# Revisa tu comprensión del material del curso

### 1. En que unidades se mide la frecuencia de muestreo?

<Question
	choices={[
		{
			text: "dB",
			explain: "No, la amplitud es medida en decibeles (dB)."
		},
		{
			text: "Hz",
			explain: "La frecuencia de muestreo es el número de muestras tomadas en un segundo y se mide en hertzios (Hz).",
			correct: true
		},
		{
			text: "bit",
			explain: "Los bits se utilizan para describir la profundidad de bits, que se refiere al número de bits de información utilizados para representar cada muestra de una señal de audio.",
		}
	]}
/>

### 2. Cuando haces streaming de una gran base de datos, ¿Qué tan pronto puedes empezar a usarla?

<Question
	choices={[
		{
			text: "Tan pronto como se haya descargado el conjunto de datos completo.",
			explain: "El objetivo de la funcionalidad de streaming es poder trabajar con ellos sin necesidad de descargar por completo un conjunto de datos"
		},
		{
			text: "Tan pronto como los primeros 16 primeros ejemplos esten descargados",
			explain: "¡Intenta de nuevo!"
		},
		{
			text: "Tan pronto como el primer ejemplo este descargado",
			explain: "",
			correct: true
		}
	]}
/>

### 3. ¿Qué es un espectrograma?

<Question
	choices={[
		{
			text: "Un dispositivo utilizado para digitalizar el audio que es capturado primero por un micrófono, el cual convierte las ondas sonoras en una señal eléctrica.",
			explain: "Un dispositivo utilizado para digitalizar se llama Conversor Análogo digital(ADC). ¡Intenta de nuevo!"
		},
		{
			text: "Un gráfico que muestra cómo la amplitud de una señal de audio cambia a lo largo del tiempo. También se conoce como la representación en el dominio del tiempo del sonido.",
			explain: "Esta descripción hace referencia a la forma de onda, no a los espectrogramas."
		},
		{
			text: "Una representación visual del espectro de frecuencia de la señal que varia con el tiempo.",
			explain: "",
			correct: true
		}
	]}
/>

### 4. ¿Cúal es la forma más fácil de convertir una señal de audio en el espectro logarítmico de mel esperado por Whisper?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()` crea un espectrograma de potencia."
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "Datasets no prepara las características para los modelos de Transformer, esto lo hace el preprocesador del modelo."
		}
	]}
/>

### 5.¿Cómo cargas un dataset desde el 🤗 Hub?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "La mejor forma es usar la libreria 🤗 Datasets.",
			correct: true
		},
		{
			text: "B",
			explain: "Librosa.load es util para cargar archivos indiduales de audio desde una ruta del sistema y retornar una tupla de la señal y la frecuencia de muestreo, pero no para un conjunto de datos extenso con muchas caracteristicas y metadata",
		},
		{
			text: "C",
			explain: "load_dataset method comes in the 🤗 Datasets library, not in 🤗 Transformers."
		}
	]}
/>

### 6. Tu conjunto de datos contiene audios de alta calidad con una frecuencia de muestreo de 32 kHz. Quieres entrenar un modelo de reconocimiento de voz que espera muestras de audio de 16kHz. ¿Qué debes hacer?

<Question
	choices={[
		{
			text: "Usar el ejemplo como está, el modelo se adaptará facilmente a ejemplos con frecuencias muestreo más altas",
			explain: "Debido a los mecanismos de atención, es complejo que los modelos puedan generalizar entre frecuencias de muestreo."
		},
		{
			text: "Usar el modulo Audio de la libreria 🤗 Datasets para hacer hacer downsampling de los ejemplos del conjunto de datos",
			explain: "",
			correct: true
		},
		{
			text: "Disminuir la frecuencia de muestreo en un factor de 2x al descartar las muestras intermedias",
			explain: "Esto crearía distorsiones en la señal llamadas aliasing. Resamplear de una forma correcta es complicado y es mejor dejarlo en manos de bibliotecas bien probadas como librosa o 🤗 Datasets"
		}
	]}
/>

### 7. ¿Cómo se puede convertir un espectrograma generado por un modelo de machine learning en una forma de onda? 

<Question
	choices={[
		{
			text: "Podemos usar una red neuronal llamada vocoder para reconstruir la forma de onda a partir del espectrograma.",
			explain: "Dado que la información de fase falta, necesitamos usar un vocoder o el algoritmo clásico Griffin-Lim para reconstruir la forma de onda.",
			correct: true
		},
		{
			text: "Se puede usar la transforma inversa de ls STFT para convertir el espectrograma en una forma de onda.",
			explain: "Un espectrograma generado carece de información de fase que es necesaria para utilizar la transformada inversa de Fourier de tiempo corto (inverse STFT)."
		},
		{
			text: "No se puede convertir un espectrograma generado por un modelo de aprendizaje automático en una forma de onda.",
			explain: "!Intenta de nuevo!"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/es/chapter1/quiz.mdx" />