import{s as ls,n as ss,o as es}from"../chunks/scheduler.b108d059.js";import{S as ts,i as as,g as i,s as a,r as M,A as ns,h as o,f as e,c as n,j as Kl,u as m,x as r,k as Ol,y as is,a as t,v as p,d as u,t as c,w as y}from"../chunks/index.008de539.js";import{C as kl}from"../chunks/CodeBlock.3968c746.js";import{H as w,E as os}from"../chunks/EditOnGithub.d1c48e3d.js";function rs(Wl){let j,D,H,K,U,O,b,xl="This page explains how scores are normalized on the Open LLM Leaderboard for the six presented benchmarks. We can categorize all tasks into those with subtasks, those without subtasks, and generative evaluation.",ll,h,sl,d,Gl="Normalization is the process of adjusting values measured on different scales to a common scale, making it possible to compare scores across different tasks. For the Open LLM Leaderboard, we normalize scores to:",el,J,El="<li>Account for the varying difficulty and random guess baselines of different tasks.</li> <li>Provide a consistent scale (0-100) for all tasks, enabling fair comparisons.</li> <li>Ensure that improvements over random guessing are appropriately reflected in the scores.</li>",tl,T,al,f,Sl="The basic normalization process involves two steps:",nl,C,Nl="<li>Subtracting the random baseline score (lower bound).</li> <li>Scaling the result to a range of 0-100.</li>",il,v,Zl="We use the following normalization function:",ol,z,rl,I,Ml,_,Bl="For tasks without subtasks (e.g., GPQA, MMLU-PRO), the normalization process is straightforward:",ml,g,Xl="<li>Determine the lower bound (random guess baseline).</li> <li>Apply the normalization function.</li> <li>Scale to a percentage.</li>",pl,A,ul,$,Ql="GPQA has 4 <code>num_choices</code>, so the lower bound is 0.25 (1/<code>num_choices</code> = 1/4 = 0.25).",cl,k,yl,W,jl,x,Yl="For tasks with subtasks (e.g., MUSR, BBH), we follow these steps:",wl,G,Vl="<li>Calculate the lower bound for each subtask.</li> <li>Normalize each subtask score.</li> <li>Average the normalized subtask scores.</li>",Ul,E,bl,S,Fl=`MUSR has three subtasks with different numbers of choices:
| Subtask               | Choices | Lower Bound |
|-----------------------|---------|-------------|
| MUSR murder mysteries | 2       | 0.5         |
| MUSR object placement | 5       | 0.2         |
| MUSR team allocation  | 3       | 0.333       |`,hl,N,dl,Z,Jl,B,ql="Generative evaluations like MATH and IFEval require a different approach:",Tl,X,Rl="<li><strong>MATH:</strong> Uses exact match accuracy. The lower bound is effectively 0, as random guessing is unlikely to produce a correct answer.</li> <li>IFEval:<ul><li>For instance-level evaluation (<code>ifeval_inst</code>), we use strict accuracy.</li> <li>For prompt-level evaluation (<code>ifeval_prompt</code>), we also use strict accuracy.</li> <li>The lower bound for both is 0, as random generation is unlikely to produce correct answers.</li></ul></li>",fl,Q,Ll="For these tasks, the normalization process in the code is as follows:",Cl,Y,vl,V,Hl="This approach ensures that even for generative tasks, we can provide normalized scores that are comparable across different evaluations.",zl,F,Il,q,Pl='For more detailed information and examples, please refer to our <a href="https://huggingface.co/spaces/open-llm-leaderboard/blog" rel="nofollow">blog post</a> on scores normalization.',_l,R,Dl='If you have any questions or need clarification, please start a new discussion on <a href="https://huggingface.co/spaces/open-llm-leaderboard/open_llm_leaderboard/discussions" rel="nofollow">the Leaderboard page</a>.',gl,L,Al,P,$l;return U=new w({props:{title:"Scores Normalization",local:"scores-normalization",headingTag:"h1"}}),h=new w({props:{title:"What is Normalization?",local:"what-is-normalization",headingTag:"h2"}}),T=new w({props:{title:"General Normalization Process",local:"general-normalization-process",headingTag:"h2"}}),z=new kl({props:{code:"ZGVmJTIwbm9ybWFsaXplX3dpdGhpbl9yYW5nZSh2YWx1ZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCh2YWx1ZSUyMC0lMjBsb3dlcl9ib3VuZCklMjAlMkYlMjAoaGlnaGVyX2JvdW5kJTIwLSUyMGxvd2VyX2JvdW5kKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">normalize_within_range</span>(<span class="hljs-params">value, lower_bound, higher_bound</span>):
    <span class="hljs-keyword">return</span> (value - lower_bound) / (higher_bound - lower_bound)`,wrap:!1}}),I=new w({props:{title:"Normalizing Tasks without Subtasks",local:"normalizing-tasks-without-subtasks",headingTag:"h2"}}),A=new w({props:{title:"Example: Normalizing GPQA Scores",local:"example-normalizing-gpqa-scores",headingTag:"h3"}}),k=new kl({props:{code:"cmF3X3Njb3JlJTIwJTNEJTIwMC42JTIwJTIwJTIzJTIwRXhhbXBsZSUyMHJhdyUyMHNjb3JlJTBBbG93ZXJfYm91bmQlMjAlM0QlMjAwLjI1JTBBaGlnaGVyX2JvdW5kJTIwJTNEJTIwMS4wJTBBJTBBaWYlMjByYXdfc2NvcmUlMjAlM0MlMjBsb3dlcl9ib3VuZCUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjAwJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjBub3JtYWxpemVfd2l0aGluX3JhbmdlKHJhd19zY29yZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUyMColMjAxMDAlMEElMEFwcmludChmJTIyTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMCU3Qm5vcm1hbGl6ZWRfc2NvcmUlM0EuMmYlN0QlMjIpJTBBJTIzJTIwT3V0cHV0JTNBJTIwTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMDQ2LjY3",highlighted:`raw_score = <span class="hljs-number">0.6</span>  <span class="hljs-comment"># Example raw score</span>
lower_bound = <span class="hljs-number">0.25</span>
higher_bound = <span class="hljs-number">1.0</span>

<span class="hljs-keyword">if</span> raw_score &lt; lower_bound:
    normalized_score = <span class="hljs-number">0</span>
<span class="hljs-keyword">else</span>:
    normalized_score = normalize_within_range(raw_score, lower_bound, higher_bound) * <span class="hljs-number">100</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Normalized GPQA score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-comment"># Output: Normalized GPQA score: 46.67</span>`,wrap:!1}}),W=new w({props:{title:"Normalizing Tasks with Subtasks",local:"normalizing-tasks-with-subtasks",headingTag:"h2"}}),E=new w({props:{title:"Example: Normalizing MUSR Scores",local:"example-normalizing-musr-scores",headingTag:"h3"}}),N=new kl({props:{code:"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",highlighted:`subtasks = [
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;murder_mysteries&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.5</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;object_placement&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.4</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.2</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;team_allocation&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.6</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.333</span>}
]

normalized_scores = []

<span class="hljs-keyword">for</span> subtask <span class="hljs-keyword">in</span> subtasks:
    <span class="hljs-keyword">if</span> subtask[<span class="hljs-string">&quot;raw_score&quot;</span>] &lt; subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>]:
        normalized_score = <span class="hljs-number">0</span>
    <span class="hljs-keyword">else</span>:
        normalized_score = normalize_within_range(
            subtask[<span class="hljs-string">&quot;raw_score&quot;</span>], 
            subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>], 
            <span class="hljs-number">1.0</span>
        ) * <span class="hljs-number">100</span>
    normalized_scores.append(normalized_score)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{subtask[<span class="hljs-string">&#x27;name&#x27;</span>]}</span> normalized score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

overall_normalized_score = <span class="hljs-built_in">sum</span>(normalized_scores) / <span class="hljs-built_in">len</span>(normalized_scores)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Overall normalized MUSR score: <span class="hljs-subst">{overall_normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># murder_mysteries normalized score: 40.00</span>
<span class="hljs-comment"># object_placement normalized score: 25.00</span>
<span class="hljs-comment"># team_allocation normalized score: 40.00</span>
<span class="hljs-comment"># Overall normalized MUSR score: 35.00</span>`,wrap:!1}}),Z=new w({props:{title:"Generative Evaluations",local:"generative-evaluations",headingTag:"h2"}}),Y=new kl({props:{code:"Zm9yJTIwc3VidGFzayUyMGluJTIwc3VidGFza3MlM0ElMEElMjAlMjAlMjAlMjBzdWJ0YXNrX3ZhbCUyMCUzRCUyMHN1YnRhc2sudmFsdWUlMEElMjAlMjAlMjAlMjB2YWx1ZSUyMCUzRCUyMGRhdGElNUIlMjJyZXN1bHRzJTIyJTVEJTVCc3VidGFza192YWwuYmVuY2htYXJrJTVEJTVCc3VidGFza192YWwubWV0cmljJTVEJTBBJTIwJTIwJTIwJTIwaGlnaGVyX2JvdW5kJTIwJTNEJTIwMSUwQSUyMCUyMCUyMCUyMGxvd2VyX2JvdW5kJTIwJTNEJTIwaGlnaGVyX2JvdW5kJTIwJTJGJTIwc3VidGFza192YWwubnVtX2Nob2ljZXMlMjBpZiUyMHN1YnRhc2tfdmFsLm51bV9jaG9pY2VzJTIwJTNFJTIwMCUyMGVsc2UlMjAwJTBBJTIwJTIwJTIwJTIwaWYlMjB2YWx1ZSUyMCUzQyUyMGxvd2VyX2JvdW5kJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplZF9zY29yZSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplZF9zY29yZSUyMCUzRCUyMG5vcm1hbGl6ZV93aXRoaW5fcmFuZ2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmFsdWUlM0R2YWx1ZSUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvd2VyX2JvdW5kJTNEbG93ZXJfYm91bmQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoaWdoZXJfYm91bmQlM0RoaWdoZXJfYm91bmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwbm9ybWFsaXplZF9zY29yZXMuYXBwZW5kKG5vcm1hbGl6ZWRfc2NvcmUlMjAqJTIwMTAwKQ==",highlighted:`<span class="hljs-keyword">for</span> subtask <span class="hljs-keyword">in</span> subtasks:
    subtask_val = subtask.value
    value = data[<span class="hljs-string">&quot;results&quot;</span>][subtask_val.benchmark][subtask_val.metric]
    higher_bound = <span class="hljs-number">1</span>
    lower_bound = higher_bound / subtask_val.num_choices <span class="hljs-keyword">if</span> subtask_val.num_choices &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0</span>
    <span class="hljs-keyword">if</span> value &lt; lower_bound:
        normalized_score = <span class="hljs-number">0</span>
    <span class="hljs-keyword">else</span>:
        normalized_score = normalize_within_range(
            value=value, 
            lower_bound=lower_bound,
            higher_bound=higher_bound
        )
    normalized_scores.append(normalized_score * <span class="hljs-number">100</span>)`,wrap:!1}}),F=new w({props:{title:"Further Information",local:"further-information",headingTag:"h2"}}),L=new os({props:{source:"https://github.com/huggingface/leaderboards/blob/main/docs/source/en/open_llm_leaderboard/normalization.md"}}),{c(){j=i("meta"),D=a(),H=i("p"),K=a(),M(U.$$.fragment),O=a(),b=i("p"),b.textContent=xl,ll=a(),M(h.$$.fragment),sl=a(),d=i("p"),d.textContent=Gl,el=a(),J=i("ol"),J.innerHTML=El,tl=a(),M(T.$$.fragment),al=a(),f=i("p"),f.textContent=Sl,nl=a(),C=i("ol"),C.innerHTML=Nl,il=a(),v=i("p"),v.textContent=Zl,ol=a(),M(z.$$.fragment),rl=a(),M(I.$$.fragment),Ml=a(),_=i("p"),_.textContent=Bl,ml=a(),g=i("ul"),g.innerHTML=Xl,pl=a(),M(A.$$.fragment),ul=a(),$=i("p"),$.innerHTML=Ql,cl=a(),M(k.$$.fragment),yl=a(),M(W.$$.fragment),jl=a(),x=i("p"),x.textContent=Yl,wl=a(),G=i("ul"),G.innerHTML=Vl,Ul=a(),M(E.$$.fragment),bl=a(),S=i("p"),S.textContent=Fl,hl=a(),M(N.$$.fragment),dl=a(),M(Z.$$.fragment),Jl=a(),B=i("p"),B.textContent=ql,Tl=a(),X=i("ol"),X.innerHTML=Rl,fl=a(),Q=i("p"),Q.textContent=Ll,Cl=a(),M(Y.$$.fragment),vl=a(),V=i("p"),V.textContent=Hl,zl=a(),M(F.$$.fragment),Il=a(),q=i("p"),q.innerHTML=Pl,_l=a(),R=i("p"),R.innerHTML=Dl,gl=a(),M(L.$$.fragment),Al=a(),P=i("p"),this.h()},l(l){const s=ns("svelte-u9bgzb",document.head);j=o(s,"META",{name:!0,content:!0}),s.forEach(e),D=n(l),H=o(l,"P",{}),Kl(H).forEach(e),K=n(l),m(U.$$.fragment,l),O=n(l),b=o(l,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1o7378m"&&(b.textContent=xl),ll=n(l),m(h.$$.fragment,l),sl=n(l),d=o(l,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1g21ee8"&&(d.textContent=Gl),el=n(l),J=o(l,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-zj6h40"&&(J.innerHTML=El),tl=n(l),m(T.$$.fragment,l),al=n(l),f=o(l,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1homifm"&&(f.textContent=Sl),nl=n(l),C=o(l,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-1noqtti"&&(C.innerHTML=Nl),il=n(l),v=o(l,"P",{"data-svelte-h":!0}),r(v)!=="svelte-uv3qwg"&&(v.textContent=Zl),ol=n(l),m(z.$$.fragment,l),rl=n(l),m(I.$$.fragment,l),Ml=n(l),_=o(l,"P",{"data-svelte-h":!0}),r(_)!=="svelte-ukmwwm"&&(_.textContent=Bl),ml=n(l),g=o(l,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-199eldc"&&(g.innerHTML=Xl),pl=n(l),m(A.$$.fragment,l),ul=n(l),$=o(l,"P",{"data-svelte-h":!0}),r($)!=="svelte-1n8wkts"&&($.innerHTML=Ql),cl=n(l),m(k.$$.fragment,l),yl=n(l),m(W.$$.fragment,l),jl=n(l),x=o(l,"P",{"data-svelte-h":!0}),r(x)!=="svelte-3f8l62"&&(x.textContent=Yl),wl=n(l),G=o(l,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-cnj190"&&(G.innerHTML=Vl),Ul=n(l),m(E.$$.fragment,l),bl=n(l),S=o(l,"P",{"data-svelte-h":!0}),r(S)!=="svelte-87ma4q"&&(S.textContent=Fl),hl=n(l),m(N.$$.fragment,l),dl=n(l),m(Z.$$.fragment,l),Jl=n(l),B=o(l,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1yp6rl7"&&(B.textContent=ql),Tl=n(l),X=o(l,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-pge6eo"&&(X.innerHTML=Rl),fl=n(l),Q=o(l,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1lm3jm4"&&(Q.textContent=Ll),Cl=n(l),m(Y.$$.fragment,l),vl=n(l),V=o(l,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1k8dio0"&&(V.textContent=Hl),zl=n(l),m(F.$$.fragment,l),Il=n(l),q=o(l,"P",{"data-svelte-h":!0}),r(q)!=="svelte-12yyx1q"&&(q.innerHTML=Pl),_l=n(l),R=o(l,"P",{"data-svelte-h":!0}),r(R)!=="svelte-n94pcj"&&(R.innerHTML=Dl),gl=n(l),m(L.$$.fragment,l),Al=n(l),P=o(l,"P",{}),Kl(P).forEach(e),this.h()},h(){Ol(j,"name","hf:doc:metadata"),Ol(j,"content",Ms)},m(l,s){is(document.head,j),t(l,D,s),t(l,H,s),t(l,K,s),p(U,l,s),t(l,O,s),t(l,b,s),t(l,ll,s),p(h,l,s),t(l,sl,s),t(l,d,s),t(l,el,s),t(l,J,s),t(l,tl,s),p(T,l,s),t(l,al,s),t(l,f,s),t(l,nl,s),t(l,C,s),t(l,il,s),t(l,v,s),t(l,ol,s),p(z,l,s),t(l,rl,s),p(I,l,s),t(l,Ml,s),t(l,_,s),t(l,ml,s),t(l,g,s),t(l,pl,s),p(A,l,s),t(l,ul,s),t(l,$,s),t(l,cl,s),p(k,l,s),t(l,yl,s),p(W,l,s),t(l,jl,s),t(l,x,s),t(l,wl,s),t(l,G,s),t(l,Ul,s),p(E,l,s),t(l,bl,s),t(l,S,s),t(l,hl,s),p(N,l,s),t(l,dl,s),p(Z,l,s),t(l,Jl,s),t(l,B,s),t(l,Tl,s),t(l,X,s),t(l,fl,s),t(l,Q,s),t(l,Cl,s),p(Y,l,s),t(l,vl,s),t(l,V,s),t(l,zl,s),p(F,l,s),t(l,Il,s),t(l,q,s),t(l,_l,s),t(l,R,s),t(l,gl,s),p(L,l,s),t(l,Al,s),t(l,P,s),$l=!0},p:ss,i(l){$l||(u(U.$$.fragment,l),u(h.$$.fragment,l),u(T.$$.fragment,l),u(z.$$.fragment,l),u(I.$$.fragment,l),u(A.$$.fragment,l),u(k.$$.fragment,l),u(W.$$.fragment,l),u(E.$$.fragment,l),u(N.$$.fragment,l),u(Z.$$.fragment,l),u(Y.$$.fragment,l),u(F.$$.fragment,l),u(L.$$.fragment,l),$l=!0)},o(l){c(U.$$.fragment,l),c(h.$$.fragment,l),c(T.$$.fragment,l),c(z.$$.fragment,l),c(I.$$.fragment,l),c(A.$$.fragment,l),c(k.$$.fragment,l),c(W.$$.fragment,l),c(E.$$.fragment,l),c(N.$$.fragment,l),c(Z.$$.fragment,l),c(Y.$$.fragment,l),c(F.$$.fragment,l),c(L.$$.fragment,l),$l=!1},d(l){l&&(e(D),e(H),e(K),e(O),e(b),e(ll),e(sl),e(d),e(el),e(J),e(tl),e(al),e(f),e(nl),e(C),e(il),e(v),e(ol),e(rl),e(Ml),e(_),e(ml),e(g),e(pl),e(ul),e($),e(cl),e(yl),e(jl),e(x),e(wl),e(G),e(Ul),e(bl),e(S),e(hl),e(dl),e(Jl),e(B),e(Tl),e(X),e(fl),e(Q),e(Cl),e(vl),e(V),e(zl),e(Il),e(q),e(_l),e(R),e(gl),e(Al),e(P)),e(j),y(U,l),y(h,l),y(T,l),y(z,l),y(I,l),y(A,l),y(k,l),y(W,l),y(E,l),y(N,l),y(Z,l),y(Y,l),y(F,l),y(L,l)}}}const Ms='{"title":"Scores Normalization","local":"scores-normalization","sections":[{"title":"What is Normalization?","local":"what-is-normalization","sections":[],"depth":2},{"title":"General Normalization Process","local":"general-normalization-process","sections":[],"depth":2},{"title":"Normalizing Tasks without Subtasks","local":"normalizing-tasks-without-subtasks","sections":[{"title":"Example: Normalizing GPQA Scores","local":"example-normalizing-gpqa-scores","sections":[],"depth":3}],"depth":2},{"title":"Normalizing Tasks with Subtasks","local":"normalizing-tasks-with-subtasks","sections":[{"title":"Example: Normalizing MUSR Scores","local":"example-normalizing-musr-scores","sections":[],"depth":3}],"depth":2},{"title":"Generative Evaluations","local":"generative-evaluations","sections":[],"depth":2},{"title":"Further Information","local":"further-information","sections":[],"depth":2}],"depth":1}';function ms(Wl){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends ts{constructor(j){super(),as(this,j,ms,rs,ls,{})}}export{js as component};
