import{s as Jt,n as Zt,o as Gt}from"../chunks/scheduler.7da89386.js";import{S as Xt,i as Wt,g as p,s as l,r as c,A as Tt,h as i,f as e,c as n,j as wt,u as r,x as o,k as Ut,y as vt,a as s,v as d,d as M,t as h,w as b}from"../chunks/index.20910acc.js";import{C as Y}from"../chunks/CodeBlock.143bd81e.js";import{H as Rt}from"../chunks/getInferenceSnippets.b7fdda57.js";function zt(ot){let m,F,_,I,u,Q,y,mt="At its core, 🤗 Optimum uses <em>configuration objects</em> to define parameters for optimization on different accelerators. These objects are then used to instantiate dedicated <em>optimizers</em>, <em>quantizers</em>, and <em>pruners</em>.",x,j,ct="Before applying quantization or optimization, we first need to export our model to the ONNX format.",H,g,E,f,rt="Let’s see now how we can apply dynamic quantization with ONNX Runtime:",$,w,q,U,dt="In this example, we’ve quantized a model from the Hugging Face Hub, but it could also be a path to a local model directory. The result from applying the <code>quantize()</code> method is a <code>model_quantized.onnx</code> file that can be used to run inference. Here’s an example of how to load an ONNX Runtime model and generate predictions with it:",S,J,A,Z,Mt="Similarly, you can apply static quantization by simply setting <code>is_static</code> to <code>True</code> when instantiating the <code>QuantizationConfig</code> object:",L,G,P,X,ht='Static quantization relies on feeding batches of data through the model to estimate the activation quantization parameters ahead of inference time. To support this, 🤗 Optimum allows you to provide a <em>calibration dataset</em>. The calibration dataset can be a simple <code>Dataset</code> object from the 🤗 Datasets library, or any dataset that’s hosted on the Hugging Face Hub. For this example, we’ll pick the <a href="https://huggingface.co/datasets/glue/viewer/sst2/test" rel="nofollow"><code>sst2</code></a> dataset that the model was originally trained on:',O,W,D,T,bt="As a final example, let’s take a look at applying <em>graph optimizations</em> techniques such as operator fusion and constant folding. As before, we load a configuration object, but this time by setting the optimization level instead of the quantization approach:",K,v,tt,R,ut="Next, we load an <em>optimizer</em> to apply these optimisations to our model:",at,z,et,k,yt="And that’s it - the model is now optimized and ready for inference! As you can see, the process is similar in each case:",st,B,jt="<li>Define the optimization / quantization strategies via an <code>OptimizationConfig</code> / <code>QuantizationConfig</code> object</li> <li>Instantiate a <code>ORTQuantizer</code> or <code>ORTOptimizer</code> class</li> <li>Apply the <code>quantize()</code> or <code>optimize()</code> method</li> <li>Run inference</li>",lt,N,gt='Check out the <a href="https://github.com/huggingface/optimum/tree/main/examples" rel="nofollow"><code>examples</code></a> directory for more sophisticated usage.',nt,C,ft="Happy optimising 🤗!",pt,V,it;return u=new Rt({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),g=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIydG1wJTJGb25ueCUyRiUyMiUwQSUyMyUyMExvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyME9OTlglMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQpJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMG9ubnglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW9ydF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;tmp/onnx/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a model from transformers and export it to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(model_checkpoint, export=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the onnx model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(save_directory)`,wrap:!1}}),w=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFF1YW50aXplciUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHF1YW50aXphdGlvbiUyMG1ldGhvZG9sb2d5JTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNERmFsc2UlMkMlMjBwZXJfY2hhbm5lbCUzREZhbHNlKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob3J0X21vZGVsKSUwQSUyMyUyMEFwcGx5JTIwZHluYW1pYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the quantization methodology</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_directory, quantization_config=qconfig)`,wrap:!1}}),J=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMkMlMjBBdXRvVG9rZW5pemVyJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5JTJDJTIwZmlsZV9uYW1lJTNEJTIybW9kZWxfcXVhbnRpemVkLm9ubnglMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBY2xzX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBcmVzdWx0cyUyMCUzRCUyMGNsc19waXBlbGluZSglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_directory, file_name=<span class="hljs-string">&quot;model_quantized.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>cls_pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>results = cls_pipeline(<span class="hljs-string">&quot;I love burritos!&quot;</span>)`,wrap:!1}}),G=new Y({props:{code:"cWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNEVHJ1ZSUyQyUyMHBlcl9jaGFubmVsJTNERmFsc2Up",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">True</span>, per_channel=<span class="hljs-literal">False</span>)',wrap:!1}}),W=new Y({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZS5jb25maWd1cmF0aW9uJTIwaW1wb3J0JTIwQXV0b0NhbGlicmF0aW9uQ29uZmlnJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19mbihleCUyQyUyMHRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoZXglNUIlMjJzZW50ZW5jZSUyMiU1RCklMEElMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBjYWxpYnJhdGlvbiUyMGRhdGFzZXQlMEFjYWxpYnJhdGlvbl9kYXRhc2V0JTIwJTNEJTIwcXVhbnRpemVyLmdldF9jYWxpYnJhdGlvbl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmdsdWUlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0X2NvbmZpZ19uYW1lJTNEJTIyc3N0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lM0RwYXJ0aWFsKHByZXByb2Nlc3NfZm4lMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3NhbXBsZXMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSklMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBjYWxpYnJhdGlvbiUyMGNvbmZpZ3VyYXRpb24lMjBjb250YWluaW5nJTIwdGhlJTIwcGFyYW1ldGVycyUyMHJlbGF0ZWQlMjB0byUyMGNhbGlicmF0aW9uLiUwQWNhbGlicmF0aW9uX2NvbmZpZyUyMCUzRCUyMEF1dG9DYWxpYnJhdGlvbkNvbmZpZy5taW5tYXgoY2FsaWJyYXRpb25fZGF0YXNldCklMEElMjMlMjBQZXJmb3JtJTIwdGhlJTIwY2FsaWJyYXRpb24lMjBzdGVwJTNBJTIwY29tcHV0ZXMlMjB0aGUlMjBhY3RpdmF0aW9ucyUyMHF1YW50aXphdGlvbiUyMHJhbmdlcyUwQXJhbmdlcyUyMCUzRCUyMHF1YW50aXplci5maXQoJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUzRGNhbGlicmF0aW9uX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxpYnJhdGlvbl9jb25maWclM0RjYWxpYnJhdGlvbl9jb25maWclMkMlMEElMjAlMjAlMjAlMjBvcGVyYXRvcnNfdG9fcXVhbnRpemUlM0RxY29uZmlnLm9wZXJhdG9yc190b19xdWFudGl6ZSUyQyUwQSklMEElMjMlMjBBcHBseSUyMHN0YXRpYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUwQSUyMCUyMCUyMCUyMGNhbGlicmF0aW9uX3RlbnNvcnNfcmFuZ2UlM0RyYW5nZXMlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcWNvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoCalibrationConfig

<span class="hljs-comment"># Define the processing function to apply to each example after loading the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_fn</span>(<span class="hljs-params">ex, tokenizer</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(ex[<span class="hljs-string">&quot;sentence&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the calibration dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_dataset = quantizer.get_calibration_dataset(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;glue&quot;</span>,
<span class="hljs-meta">... </span>    dataset_config_name=<span class="hljs-string">&quot;sst2&quot;</span>,
<span class="hljs-meta">... </span>    preprocess_function=partial(preprocess_fn, tokenizer=tokenizer),
<span class="hljs-meta">... </span>    num_samples=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the calibration configuration containing the parameters related to calibration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_config = AutoCalibrationConfig.minmax(calibration_dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform the calibration step: computes the activations quantization ranges</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ranges = quantizer.fit(
<span class="hljs-meta">... </span>    dataset=calibration_dataset,
<span class="hljs-meta">... </span>    calibration_config=calibration_config,
<span class="hljs-meta">... </span>    operators_to_quantize=qconfig.operators_to_quantize,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply static quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(
<span class="hljs-meta">... </span>    save_dir=save_directory,
<span class="hljs-meta">... </span>    calibration_tensors_range=ranges,
<span class="hljs-meta">... </span>    quantization_config=qconfig,
<span class="hljs-meta">... </span>)`,wrap:!1}}),v=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyME9wdGltaXphdGlvbkNvbmZpZyUwQSUwQSUyMyUyMEhlcmUlMjB0aGUlMjBvcHRpbWl6YXRpb24lMjBsZXZlbCUyMGlzJTIwc2VsZWN0ZWQlMjB0byUyMGJlJTIwMSUyQyUyMGVuYWJsaW5nJTIwYmFzaWMlMjBvcHRpbWl6YXRpb25zJTIwc3VjaCUyMGFzJTIwcmVkdW5kYW50JTIwbm9kZSUyMGVsaW1pbmF0aW9ucyUyMGFuZCUyMGNvbnN0YW50JTIwZm9sZGluZy4lMjBIaWdoZXIlMjBvcHRpbWl6YXRpb24lMjBsZXZlbCUyMHdpbGwlMjByZXN1bHQlMjBpbiUyMGElMjBoYXJkd2FyZSUyMGRlcGVuZGVudCUyMG9wdGltaXplZCUyMGdyYXBoLiUwQW9wdGltaXphdGlvbl9jb25maWclMjAlM0QlMjBPcHRpbWl6YXRpb25Db25maWcob3B0aW1pemF0aW9uX2xldmVsJTNEMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> OptimizationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Here the optimization level is selected to be 1, enabling basic optimizations such as redundant node eliminations and constant folding. Higher optimization level will result in a hardware dependent optimized graph.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = OptimizationConfig(optimization_level=<span class="hljs-number">1</span>)`,wrap:!1}}),z=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRPcHRpbWl6ZXIlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBPUlRPcHRpbWl6ZXIuZnJvbV9wcmV0cmFpbmVkKG9ydF9tb2RlbCklMEElMEElMjMlMjBPcHRpbWl6ZSUyMHRoZSUyMG1vZGVsJTBBb3B0aW1pemVyLm9wdGltaXplKHNhdmVfZGlyJTNEc2F2ZV9kaXJlY3RvcnklMkMlMjBvcHRpbWl6YXRpb25fY29uZmlnJTNEb3B0aW1pemF0aW9uX2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTOptimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(ort_model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Optimize the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.optimize(save_dir=save_directory, optimization_config=optimization_config)`,wrap:!1}}),{c(){m=p("meta"),F=l(),_=p("p"),I=l(),c(u.$$.fragment),Q=l(),y=p("p"),y.innerHTML=mt,x=l(),j=p("p"),j.textContent=ct,H=l(),c(g.$$.fragment),E=l(),f=p("p"),f.textContent=rt,$=l(),c(w.$$.fragment),q=l(),U=p("p"),U.innerHTML=dt,S=l(),c(J.$$.fragment),A=l(),Z=p("p"),Z.innerHTML=Mt,L=l(),c(G.$$.fragment),P=l(),X=p("p"),X.innerHTML=ht,O=l(),c(W.$$.fragment),D=l(),T=p("p"),T.innerHTML=bt,K=l(),c(v.$$.fragment),tt=l(),R=p("p"),R.innerHTML=ut,at=l(),c(z.$$.fragment),et=l(),k=p("p"),k.textContent=yt,st=l(),B=p("ol"),B.innerHTML=jt,lt=l(),N=p("p"),N.innerHTML=gt,nt=l(),C=p("p"),C.textContent=ft,pt=l(),V=p("p"),this.h()},l(t){const a=Tt("svelte-u9bgzb",document.head);m=i(a,"META",{name:!0,content:!0}),a.forEach(e),F=n(t),_=i(t,"P",{}),wt(_).forEach(e),I=n(t),r(u.$$.fragment,t),Q=n(t),y=i(t,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1vlvz9n"&&(y.innerHTML=mt),x=n(t),j=i(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1kzojza"&&(j.textContent=ct),H=n(t),r(g.$$.fragment,t),E=n(t),f=i(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-e7rpqh"&&(f.textContent=rt),$=n(t),r(w.$$.fragment,t),q=n(t),U=i(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-o28jdo"&&(U.innerHTML=dt),S=n(t),r(J.$$.fragment,t),A=n(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-o27pzy"&&(Z.innerHTML=Mt),L=n(t),r(G.$$.fragment,t),P=n(t),X=i(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-sm0oyj"&&(X.innerHTML=ht),O=n(t),r(W.$$.fragment,t),D=n(t),T=i(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-9hlkfw"&&(T.innerHTML=bt),K=n(t),r(v.$$.fragment,t),tt=n(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-xtipap"&&(R.innerHTML=ut),at=n(t),r(z.$$.fragment,t),et=n(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-8fcqft"&&(k.textContent=yt),st=n(t),B=i(t,"OL",{"data-svelte-h":!0}),o(B)!=="svelte-114qv5k"&&(B.innerHTML=jt),lt=n(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-ka9cob"&&(N.innerHTML=gt),nt=n(t),C=i(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1u3x3lz"&&(C.textContent=ft),pt=n(t),V=i(t,"P",{}),wt(V).forEach(e),this.h()},h(){Ut(m,"name","hf:doc:metadata"),Ut(m,"content",kt)},m(t,a){vt(document.head,m),s(t,F,a),s(t,_,a),s(t,I,a),d(u,t,a),s(t,Q,a),s(t,y,a),s(t,x,a),s(t,j,a),s(t,H,a),d(g,t,a),s(t,E,a),s(t,f,a),s(t,$,a),d(w,t,a),s(t,q,a),s(t,U,a),s(t,S,a),d(J,t,a),s(t,A,a),s(t,Z,a),s(t,L,a),d(G,t,a),s(t,P,a),s(t,X,a),s(t,O,a),d(W,t,a),s(t,D,a),s(t,T,a),s(t,K,a),d(v,t,a),s(t,tt,a),s(t,R,a),s(t,at,a),d(z,t,a),s(t,et,a),s(t,k,a),s(t,st,a),s(t,B,a),s(t,lt,a),s(t,N,a),s(t,nt,a),s(t,C,a),s(t,pt,a),s(t,V,a),it=!0},p:Zt,i(t){it||(M(u.$$.fragment,t),M(g.$$.fragment,t),M(w.$$.fragment,t),M(J.$$.fragment,t),M(G.$$.fragment,t),M(W.$$.fragment,t),M(v.$$.fragment,t),M(z.$$.fragment,t),it=!0)},o(t){h(u.$$.fragment,t),h(g.$$.fragment,t),h(w.$$.fragment,t),h(J.$$.fragment,t),h(G.$$.fragment,t),h(W.$$.fragment,t),h(v.$$.fragment,t),h(z.$$.fragment,t),it=!1},d(t){t&&(e(F),e(_),e(I),e(Q),e(y),e(x),e(j),e(H),e(E),e(f),e($),e(q),e(U),e(S),e(A),e(Z),e(L),e(P),e(X),e(O),e(D),e(T),e(K),e(tt),e(R),e(at),e(et),e(k),e(st),e(B),e(lt),e(N),e(nt),e(C),e(pt),e(V)),e(m),b(u,t),b(g,t),b(w,t),b(J,t),b(G,t),b(W,t),b(v,t),b(z,t)}}}const kt='{"title":"Quickstart","local":"quickstart","sections":[],"depth":1}';function Bt(ot){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Xt{constructor(m){super(),Wt(this,m,Bt,zt,Jt,{})}}export{Vt as component};
