import{s as wt,f as Tt,o as yt,n as Be}from"../chunks/scheduler.9bc65507.js";import{S as xt,i as Mt,g as l,s as n,r as p,A as $t,h as c,f as t,c as r,j as C,u as h,x as D,k as y,y as d,a,v as u,d as g,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as vt}from"../chunks/Tip.c2ecdbf4.js";import{D as q}from"../chunks/Docstring.86474e80.js";import{C as So}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ho}from"../chunks/ExampleCodeBlock.034f3a73.js";import{P as jt}from"../chunks/PipelineTag.44585822.js";import{H as R,E as Ct}from"../chunks/EditOnGithub.922df6ba.js";function zt(z){let s,w="Examples:",m,f,v;return f=new So({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZm9ybWFibGVEZXRyQ29uZmlnJTJDJTIwRGVmb3JtYWJsZURldHJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBEZWZvcm1hYmxlJTIwREVUUiUyMFNlbnNlVGltZSUyRmRlZm9ybWFibGUtZGV0ciUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEZWZvcm1hYmxlRGV0ckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBTZW5zZVRpbWUlMkZkZWZvcm1hYmxlLWRldHIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMERlZm9ybWFibGVEZXRyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DeformableDetrConfig, DeformableDetrModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Deformable DETR SenseTime/deformable-detr style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DeformableDetrConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the SenseTime/deformable-detr style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeformableDetrModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=n(),p(f.$$.fragment)},l(i){s=c(i,"P",{"data-svelte-h":!0}),D(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(i),h(f.$$.fragment,i)},m(i,T){a(i,s,T),a(i,m,T),u(f,i,T),v=!0},p:Be,i(i){v||(g(f.$$.fragment,i),v=!0)},o(i){_(f.$$.fragment,i),v=!1},d(i){i&&(t(s),t(m)),b(f,i)}}}function kt(z){let s,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=w},l(m){s=c(m,"P",{"data-svelte-h":!0}),D(s)!=="svelte-fincs2"&&(s.innerHTML=w)},m(m,f){a(m,s,f)},p:Be,d(m){m&&t(s)}}}function It(z){let s,w="Examples:",m,f,v;return f=new So({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERlZm9ybWFibGVEZXRyTW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlNlbnNlVGltZSUyRmRlZm9ybWFibGUtZGV0ciUyMiklMEFtb2RlbCUyMCUzRCUyMERlZm9ybWFibGVEZXRyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlNlbnNlVGltZSUyRmRlZm9ybWFibGUtZGV0ciUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DeformableDetrModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;SenseTime/deformable-detr&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeformableDetrModel.from_pretrained(<span class="hljs-string">&quot;SenseTime/deformable-detr&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">300</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=n(),p(f.$$.fragment)},l(i){s=c(i,"P",{"data-svelte-h":!0}),D(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(i),h(f.$$.fragment,i)},m(i,T){a(i,s,T),a(i,m,T),u(f,i,T),v=!0},p:Be,i(i){v||(g(f.$$.fragment,i),v=!0)},o(i){_(f.$$.fragment,i),v=!1},d(i){i&&(t(s),t(m)),b(f,i)}}}function Ft(z){let s,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=w},l(m){s=c(m,"P",{"data-svelte-h":!0}),D(s)!=="svelte-fincs2"&&(s.innerHTML=w)},m(m,f){a(m,s,f)},p:Be,d(m){m&&t(s)}}}function Ut(z){let s,w="Examples:",m,f,v;return f=new So({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERlZm9ybWFibGVEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJTZW5zZVRpbWUlMkZkZWZvcm1hYmxlLWRldHIlMjIpJTBBbW9kZWwlMjAlM0QlMjBEZWZvcm1hYmxlRGV0ckZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyU2Vuc2VUaW1lJTJGZGVmb3JtYWJsZS1kZXRyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMFBhc2NhbCUyMFZPQyUyMGZvcm1hdCUyMCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUwQXRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBcmVzdWx0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC41JTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QiUwQSUyMCUyMCUyMCUyMDAlMEElNUQlMEFmb3IlMjBzY29yZSUyQyUyMGxhYmVsJTJDJTIwYm94JTIwaW4lMjB6aXAocmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIyYm94ZXMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDIpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRldGVjdGVkJTIwJTdCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTdEJTIwd2l0aCUyMGNvbmZpZGVuY2UlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTdCcm91bmQoc2NvcmUuaXRlbSgpJTJDJTIwMyklN0QlMjBhdCUyMGxvY2F0aW9uJTIwJTdCYm94JTdEJTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DeformableDetrForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;SenseTime/deformable-detr&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeformableDetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;SenseTime/deformable-detr&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.8</span> at location [<span class="hljs-number">16.5</span>, <span class="hljs-number">52.84</span>, <span class="hljs-number">318.25</span>, <span class="hljs-number">470.78</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.789</span> at location [<span class="hljs-number">342.19</span>, <span class="hljs-number">24.3</span>, <span class="hljs-number">640.02</span>, <span class="hljs-number">372.25</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.633</span> at location [<span class="hljs-number">40.79</span>, <span class="hljs-number">72.78</span>, <span class="hljs-number">176.76</span>, <span class="hljs-number">117.25</span>]`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=n(),p(f.$$.fragment)},l(i){s=c(i,"P",{"data-svelte-h":!0}),D(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(i),h(f.$$.fragment,i)},m(i,T){a(i,s,T),a(i,m,T),u(f,i,T),v=!0},p:Be,i(i){v||(g(f.$$.fragment,i),v=!0)},o(i){_(f.$$.fragment,i),v=!1},d(i){i&&(t(s),t(m)),b(f,i)}}}function qt(z){let s,w,m,f,v,i,T,He,Q,Ao=`変形可能 DETR モデルは、Xizhou Zhu、Weijie Su、Lewei Lu、Bin Li、Xiaogang Wang, Jifeng Dai によって <a href="https://arxiv.org/abs/2010.04159" rel="nofollow">Deformable DETR: Deformable Transformers for End-to-End Object Detection</a> で提案されました
変形可能な DETR は、参照周囲の少数の主要なサンプリング ポイントのみに注目する新しい変形可能なアテンション モジュールを利用することにより、収束の遅さの問題と元の <a href="detr">DETR</a> の制限された特徴の空間解像度を軽減します。`,Se,K,Xo="論文の要約は次のとおりです。",Ae,ee,Yo="<em>DETR は、優れたパフォーマンスを実証しながら、物体検出における多くの手作業で設計されたコンポーネントの必要性を排除するために最近提案されました。ただし、画像特徴マップの処理における Transformer アテンション モジュールの制限により、収束が遅く、特徴の空間解像度が制限されるという問題があります。これらの問題を軽減するために、私たちは Deformable DETR を提案しました。この DETR のアテンション モジュールは、参照周囲の少数の主要なサンプリング ポイントのみに注目します。変形可能な DETR は、10 分の 1 のトレーニング エポックで、DETR よりも優れたパフォーマンス (特に小さなオブジェクトの場合) を達成できます。 COCO ベンチマークに関する広範な実験により、私たちのアプローチの有効性が実証されました。</em>",Xe,Z,Qo,Ye,oe,Ko='変形可能な DETR アーキテクチャ。 <a href="https://arxiv.org/abs/2010.04159">元の論文</a>から抜粋。',Qe,te,et='このモデルは、<a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a> によって提供されました。元のコードは <a href="https://github.com/fundamentalvision/Deformable-DETR" rel="nofollow">ここ</a> にあります。',Ke,ne,eo,re,ot='<li>トレーニング Deformable DETR は、元の <a href="detr">DETR</a> モデルをトレーニングすることと同等です。デモ ノートブックについては、以下の <a href="#resources">resources</a> セクションを参照してください。</li>',oo,ae,to,se,tt="Deformable DETR の使用を開始するのに役立つ公式 Hugging Face およびコミュニティ (🌎 で示される) リソースのリスト。",no,ie,ro,de,nt='<li><a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> のカスタム データセットでの推論と微調整に関するデモ ノートブックは、<a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Deformable-DETR" rel="nofollow">こちら</a> にあります。</li> <li><a href="../tasks/object_detection">物体検出タスクガイド</a> も参照してください。</li>',ao,le,rt="ここに含めるリソースの送信に興味がある場合は、お気軽にプル リクエストを開いてください。審査させていただきます。リソースは、既存のリソースを複製するのではなく、何か新しいものを示すことが理想的です。",so,ce,io,$,me,wo,ke,at="Constructs a Deformable DETR image processor.",To,P,fe,yo,Ie,st="Preprocess an image or a batch of images so that it can be used by the model.",xo,W,pe,Mo,Fe,it=`Converts the raw output of <a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> into final bounding boxes in (top_left_x,
top_left_y, bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,lo,he,co,F,ue,$o,L,ge,jo,Ue,dt="Preprocess an image or a batch of images.",Co,O,_e,zo,qe,lt=`Converts the raw output of <a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> into final bounding boxes in (top_left_x,
top_left_y, bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,mo,be,fo,j,De,ko,Je,ct=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a>. It is used to instantiate
a Deformable DETR model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Deformable DETR
<a href="https://huggingface.co/SenseTime/deformable-detr" rel="nofollow">SenseTime/deformable-detr</a> architecture.`,Io,Ee,mt=`Configuration objects inherit from <a href="/docs/transformers/pr_30984/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30984/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fo,V,po,ve,ho,x,we,Uo,Ne,ft=`The bare Deformable DETR Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,qo,Re,pt=`This model inherits from <a href="/docs/transformers/pr_30984/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Jo,Ze,ht=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Eo,k,Te,No,Pe,ut='The <a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> forward method, overrides the <code>__call__</code> special method.',Ro,G,Zo,B,uo,ye,go,M,xe,Po,We,gt=`Deformable DETR Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on
top, for tasks such as COCO detection.`,Wo,Le,_t=`This model inherits from <a href="/docs/transformers/pr_30984/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Lo,Oe,bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Oo,I,Me,Vo,Ve,Dt='The <a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Go,H,Bo,S,_o,$e,bo,Ge,Do;return v=new R({props:{title:"Deformable DETR",local:"deformable-detr",headingTag:"h1"}}),T=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ne=new R({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ae=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ie=new jt({props:{pipeline:"object-detection"}}),ce=new R({props:{title:"DeformableDetrImageProcessor",local:"transformers.DeformableDetrImageProcessor",headingTag:"h2"}}),me=new q({props:{name:"class transformers.DeformableDetrImageProcessor",anchor:"transformers.DeformableDetrImageProcessor",parameters:[{name:"format",val:": Union = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeformableDetrImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.DeformableDetrImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.DeformableDetrImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.DeformableDetrImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.DeformableDetrImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DeformableDetrImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DeformableDetrImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DeformableDetrImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.DeformableDetrImageProcessor.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.DeformableDetrImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.DeformableDetrImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/image_processing_deformable_detr.py#L802"}}),fe=new q({props:{name:"preprocess",anchor:"transformers.DeformableDetrImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"annotations",val:": Union = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": Union = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Union = None"},{name:"do_normalize",val:": Optional = None"},{name:"do_convert_annotations",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = None"},{name:"format",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"pad_size",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeformableDetrImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code>, padding will be applied to the bottom and right of
the image with zeros. If <code>pad_size</code> is provided, the image will be padded to the specified
dimensions. Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.DeformableDetrImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/image_processing_deformable_detr.py#L1261"}}),pe=new q({props:{name:"post_process_object_detection",anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"},{name:"top_k",val:": int = 100"}],parametersDescription:[{anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
(height, width) of each image in the batch. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DeformableDetrImageProcessor.post_process_object_detection.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Keep only top k bounding boxes before filtering by thresholding.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/image_processing_deformable_detr.py#L1572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),he=new R({props:{title:"DeformableDetrFeatureExtractor",local:"transformers.DeformableDetrFeatureExtractor",headingTag:"h2"}}),ue=new q({props:{name:"class transformers.DeformableDetrFeatureExtractor",anchor:"transformers.DeformableDetrFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/feature_extraction_deformable_detr.py#L36"}}),ge=new q({props:{name:"__call__",anchor:"transformers.DeformableDetrFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/image_processing_utils.py#L39"}}),_e=new q({props:{name:"post_process_object_detection",anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": Union = None"},{name:"top_k",val:": int = 100"}],parametersDescription:[{anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
(height, width) of each image in the batch. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.DeformableDetrFeatureExtractor.post_process_object_detection.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Keep only top k bounding boxes before filtering by thresholding.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/image_processing_deformable_detr.py#L1572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),be=new R({props:{title:"DeformableDetrConfig",local:"transformers.DeformableDetrConfig",headingTag:"h2"}}),De=new q({props:{name:"class transformers.DeformableDetrConfig",anchor:"transformers.DeformableDetrConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"num_channels",val:" = 3"},{name:"num_queries",val:" = 300"},{name:"max_position_embeddings",val:" = 1024"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 1024"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 1024"},{name:"decoder_attention_heads",val:" = 8"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"return_intermediate",val:" = True"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"backbone_kwargs",val:" = None"},{name:"dilation",val:" = False"},{name:"num_feature_levels",val:" = 4"},{name:"encoder_n_points",val:" = 4"},{name:"decoder_n_points",val:" = 4"},{name:"two_stage",val:" = False"},{name:"two_stage_num_proposals",val:" = 300"},{name:"with_box_refine",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"mask_loss_coefficient",val:" = 1"},{name:"dice_loss_coefficient",val:" = 1"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"focal_alpha",val:" = 0.25"},{name:"disable_custom_kernels",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeformableDetrConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <code>AutoBackbone</code>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DeformableDetrConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.DeformableDetrConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DeformableDetrConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> can detect in a single image. In case <code>two_stage</code> is set to <code>True</code>, we use
<code>two_stage_num_proposals</code> instead.`,name:"num_queries"},{anchor:"transformers.DeformableDetrConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.DeformableDetrConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.DeformableDetrConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.DeformableDetrConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.DeformableDetrConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.DeformableDetrConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.DeformableDetrConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.DeformableDetrConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.DeformableDetrConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.DeformableDetrConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.DeformableDetrConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.DeformableDetrConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.DeformableDetrConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.DeformableDetrConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.DeformableDetrConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.DeformableDetrConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.DeformableDetrConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;resnet50&quot;</code>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DeformableDetrConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DeformableDetrConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DeformableDetrConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when
<code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.DeformableDetrConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.DeformableDetrConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.DeformableDetrConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.DeformableDetrConfig.mask_loss_coefficient",description:`<strong>mask_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the Focal loss in the panoptic segmentation loss.`,name:"mask_loss_coefficient"},{anchor:"transformers.DeformableDetrConfig.dice_loss_coefficient",description:`<strong>dice_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the DICE/F-1 loss in the panoptic segmentation loss.`,name:"dice_loss_coefficient"},{anchor:"transformers.DeformableDetrConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.DeformableDetrConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.DeformableDetrConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"},{anchor:"transformers.DeformableDetrConfig.num_feature_levels",description:`<strong>num_feature_levels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of input feature levels.`,name:"num_feature_levels"},{anchor:"transformers.DeformableDetrConfig.encoder_n_points",description:`<strong>encoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the encoder.`,name:"encoder_n_points"},{anchor:"transformers.DeformableDetrConfig.decoder_n_points",description:`<strong>decoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the decoder.`,name:"decoder_n_points"},{anchor:"transformers.DeformableDetrConfig.two_stage",description:`<strong>two_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a two-stage deformable DETR, where the region proposals are also generated by a variant of
Deformable DETR, which are further fed into the decoder for iterative bounding box refinement.`,name:"two_stage"},{anchor:"transformers.DeformableDetrConfig.two_stage_num_proposals",description:`<strong>two_stage_num_proposals</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
The number of region proposals to be generated, in case <code>two_stage</code> is set to <code>True</code>.`,name:"two_stage_num_proposals"},{anchor:"transformers.DeformableDetrConfig.with_box_refine",description:`<strong>with_box_refine</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply iterative bounding box refinement, where each decoder layer refines the bounding boxes
based on the predictions from the previous layer.`,name:"with_box_refine"},{anchor:"transformers.DeformableDetrConfig.focal_alpha",description:`<strong>focal_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Alpha parameter in the focal loss.`,name:"focal_alpha"},{anchor:"transformers.DeformableDetrConfig.disable_custom_kernels",description:`<strong>disable_custom_kernels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Disable the use of custom CUDA and CPU kernels. This option is necessary for the ONNX export, as custom
kernels are not supported by PyTorch ONNX export.`,name:"disable_custom_kernels"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/configuration_deformable_detr.py#L26"}}),V=new Ho({props:{anchor:"transformers.DeformableDetrConfig.example",$$slots:{default:[zt]},$$scope:{ctx:z}}}),ve=new R({props:{title:"DeformableDetrModel",local:"transformers.DeformableDetrModel",headingTag:"h2"}}),we=new q({props:{name:"class transformers.DeformableDetrModel",anchor:"transformers.DeformableDetrModel",parameters:[{name:"config",val:": DeformableDetrConfig"}],parametersDescription:[{anchor:"transformers.DeformableDetrModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30984/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/modeling_deformable_detr.py#L1495"}}),Te=new q({props:{name:"forward",anchor:"transformers.DeformableDetrModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DeformableDetrModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/pr_30984/ja/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30984/ja/model_doc/detr#transformers.DetrFeatureExtractor.__call__">DeformableDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DeformableDetrModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DeformableDetrModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DeformableDetrModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DeformableDetrModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DeformableDetrModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DeformableDetrModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DeformableDetrModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DeformableDetrModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30984/ja/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/modeling_deformable_detr.py#L1651",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.deformable_detr.modeling_deformable_detr.DeformableDetrModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrConfig"
>DeformableDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_queries, num_queries)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the weighted
average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.two_stage_num_proposals</code> scoring bounding boxes are
picked as region proposals in the first stage. Output of bounding box binary classification (i.e.
foreground and background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.deformable_detr.modeling_deformable_detr.DeformableDetrModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new vt({props:{$$slots:{default:[kt]},$$scope:{ctx:z}}}),B=new Ho({props:{anchor:"transformers.DeformableDetrModel.forward.example",$$slots:{default:[It]},$$scope:{ctx:z}}}),ye=new R({props:{title:"DeformableDetrForObjectDetection",local:"transformers.DeformableDetrForObjectDetection",headingTag:"h2"}}),xe=new q({props:{name:"class transformers.DeformableDetrForObjectDetection",anchor:"transformers.DeformableDetrForObjectDetection",parameters:[{name:"config",val:": DeformableDetrConfig"}],parametersDescription:[{anchor:"transformers.DeformableDetrForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30984/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/modeling_deformable_detr.py#L1851"}}),Me=new q({props:{name:"forward",anchor:"transformers.DeformableDetrForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DeformableDetrForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/pr_30984/ja/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_30984/ja/model_doc/detr#transformers.DetrFeatureExtractor.__call__">DeformableDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30984/ja/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DeformableDetrForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30984/src/transformers/models/deformable_detr/modeling_deformable_detr.py#L1912",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.deformable_detr.modeling_deformable_detr.DeformableDetrObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30984/ja/model_doc/deformable_detr#transformers.DeformableDetrConfig"
>DeformableDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>~DeformableDetrProcessor.post_process_object_detection</code> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_queries, num_queries)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the weighted
average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_heads, 4, 4)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the weighted average
in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.two_stage_num_proposals</code> scoring bounding boxes are
picked as region proposals in the first stage. Output of bounding box binary classification (i.e.
foreground and background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.deformable_detr.modeling_deformable_detr.DeformableDetrObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new vt({props:{$$slots:{default:[Ft]},$$scope:{ctx:z}}}),S=new Ho({props:{anchor:"transformers.DeformableDetrForObjectDetection.forward.example",$$slots:{default:[Ut]},$$scope:{ctx:z}}}),$e=new Ct({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/model_doc/deformable_detr.md"}}),{c(){s=l("meta"),w=n(),m=l("p"),f=n(),p(v.$$.fragment),i=n(),p(T.$$.fragment),He=n(),Q=l("p"),Q.innerHTML=Ao,Se=n(),K=l("p"),K.textContent=Xo,Ae=n(),ee=l("p"),ee.innerHTML=Yo,Xe=n(),Z=l("img"),Ye=n(),oe=l("small"),oe.innerHTML=Ko,Qe=n(),te=l("p"),te.innerHTML=et,Ke=n(),p(ne.$$.fragment),eo=n(),re=l("ul"),re.innerHTML=ot,oo=n(),p(ae.$$.fragment),to=n(),se=l("p"),se.textContent=tt,no=n(),p(ie.$$.fragment),ro=n(),de=l("ul"),de.innerHTML=nt,ao=n(),le=l("p"),le.textContent=rt,so=n(),p(ce.$$.fragment),io=n(),$=l("div"),p(me.$$.fragment),wo=n(),ke=l("p"),ke.textContent=at,To=n(),P=l("div"),p(fe.$$.fragment),yo=n(),Ie=l("p"),Ie.textContent=st,xo=n(),W=l("div"),p(pe.$$.fragment),Mo=n(),Fe=l("p"),Fe.innerHTML=it,lo=n(),p(he.$$.fragment),co=n(),F=l("div"),p(ue.$$.fragment),$o=n(),L=l("div"),p(ge.$$.fragment),jo=n(),Ue=l("p"),Ue.textContent=dt,Co=n(),O=l("div"),p(_e.$$.fragment),zo=n(),qe=l("p"),qe.innerHTML=lt,mo=n(),p(be.$$.fragment),fo=n(),j=l("div"),p(De.$$.fragment),ko=n(),Je=l("p"),Je.innerHTML=ct,Io=n(),Ee=l("p"),Ee.innerHTML=mt,Fo=n(),p(V.$$.fragment),po=n(),p(ve.$$.fragment),ho=n(),x=l("div"),p(we.$$.fragment),Uo=n(),Ne=l("p"),Ne.textContent=ft,qo=n(),Re=l("p"),Re.innerHTML=pt,Jo=n(),Ze=l("p"),Ze.innerHTML=ht,Eo=n(),k=l("div"),p(Te.$$.fragment),No=n(),Pe=l("p"),Pe.innerHTML=ut,Ro=n(),p(G.$$.fragment),Zo=n(),p(B.$$.fragment),uo=n(),p(ye.$$.fragment),go=n(),M=l("div"),p(xe.$$.fragment),Po=n(),We=l("p"),We.textContent=gt,Wo=n(),Le=l("p"),Le.innerHTML=_t,Lo=n(),Oe=l("p"),Oe.innerHTML=bt,Oo=n(),I=l("div"),p(Me.$$.fragment),Vo=n(),Ve=l("p"),Ve.innerHTML=Dt,Go=n(),p(H.$$.fragment),Bo=n(),p(S.$$.fragment),_o=n(),p($e.$$.fragment),bo=n(),Ge=l("p"),this.h()},l(e){const o=$t("svelte-u9bgzb",document.head);s=c(o,"META",{name:!0,content:!0}),o.forEach(t),w=r(e),m=c(e,"P",{}),C(m).forEach(t),f=r(e),h(v.$$.fragment,e),i=r(e),h(T.$$.fragment,e),He=r(e),Q=c(e,"P",{"data-svelte-h":!0}),D(Q)!=="svelte-1bsrzil"&&(Q.innerHTML=Ao),Se=r(e),K=c(e,"P",{"data-svelte-h":!0}),D(K)!=="svelte-1cv3nri"&&(K.textContent=Xo),Ae=r(e),ee=c(e,"P",{"data-svelte-h":!0}),D(ee)!=="svelte-1avddbq"&&(ee.innerHTML=Yo),Xe=r(e),Z=c(e,"IMG",{src:!0,alt:!0,width:!0}),Ye=r(e),oe=c(e,"SMALL",{"data-svelte-h":!0}),D(oe)!=="svelte-egxs49"&&(oe.innerHTML=Ko),Qe=r(e),te=c(e,"P",{"data-svelte-h":!0}),D(te)!=="svelte-16rbey8"&&(te.innerHTML=et),Ke=r(e),h(ne.$$.fragment,e),eo=r(e),re=c(e,"UL",{"data-svelte-h":!0}),D(re)!=="svelte-n5csze"&&(re.innerHTML=ot),oo=r(e),h(ae.$$.fragment,e),to=r(e),se=c(e,"P",{"data-svelte-h":!0}),D(se)!=="svelte-pwof30"&&(se.textContent=tt),no=r(e),h(ie.$$.fragment,e),ro=r(e),de=c(e,"UL",{"data-svelte-h":!0}),D(de)!=="svelte-13xaoxr"&&(de.innerHTML=nt),ao=r(e),le=c(e,"P",{"data-svelte-h":!0}),D(le)!=="svelte-17ytafw"&&(le.textContent=rt),so=r(e),h(ce.$$.fragment,e),io=r(e),$=c(e,"DIV",{class:!0});var U=C($);h(me.$$.fragment,U),wo=r(U),ke=c(U,"P",{"data-svelte-h":!0}),D(ke)!=="svelte-54uec8"&&(ke.textContent=at),To=r(U),P=c(U,"DIV",{class:!0});var je=C(P);h(fe.$$.fragment,je),yo=r(je),Ie=c(je,"P",{"data-svelte-h":!0}),D(Ie)!=="svelte-jgz2ra"&&(Ie.textContent=st),je.forEach(t),xo=r(U),W=c(U,"DIV",{class:!0});var Ce=C(W);h(pe.$$.fragment,Ce),Mo=r(Ce),Fe=c(Ce,"P",{"data-svelte-h":!0}),D(Fe)!=="svelte-tebuni"&&(Fe.innerHTML=it),Ce.forEach(t),U.forEach(t),lo=r(e),h(he.$$.fragment,e),co=r(e),F=c(e,"DIV",{class:!0});var N=C(F);h(ue.$$.fragment,N),$o=r(N),L=c(N,"DIV",{class:!0});var ze=C(L);h(ge.$$.fragment,ze),jo=r(ze),Ue=c(ze,"P",{"data-svelte-h":!0}),D(Ue)!=="svelte-khengj"&&(Ue.textContent=dt),ze.forEach(t),Co=r(N),O=c(N,"DIV",{class:!0});var vo=C(O);h(_e.$$.fragment,vo),zo=r(vo),qe=c(vo,"P",{"data-svelte-h":!0}),D(qe)!=="svelte-tebuni"&&(qe.innerHTML=lt),vo.forEach(t),N.forEach(t),mo=r(e),h(be.$$.fragment,e),fo=r(e),j=c(e,"DIV",{class:!0});var A=C(j);h(De.$$.fragment,A),ko=r(A),Je=c(A,"P",{"data-svelte-h":!0}),D(Je)!=="svelte-uutjcy"&&(Je.innerHTML=ct),Io=r(A),Ee=c(A,"P",{"data-svelte-h":!0}),D(Ee)!=="svelte-1h63gr"&&(Ee.innerHTML=mt),Fo=r(A),h(V.$$.fragment,A),A.forEach(t),po=r(e),h(ve.$$.fragment,e),ho=r(e),x=c(e,"DIV",{class:!0});var J=C(x);h(we.$$.fragment,J),Uo=r(J),Ne=c(J,"P",{"data-svelte-h":!0}),D(Ne)!=="svelte-12u6mh6"&&(Ne.textContent=ft),qo=r(J),Re=c(J,"P",{"data-svelte-h":!0}),D(Re)!=="svelte-wtd5rw"&&(Re.innerHTML=pt),Jo=r(J),Ze=c(J,"P",{"data-svelte-h":!0}),D(Ze)!=="svelte-hswkmf"&&(Ze.innerHTML=ht),Eo=r(J),k=c(J,"DIV",{class:!0});var X=C(k);h(Te.$$.fragment,X),No=r(X),Pe=c(X,"P",{"data-svelte-h":!0}),D(Pe)!=="svelte-1t3ip1k"&&(Pe.innerHTML=ut),Ro=r(X),h(G.$$.fragment,X),Zo=r(X),h(B.$$.fragment,X),X.forEach(t),J.forEach(t),uo=r(e),h(ye.$$.fragment,e),go=r(e),M=c(e,"DIV",{class:!0});var E=C(M);h(xe.$$.fragment,E),Po=r(E),We=c(E,"P",{"data-svelte-h":!0}),D(We)!=="svelte-1bchwb"&&(We.textContent=gt),Wo=r(E),Le=c(E,"P",{"data-svelte-h":!0}),D(Le)!=="svelte-wtd5rw"&&(Le.innerHTML=_t),Lo=r(E),Oe=c(E,"P",{"data-svelte-h":!0}),D(Oe)!=="svelte-hswkmf"&&(Oe.innerHTML=bt),Oo=r(E),I=c(E,"DIV",{class:!0});var Y=C(I);h(Me.$$.fragment,Y),Vo=r(Y),Ve=c(Y,"P",{"data-svelte-h":!0}),D(Ve)!=="svelte-4n4n1a"&&(Ve.innerHTML=Dt),Go=r(Y),h(H.$$.fragment,Y),Bo=r(Y),h(S.$$.fragment,Y),Y.forEach(t),E.forEach(t),_o=r(e),h($e.$$.fragment,e),bo=r(e),Ge=c(e,"P",{}),C(Ge).forEach(t),this.h()},h(){y(s,"name","hf:doc:metadata"),y(s,"content",Jt),Tt(Z.src,Qo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/deformable_detr_architecture.png")||y(Z,"src",Qo),y(Z,"alt","描画"),y(Z,"width","600"),y(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){d(document.head,s),a(e,w,o),a(e,m,o),a(e,f,o),u(v,e,o),a(e,i,o),u(T,e,o),a(e,He,o),a(e,Q,o),a(e,Se,o),a(e,K,o),a(e,Ae,o),a(e,ee,o),a(e,Xe,o),a(e,Z,o),a(e,Ye,o),a(e,oe,o),a(e,Qe,o),a(e,te,o),a(e,Ke,o),u(ne,e,o),a(e,eo,o),a(e,re,o),a(e,oo,o),u(ae,e,o),a(e,to,o),a(e,se,o),a(e,no,o),u(ie,e,o),a(e,ro,o),a(e,de,o),a(e,ao,o),a(e,le,o),a(e,so,o),u(ce,e,o),a(e,io,o),a(e,$,o),u(me,$,null),d($,wo),d($,ke),d($,To),d($,P),u(fe,P,null),d(P,yo),d(P,Ie),d($,xo),d($,W),u(pe,W,null),d(W,Mo),d(W,Fe),a(e,lo,o),u(he,e,o),a(e,co,o),a(e,F,o),u(ue,F,null),d(F,$o),d(F,L),u(ge,L,null),d(L,jo),d(L,Ue),d(F,Co),d(F,O),u(_e,O,null),d(O,zo),d(O,qe),a(e,mo,o),u(be,e,o),a(e,fo,o),a(e,j,o),u(De,j,null),d(j,ko),d(j,Je),d(j,Io),d(j,Ee),d(j,Fo),u(V,j,null),a(e,po,o),u(ve,e,o),a(e,ho,o),a(e,x,o),u(we,x,null),d(x,Uo),d(x,Ne),d(x,qo),d(x,Re),d(x,Jo),d(x,Ze),d(x,Eo),d(x,k),u(Te,k,null),d(k,No),d(k,Pe),d(k,Ro),u(G,k,null),d(k,Zo),u(B,k,null),a(e,uo,o),u(ye,e,o),a(e,go,o),a(e,M,o),u(xe,M,null),d(M,Po),d(M,We),d(M,Wo),d(M,Le),d(M,Lo),d(M,Oe),d(M,Oo),d(M,I),u(Me,I,null),d(I,Vo),d(I,Ve),d(I,Go),u(H,I,null),d(I,Bo),u(S,I,null),a(e,_o,o),u($e,e,o),a(e,bo,o),a(e,Ge,o),Do=!0},p(e,[o]){const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),V.$set(U);const je={};o&2&&(je.$$scope={dirty:o,ctx:e}),G.$set(je);const Ce={};o&2&&(Ce.$$scope={dirty:o,ctx:e}),B.$set(Ce);const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),H.$set(N);const ze={};o&2&&(ze.$$scope={dirty:o,ctx:e}),S.$set(ze)},i(e){Do||(g(v.$$.fragment,e),g(T.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(De.$$.fragment,e),g(V.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(G.$$.fragment,e),g(B.$$.fragment,e),g(ye.$$.fragment,e),g(xe.$$.fragment,e),g(Me.$$.fragment,e),g(H.$$.fragment,e),g(S.$$.fragment,e),g($e.$$.fragment,e),Do=!0)},o(e){_(v.$$.fragment,e),_(T.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(De.$$.fragment,e),_(V.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(Te.$$.fragment,e),_(G.$$.fragment,e),_(B.$$.fragment,e),_(ye.$$.fragment,e),_(xe.$$.fragment,e),_(Me.$$.fragment,e),_(H.$$.fragment,e),_(S.$$.fragment,e),_($e.$$.fragment,e),Do=!1},d(e){e&&(t(w),t(m),t(f),t(i),t(He),t(Q),t(Se),t(K),t(Ae),t(ee),t(Xe),t(Z),t(Ye),t(oe),t(Qe),t(te),t(Ke),t(eo),t(re),t(oo),t(to),t(se),t(no),t(ro),t(de),t(ao),t(le),t(so),t(io),t($),t(lo),t(co),t(F),t(mo),t(fo),t(j),t(po),t(ho),t(x),t(uo),t(go),t(M),t(_o),t(bo),t(Ge)),t(s),b(v,e),b(T,e),b(ne,e),b(ae,e),b(ie,e),b(ce,e),b(me),b(fe),b(pe),b(he,e),b(ue),b(ge),b(_e),b(be,e),b(De),b(V),b(ve,e),b(we),b(Te),b(G),b(B),b(ye,e),b(xe),b(Me),b(H),b(S),b($e,e)}}}const Jt='{"title":"Deformable DETR","local":"deformable-detr","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DeformableDetrImageProcessor","local":"transformers.DeformableDetrImageProcessor","sections":[],"depth":2},{"title":"DeformableDetrFeatureExtractor","local":"transformers.DeformableDetrFeatureExtractor","sections":[],"depth":2},{"title":"DeformableDetrConfig","local":"transformers.DeformableDetrConfig","sections":[],"depth":2},{"title":"DeformableDetrModel","local":"transformers.DeformableDetrModel","sections":[],"depth":2},{"title":"DeformableDetrForObjectDetection","local":"transformers.DeformableDetrForObjectDetection","sections":[],"depth":2}],"depth":1}';function Et(z){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends xt{constructor(s){super(),Mt(this,s,Et,qt,wt,{})}}export{Gt as component};
