import{s as Ao,o as Po,n as A}from"../chunks/scheduler.25b97de1.js";import{S as Yo,i as Oo,g as c,s as a,r as g,A as Ko,h as p,f as i,c as r,j as C,u as _,x as k,k as U,y as s,a as h,v as T,d as M,t as b,w as y}from"../chunks/index.d9030fc9.js";import{T as On}from"../chunks/Tip.baa67368.js";import{D as F}from"../chunks/Docstring.e257edda.js";import{C as de}from"../chunks/CodeBlock.e6cd0d95.js";import{F as es,M as Fo}from"../chunks/Markdown.7217f838.js";import{E as le}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as ie,E as ts}from"../chunks/EditOnGithub.91d95064.js";function ns(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1UNU1vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwTVQ1TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBYXJ0aWNsZSUyMCUzRCUyMCUyMlVOJTIwT2ZmaXppZXIlMjBzYWd0JTJDJTIwZGFzcyUyMHdlaXRlciUyMHZlcmhhbmRlbHQlMjB3ZXJkZW4lMjBtdXNzJTIwaW4lMjBTeXJpZW4uJTIyJTBBc3VtbWFyeSUyMCUzRCUyMCUyMldlaXRlciUyMFZlcmhhbmRsdW5nJTIwaW4lMjBTeXJpZW4uJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0ZXh0X3RhcmdldCUzRHN1bW1hcnklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGxhYmVscyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFoaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MT5Model, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5Model.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], decoder_input_ids=labels[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function os(j){let t,f="Example:",n,o,m;return o=new de({props:{code:"JTIzJTIwT24lMjBhJTIwNCUyMEdQVSUyMG1hY2hpbmUlMjB3aXRoJTIwbXQ1LXhsJTNBJTBBbW9kZWwlMjAlM0QlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk10NS14bCUyMiklMEFkZXZpY2VfbWFwJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwMCUzQSUyMCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUyQyUwQSUyMCUyMCUyMCUyMDElM0ElMjAlNUIzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglMkMlMjA5JTVEJTJDJTBBJTIwJTIwJTIwJTIwMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTJDJTIwMTQlMkMlMjAxNSUyQyUyMDE2JTVEJTJDJTBBJTIwJTIwJTIwJTIwMyUzQSUyMCU1QjE3JTJDJTIwMTglMkMlMjAxOSUyQyUyMDIwJTJDJTIwMjElMkMlMjAyMiUyQyUyMDIzJTVEJTJDJTBBJTdEJTBBbW9kZWwucGFyYWxsZWxpemUoZGV2aWNlX21hcCklMjAlMjAlMjMlMjBTcGxpdHMlMjB0aGUlMjBtb2RlbCUyMGFjcm9zcyUyMHNldmVyYWwlMjBkZXZpY2VzJTBBbW9kZWwuZGVwYXJhbGxlbGl6ZSgpJTIwJTIwJTIzJTIwUHV0JTIwdGhlJTIwbW9kZWwlMjBiYWNrJTIwb24lMjBjcHUlMjBhbmQlMjBjbGVhbnMlMjBtZW1vcnklMjBieSUyMGNhbGxpbmclMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCk=",highlighted:`<span class="hljs-comment"># On a 4 GPU machine with mt5-xl:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)  <span class="hljs-comment"># Splits the model across several devices</span>
model.deparallelize()  <span class="hljs-comment"># Put the model back on cpu and cleans memory by calling torch.cuda.empty_cache()</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function ss(j){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=f},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){h(n,t,o)},p:A,d(n){n&&i(t)}}}function as(j){let t,f="Example:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNVDVNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyME1UNU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMlN0dWRpZXMlMjBoYXZlJTIwYmVlbiUyMHNob3duJTIwdGhhdCUyMG93bmluZyUyMGElMjBkb2clMjBpcyUyMGdvb2QlMjBmb3IlMjB5b3UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyU3R1ZGllcyUyMHNob3clMjB0aGF0JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQSUwQSUyMyUyMHByZXByb2Nlc3MlM0ElMjBQcmVwZW5kJTIwZGVjb2Rlcl9pbnB1dF9pZHMlMjB3aXRoJTIwc3RhcnQlMjB0b2tlbiUyMHdoaWNoJTIwaXMlMjBwYWQlMjB0b2tlbiUyMGZvciUyME1UNU1vZGVsLiUwQSUyMyUyMFRoaXMlMjBpcyUyMG5vdCUyMG5lZWRlZCUyMGZvciUyMHRvcmNoJ3MlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMjBhcyUyMGl0JTIwZG9lcyUyMHRoaXMlMjBpbnRlcm5hbGx5JTIwdXNpbmclMjBsYWJlbHMlMjBhcmcuJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjBtb2RlbC5fc2hpZnRfcmlnaHQoZGVjb2Rlcl9pbnB1dF9pZHMpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwZGVjb2Rlcl9pbnB1dF9pZHMlM0RkZWNvZGVyX2lucHV0X2lkcyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MT5Model

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5Model.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># preprocess: Prepend decoder_input_ids with start token which is pad token for MT5Model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is not needed for torch&#x27;s MT5ForConditionalGeneration as it does this internally using labels arg.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = model._shift_right(decoder_input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function rs(j){let t,f="Example:",n,o,m;return o=new de({props:{code:"JTIzJTIwSGVyZSUyMGlzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBhJTIwZGV2aWNlJTIwbWFwJTIwb24lMjBhJTIwbWFjaGluZSUyMHdpdGglMjA0JTIwR1BVcyUyMHVzaW5nJTIwbXQ1LXhsJTJDJTIwd2hpY2glMjBoYXMlMjBhJTIwdG90YWwlMjBvZiUyMDI0JTIwYXR0ZW50aW9uJTIwbW9kdWxlcyUzQSUwQW1vZGVsJTIwJTNEJTIwTVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdDUteGwlMjIpJTBBZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMDAlM0ElMjAlNUIwJTJDJTIwMSUyQyUyMDIlNUQlMkMlMEElMjAlMjAlMjAlMjAxJTNBJTIwJTVCMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUyQyUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUIxMCUyQyUyMDExJTJDJTIwMTIlMkMlMjAxMyUyQyUyMDE0JTJDJTIwMTUlMkMlMjAxNiU1RCUyQyUwQSUyMCUyMCUyMCUyMDMlM0ElMjAlNUIxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTJDJTIwMjIlMkMlMjAyMyU1RCUyQyUwQSU3RCUwQW1vZGVsLnBhcmFsbGVsaXplKGRldmljZV9tYXAp",highlighted:`<span class="hljs-comment"># Here is an example of a device map on a machine with 4 GPUs using mt5-xl, which has a total of 24 attention modules:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function ls(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1UNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyME1UNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEFhcnRpY2xlJTIwJTNEJTIwJTIyVU4lMjBPZmZpemllciUyMHNhZ3QlMkMlMjBkYXNzJTIwd2VpdGVyJTIwdmVyaGFuZGVsdCUyMHdlcmRlbiUyMG11c3MlMjBpbiUyMFN5cmllbi4lMjIlMEFzdW1tYXJ5JTIwJTNEJTIwJTIyV2VpdGVyJTIwVmVyaGFuZGx1bmclMjBpbiUyMFN5cmllbi4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoYXJ0aWNsZSUyQyUyMHRleHRfdGFyZ2V0JTNEc3VtbWFyeSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MT5ForConditionalGeneration, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, text_target=summary, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function is(j){let t,f="Example:",n,o,m;return o=new de({props:{code:"JTIzJTIwT24lMjBhJTIwNCUyMEdQVSUyMG1hY2hpbmUlMjB3aXRoJTIwbXQ1LXhsJTNBJTBBbW9kZWwlMjAlM0QlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk10NS14bCUyMiklMEFkZXZpY2VfbWFwJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwMCUzQSUyMCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUyQyUwQSUyMCUyMCUyMCUyMDElM0ElMjAlNUIzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglMkMlMjA5JTVEJTJDJTBBJTIwJTIwJTIwJTIwMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTJDJTIwMTQlMkMlMjAxNSUyQyUyMDE2JTVEJTJDJTBBJTIwJTIwJTIwJTIwMyUzQSUyMCU1QjE3JTJDJTIwMTglMkMlMjAxOSUyQyUyMDIwJTJDJTIwMjElMkMlMjAyMiUyQyUyMDIzJTVEJTJDJTBBJTdEJTBBbW9kZWwucGFyYWxsZWxpemUoZGV2aWNlX21hcCklMjAlMjAlMjMlMjBTcGxpdHMlMjB0aGUlMjBtb2RlbCUyMGFjcm9zcyUyMHNldmVyYWwlMjBkZXZpY2VzJTBBbW9kZWwuZGVwYXJhbGxlbGl6ZSgpJTIwJTIwJTIzJTIwUHV0JTIwdGhlJTIwbW9kZWwlMjBiYWNrJTIwb24lMjBjcHUlMjBhbmQlMjBjbGVhbnMlMjBtZW1vcnklMjBieSUyMGNhbGxpbmclMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCk=",highlighted:`<span class="hljs-comment"># On a 4 GPU machine with mt5-xl:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)  <span class="hljs-comment"># Splits the model across several devices</span>
model.deparallelize()  <span class="hljs-comment"># Put the model back on cpu and cleans memory by calling torch.cuda.empty_cache()</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function ds(j){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=f},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){h(n,t,o)},p:A,d(n){n&&i(t)}}}function cs(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEElMEElMjMlMjB0cmFpbmluZyUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjAlM0NleHRyYV9pZF8wJTNFJTIwd2Fsa3MlMjBpbiUyMCUzQ2V4dHJhX2lkXzElM0UlMjBwYXJrJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMiUzQ2V4dHJhX2lkXzAlM0UlMjBjdXRlJTIwZG9nJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHRoZSUyMCUzQ2V4dHJhX2lkXzIlM0UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUwQSUyMyUyMGluZmVyZW5jZSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJzdW1tYXJpemUlM0ElMjBzdHVkaWVzJTIwaGF2ZSUyMHNob3duJTIwdGhhdCUyMG93bmluZyUyMGElMjBkb2clMjBpcyUyMGdvb2QlMjBmb3IlMjB5b3UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0X2lkcyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUyMyUyMHN0dWRpZXMlMjBoYXZlJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdS4=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MT5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;&lt;extra_id_0&gt; cute dog &lt;extra_id_1&gt; the &lt;extra_id_2&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;summarize: studies have shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># studies have shown that owning a dog is good for you.</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function ps(j){let t,f="Example:",n,o,m;return o=new de({props:{code:"JTIzJTIwSGVyZSUyMGlzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBhJTIwZGV2aWNlJTIwbWFwJTIwb24lMjBhJTIwbWFjaGluZSUyMHdpdGglMjA0JTIwR1BVcyUyMHVzaW5nJTIwbXQ1LXhsJTJDJTIwd2hpY2glMjBoYXMlMjBhJTIwdG90YWwlMjBvZiUyMDI0JTIwYXR0ZW50aW9uJTIwbW9kdWxlcyUzQSUwQW1vZGVsJTIwJTNEJTIwTVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdDUteGwlMjIpJTBBZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMDAlM0ElMjAlNUIwJTJDJTIwMSUyQyUyMDIlNUQlMkMlMEElMjAlMjAlMjAlMjAxJTNBJTIwJTVCMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUyQyUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUIxMCUyQyUyMDExJTJDJTIwMTIlMkMlMjAxMyUyQyUyMDE0JTJDJTIwMTUlMkMlMjAxNiU1RCUyQyUwQSUyMCUyMCUyMCUyMDMlM0ElMjAlNUIxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTJDJTIwMjIlMkMlMjAyMyU1RCUyQyUwQSU3RCUwQW1vZGVsLnBhcmFsbGVsaXplKGRldmljZV9tYXAp",highlighted:`<span class="hljs-comment"># Here is an example of a device map on a machine with 4 GPUs using mt5-xl, which has a total of 24 attention modules:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function ms(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1UNUVuY29kZXJNb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyME1UNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEFhcnRpY2xlJTIwJTNEJTIwJTIyVU4lMjBPZmZpemllciUyMHNhZ3QlMkMlMjBkYXNzJTIwd2VpdGVyJTIwdmVyaGFuZGVsdCUyMHdlcmRlbiUyMG11c3MlMjBpbiUyMFN5cmllbi4lMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoYXJ0aWNsZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMpJTBBaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MT5EncoderModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function us(j){let t,f="Example:",n,o,m;return o=new de({props:{code:"JTIzJTIwT24lMjBhJTIwNCUyMEdQVSUyMG1hY2hpbmUlMjB3aXRoJTIwbXQ1LXhsJTNBJTBBbW9kZWwlMjAlM0QlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk10NS14bCUyMiklMEFkZXZpY2VfbWFwJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwMCUzQSUyMCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUyQyUwQSUyMCUyMCUyMCUyMDElM0ElMjAlNUIzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglMkMlMjA5JTVEJTJDJTBBJTIwJTIwJTIwJTIwMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTJDJTIwMTQlMkMlMjAxNSUyQyUyMDE2JTVEJTJDJTBBJTIwJTIwJTIwJTIwMyUzQSUyMCU1QjE3JTJDJTIwMTglMkMlMjAxOSUyQyUyMDIwJTJDJTIwMjElMkMlMjAyMiUyQyUyMDIzJTVEJTJDJTBBJTdEJTBBbW9kZWwucGFyYWxsZWxpemUoZGV2aWNlX21hcCklMjAlMjAlMjMlMjBTcGxpdHMlMjB0aGUlMjBtb2RlbCUyMGFjcm9zcyUyMHNldmVyYWwlMjBkZXZpY2VzJTBBbW9kZWwuZGVwYXJhbGxlbGl6ZSgpJTIwJTIwJTIzJTIwUHV0JTIwdGhlJTIwbW9kZWwlMjBiYWNrJTIwb24lMjBjcHUlMjBhbmQlMjBjbGVhbnMlMjBtZW1vcnklMjBieSUyMGNhbGxpbmclMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCk=",highlighted:`<span class="hljs-comment"># On a 4 GPU machine with mt5-xl:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)  <span class="hljs-comment"># Splits the model across several devices</span>
model.deparallelize()  <span class="hljs-comment"># Put the model back on cpu and cleans memory by calling torch.cuda.empty_cache()</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function hs(j){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=f},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){h(n,t,o)},p:A,d(n){n&&i(t)}}}function fs(j){let t,f="Example:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNVDVFbmNvZGVyTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MT5EncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function gs(j){let t,f="Example:",n,o,m;return o=new de({props:{code:"JTIzJTIwSGVyZSUyMGlzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBhJTIwZGV2aWNlJTIwbWFwJTIwb24lMjBhJTIwbWFjaGluZSUyMHdpdGglMjA0JTIwR1BVcyUyMHVzaW5nJTIwbXQ1LXhsJTJDJTIwd2hpY2glMjBoYXMlMjBhJTIwdG90YWwlMjBvZiUyMDI0JTIwYXR0ZW50aW9uJTIwbW9kdWxlcyUzQSUwQW1vZGVsJTIwJTNEJTIwTVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdDUteGwlMjIpJTBBZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMDAlM0ElMjAlNUIwJTJDJTIwMSUyQyUyMDIlNUQlMkMlMEElMjAlMjAlMjAlMjAxJTNBJTIwJTVCMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUyQyUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUIxMCUyQyUyMDExJTJDJTIwMTIlMkMlMjAxMyUyQyUyMDE0JTJDJTIwMTUlMkMlMjAxNiU1RCUyQyUwQSUyMCUyMCUyMCUyMDMlM0ElMjAlNUIxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTJDJTIwMjIlMkMlMjAyMyU1RCUyQyUwQSU3RCUwQW1vZGVsLnBhcmFsbGVsaXplKGRldmljZV9tYXAp",highlighted:`<span class="hljs-comment"># Here is an example of a device map on a machine with 4 GPUs using mt5-xl, which has a total of 24 attention modules:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function _s(j){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=f},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){h(n,t,o)},p:A,d(n){n&&i(t)}}}function Ts(j){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=f},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){h(n,t,o)},p:A,d(n){n&&i(t)}}}function Ms(j){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=f},l(n){t=p(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){h(n,t,o)},p:A,d(n){n&&i(t)}}}function bs(j){let t,f,n,o,m,e,w="The bare MT5 Model transformer outputting raw hidden-states without any specific head on top.",Ze,V,te=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,H,Q,B=`This model inherits from <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,S,Y,ae=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,qe,L,D,E,Z,Te,z,X="Moves the model to cpu from a model parallel state.",We,N,ce,P,G,O,u,x='The <a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> forward method, overrides the <code>__call__</code> special method.',q,I,pe,nt,Dt,ne,Pe,$e,Ge,vn="This is an experimental feature and is a subject to change at a moment’s notice.",_t,zt,$n=`Uses a device map to distribute attention modules of the model across several devices. If no device map is given,
it will evenly distribute blocks across all devices.`,Tt,ot,Ft,je,It,J,xe,sn,Ee,Kn="MT5 Model with a <code>language modeling</code> head on top.",an,He,eo=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,rn,me,Mt=`This model inherits from <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ln,Qe,to=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,dn,Je,jn,Ve,Me,st,bt,Zt="Moves the model to cpu from a model parallel state.",xn,Ye,Oe,oe,at,yt,qt,Jn='The <a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5ForConditionalGeneration">MT5ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Ke,be,cn,Ue,Un,ye,ke,rt,kt,Wt="This is an experimental feature and is a subject to change at a moment’s notice.",Cn,lt,wt=`Uses a device map to distribute attention modules of the model across several devices. If no device map is given,
it will evenly distribute blocks across all devices.`,zn,Se,et,tt,se,W,it,vt,Gt,Fn="The bare MT5 Model transformer outputting encoder’s raw hidden-states without any specific head on top.",$t,Vt,In=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,Be,Re,Zn=`This model inherits from <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jt,Bt,qn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xt,dt,pn,re,Ce,mn,Le,no="Moves the model to cpu from a model parallel state.",At,we,Wn,ue,ve,Pt,Ne,un='The <a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5EncoderModel">MT5EncoderModel</a> forward method, overrides the <code>__call__</code> special method.',Rt,De,d,$,Ae,R,Xe,Yt,ct,hn="This is an experimental feature and is a subject to change at a moment’s notice.",Ot,he,Nt=`Uses a device map to distribute attention modules of the model across several devices. If no device map is given,
it will evenly distribute blocks across all devices.`,Kt,en,oo,fn,so,fe,gn,po,Gn,Io=`MT5 model with a sequence classification/head on top (a linear layer on top of the pooled output) e.g. for GLUE
tasks.`,mo,Vn,Zo=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,uo,Bn,qo=`This model inherits from <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ho,Rn,Wo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,fo,Jt,_n,go,Nn,Go='The <a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5ForSequenceClassification">MT5ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',_o,tn,ao,Tn,ro,ge,Mn,To,Xn,Vo=`MT5 Encoder Model with a token classification head on top (a linear layer on top of the hidden-states output)
e.g. for Named-Entity-Recognition (NER) tasks.`,Mo,En,Bo=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,bo,Hn,Ro=`This model inherits from <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,yo,Qn,No=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ko,Ut,bn,wo,Sn,Xo='The <a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5ForTokenClassification">MT5ForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',vo,nn,lo,yn,io,_e,kn,$o,Ln,Eo=`MT5 Model with a span classification head on top for extractive question-answering tasks like SQuAD (linear layers
on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,jo,Dn,Ho=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,xo,An,Qo=`This model inherits from <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Jo,Pn,So=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Uo,Ct,wn,Co,Yn,Lo='The <a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5ForQuestionAnswering">MT5ForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',zo,on,co;return t=new ie({props:{title:"MT5Model",local:"transformers.MT5Model",headingTag:"h2"}}),o=new F({props:{name:"class transformers.MT5Model",anchor:"transformers.MT5Model",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1323"}}),L=new le({props:{anchor:"transformers.MT5Model.example",$$slots:{default:[ns]},$$scope:{ctx:j}}}),Z=new F({props:{name:"deparallelize",anchor:"transformers.MT5Model.deparallelize",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1394"}}),N=new le({props:{anchor:"transformers.MT5Model.deparallelize.example",$$slots:{default:[os]},$$scope:{ctx:j}}}),G=new F({props:{name:"forward",anchor:"transformers.MT5Model.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"decoder_input_ids",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"decoder_head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MT5Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5Model.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5Model.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5Model.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5Model.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5Model.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5Model.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5Model.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30954/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1436",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),I=new On({props:{$$slots:{default:[ss]},$$scope:{ctx:j}}}),nt=new le({props:{anchor:"transformers.MT5Model.forward.example",$$slots:{default:[as]},$$scope:{ctx:j}}}),Pe=new F({props:{name:"parallelize",anchor:"transformers.MT5Model.parallelize",parameters:[{name:"device_map",val:" = None"}],parametersDescription:[{anchor:"transformers.MT5Model.parallelize.device_map",description:`<strong>device_map</strong> (<code>Dict[int, list]</code>, <em>optional</em>) &#x2014;
A dictionary that maps attention modules to devices. Note that the embedding module and LMHead are always
automatically mapped to the first device (for esoteric reasons). That means that the first device should
have fewer attention modules mapped to it than other devices. For reference, the mt5 models have the
following number of attention modules:</p>
<ul>
<li>mt5-small: 6</li>
<li>mt5-base: 12</li>
<li>mt5-large: 24</li>
<li>mt5-xl: 24</li>
<li>mt5-xxl: 24</li>
</ul>`,name:"device_map"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1374"}}),ot=new le({props:{anchor:"transformers.MT5Model.parallelize.example",$$slots:{default:[rs]},$$scope:{ctx:j}}}),je=new ie({props:{title:"MT5ForConditionalGeneration",local:"transformers.MT5ForConditionalGeneration",headingTag:"h2"}}),xe=new F({props:{name:"class transformers.MT5ForConditionalGeneration",anchor:"transformers.MT5ForConditionalGeneration",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5ForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1552"}}),Je=new le({props:{anchor:"transformers.MT5ForConditionalGeneration.example",$$slots:{default:[ls]},$$scope:{ctx:j}}}),Me=new F({props:{name:"deparallelize",anchor:"transformers.MT5ForConditionalGeneration.deparallelize",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1624"}}),Ye=new le({props:{anchor:"transformers.MT5ForConditionalGeneration.deparallelize.example",$$slots:{default:[is]},$$scope:{ctx:j}}}),at=new F({props:{name:"forward",anchor:"transformers.MT5ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"decoder_input_ids",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"decoder_head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MT5ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5ForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5ForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30954/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MT5ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1666",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),be=new On({props:{$$slots:{default:[ds]},$$scope:{ctx:j}}}),Ue=new le({props:{anchor:"transformers.MT5ForConditionalGeneration.forward.example",$$slots:{default:[cs]},$$scope:{ctx:j}}}),ke=new F({props:{name:"parallelize",anchor:"transformers.MT5ForConditionalGeneration.parallelize",parameters:[{name:"device_map",val:" = None"}],parametersDescription:[{anchor:"transformers.MT5ForConditionalGeneration.parallelize.device_map",description:`<strong>device_map</strong> (<code>Dict[int, list]</code>, <em>optional</em>) &#x2014;
A dictionary that maps attention modules to devices. Note that the embedding module and LMHead are always
automatically mapped to the first device (for esoteric reasons). That means that the first device should
have fewer attention modules mapped to it than other devices. For reference, the mt5 models have the
following number of attention modules:</p>
<ul>
<li>mt5-small: 6</li>
<li>mt5-base: 12</li>
<li>mt5-large: 24</li>
<li>mt5-xl: 24</li>
<li>mt5-xxl: 24</li>
</ul>`,name:"device_map"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1603"}}),Se=new le({props:{anchor:"transformers.MT5ForConditionalGeneration.parallelize.example",$$slots:{default:[ps]},$$scope:{ctx:j}}}),tt=new ie({props:{title:"MT5EncoderModel",local:"transformers.MT5EncoderModel",headingTag:"h2"}}),it=new F({props:{name:"class transformers.MT5EncoderModel",anchor:"transformers.MT5EncoderModel",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5EncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1897"}}),dt=new le({props:{anchor:"transformers.MT5EncoderModel.example",$$slots:{default:[ms]},$$scope:{ctx:j}}}),Ce=new F({props:{name:"deparallelize",anchor:"transformers.MT5EncoderModel.deparallelize",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1956"}}),we=new le({props:{anchor:"transformers.MT5EncoderModel.deparallelize.example",$$slots:{default:[us]},$$scope:{ctx:j}}}),ve=new F({props:{name:"forward",anchor:"transformers.MT5EncoderModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MT5EncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5EncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5EncoderModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5EncoderModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5EncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5EncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5EncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30954/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1991",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),De=new On({props:{$$slots:{default:[hs]},$$scope:{ctx:j}}}),$=new le({props:{anchor:"transformers.MT5EncoderModel.forward.example",$$slots:{default:[fs]},$$scope:{ctx:j}}}),Xe=new F({props:{name:"parallelize",anchor:"transformers.MT5EncoderModel.parallelize",parameters:[{name:"device_map",val:" = None"}],parametersDescription:[{anchor:"transformers.MT5EncoderModel.parallelize.device_map",description:`<strong>device_map</strong> (<code>Dict[int, list]</code>, <em>optional</em>) &#x2014;
A dictionary that maps attention modules to devices. Note that the embedding module and LMHead are always
automatically mapped to the first device (for esoteric reasons). That means that the first device should
have fewer attention modules mapped to it than other devices. For reference, the mt5 models have the
following number of attention modules:</p>
<ul>
<li>mt5-small: 6</li>
<li>mt5-base: 12</li>
<li>mt5-large: 24</li>
<li>mt5-xl: 24</li>
<li>mt5-xxl: 24</li>
</ul>`,name:"device_map"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L1937"}}),en=new le({props:{anchor:"transformers.MT5EncoderModel.parallelize.example",$$slots:{default:[gs]},$$scope:{ctx:j}}}),fn=new ie({props:{title:"MT5ForSequenceClassification",local:"transformers.MT5ForSequenceClassification",headingTag:"h2"}}),gn=new F({props:{name:"class transformers.MT5ForSequenceClassification",anchor:"transformers.MT5ForSequenceClassification",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L2035"}}),_n=new F({props:{name:"forward",anchor:"transformers.MT5ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"decoder_input_ids",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"decoder_head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MT5ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5ForSequenceClassification.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5ForSequenceClassification.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30954/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MT5ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L2057",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput"
>transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput"
>transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),tn=new On({props:{$$slots:{default:[_s]},$$scope:{ctx:j}}}),Tn=new ie({props:{title:"MT5ForTokenClassification",local:"transformers.MT5ForTokenClassification",headingTag:"h2"}}),Mn=new F({props:{name:"class transformers.MT5ForTokenClassification",anchor:"transformers.MT5ForTokenClassification",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5ForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L2170"}}),bn=new F({props:{name:"forward",anchor:"transformers.MT5ForTokenClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MT5ForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5ForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5ForTokenClassification.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5ForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5ForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5ForTokenClassification.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5ForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5ForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5ForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5ForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30954/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MT5ForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L2192",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),nn=new On({props:{$$slots:{default:[Ts]},$$scope:{ctx:j}}}),yn=new ie({props:{title:"MT5ForQuestionAnswering",local:"transformers.MT5ForQuestionAnswering",headingTag:"h2"}}),kn=new F({props:{name:"class transformers.MT5ForQuestionAnswering",anchor:"transformers.MT5ForQuestionAnswering",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5ForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30954/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L2244"}}),wn=new F({props:{name:"forward",anchor:"transformers.MT5ForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"decoder_input_ids",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"decoder_head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"start_positions",val:": Optional = None"},{name:"end_positions",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MT5ForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5ForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30954/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30954/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5ForQuestionAnswering.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5ForQuestionAnswering.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5ForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5ForQuestionAnswering.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5ForQuestionAnswering.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5ForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5ForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5ForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30954/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MT5ForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<em>sequence_length</em>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.MT5ForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<em>sequence_length</em>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_mt5.py#L2300",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput"
>transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30954/en/main_classes/output#transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput"
>transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),on=new On({props:{$$slots:{default:[Ms]},$$scope:{ctx:j}}}),{c(){g(t.$$.fragment),f=a(),n=c("div"),g(o.$$.fragment),m=a(),e=c("p"),e.textContent=w,Ze=a(),V=c("p"),V.innerHTML=te,H=a(),Q=c("p"),Q.innerHTML=B,S=a(),Y=c("p"),Y.innerHTML=ae,qe=a(),g(L.$$.fragment),D=a(),E=c("div"),g(Z.$$.fragment),Te=a(),z=c("p"),z.textContent=X,We=a(),g(N.$$.fragment),ce=a(),P=c("div"),g(G.$$.fragment),O=a(),u=c("p"),u.innerHTML=x,q=a(),g(I.$$.fragment),pe=a(),g(nt.$$.fragment),Dt=a(),ne=c("div"),g(Pe.$$.fragment),$e=a(),Ge=c("p"),Ge.textContent=vn,_t=a(),zt=c("p"),zt.textContent=$n,Tt=a(),g(ot.$$.fragment),Ft=a(),g(je.$$.fragment),It=a(),J=c("div"),g(xe.$$.fragment),sn=a(),Ee=c("p"),Ee.innerHTML=Kn,an=a(),He=c("p"),He.innerHTML=eo,rn=a(),me=c("p"),me.innerHTML=Mt,ln=a(),Qe=c("p"),Qe.innerHTML=to,dn=a(),g(Je.$$.fragment),jn=a(),Ve=c("div"),g(Me.$$.fragment),st=a(),bt=c("p"),bt.textContent=Zt,xn=a(),g(Ye.$$.fragment),Oe=a(),oe=c("div"),g(at.$$.fragment),yt=a(),qt=c("p"),qt.innerHTML=Jn,Ke=a(),g(be.$$.fragment),cn=a(),g(Ue.$$.fragment),Un=a(),ye=c("div"),g(ke.$$.fragment),rt=a(),kt=c("p"),kt.textContent=Wt,Cn=a(),lt=c("p"),lt.textContent=wt,zn=a(),g(Se.$$.fragment),et=a(),g(tt.$$.fragment),se=a(),W=c("div"),g(it.$$.fragment),vt=a(),Gt=c("p"),Gt.textContent=Fn,$t=a(),Vt=c("p"),Vt.innerHTML=In,Be=a(),Re=c("p"),Re.innerHTML=Zn,jt=a(),Bt=c("p"),Bt.innerHTML=qn,xt=a(),g(dt.$$.fragment),pn=a(),re=c("div"),g(Ce.$$.fragment),mn=a(),Le=c("p"),Le.textContent=no,At=a(),g(we.$$.fragment),Wn=a(),ue=c("div"),g(ve.$$.fragment),Pt=a(),Ne=c("p"),Ne.innerHTML=un,Rt=a(),g(De.$$.fragment),d=a(),g($.$$.fragment),Ae=a(),R=c("div"),g(Xe.$$.fragment),Yt=a(),ct=c("p"),ct.textContent=hn,Ot=a(),he=c("p"),he.textContent=Nt,Kt=a(),g(en.$$.fragment),oo=a(),g(fn.$$.fragment),so=a(),fe=c("div"),g(gn.$$.fragment),po=a(),Gn=c("p"),Gn.textContent=Io,mo=a(),Vn=c("p"),Vn.innerHTML=Zo,uo=a(),Bn=c("p"),Bn.innerHTML=qo,ho=a(),Rn=c("p"),Rn.innerHTML=Wo,fo=a(),Jt=c("div"),g(_n.$$.fragment),go=a(),Nn=c("p"),Nn.innerHTML=Go,_o=a(),g(tn.$$.fragment),ao=a(),g(Tn.$$.fragment),ro=a(),ge=c("div"),g(Mn.$$.fragment),To=a(),Xn=c("p"),Xn.textContent=Vo,Mo=a(),En=c("p"),En.innerHTML=Bo,bo=a(),Hn=c("p"),Hn.innerHTML=Ro,yo=a(),Qn=c("p"),Qn.innerHTML=No,ko=a(),Ut=c("div"),g(bn.$$.fragment),wo=a(),Sn=c("p"),Sn.innerHTML=Xo,vo=a(),g(nn.$$.fragment),lo=a(),g(yn.$$.fragment),io=a(),_e=c("div"),g(kn.$$.fragment),$o=a(),Ln=c("p"),Ln.innerHTML=Eo,jo=a(),Dn=c("p"),Dn.innerHTML=Ho,xo=a(),An=c("p"),An.innerHTML=Qo,Jo=a(),Pn=c("p"),Pn.innerHTML=So,Uo=a(),Ct=c("div"),g(wn.$$.fragment),Co=a(),Yn=c("p"),Yn.innerHTML=Lo,zo=a(),g(on.$$.fragment),this.h()},l(l){_(t.$$.fragment,l),f=r(l),n=p(l,"DIV",{class:!0});var v=C(n);_(o.$$.fragment,v),m=r(v),e=p(v,"P",{"data-svelte-h":!0}),k(e)!=="svelte-r01pan"&&(e.textContent=w),Ze=r(v),V=p(v,"P",{"data-svelte-h":!0}),k(V)!=="svelte-1hbaqlt"&&(V.innerHTML=te),H=r(v),Q=p(v,"P",{"data-svelte-h":!0}),k(Q)!=="svelte-h9i66j"&&(Q.innerHTML=B),S=r(v),Y=p(v,"P",{"data-svelte-h":!0}),k(Y)!=="svelte-hswkmf"&&(Y.innerHTML=ae),qe=r(v),_(L.$$.fragment,v),D=r(v),E=p(v,"DIV",{class:!0});var Xt=C(E);_(Z.$$.fragment,Xt),Te=r(Xt),z=p(Xt,"P",{"data-svelte-h":!0}),k(z)!=="svelte-ewr91v"&&(z.textContent=X),We=r(Xt),_(N.$$.fragment,Xt),Xt.forEach(i),ce=r(v),P=p(v,"DIV",{class:!0});var pt=C(P);_(G.$$.fragment,pt),O=r(pt),u=p(pt,"P",{"data-svelte-h":!0}),k(u)!=="svelte-4zfwho"&&(u.innerHTML=x),q=r(pt),_(I.$$.fragment,pt),pe=r(pt),_(nt.$$.fragment,pt),pt.forEach(i),Dt=r(v),ne=p(v,"DIV",{class:!0});var mt=C(ne);_(Pe.$$.fragment,mt),$e=r(mt),Ge=p(mt,"P",{"data-svelte-h":!0}),k(Ge)!=="svelte-1wtkcqk"&&(Ge.textContent=vn),_t=r(mt),zt=p(mt,"P",{"data-svelte-h":!0}),k(zt)!=="svelte-16fuwd4"&&(zt.textContent=$n),Tt=r(mt),_(ot.$$.fragment,mt),mt.forEach(i),v.forEach(i),Ft=r(l),_(je.$$.fragment,l),It=r(l),J=p(l,"DIV",{class:!0});var K=C(J);_(xe.$$.fragment,K),sn=r(K),Ee=p(K,"P",{"data-svelte-h":!0}),k(Ee)!=="svelte-1mzt99y"&&(Ee.innerHTML=Kn),an=r(K),He=p(K,"P",{"data-svelte-h":!0}),k(He)!=="svelte-1hbaqlt"&&(He.innerHTML=eo),rn=r(K),me=p(K,"P",{"data-svelte-h":!0}),k(me)!=="svelte-h9i66j"&&(me.innerHTML=Mt),ln=r(K),Qe=p(K,"P",{"data-svelte-h":!0}),k(Qe)!=="svelte-hswkmf"&&(Qe.innerHTML=to),dn=r(K),_(Je.$$.fragment,K),jn=r(K),Ve=p(K,"DIV",{class:!0});var Et=C(Ve);_(Me.$$.fragment,Et),st=r(Et),bt=p(Et,"P",{"data-svelte-h":!0}),k(bt)!=="svelte-ewr91v"&&(bt.textContent=Zt),xn=r(Et),_(Ye.$$.fragment,Et),Et.forEach(i),Oe=r(K),oe=p(K,"DIV",{class:!0});var ut=C(oe);_(at.$$.fragment,ut),yt=r(ut),qt=p(ut,"P",{"data-svelte-h":!0}),k(qt)!=="svelte-15ifnei"&&(qt.innerHTML=Jn),Ke=r(ut),_(be.$$.fragment,ut),cn=r(ut),_(Ue.$$.fragment,ut),ut.forEach(i),Un=r(K),ye=p(K,"DIV",{class:!0});var ht=C(ye);_(ke.$$.fragment,ht),rt=r(ht),kt=p(ht,"P",{"data-svelte-h":!0}),k(kt)!=="svelte-1wtkcqk"&&(kt.textContent=Wt),Cn=r(ht),lt=p(ht,"P",{"data-svelte-h":!0}),k(lt)!=="svelte-16fuwd4"&&(lt.textContent=wt),zn=r(ht),_(Se.$$.fragment,ht),ht.forEach(i),K.forEach(i),et=r(l),_(tt.$$.fragment,l),se=r(l),W=p(l,"DIV",{class:!0});var ee=C(W);_(it.$$.fragment,ee),vt=r(ee),Gt=p(ee,"P",{"data-svelte-h":!0}),k(Gt)!=="svelte-1ixg1pn"&&(Gt.textContent=Fn),$t=r(ee),Vt=p(ee,"P",{"data-svelte-h":!0}),k(Vt)!=="svelte-1hbaqlt"&&(Vt.innerHTML=In),Be=r(ee),Re=p(ee,"P",{"data-svelte-h":!0}),k(Re)!=="svelte-h9i66j"&&(Re.innerHTML=Zn),jt=r(ee),Bt=p(ee,"P",{"data-svelte-h":!0}),k(Bt)!=="svelte-hswkmf"&&(Bt.innerHTML=qn),xt=r(ee),_(dt.$$.fragment,ee),pn=r(ee),re=p(ee,"DIV",{class:!0});var Ht=C(re);_(Ce.$$.fragment,Ht),mn=r(Ht),Le=p(Ht,"P",{"data-svelte-h":!0}),k(Le)!=="svelte-ewr91v"&&(Le.textContent=no),At=r(Ht),_(we.$$.fragment,Ht),Ht.forEach(i),Wn=r(ee),ue=p(ee,"DIV",{class:!0});var ft=C(ue);_(ve.$$.fragment,ft),Pt=r(ft),Ne=p(ft,"P",{"data-svelte-h":!0}),k(Ne)!=="svelte-opi0r2"&&(Ne.innerHTML=un),Rt=r(ft),_(De.$$.fragment,ft),d=r(ft),_($.$$.fragment,ft),ft.forEach(i),Ae=r(ee),R=p(ee,"DIV",{class:!0});var gt=C(R);_(Xe.$$.fragment,gt),Yt=r(gt),ct=p(gt,"P",{"data-svelte-h":!0}),k(ct)!=="svelte-1wtkcqk"&&(ct.textContent=hn),Ot=r(gt),he=p(gt,"P",{"data-svelte-h":!0}),k(he)!=="svelte-16fuwd4"&&(he.textContent=Nt),Kt=r(gt),_(en.$$.fragment,gt),gt.forEach(i),ee.forEach(i),oo=r(l),_(fn.$$.fragment,l),so=r(l),fe=p(l,"DIV",{class:!0});var ze=C(fe);_(gn.$$.fragment,ze),po=r(ze),Gn=p(ze,"P",{"data-svelte-h":!0}),k(Gn)!=="svelte-176h55s"&&(Gn.textContent=Io),mo=r(ze),Vn=p(ze,"P",{"data-svelte-h":!0}),k(Vn)!=="svelte-1hbaqlt"&&(Vn.innerHTML=Zo),uo=r(ze),Bn=p(ze,"P",{"data-svelte-h":!0}),k(Bn)!=="svelte-h9i66j"&&(Bn.innerHTML=qo),ho=r(ze),Rn=p(ze,"P",{"data-svelte-h":!0}),k(Rn)!=="svelte-hswkmf"&&(Rn.innerHTML=Wo),fo=r(ze),Jt=p(ze,"DIV",{class:!0});var Qt=C(Jt);_(_n.$$.fragment,Qt),go=r(Qt),Nn=p(Qt,"P",{"data-svelte-h":!0}),k(Nn)!=="svelte-67f6ky"&&(Nn.innerHTML=Go),_o=r(Qt),_(tn.$$.fragment,Qt),Qt.forEach(i),ze.forEach(i),ao=r(l),_(Tn.$$.fragment,l),ro=r(l),ge=p(l,"DIV",{class:!0});var Fe=C(ge);_(Mn.$$.fragment,Fe),To=r(Fe),Xn=p(Fe,"P",{"data-svelte-h":!0}),k(Xn)!=="svelte-16wnj"&&(Xn.textContent=Vo),Mo=r(Fe),En=p(Fe,"P",{"data-svelte-h":!0}),k(En)!=="svelte-1hbaqlt"&&(En.innerHTML=Bo),bo=r(Fe),Hn=p(Fe,"P",{"data-svelte-h":!0}),k(Hn)!=="svelte-h9i66j"&&(Hn.innerHTML=Ro),yo=r(Fe),Qn=p(Fe,"P",{"data-svelte-h":!0}),k(Qn)!=="svelte-hswkmf"&&(Qn.innerHTML=No),ko=r(Fe),Ut=p(Fe,"DIV",{class:!0});var St=C(Ut);_(bn.$$.fragment,St),wo=r(St),Sn=p(St,"P",{"data-svelte-h":!0}),k(Sn)!=="svelte-1oxicbq"&&(Sn.innerHTML=Xo),vo=r(St),_(nn.$$.fragment,St),St.forEach(i),Fe.forEach(i),lo=r(l),_(yn.$$.fragment,l),io=r(l),_e=p(l,"DIV",{class:!0});var Ie=C(_e);_(kn.$$.fragment,Ie),$o=r(Ie),Ln=p(Ie,"P",{"data-svelte-h":!0}),k(Ln)!=="svelte-1v5r6h0"&&(Ln.innerHTML=Eo),jo=r(Ie),Dn=p(Ie,"P",{"data-svelte-h":!0}),k(Dn)!=="svelte-1hbaqlt"&&(Dn.innerHTML=Ho),xo=r(Ie),An=p(Ie,"P",{"data-svelte-h":!0}),k(An)!=="svelte-h9i66j"&&(An.innerHTML=Qo),Jo=r(Ie),Pn=p(Ie,"P",{"data-svelte-h":!0}),k(Pn)!=="svelte-hswkmf"&&(Pn.innerHTML=So),Uo=r(Ie),Ct=p(Ie,"DIV",{class:!0});var Lt=C(Ct);_(wn.$$.fragment,Lt),Co=r(Lt),Yn=p(Lt,"P",{"data-svelte-h":!0}),k(Yn)!=="svelte-uduvvu"&&(Yn.innerHTML=Lo),zo=r(Lt),_(on.$$.fragment,Lt),Lt.forEach(i),Ie.forEach(i),this.h()},h(){U(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(l,v){T(t,l,v),h(l,f,v),h(l,n,v),T(o,n,null),s(n,m),s(n,e),s(n,Ze),s(n,V),s(n,H),s(n,Q),s(n,S),s(n,Y),s(n,qe),T(L,n,null),s(n,D),s(n,E),T(Z,E,null),s(E,Te),s(E,z),s(E,We),T(N,E,null),s(n,ce),s(n,P),T(G,P,null),s(P,O),s(P,u),s(P,q),T(I,P,null),s(P,pe),T(nt,P,null),s(n,Dt),s(n,ne),T(Pe,ne,null),s(ne,$e),s(ne,Ge),s(ne,_t),s(ne,zt),s(ne,Tt),T(ot,ne,null),h(l,Ft,v),T(je,l,v),h(l,It,v),h(l,J,v),T(xe,J,null),s(J,sn),s(J,Ee),s(J,an),s(J,He),s(J,rn),s(J,me),s(J,ln),s(J,Qe),s(J,dn),T(Je,J,null),s(J,jn),s(J,Ve),T(Me,Ve,null),s(Ve,st),s(Ve,bt),s(Ve,xn),T(Ye,Ve,null),s(J,Oe),s(J,oe),T(at,oe,null),s(oe,yt),s(oe,qt),s(oe,Ke),T(be,oe,null),s(oe,cn),T(Ue,oe,null),s(J,Un),s(J,ye),T(ke,ye,null),s(ye,rt),s(ye,kt),s(ye,Cn),s(ye,lt),s(ye,zn),T(Se,ye,null),h(l,et,v),T(tt,l,v),h(l,se,v),h(l,W,v),T(it,W,null),s(W,vt),s(W,Gt),s(W,$t),s(W,Vt),s(W,Be),s(W,Re),s(W,jt),s(W,Bt),s(W,xt),T(dt,W,null),s(W,pn),s(W,re),T(Ce,re,null),s(re,mn),s(re,Le),s(re,At),T(we,re,null),s(W,Wn),s(W,ue),T(ve,ue,null),s(ue,Pt),s(ue,Ne),s(ue,Rt),T(De,ue,null),s(ue,d),T($,ue,null),s(W,Ae),s(W,R),T(Xe,R,null),s(R,Yt),s(R,ct),s(R,Ot),s(R,he),s(R,Kt),T(en,R,null),h(l,oo,v),T(fn,l,v),h(l,so,v),h(l,fe,v),T(gn,fe,null),s(fe,po),s(fe,Gn),s(fe,mo),s(fe,Vn),s(fe,uo),s(fe,Bn),s(fe,ho),s(fe,Rn),s(fe,fo),s(fe,Jt),T(_n,Jt,null),s(Jt,go),s(Jt,Nn),s(Jt,_o),T(tn,Jt,null),h(l,ao,v),T(Tn,l,v),h(l,ro,v),h(l,ge,v),T(Mn,ge,null),s(ge,To),s(ge,Xn),s(ge,Mo),s(ge,En),s(ge,bo),s(ge,Hn),s(ge,yo),s(ge,Qn),s(ge,ko),s(ge,Ut),T(bn,Ut,null),s(Ut,wo),s(Ut,Sn),s(Ut,vo),T(nn,Ut,null),h(l,lo,v),T(yn,l,v),h(l,io,v),h(l,_e,v),T(kn,_e,null),s(_e,$o),s(_e,Ln),s(_e,jo),s(_e,Dn),s(_e,xo),s(_e,An),s(_e,Jo),s(_e,Pn),s(_e,Uo),s(_e,Ct),T(wn,Ct,null),s(Ct,Co),s(Ct,Yn),s(Ct,zo),T(on,Ct,null),co=!0},p(l,v){const Xt={};v&2&&(Xt.$$scope={dirty:v,ctx:l}),L.$set(Xt);const pt={};v&2&&(pt.$$scope={dirty:v,ctx:l}),N.$set(pt);const mt={};v&2&&(mt.$$scope={dirty:v,ctx:l}),I.$set(mt);const K={};v&2&&(K.$$scope={dirty:v,ctx:l}),nt.$set(K);const Et={};v&2&&(Et.$$scope={dirty:v,ctx:l}),ot.$set(Et);const ut={};v&2&&(ut.$$scope={dirty:v,ctx:l}),Je.$set(ut);const ht={};v&2&&(ht.$$scope={dirty:v,ctx:l}),Ye.$set(ht);const ee={};v&2&&(ee.$$scope={dirty:v,ctx:l}),be.$set(ee);const Ht={};v&2&&(Ht.$$scope={dirty:v,ctx:l}),Ue.$set(Ht);const ft={};v&2&&(ft.$$scope={dirty:v,ctx:l}),Se.$set(ft);const gt={};v&2&&(gt.$$scope={dirty:v,ctx:l}),dt.$set(gt);const ze={};v&2&&(ze.$$scope={dirty:v,ctx:l}),we.$set(ze);const Qt={};v&2&&(Qt.$$scope={dirty:v,ctx:l}),De.$set(Qt);const Fe={};v&2&&(Fe.$$scope={dirty:v,ctx:l}),$.$set(Fe);const St={};v&2&&(St.$$scope={dirty:v,ctx:l}),en.$set(St);const Ie={};v&2&&(Ie.$$scope={dirty:v,ctx:l}),tn.$set(Ie);const Lt={};v&2&&(Lt.$$scope={dirty:v,ctx:l}),nn.$set(Lt);const Do={};v&2&&(Do.$$scope={dirty:v,ctx:l}),on.$set(Do)},i(l){co||(M(t.$$.fragment,l),M(o.$$.fragment,l),M(L.$$.fragment,l),M(Z.$$.fragment,l),M(N.$$.fragment,l),M(G.$$.fragment,l),M(I.$$.fragment,l),M(nt.$$.fragment,l),M(Pe.$$.fragment,l),M(ot.$$.fragment,l),M(je.$$.fragment,l),M(xe.$$.fragment,l),M(Je.$$.fragment,l),M(Me.$$.fragment,l),M(Ye.$$.fragment,l),M(at.$$.fragment,l),M(be.$$.fragment,l),M(Ue.$$.fragment,l),M(ke.$$.fragment,l),M(Se.$$.fragment,l),M(tt.$$.fragment,l),M(it.$$.fragment,l),M(dt.$$.fragment,l),M(Ce.$$.fragment,l),M(we.$$.fragment,l),M(ve.$$.fragment,l),M(De.$$.fragment,l),M($.$$.fragment,l),M(Xe.$$.fragment,l),M(en.$$.fragment,l),M(fn.$$.fragment,l),M(gn.$$.fragment,l),M(_n.$$.fragment,l),M(tn.$$.fragment,l),M(Tn.$$.fragment,l),M(Mn.$$.fragment,l),M(bn.$$.fragment,l),M(nn.$$.fragment,l),M(yn.$$.fragment,l),M(kn.$$.fragment,l),M(wn.$$.fragment,l),M(on.$$.fragment,l),co=!0)},o(l){b(t.$$.fragment,l),b(o.$$.fragment,l),b(L.$$.fragment,l),b(Z.$$.fragment,l),b(N.$$.fragment,l),b(G.$$.fragment,l),b(I.$$.fragment,l),b(nt.$$.fragment,l),b(Pe.$$.fragment,l),b(ot.$$.fragment,l),b(je.$$.fragment,l),b(xe.$$.fragment,l),b(Je.$$.fragment,l),b(Me.$$.fragment,l),b(Ye.$$.fragment,l),b(at.$$.fragment,l),b(be.$$.fragment,l),b(Ue.$$.fragment,l),b(ke.$$.fragment,l),b(Se.$$.fragment,l),b(tt.$$.fragment,l),b(it.$$.fragment,l),b(dt.$$.fragment,l),b(Ce.$$.fragment,l),b(we.$$.fragment,l),b(ve.$$.fragment,l),b(De.$$.fragment,l),b($.$$.fragment,l),b(Xe.$$.fragment,l),b(en.$$.fragment,l),b(fn.$$.fragment,l),b(gn.$$.fragment,l),b(_n.$$.fragment,l),b(tn.$$.fragment,l),b(Tn.$$.fragment,l),b(Mn.$$.fragment,l),b(bn.$$.fragment,l),b(nn.$$.fragment,l),b(yn.$$.fragment,l),b(kn.$$.fragment,l),b(wn.$$.fragment,l),b(on.$$.fragment,l),co=!1},d(l){l&&(i(f),i(n),i(Ft),i(It),i(J),i(et),i(se),i(W),i(oo),i(so),i(fe),i(ao),i(ro),i(ge),i(lo),i(io),i(_e)),y(t,l),y(o),y(L),y(Z),y(N),y(G),y(I),y(nt),y(Pe),y(ot),y(je,l),y(xe),y(Je),y(Me),y(Ye),y(at),y(be),y(Ue),y(ke),y(Se),y(tt,l),y(it),y(dt),y(Ce),y(we),y(ve),y(De),y($),y(Xe),y(en),y(fn,l),y(gn),y(_n),y(tn),y(Tn,l),y(Mn),y(bn),y(nn),y(yn,l),y(kn),y(wn),y(on)}}}function ys(j){let t,f;return t=new Fo({props:{$$slots:{default:[bs]},$$scope:{ctx:j}}}),{c(){g(t.$$.fragment)},l(n){_(t.$$.fragment,n)},m(n,o){T(t,n,o),f=!0},p(n,o){const m={};o&2&&(m.$$scope={dirty:o,ctx:n}),t.$set(m)},i(n){f||(M(t.$$.fragment,n),f=!0)},o(n){b(t.$$.fragment,n),f=!1},d(n){y(t,n)}}}function ks(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGTVQ1TW9kZWwlMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBURk1UNU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQWFydGljbGUlMjAlM0QlMjAlMjJVTiUyME9mZml6aWVyJTIwc2FndCUyQyUyMGRhc3MlMjB3ZWl0ZXIlMjB2ZXJoYW5kZWx0JTIwd2VyZGVuJTIwbXVzcyUyMGluJTIwU3lyaWVuLiUyMiUwQXN1bW1hcnklMjAlM0QlMjAlMjJXZWl0ZXIlMjBWZXJoYW5kbHVuZyUyMGluJTIwU3lyaWVuLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihhcnRpY2xlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIodGV4dF90YXJnZXQlM0RzdW1tYXJ5JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZGVjb2Rlcl9pbnB1dF9pZHMlM0RsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFMT5Model, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFMT5Model.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], decoder_input_ids=labels[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function ws(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGTVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwVEZNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBYXJ0aWNsZSUyMCUzRCUyMCUyMlVOJTIwT2ZmaXppZXIlMjBzYWd0JTJDJTIwZGFzcyUyMHdlaXRlciUyMHZlcmhhbmRlbHQlMjB3ZXJkZW4lMjBtdXNzJTIwaW4lMjBTeXJpZW4uJTIyJTBBc3VtbWFyeSUyMCUzRCUyMCUyMldlaXRlciUyMFZlcmhhbmRsdW5nJTIwaW4lMjBTeXJpZW4uJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjB0ZXh0X3RhcmdldCUzRHN1bW1hcnklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFMT5ForConditionalGeneration, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFMT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, text_target=summary, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function vs(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGTVQ1RW5jb2Rlck1vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwVEZNVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBYXJ0aWNsZSUyMCUzRCUyMCUyMlVOJTIwT2ZmaXppZXIlMjBzYWd0JTJDJTIwZGFzcyUyMHdlaXRlciUyMHZlcmhhbmRlbHQlMjB3ZXJkZW4lMjBtdXNzJTIwaW4lMjBTeXJpZW4uJTIyJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKS5pbnB1dF9pZHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKSUwQWhpZGRlbl9zdGF0ZSUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFMT5EncoderModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFMT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(article, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function $s(j){let t,f,n,o,m,e,w=`This class overrides <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a>. Please check the superclass for the appropriate documentation alongside usage
examples.`,Ze,V,te,H,Q,B,S,Y,ae,qe=`This class overrides <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a>. Please check the superclass for the appropriate
documentation alongside usage examples.`,L,D,E,Z,Te,z,X,We,N,ce=`This class overrides <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.TFT5EncoderModel">TFT5EncoderModel</a>. Please check the superclass for the appropriate documentation alongside
usage examples.`,P,G,O;return t=new ie({props:{title:"TFMT5Model",local:"transformers.TFMT5Model",headingTag:"h2"}}),o=new F({props:{name:"class transformers.TFMT5Model",anchor:"transformers.TFMT5Model",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_tf_mt5.py#L27"}}),V=new le({props:{anchor:"transformers.TFMT5Model.example",$$slots:{default:[ks]},$$scope:{ctx:j}}}),H=new ie({props:{title:"TFMT5ForConditionalGeneration",local:"transformers.TFMT5ForConditionalGeneration",headingTag:"h2"}}),S=new F({props:{name:"class transformers.TFMT5ForConditionalGeneration",anchor:"transformers.TFMT5ForConditionalGeneration",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_tf_mt5.py#L52"}}),D=new le({props:{anchor:"transformers.TFMT5ForConditionalGeneration.example",$$slots:{default:[ws]},$$scope:{ctx:j}}}),Z=new ie({props:{title:"TFMT5EncoderModel",local:"transformers.TFMT5EncoderModel",headingTag:"h2"}}),X=new F({props:{name:"class transformers.TFMT5EncoderModel",anchor:"transformers.TFMT5EncoderModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_tf_mt5.py#L76"}}),G=new le({props:{anchor:"transformers.TFMT5EncoderModel.example",$$slots:{default:[vs]},$$scope:{ctx:j}}}),{c(){g(t.$$.fragment),f=a(),n=c("div"),g(o.$$.fragment),m=a(),e=c("p"),e.innerHTML=w,Ze=a(),g(V.$$.fragment),te=a(),g(H.$$.fragment),Q=a(),B=c("div"),g(S.$$.fragment),Y=a(),ae=c("p"),ae.innerHTML=qe,L=a(),g(D.$$.fragment),E=a(),g(Z.$$.fragment),Te=a(),z=c("div"),g(X.$$.fragment),We=a(),N=c("p"),N.innerHTML=ce,P=a(),g(G.$$.fragment),this.h()},l(u){_(t.$$.fragment,u),f=r(u),n=p(u,"DIV",{class:!0});var x=C(n);_(o.$$.fragment,x),m=r(x),e=p(x,"P",{"data-svelte-h":!0}),k(e)!=="svelte-165t0k3"&&(e.innerHTML=w),Ze=r(x),_(V.$$.fragment,x),x.forEach(i),te=r(u),_(H.$$.fragment,u),Q=r(u),B=p(u,"DIV",{class:!0});var q=C(B);_(S.$$.fragment,q),Y=r(q),ae=p(q,"P",{"data-svelte-h":!0}),k(ae)!=="svelte-5wkp0f"&&(ae.innerHTML=qe),L=r(q),_(D.$$.fragment,q),q.forEach(i),E=r(u),_(Z.$$.fragment,u),Te=r(u),z=p(u,"DIV",{class:!0});var I=C(z);_(X.$$.fragment,I),We=r(I),N=p(I,"P",{"data-svelte-h":!0}),k(N)!=="svelte-zrmexz"&&(N.innerHTML=ce),P=r(I),_(G.$$.fragment,I),I.forEach(i),this.h()},h(){U(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(u,x){T(t,u,x),h(u,f,x),h(u,n,x),T(o,n,null),s(n,m),s(n,e),s(n,Ze),T(V,n,null),h(u,te,x),T(H,u,x),h(u,Q,x),h(u,B,x),T(S,B,null),s(B,Y),s(B,ae),s(B,L),T(D,B,null),h(u,E,x),T(Z,u,x),h(u,Te,x),h(u,z,x),T(X,z,null),s(z,We),s(z,N),s(z,P),T(G,z,null),O=!0},p(u,x){const q={};x&2&&(q.$$scope={dirty:x,ctx:u}),V.$set(q);const I={};x&2&&(I.$$scope={dirty:x,ctx:u}),D.$set(I);const pe={};x&2&&(pe.$$scope={dirty:x,ctx:u}),G.$set(pe)},i(u){O||(M(t.$$.fragment,u),M(o.$$.fragment,u),M(V.$$.fragment,u),M(H.$$.fragment,u),M(S.$$.fragment,u),M(D.$$.fragment,u),M(Z.$$.fragment,u),M(X.$$.fragment,u),M(G.$$.fragment,u),O=!0)},o(u){b(t.$$.fragment,u),b(o.$$.fragment,u),b(V.$$.fragment,u),b(H.$$.fragment,u),b(S.$$.fragment,u),b(D.$$.fragment,u),b(Z.$$.fragment,u),b(X.$$.fragment,u),b(G.$$.fragment,u),O=!1},d(u){u&&(i(f),i(n),i(te),i(Q),i(B),i(E),i(Te),i(z)),y(t,u),y(o),y(V),y(H,u),y(S),y(D),y(Z,u),y(X),y(G)}}}function js(j){let t,f;return t=new Fo({props:{$$slots:{default:[$s]},$$scope:{ctx:j}}}),{c(){g(t.$$.fragment)},l(n){_(t.$$.fragment,n)},m(n,o){T(t,n,o),f=!0},p(n,o){const m={};o&2&&(m.$$scope={dirty:o,ctx:n}),t.$set(m)},i(n){f||(M(t.$$.fragment,n),f=!0)},o(n){b(t.$$.fragment,n),f=!1},d(n){y(t,n)}}}function xs(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZsYXhNVDVNb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyMEZsYXhNVDVNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEElMEFhcnRpY2xlJTIwJTNEJTIwJTIyVU4lMjBPZmZpemllciUyMHNhZ3QlMkMlMjBkYXNzJTIwd2VpdGVyJTIwdmVyaGFuZGVsdCUyMHdlcmRlbiUyMG11c3MlMjBpbiUyMFN5cmllbi4lMjIlMEFzdW1tYXJ5JTIwJTNEJTIwJTIyV2VpdGVyJTIwVmVyaGFuZGx1bmclMjBpbiUyMFN5cmllbi4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoYXJ0aWNsZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIodGV4dF90YXJnZXQlM0RzdW1tYXJ5JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMikuaW5wdXRfaWRzJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpJTBBaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FlaxMT5Model, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxMT5Model.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function Js(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZsYXhNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBGbGF4TVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQSUwQWFydGljbGUlMjAlM0QlMjAlMjJVTiUyME9mZml6aWVyJTIwc2FndCUyQyUyMGRhc3MlMjB3ZWl0ZXIlMjB2ZXJoYW5kZWx0JTIwd2VyZGVuJTIwbXVzcyUyMGluJTIwU3lyaWVuLiUyMiUwQXN1bW1hcnklMjAlM0QlMjAlMjJXZWl0ZXIlMjBWZXJoYW5kbHVuZyUyMGluJTIwU3lyaWVuLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihhcnRpY2xlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcih0ZXh0X3RhcmdldCUzRHN1bW1hcnklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKS5pbnB1dF9pZHMlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FlaxMT5ForConditionalGeneration, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxMT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function Us(j){let t,f="Examples:",n,o,m;return o=new de({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZsYXhUNUVuY29kZXJNb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyMEZsYXhUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEElMEFhcnRpY2xlJTIwJTNEJTIwJTIyVU4lMjBPZmZpemllciUyMHNhZ3QlMkMlMjBkYXNzJTIwd2VpdGVyJTIwdmVyaGFuZGVsdCUyMHdlcmRlbiUyMG11c3MlMjBpbiUyMFN5cmllbi4lMjIlMEFzdW1tYXJ5JTIwJTNEJTIwJTIyV2VpdGVyJTIwVmVyaGFuZGx1bmclMjBpbiUyMFN5cmllbi4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoYXJ0aWNsZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIodGV4dF90YXJnZXQlM0RzdW1tYXJ5JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMikuaW5wdXRfaWRzJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFoaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FlaxT5EncoderModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=p(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){h(e,t,w),h(e,n,w),T(o,e,w),m=!0},p:A,i(e){m||(M(o.$$.fragment,e),m=!0)},o(e){b(o.$$.fragment,e),m=!1},d(e){e&&(i(t),i(n)),y(o,e)}}}function Cs(j){let t,f,n,o,m,e,w=`This class overrides <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.FlaxT5Model">FlaxT5Model</a>. Please check the superclass for the appropriate documentation alongside usage
examples.`,Ze,V,te,H,Q,B,S,Y,ae,qe=`This class overrides <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a>. Please check the superclass for the appropriate
documentation alongside usage examples.`,L,D,E,Z,Te,z,X,We,N,ce=`This class overrides <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.FlaxT5EncoderModel">FlaxT5EncoderModel</a>. Please check the superclass for the appropriate documentation
alongside usage examples.`,P,G,O;return t=new ie({props:{title:"FlaxMT5Model",local:"transformers.FlaxMT5Model",headingTag:"h2"}}),o=new F({props:{name:"class transformers.FlaxMT5Model",anchor:"transformers.FlaxMT5Model",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_flax_mt5.py#L42"}}),V=new le({props:{anchor:"transformers.FlaxMT5Model.example",$$slots:{default:[xs]},$$scope:{ctx:j}}}),H=new ie({props:{title:"FlaxMT5ForConditionalGeneration",local:"transformers.FlaxMT5ForConditionalGeneration",headingTag:"h2"}}),S=new F({props:{name:"class transformers.FlaxMT5ForConditionalGeneration",anchor:"transformers.FlaxMT5ForConditionalGeneration",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_flax_mt5.py#L96"}}),D=new le({props:{anchor:"transformers.FlaxMT5ForConditionalGeneration.example",$$slots:{default:[Js]},$$scope:{ctx:j}}}),Z=new ie({props:{title:"FlaxMT5EncoderModel",local:"transformers.FlaxMT5EncoderModel",headingTag:"h2"}}),X=new F({props:{name:"class transformers.FlaxMT5EncoderModel",anchor:"transformers.FlaxMT5EncoderModel",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": Tuple = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/modeling_flax_mt5.py#L69"}}),G=new le({props:{anchor:"transformers.FlaxMT5EncoderModel.example",$$slots:{default:[Us]},$$scope:{ctx:j}}}),{c(){g(t.$$.fragment),f=a(),n=c("div"),g(o.$$.fragment),m=a(),e=c("p"),e.innerHTML=w,Ze=a(),g(V.$$.fragment),te=a(),g(H.$$.fragment),Q=a(),B=c("div"),g(S.$$.fragment),Y=a(),ae=c("p"),ae.innerHTML=qe,L=a(),g(D.$$.fragment),E=a(),g(Z.$$.fragment),Te=a(),z=c("div"),g(X.$$.fragment),We=a(),N=c("p"),N.innerHTML=ce,P=a(),g(G.$$.fragment),this.h()},l(u){_(t.$$.fragment,u),f=r(u),n=p(u,"DIV",{class:!0});var x=C(n);_(o.$$.fragment,x),m=r(x),e=p(x,"P",{"data-svelte-h":!0}),k(e)!=="svelte-1i4sz17"&&(e.innerHTML=w),Ze=r(x),_(V.$$.fragment,x),x.forEach(i),te=r(u),_(H.$$.fragment,u),Q=r(u),B=p(u,"DIV",{class:!0});var q=C(B);_(S.$$.fragment,q),Y=r(q),ae=p(q,"P",{"data-svelte-h":!0}),k(ae)!=="svelte-16ldrjp"&&(ae.innerHTML=qe),L=r(q),_(D.$$.fragment,q),q.forEach(i),E=r(u),_(Z.$$.fragment,u),Te=r(u),z=p(u,"DIV",{class:!0});var I=C(z);_(X.$$.fragment,I),We=r(I),N=p(I,"P",{"data-svelte-h":!0}),k(N)!=="svelte-1lupy9d"&&(N.innerHTML=ce),P=r(I),_(G.$$.fragment,I),I.forEach(i),this.h()},h(){U(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(u,x){T(t,u,x),h(u,f,x),h(u,n,x),T(o,n,null),s(n,m),s(n,e),s(n,Ze),T(V,n,null),h(u,te,x),T(H,u,x),h(u,Q,x),h(u,B,x),T(S,B,null),s(B,Y),s(B,ae),s(B,L),T(D,B,null),h(u,E,x),T(Z,u,x),h(u,Te,x),h(u,z,x),T(X,z,null),s(z,We),s(z,N),s(z,P),T(G,z,null),O=!0},p(u,x){const q={};x&2&&(q.$$scope={dirty:x,ctx:u}),V.$set(q);const I={};x&2&&(I.$$scope={dirty:x,ctx:u}),D.$set(I);const pe={};x&2&&(pe.$$scope={dirty:x,ctx:u}),G.$set(pe)},i(u){O||(M(t.$$.fragment,u),M(o.$$.fragment,u),M(V.$$.fragment,u),M(H.$$.fragment,u),M(S.$$.fragment,u),M(D.$$.fragment,u),M(Z.$$.fragment,u),M(X.$$.fragment,u),M(G.$$.fragment,u),O=!0)},o(u){b(t.$$.fragment,u),b(o.$$.fragment,u),b(V.$$.fragment,u),b(H.$$.fragment,u),b(S.$$.fragment,u),b(D.$$.fragment,u),b(Z.$$.fragment,u),b(X.$$.fragment,u),b(G.$$.fragment,u),O=!1},d(u){u&&(i(f),i(n),i(te),i(Q),i(B),i(E),i(Te),i(z)),y(t,u),y(o),y(V),y(H,u),y(S),y(D),y(Z,u),y(X),y(G)}}}function zs(j){let t,f;return t=new Fo({props:{$$slots:{default:[Cs]},$$scope:{ctx:j}}}),{c(){g(t.$$.fragment)},l(n){_(t.$$.fragment,n)},m(n,o){T(t,n,o),f=!0},p(n,o){const m={};o&2&&(m.$$scope={dirty:o,ctx:n}),t.$set(m)},i(n){f||(M(t.$$.fragment,n),f=!0)},o(n){b(t.$$.fragment,n),f=!1},d(n){y(t,n)}}}function Fs(j){let t,f,n,o,m,e,w,Ze='<a href="https://huggingface.co/models?filter=mt5"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-mt5-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/mt5-small-finetuned-arxiv-cs-finetuned-arxiv-cs-full"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',V,te,H,Q,B=`The mT5 model was presented in <a href="https://arxiv.org/abs/2010.11934" rel="nofollow">mT5: A massively multilingual pre-trained text-to-text transformer</a> by Linting Xue, Noah Constant, Adam Roberts, Mihir Kale, Rami Al-Rfou, Aditya
Siddhant, Aditya Barua, Colin Raffel.`,S,Y,ae="The abstract from the paper is the following:",qe,L,D=`<em>The recent “Text-to-Text Transfer Transformer” (T5) leveraged a unified text-to-text format and scale to attain
state-of-the-art results on a wide variety of English-language NLP tasks. In this paper, we introduce mT5, a
multilingual variant of T5 that was pre-trained on a new Common Crawl-based dataset covering 101 languages. We detail
the design and modified training of mT5 and demonstrate its state-of-the-art performance on many multilingual
benchmarks. We also describe a simple technique to prevent “accidental translation” in the zero-shot setting, where a
generative model chooses to (partially) translate its prediction into the wrong language. All of the code and model
checkpoints used in this work are publicly available.</em>`,E,Z,Te=`Note: mT5 was only pre-trained on <a href="https://huggingface.co/datasets/mc4" rel="nofollow">mC4</a> excluding any supervised training.
Therefore, this model has to be fine-tuned before it is usable on a downstream task, unlike the original T5 model.
Since mT5 was pre-trained unsupervisedly, there’s no real advantage to using a task prefix during single-task
fine-tuning. If you are doing multi-task fine-tuning, you should use a prefix.`,z,X,We="Google has released the following variants:",N,ce,P='<li><p><a href="https://huggingface.co/google/mt5-small" rel="nofollow">google/mt5-small</a></p></li> <li><p><a href="https://huggingface.co/google/mt5-base" rel="nofollow">google/mt5-base</a></p></li> <li><p><a href="https://huggingface.co/google/mt5-large" rel="nofollow">google/mt5-large</a></p></li> <li><p><a href="https://huggingface.co/google/mt5-xl" rel="nofollow">google/mt5-xl</a></p></li> <li><p><a href="https://huggingface.co/google/mt5-xxl" rel="nofollow">google/mt5-xxl</a>.</p></li>',G,O,u=`This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>. The original code can be
found <a href="https://github.com/google-research/multilingual-t5" rel="nofollow">here</a>.`,x,q,I,pe,nt='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',Dt,ne,Pe,$e,Ge,vn,_t,zt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> or a <a href="/docs/transformers/pr_30954/en/model_doc/mt5#transformers.TFMT5Model">TFMT5Model</a>. It is used to
instantiate a mT5 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the mT5
<a href="https://huggingface.co/google/mt5-small" rel="nofollow">google/mt5-small</a> architecture.`,$n,Tt,ot=`Configuration objects inherit from <a href="/docs/transformers/pr_30954/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30954/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ft,je,It,J,xe,sn,Ee,Kn='Construct a T5 tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',an,He,eo=`This tokenizer inherits from <a href="/docs/transformers/pr_30954/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,rn,me,Mt,ln,Qe,to=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A sequence has the following format:`,dn,Je,jn="<li>single sequence: <code>X &lt;/s&gt;</code></li> <li>pair of sequences: <code>A &lt;/s&gt; B &lt;/s&gt;</code></li>",Ve,Me,st,bt,Zt,xn="Converts a sequence of tokens (string) in a single string.",Ye,Oe,oe,at,yt,qt=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. T5 does not make
use of token type ids, therefore a list of zeros is returned.`,Jn,Ke,be,cn,Ue,Un=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,ye,ke,rt,kt,Wt,Cn=`Converts a string to a list of tokens. If <code>self.legacy</code> is set to <code>False</code>, a prefix token is added unless the
first token is special.`,lt,wt,zn='See <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a> for all details.',Se,et,tt,se,W,it,vt,Gt=`Construct a “fast” T5 tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on
<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html?highlight=unigram#models" rel="nofollow">Unigram</a>.`,Fn,$t,Vt=`This tokenizer inherits from <a href="/docs/transformers/pr_30954/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,In,Be,Re,Zn,jt,Bt=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A sequence has the following format:`,qn,xt,dt="<li>single sequence: <code>X &lt;/s&gt;</code></li> <li>pair of sequences: <code>A &lt;/s&gt; B &lt;/s&gt;</code></li>",pn,re,Ce,mn,Le,no=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. T5 does not make
use of token type ids, therefore a list of zeros is returned.`,At,we,Wn='See <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.T5TokenizerFast">T5TokenizerFast</a> for all details.',ue,ve,Pt,Ne,un,Rt,De;return m=new ie({props:{title:"mT5",local:"mt5",headingTag:"h1"}}),te=new ie({props:{title:"Overview",local:"overview",headingTag:"h2"}}),q=new ie({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ne=new ie({props:{title:"MT5Config",local:"transformers.MT5Config",headingTag:"h2"}}),Ge=new F({props:{name:"class transformers.MT5Config",anchor:"transformers.MT5Config",parameters:[{name:"vocab_size",val:" = 250112"},{name:"d_model",val:" = 512"},{name:"d_kv",val:" = 64"},{name:"d_ff",val:" = 1024"},{name:"num_layers",val:" = 8"},{name:"num_decoder_layers",val:" = None"},{name:"num_heads",val:" = 6"},{name:"relative_attention_num_buckets",val:" = 32"},{name:"relative_attention_max_distance",val:" = 128"},{name:"dropout_rate",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"initializer_factor",val:" = 1.0"},{name:"feed_forward_proj",val:" = 'gated-gelu'"},{name:"is_encoder_decoder",val:" = True"},{name:"use_cache",val:" = True"},{name:"tokenizer_class",val:" = 'T5Tokenizer'"},{name:"tie_word_embeddings",val:" = False"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"decoder_start_token_id",val:" = 0"},{name:"classifier_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MT5Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 250112) &#x2014;
Vocabulary size of the T5 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.T5Model">T5Model</a> or <a href="/docs/transformers/pr_30954/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a>.`,name:"vocab_size"},{anchor:"transformers.MT5Config.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.MT5Config.d_kv",description:`<strong>d_kv</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the key, query, value projections per attention head. In the conventional context, it is typically expected that <code>d_kv</code> has to be equal to <code>d_model // num_heads</code>.
But in the architecture of mt5-small, <code>d_kv</code> is not equal to <code>d_model //num_heads</code>. The <code>inner_dim</code> of the projection layer will be defined as <code>num_heads * d_kv</code>.`,name:"d_kv"},{anchor:"transformers.MT5Config.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the intermediate feed forward layer in each <code>T5Block</code>.`,name:"d_ff"},{anchor:"transformers.MT5Config.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_layers"},{anchor:"transformers.MT5Config.num_decoder_layers",description:`<strong>num_decoder_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of hidden layers in the Transformer decoder. Will use the same value as <code>num_layers</code> if not set.`,name:"num_decoder_layers"},{anchor:"transformers.MT5Config.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.MT5Config.relative_attention_num_buckets",description:`<strong>relative_attention_num_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of buckets to use for each attention layer.`,name:"relative_attention_num_buckets"},{anchor:"transformers.MT5Config.relative_attention_max_distance",description:`<strong>relative_attention_max_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The maximum distance of the longer sequences for the bucket separation.`,name:"relative_attention_max_distance"},{anchor:"transformers.MT5Config.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.MT5Config.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for classifier.`,name:"classifier_dropout"},{anchor:"transformers.MT5Config.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.MT5Config.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.MT5Config.feed_forward_proj",description:`<strong>feed_forward_proj</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;gated-gelu&quot;</code>) &#x2014;
Type of feed forward layer to be used. Should be one of <code>&quot;relu&quot;</code> or <code>&quot;gated-gelu&quot;</code>.`,name:"feed_forward_proj"},{anchor:"transformers.MT5Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/mt5/configuration_mt5.py#L27"}}),je=new ie({props:{title:"MT5Tokenizer",local:"transformers.T5Tokenizer",headingTag:"h2"}}),xe=new F({props:{name:"class transformers.T5Tokenizer",anchor:"transformers.T5Tokenizer",parameters:[{name:"vocab_file",val:""},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"extra_ids",val:" = 100"},{name:"additional_special_tokens",val:" = None"},{name:"sp_model_kwargs",val:": Optional = None"},{name:"legacy",val:" = None"},{name:"add_prefix_space",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.T5Tokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.T5Tokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.T5Tokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.T5Tokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.T5Tokenizer.extra_ids",description:`<strong>extra_ids</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Add a number of extra ids added to the vocabulary for use as sentinels. These tokens are
accessible as &#x201C;<extra<em>id{%d}&gt;&#x201D; where &#x201D;{%d}&#x201D; is a number between 0 and extra_ids-1. These tokens can be
retrieved by calling get_sentinel_tokens method and token ids can be by calling get_sentinel_token_ids
method
additional_special_tokens (<code>List[str]</code>, <em>optional</em>):
Additional special tokens used by the tokenizer.</extra<em>`,name:"extra_ids"},{anchor:"transformers.T5Tokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.T5Tokenizer.legacy",description:`<strong>legacy</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the <code>legacy</code> behaviour of the tokenizer should be used. Legacy is before the merge of #24622
and #25224 which includes fixes to properly handle tokens that appear after special tokens. A simple
example:</p>
<ul>
<li><code>legacy=True</code>:</li>
</ul>`,name:"legacy"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5.py#L45"}}),Mt=new F({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.T5Tokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.T5Tokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.T5Tokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5.py#L319",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),st=new F({props:{name:"convert_tokens_to_string",anchor:"transformers.T5Tokenizer.convert_tokens_to_string",parameters:[{name:"tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5.py#L409"}}),oe=new F({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.T5Tokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.T5Tokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.T5Tokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5.py#L297",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),be=new F({props:{name:"get_special_tokens_mask",anchor:"transformers.T5Tokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.T5Tokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.T5Tokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.T5Tokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5.py#L250",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),rt=new F({props:{name:"tokenize",anchor:"transformers.T5Tokenizer.tokenize",parameters:[{name:"text",val:": TextInput"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5.py#L360"}}),et=new ie({props:{title:"MT5TokenizerFast",local:"transformers.T5TokenizerFast",headingTag:"h2"}}),W=new F({props:{name:"class transformers.T5TokenizerFast",anchor:"transformers.T5TokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"extra_ids",val:" = 100"},{name:"additional_special_tokens",val:" = None"},{name:"add_prefix_space",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.T5TokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.T5TokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.T5TokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.T5TokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.T5TokenizerFast.extra_ids",description:`<strong>extra_ids</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Add a number of extra ids added to the vocabulary for use as sentinels. These tokens are accessible as
&#x201C;<extra<em>id{%d}&gt;&#x201D; where &#x201D;{%d}&#x201D; is a number between 0 and extra_ids-1. These tokens can be retrieved by
calling get_sentinel_tokens method and token ids can be by calling get_sentinel_token_ids method</extra<em>`,name:"extra_ids"},{anchor:"transformers.T5TokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.T5TokenizerFast.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the tokenizer should automatically add a prefix space`,name:"add_prefix_space"},{anchor:"transformers.T5TokenizerFast.from_slow",description:`<strong>from_slow</strong> (<code>book</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the tokenizer should be converted from a slow one. If <code>add_prefix_space</code> is set, this will be set to <code>True</code>.`,name:"from_slow"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5_fast.py#L41"}}),Re=new F({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.T5TokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.T5TokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.T5TokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5_fast.py#L179",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ce=new F({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.T5TokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.T5TokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.T5TokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30954/src/transformers/models/t5/tokenization_t5_fast.py#L205",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ve=new es({props:{pytorch:!0,tensorflow:!0,jax:!0,$$slots:{jax:[zs],tensorflow:[js],pytorch:[ys]},$$scope:{ctx:j}}}),Ne=new ts({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mt5.md"}}),{c(){t=c("meta"),f=a(),n=c("p"),o=a(),g(m.$$.fragment),e=a(),w=c("div"),w.innerHTML=Ze,V=a(),g(te.$$.fragment),H=a(),Q=c("p"),Q.innerHTML=B,S=a(),Y=c("p"),Y.textContent=ae,qe=a(),L=c("p"),L.innerHTML=D,E=a(),Z=c("p"),Z.innerHTML=Te,z=a(),X=c("p"),X.textContent=We,N=a(),ce=c("ul"),ce.innerHTML=P,G=a(),O=c("p"),O.innerHTML=u,x=a(),g(q.$$.fragment),I=a(),pe=c("ul"),pe.innerHTML=nt,Dt=a(),g(ne.$$.fragment),Pe=a(),$e=c("div"),g(Ge.$$.fragment),vn=a(),_t=c("p"),_t.innerHTML=zt,$n=a(),Tt=c("p"),Tt.innerHTML=ot,Ft=a(),g(je.$$.fragment),It=a(),J=c("div"),g(xe.$$.fragment),sn=a(),Ee=c("p"),Ee.innerHTML=Kn,an=a(),He=c("p"),He.innerHTML=eo,rn=a(),me=c("div"),g(Mt.$$.fragment),ln=a(),Qe=c("p"),Qe.textContent=to,dn=a(),Je=c("ul"),Je.innerHTML=jn,Ve=a(),Me=c("div"),g(st.$$.fragment),bt=a(),Zt=c("p"),Zt.textContent=xn,Ye=a(),Oe=c("div"),g(oe.$$.fragment),at=a(),yt=c("p"),yt.textContent=qt,Jn=a(),Ke=c("div"),g(be.$$.fragment),cn=a(),Ue=c("p"),Ue.innerHTML=Un,ye=a(),ke=c("div"),g(rt.$$.fragment),kt=a(),Wt=c("p"),Wt.innerHTML=Cn,lt=a(),wt=c("p"),wt.innerHTML=zn,Se=a(),g(et.$$.fragment),tt=a(),se=c("div"),g(W.$$.fragment),it=a(),vt=c("p"),vt.innerHTML=Gt,Fn=a(),$t=c("p"),$t.innerHTML=Vt,In=a(),Be=c("div"),g(Re.$$.fragment),Zn=a(),jt=c("p"),jt.textContent=Bt,qn=a(),xt=c("ul"),xt.innerHTML=dt,pn=a(),re=c("div"),g(Ce.$$.fragment),mn=a(),Le=c("p"),Le.textContent=no,At=a(),we=c("p"),we.innerHTML=Wn,ue=a(),g(ve.$$.fragment),Pt=a(),g(Ne.$$.fragment),un=a(),Rt=c("p"),this.h()},l(d){const $=Ko("svelte-u9bgzb",document.head);t=p($,"META",{name:!0,content:!0}),$.forEach(i),f=r(d),n=p(d,"P",{}),C(n).forEach(i),o=r(d),_(m.$$.fragment,d),e=r(d),w=p(d,"DIV",{class:!0,"data-svelte-h":!0}),k(w)!=="svelte-1ts56sn"&&(w.innerHTML=Ze),V=r(d),_(te.$$.fragment,d),H=r(d),Q=p(d,"P",{"data-svelte-h":!0}),k(Q)!=="svelte-1roqcuv"&&(Q.innerHTML=B),S=r(d),Y=p(d,"P",{"data-svelte-h":!0}),k(Y)!=="svelte-vfdo9a"&&(Y.textContent=ae),qe=r(d),L=p(d,"P",{"data-svelte-h":!0}),k(L)!=="svelte-zubcnw"&&(L.innerHTML=D),E=r(d),Z=p(d,"P",{"data-svelte-h":!0}),k(Z)!=="svelte-k2hj4w"&&(Z.innerHTML=Te),z=r(d),X=p(d,"P",{"data-svelte-h":!0}),k(X)!=="svelte-1p0jqca"&&(X.textContent=We),N=r(d),ce=p(d,"UL",{"data-svelte-h":!0}),k(ce)!=="svelte-1w0nbyl"&&(ce.innerHTML=P),G=r(d),O=p(d,"P",{"data-svelte-h":!0}),k(O)!=="svelte-1lbi4r5"&&(O.innerHTML=u),x=r(d),_(q.$$.fragment,d),I=r(d),pe=p(d,"UL",{"data-svelte-h":!0}),k(pe)!=="svelte-6ej6p2"&&(pe.innerHTML=nt),Dt=r(d),_(ne.$$.fragment,d),Pe=r(d),$e=p(d,"DIV",{class:!0});var Ae=C($e);_(Ge.$$.fragment,Ae),vn=r(Ae),_t=p(Ae,"P",{"data-svelte-h":!0}),k(_t)!=="svelte-1etr7o8"&&(_t.innerHTML=zt),$n=r(Ae),Tt=p(Ae,"P",{"data-svelte-h":!0}),k(Tt)!=="svelte-14mbcdn"&&(Tt.innerHTML=ot),Ae.forEach(i),Ft=r(d),_(je.$$.fragment,d),It=r(d),J=p(d,"DIV",{class:!0});var R=C(J);_(xe.$$.fragment,R),sn=r(R),Ee=p(R,"P",{"data-svelte-h":!0}),k(Ee)!=="svelte-pdnetr"&&(Ee.innerHTML=Kn),an=r(R),He=p(R,"P",{"data-svelte-h":!0}),k(He)!=="svelte-w9rjsd"&&(He.innerHTML=eo),rn=r(R),me=p(R,"DIV",{class:!0});var Xe=C(me);_(Mt.$$.fragment,Xe),ln=r(Xe),Qe=p(Xe,"P",{"data-svelte-h":!0}),k(Qe)!=="svelte-1wjq39d"&&(Qe.textContent=to),dn=r(Xe),Je=p(Xe,"UL",{"data-svelte-h":!0}),k(Je)!=="svelte-8gh3n2"&&(Je.innerHTML=jn),Xe.forEach(i),Ve=r(R),Me=p(R,"DIV",{class:!0});var Yt=C(Me);_(st.$$.fragment,Yt),bt=r(Yt),Zt=p(Yt,"P",{"data-svelte-h":!0}),k(Zt)!=="svelte-b3k2yi"&&(Zt.textContent=xn),Yt.forEach(i),Ye=r(R),Oe=p(R,"DIV",{class:!0});var ct=C(Oe);_(oe.$$.fragment,ct),at=r(ct),yt=p(ct,"P",{"data-svelte-h":!0}),k(yt)!=="svelte-fl5ab0"&&(yt.textContent=qt),ct.forEach(i),Jn=r(R),Ke=p(R,"DIV",{class:!0});var hn=C(Ke);_(be.$$.fragment,hn),cn=r(hn),Ue=p(hn,"P",{"data-svelte-h":!0}),k(Ue)!=="svelte-1f4f5kp"&&(Ue.innerHTML=Un),hn.forEach(i),ye=r(R),ke=p(R,"DIV",{class:!0});var Ot=C(ke);_(rt.$$.fragment,Ot),kt=r(Ot),Wt=p(Ot,"P",{"data-svelte-h":!0}),k(Wt)!=="svelte-zc6zc"&&(Wt.innerHTML=Cn),Ot.forEach(i),R.forEach(i),lt=r(d),wt=p(d,"P",{"data-svelte-h":!0}),k(wt)!=="svelte-278xt4"&&(wt.innerHTML=zn),Se=r(d),_(et.$$.fragment,d),tt=r(d),se=p(d,"DIV",{class:!0});var he=C(se);_(W.$$.fragment,he),it=r(he),vt=p(he,"P",{"data-svelte-h":!0}),k(vt)!=="svelte-gc3mz8"&&(vt.innerHTML=Gt),Fn=r(he),$t=p(he,"P",{"data-svelte-h":!0}),k($t)!=="svelte-13iarjl"&&($t.innerHTML=Vt),In=r(he),Be=p(he,"DIV",{class:!0});var Nt=C(Be);_(Re.$$.fragment,Nt),Zn=r(Nt),jt=p(Nt,"P",{"data-svelte-h":!0}),k(jt)!=="svelte-1wjq39d"&&(jt.textContent=Bt),qn=r(Nt),xt=p(Nt,"UL",{"data-svelte-h":!0}),k(xt)!=="svelte-8gh3n2"&&(xt.innerHTML=dt),Nt.forEach(i),pn=r(he),re=p(he,"DIV",{class:!0});var Kt=C(re);_(Ce.$$.fragment,Kt),mn=r(Kt),Le=p(Kt,"P",{"data-svelte-h":!0}),k(Le)!=="svelte-fl5ab0"&&(Le.textContent=no),Kt.forEach(i),he.forEach(i),At=r(d),we=p(d,"P",{"data-svelte-h":!0}),k(we)!=="svelte-1jy06jg"&&(we.innerHTML=Wn),ue=r(d),_(ve.$$.fragment,d),Pt=r(d),_(Ne.$$.fragment,d),un=r(d),Rt=p(d,"P",{}),C(Rt).forEach(i),this.h()},h(){U(t,"name","hf:doc:metadata"),U(t,"content",Is),U(w,"class","flex flex-wrap space-x-1"),U($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(d,$){s(document.head,t),h(d,f,$),h(d,n,$),h(d,o,$),T(m,d,$),h(d,e,$),h(d,w,$),h(d,V,$),T(te,d,$),h(d,H,$),h(d,Q,$),h(d,S,$),h(d,Y,$),h(d,qe,$),h(d,L,$),h(d,E,$),h(d,Z,$),h(d,z,$),h(d,X,$),h(d,N,$),h(d,ce,$),h(d,G,$),h(d,O,$),h(d,x,$),T(q,d,$),h(d,I,$),h(d,pe,$),h(d,Dt,$),T(ne,d,$),h(d,Pe,$),h(d,$e,$),T(Ge,$e,null),s($e,vn),s($e,_t),s($e,$n),s($e,Tt),h(d,Ft,$),T(je,d,$),h(d,It,$),h(d,J,$),T(xe,J,null),s(J,sn),s(J,Ee),s(J,an),s(J,He),s(J,rn),s(J,me),T(Mt,me,null),s(me,ln),s(me,Qe),s(me,dn),s(me,Je),s(J,Ve),s(J,Me),T(st,Me,null),s(Me,bt),s(Me,Zt),s(J,Ye),s(J,Oe),T(oe,Oe,null),s(Oe,at),s(Oe,yt),s(J,Jn),s(J,Ke),T(be,Ke,null),s(Ke,cn),s(Ke,Ue),s(J,ye),s(J,ke),T(rt,ke,null),s(ke,kt),s(ke,Wt),h(d,lt,$),h(d,wt,$),h(d,Se,$),T(et,d,$),h(d,tt,$),h(d,se,$),T(W,se,null),s(se,it),s(se,vt),s(se,Fn),s(se,$t),s(se,In),s(se,Be),T(Re,Be,null),s(Be,Zn),s(Be,jt),s(Be,qn),s(Be,xt),s(se,pn),s(se,re),T(Ce,re,null),s(re,mn),s(re,Le),h(d,At,$),h(d,we,$),h(d,ue,$),T(ve,d,$),h(d,Pt,$),T(Ne,d,$),h(d,un,$),h(d,Rt,$),De=!0},p(d,[$]){const Ae={};$&2&&(Ae.$$scope={dirty:$,ctx:d}),ve.$set(Ae)},i(d){De||(M(m.$$.fragment,d),M(te.$$.fragment,d),M(q.$$.fragment,d),M(ne.$$.fragment,d),M(Ge.$$.fragment,d),M(je.$$.fragment,d),M(xe.$$.fragment,d),M(Mt.$$.fragment,d),M(st.$$.fragment,d),M(oe.$$.fragment,d),M(be.$$.fragment,d),M(rt.$$.fragment,d),M(et.$$.fragment,d),M(W.$$.fragment,d),M(Re.$$.fragment,d),M(Ce.$$.fragment,d),M(ve.$$.fragment,d),M(Ne.$$.fragment,d),De=!0)},o(d){b(m.$$.fragment,d),b(te.$$.fragment,d),b(q.$$.fragment,d),b(ne.$$.fragment,d),b(Ge.$$.fragment,d),b(je.$$.fragment,d),b(xe.$$.fragment,d),b(Mt.$$.fragment,d),b(st.$$.fragment,d),b(oe.$$.fragment,d),b(be.$$.fragment,d),b(rt.$$.fragment,d),b(et.$$.fragment,d),b(W.$$.fragment,d),b(Re.$$.fragment,d),b(Ce.$$.fragment,d),b(ve.$$.fragment,d),b(Ne.$$.fragment,d),De=!1},d(d){d&&(i(f),i(n),i(o),i(e),i(w),i(V),i(H),i(Q),i(S),i(Y),i(qe),i(L),i(E),i(Z),i(z),i(X),i(N),i(ce),i(G),i(O),i(x),i(I),i(pe),i(Dt),i(Pe),i($e),i(Ft),i(It),i(J),i(lt),i(wt),i(Se),i(tt),i(se),i(At),i(we),i(ue),i(Pt),i(un),i(Rt)),i(t),y(m,d),y(te,d),y(q,d),y(ne,d),y(Ge),y(je,d),y(xe),y(Mt),y(st),y(oe),y(be),y(rt),y(et,d),y(W),y(Re),y(Ce),y(ve,d),y(Ne,d)}}}const Is='{"title":"mT5","local":"mt5","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MT5Config","local":"transformers.MT5Config","sections":[],"depth":2},{"title":"MT5Tokenizer","local":"transformers.T5Tokenizer","sections":[],"depth":2},{"title":"MT5TokenizerFast","local":"transformers.T5TokenizerFast","sections":[],"depth":2},{"title":"MT5Model","local":"transformers.MT5Model","sections":[],"depth":2},{"title":"MT5ForConditionalGeneration","local":"transformers.MT5ForConditionalGeneration","sections":[],"depth":2},{"title":"MT5EncoderModel","local":"transformers.MT5EncoderModel","sections":[],"depth":2},{"title":"MT5ForSequenceClassification","local":"transformers.MT5ForSequenceClassification","sections":[],"depth":2},{"title":"MT5ForTokenClassification","local":"transformers.MT5ForTokenClassification","sections":[],"depth":2},{"title":"MT5ForQuestionAnswering","local":"transformers.MT5ForQuestionAnswering","sections":[],"depth":2},{"title":"TFMT5Model","local":"transformers.TFMT5Model","sections":[],"depth":2},{"title":"TFMT5ForConditionalGeneration","local":"transformers.TFMT5ForConditionalGeneration","sections":[],"depth":2},{"title":"TFMT5EncoderModel","local":"transformers.TFMT5EncoderModel","sections":[],"depth":2},{"title":"FlaxMT5Model","local":"transformers.FlaxMT5Model","sections":[],"depth":2},{"title":"FlaxMT5ForConditionalGeneration","local":"transformers.FlaxMT5ForConditionalGeneration","sections":[],"depth":2},{"title":"FlaxMT5EncoderModel","local":"transformers.FlaxMT5EncoderModel","sections":[],"depth":2}],"depth":1}';function Zs(j){return Po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Es extends Yo{constructor(t){super(),Oo(this,t,Zs,Fs,Ao,{})}}export{Es as component};
