import{s as tl,f as Ot,o as ll,n as Jt}from"../chunks/scheduler.25b97de1.js";import{S as sl,i as al,g as i,s as a,r as M,A as nl,h as r,f as l,c as n,j as el,u as m,x as p,k as Tt,y as ol,a as s,v as d,d as c,t as u,w as y}from"../chunks/index.d9030fc9.js";import{T as ft}from"../chunks/Tip.baa67368.js";import{C as g}from"../chunks/CodeBlock.e6cd0d95.js";import{D as il}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as T,E as rl}from"../chunks/EditOnGithub.91d95064.js";function pl(f){let o,w='If you’re new to <code>transformers.agents</code>, make sure to first read the main <a href="./agents">agents documentation</a>.';return{c(){o=i("p"),o.innerHTML=w},l(h){o=r(h,"P",{"data-svelte-h":!0}),p(o)!=="svelte-pp2axe"&&(o.innerHTML=w)},m(h,b){s(h,o,b)},p:Jt,d(h){h&&l(o)}}}function Ml(f){let o,w='For an in-depth example of an efficient multi-agent implementation, see <a href="https://huggingface.co/blog/beating-gaia" rel="nofollow">how we pushed our multi-agent system to the top of the GAIA leaderboard</a>.';return{c(){o=i("p"),o.innerHTML=w},l(h){o=r(h,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1d151kq"&&(o.innerHTML=w)},m(h,b){s(h,o,b)},p:Jt,d(h){h&&l(o)}}}function ml(f){let o,w="gradio-tools require <em>textual</em> inputs and outputs even when working with different modalities like image and audio objects. Image and audio inputs and outputs are currently incompatible.";return{c(){o=i("p"),o.innerHTML=w},l(h){o=r(h,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1vfyu6i"&&(o.innerHTML=w)},m(h,b){s(h,o,b)},p:Jt,d(h){h&&l(o)}}}function dl(f){let o,w,h,b,I,fe,C,Je,Z,Ue,J,je,$,Ut="In this page we’re going to highlight several advanced uses of <code>transformers.agents</code>.",Ie,v,Ce,_,jt=`Multi-agent has been introduced in Microsoft’s framework <a href="https://huggingface.co/papers/2308.08155" rel="nofollow">Autogen</a>.
It simply means having several agents working together to solve your task instead of only one.
It empirically yields better performance on most benchmarks. The reason for this better performance is conceptually simple: for many tasks, rather than using a do-it-all system, you would prefer to specialize units on sub-tasks. Here, having agents with separate tool sets and memories allows to achieve efficient specialization.`,Ze,B,It="You can easily build hierarchical multi-agent systems with <code>transformers.agents</code>.",$e,W,Ct='To do so, encapsulate the agent in a <a href="/docs/transformers/pr_30530/en/main_classes/agent#transformers.ManagedAgent">ManagedAgent</a> object. This object needs arguments <code>agent</code>, <code>name</code>, and a <code>description</code>, which will then be embedded in the manager agent’s system prompt to let it know how to call this managed agent, as we also do for tools.',ve,k,Zt="Here’s an example of making an agent that managed a specific web search agent using our <code>DuckDuckGoSearchTool</code>:",_e,G,Be,U,We,R,ke,H,Ge,E,$t="Let’s take again the tool example from main documentation, for which we had implemented a <code>tool</code> decorator.",Re,Q,vt='If you need to add variation, like custom attributes for your tool, you can build your tool following the fine-grained method: building a class that inherits from the <a href="/docs/transformers/pr_30530/en/main_classes/agent#transformers.Tool">Tool</a> superclass.',He,X,_t="The custom tool needs:",Ee,Y,Bt="<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>",Qe,A,Wt='The types for both <code>inputs</code> and <code>output_type</code> should be amongst <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>.',Xe,V,Ye,F,kt="Now that the custom <code>HfModelDownloadsTool</code> class is ready, you can save it to a file named <code>model_downloads.py</code> and import it for use.",Ae,S,Ve,N,Gt='You can also share your custom tool to the Hub by calling <a href="/docs/transformers/pr_30530/en/main_classes/agent#transformers.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Fe,x,Se,q,Rt="Load the tool with the <code>~Tool.load_tool</code> function and pass it to the <code>tools</code> parameter in your agent.",Ne,L,xe,z,qe,P,Ht='You can directly import a Space from the Hub as a tool using the <a href="/docs/transformers/pr_30530/en/main_classes/agent#transformers.Tool.from_space">Tool.from_space()</a> method!',Le,D,Et='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',ze,K,Qt='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',Pe,O,De,ee,Xt="And voilà, here’s your image! 🏖️",Ke,ge,Yt,Oe,te,At="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it.",et,le,tt,se,lt,be,Vt,st,ae,Ft="How cool is this? 🤩",at,ne,nt,oe,St=`<a href="https://github.com/freddyaboulton/gradio-tools" rel="nofollow">gradio-tools</a> is a powerful library that allows using Hugging
Face Spaces as tools. It supports many existing Spaces as well as custom Spaces.`,ot,ie,Nt='Transformers supports <code>gradio_tools</code> with the <a href="/docs/transformers/pr_30530/en/main_classes/agent#transformers.Tool.from_gradio">Tool.from_gradio()</a> method. For example, let’s use the <a href="https://github.com/freddyaboulton/gradio-tools/blob/main/gradio_tools/tools/prompt_generator.py" rel="nofollow"><code>StableDiffusionPromptGeneratorTool</code></a> from <code>gradio-tools</code> toolkit for improving prompts to generate better images.',it,re,xt="Import and instantiate the tool, then pass it to the <code>Tool.from_gradio</code> method:",rt,pe,pt,j,Mt,Me,mt,me,qt=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,dt,de,Lt=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install google-search-results</code> to work properly.`,ct,ce,ut,ue,yt,ye,zt="You can leverage <code>gradio.Chatbot</code> to display your agent’s thoughts using <code>stream_to_gradio</code>, here is an example:",ht,he,wt,we,gt,Te,bt;return I=new T({props:{title:"Agents, supercharged - Multi-agents, External tools, and more",local:"agents-supercharged---multi-agents-external-tools-and-more",headingTag:"h1"}}),C=new il({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/agents_advanced.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/agents_advanced.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/agents_advanced.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/agents_advanced.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/agents_advanced.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/agents_advanced.ipynb"}]}}),Z=new T({props:{title:"What is an agent?",local:"what-is-an-agent",headingTag:"h3"}}),J=new ft({props:{warning:!1,$$slots:{default:[pl]},$$scope:{ctx:f}}}),v=new T({props:{title:"Multi-agents",local:"multi-agents",headingTag:"h2"}}),G=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmQXBpRW5naW5lJTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBNYW5hZ2VkQWdlbnQlMEElMEFsbG1fZW5naW5lJTIwJTNEJTIwSGZBcGlFbmdpbmUoKSUwQSUwQXdlYl9hZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCRHVja0R1Y2tHb1NlYXJjaFRvb2woKSU1RCUyQyUyMGxsbV9lbmdpbmUlM0RsbG1fZW5naW5lKSUwQSUwQW1hbmFnZWRfd2ViX2FnZW50JTIwJTNEJTIwTWFuYWdlZEFnZW50KCUwQSUyMCUyMCUyMCUyMGFnZW50JTNEd2ViX2FnZW50JTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndlYl9zZWFyY2glMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlJ1bnMlMjB3ZWIlMjBzZWFyY2hlcyUyMGZvciUyMHlvdS4lMjBHaXZlJTIwaXQlMjB5b3VyJTIwcXVlcnklMjBhcyUyMGFuJTIwYXJndW1lbnQuJTIyJTBBKSUwQSUwQW1hbmFnZXJfYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUyMGxsbV9lbmdpbmUlM0RsbG1fZW5naW5lJTJDJTIwbWFuYWdlZF9hZ2VudHMlM0QlNUJtYW5hZ2VkX3dlYl9hZ2VudCU1RCUwQSklMEElMEFtYW5hZ2VyX2FnZW50LnJ1biglMjJXaG8lMjBpcyUyMHRoZSUyMENFTyUyMG9mJTIwSHVnZ2luZyUyMEZhY2UlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> ReactCodeAgent, HfApiEngine, DuckDuckGoSearchTool, ManagedAgent

llm_engine = HfApiEngine()

web_agent = ReactCodeAgent(tools=[DuckDuckGoSearchTool()], llm_engine=llm_engine)

managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;web_search&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>
)

manager_agent = ReactCodeAgent(
    tools=[], llm_engine=llm_engine, managed_agents=[managed_web_agent]
)

manager_agent.run(<span class="hljs-string">&quot;Who is the CEO of Hugging Face?&quot;</span>)`,wrap:!1}}),U=new ft({props:{warning:!1,$$slots:{default:[Ml]},$$scope:{ctx:f}}}),R=new T({props:{title:"Advanced tool usage",local:"advanced-tool-usage",headingTag:"h2"}}),H=new T({props:{title:"Directly define a tool by subclassing Tool, and share it to the Hub",local:"directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub",headingTag:"h3"}}),V=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEFjbGFzcyUyMEhGTW9kZWxEb3dubG9hZHNUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMm1vZGVsX2Rvd25sb2FkX2NvdW50ZXIlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFRoaXMlMjBpcyUyMGElMjB0b29sJTIwdGhhdCUyMHJldHVybnMlMjB0aGUlMjBtb3N0JTIwZG93bmxvYWRlZCUyMG1vZGVsJTIwb2YlMjBhJTIwZ2l2ZW4lMjB0YXNrJTIwb24lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1Yi4lMEElMjAlMjAlMjAlMjBJdCUyMHJldHVybnMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBjaGVja3BvaW50LiUyMiUyMiUyMiUwQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJ0aGUlMjB0YXNrJTIwY2F0ZWdvcnklMjAoc3VjaCUyMGFzJTIwdGV4dC1jbGFzc2lmaWNhdGlvbiUyQyUyMGRlcHRoLWVzdGltYXRpb24lMkMlMjBldGMpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlMjAlM0QlMjAlMjJzdHJpbmclMjIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB0YXNrJTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwbmV4dChpdGVyKGxpc3RfbW9kZWxzKGZpbHRlciUzRHRhc2slMkMlMjBzb3J0JTNEJTIyZG93bmxvYWRzJTIyJTJDJTIwZGlyZWN0aW9uJTNELTEpKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBtb2RlbC5pZA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>

    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>`,wrap:!1}}),S=new g({props:{code:"ZnJvbSUyMG1vZGVsX2Rvd25sb2FkcyUyMGltcG9ydCUyMEhGTW9kZWxEb3dubG9hZHNUb29sJTBBJTBBdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> model_downloads <span class="hljs-keyword">import</span> HFModelDownloadsTool

tool = HFModelDownloadsTool()`,wrap:!1}}),x=new g({props:{code:"dG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGaGYtbW9kZWwtZG93bmxvYWRzJTIyKQ==",highlighted:'tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>)',wrap:!1}}),L=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUyQyUyMENvZGVBZ2VudCUwQSUwQW1vZGVsX2Rvd25sb2FkX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(<span class="hljs-string">&quot;m-ric/hf-model-downloads&quot;</span>)`,wrap:!1}}),z=new T({props:{title:"Import a Space as a tool 🚀",local:"import-a-space-as-a-tool-",headingTag:"h3"}}),O=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fc3BhY2UoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmltYWdlX2dlbmVyYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyR2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwZnJvbSUyMGElMjBwcm9tcHQlMjIpJTBBJTBBaW1hZ2VfZ2VuZXJhdGlvbl90b29sKCUyMkElMjBzdW5ueSUyMGJlYWNoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers import<span class="hljs-built_in"> Tool
</span>
image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    <span class="hljs-attribute">name</span>=<span class="hljs-string">&quot;image_generator&quot;</span>,
    <span class="hljs-attribute">description</span>=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),le=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMjBwcm9tcHQlM0QnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[image_generation_tool])

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, prompt=<span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>
)`,wrap:!1}}),se=new g({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),ne=new T({props:{title:"Use gradio-tools",local:"use-gradio-tools",headingTag:"h3"}}),pe=new g({props:{code:"ZnJvbSUyMGdyYWRpb190b29scyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblByb21wdEdlbmVyYXRvclRvb2wlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVG9vbCUyQyUyMGxvYWRfdG9vbCUyQyUyMENvZGVBZ2VudCUwQSUwQWdyYWRpb19wcm9tcHRfZ2VuZXJhdG9yX3Rvb2wlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Qcm9tcHRHZW5lcmF0b3JUb29sKCklMEFwcm9tcHRfZ2VuZXJhdG9yX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fZ3JhZGlvKGdyYWRpb19wcm9tcHRfZ2VuZXJhdG9yX3Rvb2wp",highlighted:`<span class="hljs-keyword">from</span> gradio_tools <span class="hljs-keyword">import</span> StableDiffusionPromptGeneratorTool
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, CodeAgent

gradio_prompt_generator_tool = StableDiffusionPromptGeneratorTool()
prompt_generator_tool = Tool.from_gradio(gradio_prompt_generator_tool)`,wrap:!1}}),j=new ft({props:{warning:!0,$$slots:{default:[ml]},$$scope:{ctx:f}}}),Me=new T({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),ce=new g({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwVG9vbC5mcm9tX2xhbmdjaGFpbihsb2FkX3Rvb2xzKCU1QiUyMnNlcnBhcGklMjIlNUQpJTVCMCU1RCklMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQpJTBBJTBBYWdlbnQucnVuKCUyMkhvdyUyMG1hbnklMjBtb3JlJTIwYmxvY2tzJTIwKGFsc28lMjBkZW5vdGVkJTIwYXMlMjBsYXllcnMpJTIwYXJlJTIwaW4lMjBCRVJUJTIwYmFzZSUyMGVuY29kZXIlMjBjb21wYXJlZCUyMHRvJTIwdGhlJTIwZW5jb2RlciUyMGZyb20lMjB0aGUlMjBhcmNoaXRlY3R1cmUlMjBwcm9wb3NlZCUyMGluJTIwQXR0ZW50aW9uJTIwaXMlMjBBbGwlMjBZb3UlMjBOZWVkJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, ReactCodeAgent

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = ReactCodeAgent(tools=[search_tool])

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),ue=new T({props:{title:"Display your agent run in a cool Gradio interface",local:"display-your-agent-run-in-a-cool-gradio-interface",headingTag:"h2"}}),he=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    load_tool,
    ReactCodeAgent,
    HfApiEngine,
    stream_to_gradio,
)

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

llm_engine = HfApiEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-comment"># Initialize the agent with the image generation tool</span>
agent = ReactCodeAgent(tools=[image_generation_tool], llm_engine=llm_engine)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">interact_with_agent</span>(<span class="hljs-params">task</span>):
    messages = []
    messages.append(gr.ChatMessage(role=<span class="hljs-string">&quot;user&quot;</span>, content=task))
    <span class="hljs-keyword">yield</span> messages
    <span class="hljs-keyword">for</span> msg <span class="hljs-keyword">in</span> stream_to_gradio(agent, task):
        messages.append(msg)
        <span class="hljs-keyword">yield</span> messages + [
            gr.ChatMessage(role=<span class="hljs-string">&quot;assistant&quot;</span>, content=<span class="hljs-string">&quot;⏳ Task not finished yet!&quot;</span>)
        ]
    <span class="hljs-keyword">yield</span> messages


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    text_input = gr.Textbox(lines=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Chat Message&quot;</span>, value=<span class="hljs-string">&quot;Make me a picture of the Statue of Liberty.&quot;</span>)
    submit = gr.Button(<span class="hljs-string">&quot;Run illustrator agent!&quot;</span>)
    chatbot = gr.Chatbot(
        label=<span class="hljs-string">&quot;Agent&quot;</span>,
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
        avatar_images=(
            <span class="hljs-literal">None</span>,
            <span class="hljs-string">&quot;https://em-content.zobj.net/source/twitter/53/robot-face_1f916.png&quot;</span>,
        ),
    )
    submit.click(interact_with_agent, [text_input], [chatbot])

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch()`,wrap:!1}}),we=new rl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/agents_advanced.md"}}),{c(){o=i("meta"),w=a(),h=i("p"),b=a(),M(I.$$.fragment),fe=a(),M(C.$$.fragment),Je=a(),M(Z.$$.fragment),Ue=a(),M(J.$$.fragment),je=a(),$=i("p"),$.innerHTML=Ut,Ie=a(),M(v.$$.fragment),Ce=a(),_=i("p"),_.innerHTML=jt,Ze=a(),B=i("p"),B.innerHTML=It,$e=a(),W=i("p"),W.innerHTML=Ct,ve=a(),k=i("p"),k.innerHTML=Zt,_e=a(),M(G.$$.fragment),Be=a(),M(U.$$.fragment),We=a(),M(R.$$.fragment),ke=a(),M(H.$$.fragment),Ge=a(),E=i("p"),E.innerHTML=$t,Re=a(),Q=i("p"),Q.innerHTML=vt,He=a(),X=i("p"),X.textContent=_t,Ee=a(),Y=i("ul"),Y.innerHTML=Bt,Qe=a(),A=i("p"),A.innerHTML=Wt,Xe=a(),M(V.$$.fragment),Ye=a(),F=i("p"),F.innerHTML=kt,Ae=a(),M(S.$$.fragment),Ve=a(),N=i("p"),N.innerHTML=Gt,Fe=a(),M(x.$$.fragment),Se=a(),q=i("p"),q.innerHTML=Rt,Ne=a(),M(L.$$.fragment),xe=a(),M(z.$$.fragment),qe=a(),P=i("p"),P.innerHTML=Ht,Le=a(),D=i("p"),D.innerHTML=Et,ze=a(),K=i("p"),K.innerHTML=Qt,Pe=a(),M(O.$$.fragment),De=a(),ee=i("p"),ee.textContent=Xt,Ke=a(),ge=i("img"),Oe=a(),te=i("p"),te.innerHTML=At,et=a(),M(le.$$.fragment),tt=a(),M(se.$$.fragment),lt=a(),be=i("img"),st=a(),ae=i("p"),ae.textContent=Ft,at=a(),M(ne.$$.fragment),nt=a(),oe=i("p"),oe.innerHTML=St,ot=a(),ie=i("p"),ie.innerHTML=Nt,it=a(),re=i("p"),re.innerHTML=xt,rt=a(),M(pe.$$.fragment),pt=a(),M(j.$$.fragment),Mt=a(),M(Me.$$.fragment),mt=a(),me=i("p"),me.innerHTML=qt,dt=a(),de=i("p"),de.innerHTML=Lt,ct=a(),M(ce.$$.fragment),ut=a(),M(ue.$$.fragment),yt=a(),ye=i("p"),ye.innerHTML=zt,ht=a(),M(he.$$.fragment),wt=a(),M(we.$$.fragment),gt=a(),Te=i("p"),this.h()},l(e){const t=nl("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(l),w=n(e),h=r(e,"P",{}),el(h).forEach(l),b=n(e),m(I.$$.fragment,e),fe=n(e),m(C.$$.fragment,e),Je=n(e),m(Z.$$.fragment,e),Ue=n(e),m(J.$$.fragment,e),je=n(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-dweok5"&&($.innerHTML=Ut),Ie=n(e),m(v.$$.fragment,e),Ce=n(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-oi9t2a"&&(_.innerHTML=jt),Ze=n(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-pkiik5"&&(B.innerHTML=It),$e=n(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-dqvd5"&&(W.innerHTML=Ct),ve=n(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-bx601e"&&(k.innerHTML=Zt),_e=n(e),m(G.$$.fragment,e),Be=n(e),m(U.$$.fragment,e),We=n(e),m(R.$$.fragment,e),ke=n(e),m(H.$$.fragment,e),Ge=n(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-e6ym1a"&&(E.innerHTML=$t),Re=n(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1a9fjnb"&&(Q.innerHTML=vt),He=n(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-hid0wz"&&(X.textContent=_t),Ee=n(e),Y=r(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-he81o0"&&(Y.innerHTML=Bt),Qe=n(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1tuw1rn"&&(A.innerHTML=Wt),Xe=n(e),m(V.$$.fragment,e),Ye=n(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-58l3g5"&&(F.innerHTML=kt),Ae=n(e),m(S.$$.fragment,e),Ve=n(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-ihfccw"&&(N.innerHTML=Gt),Fe=n(e),m(x.$$.fragment,e),Se=n(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-n0ukpl"&&(q.innerHTML=Rt),Ne=n(e),m(L.$$.fragment,e),xe=n(e),m(z.$$.fragment,e),qe=n(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-fqburb"&&(P.innerHTML=Ht),Le=n(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1xkj0c9"&&(D.innerHTML=Et),ze=n(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1gucs20"&&(K.innerHTML=Qt),Pe=n(e),m(O.$$.fragment,e),De=n(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-sgspwr"&&(ee.textContent=Xt),Ke=n(e),ge=r(e,"IMG",{src:!0}),Oe=n(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-3y2998"&&(te.innerHTML=At),et=n(e),m(le.$$.fragment,e),tt=n(e),m(se.$$.fragment,e),lt=n(e),be=r(e,"IMG",{src:!0}),st=n(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-i5dtbz"&&(ae.textContent=Ft),at=n(e),m(ne.$$.fragment,e),nt=n(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-c328x"&&(oe.innerHTML=St),ot=n(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-y1pyfo"&&(ie.innerHTML=Nt),it=n(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-6fvul5"&&(re.innerHTML=xt),rt=n(e),m(pe.$$.fragment,e),pt=n(e),m(j.$$.fragment,e),Mt=n(e),m(Me.$$.fragment,e),mt=n(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1rq40pf"&&(me.innerHTML=qt),dt=n(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1xl1ghw"&&(de.innerHTML=Lt),ct=n(e),m(ce.$$.fragment,e),ut=n(e),m(ue.$$.fragment,e),yt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-nrn3uu"&&(ye.innerHTML=zt),ht=n(e),m(he.$$.fragment,e),wt=n(e),m(we.$$.fragment,e),gt=n(e),Te=r(e,"P",{}),el(Te).forEach(l),this.h()},h(){Tt(o,"name","hf:doc:metadata"),Tt(o,"content",cl),Ot(ge.src,Yt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||Tt(ge,"src",Yt),Ot(be.src,Vt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||Tt(be,"src",Vt)},m(e,t){ol(document.head,o),s(e,w,t),s(e,h,t),s(e,b,t),d(I,e,t),s(e,fe,t),d(C,e,t),s(e,Je,t),d(Z,e,t),s(e,Ue,t),d(J,e,t),s(e,je,t),s(e,$,t),s(e,Ie,t),d(v,e,t),s(e,Ce,t),s(e,_,t),s(e,Ze,t),s(e,B,t),s(e,$e,t),s(e,W,t),s(e,ve,t),s(e,k,t),s(e,_e,t),d(G,e,t),s(e,Be,t),d(U,e,t),s(e,We,t),d(R,e,t),s(e,ke,t),d(H,e,t),s(e,Ge,t),s(e,E,t),s(e,Re,t),s(e,Q,t),s(e,He,t),s(e,X,t),s(e,Ee,t),s(e,Y,t),s(e,Qe,t),s(e,A,t),s(e,Xe,t),d(V,e,t),s(e,Ye,t),s(e,F,t),s(e,Ae,t),d(S,e,t),s(e,Ve,t),s(e,N,t),s(e,Fe,t),d(x,e,t),s(e,Se,t),s(e,q,t),s(e,Ne,t),d(L,e,t),s(e,xe,t),d(z,e,t),s(e,qe,t),s(e,P,t),s(e,Le,t),s(e,D,t),s(e,ze,t),s(e,K,t),s(e,Pe,t),d(O,e,t),s(e,De,t),s(e,ee,t),s(e,Ke,t),s(e,ge,t),s(e,Oe,t),s(e,te,t),s(e,et,t),d(le,e,t),s(e,tt,t),d(se,e,t),s(e,lt,t),s(e,be,t),s(e,st,t),s(e,ae,t),s(e,at,t),d(ne,e,t),s(e,nt,t),s(e,oe,t),s(e,ot,t),s(e,ie,t),s(e,it,t),s(e,re,t),s(e,rt,t),d(pe,e,t),s(e,pt,t),d(j,e,t),s(e,Mt,t),d(Me,e,t),s(e,mt,t),s(e,me,t),s(e,dt,t),s(e,de,t),s(e,ct,t),d(ce,e,t),s(e,ut,t),d(ue,e,t),s(e,yt,t),s(e,ye,t),s(e,ht,t),d(he,e,t),s(e,wt,t),d(we,e,t),s(e,gt,t),s(e,Te,t),bt=!0},p(e,[t]){const Pt={};t&2&&(Pt.$$scope={dirty:t,ctx:e}),J.$set(Pt);const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),U.$set(Dt);const Kt={};t&2&&(Kt.$$scope={dirty:t,ctx:e}),j.$set(Kt)},i(e){bt||(c(I.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(J.$$.fragment,e),c(v.$$.fragment,e),c(G.$$.fragment,e),c(U.$$.fragment,e),c(R.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(S.$$.fragment,e),c(x.$$.fragment,e),c(L.$$.fragment,e),c(z.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(j.$$.fragment,e),c(Me.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(he.$$.fragment,e),c(we.$$.fragment,e),bt=!0)},o(e){u(I.$$.fragment,e),u(C.$$.fragment,e),u(Z.$$.fragment,e),u(J.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(U.$$.fragment,e),u(R.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),u(S.$$.fragment,e),u(x.$$.fragment,e),u(L.$$.fragment,e),u(z.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(j.$$.fragment,e),u(Me.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(we.$$.fragment,e),bt=!1},d(e){e&&(l(w),l(h),l(b),l(fe),l(Je),l(Ue),l(je),l($),l(Ie),l(Ce),l(_),l(Ze),l(B),l($e),l(W),l(ve),l(k),l(_e),l(Be),l(We),l(ke),l(Ge),l(E),l(Re),l(Q),l(He),l(X),l(Ee),l(Y),l(Qe),l(A),l(Xe),l(Ye),l(F),l(Ae),l(Ve),l(N),l(Fe),l(Se),l(q),l(Ne),l(xe),l(qe),l(P),l(Le),l(D),l(ze),l(K),l(Pe),l(De),l(ee),l(Ke),l(ge),l(Oe),l(te),l(et),l(tt),l(lt),l(be),l(st),l(ae),l(at),l(nt),l(oe),l(ot),l(ie),l(it),l(re),l(rt),l(pt),l(Mt),l(mt),l(me),l(dt),l(de),l(ct),l(ut),l(yt),l(ye),l(ht),l(wt),l(gt),l(Te)),l(o),y(I,e),y(C,e),y(Z,e),y(J,e),y(v,e),y(G,e),y(U,e),y(R,e),y(H,e),y(V,e),y(S,e),y(x,e),y(L,e),y(z,e),y(O,e),y(le,e),y(se,e),y(ne,e),y(pe,e),y(j,e),y(Me,e),y(ce,e),y(ue,e),y(he,e),y(we,e)}}}const cl='{"title":"Agents, supercharged - Multi-agents, External tools, and more","local":"agents-supercharged---multi-agents-external-tools-and-more","sections":[{"title":"What is an agent?","local":"what-is-an-agent","sections":[],"depth":3},{"title":"Multi-agents","local":"multi-agents","sections":[],"depth":2},{"title":"Advanced tool usage","local":"advanced-tool-usage","sections":[{"title":"Directly define a tool by subclassing Tool, and share it to the Hub","local":"directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool 🚀","local":"import-a-space-as-a-tool-","sections":[],"depth":3},{"title":"Use gradio-tools","local":"use-gradio-tools","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3}],"depth":2},{"title":"Display your agent run in a cool Gradio interface","local":"display-your-agent-run-in-a-cool-gradio-interface","sections":[],"depth":2}],"depth":1}';function ul(f){return ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fl extends sl{constructor(o){super(),al(this,o,ul,dl,tl,{})}}export{fl as component};
