import{s as Al,o as Ql,n as ss}from"../chunks/scheduler.9bc65507.js";import{S as El,i as Sl,g as T,s as c,r as g,A as Ll,h as U,f as e,c as i,j as zl,u as h,x as W,k as fl,y as Dl,a as t,v as J,d as y,t as w,w as f}from"../chunks/index.707bf1b6.js";import{T as ul}from"../chunks/Tip.c2ecdbf4.js";import{Y as ql}from"../chunks/Youtube.e1129c6f.js";import{C as v}from"../chunks/CodeBlock.54a9f38d.js";import{D as Kl}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{F as Ms,M as os}from"../chunks/Markdown.8ab98a13.js";import{H as Xs,E as Pl}from"../chunks/EditOnGithub.922df6ba.js";function Ol(Z){let a,o='このタスクと互換性のあるすべてのアーキテクチャとチェックポイントを確認するには、<a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">タスクページ</a> を確認することをお勧めします。';return{c(){a=T("p"),a.innerHTML=o},l(l){a=U(l,"P",{"data-svelte-h":!0}),W(a)!=="svelte-1n9t13i"&&(a.innerHTML=o)},m(l,r){t(l,a,r)},p:ss,d(l){l&&e(a)}}}function sa(Z){let a,o='モデルを過学習に対してより堅牢にするために、画像データセットにいくつかのデータ拡張を適用するのが一般的です。このガイドでは、<a href="https://pytorch.org/vision/stable/index.html" rel="nofollow">torchvision</a> の <a href="https://pytorch.org/vision/stable/generated/torchvision.transforms.ColorJitter.html" rel="nofollow"><code>ColorJitter</code></a> 関数を使用します。 ) を使用して画像の色のプロパティをランダムに変更しますが、任意の画像ライブラリを使用することもできます。',l,r,u,_,X="次に、モデルの画像と注釈を準備するための 2 つの前処理関数を作成します。これらの関数は、画像を<code>pixel_values</code>に変換し、注釈を<code>labels</code>に変換します。トレーニング セットの場合、画像を画像プロセッサに提供する前に <code>jitter</code> が適用されます。テスト セットの場合、テスト中にデータ拡張が適用されないため、画像プロセッサは<code>images</code>を切り取って正規化し、<code>ラベル</code>のみを切り取ります。",B,$,R,C,Y="データセット全体に<code>jitter</code>を適用するには、🤗 Datasets <code>set_transform</code> 関数を使用します。変換はオンザフライで適用されるため、高速で消費するディスク容量が少なくなります。",x,d,V;return r=new v({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb2xvckppdHRlciUwQSUwQWppdHRlciUyMCUzRCUyMENvbG9ySml0dGVyKGJyaWdodG5lc3MlM0QwLjI1JTJDJTIwY29udHJhc3QlM0QwLjI1JTJDJTIwc2F0dXJhdGlvbiUzRDAuMjUlMkMlMjBodWUlM0QwLjEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> ColorJitter

<span class="hljs-meta">&gt;&gt;&gt; </span>jitter = ColorJitter(brightness=<span class="hljs-number">0.25</span>, contrast=<span class="hljs-number">0.25</span>, saturation=<span class="hljs-number">0.25</span>, hue=<span class="hljs-number">0.1</span>)`,wrap:!1}}),$=new v({props:{code:"ZGVmJTIwdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmppdHRlcih4KSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRzJTBBJTBBJTBBZGVmJTIwdmFsX3RyYW5zZm9ybXMoZXhhbXBsZV9iYXRjaCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJ4JTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwJTVCeCUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJhbm5vdGF0aW9uJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUyQyUyMGxhYmVscyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [jitter(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),d=new v({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybSh0cmFpbl90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybSh2YWxfdHJhbnNmb3Jtcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds.set_transform(train_transforms)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds.set_transform(val_transforms)`,wrap:!1}}),{c(){a=T("p"),a.innerHTML=o,l=c(),g(r.$$.fragment),u=c(),_=T("p"),_.innerHTML=X,B=c(),g($.$$.fragment),R=c(),C=T("p"),C.innerHTML=Y,x=c(),g(d.$$.fragment)},l(m){a=U(m,"P",{"data-svelte-h":!0}),W(a)!=="svelte-14eknvb"&&(a.innerHTML=o),l=i(m),h(r.$$.fragment,m),u=i(m),_=U(m,"P",{"data-svelte-h":!0}),W(_)!=="svelte-166rb6n"&&(_.innerHTML=X),B=i(m),h($.$$.fragment,m),R=i(m),C=U(m,"P",{"data-svelte-h":!0}),W(C)!=="svelte-wbpxor"&&(C.innerHTML=Y),x=i(m),h(d.$$.fragment,m)},m(m,b){t(m,a,b),t(m,l,b),J(r,m,b),t(m,u,b),t(m,_,b),t(m,B,b),J($,m,b),t(m,R,b),t(m,C,b),t(m,x,b),J(d,m,b),V=!0},p:ss,i(m){V||(y(r.$$.fragment,m),y($.$$.fragment,m),y(d.$$.fragment,m),V=!0)},o(m){w(r.$$.fragment,m),w($.$$.fragment,m),w(d.$$.fragment,m),V=!1},d(m){m&&(e(a),e(l),e(u),e(_),e(B),e(R),e(C),e(x)),f(r,m),f($,m),f(d,m)}}}function la(Z){let a,o;return a=new os({props:{$$slots:{default:[sa]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p(l,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:l}),a.$set(u)},i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function aa(Z){let a,o=`モデルを過学習に対してより堅牢にするために、画像データセットにいくつかのデータ拡張を適用するのが一般的です。
このガイドでは、<a href="https://www.tensorflow.org/api_docs/python/tf/image" rel="nofollow"><code>tf.image</code></a> を使用して画像の色のプロパティをランダムに変更しますが、任意のプロパティを使用することもできます。画像
好きな図書館。
2 つの別々の変換関数を定義します。`,l,r,u="<li>画像拡張を含むトレーニング データ変換</li> <li>🤗 Transformers のコンピューター ビジョン モデルはチャネル優先のレイアウトを想定しているため、画像を転置するだけの検証データ変換</li>",_,X,B,$,R=`次に、モデルの画像と注釈のバッチを準備する 2 つの前処理関数を作成します。これらの機能が適用されます
画像変換を行い、以前にロードされた <code>image_processor</code> を使用して画像を <code>pixel_values</code> に変換し、
<code>labels</code>への注釈。 <code>ImageProcessor</code> は、画像のサイズ変更と正規化も処理します。`,C,Y,x,d,V=`データセット全体に前処理変換を適用するには、🤗 Datasets <code>set_transform</code> 関数を使用します。
変換はオンザフライで適用されるため、高速で消費するディスク容量が少なくなります。`,m,b,F;return X=new v({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEElMEFkZWYlMjBhdWdfdHJhbnNmb3JtcyhpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmtlcmFzLnV0aWxzLmltZ190b19hcnJheShpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9icmlnaHRuZXNzKGltYWdlJTJDJTIwMC4yNSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9jb250cmFzdChpbWFnZSUyQyUyMDAuNSUyQyUyMDIuMCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9zYXR1cmF0aW9uKGltYWdlJTJDJTIwMC43NSUyQyUyMDEuMjUpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0Zi5pbWFnZS5yYW5kb21faHVlKGltYWdlJTJDJTIwMC4xKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYudHJhbnNwb3NlKGltYWdlJTJDJTIwKDIlMkMlMjAwJTJDJTIwMSkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEElMEFkZWYlMjB0cmFuc2Zvcm1zKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYua2VyYXMudXRpbHMuaW1nX3RvX2FycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYudHJhbnNwb3NlKGltYWdlJTJDJTIwKDIlMkMlMjAwJTJDJTIwMSkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">aug_transforms</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = tf.keras.utils.img_to_array(image)
<span class="hljs-meta">... </span>    image = tf.image.random_brightness(image, <span class="hljs-number">0.25</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_contrast(image, <span class="hljs-number">0.5</span>, <span class="hljs-number">2.0</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_saturation(image, <span class="hljs-number">0.75</span>, <span class="hljs-number">1.25</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_hue(image, <span class="hljs-number">0.1</span>)
<span class="hljs-meta">... </span>    image = tf.transpose(image, (<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = tf.keras.utils.img_to_array(image)
<span class="hljs-meta">... </span>    image = tf.transpose(image, (<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image`,wrap:!1}}),Y=new v({props:{code:"ZGVmJTIwdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmF1Z190cmFuc2Zvcm1zKHguY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRzJTBBJTBBJTBBZGVmJTIwdmFsX3RyYW5zZm9ybXMoZXhhbXBsZV9iYXRjaCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJ0cmFuc2Zvcm1zKHguY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [aug_transforms(x.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [transforms(x.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),b=new v({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybSh0cmFpbl90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybSh2YWxfdHJhbnNmb3Jtcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds.set_transform(train_transforms)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds.set_transform(val_transforms)`,wrap:!1}}),{c(){a=T("p"),a.innerHTML=o,l=c(),r=T("ul"),r.innerHTML=u,_=c(),g(X.$$.fragment),B=c(),$=T("p"),$.innerHTML=R,C=c(),g(Y.$$.fragment),x=c(),d=T("p"),d.innerHTML=V,m=c(),g(b.$$.fragment)},l(j){a=U(j,"P",{"data-svelte-h":!0}),W(a)!=="svelte-1gdpu9e"&&(a.innerHTML=o),l=i(j),r=U(j,"UL",{"data-svelte-h":!0}),W(r)!=="svelte-1fzyemf"&&(r.innerHTML=u),_=i(j),h(X.$$.fragment,j),B=i(j),$=U(j,"P",{"data-svelte-h":!0}),W($)!=="svelte-t1b9t8"&&($.innerHTML=R),C=i(j),h(Y.$$.fragment,j),x=i(j),d=U(j,"P",{"data-svelte-h":!0}),W(d)!=="svelte-1tl8xez"&&(d.innerHTML=V),m=i(j),h(b.$$.fragment,j)},m(j,k){t(j,a,k),t(j,l,k),t(j,r,k),t(j,_,k),J(X,j,k),t(j,B,k),t(j,$,k),t(j,C,k),J(Y,j,k),t(j,x,k),t(j,d,k),t(j,m,k),J(b,j,k),F=!0},p:ss,i(j){F||(y(X.$$.fragment,j),y(Y.$$.fragment,j),y(b.$$.fragment,j),F=!0)},o(j){w(X.$$.fragment,j),w(Y.$$.fragment,j),w(b.$$.fragment,j),F=!1},d(j){j&&(e(a),e(l),e(r),e(_),e(B),e($),e(C),e(x),e(d),e(m)),f(X,j),f(Y,j),f(b,j)}}}function ea(Z){let a,o;return a=new os({props:{$$slots:{default:[aa]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p(l,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:l}),a.$set(u)},i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function ta(Z){let a,o;return a=new v({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2glMjBpbXBvcnQlMjBubiUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ2l0cyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ2l0c190ZW5zb3IlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KGxvZ2l0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dpdHNfdGVuc29yJTIwJTNEJTIwbm4uZnVuY3Rpb25hbC5pbnRlcnBvbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dpdHNfdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRGxhYmVscy5zaGFwZSU1Qi0yJTNBJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxpZ25fY29ybmVycyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5hcmdtYXgoZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkX2xhYmVscyUyMCUzRCUyMGxvZ2l0c190ZW5zb3IuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY3MlMjAlM0QlMjBtZXRyaWMuY29tcHV0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUzRHByZWRfbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVmZXJlbmNlcyUzRGxhYmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWdub3JlX2luZGV4JTNEMjU1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVkdWNlX2xhYmVscyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGtleSUyQyUyMHZhbHVlJTIwaW4lMjBtZXRyaWNzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHR5cGUodmFsdWUpJTIwaXMlMjBucC5uZGFycmF5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljcyU1QmtleSU1RCUyMCUzRCUyMHZhbHVlLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        logits, labels = eval_pred
<span class="hljs-meta">... </span>        logits_tensor = torch.from_numpy(logits)
<span class="hljs-meta">... </span>        logits_tensor = nn.functional.interpolate(
<span class="hljs-meta">... </span>            logits_tensor,
<span class="hljs-meta">... </span>            size=labels.shape[-<span class="hljs-number">2</span>:],
<span class="hljs-meta">... </span>            mode=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>            align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        ).argmax(dim=<span class="hljs-number">1</span>)

<span class="hljs-meta">... </span>        pred_labels = logits_tensor.detach().cpu().numpy()
<span class="hljs-meta">... </span>        metrics = metric.compute(
<span class="hljs-meta">... </span>            predictions=pred_labels,
<span class="hljs-meta">... </span>            references=labels,
<span class="hljs-meta">... </span>            num_labels=num_labels,
<span class="hljs-meta">... </span>            ignore_index=<span class="hljs-number">255</span>,
<span class="hljs-meta">... </span>            reduce_labels=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> metrics.items():
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> <span class="hljs-built_in">type</span>(value) <span class="hljs-keyword">is</span> np.ndarray:
<span class="hljs-meta">... </span>                metrics[key] = value.tolist()
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> metrics`,wrap:!1}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p:ss,i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function na(Z){let a,o;return a=new os({props:{$$slots:{default:[ta]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p(l,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:l}),a.$set(u)},i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function pa(Z){let a,o;return a=new v({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjB0Zi50cmFuc3Bvc2UobG9naXRzJTJDJTIwcGVybSUzRCU1QjAlMkMlMjAyJTJDJTIwMyUyQyUyMDElNUQpJTBBJTIwJTIwJTIwJTIwbG9naXRzX3Jlc2l6ZWQlMjAlM0QlMjB0Zi5pbWFnZS5yZXNpemUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRHRmLnNoYXBlKGxhYmVscyklNUIxJTNBJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0aG9kJTNEJTIyYmlsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwcHJlZF9sYWJlbHMlMjAlM0QlMjB0Zi5hcmdtYXgobG9naXRzX3Jlc2l6ZWQlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUyMCUzRCUyMG1ldHJpYy5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTNEcHJlZF9sYWJlbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWZlcmVuY2VzJTNEbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZ25vcmVfaW5kZXglM0QtMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlZHVjZV9sYWJlbHMlM0RpbWFnZV9wcm9jZXNzb3IuZG9fcmVkdWNlX2xhYmVscyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBwZXJfY2F0ZWdvcnlfYWNjdXJhY3klMjAlM0QlMjBtZXRyaWNzLnBvcCglMjJwZXJfY2F0ZWdvcnlfYWNjdXJhY3klMjIpLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwcGVyX2NhdGVnb3J5X2lvdSUyMCUzRCUyMG1ldHJpY3MucG9wKCUyMnBlcl9jYXRlZ29yeV9pb3UlMjIpLnRvbGlzdCgpJTBBJTBBJTIwJTIwJTIwJTIwbWV0cmljcy51cGRhdGUoJTdCZiUyMmFjY3VyYWN5XyU3QmlkMmxhYmVsJTVCaSU1RCU3RCUyMiUzQSUyMHYlMjBmb3IlMjBpJTJDJTIwdiUyMGluJTIwZW51bWVyYXRlKHBlcl9jYXRlZ29yeV9hY2N1cmFjeSklN0QpJTBBJTIwJTIwJTIwJTIwbWV0cmljcy51cGRhdGUoJTdCZiUyMmlvdV8lN0JpZDJsYWJlbCU1QmklNUQlN0QlMjIlM0ElMjB2JTIwZm9yJTIwaSUyQyUyMHYlMjBpbiUyMGVudW1lcmF0ZShwZXJfY2F0ZWdvcnlfaW91KSU3RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2YWxfJTIyJTIwJTJCJTIwayUzQSUyMHYlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwbWV0cmljcy5pdGVtcygpJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    logits = tf.transpose(logits, perm=[<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>])
<span class="hljs-meta">... </span>    logits_resized = tf.image.resize(
<span class="hljs-meta">... </span>        logits,
<span class="hljs-meta">... </span>        size=tf.shape(labels)[<span class="hljs-number">1</span>:],
<span class="hljs-meta">... </span>        method=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    pred_labels = tf.argmax(logits_resized, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metrics = metric.compute(
<span class="hljs-meta">... </span>        predictions=pred_labels,
<span class="hljs-meta">... </span>        references=labels,
<span class="hljs-meta">... </span>        num_labels=num_labels,
<span class="hljs-meta">... </span>        ignore_index=-<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>        reduce_labels=image_processor.do_reduce_labels,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    per_category_accuracy = metrics.pop(<span class="hljs-string">&quot;per_category_accuracy&quot;</span>).tolist()
<span class="hljs-meta">... </span>    per_category_iou = metrics.pop(<span class="hljs-string">&quot;per_category_iou&quot;</span>).tolist()

<span class="hljs-meta">... </span>    metrics.update({<span class="hljs-string">f&quot;accuracy_<span class="hljs-subst">{id2label[i]}</span>&quot;</span>: v <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(per_category_accuracy)})
<span class="hljs-meta">... </span>    metrics.update({<span class="hljs-string">f&quot;iou_<span class="hljs-subst">{id2label[i]}</span>&quot;</span>: v <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(per_category_iou)})
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;val_&quot;</span> + k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> metrics.items()}`,wrap:!1}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p:ss,i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function ma(Z){let a,o;return a=new os({props:{$$slots:{default:[pa]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p(l,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:l}),a.$set(u)},i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function ra(Z){let a,o='<a href="/docs/transformers/pr_30182/ja/main_classes/trainer#transformers.Trainer">Trainer</a> を使用したモデルの微調整に慣れていない場合は、<a href="../training#finetune-with-trainer">ここ</a> の基本的なチュートリアルをご覧ください。';return{c(){a=T("p"),a.innerHTML=o},l(l){a=U(l,"P",{"data-svelte-h":!0}),W(a)!=="svelte-1dbzmdm"&&(a.innerHTML=o)},m(l,r){t(l,a,r)},p:ss,d(l){l&&e(a)}}}function ca(Z){let a,o,l,r='これでモデルのトレーニングを開始する準備が整いました。 <a href="/docs/transformers/pr_30182/ja/model_doc/auto#transformers.AutoModelForSemanticSegmentation">AutoModelForSemanticSegmentation</a> を使用して SegFormer をロードし、ラベル ID とラベル クラス間のマッピングをモデルに渡します。',u,_,X,B,$="この時点で残っている手順は次の 3 つだけです。",R,C,Y='<li><a href="/docs/transformers/pr_30182/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> でトレーニング ハイパーパラメータを定義します。 <code>image</code> 列が削除されるため、未使用の列を削除しないことが重要です。 <code>image</code> 列がないと、<code>pixel_values</code> を作成できません。この動作を防ぐには、<code>remove_unused_columns=False</code>を設定してください。他に必要なパラメータは、モデルの保存場所を指定する <code>output_dir</code> だけです。 <code>push_to_hub=True</code>を設定して、このモデルをハブにプッシュします (モデルをアップロードするには、Hugging Face にサインインする必要があります)。各エポックの終了時に、<a href="/docs/transformers/pr_30182/ja/main_classes/trainer#transformers.Trainer">Trainer</a> は IoU メトリックを評価し、トレーニング チェックポイントを保存します。</li> <li>トレーニング引数を、モデル、データセット、トークナイザー、データ照合器、および <code>compute_metrics</code> 関数とともに <a href="/docs/transformers/pr_30182/ja/main_classes/trainer#transformers.Trainer">Trainer</a> に渡します。</li> <li><a href="/docs/transformers/pr_30182/ja/main_classes/trainer#transformers.Trainer.train">train()</a> を呼び出してモデルを微調整します。</li>',x,d,V,m,b='トレーニングが完了したら、 <a href="/docs/transformers/pr_30182/ja/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> メソッドを使用してモデルをハブに共有し、誰もがモデルを使用できるようにします。',F,j,k;return a=new ul({props:{$$slots:{default:[ra]},$$scope:{ctx:Z}}}),_=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBUcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMjBsYWJlbDJpZCUzRGxhYmVsMmlkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSemanticSegmentation, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(checkpoint, id2label=id2label, label2id=label2id)`,wrap:!1}}),d=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJzZWdmb3JtZXItYjAtc2NlbmUtcGFyc2UtMTUwJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDZlLTUlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0QyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV90b3RhbF9saW1pdCUzRDMlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfYWNjdW11bGF0aW9uX3N0ZXBzJTNENSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kcyUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRlc3RfZHMlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;segformer-b0-scene-parse-150&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">6e-5</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    eval_accumulation_steps=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=train_ds,
<span class="hljs-meta">... </span>    eval_dataset=test_ds,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),j=new v({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){g(a.$$.fragment),o=c(),l=T("p"),l.innerHTML=r,u=c(),g(_.$$.fragment),X=c(),B=T("p"),B.textContent=$,R=c(),C=T("ol"),C.innerHTML=Y,x=c(),g(d.$$.fragment),V=c(),m=T("p"),m.innerHTML=b,F=c(),g(j.$$.fragment)},l(p){h(a.$$.fragment,p),o=i(p),l=U(p,"P",{"data-svelte-h":!0}),W(l)!=="svelte-1f332u"&&(l.innerHTML=r),u=i(p),h(_.$$.fragment,p),X=i(p),B=U(p,"P",{"data-svelte-h":!0}),W(B)!=="svelte-1j8bgyv"&&(B.textContent=$),R=i(p),C=U(p,"OL",{"data-svelte-h":!0}),W(C)!=="svelte-11lmewd"&&(C.innerHTML=Y),x=i(p),h(d.$$.fragment,p),V=i(p),m=U(p,"P",{"data-svelte-h":!0}),W(m)!=="svelte-1jfgvz7"&&(m.innerHTML=b),F=i(p),h(j.$$.fragment,p)},m(p,I){J(a,p,I),t(p,o,I),t(p,l,I),t(p,u,I),J(_,p,I),t(p,X,I),t(p,B,I),t(p,R,I),t(p,C,I),t(p,x,I),J(d,p,I),t(p,V,I),t(p,m,I),t(p,F,I),J(j,p,I),k=!0},p(p,I){const E={};I&2&&(E.$$scope={dirty:I,ctx:p}),a.$set(E)},i(p){k||(y(a.$$.fragment,p),y(_.$$.fragment,p),y(d.$$.fragment,p),y(j.$$.fragment,p),k=!0)},o(p){w(a.$$.fragment,p),w(_.$$.fragment,p),w(d.$$.fragment,p),w(j.$$.fragment,p),k=!1},d(p){p&&(e(o),e(l),e(u),e(X),e(B),e(R),e(C),e(x),e(V),e(m),e(F)),f(a,p),f(_,p),f(d,p),f(j,p)}}}function ia(Z){let a,o;return a=new os({props:{$$slots:{default:[ca]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p(l,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:l}),a.$set(u)},i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function Ma(Z){let a,o='Keras を使用したモデルの微調整に慣れていない場合は、まず <a href="./training#train-a-tensorflow-model-with-keras">基本チュートリアル</a> を確認してください。';return{c(){a=T("p"),a.innerHTML=o},l(l){a=U(l,"P",{"data-svelte-h":!0}),W(a)!=="svelte-m0v6mc"&&(a.innerHTML=o)},m(l,r){t(l,a,r)},p:ss,d(l){l&&e(a)}}}function oa(Z){let a,o,l,r="TensorFlow でモデルを微調整するには、次の手順に従います。",u,_,X="<li>トレーニングのハイパーパラメータを定義し、オプティマイザーと学習率スケジュールを設定します。</li> <li>事前トレーニングされたモデルをインスタンス化します。</li> <li>🤗 データセットを <code>tf.data.Dataset</code> に変換します。</li> <li>モデルをコンパイルします。</li> <li>コールバックを追加してメトリクスを計算し、モデルを 🤗 Hub にアップロードします</li> <li><code>fit()</code> メソッドを使用してトレーニングを実行します。</li>",B,$,R="まず、ハイパーパラメーター、オプティマイザー、学習率スケジュールを定義します。",C,Y,x,d,V=`次に、ラベル マッピングとともに <a href="/docs/transformers/pr_30182/ja/model_doc/auto#transformers.TFAutoModelForSemanticSegmentation">TFAutoModelForSemanticSegmentation</a> を使用して SegFormer をロードし、それをコンパイルします。
オプティマイザ。 Transformers モデルにはすべてデフォルトのタスク関連の損失関数があるため、次の場合を除き、損失関数を指定する必要はないことに注意してください。`,m,b,F,j,k="<code>to_tf_dataset</code> と <code>DefaultDataCollat​​or</code> を使用して、データセットを <code>tf.data.Dataset</code> 形式に変換します。",p,I,E,A,S=`予測から精度を計算し、モデルを 🤗 ハブにプッシュするには、<a href="../main_classes/keras_callbacks">Keras callbacks</a> を使用します。
<code>compute_metrics</code> 関数を <a href="/docs/transformers/pr_30182/ja/main_classes/keras_callbacks#transformers.KerasMetricCallback">KerasMetricCallback</a> に渡します。
そして <a href="/docs/transformers/pr_30182/ja/main_classes/keras_callbacks#transformers.PushToHubCallback">PushToHubCallback</a> を使用してモデルをアップロードします。`,q,N,js,Q,L=`ついに、モデルをトレーニングする準備が整いました。トレーニングおよび検証データセット、エポック数、
モデルを微調整するためのコールバック:`,K,H,P,z,Rs="おめでとう！モデルを微調整し、🤗 Hub で共有しました。これで推論に使用できるようになりました。",O;return a=new ul({props:{$$slots:{default:[Ma]},$$scope:{ctx:Z}}}),Y=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGNyZWF0ZV9vcHRpbWl6ZXIlMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwMiUwQW51bV9lcG9jaHMlMjAlM0QlMjA1MCUwQW51bV90cmFpbl9zdGVwcyUyMCUzRCUyMGxlbih0cmFpbl9kcyklMjAqJTIwbnVtX2Vwb2NocyUwQWxlYXJuaW5nX3JhdGUlMjAlM0QlMjA2ZS01JTBBd2VpZ2h0X2RlY2F5X3JhdGUlMjAlM0QlMjAwLjAxJTBBJTBBb3B0aW1pemVyJTJDJTIwbHJfc2NoZWR1bGUlMjAlM0QlMjBjcmVhdGVfb3B0aW1pemVyKCUwQSUyMCUyMCUyMCUyMGluaXRfbHIlM0RsZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX3N0ZXBzJTNEbnVtX3RyYWluX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5X3JhdGUlM0R3ZWlnaHRfZGVjYXlfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> create_optimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_train_steps = <span class="hljs-built_in">len</span>(train_ds) * num_epochs
<span class="hljs-meta">&gt;&gt;&gt; </span>learning_rate = <span class="hljs-number">6e-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>weight_decay_rate = <span class="hljs-number">0.01</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer, lr_schedule = create_optimizer(
<span class="hljs-meta">... </span>    init_lr=learning_rate,
<span class="hljs-meta">... </span>    num_train_steps=num_train_steps,
<span class="hljs-meta">... </span>    weight_decay_rate=weight_decay_rate,
<span class="hljs-meta">... </span>    num_warmup_steps=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),b=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGNoZWNrcG9pbnQlMkMlMEElMjAlMjAlMjAlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSklMEFtb2RlbC5jb21waWxlKG9wdGltaXplciUzRG9wdGltaXplciklMjAlMjAlMjMlMjBObyUyMGxvc3MlMjBhcmd1bWVudCE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(optimizer=optimizer)  <span class="hljs-comment"># No loss argument!</span>`,wrap:!1}}),I=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUwQXRmX3RyYWluX2RhdGFzZXQlMjAlM0QlMjB0cmFpbl9kcy50b190Zl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGNvbHVtbnMlM0QlNUIlMjJwaXhlbF92YWx1ZXMlMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUyQyUwQSklMEElMEF0Zl9ldmFsX2RhdGFzZXQlMjAlM0QlMjB0ZXN0X2RzLnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiUyQyUyMCUyMmxhYmVsJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = train_ds.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;pixel_values&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_eval_dataset = test_ds.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;pixel_values&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5rZXJhc19jYWxsYmFja3MlMjBpbXBvcnQlMjBLZXJhc01ldHJpY0NhbGxiYWNrJTJDJTIwUHVzaFRvSHViQ2FsbGJhY2slMEElMEFtZXRyaWNfY2FsbGJhY2slMjAlM0QlMjBLZXJhc01ldHJpY0NhbGxiYWNrKCUwQSUyMCUyMCUyMCUyMG1ldHJpY19mbiUzRGNvbXB1dGVfbWV0cmljcyUyQyUyMGV2YWxfZGF0YXNldCUzRHRmX2V2YWxfZGF0YXNldCUyQyUyMGJhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTIwbGFiZWxfY29scyUzRCU1QiUyMmxhYmVscyUyMiU1RCUwQSklMEElMEFwdXNoX3RvX2h1Yl9jYWxsYmFjayUyMCUzRCUyMFB1c2hUb0h1YkNhbGxiYWNrKG91dHB1dF9kaXIlM0QlMjJzY2VuZV9zZWdtZW50YXRpb24lMjIlMkMlMjB0b2tlbml6ZXIlM0RpbWFnZV9wcm9jZXNzb3IpJTBBJTBBY2FsbGJhY2tzJTIwJTNEJTIwJTVCbWV0cmljX2NhbGxiYWNrJTJDJTIwcHVzaF90b19odWJfY2FsbGJhY2slNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> KerasMetricCallback, PushToHubCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>metric_callback = KerasMetricCallback(
<span class="hljs-meta">... </span>    metric_fn=compute_metrics, eval_dataset=tf_eval_dataset, batch_size=batch_size, label_cols=[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>push_to_hub_callback = PushToHubCallback(output_dir=<span class="hljs-string">&quot;scene_segmentation&quot;</span>, tokenizer=image_processor)

<span class="hljs-meta">&gt;&gt;&gt; </span>callbacks = [metric_callback, push_to_hub_callback]`,wrap:!1}}),H=new v({props:{code:"bW9kZWwuZml0KCUwQSUyMCUyMCUyMCUyMHRmX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB2YWxpZGF0aW9uX2RhdGElM0R0Zl9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja3MlM0RjYWxsYmFja3MlMkMlMEElMjAlMjAlMjAlMjBlcG9jaHMlM0RudW1fZXBvY2hzJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(
<span class="hljs-meta">... </span>    tf_train_dataset,
<span class="hljs-meta">... </span>    validation_data=tf_eval_dataset,
<span class="hljs-meta">... </span>    callbacks=callbacks,
<span class="hljs-meta">... </span>    epochs=num_epochs,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(a.$$.fragment),o=c(),l=T("p"),l.textContent=r,u=c(),_=T("ol"),_.innerHTML=X,B=c(),$=T("p"),$.textContent=R,C=c(),g(Y.$$.fragment),x=c(),d=T("p"),d.innerHTML=V,m=c(),g(b.$$.fragment),F=c(),j=T("p"),j.innerHTML=k,p=c(),g(I.$$.fragment),E=c(),A=T("p"),A.innerHTML=S,q=c(),g(N.$$.fragment),js=c(),Q=T("p"),Q.textContent=L,K=c(),g(H.$$.fragment),P=c(),z=T("p"),z.textContent=Rs},l(M){h(a.$$.fragment,M),o=i(M),l=U(M,"P",{"data-svelte-h":!0}),W(l)!=="svelte-a44fb"&&(l.textContent=r),u=i(M),_=U(M,"OL",{"data-svelte-h":!0}),W(_)!=="svelte-23fvp6"&&(_.innerHTML=X),B=i(M),$=U(M,"P",{"data-svelte-h":!0}),W($)!=="svelte-1u4w84l"&&($.textContent=R),C=i(M),h(Y.$$.fragment,M),x=i(M),d=U(M,"P",{"data-svelte-h":!0}),W(d)!=="svelte-14t4zvv"&&(d.innerHTML=V),m=i(M),h(b.$$.fragment,M),F=i(M),j=U(M,"P",{"data-svelte-h":!0}),W(j)!=="svelte-ye4n86"&&(j.innerHTML=k),p=i(M),h(I.$$.fragment,M),E=i(M),A=U(M,"P",{"data-svelte-h":!0}),W(A)!=="svelte-14ca3z0"&&(A.innerHTML=S),q=i(M),h(N.$$.fragment,M),js=i(M),Q=U(M,"P",{"data-svelte-h":!0}),W(Q)!=="svelte-bif4s6"&&(Q.textContent=L),K=i(M),h(H.$$.fragment,M),P=i(M),z=U(M,"P",{"data-svelte-h":!0}),W(z)!=="svelte-f4xo0m"&&(z.textContent=Rs)},m(M,G){J(a,M,G),t(M,o,G),t(M,l,G),t(M,u,G),t(M,_,G),t(M,B,G),t(M,$,G),t(M,C,G),J(Y,M,G),t(M,x,G),t(M,d,G),t(M,m,G),J(b,M,G),t(M,F,G),t(M,j,G),t(M,p,G),J(I,M,G),t(M,E,G),t(M,A,G),t(M,q,G),J(N,M,G),t(M,js,G),t(M,Q,G),t(M,K,G),J(H,M,G),t(M,P,G),t(M,z,G),O=!0},p(M,G){const D={};G&2&&(D.$$scope={dirty:G,ctx:M}),a.$set(D)},i(M){O||(y(a.$$.fragment,M),y(Y.$$.fragment,M),y(b.$$.fragment,M),y(I.$$.fragment,M),y(N.$$.fragment,M),y(H.$$.fragment,M),O=!0)},o(M){w(a.$$.fragment,M),w(Y.$$.fragment,M),w(b.$$.fragment,M),w(I.$$.fragment,M),w(N.$$.fragment,M),w(H.$$.fragment,M),O=!1},d(M){M&&(e(o),e(l),e(u),e(_),e(B),e($),e(C),e(x),e(d),e(m),e(F),e(j),e(p),e(E),e(A),e(q),e(js),e(Q),e(K),e(P),e(z)),f(a,M),f(Y,M),f(b,M),f(I,M),f(N,M),f(H,M)}}}function ja(Z){let a,o;return a=new os({props:{$$slots:{default:[oa]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p(l,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:l}),a.$set(u)},i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function ga(Z){let a,o='推論用に微調整されたモデルを試す最も簡単な方法は、それを <a href="/docs/transformers/pr_30182/ja/main_classes/pipelines#transformers.pipeline">pipeline()</a> で使用することです。モデルを使用して画像セグメンテーション用の <code>pipeline</code>をインスタンス化し、それに画像を渡します。',l,r,u,_,X="必要に応じて、<code>pipeline</code>の結果を手動で複製することもできます。画像を画像プロセッサで処理し、<code>pixel_values</code> を GPU に配置します。",B,$,R,C,Y="入力をモデルに渡し、<code>logits</code>を返します。",x,d,V,m,b="次に、ロジットを元の画像サイズに再スケールします。",F,j,k;return r=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJteV9hd2Vzb21lX3NlZ19tb2RlbCUyMiklMEFzZWdtZW50ZXIoaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=<span class="hljs-string">&quot;my_awesome_seg_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter(image)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;wall&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062690</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sky&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062A50</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;floor&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062B50</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ceiling&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062A10</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bed &#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062E90</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;windowpane&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062390</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cabinet&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062550</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;chair&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062D90</span>&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;armchair&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=640x427 at <span class="hljs-number">0x7FD5B2062E10</span>&gt;}]`,wrap:!1}}),$=new v({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUyMCUyMCUyMyUyMHVzZSUyMEdQVSUyMGlmJTIwYXZhaWxhYmxlJTJDJTIwb3RoZXJ3aXNlJTIwdXNlJTIwYSUyMENQVSUwQWVuY29kaW5nJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBlbmNvZGluZy5waXhlbF92YWx1ZXMudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)  <span class="hljs-comment"># use GPU if available, otherwise use a CPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = encoding.pixel_values.to(device)`,wrap:!1}}),d=new v({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyUzRHBpeGVsX3ZhbHVlcyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values=pixel_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits.cpu()`,wrap:!1}}),j=new v({props:{code:"dXBzYW1wbGVkX2xvZ2l0cyUyMCUzRCUyMG5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwbG9naXRzJTJDJTBBJTIwJTIwJTIwJTIwc2l6ZSUzRGltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGUlM0QlMjJiaWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEFwcmVkX3NlZyUyMCUzRCUyMHVwc2FtcGxlZF9sb2dpdHMuYXJnbWF4KGRpbSUzRDEpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>upsampled_logits = nn.functional.interpolate(
<span class="hljs-meta">... </span>    logits,
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred_seg = upsampled_logits.argmax(dim=<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=T("p"),a.innerHTML=o,l=c(),g(r.$$.fragment),u=c(),_=T("p"),_.innerHTML=X,B=c(),g($.$$.fragment),R=c(),C=T("p"),C.innerHTML=Y,x=c(),g(d.$$.fragment),V=c(),m=T("p"),m.textContent=b,F=c(),g(j.$$.fragment)},l(p){a=U(p,"P",{"data-svelte-h":!0}),W(a)!=="svelte-1gsl9p6"&&(a.innerHTML=o),l=i(p),h(r.$$.fragment,p),u=i(p),_=U(p,"P",{"data-svelte-h":!0}),W(_)!=="svelte-fs04zi"&&(_.innerHTML=X),B=i(p),h($.$$.fragment,p),R=i(p),C=U(p,"P",{"data-svelte-h":!0}),W(C)!=="svelte-1rvunpz"&&(C.innerHTML=Y),x=i(p),h(d.$$.fragment,p),V=i(p),m=U(p,"P",{"data-svelte-h":!0}),W(m)!=="svelte-oolpf2"&&(m.textContent=b),F=i(p),h(j.$$.fragment,p)},m(p,I){t(p,a,I),t(p,l,I),J(r,p,I),t(p,u,I),t(p,_,I),t(p,B,I),J($,p,I),t(p,R,I),t(p,C,I),t(p,x,I),J(d,p,I),t(p,V,I),t(p,m,I),t(p,F,I),J(j,p,I),k=!0},p:ss,i(p){k||(y(r.$$.fragment,p),y($.$$.fragment,p),y(d.$$.fragment,p),y(j.$$.fragment,p),k=!0)},o(p){w(r.$$.fragment,p),w($.$$.fragment,p),w(d.$$.fragment,p),w(j.$$.fragment,p),k=!1},d(p){p&&(e(a),e(l),e(u),e(_),e(B),e(R),e(C),e(x),e(V),e(m),e(F)),f(r,p),f($,p),f(d,p),f(j,p)}}}function ha(Z){let a,o;return a=new os({props:{$$slots:{default:[ga]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p(l,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:l}),a.$set(u)},i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function Ja(Z){let a,o="画像プロセッサをロードして画像を前処理し、入力を TensorFlow テンソルとして返します。",l,r,u,_,X="入力をモデルに渡し、<code>logits</code>を返します。",B,$,R,C,Y="次に、ロジットを元の画像サイズに再スケールし、クラス次元に argmax を適用します。",x,d,V;return r=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGc2NlbmVfc2VnbWVudGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/scene_segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`,wrap:!1}}),$=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk1hcmlhSyUyRnNjZW5lX3NlZ21lbnRhdGlvbiUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;MariaK/scene_segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits`,wrap:!1}}),d=new v({props:{code:"bG9naXRzJTIwJTNEJTIwdGYudHJhbnNwb3NlKGxvZ2l0cyUyQyUyMCU1QjAlMkMlMjAyJTJDJTIwMyUyQyUyMDElNUQpJTBBJTBBdXBzYW1wbGVkX2xvZ2l0cyUyMCUzRCUyMHRmLmltYWdlLnJlc2l6ZSglMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBXZSUyMHJldmVyc2UlMjB0aGUlMjBzaGFwZSUyMG9mJTIwJTYwaW1hZ2UlNjAlMjBiZWNhdXNlJTIwJTYwaW1hZ2Uuc2l6ZSU2MCUyMHJldHVybnMlMjB3aWR0aCUyMGFuZCUyMGhlaWdodC4lMEElMjAlMjAlMjAlMjBpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEEpJTBBJTBBcHJlZF9zZWclMjAlM0QlMjB0Zi5tYXRoLmFyZ21heCh1cHNhbXBsZWRfbG9naXRzJTJDJTIwYXhpcyUzRC0xKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>logits = tf.transpose(logits, [<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>upsampled_logits = tf.image.resize(
<span class="hljs-meta">... </span>    logits,
<span class="hljs-meta">... </span>    <span class="hljs-comment"># We reverse the shape of \`image\` because \`image.size\` returns width and height.</span>
<span class="hljs-meta">... </span>    image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred_seg = tf.math.argmax(upsampled_logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=T("p"),a.textContent=o,l=c(),g(r.$$.fragment),u=c(),_=T("p"),_.innerHTML=X,B=c(),g($.$$.fragment),R=c(),C=T("p"),C.textContent=Y,x=c(),g(d.$$.fragment)},l(m){a=U(m,"P",{"data-svelte-h":!0}),W(a)!=="svelte-7m1b4a"&&(a.textContent=o),l=i(m),h(r.$$.fragment,m),u=i(m),_=U(m,"P",{"data-svelte-h":!0}),W(_)!=="svelte-1rvunpz"&&(_.innerHTML=X),B=i(m),h($.$$.fragment,m),R=i(m),C=U(m,"P",{"data-svelte-h":!0}),W(C)!=="svelte-3qm4xh"&&(C.textContent=Y),x=i(m),h(d.$$.fragment,m)},m(m,b){t(m,a,b),t(m,l,b),J(r,m,b),t(m,u,b),t(m,_,b),t(m,B,b),J($,m,b),t(m,R,b),t(m,C,b),t(m,x,b),J(d,m,b),V=!0},p:ss,i(m){V||(y(r.$$.fragment,m),y($.$$.fragment,m),y(d.$$.fragment,m),V=!0)},o(m){w(r.$$.fragment,m),w($.$$.fragment,m),w(d.$$.fragment,m),V=!1},d(m){m&&(e(a),e(l),e(u),e(_),e(B),e(R),e(C),e(x)),f(r,m),f($,m),f(d,m)}}}function ya(Z){let a,o;return a=new os({props:{$$slots:{default:[Ja]},$$scope:{ctx:Z}}}),{c(){g(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,r){J(a,l,r),o=!0},p(l,r){const u={};r&2&&(u.$$scope={dirty:r,ctx:l}),a.$set(u)},i(l){o||(y(a.$$.fragment,l),o=!0)},o(l){w(a.$$.fragment,l),o=!1},d(l){f(a,l)}}}function wa(Z){let a,o,l,r,u,_,X,B,$,R,C,Y="セマンティック セグメンテーションでは、画像の個々のピクセルにラベルまたはクラスを割り当てます。セグメンテーションにはいくつかのタイプがありますが、セマンティック セグメンテーションの場合、同じオブジェクトの一意のインスタンス間の区別は行われません。両方のオブジェクトに同じラベルが付けられます (たとえば、<code>car-1</code>と<code>car-2</code>の代わりに<code>car</code>)。セマンティック セグメンテーションの一般的な現実世界のアプリケーションには、歩行者や重要な交通情報を識別するための自動運転車のトレーニング、医療画像内の細胞と異常の識別、衛星画像からの環境変化の監視などが含まれます。",x,d,V="このガイドでは、次の方法を説明します。",m,b,F='<li><a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">SceneParse150</a> データセットの <a href="https://huggingface.co/docs/transformers/main/en/model_doc/segformer#segformer" rel="nofollow">SegFormer</a> を微調整します。</li> <li>微調整したモデルを推論に使用します。</li>',j,k,p,I,E="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",A,S,q,N,js="モデルをアップロードしてコミュニティと共有できるように、Hugging Face アカウントにログインすることをお勧めします。プロンプトが表示されたら、トークンを入力してログインします。",Q,L,K,H,P,z,Rs="まず、SceneParse150 データセットの小さいサブセットを 🤗 データセット ライブラリから読み込みます。これにより、完全なデータセットのトレーニングにさらに時間を費やす前に、実験してすべてが機能することを確認する機会が得られます。",O,M,G,D,dl="<code>train_test_split</code> メソッドを使用して、データセットの <code>train</code> 分割をトレイン セットとテスト セットに分割します。",Vs,gs,Fs,hs,bl="次に、例を見てみましょう。",Ns,Js,Hs,ys,Tl="<li><code>image</code>: シーンの PIL イメージ。</li> <li><code>annotation</code>: セグメンテーション マップの PIL イメージ。モデルのターゲットでもあります。</li> <li><code>scene_category</code>: “kitchen”や”office”などの画像シーンを説明するカテゴリ ID。このガイドでは、<code>image</code>と<code>annotation</code>のみが必要になります。どちらも PIL イメージです。</li>",zs,ws,Ul="また、ラベル ID をラベル クラスにマップする辞書を作成することもできます。これは、後でモデルを設定するときに役立ちます。ハブからマッピングをダウンロードし、<code>id2label</code> および <code>label2id</code> ディクショナリを作成します。",As,fs,Qs,us,Es,ds,$l="次のステップでは、SegFormer 画像プロセッサをロードして、モデルの画像と注釈を準備します。このデータセットのような一部のデータセットは、バックグラウンド クラスとしてゼロインデックスを使用します。ただし、実際には背景クラスは 150 個のクラスに含まれていないため、<code>do_reduce_labels=True</code>を設定してすべてのラベルから 1 つを引く必要があります。ゼロインデックスは <code>255</code> に置き換えられるため、SegFormer の損失関数によって無視されます。",Ss,bs,Ls,ls,Ds,as,qs,Ts,Ks,Us,Il='トレーニング中にメトリクスを含めると、多くの場合、モデルのパフォーマンスを評価するのに役立ちます。 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a> ライブラリを使用して、評価メソッドをすばやくロードできます。このタスクでは、<a href="https://huggingface.co/spaces/evaluate-metric/accuracy" rel="nofollow">Mean Intersection over Union</a> (IoU) メトリックをロードします (🤗 Evaluate <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">クイック ツアー</a> を参照して、メトリクスをロードして計算する方法の詳細を確認してください)。',Ps,$s,Os,Is,_l=`次に、メトリクスを <code>compute</code> する関数を作成します。予測を次のように変換する必要があります
最初にロジットを作成し、次に <code>compute</code> を呼び出す前にラベルのサイズに一致するように再形成します。`,sl,es,ll,ts,al,_s,Cl="これで<code>compute_metrics</code>関数の準備が整いました。トレーニングをセットアップするときにこの関数に戻ります。",el,Cs,tl,ns,nl,ps,pl,Ws,ml,Zs,Wl="モデルを微調整したので、それを推論に使用できるようになりました。",rl,Bs,Zl="推論のために画像をロードします。",cl,ks,il,ms,Bl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/semantic-seg-image.png" alt="Image of bedroom"/>',Ml,rs,ol,cs,jl,Gs,kl='結果を視覚化するには、<a href="https://github.com/tensorflow/models/blob/3f1ca33afe3c1631b733ea7e40c294273b9e406d/research/deeplab/utils/get_dataset_colormap.py#L51" rel="nofollow">データセット カラー パレット</a> を、それぞれをマップする <code>ade_palette()</code> としてロードします。クラスを RGB 値に変換します。次に、画像と予測されたセグメンテーション マップを組み合わせてプロットできます。',gl,xs,hl,is,Gl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/semantic-seg-preds.png" alt="Image of bedroom overlaid with segmentation map"/>',Jl,vs,yl,Ys,wl;return u=new Xs({props:{title:"Semantic segmentation",local:"semantic-segmentation",headingTag:"h1"}}),X=new Kl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/semantic_segmentation.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/semantic_segmentation.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/semantic_segmentation.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/semantic_segmentation.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/semantic_segmentation.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/semantic_segmentation.ipynb"}]}}),$=new ql({props:{id:"dKE8SIt9C-w"}}),k=new ul({props:{$$slots:{default:[Ol]},$$scope:{ctx:Z}}}),S=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlMjBldmFsdWF0ZQ==",highlighted:"pip install -q datasets transformers evaluate",wrap:!1}}),L=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),H=new Xs({props:{title:"Load SceneParse150 dataset",local:"load-sceneparse150-dataset",headingTag:"h2"}}),M=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyc2NlbmVfcGFyc2VfMTUwJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTUwJTVEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;scene_parse_150&quot;</span>, split=<span class="hljs-string">&quot;train[:50]&quot;</span>)`,wrap:!1}}),gs=new v({props:{code:"ZHMlMjAlM0QlMjBkcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMiklMEF0cmFpbl9kcyUyMCUzRCUyMGRzJTVCJTIydHJhaW4lMjIlNUQlMEF0ZXN0X2RzJTIwJTNEJTIwZHMlNUIlMjJ0ZXN0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.train_test_split(test_size=<span class="hljs-number">0.2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds = ds[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),Js=new v({props:{code:"dHJhaW5fZHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x683 at <span class="hljs-number">0x7F9B0C201F90</span>&gt;,
 <span class="hljs-string">&#x27;annotation&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=L size=512x683 at <span class="hljs-number">0x7F9B0C201DD0</span>&gt;,
 <span class="hljs-string">&#x27;scene_category&#x27;</span>: <span class="hljs-number">368</span>}`,wrap:!1}}),fs=new v({props:{code:"aW1wb3J0JTIwanNvbiUwQWZyb20lMjBwYXRobGliJTIwaW1wb3J0JTIwUGF0aCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEElMEFyZXBvX2lkJTIwJTNEJTIwJTIyaHVnZ2luZ2ZhY2UlMkZsYWJlbC1maWxlcyUyMiUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyYWRlMjBrLWlkMmxhYmVsLmpzb24lMjIlMEFpZDJsYWJlbCUyMCUzRCUyMGpzb24ubG9hZHMoUGF0aChoZl9odWJfZG93bmxvYWQocmVwb19pZCUyQyUyMGZpbGVuYW1lJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMikpLnJlYWRfdGV4dCgpKSUwQWlkMmxhYmVsJTIwJTNEJTIwJTdCaW50KGspJTNBJTIwdiUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpZDJsYWJlbC5pdGVtcygpJTdEJTBBbGFiZWwyaWQlMjAlM0QlMjAlN0J2JTNBJTIwayUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpZDJsYWJlbC5pdGVtcygpJTdEJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihpZDJsYWJlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;huggingface/label-files&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>filename = <span class="hljs-string">&quot;ade20k-id2label.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = json.loads(Path(hf_hub_download(repo_id, filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)).read_text())
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {<span class="hljs-built_in">int</span>(k): v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(id2label)`,wrap:!1}}),us=new Xs({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),bs=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJudmlkaWElMkZtaXQtYjAlMjIlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBkb19yZWR1Y2VfbGFiZWxzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;nvidia/mit-b0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint, do_reduce_labels=<span class="hljs-literal">True</span>)`,wrap:!1}}),ls=new Ms({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[la]},$$scope:{ctx:Z}}}),as=new Ms({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[ea]},$$scope:{ctx:Z}}}),Ts=new Xs({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),$s=new v({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMm1lYW5faW91JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = evaluate.load(<span class="hljs-string">&quot;mean_iou&quot;</span>)`,wrap:!1}}),es=new Ms({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[na]},$$scope:{ctx:Z}}}),ts=new Ms({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[ma]},$$scope:{ctx:Z}}}),Cs=new Xs({props:{title:"Train",local:"train",headingTag:"h2"}}),ns=new Ms({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[ia]},$$scope:{ctx:Z}}}),ps=new Ms({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[ja]},$$scope:{ctx:Z}}}),Ws=new Xs({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ks=new v({props:{code:"aW1hZ2UlMjAlM0QlMjBkcyU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),rs=new Ms({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[ha]},$$scope:{ctx:Z}}}),cs=new Ms({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[ya]},$$scope:{ctx:Z}}}),xs=new v({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQWNvbG9yX3NlZyUyMCUzRCUyMG5wLnplcm9zKChwcmVkX3NlZy5zaGFwZSU1QjAlNUQlMkMlMjBwcmVkX3NlZy5zaGFwZSU1QjElNUQlMkMlMjAzKSUyQyUyMGR0eXBlJTNEbnAudWludDgpJTBBcGFsZXR0ZSUyMCUzRCUyMG5wLmFycmF5KGFkZV9wYWxldHRlKCkpJTBBZm9yJTIwbGFiZWwlMkMlMjBjb2xvciUyMGluJTIwZW51bWVyYXRlKHBhbGV0dGUpJTNBJTBBJTIwJTIwJTIwJTIwY29sb3Jfc2VnJTVCcHJlZF9zZWclMjAlM0QlM0QlMjBsYWJlbCUyQyUyMCUzQSU1RCUyMCUzRCUyMGNvbG9yJTBBY29sb3Jfc2VnJTIwJTNEJTIwY29sb3Jfc2VnJTVCLi4uJTJDJTIwJTNBJTNBLTElNUQlMjAlMjAlMjMlMjBjb252ZXJ0JTIwdG8lMjBCR1IlMEElMEFpbWclMjAlM0QlMjBucC5hcnJheShpbWFnZSklMjAqJTIwMC41JTIwJTJCJTIwY29sb3Jfc2VnJTIwKiUyMDAuNSUyMCUyMCUyMyUyMHBsb3QlMjB0aGUlMjBpbWFnZSUyMHdpdGglMjB0aGUlMjBzZWdtZW50YXRpb24lMjBtYXAlMEFpbWclMjAlM0QlMjBpbWcuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQXBsdC5maWd1cmUoZmlnc2l6ZSUzRCgxNSUyQyUyMDEwKSklMEFwbHQuaW1zaG93KGltZyklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>color_seg = np.zeros((pred_seg.shape[<span class="hljs-number">0</span>], pred_seg.shape[<span class="hljs-number">1</span>], <span class="hljs-number">3</span>), dtype=np.uint8)
<span class="hljs-meta">&gt;&gt;&gt; </span>palette = np.array(ade_palette())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> label, color <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(palette):
<span class="hljs-meta">... </span>    color_seg[pred_seg == label, :] = color
<span class="hljs-meta">&gt;&gt;&gt; </span>color_seg = color_seg[..., ::-<span class="hljs-number">1</span>]  <span class="hljs-comment"># convert to BGR</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>img = np.array(image) * <span class="hljs-number">0.5</span> + color_seg * <span class="hljs-number">0.5</span>  <span class="hljs-comment"># plot the image with the segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img = img.astype(np.uint8)

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(img)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),vs=new Pl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/tasks/semantic_segmentation.md"}}),{c(){a=T("meta"),o=c(),l=T("p"),r=c(),g(u.$$.fragment),_=c(),g(X.$$.fragment),B=c(),g($.$$.fragment),R=c(),C=T("p"),C.innerHTML=Y,x=c(),d=T("p"),d.textContent=V,m=c(),b=T("ol"),b.innerHTML=F,j=c(),g(k.$$.fragment),p=c(),I=T("p"),I.textContent=E,A=c(),g(S.$$.fragment),q=c(),N=T("p"),N.textContent=js,Q=c(),g(L.$$.fragment),K=c(),g(H.$$.fragment),P=c(),z=T("p"),z.textContent=Rs,O=c(),g(M.$$.fragment),G=c(),D=T("p"),D.innerHTML=dl,Vs=c(),g(gs.$$.fragment),Fs=c(),hs=T("p"),hs.textContent=bl,Ns=c(),g(Js.$$.fragment),Hs=c(),ys=T("ul"),ys.innerHTML=Tl,zs=c(),ws=T("p"),ws.innerHTML=Ul,As=c(),g(fs.$$.fragment),Qs=c(),g(us.$$.fragment),Es=c(),ds=T("p"),ds.innerHTML=$l,Ss=c(),g(bs.$$.fragment),Ls=c(),g(ls.$$.fragment),Ds=c(),g(as.$$.fragment),qs=c(),g(Ts.$$.fragment),Ks=c(),Us=T("p"),Us.innerHTML=Il,Ps=c(),g($s.$$.fragment),Os=c(),Is=T("p"),Is.innerHTML=_l,sl=c(),g(es.$$.fragment),ll=c(),g(ts.$$.fragment),al=c(),_s=T("p"),_s.innerHTML=Cl,el=c(),g(Cs.$$.fragment),tl=c(),g(ns.$$.fragment),nl=c(),g(ps.$$.fragment),pl=c(),g(Ws.$$.fragment),ml=c(),Zs=T("p"),Zs.textContent=Wl,rl=c(),Bs=T("p"),Bs.textContent=Zl,cl=c(),g(ks.$$.fragment),il=c(),ms=T("div"),ms.innerHTML=Bl,Ml=c(),g(rs.$$.fragment),ol=c(),g(cs.$$.fragment),jl=c(),Gs=T("p"),Gs.innerHTML=kl,gl=c(),g(xs.$$.fragment),hl=c(),is=T("div"),is.innerHTML=Gl,Jl=c(),g(vs.$$.fragment),yl=c(),Ys=T("p"),this.h()},l(s){const n=Ll("svelte-u9bgzb",document.head);a=U(n,"META",{name:!0,content:!0}),n.forEach(e),o=i(s),l=U(s,"P",{}),zl(l).forEach(e),r=i(s),h(u.$$.fragment,s),_=i(s),h(X.$$.fragment,s),B=i(s),h($.$$.fragment,s),R=i(s),C=U(s,"P",{"data-svelte-h":!0}),W(C)!=="svelte-aptwcv"&&(C.innerHTML=Y),x=i(s),d=U(s,"P",{"data-svelte-h":!0}),W(d)!=="svelte-w5jzhi"&&(d.textContent=V),m=i(s),b=U(s,"OL",{"data-svelte-h":!0}),W(b)!=="svelte-1jiwjp7"&&(b.innerHTML=F),j=i(s),h(k.$$.fragment,s),p=i(s),I=U(s,"P",{"data-svelte-h":!0}),W(I)!=="svelte-1lya3k8"&&(I.textContent=E),A=i(s),h(S.$$.fragment,s),q=i(s),N=U(s,"P",{"data-svelte-h":!0}),W(N)!=="svelte-193zy02"&&(N.textContent=js),Q=i(s),h(L.$$.fragment,s),K=i(s),h(H.$$.fragment,s),P=i(s),z=U(s,"P",{"data-svelte-h":!0}),W(z)!=="svelte-1q1mg88"&&(z.textContent=Rs),O=i(s),h(M.$$.fragment,s),G=i(s),D=U(s,"P",{"data-svelte-h":!0}),W(D)!=="svelte-m4w3yq"&&(D.innerHTML=dl),Vs=i(s),h(gs.$$.fragment,s),Fs=i(s),hs=U(s,"P",{"data-svelte-h":!0}),W(hs)!=="svelte-1r6oj5w"&&(hs.textContent=bl),Ns=i(s),h(Js.$$.fragment,s),Hs=i(s),ys=U(s,"UL",{"data-svelte-h":!0}),W(ys)!=="svelte-1qjmioa"&&(ys.innerHTML=Tl),zs=i(s),ws=U(s,"P",{"data-svelte-h":!0}),W(ws)!=="svelte-aqhl7k"&&(ws.innerHTML=Ul),As=i(s),h(fs.$$.fragment,s),Qs=i(s),h(us.$$.fragment,s),Es=i(s),ds=U(s,"P",{"data-svelte-h":!0}),W(ds)!=="svelte-5gp94r"&&(ds.innerHTML=$l),Ss=i(s),h(bs.$$.fragment,s),Ls=i(s),h(ls.$$.fragment,s),Ds=i(s),h(as.$$.fragment,s),qs=i(s),h(Ts.$$.fragment,s),Ks=i(s),Us=U(s,"P",{"data-svelte-h":!0}),W(Us)!=="svelte-cdztvg"&&(Us.innerHTML=Il),Ps=i(s),h($s.$$.fragment,s),Os=i(s),Is=U(s,"P",{"data-svelte-h":!0}),W(Is)!=="svelte-1d4c85c"&&(Is.innerHTML=_l),sl=i(s),h(es.$$.fragment,s),ll=i(s),h(ts.$$.fragment,s),al=i(s),_s=U(s,"P",{"data-svelte-h":!0}),W(_s)!=="svelte-18cw5xr"&&(_s.innerHTML=Cl),el=i(s),h(Cs.$$.fragment,s),tl=i(s),h(ns.$$.fragment,s),nl=i(s),h(ps.$$.fragment,s),pl=i(s),h(Ws.$$.fragment,s),ml=i(s),Zs=U(s,"P",{"data-svelte-h":!0}),W(Zs)!=="svelte-cyrfc8"&&(Zs.textContent=Wl),rl=i(s),Bs=U(s,"P",{"data-svelte-h":!0}),W(Bs)!=="svelte-21b5vl"&&(Bs.textContent=Zl),cl=i(s),h(ks.$$.fragment,s),il=i(s),ms=U(s,"DIV",{class:!0,"data-svelte-h":!0}),W(ms)!=="svelte-11jfm1f"&&(ms.innerHTML=Bl),Ml=i(s),h(rs.$$.fragment,s),ol=i(s),h(cs.$$.fragment,s),jl=i(s),Gs=U(s,"P",{"data-svelte-h":!0}),W(Gs)!=="svelte-e1i4a5"&&(Gs.innerHTML=kl),gl=i(s),h(xs.$$.fragment,s),hl=i(s),is=U(s,"DIV",{class:!0,"data-svelte-h":!0}),W(is)!=="svelte-nsecok"&&(is.innerHTML=Gl),Jl=i(s),h(vs.$$.fragment,s),yl=i(s),Ys=U(s,"P",{}),zl(Ys).forEach(e),this.h()},h(){fl(a,"name","hf:doc:metadata"),fl(a,"content",fa),fl(ms,"class","flex justify-center"),fl(is,"class","flex justify-center")},m(s,n){Dl(document.head,a),t(s,o,n),t(s,l,n),t(s,r,n),J(u,s,n),t(s,_,n),J(X,s,n),t(s,B,n),J($,s,n),t(s,R,n),t(s,C,n),t(s,x,n),t(s,d,n),t(s,m,n),t(s,b,n),t(s,j,n),J(k,s,n),t(s,p,n),t(s,I,n),t(s,A,n),J(S,s,n),t(s,q,n),t(s,N,n),t(s,Q,n),J(L,s,n),t(s,K,n),J(H,s,n),t(s,P,n),t(s,z,n),t(s,O,n),J(M,s,n),t(s,G,n),t(s,D,n),t(s,Vs,n),J(gs,s,n),t(s,Fs,n),t(s,hs,n),t(s,Ns,n),J(Js,s,n),t(s,Hs,n),t(s,ys,n),t(s,zs,n),t(s,ws,n),t(s,As,n),J(fs,s,n),t(s,Qs,n),J(us,s,n),t(s,Es,n),t(s,ds,n),t(s,Ss,n),J(bs,s,n),t(s,Ls,n),J(ls,s,n),t(s,Ds,n),J(as,s,n),t(s,qs,n),J(Ts,s,n),t(s,Ks,n),t(s,Us,n),t(s,Ps,n),J($s,s,n),t(s,Os,n),t(s,Is,n),t(s,sl,n),J(es,s,n),t(s,ll,n),J(ts,s,n),t(s,al,n),t(s,_s,n),t(s,el,n),J(Cs,s,n),t(s,tl,n),J(ns,s,n),t(s,nl,n),J(ps,s,n),t(s,pl,n),J(Ws,s,n),t(s,ml,n),t(s,Zs,n),t(s,rl,n),t(s,Bs,n),t(s,cl,n),J(ks,s,n),t(s,il,n),t(s,ms,n),t(s,Ml,n),J(rs,s,n),t(s,ol,n),J(cs,s,n),t(s,jl,n),t(s,Gs,n),t(s,gl,n),J(xs,s,n),t(s,hl,n),t(s,is,n),t(s,Jl,n),J(vs,s,n),t(s,yl,n),t(s,Ys,n),wl=!0},p(s,[n]){const xl={};n&2&&(xl.$$scope={dirty:n,ctx:s}),k.$set(xl);const vl={};n&2&&(vl.$$scope={dirty:n,ctx:s}),ls.$set(vl);const Xl={};n&2&&(Xl.$$scope={dirty:n,ctx:s}),as.$set(Xl);const Rl={};n&2&&(Rl.$$scope={dirty:n,ctx:s}),es.$set(Rl);const Yl={};n&2&&(Yl.$$scope={dirty:n,ctx:s}),ts.$set(Yl);const Vl={};n&2&&(Vl.$$scope={dirty:n,ctx:s}),ns.$set(Vl);const Fl={};n&2&&(Fl.$$scope={dirty:n,ctx:s}),ps.$set(Fl);const Nl={};n&2&&(Nl.$$scope={dirty:n,ctx:s}),rs.$set(Nl);const Hl={};n&2&&(Hl.$$scope={dirty:n,ctx:s}),cs.$set(Hl)},i(s){wl||(y(u.$$.fragment,s),y(X.$$.fragment,s),y($.$$.fragment,s),y(k.$$.fragment,s),y(S.$$.fragment,s),y(L.$$.fragment,s),y(H.$$.fragment,s),y(M.$$.fragment,s),y(gs.$$.fragment,s),y(Js.$$.fragment,s),y(fs.$$.fragment,s),y(us.$$.fragment,s),y(bs.$$.fragment,s),y(ls.$$.fragment,s),y(as.$$.fragment,s),y(Ts.$$.fragment,s),y($s.$$.fragment,s),y(es.$$.fragment,s),y(ts.$$.fragment,s),y(Cs.$$.fragment,s),y(ns.$$.fragment,s),y(ps.$$.fragment,s),y(Ws.$$.fragment,s),y(ks.$$.fragment,s),y(rs.$$.fragment,s),y(cs.$$.fragment,s),y(xs.$$.fragment,s),y(vs.$$.fragment,s),wl=!0)},o(s){w(u.$$.fragment,s),w(X.$$.fragment,s),w($.$$.fragment,s),w(k.$$.fragment,s),w(S.$$.fragment,s),w(L.$$.fragment,s),w(H.$$.fragment,s),w(M.$$.fragment,s),w(gs.$$.fragment,s),w(Js.$$.fragment,s),w(fs.$$.fragment,s),w(us.$$.fragment,s),w(bs.$$.fragment,s),w(ls.$$.fragment,s),w(as.$$.fragment,s),w(Ts.$$.fragment,s),w($s.$$.fragment,s),w(es.$$.fragment,s),w(ts.$$.fragment,s),w(Cs.$$.fragment,s),w(ns.$$.fragment,s),w(ps.$$.fragment,s),w(Ws.$$.fragment,s),w(ks.$$.fragment,s),w(rs.$$.fragment,s),w(cs.$$.fragment,s),w(xs.$$.fragment,s),w(vs.$$.fragment,s),wl=!1},d(s){s&&(e(o),e(l),e(r),e(_),e(B),e(R),e(C),e(x),e(d),e(m),e(b),e(j),e(p),e(I),e(A),e(q),e(N),e(Q),e(K),e(P),e(z),e(O),e(G),e(D),e(Vs),e(Fs),e(hs),e(Ns),e(Hs),e(ys),e(zs),e(ws),e(As),e(Qs),e(Es),e(ds),e(Ss),e(Ls),e(Ds),e(qs),e(Ks),e(Us),e(Ps),e(Os),e(Is),e(sl),e(ll),e(al),e(_s),e(el),e(tl),e(nl),e(pl),e(ml),e(Zs),e(rl),e(Bs),e(cl),e(il),e(ms),e(Ml),e(ol),e(jl),e(Gs),e(gl),e(hl),e(is),e(Jl),e(yl),e(Ys)),e(a),f(u,s),f(X,s),f($,s),f(k,s),f(S,s),f(L,s),f(H,s),f(M,s),f(gs,s),f(Js,s),f(fs,s),f(us,s),f(bs,s),f(ls,s),f(as,s),f(Ts,s),f($s,s),f(es,s),f(ts,s),f(Cs,s),f(ns,s),f(ps,s),f(Ws,s),f(ks,s),f(rs,s),f(cs,s),f(xs,s),f(vs,s)}}}const fa='{"title":"Semantic segmentation","local":"semantic-segmentation","sections":[{"title":"Load SceneParse150 dataset","local":"load-sceneparse150-dataset","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function ua(Z){return Ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends El{constructor(a){super(),Sl(this,a,ua,wa,Al,{})}}export{Wa as component};
