import{s as ol,f as il,o as rl,n as z}from"../chunks/scheduler.25b97de1.js";import{S as pl,i as cl,g as u,s as p,r as J,A as Ml,h,f as s,c,j as gt,u as f,x as T,k as Ce,y as dl,a as n,v as U,d as w,t as b,w as j}from"../chunks/index.d9030fc9.js";import{T as H}from"../chunks/Tip.baa67368.js";import{C as $}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Y,E as ml}from"../chunks/EditOnGithub.91d95064.js";import{H as Gt,a as ke}from"../chunks/HfOption.1e589c90.js";function yl(I){let t,M='Hugging Face also provides <a href="https://hf.co/docs/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a>, a library dedicated to deploying and serving highly optimized LLMs for inference. It includes deployment-oriented optimization features not included in Transformers, such as continuous batching for increasing throughput and tensor parallelism for multi-GPU inference.';return{c(){t=u("p"),t.innerHTML=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-utq275"&&(t.innerHTML=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function ul(I){let t,M='Currently, only <a href="./model_doc/llama2">Llama</a> and a few other models support static kv-cache and <code>torch.compile</code>. Check <a href="https://github.com/huggingface/transformers/issues/28981" rel="nofollow">this issue</a> for a live model compatibility list.';return{c(){t=u("p"),t.innerHTML=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1cpz1yf"&&(t.innerHTML=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function hl(I){let t,M='Regardless of the strategy used with <code>torch.compile</code>, you can avoid shape-related recompilations if you left-pad your LLM inputs to a limited set of values. The <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizer.__call__.pad_to_multiple_of" rel="nofollow"><code>pad_to_multiple_of</code> tokenizer flag</a> is your friend!';return{c(){t=u("p"),t.innerHTML=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1m3bnto"&&(t.innerHTML=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Tl(I){let t,M='For a more advanced usage of the static cache, such as multi-turn conversations, we recommend instantiating and manipulating the cache object outside <a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. See the advanced usage tab.';return{c(){t=u("p"),t.innerHTML=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1ueh5iw"&&(t.innerHTML=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Jl(I){let t,M='For this example, let’s use the <a href="https://hf.co/google/gemma-2b" rel="nofollow">Gemma</a> model. All we need to do is to:',l,o,i="<li>Access the model’s <code>generation_config</code> attribute and set the <code>cache_implementation</code> to “static”;</li> <li>Call <code>torch.compile</code> on the model to compile the forward pass with the static kv-cache.</li>",r,m,g="And that’s it!",R,G,B,Z,v="Under the hood, <code>generate</code> will attempt to reuse the same cache object, removing the need for re-compilation at each call. Avoiding re-compilation is critical to get the most out of <code>torch.compile</code>, and you should be aware of the following:",F,V,C="<li>If the batch size changes or the maximum output length increases between calls, the cache will have to be reinitialized, triggering a new compilation;</li> <li>The first couple of calls of the compiled function are slower, as the function is being compiled.</li>",X,k,W;return G=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuY2FjaGVfaW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzdGF0aWMlMjIlMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generation_config.cache_implementation = <span class="hljs-string">&quot;static&quot;</span>

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),k=new H({props:{warning:!0,$$slots:{default:[Tl]},$$scope:{ctx:I}}}),{c(){t=u("p"),t.innerHTML=M,l=p(),o=u("ol"),o.innerHTML=i,r=p(),m=u("p"),m.textContent=g,R=p(),J(G.$$.fragment),B=p(),Z=u("p"),Z.innerHTML=v,F=p(),V=u("ol"),V.innerHTML=C,X=p(),J(k.$$.fragment)},l(y){t=h(y,"P",{"data-svelte-h":!0}),T(t)!=="svelte-oys3sj"&&(t.innerHTML=M),l=c(y),o=h(y,"OL",{"data-svelte-h":!0}),T(o)!=="svelte-1fw1ivc"&&(o.innerHTML=i),r=c(y),m=h(y,"P",{"data-svelte-h":!0}),T(m)!=="svelte-9wooxy"&&(m.textContent=g),R=c(y),f(G.$$.fragment,y),B=c(y),Z=h(y,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-yth3sl"&&(Z.innerHTML=v),F=c(y),V=h(y,"OL",{"data-svelte-h":!0}),T(V)!=="svelte-u5kopl"&&(V.innerHTML=C),X=c(y),f(k.$$.fragment,y)},m(y,d){n(y,t,d),n(y,l,d),n(y,o,d),n(y,r,d),n(y,m,d),n(y,R,d),U(G,y,d),n(y,B,d),n(y,Z,d),n(y,F,d),n(y,V,d),n(y,X,d),U(k,y,d),W=!0},p(y,d){const _={};d&2&&(_.$$scope={dirty:d,ctx:y}),k.$set(_)},i(y){W||(w(G.$$.fragment,y),w(k.$$.fragment,y),W=!0)},o(y){b(G.$$.fragment,y),b(k.$$.fragment,y),W=!1},d(y){y&&(s(t),s(l),s(o),s(r),s(m),s(R),s(B),s(Z),s(F),s(V),s(X)),j(G,y),j(k,y)}}}function fl(I){let t,M='If you want to reuse the same <a href="/docs/transformers/pr_29886/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object on a new prompt, be sure to reset its contents with the <code>.reset()</code> method between calls';return{c(){t=u("p"),t.innerHTML=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-3bua72"&&(t.innerHTML=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Ul(I){let t,M='A <a href="/docs/transformers/pr_29886/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can be passed to the model’s <a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> under the <code>past_key_values</code> argument. The object will retain the cache contents, so you can pass it to a new <a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> call to continue generation, like you would do with a dynamic cache.',l,o,i,r,m,g,R='If you want to go further down a level, the <a href="/docs/transformers/pr_29886/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can also be passed to the model’s forward pass under the same <code>past_key_values</code> argument. Using this strategy, you can write your own function to decode the next token given the current token and position and cache position of previously generated tokens.',G,B,Z,v,F="There are a few important things you must do to enable static kv-cache and <code>torch.compile</code> with the <code>StaticCache</code> method:",V,C,X='<li>Initialize the <a href="/docs/transformers/pr_29886/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> instance before using the model for inference. There you can configure parameters like the maximum batch size and sequence length.</li> <li>Call <code>torch.compile</code> on the model to compile the forward pass with the static kv-cache.</li> <li>Set <code>enable_math=True</code> in the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> context manager to enable the native PyTorch C++ implementation of scaled dot product attention to speed up inference even more.</li>',k,W,y;return o=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBvcyUwQW9zLmVudmlyb24lNUIlMjJUT0tFTklaRVJTX1BBUkFMTEVMSVNNJTIyJTVEJTIwJTNEJTIwJTIyZmFsc2UlMjIlMjAlMjAlMjMlMjBUbyUyMHByZXZlbnQlMjBsb25nJTIwd2FybmluZ3MlMjAlM0EpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0X2xlbmd0aCUyMCUzRCUyMGlucHV0X2lkcy5pbnB1dF9pZHMuc2hhcGUlNUIxJTVEJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcubWF4X25ld190b2tlbnMlMjAlM0QlMjAxNiUwQSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFN0YXRpY0NhY2hlKCUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwSWYlMjB5b3UlMjBwbGFuJTIwdG8lMjByZXVzZSUyMHRoZSUyMGNhY2hlJTJDJTIwbWFrZSUyMHN1cmUlMjB0aGUlMjBjYWNoZSUyMGxlbmd0aCUyMGlzJTIwbGFyZ2UlMjBlbm91Z2glMjBmb3IlMjBhbGwlMjBjYXNlcyUwQSUyMCUyMCUyMCUyMG1heF9jYWNoZV9sZW4lM0Rwcm9tcHRfbGVuZ3RoJTJCKG1vZGVsLmdlbmVyYXRpb25fY29uZmlnLm1heF9uZXdfdG9rZW5zKjIpJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTNEbW9kZWwuZGV2aWNlJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0Rtb2RlbC5kdHlwZSUwQSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dF9pZHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QidUaGUlMjB0aGVvcnklMjBvZiUyMHNwZWNpYWwlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwMS4lMjBUaGUlMjBzcGVlZCUyMG9mJTIwbGlnaHQlMjBpcyUyMGNvbnN0YW50JTIwaW4lMjBhbGwlMjBpbmVydGlhbCUyMHJlZmVyZW5jZSUyMGZyYW1lcy4lMjAyJyU1RCUwQSUwQSUyMyUyMHBhc3MlMjBpbiUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBhbmQlMjB0aGUlMjBzYW1lJTIwY2FjaGUlMjBvYmplY3QlMjB0byUyMGNvbnRpbnVlJTIwZ2VuZXJhdGlvbiUyMGZyb20lMjB3aGVyZSUyMGl0JTIwbGVmdCUyMG9mZi4lMjBPcHRpb25hbGx5JTJDJTIwaW4lMjBhJTBBJTIzJTIwbXVsdGktdHVybiUyMGNvbnZlcnNhdGlvbiUyQyUyMGFwcGVuZCUyMHRoZSUyMG5ldyUyMHVzZXIlMjBpbnB1dCUyMHRvJTIwdGhlJTIwZ2VuZXJhdGVkJTIwdGV4dC4lMEFuZXdfaW5wdXRfaWRzJTIwJTNEJTIwb3V0cHV0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShuZXdfaW5wdXRfaWRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UlMjBmcmFtZXMuJTIwMi4lMjBUaGUlMjBzcGVlZCUyMG9mJTIwbGlnaHQlMjBpcyUyMGNvbnN0YW50JTIwaW4lMjBhbGwlMjBpbmVydGlhbCUyMHJlZmVyZW5jZSUyMGZyYW1lcy4lMjAzLiclNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt_length = input_ids.input_ids.shape[<span class="hljs-number">1</span>]
model.generation_config.max_new_tokens = <span class="hljs-number">16</span>

past_key_values = StaticCache(
    config=model.config,
    batch_size=<span class="hljs-number">1</span>,
    <span class="hljs-comment"># If you plan to reuse the cache, make sure the cache length is large enough for all cases</span>
    max_cache_len=prompt_length+(model.generation_config.max_new_tokens*<span class="hljs-number">2</span>),
    device=model.device,
    dtype=model.dtype
)
outputs = model.generate(**input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2&#x27;</span>]

<span class="hljs-comment"># pass in the generated text and the same cache object to continue generation from where it left off. Optionally, in a</span>
<span class="hljs-comment"># multi-turn conversation, append the new user input to the generated text.</span>
new_input_ids = outputs
outputs = model.generate(new_input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2. The speed of light is constant in all inertial reference frames. 3.&#x27;</span>]`,wrap:!1}}),r=new H({props:{warning:!1,$$slots:{default:[fl]},$$scope:{ctx:I}}}),B=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTJDJTIwbG9nZ2luZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudGVzdGluZ191dGlscyUyMGltcG9ydCUyMENhcHR1cmVMb2dnZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbHklMjBwdXQlMkMlMjB0aGUlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjB0aGF0JTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyTXklMjBmYXZvcml0ZSUyMGFsbCUyMHRpbWUlMjBmYXZvcml0ZSUyMGNvbmRpbWVudCUyMGlzJTIwa2V0Y2h1cC4lMjIlMkMlMEElNUQlMEElMEFOVU1fVE9LRU5TX1RPX0dFTkVSQVRFJTIwJTNEJTIwNDAlMEF0b3JjaF9kZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMnJpZ2h0JTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyc2VxdWVudGlhbCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSkudG8obW9kZWwuZGV2aWNlKSUwQSUwQWRlZiUyMGRlY29kZV9vbmVfdG9rZW5zKG1vZGVsJTJDJTIwY3VyX3Rva2VuJTJDJTIwaW5wdXRfcG9zJTJDJTIwY2FjaGVfcG9zaXRpb24lMkMlMjBwYXN0X2tleV92YWx1ZXMpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VyX3Rva2VuJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zaXRpb25faWRzJTNEaW5wdXRfcG9zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGVfcG9zaXRpb24lM0RjYWNoZV9wb3NpdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9kaWN0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSU1QjAlNUQlMEElMjAlMjAlMjAlMjBuZXdfdG9rZW4lMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTVCJTNBJTJDJTIwLTElNUQlMkMlMjBkaW0lM0QtMSklNUIlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbmV3X3Rva2Vu",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizer, LlamaForCausalLM, StaticCache, logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger
<span class="hljs-keyword">import</span> torch

prompts = [
    <span class="hljs-string">&quot;Simply put, the theory of relativity states that &quot;</span>,
    <span class="hljs-string">&quot;My favorite all time favorite condiment is ketchup.&quot;</span>,
]

NUM_TOKENS_TO_GENERATE = <span class="hljs-number">40</span>
torch_device = <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, padding_side=<span class="hljs-string">&quot;right&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;sequential&quot;</span>)
inputs = tokenizer(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>).to(model.device)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_one_tokens</span>(<span class="hljs-params">model, cur_token, input_pos, cache_position, past_key_values</span>):
    logits = model(
        cur_token,
        position_ids=input_pos,
        cache_position=cache_position,
        past_key_values=past_key_values,
        return_dict=<span class="hljs-literal">False</span>,
        use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    new_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">return</span> new_token`,wrap:!1}}),W=new $({props:{code:"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",highlighted:`batch_size, seq_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape
<span class="hljs-keyword">with</span> torch.no_grad():
    past_key_values = StaticCache(
        config=model.config, batch_size=<span class="hljs-number">2</span>, max_cache_len=<span class="hljs-number">4096</span>, device=torch_device, dtype=model.dtype
    )
    cache_position = torch.arange(seq_length, device=torch_device)
    generated_ids = torch.zeros(
        batch_size, seq_length + NUM_TOKENS_TO_GENERATE + <span class="hljs-number">1</span>, dtype=torch.<span class="hljs-built_in">int</span>, device=torch_device
    )
    generated_ids[:, cache_position] = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(torch_device).to(torch.<span class="hljs-built_in">int</span>)

    logits = model(
        **inputs, cache_position=cache_position, past_key_values=past_key_values,return_dict=<span class="hljs-literal">False</span>, use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    next_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    generated_ids[:, seq_length] = next_token[:, <span class="hljs-number">0</span>]

    decode_one_tokens = torch.<span class="hljs-built_in">compile</span>(decode_one_tokens, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    cache_position = torch.tensor([seq_length + <span class="hljs-number">1</span>], device=torch_device)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, NUM_TOKENS_TO_GENERATE):
        <span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>, enable_math=<span class="hljs-literal">True</span>):
            next_token = decode_one_tokens(model, next_token.clone(), <span class="hljs-literal">None</span>, cache_position, past_key_values)
            generated_ids[:, cache_position] = next_token.<span class="hljs-built_in">int</span>()
        cache_position += <span class="hljs-number">1</span>

text = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
text
[<span class="hljs-string">&#x27;Simply put, the theory of relativity states that 1) the speed of light is constant, 2) the speed of light is the same for all observers, and 3) the laws of physics are the same for all observers.&#x27;</span>,
 <span class="hljs-string">&#x27;My favorite all time favorite condiment is ketchup. I love it on everything. I love it on my eggs, my fries, my chicken, my burgers, my hot dogs, my sandwiches, my salads, my p&#x27;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=M,l=p(),J(o.$$.fragment),i=p(),J(r.$$.fragment),m=p(),g=u("p"),g.innerHTML=R,G=p(),J(B.$$.fragment),Z=p(),v=u("p"),v.innerHTML=F,V=p(),C=u("ol"),C.innerHTML=X,k=p(),J(W.$$.fragment)},l(d){t=h(d,"P",{"data-svelte-h":!0}),T(t)!=="svelte-5iv6r8"&&(t.innerHTML=M),l=c(d),f(o.$$.fragment,d),i=c(d),f(r.$$.fragment,d),m=c(d),g=h(d,"P",{"data-svelte-h":!0}),T(g)!=="svelte-4f2nj6"&&(g.innerHTML=R),G=c(d),f(B.$$.fragment,d),Z=c(d),v=h(d,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1haj213"&&(v.innerHTML=F),V=c(d),C=h(d,"OL",{"data-svelte-h":!0}),T(C)!=="svelte-7kp37x"&&(C.innerHTML=X),k=c(d),f(W.$$.fragment,d)},m(d,_){n(d,t,_),n(d,l,_),U(o,d,_),n(d,i,_),U(r,d,_),n(d,m,_),n(d,g,_),n(d,G,_),U(B,d,_),n(d,Z,_),n(d,v,_),n(d,V,_),n(d,C,_),n(d,k,_),U(W,d,_),y=!0},p(d,_){const N={};_&2&&(N.$$scope={dirty:_,ctx:d}),r.$set(N)},i(d){y||(w(o.$$.fragment,d),w(r.$$.fragment,d),w(B.$$.fragment,d),w(W.$$.fragment,d),y=!0)},o(d){b(o.$$.fragment,d),b(r.$$.fragment,d),b(B.$$.fragment,d),b(W.$$.fragment,d),y=!1},d(d){d&&(s(t),s(l),s(i),s(m),s(g),s(G),s(Z),s(v),s(V),s(C),s(k)),j(o,d),j(r,d),j(B,d),j(W,d)}}}function wl(I){let t,M="Compiling the entire <code>generate</code> function, in terms of code, is even simpler than in the basic usage: call <code>torch.compile</code> on <code>generate</code> to compile the entire function. No need to specify the use of the static cache: although it is compatible, dynamic cache (default) was faster in our benchmarks.",l,o,i,r,m="As a result, we compile not only the model forward pass, but also all input preparation, logit processor operations, and so on. The result should be a slightly <code>generate</code> call, compared to the basic usage example, and the compiled graph may be better suited to more exotic hardware devices or use cases. However, there are severe drawbacks in using this approach:",g,R,G="<li>Compilation is much slower;</li> <li>All parameterization of <code>generate</code> must be done through <code>generation_config</code>;</li> <li>Many warnings and exceptions are suppressed — we suggest testing with its uncompiled form first;</li> <li>Although we are working on it, it is heavily feature restricted (for instance, at the time of writing, generation does not stop if an EOS token is selected).</li>",B;return o=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsLmdlbmVyYXRlJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generate = torch.<span class="hljs-built_in">compile</span>(model.generate, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=M,l=p(),J(o.$$.fragment),i=p(),r=u("p"),r.innerHTML=m,g=p(),R=u("ol"),R.innerHTML=G},l(Z){t=h(Z,"P",{"data-svelte-h":!0}),T(t)!=="svelte-5smhof"&&(t.innerHTML=M),l=c(Z),f(o.$$.fragment,Z),i=c(Z),r=h(Z,"P",{"data-svelte-h":!0}),T(r)!=="svelte-1sxxqo6"&&(r.innerHTML=m),g=c(Z),R=h(Z,"OL",{"data-svelte-h":!0}),T(R)!=="svelte-tj5w3v"&&(R.innerHTML=G)},m(Z,v){n(Z,t,v),n(Z,l,v),U(o,Z,v),n(Z,i,v),n(Z,r,v),n(Z,g,v),n(Z,R,v),B=!0},p:z,i(Z){B||(w(o.$$.fragment,Z),B=!0)},o(Z){b(o.$$.fragment,Z),B=!1},d(Z){Z&&(s(t),s(l),s(i),s(r),s(g),s(R)),j(o,Z)}}}function bl(I){let t,M,l,o,i,r;return t=new ke({props:{id:"static-kv",option:"basic usage: generation_config",$$slots:{default:[Jl]},$$scope:{ctx:I}}}),l=new ke({props:{id:"static-kv",option:"advanced usage: control Static Cache",$$slots:{default:[Ul]},$$scope:{ctx:I}}}),i=new ke({props:{id:"static-kv",option:"advanced usage: end-to-end generate compilation",$$slots:{default:[wl]},$$scope:{ctx:I}}}),{c(){J(t.$$.fragment),M=p(),J(l.$$.fragment),o=p(),J(i.$$.fragment)},l(m){f(t.$$.fragment,m),M=c(m),f(l.$$.fragment,m),o=c(m),f(i.$$.fragment,m)},m(m,g){U(t,m,g),n(m,M,g),U(l,m,g),n(m,o,g),U(i,m,g),r=!0},p(m,g){const R={};g&2&&(R.$$scope={dirty:g,ctx:m}),t.$set(R);const G={};g&2&&(G.$$scope={dirty:g,ctx:m}),l.$set(G);const B={};g&2&&(B.$$scope={dirty:g,ctx:m}),i.$set(B)},i(m){r||(w(t.$$.fragment,m),w(l.$$.fragment,m),w(i.$$.fragment,m),r=!0)},o(m){b(t.$$.fragment,m),b(l.$$.fragment,m),b(i.$$.fragment,m),r=!1},d(m){m&&(s(M),s(o)),j(t,m),j(l,m),j(i,m)}}}function jl(I){let t,M='For a more in-depth explanation, take a look at the <a href="https://hf.co/blog/assisted-generation" rel="nofollow">Assisted Generation: a new direction toward low-latency text generation</a> blog post!';return{c(){t=u("p"),t.innerHTML=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-112w74b"&&(t.innerHTML=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Il(I){let t,M="Speculative decoding is only supported for the greedy search and sampling decoding strategies, and it also doesn’t support batched inputs.";return{c(){t=u("p"),t.textContent=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-eq929k"&&(t.textContent=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Zl(I){let t,M;return t=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElNUIlMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwdGhhdCUyMHRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQuJTIwJTIwJTIwJTIwJTIyJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that the speed of light is constant.    &quot;</span>]`,wrap:!1}}),{c(){J(t.$$.fragment)},l(l){f(t.$$.fragment,l)},m(l,o){U(t,l,o),M=!0},p:z,i(l){M||(w(t.$$.fragment,l),M=!0)},o(l){b(t.$$.fragment,l),M=!1},d(l){j(t,l)}}}function gl(I){let t,M='For speculative sampling decoding, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method in addition to the assistant model.',l,o,i;return o=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuNyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJTIyRWluc3RlaW4ncyUyMHRoZW9yeSUyMG9mJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMHRoYXQlMjBtb3Rpb24lMjBpbiUyMHRoZSUyMHVuaXZlcnNlJTIwaXMlMjBub3QlMjBhJTIwc3RyYWlnaHQlMjBsaW5lLiU1Q24lMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that motion in the universe is not a straight line.\\n&quot;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=M,l=p(),J(o.$$.fragment)},l(r){t=h(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1sq00bg"&&(t.innerHTML=M),l=c(r),f(o.$$.fragment,r)},m(r,m){n(r,t,m),n(r,l,m),U(o,r,m),i=!0},p:z,i(r){i||(w(o.$$.fragment,r),i=!0)},o(r){b(o.$$.fragment,r),i=!1},d(r){r&&(s(t),s(l)),j(o,r)}}}function Gl(I){let t,M,l,o;return t=new ke({props:{id:"spec-decoding",option:"greedy search",$$slots:{default:[Zl]},$$scope:{ctx:I}}}),l=new ke({props:{id:"spec-decoding",option:"sampling",$$slots:{default:[gl]},$$scope:{ctx:I}}}),{c(){J(t.$$.fragment),M=p(),J(l.$$.fragment)},l(i){f(t.$$.fragment,i),M=c(i),f(l.$$.fragment,i)},m(i,r){U(t,i,r),n(i,M,r),U(l,i,r),o=!0},p(i,r){const m={};r&2&&(m.$$scope={dirty:r,ctx:i}),t.$set(m);const g={};r&2&&(g.$$scope={dirty:r,ctx:i}),l.$set(g)},i(i){o||(w(t.$$.fragment,i),w(l.$$.fragment,i),o=!0)},o(i){b(t.$$.fragment,i),b(l.$$.fragment,i),o=!1},d(i){i&&s(M),j(t,i),j(l,i)}}}function vl(I){let t,M;return t=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHByb21wdF9sb29rdXBfbnVtX3Rva2VucyUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QidUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVudHJvcHklMjBpbmNyZWFzZXMlMjB3aXRoJTIwdGVtcGVyYXR1cmUuJTIwJTIwJTIwJTIwJTIwJTIwJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The second law of thermodynamics states that entropy increases with temperature.      &#x27;</span>]`,wrap:!1}}),{c(){J(t.$$.fragment)},l(l){f(t.$$.fragment,l)},m(l,o){U(t,l,o),M=!0},p:z,i(l){M||(w(t.$$.fragment,l),M=!0)},o(l){b(t.$$.fragment,l),M=!1},d(l){j(t,l)}}}function _l(I){let t,M='For prompt lookup decoding with sampling, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',l,o,i;return o=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBwcm9tcHRfbG9va3VwX251bV90b2tlbnMlM0QzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRlbXBlcmF0dXJlJTNEMC43KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVuZXJneSUyMGNhbm5vdCUyMGJlJTIwY3JlYXRlZCUyMG5vciUyMGRlc3Ryb3llZC4lMjBJdCdzJTIwbm90JTIwYSUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;The second law of thermodynamics states that energy cannot be created nor destroyed. It&#x27;s not a&quot;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=M,l=p(),J(o.$$.fragment)},l(r){t=h(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-mcrvtx"&&(t.innerHTML=M),l=c(r),f(o.$$.fragment,r)},m(r,m){n(r,t,m),n(r,l,m),U(o,r,m),i=!0},p:z,i(r){i||(w(o.$$.fragment,r),i=!0)},o(r){b(o.$$.fragment,r),i=!1},d(r){r&&(s(t),s(l)),j(o,r)}}}function Rl(I){let t,M,l,o;return t=new ke({props:{id:"pld",option:"greedy decoding",$$slots:{default:[vl]},$$scope:{ctx:I}}}),l=new ke({props:{id:"pld",option:"sampling",$$slots:{default:[_l]},$$scope:{ctx:I}}}),{c(){J(t.$$.fragment),M=p(),J(l.$$.fragment)},l(i){f(t.$$.fragment,i),M=c(i),f(l.$$.fragment,i)},m(i,r){U(t,i,r),n(i,M,r),U(l,i,r),o=!0},p(i,r){const m={};r&2&&(m.$$scope={dirty:r,ctx:i}),t.$set(m);const g={};r&2&&(g.$$scope={dirty:r,ctx:i}),l.$set(g)},i(i){o||(w(t.$$.fragment,i),w(l.$$.fragment,i),o=!0)},o(i){b(t.$$.fragment,i),b(l.$$.fragment,i),o=!1},d(i){i&&s(M),j(t,i),j(l,i)}}}function Bl(I){let t,M="SDPA supports FlashAttention-2 as long as you have the latest PyTorch version installed.";return{c(){t=u("p"),t.textContent=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-12yxz1f"&&(t.textContent=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function kl(I){let t,M='There are many quantization libraries (see the <a href="./quantization">Quantization</a> guide for more details) available, such as Quanto, AQLM, AWQ, and AutoGPTQ. Feel free to try them out and see which one works best for your use case. We also recommend reading the <a href="https://hf.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> blog post which compares AutoGPTQ and bitsandbytes.';return{c(){t=u("p"),t.innerHTML=M},l(l){t=h(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-1b7gbou"&&(t.innerHTML=M)},m(l,o){n(l,t,o)},p:z,d(l){l&&s(t)}}}function Cl(I){let t,M,l,o,i,r,m,g="Large language models (LLMs) have pushed text generation applications, such as chat and code completion models, to the next level by producing text that displays a high level of understanding and fluency. But what makes LLMs so powerful - namely their size - also presents challenges for inference.",R,G,B="Basic inference is slow because LLMs have to be called repeatedly to generate the next token. The input sequence increases as generation progresses, which takes longer and longer for the LLM to process. LLMs also have billions of parameters, making it a challenge to store and handle all those weights in memory.",Z,v,F="This guide will show you how to use the optimization techniques available in Transformers to accelerate LLM inference.",V,C,X,k,W,y,d="During decoding, a LLM computes the key-value (kv) values for each input token and since it is autoregressive, it computes the same kv values each time because the generated output becomes part of the input now. This is not very efficient because you’re recomputing the same kv values each time.",_,N,vt='To optimize this, you can use a kv-cache to store the past keys and values instead of recomputing them each time. However, since the kv-cache grows with each generation step and is dynamic, it prevents you from taking advantage of <a href="./perf_torch_compile"><code>torch.compile</code></a>, a powerful optimization tool that fuses PyTorch code into fast and optimized kernels. We have an entire guide dedicated to kv-caches <a href="./kv_cache">here</a>.',We,O,_t="The <em>static kv-cache</em> solves this issue by pre-allocating the kv-cache size to a maximum value which allows you to combine it with <code>torch.compile</code> for up to a 4x speed up. Your speed up may vary depending on the model size (larger models have a smaller speed up) and hardware.",$e,Q,ze,ee,Rt="There are three flavors of static kv-cache usage, depending on the complexity of your task:",Xe,te,Bt="<li>Basic usage: simply set a flag in <code>generation_config</code> (recommended);</li> <li>Advanced usage: handle a cache object for multi-turn generation or a custom generation loop;</li> <li>Advanced usage: compile the entire <code>generate</code> function into a single graph, if having a single graph is relevant for you.</li>",Fe,le,kt="Select the correct tab below for further instructions on each of these flavors.",Ne,S,Ee,x,Ye,se,He,A,Qe,ae,Ct="Another issue with autoregression is that for each input token you need to load the model weights each time during the forward pass. This is slow and cumbersome for LLMs which have billions of parameters. Speculative decoding alleviates this slowdown by using a second smaller and faster assistant model to generate candidate tokens that are verified by the larger LLM in a single forward pass. If the verified tokens are correct, the LLM essentially gets them for “free” without having to generate them itself. There is no degradation in accuracy because the verification forward pass ensures the same outputs are generated as if the LLM had generated them on its own.",Se,ne,Vt="To get the largest speed up, the assistant model should be a lot smaller than the LLM so that it can generate tokens quickly. The assistant and LLM model must also share the same tokenizer to avoid re-encoding and decoding tokens.",xe,q,Ae,oe,Wt='Enable speculative decoding by loading an assistant model and passing it to the <a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',qe,L,Le,ie,De,re,$t="Prompt lookup decoding is a variant of speculative decoding that is also compatible with greedy search and sampling. Prompt lookup works especially well for input-grounded tasks - such as summarization - where there is often overlapping words between the prompt and output. These overlapping n-grams are used as the LLM candidate tokens.",Ke,pe,zt='To enable prompt lookup decoding, specify the number of tokens that should be overlapping in the <code>prompt_lookup_num_tokens</code> parameter. Then you can pass this parameter to the <a href="/docs/transformers/pr_29886/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',Pe,D,Oe,ce,et,Me,Xt="A known issue with transformer models is that the self-attention mechanism grows quadratically in compute and memory with the number of input tokens. This limitation is only magnified in LLMs which handles much longer sequences. To address this, try FlashAttention2 or PyTorch’s scaled dot product attention (SDPA), which are more memory efficient attention implementations and can accelerate inference.",tt,de,lt,me,Ft='FlashAttention and <a href="./perf_infer_gpu_one#flashattention-2">FlashAttention-2</a> break up the attention computation into smaller chunks and reduces the number of intermediate read/write operations to GPU memory to speed up inference. FlashAttention-2 improves on the original FlashAttention algorithm by also parallelizing over sequence length dimension and better partitioning work on the hardware to reduce synchronization and communication overhead.',st,ye,Nt='To use FlashAttention-2, set <code>attn_implementation=&quot;flash_attention_2&quot;</code> in the <a href="/docs/transformers/pr_29886/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method.',at,ue,nt,he,ot,Te,Et="In addition to optimizing inference, you can also enhance the training efficiency of large language models by leveraging torch.compile during fine-tuning and using a padding-free data collator. This approach can significantly speed up training and reduce computational overhead.",it,Je,Yt="Here’s how you can fine-tune a Llama model using SFTTrainer from the TRL library, with torch_compile enabled and a padding-free data collator:",rt,fe,pt,Ue,ct,we,Ht="Scaled dot product attention (SDPA) is automatically enabled in PyTorch 2.0 and it supports FlashAttention, xFormers, and PyTorch’s C++ implementation. SDPA chooses the most performant attention algorithm if you’re using a CUDA backend. For other backends, SDPA defaults to the PyTorch C++ implementation.",Mt,K,dt,be,Qt='Use the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> context manager to explicitly enable or disable any of the three attention algorithms. For example, set <code>enable_flash=True</code> to enable FlashAttention.',mt,je,yt,Ie,ut,Ze,St="Quantization reduces the size of the LLM weights by storing them in a lower precision. This translates to lower memory usage and makes loading LLMs for inference more accessible if you’re constrained by your GPUs memory. If you aren’t limited by your GPU, you don’t necessarily need to quantize your model because it can incur a small latency cost (except for AWQ and fused AWQ modules) due to the extra step required to quantize and dequantize the weights.",ht,P,Tt,ge,xt='Use the Model Memory Calculator below to estimate and compare how much memory is required to load a model. For example, try estimating how much memory it costs to load <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral-7B-v0.1</a>.',Jt,E,At,ft,Ge,qt='To load Mistral-7B-v0.1 in half-precision, set the <code>torch_dtype</code> parameter in the <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method to <code>torch.bfloat16</code>. This requires 13.74GB of memory.',Ut,ve,wt,_e,Lt='To load a quantized model (8-bit or 4-bit) for inference, try <a href="https://hf.co/docs/bitsandbytes" rel="nofollow">bitsandbytes</a> and set the <code>load_in_4bit</code> or <code>load_in_8bit</code> parameters to <code>True</code>. Loading the model in 8-bits only requires 6.87 GB of memory.',bt,Re,jt,Be,It,Ve,Zt;return i=new Y({props:{title:"LLM inference optimization",local:"llm-inference-optimization",headingTag:"h1"}}),C=new H({props:{warning:!1,$$slots:{default:[yl]},$$scope:{ctx:I}}}),k=new Y({props:{title:"Static kv-cache and torch.compile",local:"static-kv-cache-and-torchcompile",headingTag:"h2"}}),Q=new H({props:{warning:!0,$$slots:{default:[ul]},$$scope:{ctx:I}}}),S=new H({props:{warning:!1,$$slots:{default:[hl]},$$scope:{ctx:I}}}),x=new Gt({props:{id:"static-kv",options:["basic usage: generation_config","advanced usage: control Static Cache","advanced usage: end-to-end generate compilation"],$$slots:{default:[bl]},$$scope:{ctx:I}}}),se=new Y({props:{title:"Speculative decoding",local:"speculative-decoding",headingTag:"h2"}}),A=new H({props:{warning:!1,$$slots:{default:[jl]},$$scope:{ctx:I}}}),q=new H({props:{warning:!0,$$slots:{default:[Il]},$$scope:{ctx:I}}}),L=new Gt({props:{id:"spec-decoding",options:["greedy search","sampling"],$$slots:{default:[Gl]},$$scope:{ctx:I}}}),ie=new Y({props:{title:"Prompt lookup decoding",local:"prompt-lookup-decoding",headingTag:"h3"}}),D=new Gt({props:{id:"pld",options:["greedy decoding","sampling"],$$slots:{default:[Rl]},$$scope:{ctx:I}}}),ce=new Y({props:{title:"Attention optimizations",local:"attention-optimizations",headingTag:"h2"}}),de=new Y({props:{title:"FlashAttention-2",local:"flashattention-2",headingTag:"h3"}}),ue=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),he=new Y({props:{title:"Fine-Tuning with torch.compile and Padding-Free Data Collation",local:"fine-tuning-with-torchcompile-and-padding-free-data-collation",headingTag:"h3"}}),fe=new $({props:{code:"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",highlighted:`#################### IMPORTS ###################

<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">import</span> dataclasses
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,
    AutoTokenizer,
    TrainingArguments
)
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

#################### MODEL LOADING WITH FLASH ATTENTION ###################

model_name = <span class="hljs-string">&quot;meta-llama/Llama-3.2-1B&quot;</span>
model = AutoModelForCausalLM.from_pretrained(
    model_name,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>  # Enables FlashAttention<span class="hljs-number">-2</span>
)
tokenizer = AutoTokenizer.from_pretrained(model_name, use_fast=<span class="hljs-literal">True</span>)

#################### DATA PREPROCESSING (PADDING-FREE) ###################

response_template = <span class="hljs-string">&quot;\\n### Label:&quot;</span>
response_template_ids = tokenizer.encode(
    response_template, add_special_tokens=<span class="hljs-literal">False</span>
)[<span class="hljs-number">2</span>:]  # Exclude <span class="hljs-keyword">special</span> tokens

data_collator = DataCollatorForCompletionOnlyLM(
    response_template_ids=response_template_ids,
    tokenizer=tokenizer,
    ignore_index=<span class="hljs-number">-100</span>,
    padding_free=<span class="hljs-literal">True</span>  # Enables padding-free collation
)

def format_dataset(example):
    return {
        <span class="hljs-string">&quot;output&quot;</span>: example[<span class="hljs-string">&quot;output&quot;</span>] + tokenizer.eos_token
    }

data_files = {<span class="hljs-string">&quot;train&quot;</span>: <span class="hljs-string">&quot;path/to/dataset&quot;</span>}  # Replace <span class="hljs-keyword">with</span> your dataset path
json_dataset = datasets.load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files)
formatted_train_dataset = json_dataset[<span class="hljs-string">&quot;train&quot;</span>].map(format_dataset)

################# TRAINING CONFIGURATION ############################

train_args = TrainingArguments(
    num_train_epochs=<span class="hljs-number">5</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    weight_decay=<span class="hljs-number">0.0</span>,
    warmup_ratio=<span class="hljs-number">0.03</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,
    logging_steps=<span class="hljs-number">1</span>,
    include_tokens_per_second=<span class="hljs-literal">True</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    torch_compile=<span class="hljs-literal">True</span>,  # Enables torch.compile
    torch_compile_backend=<span class="hljs-string">&quot;inductor&quot;</span>,
    torch_compile_mode=<span class="hljs-string">&quot;default&quot;</span>
)

# Convert TrainingArguments to SFTConfig
transformer_train_arg_fields = [x.name for x <span class="hljs-keyword">in</span> dataclasses.fields(SFTConfig)]
transformer_kwargs = {
    k: v
    for k, v <span class="hljs-keyword">in</span> train_args.to_dict().items()
    <span class="hljs-keyword">if</span> k <span class="hljs-keyword">in</span> transformer_train_arg_fields
}
training_args = SFTConfig(**transformer_kwargs)

####################### FINE-TUNING #####################

trainer = SFTTrainer(
    model=model,
    tokenizer=tokenizer,
    train_dataset=formatted_train_dataset,
    data_collator=data_collator,
    dataset_text_field=<span class="hljs-string">&quot;output&quot;</span>,
    args=training_args,
)
trainer.train()`,wrap:!1}}),Ue=new Y({props:{title:"PyTorch scaled dot product attention",local:"pytorch-scaled-dot-product-attention",headingTag:"h3"}}),K=new H({props:{warning:!1,$$slots:{default:[Bl]},$$scope:{ctx:I}}}),je=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZnZW1tYS0yYiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    outputs = model.generate(**inputs)`,wrap:!1}}),Ie=new Y({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),P=new H({props:{warning:!1,$$slots:{default:[kl]},$$scope:{ctx:I}}}),ve=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)`,wrap:!1}}),Re=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=quant_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Be=new ml({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_optims.md"}}),{c(){t=u("meta"),M=p(),l=u("p"),o=p(),J(i.$$.fragment),r=p(),m=u("p"),m.textContent=g,R=p(),G=u("p"),G.textContent=B,Z=p(),v=u("p"),v.textContent=F,V=p(),J(C.$$.fragment),X=p(),J(k.$$.fragment),W=p(),y=u("p"),y.textContent=d,_=p(),N=u("p"),N.innerHTML=vt,We=p(),O=u("p"),O.innerHTML=_t,$e=p(),J(Q.$$.fragment),ze=p(),ee=u("p"),ee.textContent=Rt,Xe=p(),te=u("ol"),te.innerHTML=Bt,Fe=p(),le=u("p"),le.textContent=kt,Ne=p(),J(S.$$.fragment),Ee=p(),J(x.$$.fragment),Ye=p(),J(se.$$.fragment),He=p(),J(A.$$.fragment),Qe=p(),ae=u("p"),ae.textContent=Ct,Se=p(),ne=u("p"),ne.textContent=Vt,xe=p(),J(q.$$.fragment),Ae=p(),oe=u("p"),oe.innerHTML=Wt,qe=p(),J(L.$$.fragment),Le=p(),J(ie.$$.fragment),De=p(),re=u("p"),re.textContent=$t,Ke=p(),pe=u("p"),pe.innerHTML=zt,Pe=p(),J(D.$$.fragment),Oe=p(),J(ce.$$.fragment),et=p(),Me=u("p"),Me.textContent=Xt,tt=p(),J(de.$$.fragment),lt=p(),me=u("p"),me.innerHTML=Ft,st=p(),ye=u("p"),ye.innerHTML=Nt,at=p(),J(ue.$$.fragment),nt=p(),J(he.$$.fragment),ot=p(),Te=u("p"),Te.textContent=Et,it=p(),Je=u("p"),Je.textContent=Yt,rt=p(),J(fe.$$.fragment),pt=p(),J(Ue.$$.fragment),ct=p(),we=u("p"),we.textContent=Ht,Mt=p(),J(K.$$.fragment),dt=p(),be=u("p"),be.innerHTML=Qt,mt=p(),J(je.$$.fragment),yt=p(),J(Ie.$$.fragment),ut=p(),Ze=u("p"),Ze.textContent=St,ht=p(),J(P.$$.fragment),Tt=p(),ge=u("p"),ge.innerHTML=xt,Jt=p(),E=u("iframe"),ft=p(),Ge=u("p"),Ge.innerHTML=qt,Ut=p(),J(ve.$$.fragment),wt=p(),_e=u("p"),_e.innerHTML=Lt,bt=p(),J(Re.$$.fragment),jt=p(),J(Be.$$.fragment),It=p(),Ve=u("p"),this.h()},l(e){const a=Ml("svelte-u9bgzb",document.head);t=h(a,"META",{name:!0,content:!0}),a.forEach(s),M=c(e),l=h(e,"P",{}),gt(l).forEach(s),o=c(e),f(i.$$.fragment,e),r=c(e),m=h(e,"P",{"data-svelte-h":!0}),T(m)!=="svelte-1kjw8nj"&&(m.textContent=g),R=c(e),G=h(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-1l3iyos"&&(G.textContent=B),Z=c(e),v=h(e,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1wb7yan"&&(v.textContent=F),V=c(e),f(C.$$.fragment,e),X=c(e),f(k.$$.fragment,e),W=c(e),y=h(e,"P",{"data-svelte-h":!0}),T(y)!=="svelte-bq37ce"&&(y.textContent=d),_=c(e),N=h(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-w4nvh4"&&(N.innerHTML=vt),We=c(e),O=h(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-jt9td8"&&(O.innerHTML=_t),$e=c(e),f(Q.$$.fragment,e),ze=c(e),ee=h(e,"P",{"data-svelte-h":!0}),T(ee)!=="svelte-1439wi2"&&(ee.textContent=Rt),Xe=c(e),te=h(e,"OL",{"data-svelte-h":!0}),T(te)!=="svelte-165n3j5"&&(te.innerHTML=Bt),Fe=c(e),le=h(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-etip6m"&&(le.textContent=kt),Ne=c(e),f(S.$$.fragment,e),Ee=c(e),f(x.$$.fragment,e),Ye=c(e),f(se.$$.fragment,e),He=c(e),f(A.$$.fragment,e),Qe=c(e),ae=h(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-18z9bzk"&&(ae.textContent=Ct),Se=c(e),ne=h(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-1nm1j4o"&&(ne.textContent=Vt),xe=c(e),f(q.$$.fragment,e),Ae=c(e),oe=h(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-1ixbm0o"&&(oe.innerHTML=Wt),qe=c(e),f(L.$$.fragment,e),Le=c(e),f(ie.$$.fragment,e),De=c(e),re=h(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-123yl06"&&(re.textContent=$t),Ke=c(e),pe=h(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-1b3scnj"&&(pe.innerHTML=zt),Pe=c(e),f(D.$$.fragment,e),Oe=c(e),f(ce.$$.fragment,e),et=c(e),Me=h(e,"P",{"data-svelte-h":!0}),T(Me)!=="svelte-zxt0p7"&&(Me.textContent=Xt),tt=c(e),f(de.$$.fragment,e),lt=c(e),me=h(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-pa091d"&&(me.innerHTML=Ft),st=c(e),ye=h(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-1k6zdgj"&&(ye.innerHTML=Nt),at=c(e),f(ue.$$.fragment,e),nt=c(e),f(he.$$.fragment,e),ot=c(e),Te=h(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-avgiyv"&&(Te.textContent=Et),it=c(e),Je=h(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-1wz30yc"&&(Je.textContent=Yt),rt=c(e),f(fe.$$.fragment,e),pt=c(e),f(Ue.$$.fragment,e),ct=c(e),we=h(e,"P",{"data-svelte-h":!0}),T(we)!=="svelte-16n93px"&&(we.textContent=Ht),Mt=c(e),f(K.$$.fragment,e),dt=c(e),be=h(e,"P",{"data-svelte-h":!0}),T(be)!=="svelte-cbkj1o"&&(be.innerHTML=Qt),mt=c(e),f(je.$$.fragment,e),yt=c(e),f(Ie.$$.fragment,e),ut=c(e),Ze=h(e,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-x4c749"&&(Ze.textContent=St),ht=c(e),f(P.$$.fragment,e),Tt=c(e),ge=h(e,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-1i2aaqz"&&(ge.innerHTML=xt),Jt=c(e),E=h(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),gt(E).forEach(s),ft=c(e),Ge=h(e,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-1h2017c"&&(Ge.innerHTML=qt),Ut=c(e),f(ve.$$.fragment,e),wt=c(e),_e=h(e,"P",{"data-svelte-h":!0}),T(_e)!=="svelte-a32zwr"&&(_e.innerHTML=Lt),bt=c(e),f(Re.$$.fragment,e),jt=c(e),f(Be.$$.fragment,e),It=c(e),Ve=h(e,"P",{}),gt(Ve).forEach(s),this.h()},h(){Ce(t,"name","hf:doc:metadata"),Ce(t,"content",Vl),il(E.src,At="https://hf-accelerate-model-memory-usage.hf.space")||Ce(E,"src",At),Ce(E,"frameborder","0"),Ce(E,"width","850"),Ce(E,"height","450")},m(e,a){dl(document.head,t),n(e,M,a),n(e,l,a),n(e,o,a),U(i,e,a),n(e,r,a),n(e,m,a),n(e,R,a),n(e,G,a),n(e,Z,a),n(e,v,a),n(e,V,a),U(C,e,a),n(e,X,a),U(k,e,a),n(e,W,a),n(e,y,a),n(e,_,a),n(e,N,a),n(e,We,a),n(e,O,a),n(e,$e,a),U(Q,e,a),n(e,ze,a),n(e,ee,a),n(e,Xe,a),n(e,te,a),n(e,Fe,a),n(e,le,a),n(e,Ne,a),U(S,e,a),n(e,Ee,a),U(x,e,a),n(e,Ye,a),U(se,e,a),n(e,He,a),U(A,e,a),n(e,Qe,a),n(e,ae,a),n(e,Se,a),n(e,ne,a),n(e,xe,a),U(q,e,a),n(e,Ae,a),n(e,oe,a),n(e,qe,a),U(L,e,a),n(e,Le,a),U(ie,e,a),n(e,De,a),n(e,re,a),n(e,Ke,a),n(e,pe,a),n(e,Pe,a),U(D,e,a),n(e,Oe,a),U(ce,e,a),n(e,et,a),n(e,Me,a),n(e,tt,a),U(de,e,a),n(e,lt,a),n(e,me,a),n(e,st,a),n(e,ye,a),n(e,at,a),U(ue,e,a),n(e,nt,a),U(he,e,a),n(e,ot,a),n(e,Te,a),n(e,it,a),n(e,Je,a),n(e,rt,a),U(fe,e,a),n(e,pt,a),U(Ue,e,a),n(e,ct,a),n(e,we,a),n(e,Mt,a),U(K,e,a),n(e,dt,a),n(e,be,a),n(e,mt,a),U(je,e,a),n(e,yt,a),U(Ie,e,a),n(e,ut,a),n(e,Ze,a),n(e,ht,a),U(P,e,a),n(e,Tt,a),n(e,ge,a),n(e,Jt,a),n(e,E,a),n(e,ft,a),n(e,Ge,a),n(e,Ut,a),U(ve,e,a),n(e,wt,a),n(e,_e,a),n(e,bt,a),U(Re,e,a),n(e,jt,a),U(Be,e,a),n(e,It,a),n(e,Ve,a),Zt=!0},p(e,[a]){const Dt={};a&2&&(Dt.$$scope={dirty:a,ctx:e}),C.$set(Dt);const Kt={};a&2&&(Kt.$$scope={dirty:a,ctx:e}),Q.$set(Kt);const Pt={};a&2&&(Pt.$$scope={dirty:a,ctx:e}),S.$set(Pt);const Ot={};a&2&&(Ot.$$scope={dirty:a,ctx:e}),x.$set(Ot);const el={};a&2&&(el.$$scope={dirty:a,ctx:e}),A.$set(el);const tl={};a&2&&(tl.$$scope={dirty:a,ctx:e}),q.$set(tl);const ll={};a&2&&(ll.$$scope={dirty:a,ctx:e}),L.$set(ll);const sl={};a&2&&(sl.$$scope={dirty:a,ctx:e}),D.$set(sl);const al={};a&2&&(al.$$scope={dirty:a,ctx:e}),K.$set(al);const nl={};a&2&&(nl.$$scope={dirty:a,ctx:e}),P.$set(nl)},i(e){Zt||(w(i.$$.fragment,e),w(C.$$.fragment,e),w(k.$$.fragment,e),w(Q.$$.fragment,e),w(S.$$.fragment,e),w(x.$$.fragment,e),w(se.$$.fragment,e),w(A.$$.fragment,e),w(q.$$.fragment,e),w(L.$$.fragment,e),w(ie.$$.fragment,e),w(D.$$.fragment,e),w(ce.$$.fragment,e),w(de.$$.fragment,e),w(ue.$$.fragment,e),w(he.$$.fragment,e),w(fe.$$.fragment,e),w(Ue.$$.fragment,e),w(K.$$.fragment,e),w(je.$$.fragment,e),w(Ie.$$.fragment,e),w(P.$$.fragment,e),w(ve.$$.fragment,e),w(Re.$$.fragment,e),w(Be.$$.fragment,e),Zt=!0)},o(e){b(i.$$.fragment,e),b(C.$$.fragment,e),b(k.$$.fragment,e),b(Q.$$.fragment,e),b(S.$$.fragment,e),b(x.$$.fragment,e),b(se.$$.fragment,e),b(A.$$.fragment,e),b(q.$$.fragment,e),b(L.$$.fragment,e),b(ie.$$.fragment,e),b(D.$$.fragment,e),b(ce.$$.fragment,e),b(de.$$.fragment,e),b(ue.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),b(Ue.$$.fragment,e),b(K.$$.fragment,e),b(je.$$.fragment,e),b(Ie.$$.fragment,e),b(P.$$.fragment,e),b(ve.$$.fragment,e),b(Re.$$.fragment,e),b(Be.$$.fragment,e),Zt=!1},d(e){e&&(s(M),s(l),s(o),s(r),s(m),s(R),s(G),s(Z),s(v),s(V),s(X),s(W),s(y),s(_),s(N),s(We),s(O),s($e),s(ze),s(ee),s(Xe),s(te),s(Fe),s(le),s(Ne),s(Ee),s(Ye),s(He),s(Qe),s(ae),s(Se),s(ne),s(xe),s(Ae),s(oe),s(qe),s(Le),s(De),s(re),s(Ke),s(pe),s(Pe),s(Oe),s(et),s(Me),s(tt),s(lt),s(me),s(st),s(ye),s(at),s(nt),s(ot),s(Te),s(it),s(Je),s(rt),s(pt),s(ct),s(we),s(Mt),s(dt),s(be),s(mt),s(yt),s(ut),s(Ze),s(ht),s(Tt),s(ge),s(Jt),s(E),s(ft),s(Ge),s(Ut),s(wt),s(_e),s(bt),s(jt),s(It),s(Ve)),s(t),j(i,e),j(C,e),j(k,e),j(Q,e),j(S,e),j(x,e),j(se,e),j(A,e),j(q,e),j(L,e),j(ie,e),j(D,e),j(ce,e),j(de,e),j(ue,e),j(he,e),j(fe,e),j(Ue,e),j(K,e),j(je,e),j(Ie,e),j(P,e),j(ve,e),j(Re,e),j(Be,e)}}}const Vl='{"title":"LLM inference optimization","local":"llm-inference-optimization","sections":[{"title":"Static kv-cache and torch.compile","local":"static-kv-cache-and-torchcompile","sections":[],"depth":2},{"title":"Speculative decoding","local":"speculative-decoding","sections":[{"title":"Prompt lookup decoding","local":"prompt-lookup-decoding","sections":[],"depth":3}],"depth":2},{"title":"Attention optimizations","local":"attention-optimizations","sections":[{"title":"FlashAttention-2","local":"flashattention-2","sections":[],"depth":3},{"title":"Fine-Tuning with torch.compile and Padding-Free Data Collation","local":"fine-tuning-with-torchcompile-and-padding-free-data-collation","sections":[],"depth":3},{"title":"PyTorch scaled dot product attention","local":"pytorch-scaled-dot-product-attention","sections":[],"depth":3}],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2}],"depth":1}';function Wl(I){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yl extends pl{constructor(t){super(),cl(this,t,Wl,Cl,ol,{})}}export{Yl as component};
