import{s as ss,o as ls,n as as}from"../chunks/scheduler.25b97de1.js";import{S as ns,i as is,g as i,s as a,r,m as ps,A as rs,h as p,f as s,c as n,j as ts,u as o,x as d,n as os,k as _t,y as ms,a as l,v as m,d as M,t as c,w as y}from"../chunks/index.d9030fc9.js";import{T as Ms}from"../chunks/Tip.baa67368.js";import{C as h}from"../chunks/CodeBlock.e6cd0d95.js";import{D as cs}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as Je,E as ys}from"../chunks/EditOnGithub.91d95064.js";function ds(Ue){let u,b="Many image captioning datasets contain multiple captions per image. In those cases, a common strategy is to randomly sample a caption amongst the available ones during training.";return{c(){u=i("p"),u.textContent=b},l(f){u=p(f,"P",{"data-svelte-h":!0}),d(u)!=="svelte-n6sigx"&&(u.textContent=b)},m(f,be){l(f,u,be)},p:as,d(f){f&&s(u)}}}function hs(Ue){let u,b,f,be,T,je,U,$e,j,Ct=`Image captioning is the task of predicting a caption for a given image. Common real world applications of it include
aiding visually impaired people that can help them navigate through different situations. Therefore, image captioning
helps to improve content accessibility for people by describing images to them.`,_e,$,kt="This guide will show you how to:",Ce,_,It="<li>Fine-tune an image captioning model.</li> <li>Use the fine-tuned model for inference.</li>",ke,C,vt="Before you begin, make sure you have all the necessary libraries installed:",Ie,k,ve,I,Bt="We encourage you to log in to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to log in:",Be,v,We,B,Ze,W,Wt=`Use the 🤗 Dataset library to load a dataset that consists of {image-caption} pairs. To create your own image captioning dataset
in PyTorch, you can follow <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/GIT/Fine_tune_GIT_on_an_image_captioning_dataset.ipynb" rel="nofollow">this notebook</a>.`,Ge,Z,xe,G,Re,x,Zt="The dataset has two features, <code>image</code> and <code>text</code>.",He,w,Xe,R,Gt='Split the dataset’s train split into a train and test set with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.train_test_split" rel="nofollow">train_test_split</a> method:',Ve,H,Ye,X,xt="Let’s visualize a couple of samples from the training set.",Ee,V,ze,g,Rt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_training_images_image_cap.png" alt="Sample training images"/>',Qe,Y,Fe,E,Ht="Since the dataset has two modalities (image and text), the pre-processing pipeline will preprocess images and the captions.",Ne,z,Xt="To do so, load the processor class associated with the model you are about to fine-tune.",Ae,Q,Se,F,Vt="The processor will internally pre-process the image (which includes resizing, and pixel scaling) and tokenize the caption.",qe,N,Le,A,Yt="With the dataset ready, you can now set up the model for fine-tuning.",Pe,S,Ke,q,Et='Load the <a href="https://huggingface.co/microsoft/git-base" rel="nofollow">“microsoft/git-base”</a> into a <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoModelForCausalLM" rel="nofollow"><code>AutoModelForCausalLM</code></a> object.',De,L,Oe,P,et,K,zt='Image captioning models are typically evaluated with the <a href="https://huggingface.co/spaces/evaluate-metric/rouge" rel="nofollow">Rouge Score</a> or <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">Word Error Rate</a>. For this guide, you will use the Word Error Rate (WER).',tt,D,Qt='We use the 🤗 Evaluate library to do so. For potential limitations and other gotchas of the WER, refer to <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">this guide</a>.',st,O,lt,ee,at,te,Ft='Now, you are ready to start fine-tuning the model. You will use the 🤗 <a href="/docs/transformers/pr_29261/en/main_classes/trainer#transformers.Trainer">Trainer</a> for this.',nt,se,Nt='First, define the training arguments using <a href="/docs/transformers/pr_29261/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.',it,le,pt,ae,At="Then pass them along with the datasets and the model to 🤗 Trainer.",rt,ne,ot,ie,St='To start training, simply call <a href="/docs/transformers/pr_29261/en/main_classes/trainer#transformers.Trainer.train">train()</a> on the <a href="/docs/transformers/pr_29261/en/main_classes/trainer#transformers.Trainer">Trainer</a> object.',mt,pe,Mt,re,qt="You should see the training loss drop smoothly as training progresses.",ct,oe,Lt='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/pr_29261/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',yt,me,dt,Me,ht,ce,Pt="Take a sample image from <code>test_ds</code> to test the model.",ut,ye,ft,J,Kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/test_image_image_cap.png" alt="Test image"/>',wt,de,gt,he,Dt="Call <code>generate</code> and decode the predictions.",Jt,ue,bt,fe,Tt,we,Ot="Looks like the fine-tuned model generated a pretty good caption!",Ut,ge,jt,Te,$t;return T=new Je({props:{title:"Image captioning",local:"image-captioning",headingTag:"h1"}}),U=new cs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_captioning.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_captioning.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_captioning.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_captioning.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_captioning.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_captioning.ipynb"}]}}),k=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGUlMjAtcSUwQXBpcCUyMGluc3RhbGwlMjBqaXdlciUyMC1x",highlighted:`pip install transformers datasets evaluate -q
pip install jiwer -q`,wrap:!1}}),v=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),B=new Je({props:{title:"Load the Pokémon BLIP captions dataset",local:"load-the-pokémon-blip-captions-dataset",headingTag:"h2"}}),Z=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybGFtYmRhbGFicyUyRnBva2Vtb24tYmxpcC1jYXB0aW9ucyUyMiklMEFkcw==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;lambdalabs/pokemon-blip-captions&quot;</span>)
ds`,wrap:!1}}),G=new h({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2ltYWdlJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwODMzJTBBJTIwJTIwJTIwJTIwJTdEKSUwQSU3RCk=",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
        num_rows: 833
    })
})`,wrap:!1}}),w=new Ms({props:{$$slots:{default:[ds]},$$scope:{ctx:Ue}}}),H=new h({props:{code:"ZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC4xKSUwQXRyYWluX2RzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RCUwQXRlc3RfZHMlMjAlM0QlMjBkcyU1QiUyMnRlc3QlMjIlNUQ=",highlighted:`ds = ds[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>)
train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
test_ds = ds[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),V=new h({props:{code:"ZnJvbSUyMHRleHR3cmFwJTIwaW1wb3J0JTIwd3JhcCUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEElMEFkZWYlMjBwbG90X2ltYWdlcyhpbWFnZXMlMkMlMjBjYXB0aW9ucyklM0ElMEElMjAlMjAlMjAlMjBwbHQuZmlndXJlKGZpZ3NpemUlM0QoMjAlMkMlMjAyMCkpJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGltYWdlcykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdCgxJTJDJTIwbGVuKGltYWdlcyklMkMlMjBpJTIwJTJCJTIwMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXB0aW9uJTIwJTNEJTIwY2FwdGlvbnMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FwdGlvbiUyMCUzRCUyMCUyMiU1Q24lMjIuam9pbih3cmFwKGNhcHRpb24lMkMlMjAxMikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0LnRpdGxlKGNhcHRpb24pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0Lmltc2hvdyhpbWFnZXMlNUJpJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBsdC5heGlzKCUyMm9mZiUyMiklMEElMEElMEFzYW1wbGVfaW1hZ2VzX3RvX3Zpc3VhbGl6ZSUyMCUzRCUyMCU1Qm5wLmFycmF5KHRyYWluX2RzJTVCaSU1RCU1QiUyMmltYWdlJTIyJTVEKSUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBc2FtcGxlX2NhcHRpb25zJTIwJTNEJTIwJTVCdHJhaW5fZHMlNUJpJTVEJTVCJTIydGV4dCUyMiU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBcGxvdF9pbWFnZXMoc2FtcGxlX2ltYWdlc190b192aXN1YWxpemUlMkMlMjBzYW1wbGVfY2FwdGlvbnMp",highlighted:`<span class="hljs-keyword">from</span> textwrap <span class="hljs-keyword">import</span> wrap
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_images</span>(<span class="hljs-params">images, captions</span>):
    plt.figure(figsize=(<span class="hljs-number">20</span>, <span class="hljs-number">20</span>))
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(images)):
        ax = plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(images), i + <span class="hljs-number">1</span>)
        caption = captions[i]
        caption = <span class="hljs-string">&quot;\\n&quot;</span>.join(wrap(caption, <span class="hljs-number">12</span>))
        plt.title(caption)
        plt.imshow(images[i])
        plt.axis(<span class="hljs-string">&quot;off&quot;</span>)


sample_images_to_visualize = [np.array(train_ds[i][<span class="hljs-string">&quot;image&quot;</span>]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>)]
sample_captions = [train_ds[i][<span class="hljs-string">&quot;text&quot;</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>)]
plot_images(sample_images_to_visualize, sample_captions)`,wrap:!1}}),Y=new Je({props:{title:"Preprocess the dataset",local:"preprocess-the-dataset",headingTag:"h2"}}),Q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGZ2l0LWJhc2UlMjIlMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

checkpoint = <span class="hljs-string">&quot;microsoft/git-base&quot;</span>
processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),N=new h({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjAlMjAlMjAlMjBjYXB0aW9ucyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIydGV4dCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZXMlMkMlMjB0ZXh0JTNEY2FwdGlvbnMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiklMEElMjAlMjAlMjAlMjBpbnB1dHMudXBkYXRlKCU3QiUyMmxhYmVscyUyMiUzQSUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU3RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEF0cmFpbl9kcy5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMpJTBBdGVzdF9kcy5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">example_batch</span>):
    images = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    captions = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;text&quot;</span>]]
    inputs = processor(images=images, text=captions, padding=<span class="hljs-string">&quot;max_length&quot;</span>)
    inputs.update({<span class="hljs-string">&quot;labels&quot;</span>: inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]})
    <span class="hljs-keyword">return</span> inputs


train_ds.set_transform(transforms)
test_ds.set_transform(transforms)`,wrap:!1}}),S=new Je({props:{title:"Load a base model",local:"load-a-base-model",headingTag:"h2"}}),L=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(checkpoint)`,wrap:!1}}),P=new Je({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),O=new h({props:{code:"ZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwbG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBd2VyJTIwJTNEJTIwbG9hZCglMjJ3ZXIlMjIpJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKSUwQSUyMCUyMCUyMCUyMGRlY29kZWRfbGFiZWxzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShsYWJlbHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBkZWNvZGVkX3ByZWRpY3Rpb25zJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkaWN0ZWQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjB3ZXJfc2NvcmUlMjAlM0QlMjB3ZXIuY29tcHV0ZShwcmVkaWN0aW9ucyUzRGRlY29kZWRfcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEZGVjb2RlZF9sYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyd2VyX3Njb3JlJTIyJTNBJTIwd2VyX3Njb3JlJTdE",highlighted:`<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> load
<span class="hljs-keyword">import</span> torch

wer = load(<span class="hljs-string">&quot;wer&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    logits, labels = eval_pred
    predicted = logits.argmax(-<span class="hljs-number">1</span>)
    decoded_labels = processor.batch_decode(labels, skip_special_tokens=<span class="hljs-literal">True</span>)
    decoded_predictions = processor.batch_decode(predicted, skip_special_tokens=<span class="hljs-literal">True</span>)
    wer_score = wer.compute(predictions=decoded_predictions, references=decoded_labels)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_score&quot;</span>: wer_score}`,wrap:!1}}),ee=new Je({props:{title:"Train!",local:"train",headingTag:"h2"}}),le=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjBjaGVja3BvaW50LnNwbGl0KCUyMiUyRiUyMiklNUIxJTVEJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RmJTIyJTdCbW9kZWxfbmFtZSU3RC1wb2tlbW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMyUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfbmFtZXMlM0QlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

model_name = checkpoint.split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-pokemon&quot;</span>,
    learning_rate=<span class="hljs-number">5e-5</span>,
    num_train_epochs=<span class="hljs-number">50</span>,
    fp16=<span class="hljs-literal">True</span>,
    per_device_train_batch_size=<span class="hljs-number">32</span>,
    per_device_eval_batch_size=<span class="hljs-number">32</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    save_total_limit=<span class="hljs-number">3</span>,
    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    eval_steps=<span class="hljs-number">50</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_steps=<span class="hljs-number">50</span>,
    logging_steps=<span class="hljs-number">50</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ne=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdGVzdF9kcyUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSk=",highlighted:`trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=train_ds,
    eval_dataset=test_ds,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),pe=new h({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),me=new h({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),Me=new Je({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ye=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnBva2Vtb24ucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/pokemon.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),de=new h({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW5wdXRzLnBpeGVsX3ZhbHVlcw==",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
pixel_values = inputs.pixel_values`,wrap:!1}}),ue=new h({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHBpeGVsX3ZhbHVlcyUzRHBpeGVsX3ZhbHVlcyUyQyUyMG1heF9sZW5ndGglM0Q1MCklMEFnZW5lcmF0ZWRfY2FwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEFwcmludChnZW5lcmF0ZWRfY2FwdGlvbik=",highlighted:`generated_ids = model.generate(pixel_values=pixel_values, max_length=<span class="hljs-number">50</span>)
generated_caption = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(generated_caption)`,wrap:!1}}),fe=new h({props:{code:"YSUyMGRyYXdpbmclMjBvZiUyMGElMjBwaW5rJTIwYW5kJTIwYmx1ZSUyMHBva2Vtb24=",highlighted:"a drawing of a pink and blue pokemon",wrap:!1}}),ge=new ys({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_captioning.md"}}),{c(){u=i("meta"),b=a(),f=i("p"),be=a(),r(T.$$.fragment),je=a(),r(U.$$.fragment),$e=a(),j=i("p"),j.textContent=Ct,_e=a(),$=i("p"),$.textContent=kt,Ce=a(),_=i("ul"),_.innerHTML=It,ke=a(),C=i("p"),C.textContent=vt,Ie=a(),r(k.$$.fragment),ve=a(),I=i("p"),I.textContent=Bt,Be=a(),r(v.$$.fragment),We=a(),r(B.$$.fragment),Ze=a(),W=i("p"),W.innerHTML=Wt,Ge=a(),r(Z.$$.fragment),xe=a(),r(G.$$.fragment),Re=a(),x=i("p"),x.innerHTML=Zt,He=a(),r(w.$$.fragment),Xe=a(),R=i("p"),R.innerHTML=Gt,Ve=a(),r(H.$$.fragment),Ye=a(),X=i("p"),X.textContent=xt,Ee=a(),r(V.$$.fragment),ze=a(),g=i("div"),g.innerHTML=Rt,Qe=a(),r(Y.$$.fragment),Fe=a(),E=i("p"),E.textContent=Ht,Ne=a(),z=i("p"),z.textContent=Xt,Ae=a(),r(Q.$$.fragment),Se=a(),F=i("p"),F.textContent=Vt,qe=a(),r(N.$$.fragment),Le=a(),A=i("p"),A.textContent=Yt,Pe=a(),r(S.$$.fragment),Ke=a(),q=i("p"),q.innerHTML=Et,De=a(),r(L.$$.fragment),Oe=a(),r(P.$$.fragment),et=a(),K=i("p"),K.innerHTML=zt,tt=a(),D=i("p"),D.innerHTML=Qt,st=a(),r(O.$$.fragment),lt=a(),r(ee.$$.fragment),at=a(),te=i("p"),te.innerHTML=Ft,nt=a(),se=i("p"),se.innerHTML=Nt,it=a(),r(le.$$.fragment),pt=a(),ae=i("p"),ae.textContent=At,rt=a(),r(ne.$$.fragment),ot=a(),ie=i("p"),ie.innerHTML=St,mt=a(),r(pe.$$.fragment),Mt=a(),re=i("p"),re.textContent=qt,ct=a(),oe=i("p"),oe.innerHTML=Lt,yt=a(),r(me.$$.fragment),dt=a(),r(Me.$$.fragment),ht=a(),ce=i("p"),ce.innerHTML=Pt,ut=a(),r(ye.$$.fragment),ft=a(),J=i("div"),J.innerHTML=Kt,wt=ps(`
    
Prepare image for the model.

	`),r(de.$$.fragment),gt=a(),he=i("p"),he.innerHTML=Dt,Jt=a(),r(ue.$$.fragment),bt=a(),r(fe.$$.fragment),Tt=a(),we=i("p"),we.textContent=Ot,Ut=a(),r(ge.$$.fragment),jt=a(),Te=i("p"),this.h()},l(e){const t=rs("svelte-u9bgzb",document.head);u=p(t,"META",{name:!0,content:!0}),t.forEach(s),b=n(e),f=p(e,"P",{}),ts(f).forEach(s),be=n(e),o(T.$$.fragment,e),je=n(e),o(U.$$.fragment,e),$e=n(e),j=p(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-ws486a"&&(j.textContent=Ct),_e=n(e),$=p(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-1aff4p7"&&($.textContent=kt),Ce=n(e),_=p(e,"UL",{"data-svelte-h":!0}),d(_)!=="svelte-l0kgiy"&&(_.innerHTML=It),ke=n(e),C=p(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1c9nexd"&&(C.textContent=vt),Ie=n(e),o(k.$$.fragment,e),ve=n(e),I=p(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-27hn0u"&&(I.textContent=Bt),Be=n(e),o(v.$$.fragment,e),We=n(e),o(B.$$.fragment,e),Ze=n(e),W=p(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1ijrbcw"&&(W.innerHTML=Wt),Ge=n(e),o(Z.$$.fragment,e),xe=n(e),o(G.$$.fragment,e),Re=n(e),x=p(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-14ukxt"&&(x.innerHTML=Zt),He=n(e),o(w.$$.fragment,e),Xe=n(e),R=p(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-mi4jsl"&&(R.innerHTML=Gt),Ve=n(e),o(H.$$.fragment,e),Ye=n(e),X=p(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1fsrtvj"&&(X.textContent=xt),Ee=n(e),o(V.$$.fragment,e),ze=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),d(g)!=="svelte-1qemygy"&&(g.innerHTML=Rt),Qe=n(e),o(Y.$$.fragment,e),Fe=n(e),E=p(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1ogvs11"&&(E.textContent=Ht),Ne=n(e),z=p(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1shh6cf"&&(z.textContent=Xt),Ae=n(e),o(Q.$$.fragment,e),Se=n(e),F=p(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-l3qjuh"&&(F.textContent=Vt),qe=n(e),o(N.$$.fragment,e),Le=n(e),A=p(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1bhogex"&&(A.textContent=Yt),Pe=n(e),o(S.$$.fragment,e),Ke=n(e),q=p(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-n2g9rz"&&(q.innerHTML=Et),De=n(e),o(L.$$.fragment,e),Oe=n(e),o(P.$$.fragment,e),et=n(e),K=p(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1tzk2iw"&&(K.innerHTML=zt),tt=n(e),D=p(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-e8lgr2"&&(D.innerHTML=Qt),st=n(e),o(O.$$.fragment,e),lt=n(e),o(ee.$$.fragment,e),at=n(e),te=p(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-pbrxg6"&&(te.innerHTML=Ft),nt=n(e),se=p(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-wn83bq"&&(se.innerHTML=Nt),it=n(e),o(le.$$.fragment,e),pt=n(e),ae=p(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-y5ywt5"&&(ae.textContent=At),rt=n(e),o(ne.$$.fragment,e),ot=n(e),ie=p(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-18iqupu"&&(ie.innerHTML=St),mt=n(e),o(pe.$$.fragment,e),Mt=n(e),re=p(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-acs4yg"&&(re.textContent=qt),ct=n(e),oe=p(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1exc5rw"&&(oe.innerHTML=Lt),yt=n(e),o(me.$$.fragment,e),dt=n(e),o(Me.$$.fragment,e),ht=n(e),ce=p(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-16tgs9z"&&(ce.innerHTML=Pt),ut=n(e),o(ye.$$.fragment,e),ft=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),d(J)!=="svelte-yvzmn4"&&(J.innerHTML=Kt),wt=os(e,`
    
Prepare image for the model.

	`),o(de.$$.fragment,e),gt=n(e),he=p(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1rbuk2y"&&(he.innerHTML=Dt),Jt=n(e),o(ue.$$.fragment,e),bt=n(e),o(fe.$$.fragment,e),Tt=n(e),we=p(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-vibkpa"&&(we.textContent=Ot),Ut=n(e),o(ge.$$.fragment,e),jt=n(e),Te=p(e,"P",{}),ts(Te).forEach(s),this.h()},h(){_t(u,"name","hf:doc:metadata"),_t(u,"content",us),_t(g,"class","flex justify-center"),_t(J,"class","flex justify-center")},m(e,t){ms(document.head,u),l(e,b,t),l(e,f,t),l(e,be,t),m(T,e,t),l(e,je,t),m(U,e,t),l(e,$e,t),l(e,j,t),l(e,_e,t),l(e,$,t),l(e,Ce,t),l(e,_,t),l(e,ke,t),l(e,C,t),l(e,Ie,t),m(k,e,t),l(e,ve,t),l(e,I,t),l(e,Be,t),m(v,e,t),l(e,We,t),m(B,e,t),l(e,Ze,t),l(e,W,t),l(e,Ge,t),m(Z,e,t),l(e,xe,t),m(G,e,t),l(e,Re,t),l(e,x,t),l(e,He,t),m(w,e,t),l(e,Xe,t),l(e,R,t),l(e,Ve,t),m(H,e,t),l(e,Ye,t),l(e,X,t),l(e,Ee,t),m(V,e,t),l(e,ze,t),l(e,g,t),l(e,Qe,t),m(Y,e,t),l(e,Fe,t),l(e,E,t),l(e,Ne,t),l(e,z,t),l(e,Ae,t),m(Q,e,t),l(e,Se,t),l(e,F,t),l(e,qe,t),m(N,e,t),l(e,Le,t),l(e,A,t),l(e,Pe,t),m(S,e,t),l(e,Ke,t),l(e,q,t),l(e,De,t),m(L,e,t),l(e,Oe,t),m(P,e,t),l(e,et,t),l(e,K,t),l(e,tt,t),l(e,D,t),l(e,st,t),m(O,e,t),l(e,lt,t),m(ee,e,t),l(e,at,t),l(e,te,t),l(e,nt,t),l(e,se,t),l(e,it,t),m(le,e,t),l(e,pt,t),l(e,ae,t),l(e,rt,t),m(ne,e,t),l(e,ot,t),l(e,ie,t),l(e,mt,t),m(pe,e,t),l(e,Mt,t),l(e,re,t),l(e,ct,t),l(e,oe,t),l(e,yt,t),m(me,e,t),l(e,dt,t),m(Me,e,t),l(e,ht,t),l(e,ce,t),l(e,ut,t),m(ye,e,t),l(e,ft,t),l(e,J,t),l(e,wt,t),m(de,e,t),l(e,gt,t),l(e,he,t),l(e,Jt,t),m(ue,e,t),l(e,bt,t),m(fe,e,t),l(e,Tt,t),l(e,we,t),l(e,Ut,t),m(ge,e,t),l(e,jt,t),l(e,Te,t),$t=!0},p(e,[t]){const es={};t&2&&(es.$$scope={dirty:t,ctx:e}),w.$set(es)},i(e){$t||(M(T.$$.fragment,e),M(U.$$.fragment,e),M(k.$$.fragment,e),M(v.$$.fragment,e),M(B.$$.fragment,e),M(Z.$$.fragment,e),M(G.$$.fragment,e),M(w.$$.fragment,e),M(H.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),M(S.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(Me.$$.fragment,e),M(ye.$$.fragment,e),M(de.$$.fragment,e),M(ue.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),$t=!0)},o(e){c(T.$$.fragment,e),c(U.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(w.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),$t=!1},d(e){e&&(s(b),s(f),s(be),s(je),s($e),s(j),s(_e),s($),s(Ce),s(_),s(ke),s(C),s(Ie),s(ve),s(I),s(Be),s(We),s(Ze),s(W),s(Ge),s(xe),s(Re),s(x),s(He),s(Xe),s(R),s(Ve),s(Ye),s(X),s(Ee),s(ze),s(g),s(Qe),s(Fe),s(E),s(Ne),s(z),s(Ae),s(Se),s(F),s(qe),s(Le),s(A),s(Pe),s(Ke),s(q),s(De),s(Oe),s(et),s(K),s(tt),s(D),s(st),s(lt),s(at),s(te),s(nt),s(se),s(it),s(pt),s(ae),s(rt),s(ot),s(ie),s(mt),s(Mt),s(re),s(ct),s(oe),s(yt),s(dt),s(ht),s(ce),s(ut),s(ft),s(J),s(wt),s(gt),s(he),s(Jt),s(bt),s(Tt),s(we),s(Ut),s(jt),s(Te)),s(u),y(T,e),y(U,e),y(k,e),y(v,e),y(B,e),y(Z,e),y(G,e),y(w,e),y(H,e),y(V,e),y(Y,e),y(Q,e),y(N,e),y(S,e),y(L,e),y(P,e),y(O,e),y(ee,e),y(le,e),y(ne,e),y(pe,e),y(me,e),y(Me,e),y(ye,e),y(de,e),y(ue,e),y(fe,e),y(ge,e)}}}const us='{"title":"Image captioning","local":"image-captioning","sections":[{"title":"Load the Pokémon BLIP captions dataset","local":"load-the-pokémon-blip-captions-dataset","sections":[],"depth":2},{"title":"Preprocess the dataset","local":"preprocess-the-dataset","sections":[],"depth":2},{"title":"Load a base model","local":"load-a-base-model","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Train!","local":"train","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function fs(Ue){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends ns{constructor(u){super(),is(this,u,fs,hs,ss,{})}}export{js as component};
