import{s as Fo,o as Lo}from"../chunks/scheduler.25b97de1.js";import{S as Do,i as Po,g as o,s as a,r as M,A as Ko,h as i,f as s,c as n,j as _o,u as r,x as p,k as Xo,y as Oo,a as l,v as y,d as c,t as h,w as m,m as Ho,n as Yo}from"../chunks/index.d9030fc9.js";import{T as Eo}from"../chunks/Tip.baa67368.js";import{C as d}from"../chunks/CodeBlock.e6cd0d95.js";import{H as u,E as ti}from"../chunks/EditOnGithub.91d95064.js";function ei(cs){let J;return{c(){J=Ho(`Not all of the tool-calling features shown above are used by all models. Some use tool call IDs, others simply use the function name and
match tool calls to results using the ordering, and there are several models that use neither and only issue one tool 
call at a time to avoid confusion. If you want your code to be compatible across as many models as possible, we 
recommend structuring your tools calls like we've shown here, and returning tool results in the order that
they were issued by the model. The chat templates on each model should handle the rest.`)},l(T){J=Yo(T,`Not all of the tool-calling features shown above are used by all models. Some use tool call IDs, others simply use the function name and
match tool calls to results using the ordering, and there are several models that use neither and only issue one tool 
call at a time to avoid confusion. If you want your code to be compatible across as many models as possible, we 
recommend structuring your tools calls like we've shown here, and returning tool results in the order that
they were issued by the model. The chat templates on each model should handle the rest.`)},m(T,U){l(T,J,U)},d(T){T&&s(J)}}}function si(cs){let J;return{c(){J=Ho(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(T){J=Yo(T,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(T,U){l(T,J,U)},d(T){T&&s(J)}}}function li(cs){let J,T,U,ms,I,ds,f,us,g,Mn=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,Js,b,rn=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,Ts,C,yn=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,Us,G,ws,x,cn=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>mistralai/Mistral-7B-Instruct-v0.1</code> model.`,js,B,Is,v,hn=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!). Mistral-instruct was trained with these tokens, but BlenderBot was not.`,fs,Z,gs,$,mn=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/pr_28196/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> method. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,bs,k,dn="Here’s an example of preparing input for <code>model.generate()</code>, using the <code>Zephyr</code> assistant model:",Cs,N,Gs,Q,un="This will yield a string in the input format that Zephyr expects.",xs,W,Bs,V,Jn="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",vs,S,Zs,q,Tn="This will yield:",$s,A,ks,R,Un="Arr, ‘twas easy after all!",Ns,z,Qs,_,wn=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/pr_28196/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,Ws,X,Vs,E,Ss,H,jn=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,qs,Y,As,F,In=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Rs,L,zs,D,fn="Here’s what this will look like without a generation prompt, using the ChatML template we saw in the Zephyr example:",_s,P,Xs,K,gn="And here’s what it looks like <strong>with</strong> a generation prompt:",Es,O,Hs,tt,bn=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,Ys,et,Cn=`Not all models require generation prompts. Some models, like BlenderBot and LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Fs,st,Ls,lt,Gn=`Yes! We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,Ds,at,Ps,nt,xn="And we get:",Ks,ot,Os,it,Bn="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",tl,pt,el,Mt,vn=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,sl,rt,Zn=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,ll,yt,al,ct,$n=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,nl,ht,ol,mt,kn=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,il,dt,Nn=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description<br/>
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,pl,ut,Ml,Jt,Qn=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,rl,Tt,Wn="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",yl,Ut,cl,wt,Vn=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,hl,jt,Sn="First, let’s load our model and tokenizer:",ml,It,dl,ft,qn="Next, let’s define a list of tools:",ul,gt,Jl,bt,An="Now, let’s set up a conversation for our bot:",Tl,Ct,Ul,Gt,Rn="Now, let’s apply the chat template and generate a response:",wl,xt,jl,Bt,zn="And we get:",Il,vt,fl,Zt,_n=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,gl,$t,Xn=`Let’s append the model’s tool call to the conversation. Note that we generate a random <code>tool_call_id</code> here. These IDs
are not used by all models, but they allow models to issue multiple tool calls at once and keep track of which response
corresponds to which call. You can generate them any way you like, but they should be unique within each chat.`,bl,kt,Cl,Nt,En=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly. Again, note the <code>tool_call_id</code> - this should match the ID used in the tool call above.`,Gl,Qt,xl,Wt,Hn="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",Bl,Vt,vl,St,Yn="And we get:",Zl,qt,$l,At,Fn=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,kl,w,Nl,Rt,Ql,zt,Ln=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,Wl,_t,Dn=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,Vl,Xt,Sl,Et,Pn="This will yield:",ql,Ht,Al,Yt,Kn=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,Rl,Ft,On="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",zl,Lt,_l,Dt,Xl,Pt,to=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,El,Kt,eo="Here’s an example of a RAG template in action:",Hl,Ot,Yl,te,Fl,ee,so=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,Ll,se,Dl,le,lo=`That’s kind of intimidating. Let’s clean it up a little to make it more readable. In the process, though, we also make
sure that the newlines and indentation we add don’t end up being included in the template output - see the tip on
<a href="#trimming-whitespace">trimming whitespace</a> below!`,Pl,ae,Kl,ne,ao=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,Ol,oe,ta,ie,no="Effectively, the template does three things:",ea,pe,oo="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",sa,Me,io=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,la,re,aa,ye,po=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,na,ce,oa,he,ia,me,Mo=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,pa,de,Ma,ue,ro=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/pr_28196/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/pr_28196/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,ra,Je,ya,Te,yo=`The method <a href="/docs/transformers/pr_28196/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/pr_28196/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/pr_28196/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,ca,j,ha,Ue,ma,we,co=`Some models use different templates for different use cases. For example, they might use one template for normal chat
and another for tool-use, or retrieval-augmented generation. In these cases, <code>tokenizer.chat_template</code> is a dictionary.
This can cause some confusion, and where possible, we recommend using a single template for all use-cases. You can use
Jinja statements like <code>if tools is defined</code> and <code>{% macro %}</code> definitions to easily wrap multiple code paths in a
single template.`,da,je,ho=`When a tokenizer has multiple templates, <code>tokenizer.chat_template</code> will be a <code>dict</code>, where each key is the name
of a template. The <code>apply_chat_template</code> method has special handling for certain template names: Specifically, it will
look for a template named <code>default</code> in most cases, and will raise an error if it can’t find one. However, if a template
named <code>tool_use</code> exists when the user has passed a <code>tools</code> argument, it will use that instead. To access templates
with other names, pass the name of the template you want to the <code>chat_template</code> argument of
<code>apply_chat_template()</code>.`,ua,Ie,mo=`We find that this can be a bit confusing for users, though - so if you’re writing a template yourself, we recommend
trying to put it all in a single template where possible!`,Ja,fe,Ta,ge,uo=`Before the introduction of chat templates, chat handling was hardcoded at the model class level. For backwards
compatibility, we have retained this class-specific handling as default templates, also set at the class level. If a
model does not have a chat template set, but there is a default template for its model class, the <code>TextGenerationPipeline</code>
class and methods like <code>apply_chat_template</code> will use the class template instead. You can find out what the default
template for your tokenizer is by checking the <code>tokenizer.default_chat_template</code> attribute.`,Ua,be,Jo=`This is something we do purely for backward compatibility reasons, to avoid breaking any existing workflows. Even when
the class template is appropriate for your model, we strongly recommend overriding the default template by
setting the <code>chat_template</code> attribute explicitly to make it clear to users that your model has been correctly configured
for chat.`,wa,Ce,To=`Now that actual chat templates have been adopted more widely, default templates have been deprecated and will be
removed in a future release. We strongly recommend setting the <code>chat_template</code> attribute for any tokenizers that
still depend on them!`,ja,Ge,Ia,xe,Uo=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,fa,Be,wo=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,ga,ve,ba,Ze,jo=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,Ca,$e,Ga,ke,Io=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,xa,Ne,Ba,Qe,fo=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/pr_28196/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,va,We,Za,Ve,go=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/pr_28196/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,$a,Se,bo=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,ka,qe,Co=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Na,Ae,Qa,Re,Go=`If you’re unfamiliar with Jinja, we generally find that the easiest way to write a chat template is to first
write a short Python script that formats messages the way you want, and then convert that script into a template.`,Wa,ze,xo=`Remember that the template handler will receive the conversation history as a variable called <code>messages</code>.<br/>
You will be able to access <code>messages</code> in your template just like you can in Python, which means you can loop over
it with <code>{% for message in messages %}</code> or access individual messages with <code>{{ messages[0] }}</code>, for example.`,Va,_e,Bo="You can also use the following tips to convert your code to Jinja:",Sa,Xe,qa,Ee,vo=`By default, Jinja will print any whitespace that comes before or after a block. This can be a problem for chat
templates, which generally want to be very precise with whitespace! To avoid this, we strongly recommend writing
your templates like this:`,Aa,He,Ra,Ye,Zo="rather than like this:",za,Fe,_a,Le,$o=`Adding <code>-</code> will strip any whitespace that comes before the block. The second example looks innocent, but the newline
and indentation may end up being included in the output, which is probably not what you want!`,Xa,De,Ea,Pe,ko="For loops in Jinja look like this:",Ha,Ke,Ya,Oe,No=`Note that whatever’s inside the {{ expression block }} will be printed to the output. You can use operators like
<code>+</code> to combine strings inside expression blocks.`,Fa,ts,La,es,Qo="If statements in Jinja look like this:",Da,ss,Pa,ls,Wo=`Note how where Python uses whitespace to mark the beginnings and ends of <code>for</code> and <code>if</code> blocks, Jinja requires you
to explicitly end them with <code>{% endfor %}</code> and <code>{% endif %}</code>.`,Ka,as,Oa,ns,Vo=`Inside your template, you will have access to the list of <code>messages</code>, but you can also access several other special
variables. These include special tokens like <code>bos_token</code> and <code>eos_token</code>, as well as the <code>add_generation_prompt</code>
variable that we discussed above. You can also use the <code>loop</code> variable to access information about the current loop
iteration, for example  using <code>{% if loop.last %}</code> to check if the current message is the last message in the
conversation. Here’s an example that puts these ideas together to add a generation prompt at the end of the
conversation if add_generation_prompt is <code>True</code>:`,tn,os,en,is,sn,ps,So=`There are multiple implementations of Jinja in various languages. They generally have the same syntax,
but a key difference is that when you’re writing a template in Python you can use Python methods, such as
<code>.lower()</code> on strings or <code>.items()</code> on dicts. This will break if someone tries to use your template on a non-Python
implementation of Jinja. Non-Python implementations are particularly common in deployment environments, where JS
and Rust are very popular.`,ln,Ms,qo=`Don’t panic, though! There are a few easy changes you can make to your templates to ensure they’re compatible across
all implementations of Jinja:`,an,rs,Ao=`<li>Replace Python methods with Jinja filters. These usually have the same name, for example <code>string.lower()</code> becomes
<code>string|lower</code>, and <code>dict.items()</code> becomes <code>dict|items</code>. One notable change is that <code>string.strip()</code> becomes <code>string|trim</code>.
See the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">list of built-in filters</a>
in the Jinja documentation for more.</li> <li>Replace <code>True</code>, <code>False</code> and <code>None</code>, which are Python-specific, with <code>true</code>, <code>false</code> and <code>none</code>.</li> <li>Directly rendering a dict or list may give different results in other implementations (for example, string entries
might change from single-quoted to double-quoted). Adding the <code>tojson</code> filter can help to ensure consistency here.</li>`,nn,ys,on,hs,pn;return I=new u({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),f=new u({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),G=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),B=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),Z=new u({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),N=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),W=new d({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),S=new d({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),A=new d({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),z=new u({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),X=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),E=new d({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),Y=new u({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),L=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),P=new d({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),O=new d({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),st=new u({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),at=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),ot=new d({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),pt=new u({props:{title:"Advanced: Extra inputs to chat templates",local:"advanced-extra-inputs-to-chat-templates",headingTag:"h2"}}),yt=new u({props:{title:"Advanced: Tool use / function calling",local:"advanced-tool-use--function-calling",headingTag:"h2"}}),ht=new d({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),ut=new u({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),Ut=new u({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),It=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMHJldmlzaW9uJTNEJTIycHIlMkYxMyUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint, revision=<span class="hljs-string">&quot;pr/13&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),gt=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),Ct=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),xt=new d({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBjaGF0X3RlbXBsYXRlJTNEJTIydG9vbF91c2UlMjIlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, chat_template=<span class="hljs-string">&quot;tool_use&quot;</span>, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),vt=new d({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),kt=new d({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIydkFIZGYzJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjBzaG91bGQlMjBiZSUyMHVuaXF1ZSUyMGZvciUyMGVhY2glMjB0b29sJTIwY2FsbCUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;vAHdf3&quot;</span>  <span class="hljs-comment"># Random ID, should be unique for each tool call</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),Qt=new d({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),Vt=new d({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBjaGF0X3RlbXBsYXRlJTNEJTIydG9vbF91c2UlMjIlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, chat_template=<span class="hljs-string">&quot;tool_use&quot;</span>, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),qt=new d({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),w=new Eo({props:{$$slots:{default:[ei]},$$scope:{ctx:cs}}}),Rt=new u({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),Xt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),Ht=new d({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Lt=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>, 
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>, 
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        }, 
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      }, 
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),Dt=new u({props:{title:"Advanced: Retrieval-augmented generation",local:"advanced-retrieval-augmented-generation",headingTag:"h2"}}),Ot=new d({props:{code:"ZG9jdW1lbnQxJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJUaGUlMjBNb29uJTNBJTIwT3VyJTIwQWdlLU9sZCUyMEZvZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnRzJTIyJTNBJTIwJTIyTWFuJTIwaGFzJTIwYWx3YXlzJTIwZHJlYW1lZCUyMG9mJTIwZGVzdHJveWluZyUyMHRoZSUyMG1vb24uJTIwSW4lMjB0aGlzJTIwZXNzYXklMkMlMjBJJTIwc2hhbGwuLi4lMjIlMEElN0QlMEElMEFkb2N1bWVudDIlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0aXRsZSUyMiUzQSUyMCUyMlRoZSUyMFN1biUzQSUyME91ciUyMEFnZS1PbGQlMjBGcmllbmQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50cyUyMiUzQSUyMCUyMkFsdGhvdWdoJTIwb2Z0ZW4lMjB1bmRlcmFwcHJlY2lhdGVkJTJDJTIwdGhlJTIwc3VuJTIwcHJvdmlkZXMlMjBzZXZlcmFsJTIwbm90YWJsZSUyMGJlbmVmaXRzLi4uJTIyJTBBJTdEJTBBJTBBbW9kZWxfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUzRCU1QmRvY3VtZW50MSUyQyUyMGRvY3VtZW50MiU1RCUwQSk=",highlighted:`document1 = {
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>,
    <span class="hljs-string">&quot;contents&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
}

document2 = {
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
    <span class="hljs-string">&quot;contents&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
}

model_input = tokenizer.apply_chat_template(
    messages,
    documents=[document1, document2]
)`,wrap:!1}}),te=new u({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),se=new d({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),ae=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclMjAlMjAnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3Qi0lMjBlb3NfdG9rZW4lMjAlN0QlN0Q=",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> message[&#x27;role&#x27;] == &#x27;user&#x27; %}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{- &#x27; &#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- message[&#x27;content&#x27;] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> not loop.last %}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{- &#x27;  &#x27; }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{- eos_token }}</span>`,wrap:!1}}),oe=new d({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),re=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclNUMlNUNuJTNDJTNDJTJGU1lTJTNFJTNFJTVDJTVDbiU1QyU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUyMCclMjAlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),ce=new u({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),he=new u({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),de=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),Je=new d({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),j=new Eo({props:{$$slots:{default:[si]},$$scope:{ctx:cs}}}),Ue=new u({props:{title:"Why do some models have multiple templates?",local:"why-do-some-models-have-multiple-templates",headingTag:"h3"}}),fe=new u({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h3"}}),Ge=new u({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),ve=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[&#x27;content&#x27;] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),$e=new d({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),Ne=new d({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),We=new u({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),Ae=new u({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),Xe=new u({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),He=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),Fe=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] + message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),De=new u({props:{title:"For loops",local:"for-loops",headingTag:"h3"}}),Ke=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),ts=new u({props:{title:"If statements",local:"if-statements",headingTag:"h3"}}),ss=new d({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
    {{- message[<span class="hljs-string">&#x27;content&#x27;</span>] }}
{%- endif %}`,wrap:!1}}),as=new u({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),os=new d({props:{code:"JTdCJTI1LSUyMGlmJTIwbG9vcC5sYXN0JTIwYW5kJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMGJvc190b2tlbiUyMCUyQiUyMCdBc3Npc3RhbnQlM0ElNUNuJyUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{- bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),is=new u({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),ys=new ti({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating.md"}}),{c(){J=o("meta"),T=a(),U=o("p"),ms=a(),M(I.$$.fragment),ds=a(),M(f.$$.fragment),us=a(),g=o("p"),g.innerHTML=Mn,Js=a(),b=o("p"),b.innerHTML=rn,Ts=a(),C=o("p"),C.innerHTML=yn,Us=a(),M(G.$$.fragment),ws=a(),x=o("p"),x.innerHTML=cn,js=a(),M(B.$$.fragment),Is=a(),v=o("p"),v.textContent=hn,fs=a(),M(Z.$$.fragment),gs=a(),$=o("p"),$.innerHTML=mn,bs=a(),k=o("p"),k.innerHTML=dn,Cs=a(),M(N.$$.fragment),Gs=a(),Q=o("p"),Q.textContent=un,xs=a(),M(W.$$.fragment),Bs=a(),V=o("p"),V.textContent=Jn,vs=a(),M(S.$$.fragment),Zs=a(),q=o("p"),q.textContent=Tn,$s=a(),M(A.$$.fragment),ks=a(),R=o("p"),R.textContent=Un,Ns=a(),M(z.$$.fragment),Qs=a(),_=o("p"),_.innerHTML=wn,Ws=a(),M(X.$$.fragment),Vs=a(),M(E.$$.fragment),Ss=a(),H=o("p"),H.innerHTML=jn,qs=a(),M(Y.$$.fragment),As=a(),F=o("p"),F.innerHTML=In,Rs=a(),M(L.$$.fragment),zs=a(),D=o("p"),D.textContent=fn,_s=a(),M(P.$$.fragment),Xs=a(),K=o("p"),K.innerHTML=gn,Es=a(),M(O.$$.fragment),Hs=a(),tt=o("p"),tt.textContent=bn,Ys=a(),et=o("p"),et.innerHTML=Cn,Fs=a(),M(st.$$.fragment),Ls=a(),lt=o("p"),lt.innerHTML=Gn,Ds=a(),M(at.$$.fragment),Ps=a(),nt=o("p"),nt.textContent=xn,Ks=a(),M(ot.$$.fragment),Os=a(),it=o("p"),it.innerHTML=Bn,tl=a(),M(pt.$$.fragment),el=a(),Mt=o("p"),Mt.innerHTML=vn,sl=a(),rt=o("p"),rt.textContent=Zn,ll=a(),M(yt.$$.fragment),al=a(),ct=o("p"),ct.innerHTML=$n,nl=a(),M(ht.$$.fragment),ol=a(),mt=o("p"),mt.textContent=kn,il=a(),dt=o("ul"),dt.innerHTML=Nn,pl=a(),M(ut.$$.fragment),Ml=a(),Jt=o("p"),Jt.textContent=Qn,rl=a(),Tt=o("ol"),Tt.innerHTML=Wn,yl=a(),M(Ut.$$.fragment),cl=a(),wt=o("p"),wt.innerHTML=Vn,hl=a(),jt=o("p"),jt.textContent=Sn,ml=a(),M(It.$$.fragment),dl=a(),ft=o("p"),ft.textContent=qn,ul=a(),M(gt.$$.fragment),Jl=a(),bt=o("p"),bt.textContent=An,Tl=a(),M(Ct.$$.fragment),Ul=a(),Gt=o("p"),Gt.textContent=Rn,wl=a(),M(xt.$$.fragment),jl=a(),Bt=o("p"),Bt.textContent=zn,Il=a(),M(vt.$$.fragment),fl=a(),Zt=o("p"),Zt.textContent=_n,gl=a(),$t=o("p"),$t.innerHTML=Xn,bl=a(),M(kt.$$.fragment),Cl=a(),Nt=o("p"),Nt.innerHTML=En,Gl=a(),M(Qt.$$.fragment),xl=a(),Wt=o("p"),Wt.textContent=Hn,Bl=a(),M(Vt.$$.fragment),vl=a(),St=o("p"),St.textContent=Yn,Zl=a(),M(qt.$$.fragment),$l=a(),At=o("p"),At.textContent=Fn,kl=a(),M(w.$$.fragment),Nl=a(),M(Rt.$$.fragment),Ql=a(),zt=o("p"),zt.innerHTML=Ln,Wl=a(),_t=o("p"),_t.textContent=Dn,Vl=a(),M(Xt.$$.fragment),Sl=a(),Et=o("p"),Et.textContent=Pn,ql=a(),M(Ht.$$.fragment),Al=a(),Yt=o("p"),Yt.innerHTML=Kn,Rl=a(),Ft=o("p"),Ft.innerHTML=On,zl=a(),M(Lt.$$.fragment),_l=a(),M(Dt.$$.fragment),Xl=a(),Pt=o("p"),Pt.innerHTML=to,El=a(),Kt=o("p"),Kt.textContent=eo,Hl=a(),M(Ot.$$.fragment),Yl=a(),M(te.$$.fragment),Fl=a(),ee=o("p"),ee.innerHTML=so,Ll=a(),M(se.$$.fragment),Dl=a(),le=o("p"),le.innerHTML=lo,Pl=a(),M(ae.$$.fragment),Kl=a(),ne=o("p"),ne.innerHTML=ao,Ol=a(),M(oe.$$.fragment),ta=a(),ie=o("p"),ie.textContent=no,ea=a(),pe=o("ol"),pe.innerHTML=oo,sa=a(),Me=o("p"),Me.textContent=io,la=a(),M(re.$$.fragment),aa=a(),ye=o("p"),ye.textContent=po,na=a(),M(ce.$$.fragment),oa=a(),M(he.$$.fragment),ia=a(),me=o("p"),me.innerHTML=Mo,pa=a(),M(de.$$.fragment),Ma=a(),ue=o("p"),ue.innerHTML=ro,ra=a(),M(Je.$$.fragment),ya=a(),Te=o("p"),Te.innerHTML=yo,ca=a(),M(j.$$.fragment),ha=a(),M(Ue.$$.fragment),ma=a(),we=o("p"),we.innerHTML=co,da=a(),je=o("p"),je.innerHTML=ho,ua=a(),Ie=o("p"),Ie.textContent=mo,Ja=a(),M(fe.$$.fragment),Ta=a(),ge=o("p"),ge.innerHTML=uo,Ua=a(),be=o("p"),be.innerHTML=Jo,wa=a(),Ce=o("p"),Ce.innerHTML=To,ja=a(),M(Ge.$$.fragment),Ia=a(),xe=o("p"),xe.textContent=Uo,fa=a(),Be=o("p"),Be.innerHTML=wo,ga=a(),M(ve.$$.fragment),ba=a(),Ze=o("p"),Ze.innerHTML=jo,Ca=a(),M($e.$$.fragment),Ga=a(),ke=o("p"),ke.innerHTML=Io,xa=a(),M(Ne.$$.fragment),Ba=a(),Qe=o("p"),Qe.innerHTML=fo,va=a(),M(We.$$.fragment),Za=a(),Ve=o("p"),Ve.innerHTML=go,$a=a(),Se=o("p"),Se.innerHTML=bo,ka=a(),qe=o("p"),qe.textContent=Co,Na=a(),M(Ae.$$.fragment),Qa=a(),Re=o("p"),Re.textContent=Go,Wa=a(),ze=o("p"),ze.innerHTML=xo,Va=a(),_e=o("p"),_e.textContent=Bo,Sa=a(),M(Xe.$$.fragment),qa=a(),Ee=o("p"),Ee.textContent=vo,Aa=a(),M(He.$$.fragment),Ra=a(),Ye=o("p"),Ye.textContent=Zo,za=a(),M(Fe.$$.fragment),_a=a(),Le=o("p"),Le.innerHTML=$o,Xa=a(),M(De.$$.fragment),Ea=a(),Pe=o("p"),Pe.textContent=ko,Ha=a(),M(Ke.$$.fragment),Ya=a(),Oe=o("p"),Oe.innerHTML=No,Fa=a(),M(ts.$$.fragment),La=a(),es=o("p"),es.textContent=Qo,Da=a(),M(ss.$$.fragment),Pa=a(),ls=o("p"),ls.innerHTML=Wo,Ka=a(),M(as.$$.fragment),Oa=a(),ns=o("p"),ns.innerHTML=Vo,tn=a(),M(os.$$.fragment),en=a(),M(is.$$.fragment),sn=a(),ps=o("p"),ps.innerHTML=So,ln=a(),Ms=o("p"),Ms.textContent=qo,an=a(),rs=o("ul"),rs.innerHTML=Ao,nn=a(),M(ys.$$.fragment),on=a(),hs=o("p"),this.h()},l(t){const e=Ko("svelte-u9bgzb",document.head);J=i(e,"META",{name:!0,content:!0}),e.forEach(s),T=n(t),U=i(t,"P",{}),_o(U).forEach(s),ms=n(t),r(I.$$.fragment,t),ds=n(t),r(f.$$.fragment,t),us=n(t),g=i(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-ydi30o"&&(g.innerHTML=Mn),Js=n(t),b=i(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1p8dq8"&&(b.innerHTML=rn),Ts=n(t),C=i(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1n6wf0k"&&(C.innerHTML=yn),Us=n(t),r(G.$$.fragment,t),ws=n(t),x=i(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1e3bvfs"&&(x.innerHTML=cn),js=n(t),r(B.$$.fragment,t),Is=n(t),v=i(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-15k3bj3"&&(v.textContent=hn),fs=n(t),r(Z.$$.fragment,t),gs=n(t),$=i(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-e2vmdu"&&($.innerHTML=mn),bs=n(t),k=i(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-gmslqw"&&(k.innerHTML=dn),Cs=n(t),r(N.$$.fragment,t),Gs=n(t),Q=i(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1vy7akj"&&(Q.textContent=un),xs=n(t),r(W.$$.fragment,t),Bs=n(t),V=i(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-hj60o5"&&(V.textContent=Jn),vs=n(t),r(S.$$.fragment,t),Zs=n(t),q=i(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1bfcqd3"&&(q.textContent=Tn),$s=n(t),r(A.$$.fragment,t),ks=n(t),R=i(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-k9m2iy"&&(R.textContent=Un),Ns=n(t),r(z.$$.fragment,t),Qs=n(t),_=i(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-df6ndf"&&(_.innerHTML=wn),Ws=n(t),r(X.$$.fragment,t),Vs=n(t),r(E.$$.fragment,t),Ss=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-5umvde"&&(H.innerHTML=jn),qs=n(t),r(Y.$$.fragment,t),As=n(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-rhnu79"&&(F.innerHTML=In),Rs=n(t),r(L.$$.fragment,t),zs=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1g5nifq"&&(D.textContent=fn),_s=n(t),r(P.$$.fragment,t),Xs=n(t),K=i(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-61bp3d"&&(K.innerHTML=gn),Es=n(t),r(O.$$.fragment,t),Hs=n(t),tt=i(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-inq88f"&&(tt.textContent=bn),Ys=n(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-76qw2e"&&(et.innerHTML=Cn),Fs=n(t),r(st.$$.fragment,t),Ls=n(t),lt=i(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-i6ltb0"&&(lt.innerHTML=Gn),Ds=n(t),r(at.$$.fragment,t),Ps=n(t),nt=i(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-13505nn"&&(nt.textContent=xn),Ks=n(t),r(ot.$$.fragment,t),Os=n(t),it=i(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-ziuqkt"&&(it.innerHTML=Bn),tl=n(t),r(pt.$$.fragment,t),el=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-dd615e"&&(Mt.innerHTML=vn),sl=n(t),rt=i(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-dcun4m"&&(rt.textContent=Zn),ll=n(t),r(yt.$$.fragment,t),al=n(t),ct=i(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-6sd0wq"&&(ct.innerHTML=$n),nl=n(t),r(ht.$$.fragment,t),ol=n(t),mt=i(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-608o9m"&&(mt.textContent=kn),il=n(t),dt=i(t,"UL",{"data-svelte-h":!0}),p(dt)!=="svelte-n1b3zm"&&(dt.innerHTML=Nn),pl=n(t),r(ut.$$.fragment,t),Ml=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-11962fa"&&(Jt.textContent=Qn),rl=n(t),Tt=i(t,"OL",{"data-svelte-h":!0}),p(Tt)!=="svelte-1vd84s7"&&(Tt.innerHTML=Wn),yl=n(t),r(Ut.$$.fragment,t),cl=n(t),wt=i(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1oi0gsn"&&(wt.innerHTML=Vn),hl=n(t),jt=i(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-o8n6v4"&&(jt.textContent=Sn),ml=n(t),r(It.$$.fragment,t),dl=n(t),ft=i(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1q7358y"&&(ft.textContent=qn),ul=n(t),r(gt.$$.fragment,t),Jl=n(t),bt=i(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-11hfyaa"&&(bt.textContent=An),Tl=n(t),r(Ct.$$.fragment,t),Ul=n(t),Gt=i(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-1usrd3e"&&(Gt.textContent=Rn),wl=n(t),r(xt.$$.fragment,t),jl=n(t),Bt=i(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-13505nn"&&(Bt.textContent=zn),Il=n(t),r(vt.$$.fragment,t),fl=n(t),Zt=i(t,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-nxltbo"&&(Zt.textContent=_n),gl=n(t),$t=i(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-1fjq90r"&&($t.innerHTML=Xn),bl=n(t),r(kt.$$.fragment,t),Cl=n(t),Nt=i(t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-6h0phb"&&(Nt.innerHTML=En),Gl=n(t),r(Qt.$$.fragment,t),xl=n(t),Wt=i(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-1qjybqz"&&(Wt.textContent=Hn),Bl=n(t),r(Vt.$$.fragment,t),vl=n(t),St=i(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-13505nn"&&(St.textContent=Yn),Zl=n(t),r(qt.$$.fragment,t),$l=n(t),At=i(t,"P",{"data-svelte-h":!0}),p(At)!=="svelte-1evxmus"&&(At.textContent=Fn),kl=n(t),r(w.$$.fragment,t),Nl=n(t),r(Rt.$$.fragment,t),Ql=n(t),zt=i(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-pl4mbs"&&(zt.innerHTML=Ln),Wl=n(t),_t=i(t,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-37xmdz"&&(_t.textContent=Dn),Vl=n(t),r(Xt.$$.fragment,t),Sl=n(t),Et=i(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-1bfcqd3"&&(Et.textContent=Pn),ql=n(t),r(Ht.$$.fragment,t),Al=n(t),Yt=i(t,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-19t6fs5"&&(Yt.innerHTML=Kn),Rl=n(t),Ft=i(t,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-1nlyrys"&&(Ft.innerHTML=On),zl=n(t),r(Lt.$$.fragment,t),_l=n(t),r(Dt.$$.fragment,t),Xl=n(t),Pt=i(t,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-1977j4z"&&(Pt.innerHTML=to),El=n(t),Kt=i(t,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-1xmnzcc"&&(Kt.textContent=eo),Hl=n(t),r(Ot.$$.fragment,t),Yl=n(t),r(te.$$.fragment,t),Fl=n(t),ee=i(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-9hx4bd"&&(ee.innerHTML=so),Ll=n(t),r(se.$$.fragment,t),Dl=n(t),le=i(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1adekhh"&&(le.innerHTML=lo),Pl=n(t),r(ae.$$.fragment,t),Kl=n(t),ne=i(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-zet1qo"&&(ne.innerHTML=ao),Ol=n(t),r(oe.$$.fragment,t),ta=n(t),ie=i(t,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-9bdwn1"&&(ie.textContent=no),ea=n(t),pe=i(t,"OL",{"data-svelte-h":!0}),p(pe)!=="svelte-yy2gop"&&(pe.innerHTML=oo),sa=n(t),Me=i(t,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-jxu6rq"&&(Me.textContent=io),la=n(t),r(re.$$.fragment,t),aa=n(t),ye=i(t,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-dqaxjt"&&(ye.textContent=po),na=n(t),r(ce.$$.fragment,t),oa=n(t),r(he.$$.fragment,t),ia=n(t),me=i(t,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1ubxgh9"&&(me.innerHTML=Mo),pa=n(t),r(de.$$.fragment,t),Ma=n(t),ue=i(t,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1c86fpy"&&(ue.innerHTML=ro),ra=n(t),r(Je.$$.fragment,t),ya=n(t),Te=i(t,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-mro022"&&(Te.innerHTML=yo),ca=n(t),r(j.$$.fragment,t),ha=n(t),r(Ue.$$.fragment,t),ma=n(t),we=i(t,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1d7cql4"&&(we.innerHTML=co),da=n(t),je=i(t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1u88h1j"&&(je.innerHTML=ho),ua=n(t),Ie=i(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1g7ri12"&&(Ie.textContent=mo),Ja=n(t),r(fe.$$.fragment,t),Ta=n(t),ge=i(t,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-wev7i6"&&(ge.innerHTML=uo),Ua=n(t),be=i(t,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1o0lzen"&&(be.innerHTML=Jo),wa=n(t),Ce=i(t,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1o7n9tk"&&(Ce.innerHTML=To),ja=n(t),r(Ge.$$.fragment,t),Ia=n(t),xe=i(t,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-5u6sqi"&&(xe.textContent=Uo),fa=n(t),Be=i(t,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-ffreiw"&&(Be.innerHTML=wo),ga=n(t),r(ve.$$.fragment,t),ba=n(t),Ze=i(t,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1cj1ql7"&&(Ze.innerHTML=jo),Ca=n(t),r($e.$$.fragment,t),Ga=n(t),ke=i(t,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-soh9qu"&&(ke.innerHTML=Io),xa=n(t),r(Ne.$$.fragment,t),Ba=n(t),Qe=i(t,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1tz8dl2"&&(Qe.innerHTML=fo),va=n(t),r(We.$$.fragment,t),Za=n(t),Ve=i(t,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1r1105z"&&(Ve.innerHTML=go),$a=n(t),Se=i(t,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-kn2i6o"&&(Se.innerHTML=bo),ka=n(t),qe=i(t,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-197jyne"&&(qe.textContent=Co),Na=n(t),r(Ae.$$.fragment,t),Qa=n(t),Re=i(t,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-64od1c"&&(Re.textContent=Go),Wa=n(t),ze=i(t,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1wubuld"&&(ze.innerHTML=xo),Va=n(t),_e=i(t,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1hxm0m6"&&(_e.textContent=Bo),Sa=n(t),r(Xe.$$.fragment,t),qa=n(t),Ee=i(t,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1ttgeg7"&&(Ee.textContent=vo),Aa=n(t),r(He.$$.fragment,t),Ra=n(t),Ye=i(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-qihux6"&&(Ye.textContent=Zo),za=n(t),r(Fe.$$.fragment,t),_a=n(t),Le=i(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-pefrh0"&&(Le.innerHTML=$o),Xa=n(t),r(De.$$.fragment,t),Ea=n(t),Pe=i(t,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1mepej5"&&(Pe.textContent=ko),Ha=n(t),r(Ke.$$.fragment,t),Ya=n(t),Oe=i(t,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-rw0syz"&&(Oe.innerHTML=No),Fa=n(t),r(ts.$$.fragment,t),La=n(t),es=i(t,"P",{"data-svelte-h":!0}),p(es)!=="svelte-audzqy"&&(es.textContent=Qo),Da=n(t),r(ss.$$.fragment,t),Pa=n(t),ls=i(t,"P",{"data-svelte-h":!0}),p(ls)!=="svelte-gc7ich"&&(ls.innerHTML=Wo),Ka=n(t),r(as.$$.fragment,t),Oa=n(t),ns=i(t,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-1ky9l6m"&&(ns.innerHTML=Vo),tn=n(t),r(os.$$.fragment,t),en=n(t),r(is.$$.fragment,t),sn=n(t),ps=i(t,"P",{"data-svelte-h":!0}),p(ps)!=="svelte-jvvtjt"&&(ps.innerHTML=So),ln=n(t),Ms=i(t,"P",{"data-svelte-h":!0}),p(Ms)!=="svelte-f0ucf0"&&(Ms.textContent=qo),an=n(t),rs=i(t,"UL",{"data-svelte-h":!0}),p(rs)!=="svelte-doa6oc"&&(rs.innerHTML=Ao),nn=n(t),r(ys.$$.fragment,t),on=n(t),hs=i(t,"P",{}),_o(hs).forEach(s),this.h()},h(){Xo(J,"name","hf:doc:metadata"),Xo(J,"content",ai)},m(t,e){Oo(document.head,J),l(t,T,e),l(t,U,e),l(t,ms,e),y(I,t,e),l(t,ds,e),y(f,t,e),l(t,us,e),l(t,g,e),l(t,Js,e),l(t,b,e),l(t,Ts,e),l(t,C,e),l(t,Us,e),y(G,t,e),l(t,ws,e),l(t,x,e),l(t,js,e),y(B,t,e),l(t,Is,e),l(t,v,e),l(t,fs,e),y(Z,t,e),l(t,gs,e),l(t,$,e),l(t,bs,e),l(t,k,e),l(t,Cs,e),y(N,t,e),l(t,Gs,e),l(t,Q,e),l(t,xs,e),y(W,t,e),l(t,Bs,e),l(t,V,e),l(t,vs,e),y(S,t,e),l(t,Zs,e),l(t,q,e),l(t,$s,e),y(A,t,e),l(t,ks,e),l(t,R,e),l(t,Ns,e),y(z,t,e),l(t,Qs,e),l(t,_,e),l(t,Ws,e),y(X,t,e),l(t,Vs,e),y(E,t,e),l(t,Ss,e),l(t,H,e),l(t,qs,e),y(Y,t,e),l(t,As,e),l(t,F,e),l(t,Rs,e),y(L,t,e),l(t,zs,e),l(t,D,e),l(t,_s,e),y(P,t,e),l(t,Xs,e),l(t,K,e),l(t,Es,e),y(O,t,e),l(t,Hs,e),l(t,tt,e),l(t,Ys,e),l(t,et,e),l(t,Fs,e),y(st,t,e),l(t,Ls,e),l(t,lt,e),l(t,Ds,e),y(at,t,e),l(t,Ps,e),l(t,nt,e),l(t,Ks,e),y(ot,t,e),l(t,Os,e),l(t,it,e),l(t,tl,e),y(pt,t,e),l(t,el,e),l(t,Mt,e),l(t,sl,e),l(t,rt,e),l(t,ll,e),y(yt,t,e),l(t,al,e),l(t,ct,e),l(t,nl,e),y(ht,t,e),l(t,ol,e),l(t,mt,e),l(t,il,e),l(t,dt,e),l(t,pl,e),y(ut,t,e),l(t,Ml,e),l(t,Jt,e),l(t,rl,e),l(t,Tt,e),l(t,yl,e),y(Ut,t,e),l(t,cl,e),l(t,wt,e),l(t,hl,e),l(t,jt,e),l(t,ml,e),y(It,t,e),l(t,dl,e),l(t,ft,e),l(t,ul,e),y(gt,t,e),l(t,Jl,e),l(t,bt,e),l(t,Tl,e),y(Ct,t,e),l(t,Ul,e),l(t,Gt,e),l(t,wl,e),y(xt,t,e),l(t,jl,e),l(t,Bt,e),l(t,Il,e),y(vt,t,e),l(t,fl,e),l(t,Zt,e),l(t,gl,e),l(t,$t,e),l(t,bl,e),y(kt,t,e),l(t,Cl,e),l(t,Nt,e),l(t,Gl,e),y(Qt,t,e),l(t,xl,e),l(t,Wt,e),l(t,Bl,e),y(Vt,t,e),l(t,vl,e),l(t,St,e),l(t,Zl,e),y(qt,t,e),l(t,$l,e),l(t,At,e),l(t,kl,e),y(w,t,e),l(t,Nl,e),y(Rt,t,e),l(t,Ql,e),l(t,zt,e),l(t,Wl,e),l(t,_t,e),l(t,Vl,e),y(Xt,t,e),l(t,Sl,e),l(t,Et,e),l(t,ql,e),y(Ht,t,e),l(t,Al,e),l(t,Yt,e),l(t,Rl,e),l(t,Ft,e),l(t,zl,e),y(Lt,t,e),l(t,_l,e),y(Dt,t,e),l(t,Xl,e),l(t,Pt,e),l(t,El,e),l(t,Kt,e),l(t,Hl,e),y(Ot,t,e),l(t,Yl,e),y(te,t,e),l(t,Fl,e),l(t,ee,e),l(t,Ll,e),y(se,t,e),l(t,Dl,e),l(t,le,e),l(t,Pl,e),y(ae,t,e),l(t,Kl,e),l(t,ne,e),l(t,Ol,e),y(oe,t,e),l(t,ta,e),l(t,ie,e),l(t,ea,e),l(t,pe,e),l(t,sa,e),l(t,Me,e),l(t,la,e),y(re,t,e),l(t,aa,e),l(t,ye,e),l(t,na,e),y(ce,t,e),l(t,oa,e),y(he,t,e),l(t,ia,e),l(t,me,e),l(t,pa,e),y(de,t,e),l(t,Ma,e),l(t,ue,e),l(t,ra,e),y(Je,t,e),l(t,ya,e),l(t,Te,e),l(t,ca,e),y(j,t,e),l(t,ha,e),y(Ue,t,e),l(t,ma,e),l(t,we,e),l(t,da,e),l(t,je,e),l(t,ua,e),l(t,Ie,e),l(t,Ja,e),y(fe,t,e),l(t,Ta,e),l(t,ge,e),l(t,Ua,e),l(t,be,e),l(t,wa,e),l(t,Ce,e),l(t,ja,e),y(Ge,t,e),l(t,Ia,e),l(t,xe,e),l(t,fa,e),l(t,Be,e),l(t,ga,e),y(ve,t,e),l(t,ba,e),l(t,Ze,e),l(t,Ca,e),y($e,t,e),l(t,Ga,e),l(t,ke,e),l(t,xa,e),y(Ne,t,e),l(t,Ba,e),l(t,Qe,e),l(t,va,e),y(We,t,e),l(t,Za,e),l(t,Ve,e),l(t,$a,e),l(t,Se,e),l(t,ka,e),l(t,qe,e),l(t,Na,e),y(Ae,t,e),l(t,Qa,e),l(t,Re,e),l(t,Wa,e),l(t,ze,e),l(t,Va,e),l(t,_e,e),l(t,Sa,e),y(Xe,t,e),l(t,qa,e),l(t,Ee,e),l(t,Aa,e),y(He,t,e),l(t,Ra,e),l(t,Ye,e),l(t,za,e),y(Fe,t,e),l(t,_a,e),l(t,Le,e),l(t,Xa,e),y(De,t,e),l(t,Ea,e),l(t,Pe,e),l(t,Ha,e),y(Ke,t,e),l(t,Ya,e),l(t,Oe,e),l(t,Fa,e),y(ts,t,e),l(t,La,e),l(t,es,e),l(t,Da,e),y(ss,t,e),l(t,Pa,e),l(t,ls,e),l(t,Ka,e),y(as,t,e),l(t,Oa,e),l(t,ns,e),l(t,tn,e),y(os,t,e),l(t,en,e),y(is,t,e),l(t,sn,e),l(t,ps,e),l(t,ln,e),l(t,Ms,e),l(t,an,e),l(t,rs,e),l(t,nn,e),y(ys,t,e),l(t,on,e),l(t,hs,e),pn=!0},p(t,[e]){const Ro={};e&2&&(Ro.$$scope={dirty:e,ctx:t}),w.$set(Ro);const zo={};e&2&&(zo.$$scope={dirty:e,ctx:t}),j.$set(zo)},i(t){pn||(c(I.$$.fragment,t),c(f.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(Z.$$.fragment,t),c(N.$$.fragment,t),c(W.$$.fragment,t),c(S.$$.fragment,t),c(A.$$.fragment,t),c(z.$$.fragment,t),c(X.$$.fragment,t),c(E.$$.fragment,t),c(Y.$$.fragment,t),c(L.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(st.$$.fragment,t),c(at.$$.fragment,t),c(ot.$$.fragment,t),c(pt.$$.fragment,t),c(yt.$$.fragment,t),c(ht.$$.fragment,t),c(ut.$$.fragment,t),c(Ut.$$.fragment,t),c(It.$$.fragment,t),c(gt.$$.fragment,t),c(Ct.$$.fragment,t),c(xt.$$.fragment,t),c(vt.$$.fragment,t),c(kt.$$.fragment,t),c(Qt.$$.fragment,t),c(Vt.$$.fragment,t),c(qt.$$.fragment,t),c(w.$$.fragment,t),c(Rt.$$.fragment,t),c(Xt.$$.fragment,t),c(Ht.$$.fragment,t),c(Lt.$$.fragment,t),c(Dt.$$.fragment,t),c(Ot.$$.fragment,t),c(te.$$.fragment,t),c(se.$$.fragment,t),c(ae.$$.fragment,t),c(oe.$$.fragment,t),c(re.$$.fragment,t),c(ce.$$.fragment,t),c(he.$$.fragment,t),c(de.$$.fragment,t),c(Je.$$.fragment,t),c(j.$$.fragment,t),c(Ue.$$.fragment,t),c(fe.$$.fragment,t),c(Ge.$$.fragment,t),c(ve.$$.fragment,t),c($e.$$.fragment,t),c(Ne.$$.fragment,t),c(We.$$.fragment,t),c(Ae.$$.fragment,t),c(Xe.$$.fragment,t),c(He.$$.fragment,t),c(Fe.$$.fragment,t),c(De.$$.fragment,t),c(Ke.$$.fragment,t),c(ts.$$.fragment,t),c(ss.$$.fragment,t),c(as.$$.fragment,t),c(os.$$.fragment,t),c(is.$$.fragment,t),c(ys.$$.fragment,t),pn=!0)},o(t){h(I.$$.fragment,t),h(f.$$.fragment,t),h(G.$$.fragment,t),h(B.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(W.$$.fragment,t),h(S.$$.fragment,t),h(A.$$.fragment,t),h(z.$$.fragment,t),h(X.$$.fragment,t),h(E.$$.fragment,t),h(Y.$$.fragment,t),h(L.$$.fragment,t),h(P.$$.fragment,t),h(O.$$.fragment,t),h(st.$$.fragment,t),h(at.$$.fragment,t),h(ot.$$.fragment,t),h(pt.$$.fragment,t),h(yt.$$.fragment,t),h(ht.$$.fragment,t),h(ut.$$.fragment,t),h(Ut.$$.fragment,t),h(It.$$.fragment,t),h(gt.$$.fragment,t),h(Ct.$$.fragment,t),h(xt.$$.fragment,t),h(vt.$$.fragment,t),h(kt.$$.fragment,t),h(Qt.$$.fragment,t),h(Vt.$$.fragment,t),h(qt.$$.fragment,t),h(w.$$.fragment,t),h(Rt.$$.fragment,t),h(Xt.$$.fragment,t),h(Ht.$$.fragment,t),h(Lt.$$.fragment,t),h(Dt.$$.fragment,t),h(Ot.$$.fragment,t),h(te.$$.fragment,t),h(se.$$.fragment,t),h(ae.$$.fragment,t),h(oe.$$.fragment,t),h(re.$$.fragment,t),h(ce.$$.fragment,t),h(he.$$.fragment,t),h(de.$$.fragment,t),h(Je.$$.fragment,t),h(j.$$.fragment,t),h(Ue.$$.fragment,t),h(fe.$$.fragment,t),h(Ge.$$.fragment,t),h(ve.$$.fragment,t),h($e.$$.fragment,t),h(Ne.$$.fragment,t),h(We.$$.fragment,t),h(Ae.$$.fragment,t),h(Xe.$$.fragment,t),h(He.$$.fragment,t),h(Fe.$$.fragment,t),h(De.$$.fragment,t),h(Ke.$$.fragment,t),h(ts.$$.fragment,t),h(ss.$$.fragment,t),h(as.$$.fragment,t),h(os.$$.fragment,t),h(is.$$.fragment,t),h(ys.$$.fragment,t),pn=!1},d(t){t&&(s(T),s(U),s(ms),s(ds),s(us),s(g),s(Js),s(b),s(Ts),s(C),s(Us),s(ws),s(x),s(js),s(Is),s(v),s(fs),s(gs),s($),s(bs),s(k),s(Cs),s(Gs),s(Q),s(xs),s(Bs),s(V),s(vs),s(Zs),s(q),s($s),s(ks),s(R),s(Ns),s(Qs),s(_),s(Ws),s(Vs),s(Ss),s(H),s(qs),s(As),s(F),s(Rs),s(zs),s(D),s(_s),s(Xs),s(K),s(Es),s(Hs),s(tt),s(Ys),s(et),s(Fs),s(Ls),s(lt),s(Ds),s(Ps),s(nt),s(Ks),s(Os),s(it),s(tl),s(el),s(Mt),s(sl),s(rt),s(ll),s(al),s(ct),s(nl),s(ol),s(mt),s(il),s(dt),s(pl),s(Ml),s(Jt),s(rl),s(Tt),s(yl),s(cl),s(wt),s(hl),s(jt),s(ml),s(dl),s(ft),s(ul),s(Jl),s(bt),s(Tl),s(Ul),s(Gt),s(wl),s(jl),s(Bt),s(Il),s(fl),s(Zt),s(gl),s($t),s(bl),s(Cl),s(Nt),s(Gl),s(xl),s(Wt),s(Bl),s(vl),s(St),s(Zl),s($l),s(At),s(kl),s(Nl),s(Ql),s(zt),s(Wl),s(_t),s(Vl),s(Sl),s(Et),s(ql),s(Al),s(Yt),s(Rl),s(Ft),s(zl),s(_l),s(Xl),s(Pt),s(El),s(Kt),s(Hl),s(Yl),s(Fl),s(ee),s(Ll),s(Dl),s(le),s(Pl),s(Kl),s(ne),s(Ol),s(ta),s(ie),s(ea),s(pe),s(sa),s(Me),s(la),s(aa),s(ye),s(na),s(oa),s(ia),s(me),s(pa),s(Ma),s(ue),s(ra),s(ya),s(Te),s(ca),s(ha),s(ma),s(we),s(da),s(je),s(ua),s(Ie),s(Ja),s(Ta),s(ge),s(Ua),s(be),s(wa),s(Ce),s(ja),s(Ia),s(xe),s(fa),s(Be),s(ga),s(ba),s(Ze),s(Ca),s(Ga),s(ke),s(xa),s(Ba),s(Qe),s(va),s(Za),s(Ve),s($a),s(Se),s(ka),s(qe),s(Na),s(Qa),s(Re),s(Wa),s(ze),s(Va),s(_e),s(Sa),s(qa),s(Ee),s(Aa),s(Ra),s(Ye),s(za),s(_a),s(Le),s(Xa),s(Ea),s(Pe),s(Ha),s(Ya),s(Oe),s(Fa),s(La),s(es),s(Da),s(Pa),s(ls),s(Ka),s(Oa),s(ns),s(tn),s(en),s(sn),s(ps),s(ln),s(Ms),s(an),s(rs),s(nn),s(on),s(hs)),s(J),m(I,t),m(f,t),m(G,t),m(B,t),m(Z,t),m(N,t),m(W,t),m(S,t),m(A,t),m(z,t),m(X,t),m(E,t),m(Y,t),m(L,t),m(P,t),m(O,t),m(st,t),m(at,t),m(ot,t),m(pt,t),m(yt,t),m(ht,t),m(ut,t),m(Ut,t),m(It,t),m(gt,t),m(Ct,t),m(xt,t),m(vt,t),m(kt,t),m(Qt,t),m(Vt,t),m(qt,t),m(w,t),m(Rt,t),m(Xt,t),m(Ht,t),m(Lt,t),m(Dt,t),m(Ot,t),m(te,t),m(se,t),m(ae,t),m(oe,t),m(re,t),m(ce,t),m(he,t),m(de,t),m(Je,t),m(j,t),m(Ue,t),m(fe,t),m(Ge,t),m(ve,t),m($e,t),m(Ne,t),m(We,t),m(Ae,t),m(Xe,t),m(He,t),m(Fe,t),m(De,t),m(Ke,t),m(ts,t),m(ss,t),m(as,t),m(os,t),m(is,t),m(ys,t)}}}const ai='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: Extra inputs to chat templates","local":"advanced-extra-inputs-to-chat-templates","sections":[],"depth":2},{"title":"Advanced: Tool use / function calling","local":"advanced-tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Retrieval-augmented generation","local":"advanced-retrieval-augmented-generation","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"Why do some models have multiple templates?","local":"why-do-some-models-have-multiple-templates","sections":[],"depth":3},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"For loops","local":"for-loops","sections":[],"depth":3},{"title":"If statements","local":"if-statements","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3}],"depth":2}],"depth":1}';function ni(cs){return Lo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yi extends Do{constructor(J){super(),Po(this,J,ni,li,Fo,{})}}export{yi as component};
