import{s as al,o as nl,n as ll}from"../chunks/scheduler.c59d9fbb.js";import{S as il,i as pl,g as y,s as a,r as i,A as ml,h as d,f as s,c as n,j as el,u as p,x as h,k as tl,y as rl,a as l,v as m,d as r,t as o,w as M}from"../chunks/index.a47918e3.js";import{T as sl}from"../chunks/Tip.3fcf4aa4.js";import{C as f}from"../chunks/CodeBlock.936db8cd.js";import{D as ol}from"../chunks/DocNotebookDropdown.c0ce911f.js";import{H as Se,E as Ml}from"../chunks/EditOnGithub.813e7c73.js";function yl(Ee){let c,b="Some datasets on the Hugging Face Hub don’t have a <code>ClassLabel</code> feature for the label column. In these cases, you should compute the candidate labels manually by first computing the id2label mapping as follows:";return{c(){c=y("p"),c.innerHTML=b},l(w){c=d(w,"P",{"data-svelte-h":!0}),h(c)!=="svelte-127biyz"&&(c.innerHTML=b)},m(w,u){l(w,c,u)},p:ll,d(w){w&&s(c)}}}function dl(Ee){let c,b="You might find you can get better performance by tweaking the <code>template</code> argument from the default of <code>&quot;The sentence is {}&quot;</code> to variants like <code>&quot;This sentence is {}&quot;</code> or <code>&quot;This example is {}&quot;</code>.";return{c(){c=y("p"),c.innerHTML=b},l(w){c=d(w,"P",{"data-svelte-h":!0}),h(c)!=="svelte-mk86f2"&&(c.innerHTML=b)},m(w,u){l(w,c,u)},p:ll,d(w){w&&s(c)}}}function hl(Ee){let c,b,w,u,T,Ae,$,qe,j,bs="Although SetFit was designed for few-shot learning, the method can also be applied in scenarios where no labeled data is available. The main trick is to create <em>synthetic examples</em> that resemble the classification task, and then train a SetFit model on them.",De,C,us="Remarkably, this simple technique typically outperforms the zero-shot pipeline in 🤗 Transformers, and can generate predictions by a factor of 5x (or more) faster!",Le,g,Js="In this tutorial, we’ll explore how:",Pe,Z,Us="<li>SetFit can be applied for zero-shot classification</li> <li>Adding synthetic examples can also provide a performance boost to few-shot classification.</li>",Ke,x,Oe,I,Ts="If you’re running this Notebook on Colab or some other cloud platform, you will need to install the <code>setfit</code> library. Uncomment the following cell and run it:",et,W,tt,k,$s="To benchmark the performance of the “zero-shot” method, we’ll use the following dataset and pretrained model:",st,G,lt,R,js="Next, we’ll download the reference dataset from the Hugging Face Hub:",at,X,nt,N,it,Q,Cs="Now that we’re set up, let’s create some synthetic data to train on!",pt,_,mt,B,gs="The first thing we need to do is create a dataset of synthetic examples. In <code>setfit</code>, we can do this by applying the <code>get_templated_dataset()</code> function to a dummy dataset. This function expects a few main things:",rt,F,Zs="<li>A list of candidate labels to classify with. We’ll use the labels from the reference dataset here, but this could be anything that’s relevant to the task and dataset at hand.</li> <li>A template to generate examples with. By default, it is <code>&quot;This sentence is {}&quot;</code>, where the <code>{}</code> will be filled by one of the candidate labels</li> <li>A sample size $N$, which will create $N$ synthetic examples per class. We find $N=8$ usually works best.</li>",ot,z,xs="Armed with this information, let’s first extract some candidate labels from the dataset:",Mt,V,yt,v,dt,J,ht,Y,ft,E,Is="Now that we have the labels, it’s a simple matter to create synthetic examples:",ct,S,wt,H,bt,U,ut,A,Ws="Since our dataset has 6 classes and we chose a sample size of 8, our synthetic dataset contains $6\\times 8=48$ examples. If we take a look at a few of the examples:",Jt,q,Ut,D,Tt,L,ks="We can see that each input takes the form of the template and has a corresponding label associated with it.",$t,P,Gs="Let’s not train a SetFit model on these examples!",jt,K,Ct,O,Rs="To train a SetFit model, the first thing to do is download a pretrained checkpoint from the Hub. We can do so by using the <code>SetFitModel.from_pretrained()</code> method:",gt,ee,Zt,te,Xs='Here, we’ve downloaded a pretrained Sentence Transformer from the Hub and added a logistic classification head to the create the SetFit model. As indicated in the message, we need to train this model on some labeled examples. We can do so by using the <a href="/docs/setfit/pr_527/en/reference/trainer#setfit.Trainer">Trainer</a> class as follows:',xt,se,It,le,Ns="Now that we’ve created a trainer, we can train it! While we’re at it, let’s time how long it takes to train and evaluate the model:",Wt,ae,kt,ne,Gt,ie,Rt,pe,Qs="Great, now that we have a reference score let’s compare against the zero-shot pipeline from 🤗 Transformers.",Xt,me,Nt,re,_s="🤗 Transformers provides a zero-shot pipeline that frames text classification as a natural language inference task. Let’s load the pipeline and place it on the GPU for fast inference:",Qt,oe,_t,Me,Bs="Now that we have the model, let’s generate some predictions. We’ll use the same candidate labels as we did with SetFit and increase the batch size for to speed things up:",Bt,ye,Ft,de,zt,he,Fs="Note that this took almost 5x longer to generate predictions than SetFit! OK, so how well does it perform? Since each prediction is a dictionary of label names ranked by score:",Vt,fe,vt,ce,Yt,we,zs="We can use the <code>str2int()</code> function from the <code>label</code> column to convert them to integers.",Et,be,St,ue,Vs="<strong>Note:</strong> As noted earlier, if you’re using a dataset that doesn’t have a <code>ClassLabel</code> feature for the label column, you’ll need to compute the label mapping manually with something like:",Ht,Je,At,Ue,vs="The last step is to compute accuracy using 🤗 Evaluate:",qt,Te,Dt,$e,Lt,je,Ys="Compared to SetFit, this approach performs significantly worse. Let’s wrap up our analysis by combining synthetic examples with a few labeled ones.",Pt,Ce,Kt,ge,Es="If you have a few labeled examples, adding synthetic data can often boost performance. To simulate this, let’s first sample 8 labeled examples from our reference dataset:",Ot,Ze,es,xe,ts,Ie,Ss="To warm up, we’ll train a SetFit model on these true labels:",ss,We,ls,ke,as,Ge,Hs="Note that for this particular dataset, the performance with true labels is <em>worse</em> than training on synthetic examples! In our experiments, we found that the difference depends strongly on the dataset in question. Since SetFit models are fast to train, you can always try both approaches and pick the best one.",ns,Re,As="In any case, let’s now add some synthetic examples to our training set:",is,Xe,ps,Ne,ms,Qe,qs="As before, we can train and evaluate SetFit with the augmented dataset:",rs,_e,os,Be,Ms,Fe,Ds="Great, this has given us a significant boost in performance and given us a few percentage points over the purely synthetic example.",ys,ze,Ls="Let’s plot the final results for comparison:",ds,Ve,hs,ve,Ps='<img src="https://github.com/huggingface/setfit/assets/37621491/b02d3e62-d51c-4506-91f6-2fe9b7ef554d" alt="setfit_zero_shot_results"/>',fs,Ye,cs,He,ws;return T=new Se({props:{title:"Zero-shot Text Classification",local:"zero-shot-text-classification",headingTag:"h1"}}),$=new ol({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/zero_shot.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/zero_shot.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/zero_shot.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/zero_shot.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/zero_shot.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/zero_shot.ipynb"}]}}),x=new Se({props:{title:"Setup",local:"setup",headingTag:"h2"}}),W=new f({props:{code:"JTIzJTIwJTI1cGlwJTIwaW5zdGFsbCUyMHNldGZpdCUyMG1hdHBsb3RsaWI=",highlighted:'<span class="hljs-comment"># %pip install setfit matplotlib</span>',wrap:!1}}),G=new f({props:{code:"ZGF0YXNldF9pZCUyMCUzRCUyMCUyMmVtb3Rpb24lMjIlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRnBhcmFwaHJhc2UtbXBuZXQtYmFzZS12MiUyMg==",highlighted:`dataset_id = <span class="hljs-string">&quot;emotion&quot;</span>
model_id = <span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>`,wrap:!1}}),X=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcmVmZXJlbmNlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9pZCklMEFyZWZlcmVuY2VfZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

reference_dataset = load_dataset(dataset_id)
reference_dataset`,wrap:!1}}),N=new f({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTYwMDAlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTIwJTIwJTIwJTIwdmFsaWRhdGlvbiUzQSUyMERhdGFzZXQoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlM0ElMjAlNUIndGV4dCclMkMlMjAnbGFiZWwnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjAyMDAwJTBBJTIwJTIwJTIwJTIwJTdEKSUwQSUyMCUyMCUyMCUyMHRlc3QlM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMjAwMCUwQSUyMCUyMCUyMCUyMCU3RCklMEElN0Qp",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">16000</span>
    })
    validation: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">2000</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">2000</span>
    })
})`,wrap:!1}}),_=new Se({props:{title:"Creating a synthetic dataset",local:"creating-a-synthetic-dataset",headingTag:"h2"}}),V=new f({props:{code:"JTIzJTIwRXh0cmFjdCUyMENsYXNzTGFiZWwlMjBmZWF0dXJlJTIwZnJvbSUyMCUyMmxhYmVsJTIyJTIwY29sdW1uJTBBbGFiZWxfZmVhdHVyZXMlMjAlM0QlMjByZWZlcmVuY2VfZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQlMEElMjMlMjBMYWJlbCUyMG5hbWVzJTIwdG8lMjBjbGFzc2lmeSUyMHdpdGglMEFjYW5kaWRhdGVfbGFiZWxzJTIwJTNEJTIwbGFiZWxfZmVhdHVyZXMubmFtZXMlMEFjYW5kaWRhdGVfbGFiZWxz",highlighted:`<span class="hljs-comment"># Extract ClassLabel feature from &quot;label&quot; column</span>
label_features = reference_dataset[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-comment"># Label names to classify with</span>
candidate_labels = label_features.names
candidate_labels`,wrap:!1}}),v=new f({props:{code:"JTVCJ3NhZG5lc3MnJTJDJTIwJ2pveSclMkMlMjAnbG92ZSclMkMlMjAnYW5nZXInJTJDJTIwJ2ZlYXInJTJDJTIwJ3N1cnByaXNlJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;sadness</span>&#x27;, <span class="hljs-symbol">&#x27;joy</span>&#x27;, <span class="hljs-symbol">&#x27;love</span>&#x27;, <span class="hljs-symbol">&#x27;anger</span>&#x27;, <span class="hljs-symbol">&#x27;fear</span>&#x27;, <span class="hljs-symbol">&#x27;surprise</span>&#x27;]',wrap:!1}}),J=new sl({props:{$$slots:{default:[yl]},$$scope:{ctx:Ee}}}),Y=new f({props:{code:"ZGVmJTIwZ2V0X2lkMmxhYmVsKGRhdGFzZXQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwY29sdW1uJTIwd2l0aCUyMHRoZSUyMGxhYmVsJTIwbmFtZXMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUyMCUzRCUyMGRhdGFzZXQudW5pcXVlKCUyMmxhYmVsX3RleHQlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwY29sdW1uJTIwd2l0aCUyMHRoZSUyMGxhYmVsJTIwSURzJTBBJTIwJTIwJTIwJTIwbGFiZWxfaWRzJTIwJTNEJTIwZGF0YXNldC51bmlxdWUoJTIybGFiZWwlMjIpJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlMjAlM0QlMjBkaWN0KHppcChsYWJlbF9pZHMlMkMlMjBsYWJlbF9uYW1lcykpJTBBJTIwJTIwJTIwJTIwJTIzJTIwU29ydCUyMGJ5JTIwbGFiZWwlMjBJRCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QmtleSUzQSUyMHZhbCUyMGZvciUyMGtleSUyQyUyMHZhbCUyMGluJTIwc29ydGVkKGlkMmxhYmVsLml0ZW1zKCklMkMlMjBrZXklMjAlM0QlMjBsYW1iZGElMjB4JTNBJTIweCU1QjAlNUQpJTdEJTBBJTBBaWQybGFiZWwlMjAlM0QlMjBnZXRfaWQybGFiZWwocmVmZXJlbmNlX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCklMEFjYW5kaWRhdGVfbGFiZWxzJTIwJTNEJTIwbGlzdChpZDJsYWJlbC52YWx1ZXMoKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_id2label</span>(<span class="hljs-params">dataset</span>):
    <span class="hljs-comment"># The column with the label names</span>
    label_names = dataset.unique(<span class="hljs-string">&quot;label_text&quot;</span>)
    <span class="hljs-comment"># The column with the label IDs</span>
    label_ids = dataset.unique(<span class="hljs-string">&quot;label&quot;</span>)
    id2label = <span class="hljs-built_in">dict</span>(<span class="hljs-built_in">zip</span>(label_ids, label_names))
    <span class="hljs-comment"># Sort by label ID</span>
    <span class="hljs-keyword">return</span> {key: val <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(id2label.items(), key = <span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">0</span>])}

id2label = get_id2label(reference_dataset[<span class="hljs-string">&quot;train&quot;</span>])
candidate_labels = <span class="hljs-built_in">list</span>(id2label.values())`,wrap:!1}}),S=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjBzZXRmaXQlMjBpbXBvcnQlMjBnZXRfdGVtcGxhdGVkX2RhdGFzZXQlMEElMEElMjMlMjBBJTIwZHVtbXklMjBkYXRhc2V0JTIwdG8lMjBmaWxsJTIwd2l0aCUyMHN5bnRoZXRpYyUyMGV4YW1wbGVzJTBBZHVtbXlfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiU3RCklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwZ2V0X3RlbXBsYXRlZF9kYXRhc2V0KGR1bW15X2RhdGFzZXQlMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTNEY2FuZGlkYXRlX2xhYmVscyUyQyUyMHNhbXBsZV9zaXplJTNEOCklMEF0cmFpbl9kYXRhc2V0",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> get_templated_dataset

<span class="hljs-comment"># A dummy dataset to fill with synthetic examples</span>
dummy_dataset = Dataset.from_dict({})
train_dataset = get_templated_dataset(dummy_dataset, candidate_labels=candidate_labels, sample_size=<span class="hljs-number">8</span>)
train_dataset`,wrap:!1}}),H=new f({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQ4JTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">48</span>
})`,wrap:!1}}),U=new sl({props:{$$slots:{default:[dl]},$$scope:{ctx:Ee}}}),q=new f({props:{code:"dHJhaW5fZGF0YXNldC5zaHVmZmxlKCklNUIlM0EzJTVE",highlighted:'train_dataset.shuffle()[:<span class="hljs-number">3</span>]',wrap:!1}}),D=new f({props:{code:"JTdCJ3RleHQnJTNBJTIwJTVCJ1RoaXMlMjBzZW50ZW5jZSUyMGlzJTIwbG92ZSclMkMlMEElMjAlMjAnVGhpcyUyMHNlbnRlbmNlJTIwaXMlMjBmZWFyJyUyQyUwQSUyMCUyMCdUaGlzJTIwc2VudGVuY2UlMjBpcyUyMGpveSclNUQlMkMlMEElMjAnbGFiZWwnJTNBJTIwJTVCMiUyQyUyMDQlMkMlMjAxJTVEJTdE",highlighted:`{<span class="hljs-symbol">&#x27;text</span>&#x27;: [<span class="hljs-symbol">&#x27;This</span> sentence <span class="hljs-keyword">is</span> love&#x27;,
  <span class="hljs-symbol">&#x27;This</span> sentence <span class="hljs-keyword">is</span> fear&#x27;,
  <span class="hljs-symbol">&#x27;This</span> sentence <span class="hljs-keyword">is</span> joy&#x27;],
 <span class="hljs-symbol">&#x27;label</span>&#x27;: [<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),K=new Se({props:{title:"Fine-tuning the model",local:"fine-tuning-the-model",headingTag:"h2"}}),ee=new f({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

model = SetFitModel.from_pretrained(model_id)`,wrap:!1}}),se=new f({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RyZWZlcmVuY2VfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEEp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=reference_dataset[<span class="hljs-string">&quot;test&quot;</span>]
)`,wrap:!1}}),ae=new f({props:{code:"JTI1JTI1dGltZSUwQXRyYWluZXIudHJhaW4oKSUwQXplcm9zaG90X21ldHJpY3MlMjAlM0QlMjB0cmFpbmVyLmV2YWx1YXRlKCklMEF6ZXJvc2hvdF9tZXRyaWNz",highlighted:`%%time
trainer.train()
zeroshot_metrics = trainer.evaluate()
zeroshot_metrics`,wrap:!1}}),ne=new f({props:{code:"KioqKiolMjBSdW5uaW5nJTIwdHJhaW5pbmclMjAqKioqKiUwQSUyMCUyME51bSUyMGV4YW1wbGVzJTIwJTNEJTIwMTkyMCUwQSUyMCUyME51bSUyMGVwb2NocyUyMCUzRCUyMDElMEElMjAlMjBUb3RhbCUyMG9wdGltaXphdGlvbiUyMHN0ZXBzJTIwJTNEJTIwMTIwJTBBJTIwJTIwVG90YWwlMjB0cmFpbiUyMGJhdGNoJTIwc2l6ZSUyMCUzRCUyMDE2JTBBKioqKiolMjBSdW5uaW5nJTIwZXZhbHVhdGlvbiUyMCoqKioqJTBBJTdCJ2FjY3VyYWN5JyUzQSUyMDAuNTM0NSU3RA==",highlighted:`***** Running training *****
  Num examples = <span class="hljs-number">1920</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">120</span>
  Total train batch size = <span class="hljs-number">16</span>
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.5345</span>}`,wrap:!1}}),ie=new f({props:{code:"Q1BVJTIwdGltZXMlM0ElMjB1c2VyJTIwMTIuOSUyMHMlMkMlMjBzeXMlM0ElMjAyLjM3JTIwcyUyQyUyMHRvdGFsJTNBJTIwMTUuMiUyMHMlMEFXYWxsJTIwdGltZSUzQSUyMDExJTIwcw==",highlighted:`<span class="hljs-attribute">CPU</span> times: user <span class="hljs-number">12</span>.<span class="hljs-number">9</span> s, sys: <span class="hljs-number">2</span>.<span class="hljs-number">37</span> s, total: <span class="hljs-number">15</span>.<span class="hljs-number">2</span> s
<span class="hljs-attribute">Wall</span> time: <span class="hljs-number">11</span> s`,wrap:!1}}),me=new Se({props:{title:"Comparing against the zero-shot pipeline from 🤗 Transformers",local:"comparing-against-the-zero-shot-pipeline-from--transformers",headingTag:"h2"}}),oe=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnplcm8tc2hvdC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMGRldmljZSUzRDAp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, device=<span class="hljs-number">0</span>)`,wrap:!1}}),ye=new f({props:{code:"JTI1JTI1dGltZSUwQXplcm9zaG90X3ByZWRzJTIwJTNEJTIwcGlwZShyZWZlcmVuY2VfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDE2JTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMp",highlighted:`%%time
zeroshot_preds = pipe(reference_dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;text&quot;</span>], batch_size=<span class="hljs-number">16</span>, candidate_labels=candidate_labels)`,wrap:!1}}),de=new f({props:{code:"Q1BVJTIwdGltZXMlM0ElMjB1c2VyJTIwMW1pbiUyMDEwcyUyQyUyMHN5cyUzQSUyMDE2NiUyMG1zJTJDJTIwdG90YWwlM0ElMjAxbWluJTIwMTFzJTBBV2FsbCUyMHRpbWUlM0ElMjA1My4xJTIwcw==",highlighted:`<span class="hljs-attribute">CPU</span> times: user <span class="hljs-number">1</span>min <span class="hljs-number">10</span>s, sys: <span class="hljs-number">166</span> ms, total: <span class="hljs-number">1</span>min <span class="hljs-number">11</span>s
<span class="hljs-attribute">Wall</span> time: <span class="hljs-number">53</span>.<span class="hljs-number">1</span> s`,wrap:!1}}),fe=new f({props:{code:"emVyb3Nob3RfcHJlZHMlNUIwJTVE",highlighted:'zeroshot_preds[<span class="hljs-number">0</span>]',wrap:!1}}),ce=new f({props:{code:"JTdCJ3NlcXVlbmNlJyUzQSUyMCdpbSUyMGZlZWxpbmclMjByYXRoZXIlMjByb3R0ZW4lMjBzbyUyMGltJTIwbm90JTIwdmVyeSUyMGFtYml0aW91cyUyMHJpZ2h0JTIwbm93JyUyQyUwQSUyMCdsYWJlbHMnJTNBJTIwJTVCJ3NhZG5lc3MnJTJDJTIwJ2FuZ2VyJyUyQyUyMCdzdXJwcmlzZSclMkMlMjAnZmVhciclMkMlMjAnam95JyUyQyUyMCdsb3ZlJyU1RCUyQyUwQSUyMCdzY29yZXMnJTNBJTIwJTVCMC43MzY3OTg1ODQ0NjEyMTIyJTJDJTBBJTIwJTIwMC4xMDA0MTY3NDIyNjUyMjQ0NiUyQyUwQSUyMCUyMDAuMDk3NzAxNTY0NDMxMTkwNDklMkMlMEElMjAlMjAwLjA1ODgwMTEwNzEwODU5Mjk5JTJDJTBBJTIwJTIwMC4wMDQyNjYzNTU2NTIzNjIxMDglMkMlMEElMjAlMjAwLjAwMjAxNTY3NjgxNTA2Mjc2MTMlNUQlN0Q=",highlighted:`{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;im feeling rather rotten so im not very ambitious right now&#x27;</span>,
 <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;sadness&#x27;</span>, <span class="hljs-string">&#x27;anger&#x27;</span>, <span class="hljs-string">&#x27;surprise&#x27;</span>, <span class="hljs-string">&#x27;fear&#x27;</span>, <span class="hljs-string">&#x27;joy&#x27;</span>, <span class="hljs-string">&#x27;love&#x27;</span>],
 <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.7367985844612122</span>,
  <span class="hljs-number">0.10041674226522446</span>,
  <span class="hljs-number">0.09770156443119049</span>,
  <span class="hljs-number">0.05880110710859299</span>,
  <span class="hljs-number">0.004266355652362108</span>,
  <span class="hljs-number">0.0020156768150627613</span>]}`,wrap:!1}}),be=new f({props:{code:"cHJlZHMlMjAlM0QlMjAlNUJsYWJlbF9mZWF0dXJlcy5zdHIyaW50KHByZWQlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEKSUyMGZvciUyMHByZWQlMjBpbiUyMHplcm9zaG90X3ByZWRzJTVE",highlighted:'preds = [label_features.str2int(pred[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> zeroshot_preds]',wrap:!1}}),Je=new f({props:{code:"aWQybGFiZWwlMjAlM0QlMjBnZXRfaWQybGFiZWwocmVmZXJlbmNlX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCklMEFsYWJlbDJpZCUyMCUzRCUyMCU3QnYlM0FrJTIwZm9yJTIwayUyQ3YlMjBpbiUyMGlkMmxhYmVsLml0ZW1zKCklN0QlMEFwcmVkcyUyMCUzRCUyMCU1QmxhYmVsMmlkJTVCcHJlZCU1QiUyMmxhYmVscyUyMiU1RCU1QjAlNUQlNUQlMjBmb3IlMjBwcmVkJTIwaW4lMjB6ZXJvc2hvdF9wcmVkcyU1RA==",highlighted:`id2label = get_id2label(reference_dataset[<span class="hljs-string">&quot;train&quot;</span>])
label2id = {v:k <span class="hljs-keyword">for</span> k,v <span class="hljs-keyword">in</span> id2label.items()}
preds = [label2id[pred[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]] <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> zeroshot_preds]`,wrap:!1}}),Te=new f({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQXRyYW5zZm9ybWVyc19tZXRyaWNzJTIwJTNEJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkcyUyQyUyMHJlZmVyZW5jZXMlM0RyZWZlcmVuY2VfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJsYWJlbCUyMiU1RCklMEF0cmFuc2Zvcm1lcnNfbWV0cmljcw==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)
transformers_metrics = metric.compute(predictions=preds, references=reference_dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;label&quot;</span>])
transformers_metrics`,wrap:!1}}),$e=new f({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuMzc2NSU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.3765</span>}',wrap:!1}}),Ce=new Se({props:{title:"Augmenting labeled data with synthetic examples",local:"augmenting-labeled-data-with-synthetic-examples",headingTag:"h2"}}),Ze=new f({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMHNhbXBsZV9kYXRhc2V0JTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNhbXBsZV9kYXRhc2V0KHJlZmVyZW5jZV9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBdHJhaW5fZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> sample_dataset

train_dataset = sample_dataset(reference_dataset[<span class="hljs-string">&quot;train&quot;</span>])
train_dataset`,wrap:!1}}),xe=new f({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQ4JTBBJTdEKQ==",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">48</span>
})`,wrap:!1}}),We=new f({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEcmVmZXJlbmNlX2RhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTBBKSUwQXRyYWluZXIudHJhaW4oKSUwQWZld3Nob3RfbWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQWZld3Nob3RfbWV0cmljcw==",highlighted:`model = SetFitModel.from_pretrained(model_id)

trainer = Trainer(
    model=model,
    train_dataset=train_dataset,
    eval_dataset=reference_dataset[<span class="hljs-string">&quot;test&quot;</span>]
)
trainer.train()
fewshot_metrics = trainer.evaluate()
fewshot_metrics`,wrap:!1}}),ke=new f({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNDcwNSU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.4705</span>}',wrap:!1}}),Xe=new f({props:{code:"YXVnbWVudGVkX2RhdGFzZXQlMjAlM0QlMjBnZXRfdGVtcGxhdGVkX2RhdGFzZXQodHJhaW5fZGF0YXNldCUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0RjYW5kaWRhdGVfbGFiZWxzJTJDJTIwc2FtcGxlX3NpemUlM0Q4KSUwQWF1Z21lbnRlZF9kYXRhc2V0",highlighted:`augmented_dataset = get_templated_dataset(train_dataset, candidate_labels=candidate_labels, sample_size=<span class="hljs-number">8</span>)
augmented_dataset`,wrap:!1}}),Ne=new f({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDk2JTBBJTdEKQ==",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">96</span>
})`,wrap:!1}}),_e=new f({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RhdWdtZW50ZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHJlZmVyZW5jZV9kYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUwQSklMEF0cmFpbmVyLnRyYWluKCklMEFhdWdtZW50ZWRfbWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQWF1Z21lbnRlZF9tZXRyaWNz",highlighted:`model = SetFitModel.from_pretrained(model_id)

trainer = Trainer(
    model=model,
    train_dataset=augmented_dataset,
    eval_dataset=reference_dataset[<span class="hljs-string">&quot;test&quot;</span>]
)
trainer.train()
augmented_metrics = trainer.evaluate()
augmented_metrics`,wrap:!1}}),Be=new f({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjEzJTdE",highlighted:'{&#x27;accuracy&#x27;: <span class="hljs-number">0.613</span>}',wrap:!1}}),Ve=new f({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdCglN0IlMjJNZXRob2QlMjIlM0ElNUIlMjJUcmFuc2Zvcm1lcnMlMjAoemVyby1zaG90KSUyMiUyQyUyMCUyMlNldEZpdCUyMCh6ZXJvLXNob3QpJTIyJTJDJTIwJTIyU2V0Rml0JTIwKGF1Z21lbnRlZCklMjIlNUQlMkMlMjAlMjJBY2N1cmFjeSUyMiUzQSUyMCU1QnRyYW5zZm9ybWVyc19tZXRyaWNzJTVCJTIyYWNjdXJhY3klMjIlNUQlMkMlMjB6ZXJvc2hvdF9tZXRyaWNzJTVCJTIyYWNjdXJhY3klMjIlNUQlMkMlMjBhdWdtZW50ZWRfbWV0cmljcyU1QiUyMmFjY3VyYWN5JTIyJTVEJTVEJTdEKSUwQWRmLnBsb3Qoa2luZCUzRCUyMmJhcmglMjIlMkMlMjB4JTNEJTIyTWV0aG9kJTIyKSUzQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMA==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame.from_dict({<span class="hljs-string">&quot;Method&quot;</span>:[<span class="hljs-string">&quot;Transformers (zero-shot)&quot;</span>, <span class="hljs-string">&quot;SetFit (zero-shot)&quot;</span>, <span class="hljs-string">&quot;SetFit (augmented)&quot;</span>], <span class="hljs-string">&quot;Accuracy&quot;</span>: [transformers_metrics[<span class="hljs-string">&quot;accuracy&quot;</span>], zeroshot_metrics[<span class="hljs-string">&quot;accuracy&quot;</span>], augmented_metrics[<span class="hljs-string">&quot;accuracy&quot;</span>]]})
df.plot(kind=<span class="hljs-string">&quot;barh&quot;</span>, x=<span class="hljs-string">&quot;Method&quot;</span>);                                       `,wrap:!1}}),Ye=new Ml({props:{source:"https://github.com/huggingface/setfit/blob/main/docs/source/en/tutorials/zero_shot.mdx"}}),{c(){c=y("meta"),b=a(),w=y("p"),u=a(),i(T.$$.fragment),Ae=a(),i($.$$.fragment),qe=a(),j=y("p"),j.innerHTML=bs,De=a(),C=y("p"),C.textContent=us,Le=a(),g=y("p"),g.textContent=Js,Pe=a(),Z=y("ul"),Z.innerHTML=Us,Ke=a(),i(x.$$.fragment),Oe=a(),I=y("p"),I.innerHTML=Ts,et=a(),i(W.$$.fragment),tt=a(),k=y("p"),k.textContent=$s,st=a(),i(G.$$.fragment),lt=a(),R=y("p"),R.textContent=js,at=a(),i(X.$$.fragment),nt=a(),i(N.$$.fragment),it=a(),Q=y("p"),Q.textContent=Cs,pt=a(),i(_.$$.fragment),mt=a(),B=y("p"),B.innerHTML=gs,rt=a(),F=y("ul"),F.innerHTML=Zs,ot=a(),z=y("p"),z.textContent=xs,Mt=a(),i(V.$$.fragment),yt=a(),i(v.$$.fragment),dt=a(),i(J.$$.fragment),ht=a(),i(Y.$$.fragment),ft=a(),E=y("p"),E.textContent=Is,ct=a(),i(S.$$.fragment),wt=a(),i(H.$$.fragment),bt=a(),i(U.$$.fragment),ut=a(),A=y("p"),A.textContent=Ws,Jt=a(),i(q.$$.fragment),Ut=a(),i(D.$$.fragment),Tt=a(),L=y("p"),L.textContent=ks,$t=a(),P=y("p"),P.textContent=Gs,jt=a(),i(K.$$.fragment),Ct=a(),O=y("p"),O.innerHTML=Rs,gt=a(),i(ee.$$.fragment),Zt=a(),te=y("p"),te.innerHTML=Xs,xt=a(),i(se.$$.fragment),It=a(),le=y("p"),le.textContent=Ns,Wt=a(),i(ae.$$.fragment),kt=a(),i(ne.$$.fragment),Gt=a(),i(ie.$$.fragment),Rt=a(),pe=y("p"),pe.textContent=Qs,Xt=a(),i(me.$$.fragment),Nt=a(),re=y("p"),re.textContent=_s,Qt=a(),i(oe.$$.fragment),_t=a(),Me=y("p"),Me.textContent=Bs,Bt=a(),i(ye.$$.fragment),Ft=a(),i(de.$$.fragment),zt=a(),he=y("p"),he.textContent=Fs,Vt=a(),i(fe.$$.fragment),vt=a(),i(ce.$$.fragment),Yt=a(),we=y("p"),we.innerHTML=zs,Et=a(),i(be.$$.fragment),St=a(),ue=y("p"),ue.innerHTML=Vs,Ht=a(),i(Je.$$.fragment),At=a(),Ue=y("p"),Ue.textContent=vs,qt=a(),i(Te.$$.fragment),Dt=a(),i($e.$$.fragment),Lt=a(),je=y("p"),je.textContent=Ys,Pt=a(),i(Ce.$$.fragment),Kt=a(),ge=y("p"),ge.textContent=Es,Ot=a(),i(Ze.$$.fragment),es=a(),i(xe.$$.fragment),ts=a(),Ie=y("p"),Ie.textContent=Ss,ss=a(),i(We.$$.fragment),ls=a(),i(ke.$$.fragment),as=a(),Ge=y("p"),Ge.innerHTML=Hs,ns=a(),Re=y("p"),Re.textContent=As,is=a(),i(Xe.$$.fragment),ps=a(),i(Ne.$$.fragment),ms=a(),Qe=y("p"),Qe.textContent=qs,rs=a(),i(_e.$$.fragment),os=a(),i(Be.$$.fragment),Ms=a(),Fe=y("p"),Fe.textContent=Ds,ys=a(),ze=y("p"),ze.textContent=Ls,ds=a(),i(Ve.$$.fragment),hs=a(),ve=y("p"),ve.innerHTML=Ps,fs=a(),i(Ye.$$.fragment),cs=a(),He=y("p"),this.h()},l(e){const t=ml("svelte-u9bgzb",document.head);c=d(t,"META",{name:!0,content:!0}),t.forEach(s),b=n(e),w=d(e,"P",{}),el(w).forEach(s),u=n(e),p(T.$$.fragment,e),Ae=n(e),p($.$$.fragment,e),qe=n(e),j=d(e,"P",{"data-svelte-h":!0}),h(j)!=="svelte-49m0ob"&&(j.innerHTML=bs),De=n(e),C=d(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1pgs32t"&&(C.textContent=us),Le=n(e),g=d(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-lmbomz"&&(g.textContent=Js),Pe=n(e),Z=d(e,"UL",{"data-svelte-h":!0}),h(Z)!=="svelte-1dtrqj6"&&(Z.innerHTML=Us),Ke=n(e),p(x.$$.fragment,e),Oe=n(e),I=d(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-12h4adn"&&(I.innerHTML=Ts),et=n(e),p(W.$$.fragment,e),tt=n(e),k=d(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-15vly9o"&&(k.textContent=$s),st=n(e),p(G.$$.fragment,e),lt=n(e),R=d(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-3ogv3u"&&(R.textContent=js),at=n(e),p(X.$$.fragment,e),nt=n(e),p(N.$$.fragment,e),it=n(e),Q=d(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1w6rynr"&&(Q.textContent=Cs),pt=n(e),p(_.$$.fragment,e),mt=n(e),B=d(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-adojsi"&&(B.innerHTML=gs),rt=n(e),F=d(e,"UL",{"data-svelte-h":!0}),h(F)!=="svelte-by6xjw"&&(F.innerHTML=Zs),ot=n(e),z=d(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1i04wu6"&&(z.textContent=xs),Mt=n(e),p(V.$$.fragment,e),yt=n(e),p(v.$$.fragment,e),dt=n(e),p(J.$$.fragment,e),ht=n(e),p(Y.$$.fragment,e),ft=n(e),E=d(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-cdjdl1"&&(E.textContent=Is),ct=n(e),p(S.$$.fragment,e),wt=n(e),p(H.$$.fragment,e),bt=n(e),p(U.$$.fragment,e),ut=n(e),A=d(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-15vjhv3"&&(A.textContent=Ws),Jt=n(e),p(q.$$.fragment,e),Ut=n(e),p(D.$$.fragment,e),Tt=n(e),L=d(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1nsze7a"&&(L.textContent=ks),$t=n(e),P=d(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1f237sj"&&(P.textContent=Gs),jt=n(e),p(K.$$.fragment,e),Ct=n(e),O=d(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1wsggxt"&&(O.innerHTML=Rs),gt=n(e),p(ee.$$.fragment,e),Zt=n(e),te=d(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-1659b5o"&&(te.innerHTML=Xs),xt=n(e),p(se.$$.fragment,e),It=n(e),le=d(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-1j39k4m"&&(le.textContent=Ns),Wt=n(e),p(ae.$$.fragment,e),kt=n(e),p(ne.$$.fragment,e),Gt=n(e),p(ie.$$.fragment,e),Rt=n(e),pe=d(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-qy8724"&&(pe.textContent=Qs),Xt=n(e),p(me.$$.fragment,e),Nt=n(e),re=d(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1f0jnhg"&&(re.textContent=_s),Qt=n(e),p(oe.$$.fragment,e),_t=n(e),Me=d(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-1cgr0vy"&&(Me.textContent=Bs),Bt=n(e),p(ye.$$.fragment,e),Ft=n(e),p(de.$$.fragment,e),zt=n(e),he=d(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-86x017"&&(he.textContent=Fs),Vt=n(e),p(fe.$$.fragment,e),vt=n(e),p(ce.$$.fragment,e),Yt=n(e),we=d(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-1n8twc4"&&(we.innerHTML=zs),Et=n(e),p(be.$$.fragment,e),St=n(e),ue=d(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-1ftqzjk"&&(ue.innerHTML=Vs),Ht=n(e),p(Je.$$.fragment,e),At=n(e),Ue=d(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-12zr7cu"&&(Ue.textContent=vs),qt=n(e),p(Te.$$.fragment,e),Dt=n(e),p($e.$$.fragment,e),Lt=n(e),je=d(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-17sxasd"&&(je.textContent=Ys),Pt=n(e),p(Ce.$$.fragment,e),Kt=n(e),ge=d(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-1flrffh"&&(ge.textContent=Es),Ot=n(e),p(Ze.$$.fragment,e),es=n(e),p(xe.$$.fragment,e),ts=n(e),Ie=d(e,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-1bycgqm"&&(Ie.textContent=Ss),ss=n(e),p(We.$$.fragment,e),ls=n(e),p(ke.$$.fragment,e),as=n(e),Ge=d(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-wg4hvq"&&(Ge.innerHTML=Hs),ns=n(e),Re=d(e,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-m7nb3g"&&(Re.textContent=As),is=n(e),p(Xe.$$.fragment,e),ps=n(e),p(Ne.$$.fragment,e),ms=n(e),Qe=d(e,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-1109ka9"&&(Qe.textContent=qs),rs=n(e),p(_e.$$.fragment,e),os=n(e),p(Be.$$.fragment,e),Ms=n(e),Fe=d(e,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-1356otx"&&(Fe.textContent=Ds),ys=n(e),ze=d(e,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-nj653h"&&(ze.textContent=Ls),ds=n(e),p(Ve.$$.fragment,e),hs=n(e),ve=d(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-14ep6rh"&&(ve.innerHTML=Ps),fs=n(e),p(Ye.$$.fragment,e),cs=n(e),He=d(e,"P",{}),el(He).forEach(s),this.h()},h(){tl(c,"name","hf:doc:metadata"),tl(c,"content",fl)},m(e,t){rl(document.head,c),l(e,b,t),l(e,w,t),l(e,u,t),m(T,e,t),l(e,Ae,t),m($,e,t),l(e,qe,t),l(e,j,t),l(e,De,t),l(e,C,t),l(e,Le,t),l(e,g,t),l(e,Pe,t),l(e,Z,t),l(e,Ke,t),m(x,e,t),l(e,Oe,t),l(e,I,t),l(e,et,t),m(W,e,t),l(e,tt,t),l(e,k,t),l(e,st,t),m(G,e,t),l(e,lt,t),l(e,R,t),l(e,at,t),m(X,e,t),l(e,nt,t),m(N,e,t),l(e,it,t),l(e,Q,t),l(e,pt,t),m(_,e,t),l(e,mt,t),l(e,B,t),l(e,rt,t),l(e,F,t),l(e,ot,t),l(e,z,t),l(e,Mt,t),m(V,e,t),l(e,yt,t),m(v,e,t),l(e,dt,t),m(J,e,t),l(e,ht,t),m(Y,e,t),l(e,ft,t),l(e,E,t),l(e,ct,t),m(S,e,t),l(e,wt,t),m(H,e,t),l(e,bt,t),m(U,e,t),l(e,ut,t),l(e,A,t),l(e,Jt,t),m(q,e,t),l(e,Ut,t),m(D,e,t),l(e,Tt,t),l(e,L,t),l(e,$t,t),l(e,P,t),l(e,jt,t),m(K,e,t),l(e,Ct,t),l(e,O,t),l(e,gt,t),m(ee,e,t),l(e,Zt,t),l(e,te,t),l(e,xt,t),m(se,e,t),l(e,It,t),l(e,le,t),l(e,Wt,t),m(ae,e,t),l(e,kt,t),m(ne,e,t),l(e,Gt,t),m(ie,e,t),l(e,Rt,t),l(e,pe,t),l(e,Xt,t),m(me,e,t),l(e,Nt,t),l(e,re,t),l(e,Qt,t),m(oe,e,t),l(e,_t,t),l(e,Me,t),l(e,Bt,t),m(ye,e,t),l(e,Ft,t),m(de,e,t),l(e,zt,t),l(e,he,t),l(e,Vt,t),m(fe,e,t),l(e,vt,t),m(ce,e,t),l(e,Yt,t),l(e,we,t),l(e,Et,t),m(be,e,t),l(e,St,t),l(e,ue,t),l(e,Ht,t),m(Je,e,t),l(e,At,t),l(e,Ue,t),l(e,qt,t),m(Te,e,t),l(e,Dt,t),m($e,e,t),l(e,Lt,t),l(e,je,t),l(e,Pt,t),m(Ce,e,t),l(e,Kt,t),l(e,ge,t),l(e,Ot,t),m(Ze,e,t),l(e,es,t),m(xe,e,t),l(e,ts,t),l(e,Ie,t),l(e,ss,t),m(We,e,t),l(e,ls,t),m(ke,e,t),l(e,as,t),l(e,Ge,t),l(e,ns,t),l(e,Re,t),l(e,is,t),m(Xe,e,t),l(e,ps,t),m(Ne,e,t),l(e,ms,t),l(e,Qe,t),l(e,rs,t),m(_e,e,t),l(e,os,t),m(Be,e,t),l(e,Ms,t),l(e,Fe,t),l(e,ys,t),l(e,ze,t),l(e,ds,t),m(Ve,e,t),l(e,hs,t),l(e,ve,t),l(e,fs,t),m(Ye,e,t),l(e,cs,t),l(e,He,t),ws=!0},p(e,[t]){const Ks={};t&2&&(Ks.$$scope={dirty:t,ctx:e}),J.$set(Ks);const Os={};t&2&&(Os.$$scope={dirty:t,ctx:e}),U.$set(Os)},i(e){ws||(r(T.$$.fragment,e),r($.$$.fragment,e),r(x.$$.fragment,e),r(W.$$.fragment,e),r(G.$$.fragment,e),r(X.$$.fragment,e),r(N.$$.fragment,e),r(_.$$.fragment,e),r(V.$$.fragment,e),r(v.$$.fragment,e),r(J.$$.fragment,e),r(Y.$$.fragment,e),r(S.$$.fragment,e),r(H.$$.fragment,e),r(U.$$.fragment,e),r(q.$$.fragment,e),r(D.$$.fragment,e),r(K.$$.fragment,e),r(ee.$$.fragment,e),r(se.$$.fragment,e),r(ae.$$.fragment,e),r(ne.$$.fragment,e),r(ie.$$.fragment,e),r(me.$$.fragment,e),r(oe.$$.fragment,e),r(ye.$$.fragment,e),r(de.$$.fragment,e),r(fe.$$.fragment,e),r(ce.$$.fragment,e),r(be.$$.fragment,e),r(Je.$$.fragment,e),r(Te.$$.fragment,e),r($e.$$.fragment,e),r(Ce.$$.fragment,e),r(Ze.$$.fragment,e),r(xe.$$.fragment,e),r(We.$$.fragment,e),r(ke.$$.fragment,e),r(Xe.$$.fragment,e),r(Ne.$$.fragment,e),r(_e.$$.fragment,e),r(Be.$$.fragment,e),r(Ve.$$.fragment,e),r(Ye.$$.fragment,e),ws=!0)},o(e){o(T.$$.fragment,e),o($.$$.fragment,e),o(x.$$.fragment,e),o(W.$$.fragment,e),o(G.$$.fragment,e),o(X.$$.fragment,e),o(N.$$.fragment,e),o(_.$$.fragment,e),o(V.$$.fragment,e),o(v.$$.fragment,e),o(J.$$.fragment,e),o(Y.$$.fragment,e),o(S.$$.fragment,e),o(H.$$.fragment,e),o(U.$$.fragment,e),o(q.$$.fragment,e),o(D.$$.fragment,e),o(K.$$.fragment,e),o(ee.$$.fragment,e),o(se.$$.fragment,e),o(ae.$$.fragment,e),o(ne.$$.fragment,e),o(ie.$$.fragment,e),o(me.$$.fragment,e),o(oe.$$.fragment,e),o(ye.$$.fragment,e),o(de.$$.fragment,e),o(fe.$$.fragment,e),o(ce.$$.fragment,e),o(be.$$.fragment,e),o(Je.$$.fragment,e),o(Te.$$.fragment,e),o($e.$$.fragment,e),o(Ce.$$.fragment,e),o(Ze.$$.fragment,e),o(xe.$$.fragment,e),o(We.$$.fragment,e),o(ke.$$.fragment,e),o(Xe.$$.fragment,e),o(Ne.$$.fragment,e),o(_e.$$.fragment,e),o(Be.$$.fragment,e),o(Ve.$$.fragment,e),o(Ye.$$.fragment,e),ws=!1},d(e){e&&(s(b),s(w),s(u),s(Ae),s(qe),s(j),s(De),s(C),s(Le),s(g),s(Pe),s(Z),s(Ke),s(Oe),s(I),s(et),s(tt),s(k),s(st),s(lt),s(R),s(at),s(nt),s(it),s(Q),s(pt),s(mt),s(B),s(rt),s(F),s(ot),s(z),s(Mt),s(yt),s(dt),s(ht),s(ft),s(E),s(ct),s(wt),s(bt),s(ut),s(A),s(Jt),s(Ut),s(Tt),s(L),s($t),s(P),s(jt),s(Ct),s(O),s(gt),s(Zt),s(te),s(xt),s(It),s(le),s(Wt),s(kt),s(Gt),s(Rt),s(pe),s(Xt),s(Nt),s(re),s(Qt),s(_t),s(Me),s(Bt),s(Ft),s(zt),s(he),s(Vt),s(vt),s(Yt),s(we),s(Et),s(St),s(ue),s(Ht),s(At),s(Ue),s(qt),s(Dt),s(Lt),s(je),s(Pt),s(Kt),s(ge),s(Ot),s(es),s(ts),s(Ie),s(ss),s(ls),s(as),s(Ge),s(ns),s(Re),s(is),s(ps),s(ms),s(Qe),s(rs),s(os),s(Ms),s(Fe),s(ys),s(ze),s(ds),s(hs),s(ve),s(fs),s(cs),s(He)),s(c),M(T,e),M($,e),M(x,e),M(W,e),M(G,e),M(X,e),M(N,e),M(_,e),M(V,e),M(v,e),M(J,e),M(Y,e),M(S,e),M(H,e),M(U,e),M(q,e),M(D,e),M(K,e),M(ee,e),M(se,e),M(ae,e),M(ne,e),M(ie,e),M(me,e),M(oe,e),M(ye,e),M(de,e),M(fe,e),M(ce,e),M(be,e),M(Je,e),M(Te,e),M($e,e),M(Ce,e),M(Ze,e),M(xe,e),M(We,e),M(ke,e),M(Xe,e),M(Ne,e),M(_e,e),M(Be,e),M(Ve,e),M(Ye,e)}}}const fl='{"title":"Zero-shot Text Classification","local":"zero-shot-text-classification","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Creating a synthetic dataset","local":"creating-a-synthetic-dataset","sections":[],"depth":2},{"title":"Fine-tuning the model","local":"fine-tuning-the-model","sections":[],"depth":2},{"title":"Comparing against the zero-shot pipeline from 🤗 Transformers","local":"comparing-against-the-zero-shot-pipeline-from--transformers","sections":[],"depth":2},{"title":"Augmenting labeled data with synthetic examples","local":"augmenting-labeled-data-with-synthetic-examples","sections":[],"depth":2}],"depth":1}';function cl(Ee){return nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $l extends il{constructor(c){super(),pl(this,c,cl,hl,al,{})}}export{$l as component};
