import{s as gt,n as ft,o as vt}from"../chunks/scheduler.f6b352c8.js";import{S as wt,i as bt,g as s,s as n,r as p,A as Tt,h as a,f as l,c as o,j as ct,u,x as r,k as dt,y as ht,a as i,v as m,d as c,t as d,w as g}from"../chunks/index.b90df637.js";import{C as ze}from"../chunks/CodeBlock.e5718f9d.js";import{H as v,E as Mt}from"../chunks/getInferenceSnippets.6d5d08a4.js";function yt(Ne){let f,K,F,ee,w,te,b,Xe="<strong>LIBERO</strong> is a benchmark designed to study <strong>lifelong robot learning</strong>. The idea is that robots won’t just be pretrained once in a factory, they’ll need to keep learning and adapting with their human users over time. This ongoing adaptation is called <strong>lifelong learning in decision making (LLDM)</strong>, and it’s a key step toward building robots that become truly personalized helpers.",le,T,Ze="To make progress on this challenge, LIBERO provides a set of standardized tasks that focus on <strong>knowledge transfer</strong>: how well a robot can apply what it has already learned to new situations. By evaluating on LIBERO, different algorithms can be compared fairly and researchers can build on each other’s work.",ie,h,Pe="LIBERO includes <strong>five task suites</strong>:",ne,M,Ye="<li><strong>LIBERO-Spatial (<code>libero_spatial</code>)</strong> – tasks that require reasoning about spatial relations.</li> <li><strong>LIBERO-Object (<code>libero_object</code>)</strong> – tasks centered on manipulating different objects.</li> <li><strong>LIBERO-Goal (<code>libero_goal</code>)</strong> – goal-conditioned tasks where the robot must adapt to changing targets.</li> <li><strong>LIBERO-90 (<code>libero_90</code>)</strong> – 90 short-horizon tasks from the LIBERO-100 collection.</li> <li><strong>LIBERO-Long (<code>libero_10</code>)</strong> – 10 long-horizon tasks from the LIBERO-100 collection.</li>",oe,y,Ae="Together, these suites cover <strong>130 tasks</strong>, ranging from simple object manipulations to complex multi-step scenarios. LIBERO is meant to grow over time, and to serve as a shared benchmark where the community can test and improve lifelong learning algorithms.",se,L,Qe='<img src="https://libero-project.github.io/assets/img/libero/fig1.png" alt="Libero Figure"/>',ae,$,re,J,De='At <strong>LeRobot</strong>, we ported <a href="https://github.com/Lifelong-Robot-Learning/LIBERO" rel="nofollow">LIBERO</a> into our framework and used it mainly to <strong>evaluate <a href="https://huggingface.co/docs/lerobot/en/smolvla" rel="nofollow">SmolVLA</a></strong>, our lightweight Vision-Language-Action model.',pe,C,Fe="LIBERO is now part of our <strong>multi-eval supported simulation</strong>, meaning you can benchmark your policies either on a <strong>single suite of tasks</strong> or across <strong>multiple suites at once</strong> with just a flag.",ue,_,qe=`To Install LIBERO, after following LeRobot official instructions, just do:
<code>pip install -e &quot;.[libero]&quot;</code>`,me,U,ce,I,Ke="Evaluate a policy on one LIBERO suite:",de,R,ge,x,et="<li><code>--env.task</code> picks the suite (<code>libero_object</code>, <code>libero_spatial</code>, etc.).</li> <li><code>--eval.batch_size</code> controls how many environments run in parallel.</li> <li><code>--eval.n_episodes</code> sets how many episodes to run in total.</li>",fe,ve,we,k,be,B,tt="Benchmark a policy across multiple suites at once:",Te,E,he,H,lt="<li>Pass a comma-separated list to <code>--env.task</code> for multi-suite evaluation.</li> <li>Set <code>-env.multitask_eval=True</code> to enable evaluation across all tasks in those suites.</li>",Me,j,ye,V,it="When using LIBERO through LeRobot, policies interact with the environment via <strong>observations</strong> and <strong>actions</strong>:",Le,G,nt="<li><p><strong>Observations</strong></p> <ul><li><code>observation.state</code> – proprioceptive features (agent state).</li> <li><code>observation.images.image</code> – main camera view (<code>agentview_image</code>).</li> <li><code>observation.images.image2</code> – wrist camera view (<code>robot0_eye_in_hand_image</code>).</li></ul> <p>⚠️ <strong>Note:</strong> LeRobot enforces the <code>.images.*</code> prefix for any visual features. Make sure your dataset metadata keys match this convention when evaluating.</p></li> <li><p><strong>Actions</strong></p> <ul><li>Continuous control values in a <code>Box(-1, 1, shape=(7,))</code> space.</li></ul></li>",$e,S,ot=`We also provide a notebook for quick testing:
Training with LIBERO`,Je,W,Ce,O,st="When training on LIBERO tasks, make sure your dataset parquet and metadata keys follow the LeRobot convention.",_e,z,at="The environment expects:",Ue,N,rt="<li><code>observation.state</code> → 8-dim agent state</li> <li><code>observation.images.image</code> → main camera (<code>agentview_image</code>)</li> <li><code>observation.images.image2</code> → wrist camera (<code>robot0_eye_in_hand_image</code>)</li>",Ie,X,pt="⚠️ Cleaning the dataset upfront is <strong>cleaner and more efficient</strong> than remapping keys inside the code. We plan to provide a script to easily preprocess such data.",Re,xe,ke,Z,Be,P,Ee,He,je,Y,Ve,A,ut="LeRobot uses MuJoCo for simulation. You need to set the rendering backend before training or evaluation:",Ge,Q,mt="<li><code>export MUJOCO_GL=egl</code> → for headless servers (e.g. HPC, cloud)</li> <li><code>export MUJOCO_GL=glfw</code> → for local runs with a display</li>",Se,D,We,q,Oe;return w=new v({props:{title:"LIBERO",local:"libero",headingTag:"h1"}}),$=new v({props:{title:"Evaluating with LIBERO",local:"evaluating-with-libero",headingTag:"h2"}}),U=new v({props:{title:"Single-suite evaluation",local:"single-suite-evaluation",headingTag:"h3"}}),R=new ze({props:{code:"cHl0aG9uJTIwc3JjJTJGbGVyb2JvdCUyRnNjcmlwdHMlMkZldmFsLnB5JTIwJTVDJTBBJTIwJTIwLS1wb2xpY3kucGF0aCUzRCUyMnlvdXItcG9saWN5LWlkJTIyJTIwJTVDJTBBJTIwJTIwLS1lbnYudHlwZSUzRGxpYmVybyUyMCU1QyUwQSUyMCUyMC0tZW52LnRhc2slM0RsaWJlcm9fb2JqZWN0JTIwJTVDJTBBJTIwJTIwLS1lbnYubXVsdGl0YXNrX2V2YWwlM0RGYWxzZSUyMCU1QyUwQSUyMCUyMC0tZXZhbC5iYXRjaF9zaXplJTNEMiUyMCU1QyUwQSUyMCUyMC0tZXZhbC5uX2VwaXNvZGVzJTNEMw==",highlighted:`python src/lerobot/scripts/eval.py \\
  --policy.path=<span class="hljs-string">&quot;your-policy-id&quot;</span> \\
  --env.type=libero \\
  --env.task=libero_object \\
  --env.multitask_eval=False \\
  --eval.batch_size=2 \\
  --eval.n_episodes=3`,wrap:!1}}),k=new v({props:{title:"Multi-suite evaluation",local:"multi-suite-evaluation",headingTag:"h3"}}),E=new ze({props:{code:"cHl0aG9uJTIwc3JjJTJGbGVyb2JvdCUyRnNjcmlwdHMlMkZldmFsLnB5JTIwJTVDJTBBJTIwJTIwLS1wb2xpY3kucGF0aCUzRCUyMnlvdXItcG9saWN5LWlkJTIyJTIwJTVDJTBBJTIwJTIwLS1lbnYudHlwZSUzRGxpYmVybyUyMCU1QyUwQSUyMCUyMC0tZW52LnRhc2slM0RsaWJlcm9fb2JqZWN0JTJDbGliZXJvX3NwYXRpYWwlMjAlNUMlMEElMjAlMjAtLWVudi5tdWx0aXRhc2tfZXZhbCUzRFRydWUlMjAlNUMlMEElMjAlMjAtLWV2YWwuYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAlMjAtLWV2YWwubl9lcGlzb2RlcyUzRDI=",highlighted:`python src/lerobot/scripts/eval.py \\
  --policy.path=<span class="hljs-string">&quot;your-policy-id&quot;</span> \\
  --env.type=libero \\
  --env.task=libero_object,libero_spatial \\
  --env.multitask_eval=True \\
  --eval.batch_size=1 \\
  --eval.n_episodes=2`,wrap:!1}}),j=new v({props:{title:"Policy inputs and outputs",local:"policy-inputs-and-outputs",headingTag:"h3"}}),W=new v({props:{title:"Training with LIBERO",local:"training-with-libero",headingTag:"h2"}}),Z=new v({props:{title:"Example training command",local:"example-training-command",headingTag:"h3"}}),P=new ze({props:{code:"cHl0aG9uJTIwc3JjJTJGbGVyb2JvdCUyRnNjcmlwdHMlMkZ0cmFpbi5weSUyMCU1QyUwQSUyMCUyMC0tcG9saWN5LnR5cGUlM0RzbW9sdmxhJTIwJTVDJTBBJTIwJTIwLS1wb2xpY3kucmVwb19pZCUzRCUyNCU3QkhGX1VTRVIlN0QlMkZsaWJlcm8tdGVzdCUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldC5yZXBvX2lkJTNEamFkZWNob2doYXJpJTJGc21vbC1saWJlcm8zJTIwJTVDJTBBJTIwJTIwLS1lbnYudHlwZSUzRGxpYmVybyUyMCU1QyUwQSUyMCUyMC0tZW52LnRhc2slM0RsaWJlcm9fMTAlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QuJTJGb3V0cHV0cyUyRiUyMCU1QyUwQSUyMCUyMC0tc3RlcHMlM0QxMDAwMDAlMjAlNUMlMEElMjAlMjAtLWJhdGNoX3NpemUlM0Q0JTIwJTVDJTBBJTIwJTIwLS1lbnYubXVsdGl0YXNrX2V2YWwlM0RUcnVlJTIwJTVDJTBBJTIwJTIwLS1ldmFsLmJhdGNoX3NpemUlM0QxJTIwJTVDJTBBJTIwJTIwLS1ldmFsLm5fZXBpc29kZXMlM0QxJTIwJTVDJTBBJTIwJTIwLS1ldmFsX2ZyZXElM0QxMDAwJTIwJTVD",highlighted:`python src/lerobot/scripts/train.py \\
  --policy.type=smolvla \\
  --policy.repo_id=<span class="hljs-variable">\${HF_USER}</span>/libero-test \\
  --dataset.repo_id=jadechoghari/smol-libero3 \\
  --env.type=libero \\
  --env.task=libero_10 \\
  --output_dir=./outputs/ \\
  --steps=100000 \\
  --batch_size=4 \\
  --env.multitask_eval=True \\
  --eval.batch_size=1 \\
  --eval.n_episodes=1 \\
  --eval_freq=1000 \\`,wrap:!1}}),Y=new v({props:{title:"Note on rendering",local:"note-on-rendering",headingTag:"h3"}}),D=new Mt({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/libero.mdx"}}),{c(){f=s("meta"),K=n(),F=s("p"),ee=n(),p(w.$$.fragment),te=n(),b=s("p"),b.innerHTML=Xe,le=n(),T=s("p"),T.innerHTML=Ze,ie=n(),h=s("p"),h.innerHTML=Pe,ne=n(),M=s("ul"),M.innerHTML=Ye,oe=n(),y=s("p"),y.innerHTML=Ae,se=n(),L=s("p"),L.innerHTML=Qe,ae=n(),p($.$$.fragment),re=n(),J=s("p"),J.innerHTML=De,pe=n(),C=s("p"),C.innerHTML=Fe,ue=n(),_=s("p"),_.innerHTML=qe,me=n(),p(U.$$.fragment),ce=n(),I=s("p"),I.textContent=Ke,de=n(),p(R.$$.fragment),ge=n(),x=s("ul"),x.innerHTML=et,fe=n(),ve=s("hr"),we=n(),p(k.$$.fragment),be=n(),B=s("p"),B.textContent=tt,Te=n(),p(E.$$.fragment),he=n(),H=s("ul"),H.innerHTML=lt,Me=n(),p(j.$$.fragment),ye=n(),V=s("p"),V.innerHTML=it,Le=n(),G=s("ul"),G.innerHTML=nt,$e=n(),S=s("p"),S.textContent=ot,Je=n(),p(W.$$.fragment),Ce=n(),O=s("p"),O.textContent=st,_e=n(),z=s("p"),z.textContent=at,Ue=n(),N=s("ul"),N.innerHTML=rt,Ie=n(),X=s("p"),X.innerHTML=pt,Re=n(),xe=s("hr"),ke=n(),p(Z.$$.fragment),Be=n(),p(P.$$.fragment),Ee=n(),He=s("hr"),je=n(),p(Y.$$.fragment),Ve=n(),A=s("p"),A.textContent=ut,Ge=n(),Q=s("ul"),Q.innerHTML=mt,Se=n(),p(D.$$.fragment),We=n(),q=s("p"),this.h()},l(e){const t=Tt("svelte-u9bgzb",document.head);f=a(t,"META",{name:!0,content:!0}),t.forEach(l),K=o(e),F=a(e,"P",{}),ct(F).forEach(l),ee=o(e),u(w.$$.fragment,e),te=o(e),b=a(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-fyznsg"&&(b.innerHTML=Xe),le=o(e),T=a(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-23n11j"&&(T.innerHTML=Ze),ie=o(e),h=a(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-fl0oer"&&(h.innerHTML=Pe),ne=o(e),M=a(e,"UL",{"data-svelte-h":!0}),r(M)!=="svelte-iw3z34"&&(M.innerHTML=Ye),oe=o(e),y=a(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-11r5n4m"&&(y.innerHTML=Ae),se=o(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-16t927x"&&(L.innerHTML=Qe),ae=o(e),u($.$$.fragment,e),re=o(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1uljv9f"&&(J.innerHTML=De),pe=o(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1nzglkh"&&(C.innerHTML=Fe),ue=o(e),_=a(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-pkg7xa"&&(_.innerHTML=qe),me=o(e),u(U.$$.fragment,e),ce=o(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1o5bftu"&&(I.textContent=Ke),de=o(e),u(R.$$.fragment,e),ge=o(e),x=a(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-4js1or"&&(x.innerHTML=et),fe=o(e),ve=a(e,"HR",{}),we=o(e),u(k.$$.fragment,e),be=o(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-12stn56"&&(B.textContent=tt),Te=o(e),u(E.$$.fragment,e),he=o(e),H=a(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-9et7sg"&&(H.innerHTML=lt),Me=o(e),u(j.$$.fragment,e),ye=o(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-h6xa1e"&&(V.innerHTML=it),Le=o(e),G=a(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-tc6hc0"&&(G.innerHTML=nt),$e=o(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-16no5in"&&(S.textContent=ot),Je=o(e),u(W.$$.fragment,e),Ce=o(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-s7z94m"&&(O.textContent=st),_e=o(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-12dqi7e"&&(z.textContent=at),Ue=o(e),N=a(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-xymmhg"&&(N.innerHTML=rt),Ie=o(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1i6lu5z"&&(X.innerHTML=pt),Re=o(e),xe=a(e,"HR",{}),ke=o(e),u(Z.$$.fragment,e),Be=o(e),u(P.$$.fragment,e),Ee=o(e),He=a(e,"HR",{}),je=o(e),u(Y.$$.fragment,e),Ve=o(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1g2lw2j"&&(A.textContent=ut),Ge=o(e),Q=a(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-78fh3e"&&(Q.innerHTML=mt),Se=o(e),u(D.$$.fragment,e),We=o(e),q=a(e,"P",{}),ct(q).forEach(l),this.h()},h(){dt(f,"name","hf:doc:metadata"),dt(f,"content",Lt)},m(e,t){ht(document.head,f),i(e,K,t),i(e,F,t),i(e,ee,t),m(w,e,t),i(e,te,t),i(e,b,t),i(e,le,t),i(e,T,t),i(e,ie,t),i(e,h,t),i(e,ne,t),i(e,M,t),i(e,oe,t),i(e,y,t),i(e,se,t),i(e,L,t),i(e,ae,t),m($,e,t),i(e,re,t),i(e,J,t),i(e,pe,t),i(e,C,t),i(e,ue,t),i(e,_,t),i(e,me,t),m(U,e,t),i(e,ce,t),i(e,I,t),i(e,de,t),m(R,e,t),i(e,ge,t),i(e,x,t),i(e,fe,t),i(e,ve,t),i(e,we,t),m(k,e,t),i(e,be,t),i(e,B,t),i(e,Te,t),m(E,e,t),i(e,he,t),i(e,H,t),i(e,Me,t),m(j,e,t),i(e,ye,t),i(e,V,t),i(e,Le,t),i(e,G,t),i(e,$e,t),i(e,S,t),i(e,Je,t),m(W,e,t),i(e,Ce,t),i(e,O,t),i(e,_e,t),i(e,z,t),i(e,Ue,t),i(e,N,t),i(e,Ie,t),i(e,X,t),i(e,Re,t),i(e,xe,t),i(e,ke,t),m(Z,e,t),i(e,Be,t),m(P,e,t),i(e,Ee,t),i(e,He,t),i(e,je,t),m(Y,e,t),i(e,Ve,t),i(e,A,t),i(e,Ge,t),i(e,Q,t),i(e,Se,t),m(D,e,t),i(e,We,t),i(e,q,t),Oe=!0},p:ft,i(e){Oe||(c(w.$$.fragment,e),c($.$$.fragment,e),c(U.$$.fragment,e),c(R.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(j.$$.fragment,e),c(W.$$.fragment,e),c(Z.$$.fragment,e),c(P.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),Oe=!0)},o(e){d(w.$$.fragment,e),d($.$$.fragment,e),d(U.$$.fragment,e),d(R.$$.fragment,e),d(k.$$.fragment,e),d(E.$$.fragment,e),d(j.$$.fragment,e),d(W.$$.fragment,e),d(Z.$$.fragment,e),d(P.$$.fragment,e),d(Y.$$.fragment,e),d(D.$$.fragment,e),Oe=!1},d(e){e&&(l(K),l(F),l(ee),l(te),l(b),l(le),l(T),l(ie),l(h),l(ne),l(M),l(oe),l(y),l(se),l(L),l(ae),l(re),l(J),l(pe),l(C),l(ue),l(_),l(me),l(ce),l(I),l(de),l(ge),l(x),l(fe),l(ve),l(we),l(be),l(B),l(Te),l(he),l(H),l(Me),l(ye),l(V),l(Le),l(G),l($e),l(S),l(Je),l(Ce),l(O),l(_e),l(z),l(Ue),l(N),l(Ie),l(X),l(Re),l(xe),l(ke),l(Be),l(Ee),l(He),l(je),l(Ve),l(A),l(Ge),l(Q),l(Se),l(We),l(q)),l(f),g(w,e),g($,e),g(U,e),g(R,e),g(k,e),g(E,e),g(j,e),g(W,e),g(Z,e),g(P,e),g(Y,e),g(D,e)}}}const Lt='{"title":"LIBERO","local":"libero","sections":[{"title":"Evaluating with LIBERO","local":"evaluating-with-libero","sections":[{"title":"Single-suite evaluation","local":"single-suite-evaluation","sections":[],"depth":3},{"title":"Multi-suite evaluation","local":"multi-suite-evaluation","sections":[],"depth":3},{"title":"Policy inputs and outputs","local":"policy-inputs-and-outputs","sections":[],"depth":3}],"depth":2},{"title":"Training with LIBERO","local":"training-with-libero","sections":[{"title":"Example training command","local":"example-training-command","sections":[],"depth":3},{"title":"Note on rendering","local":"note-on-rendering","sections":[],"depth":3}],"depth":2}],"depth":1}';function $t(Ne){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends wt{constructor(f){super(),bt(this,f,$t,yt,gt,{})}}export{It as component};
