import{s as _l,n as xl,o as $l}from"../chunks/scheduler.85c25b89.js";import{S as yl,i as wl,g as a,s as o,r as d,A as Cl,h as r,f as i,c as n,j as s,u as c,x as m,k as v,y as t,a as p,v as g,d as u,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.5c1d567f.js";import{H as U,E as Al}from"../chunks/EditOnGithub.b65eee75.js";function Ll(Li){let Z,yr,ir,wr,ve,Cr,be,Ti="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",Ar,_e,Lr,xe,Tr,_,$e,To,zt,zi="Create an optimizer instance via timm registry.",zo,Dt,Di=`Creates and configures an optimizer with appropriate parameter groups and settings.
Supports automatic parameter group creation for weight decay and layer-wise learning
rates, as well as custom parameter grouping.`,Do,qt,qi="Examples:",qo,mr,lr,ye,we,Po,Pt,Pi="optimizer = create_optimizer_v2(model, ‘adamw’, lr=1e-3)",Mo,sr,pr,Ce,Ae,ko,Mt,Mi=`optimizer = create_optimizer_v2(
…     model, ‘sgd’, lr=0.1, momentum=0.9, weight_decay=1e-4
… )`,Eo,dr,cr,Le,Te,No,kt,ki=`optimizer = create_optimizer_v2(
…     model, ‘adam’, lr=1e-3, layer_decay=0.7
… )`,Oo,gr,ur,ze,De,Io,Et,Ei=`def group_fn(model):
…     return [
…         {‘params’: model.backbone.parameters(), ‘lr’: 1e-4},
…         {‘params’: model.head.parameters(), ‘lr’: 1e-3}
…     ]
optimizer = create_optimizer_v2(
…     model, ‘sgd’, param_group_fn=group_fn
… )`,Fo,Nt,Ni=`Note:
Parameter group handling precedence:`,Ho,Ot,Oi="<li>If param_group_fn is provided, it will be used exclusively</li> <li>If layer_decay is provided, layer-wise groups will be created</li> <li>If weight_decay &gt; 0 and filter_bias_and_bn is True, weight decay groups will be created</li> <li>Otherwise, all parameters will be in a single group</li>",zr,x,qe,Bo,It,Ii="List available optimizer names, optionally filtered.",Ro,Ft,Fi=`List all registered optimizers, with optional filtering using wildcard patterns.
Optimizers can be filtered using include and exclude patterns, and can optionally
return descriptions with each optimizer name.`,Go,Ht,Hi="Examples:",So,Bt,Bi=`<blockquote><blockquote><p>list_optimizers()
[‘adam’, ‘adamw’, ‘sgd’, …]</p></blockquote></blockquote>`,Vo,Rt,Ri=`<blockquote><blockquote><p>list_optimizers([‘la<em>’, ‘nla</em>’])  # List lamb &amp; lars
[‘lamb’, ‘lambc’, ‘larc’, ‘lars’, ‘nlarc’, ‘nlars’]</p></blockquote></blockquote>`,Wo,Gt,Gi=`<blockquote><blockquote><p>list_optimizers(’<em>adam</em>’, exclude_filters=[‘bnb<em>’, ‘fused</em>’])  # Exclude bnb &amp; apex adam optimizers
[‘adam’, ‘adamax’, ‘adamp’, ‘adamw’, ‘nadam’, ‘nadamw’, ‘radam’]</p></blockquote></blockquote>`,Uo,St,Si=`<blockquote><blockquote><p>list_optimizers(with_description=True)  # Get descriptions
[(‘adabelief’, ‘Adapts learning rate based on gradient prediction error’),
(‘adadelta’, ‘torch.optim Adadelta, Adapts learning rates based on running windows of gradients’),
(‘adafactor’, ‘Memory-efficient implementation of Adam with factored gradients’),
…]</p></blockquote></blockquote>`,Dr,w,Pe,Qo,Vt,Vi="Get optimizer class by name with option to bind default arguments.",Ko,Wt,Wi=`Retrieves the optimizer class or a partial function with default arguments bound.
This allows direct instantiation of optimizers with their default configurations
without going through the full factory.`,jo,Ut,Ui="Examples:",Zo,fr,hr,Me,ke,Xo,Qt,Qi=`Adam = get_optimizer_class(‘adam’)
opt = Adam(model.parameters(), lr=1e-3)`,Jo,vr,br,Ee,Ne,Yo,Kt,Ki=`AdamWithDefaults = get_optimizer_class(‘adam’, bind_defaults=True)
opt = AdamWithDefaults(model.parameters(), lr=1e-3)`,en,_r,xr,Oe,Ie,tn,jt,ji=`SGD = get_optimizer_class(‘sgd’, bind_defaults=True)  # nesterov=True bound
opt = SGD(model.parameters(), lr=0.1, momentum=0.9)`,qr,Fe,Pr,A,He,an,Zt,Zi="Implements AdaBelief algorithm. Modified from Adam in PyTorch",rn,Xt,Xi="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",on,Jt,Ji=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,nn,Yt,Yi='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',mn,J,Be,ln,ea,em="Performs a single optimization step.",Mr,L,Re,sn,ta,tm="Implements Adafactor algorithm.",pn,aa,am=`This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,dn,ra,rm=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,cn,oa,om=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,gn,Y,Ge,un,na,nm="Performs a single optimization step.",kr,R,Se,fn,ia,im="PyTorch implementation of BigVision’s Adafactor variant with both single and multi tensor implementations.",hn,ma,mm='Adapted from <a href="https://github.com/google-research/big_vision" rel="nofollow">https://github.com/google-research/big_vision</a> by Ross Wightman',Er,T,Ve,vn,la,lm="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",bn,ee,We,_n,sa,sm="Gets all parameters in all param_groups with gradients",xn,te,Ue,$n,pa,pm="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",yn,ae,Qe,wn,da,dm="Performs a single optimization step.",Cn,re,Ke,An,ca,cm="Zeros out the accumalated hessian traces.",Nr,je,Ze,Or,P,Xe,Ln,ga,gm="Implements AdamW algorithm.",Tn,ua,um=`The original Adam algorithm was proposed in <code>Adam: A Method for Stochastic Optimization</code><em>.
The AdamW variant was proposed in <code>Decoupled Weight Decay Regularization</code></em>.`,zn,fa,fm=`.. _Adam\\: A Method for Stochastic Optimization:
<a href="https://arxiv.org/abs/1412.6980" rel="nofollow">https://arxiv.org/abs/1412.6980</a>
.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,Dn,oe,Je,qn,ha,hm="Performs a single optimization step.",Ir,G,Ye,Pn,va,vm=`Implements a pytorch variant of Adan
Adan was proposed in
Adan: Adaptive Nesterov Momentum Algorithm for Faster Optimizing Deep Models[J]. arXiv preprint arXiv:2208.06677, 2022.
<a href="https://arxiv.org/abs/2208.06677" rel="nofollow">https://arxiv.org/abs/2208.06677</a>`,Mn,ne,et,kn,ba,bm="Performs a single optimization step.",Fr,S,tt,En,_a,_m='ADOPT: Modified Adam Can Converge with Any β2 with the Optimal Rate: <a href="https://arxiv.org/abs/2411.02853" rel="nofollow">https://arxiv.org/abs/2411.02853</a>',Nn,ie,at,On,xa,xm="Perform a single optimization step.",Hr,M,rt,In,$a,$m=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,Fn,ya,ym="LAMB was proposed in <code>Large Batch Optimization for Deep Learning: Training BERT in 76 minutes</code>_.",Hn,wa,wm=`.. _Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:
<a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,Bn,me,ot,Rn,Ca,Cm="Performs a single optimization step.",Br,O,nt,Gn,Aa,Am="LARS for PyTorch",Sn,La,Lm='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',Vn,le,it,Wn,Ta,Tm="Performs a single optimization step.",Rr,V,mt,Un,za,zm="Implements Lion algorithm.",Qn,se,lt,Kn,Da,Dm="Performs a single optimization step.",Gr,st,pt,Sr,C,dt,jn,qa,qm=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,Zn,Pa,Pm='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Xn,Ma,Mm=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,Jn,ka,km=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Yn,Ea,Em="On sparse problems both weight_decay and momentum should be set to 0.",ei,pe,ct,ti,Na,Nm="Performs a single optimization step.",Vr,z,gt,ai,Oa,Om="Implements Nadam algorithm (a variant of Adam based on Nesterov momentum).",ri,Ia,Im="It has been proposed in <code>Incorporating Nesterov Momentum into Adam</code>__.",oi,Fa,Fm='<strong><a href="http://cs229.stanford.edu/proj2015/054_report.pdf" rel="nofollow">http://cs229.stanford.edu/proj2015/054_report.pdf</a></strong> <a href="http://www.cs.toronto.edu/~fritz/absps/momentum.pdf" rel="nofollow">http://www.cs.toronto.edu/~fritz/absps/momentum.pdf</a>',ni,Ha,Hm=`Originally taken from: <a href="https://github.com/pytorch/pytorch/pull/1408" rel="nofollow">https://github.com/pytorch/pytorch/pull/1408</a>
NOTE: Has potential issues but does work well on some problems.`,ii,de,ut,mi,Ba,Bm="Performs a single optimization step.",Wr,k,ft,li,Ra,Rm="Implements NAdamW algorithm.",si,Ga,Gm=`See Table 1 in <a href="https://arxiv.org/abs/1910.05446" rel="nofollow">https://arxiv.org/abs/1910.05446</a> for the implementation of
the NAdam algorithm (there is also a comment in the code which highlights
the only difference of NAdamW and AdamW).
For further details regarding the algorithm we refer to
<code>Decoupled Weight Decay Regularization</code>_.`,pi,Sa,Sm=`.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,di,ce,ht,ci,Va,Vm="Performs a single optimization step.",Ur,W,vt,gi,Wa,Wm="Implements Novograd algorithm.",ui,ge,bt,fi,Ua,Um="Performs a single optimization step.",Qr,_t,xt,Kr,$,$t,hi,Qa,Qm="Implements RMSprop algorithm (TensorFlow style epsilon)",vi,Ka,Km=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,bi,ja,jm="Noteworthy changes include:",_i,Za,Zm="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",xi,Xa,Xm=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,$i,Ja,Jm=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,yi,ue,yt,wi,Ya,Ym="Performs a single optimization step.",jr,wt,Ct,Zr,X,At,Ci,fe,Lt,Ai,er,el="Performs a single optimization step.",Xr,Tt,Jr,$r,Yr;return ve=new U({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),_e=new U({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),xe=new U({props:{title:"Factory functions",local:"timm.optim.create_optimizer_v2",headingTag:"h3"}}),$e=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:": Union"},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": Optional = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": Optional = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": Optional = None"},{name:"param_group_fn",val:": Optional = None"},{name:"**kwargs",val:": Any"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/_optim_factory.py#L839",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Configured optimizer instance.</p>
`}}),we=new U({props:{title:"Basic usage with a model",local:"basic-usage-with-a-model",headingTag:"h1"}}),Ae=new U({props:{title:"SGD with momentum and weight decay",local:"sgd-with-momentum-and-weight-decay",headingTag:"h1"}}),Te=new U({props:{title:"Adam with layer-wise learning rate decay",local:"adam-with-layer-wise-learning-rate-decay",headingTag:"h1"}}),De=new U({props:{title:"Custom parameter groups",local:"custom-parameter-groups",headingTag:"h1"}}),qe=new b({props:{name:"timm.optim.list_optimizers",anchor:"timm.optim.list_optimizers",parameters:[{name:"filter",val:": Union = ''"},{name:"exclude_filters",val:": Optional = None"},{name:"with_description",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/_optim_factory.py#L739",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of optimizer names as strings (e.g., [‘adam’, ‘adamw’, …])
If with_description is True:
List of tuples of (name, description) (e.g., [(‘adam’, ‘Adaptive Moment…’), …])</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If with_description is False</p>
`}}),Pe=new b({props:{name:"timm.optim.get_optimizer_class",anchor:"timm.optim.get_optimizer_class",parameters:[{name:"name",val:": str"},{name:"bind_defaults",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/_optim_factory.py#L799",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The optimizer class (e.g., torch.optim.Adam)
If bind_defaults is True:
A partial function with default arguments bound</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If bind_defaults is False</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If optimizer name is not found in registry</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ke=new U({props:{title:"Get raw optimizer class",local:"get-raw-optimizer-class",headingTag:"h1"}}),Ne=new U({props:{title:"Get optimizer with defaults bound",local:"get-optimizer-with-defaults-bound",headingTag:"h1"}}),Ie=new U({props:{title:"Get SGD with nesterov momentum default",local:"get-sgd-with-nesterov-momentum-default",headingTag:"h1"}}),Fe=new U({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),He=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adabelief.py#L6"}}),Be=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adabelief.py#L106"}}),Re=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:""},{name:"lr",val:" = None"},{name:"eps",val:" = 1e-30"},{name:"eps_scale",val:" = 0.001"},{name:"clip_threshold",val:" = 1.0"},{name:"decay_rate",val:" = -0.8"},{name:"betas",val:" = None"},{name:"weight_decay",val:" = 0.0"},{name:"scale_parameter",val:" = True"},{name:"warmup_init",val:" = False"},{name:"min_dim_size_to_factor",val:" = 32"}],parametersDescription:[{anchor:"timm.optim.Adafactor.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adafactor.lr",description:"<strong>lr</strong> (float, optional) &#x2014; external learning rate (default: None)",name:"lr"},{anchor:"timm.optim.Adafactor.eps",description:`<strong>eps</strong> (tuple[float, float]) &#x2014; regularization constants for square gradient
and parameter scale respectively (default: (1e-30, 1e-3))`,name:"eps"},{anchor:"timm.optim.Adafactor.clip_threshold",description:"<strong>clip_threshold</strong> (float) &#x2014; threshold of root mean square of final gradient update (default: 1.0)",name:"clip_threshold"},{anchor:"timm.optim.Adafactor.decay_rate",description:"<strong>decay_rate</strong> (float) &#x2014; coefficient used to compute running averages of square gradient (default: -0.8)",name:"decay_rate"},{anchor:"timm.optim.Adafactor.beta1",description:"<strong>beta1</strong> (float) &#x2014; coefficient used for computing running averages of gradient (default: None)",name:"beta1"},{anchor:"timm.optim.Adafactor.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adafactor.scale_parameter",description:"<strong>scale_parameter</strong> (bool) &#x2014; if True, learning rate is scaled by root mean square of parameter (default: True)",name:"scale_parameter"},{anchor:"timm.optim.Adafactor.warmup_init",description:`<strong>warmup_init</strong> (bool) &#x2014; time-dependent learning rate computation depends on
whether warm-up initialization is being used (default: False)`,name:"warmup_init"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adafactor.py#L17"}}),Ge=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adafactor.py#L117"}}),Se=new b({props:{name:"class timm.optim.AdafactorBigVision",anchor:"timm.optim.AdafactorBigVision",parameters:[{name:"params",val:""},{name:"lr",val:": float = 1.0"},{name:"min_dim_size_to_factor",val:": int = 32"},{name:"decay_rate",val:": float = 0.8"},{name:"decay_offset",val:": int = 0"},{name:"beta2_cap",val:": float = 0.999"},{name:"momentum",val:": Optional = 0.9"},{name:"momentum_dtype",val:": Union = torch.bfloat16"},{name:"eps",val:": Optional = None"},{name:"weight_decay",val:": float = 0.0"},{name:"clipping_threshold",val:": Optional = None"},{name:"unscaled_wd",val:": bool = False"},{name:"foreach",val:": Optional = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adafactor_bv.py#L48"}}),Ve=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adahessian.py#L9"}}),We=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adahessian.py#L74"}}),Ue=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adahessian.py#L90"}}),Qe=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adahessian.py#L118"}}),Ke=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adahessian.py#L81"}}),Ze=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adamp.py#L43"}}),Xe=new b({props:{name:"class timm.optim.AdamW",anchor:"timm.optim.AdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.AdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.AdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"},{anchor:"timm.optim.AdamW.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adamw.py#L12"}}),Je=new b({props:{name:"step",anchor:"timm.optim.AdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adamw.py#L71"}}),Ye=new b({props:{name:"class timm.optim.Adan",anchor:"timm.optim.Adan",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.98, 0.92, 0.99)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"no_prox",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adan.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Adan.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Adan.betas",description:`<strong>betas</strong> (Tuple[float, float, flot], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.98, 0.92, 0.99))`,name:"betas"},{anchor:"timm.optim.Adan.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Adan.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; decoupled weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adan.no_prox",description:"<strong>no_prox</strong> (bool) &#x2014; how to perform the decoupled weight decay (default: False)",name:"no_prox"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adan.py#L16"}}),et=new b({props:{name:"step",anchor:"timm.optim.Adan.step",parameters:[{name:"closure",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adan.py#L71"}}),tt=new b({props:{name:"class timm.optim.Adopt",anchor:"timm.optim.Adopt",parameters:[{name:"params",val:""},{name:"lr",val:": Union = 0.001"},{name:"betas",val:": Tuple = (0.9, 0.9999)"},{name:"eps",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"decoupled",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"maximize",val:": bool = False"},{name:"capturable",val:": bool = False"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adopt.py#L53"}}),at=new b({props:{name:"step",anchor:"timm.optim.Adopt.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adopt.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/adopt.py#L188"}}),rt=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"bias_correction",val:" = True"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-06"},{name:"weight_decay",val:" = 0.01"},{name:"grad_averaging",val:" = True"},{name:"max_grad_norm",val:" = 1.0"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Lamb.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:`<strong>grad_averaging</strong> (bool, optional) &#x2014; whether apply (1-beta2) to grad when
calculating running averages of gradient. (default: True)`,name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> (float, optional) &#x2014; value used to clip global grad norm (default: 1.0)",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LAMBC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:`<strong>always_adapt</strong> (boolean, optional) &#x2014; Apply adaptive learning rate to 0.0
weight decay parameter (default: False)`,name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/lamb.py#L60"}}),ot=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/lamb.py#L131"}}),nt=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/lars.py#L17"}}),it=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/lars.py#L75"}}),mt=new b({props:{name:"class timm.optim.Lion",anchor:"timm.optim.Lion",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.0001"},{name:"betas",val:" = (0.9, 0.99)"},{name:"weight_decay",val:" = 0.0"},{name:"maximize",val:" = False"},{name:"foreach",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/lion.py#L25"}}),lt=new b({props:{name:"step",anchor:"timm.optim.Lion.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lion.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/lion.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the loss.</p>
`}}),pt=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/lookahead.py#L15"}}),dt=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/madgrad.py#L24"}}),ct=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": Optional = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/madgrad.py#L90"}}),gt=new b({props:{name:"class timm.optim.Nadam",anchor:"timm.optim.Nadam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.002"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"schedule_decay",val:" = 0.004"}],parametersDescription:[{anchor:"timm.optim.Nadam.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.Nadam.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 2e-3)",name:"lr"},{anchor:"timm.optim.Nadam.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square`,name:"betas"},{anchor:"timm.optim.Nadam.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Nadam.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Nadam.schedule_decay",description:"<strong>schedule_decay</strong> (float, optional) &#x2014; momentum schedule decay (default: 4e-3)",name:"schedule_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/nadam.py#L7"}}),ut=new b({props:{name:"step",anchor:"timm.optim.Nadam.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Nadam.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/nadam.py#L50"}}),ft=new b({props:{name:"class timm.optim.nadamw.NAdamW",anchor:"timm.optim.nadamw.NAdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"capturable",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.nadamw.NAdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.nadamw.NAdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.nadamw.NAdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.nadamw.NAdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.nadamw.NAdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/nadamw.py#L15"}}),ht=new b({props:{name:"step",anchor:"timm.optim.nadamw.NAdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.nadamw.NAdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/nadamw.py#L80"}}),vt=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:`<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)
grad_averaging &#x2014; gradient averaging`,name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/nvnovograd.py#L13"}}),bt=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/nvnovograd.py#L66"}}),xt=new b({props:{name:"class timm.optim.RAdam",anchor:"timm.optim.RAdam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/radam.py#L10"}}),$t=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.01"},{name:"alpha",val:" = 0.9"},{name:"eps",val:" = 1e-10"},{name:"weight_decay",val:" = 0"},{name:"momentum",val:" = 0.0"},{name:"centered",val:" = False"},{name:"decoupled_decay",val:" = False"},{name:"lr_in_momentum",val:" = True"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-2)",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> (float, optional) &#x2014; smoothing (decay) constant (default: 0.9)",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-10)`,name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:`<strong>centered</strong> (bool, optional)  &#x2014; if <code>True</code>, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance`,name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> (bool, optional) &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:`<strong>lr_in_momentum</strong> (bool, optional) &#x2014; learning rate scaling is included in the momentum buffer
update as per defaults in Tensorflow`,name:"lr_in_momentum"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/rmsprop_tf.py#L14"}}),yt=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/rmsprop_tf.py#L89"}}),Ct=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/sgdp.py#L19"}}),At=new b({props:{name:"class timm.optim.sgdw.SGDW",anchor:"timm.optim.sgdw.SGDW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": Optional = None"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/sgdw.py#L16"}}),Lt=new b({props:{name:"step",anchor:"timm.optim.sgdw.SGDW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.sgdw.SGDW.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2320/timm/optim/sgdw.py#L79"}}),Tt=new Al({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){Z=a("meta"),yr=o(),ir=a("p"),wr=o(),d(ve.$$.fragment),Cr=o(),be=a("p"),be.innerHTML=Ti,Ar=o(),d(_e.$$.fragment),Lr=o(),d(xe.$$.fragment),Tr=o(),_=a("div"),d($e.$$.fragment),To=o(),zt=a("p"),zt.textContent=zi,zo=o(),Dt=a("p"),Dt.textContent=Di,Do=o(),qt=a("p"),qt.textContent=qi,qo=o(),mr=a("blockquote"),lr=a("blockquote"),ye=a("blockquote"),d(we.$$.fragment),Po=o(),Pt=a("p"),Pt.textContent=Pi,Mo=o(),sr=a("blockquote"),pr=a("blockquote"),Ce=a("blockquote"),d(Ae.$$.fragment),ko=o(),Mt=a("p"),Mt.textContent=Mi,Eo=o(),dr=a("blockquote"),cr=a("blockquote"),Le=a("blockquote"),d(Te.$$.fragment),No=o(),kt=a("p"),kt.textContent=ki,Oo=o(),gr=a("blockquote"),ur=a("blockquote"),ze=a("blockquote"),d(De.$$.fragment),Io=o(),Et=a("p"),Et.textContent=Ei,Fo=o(),Nt=a("p"),Nt.textContent=Ni,Ho=o(),Ot=a("ol"),Ot.innerHTML=Oi,zr=o(),x=a("div"),d(qe.$$.fragment),Bo=o(),It=a("p"),It.textContent=Ii,Ro=o(),Ft=a("p"),Ft.textContent=Fi,Go=o(),Ht=a("p"),Ht.textContent=Hi,So=o(),Bt=a("blockquote"),Bt.innerHTML=Bi,Vo=o(),Rt=a("blockquote"),Rt.innerHTML=Ri,Wo=o(),Gt=a("blockquote"),Gt.innerHTML=Gi,Uo=o(),St=a("blockquote"),St.innerHTML=Si,Dr=o(),w=a("div"),d(Pe.$$.fragment),Qo=o(),Vt=a("p"),Vt.textContent=Vi,Ko=o(),Wt=a("p"),Wt.textContent=Wi,jo=o(),Ut=a("p"),Ut.textContent=Ui,Zo=o(),fr=a("blockquote"),hr=a("blockquote"),Me=a("blockquote"),d(ke.$$.fragment),Xo=o(),Qt=a("p"),Qt.textContent=Qi,Jo=o(),vr=a("blockquote"),br=a("blockquote"),Ee=a("blockquote"),d(Ne.$$.fragment),Yo=o(),Kt=a("p"),Kt.textContent=Ki,en=o(),_r=a("blockquote"),xr=a("blockquote"),Oe=a("blockquote"),d(Ie.$$.fragment),tn=o(),jt=a("p"),jt.textContent=ji,qr=o(),d(Fe.$$.fragment),Pr=o(),A=a("div"),d(He.$$.fragment),an=o(),Zt=a("p"),Zt.textContent=Zi,rn=o(),Xt=a("p"),Xt.textContent=Xi,on=o(),Jt=a("p"),Jt.innerHTML=Ji,nn=o(),Yt=a("ul"),Yt.innerHTML=Yi,mn=o(),J=a("div"),d(Be.$$.fragment),ln=o(),ea=a("p"),ea.textContent=em,Mr=o(),L=a("div"),d(Re.$$.fragment),sn=o(),ta=a("p"),ta.textContent=tm,pn=o(),aa=a("p"),aa.innerHTML=am,dn=o(),ra=a("p"),ra.innerHTML=rm,cn=o(),oa=a("p"),oa.innerHTML=om,gn=o(),Y=a("div"),d(Ge.$$.fragment),un=o(),na=a("p"),na.textContent=nm,kr=o(),R=a("div"),d(Se.$$.fragment),fn=o(),ia=a("p"),ia.textContent=im,hn=o(),ma=a("p"),ma.innerHTML=mm,Er=o(),T=a("div"),d(Ve.$$.fragment),vn=o(),la=a("p"),la.textContent=lm,bn=o(),ee=a("div"),d(We.$$.fragment),_n=o(),sa=a("p"),sa.textContent=sm,xn=o(),te=a("div"),d(Ue.$$.fragment),$n=o(),pa=a("p"),pa.textContent=pm,yn=o(),ae=a("div"),d(Qe.$$.fragment),wn=o(),da=a("p"),da.textContent=dm,Cn=o(),re=a("div"),d(Ke.$$.fragment),An=o(),ca=a("p"),ca.textContent=cm,Nr=o(),je=a("div"),d(Ze.$$.fragment),Or=o(),P=a("div"),d(Xe.$$.fragment),Ln=o(),ga=a("p"),ga.textContent=gm,Tn=o(),ua=a("p"),ua.innerHTML=um,zn=o(),fa=a("p"),fa.innerHTML=fm,Dn=o(),oe=a("div"),d(Je.$$.fragment),qn=o(),ha=a("p"),ha.textContent=hm,Ir=o(),G=a("div"),d(Ye.$$.fragment),Pn=o(),va=a("p"),va.innerHTML=vm,Mn=o(),ne=a("div"),d(et.$$.fragment),kn=o(),ba=a("p"),ba.textContent=bm,Fr=o(),S=a("div"),d(tt.$$.fragment),En=o(),_a=a("p"),_a.innerHTML=_m,Nn=o(),ie=a("div"),d(at.$$.fragment),On=o(),xa=a("p"),xa.textContent=xm,Hr=o(),M=a("div"),d(rt.$$.fragment),In=o(),$a=a("p"),$a.innerHTML=$m,Fn=o(),ya=a("p"),ya.innerHTML=ym,Hn=o(),wa=a("p"),wa.innerHTML=wm,Bn=o(),me=a("div"),d(ot.$$.fragment),Rn=o(),Ca=a("p"),Ca.textContent=Cm,Br=o(),O=a("div"),d(nt.$$.fragment),Gn=o(),Aa=a("p"),Aa.textContent=Am,Sn=o(),La=a("p"),La.innerHTML=Lm,Vn=o(),le=a("div"),d(it.$$.fragment),Wn=o(),Ta=a("p"),Ta.textContent=Tm,Rr=o(),V=a("div"),d(mt.$$.fragment),Un=o(),za=a("p"),za.textContent=zm,Qn=o(),se=a("div"),d(lt.$$.fragment),Kn=o(),Da=a("p"),Da.textContent=Dm,Gr=o(),st=a("div"),d(pt.$$.fragment),Sr=o(),C=a("div"),d(dt.$$.fragment),jn=o(),qa=a("p"),qa.textContent=qm,Zn=o(),Pa=a("p"),Pa.innerHTML=Pm,Xn=o(),Ma=a("p"),Ma.textContent=Mm,Jn=o(),ka=a("p"),ka.textContent=km,Yn=o(),Ea=a("p"),Ea.textContent=Em,ei=o(),pe=a("div"),d(ct.$$.fragment),ti=o(),Na=a("p"),Na.textContent=Nm,Vr=o(),z=a("div"),d(gt.$$.fragment),ai=o(),Oa=a("p"),Oa.textContent=Om,ri=o(),Ia=a("p"),Ia.innerHTML=Im,oi=o(),Fa=a("p"),Fa.innerHTML=Fm,ni=o(),Ha=a("p"),Ha.innerHTML=Hm,ii=o(),de=a("div"),d(ut.$$.fragment),mi=o(),Ba=a("p"),Ba.textContent=Bm,Wr=o(),k=a("div"),d(ft.$$.fragment),li=o(),Ra=a("p"),Ra.textContent=Rm,si=o(),Ga=a("p"),Ga.innerHTML=Gm,pi=o(),Sa=a("p"),Sa.innerHTML=Sm,di=o(),ce=a("div"),d(ht.$$.fragment),ci=o(),Va=a("p"),Va.textContent=Vm,Ur=o(),W=a("div"),d(vt.$$.fragment),gi=o(),Wa=a("p"),Wa.textContent=Wm,ui=o(),ge=a("div"),d(bt.$$.fragment),fi=o(),Ua=a("p"),Ua.textContent=Um,Qr=o(),_t=a("div"),d(xt.$$.fragment),Kr=o(),$=a("div"),d($t.$$.fragment),hi=o(),Qa=a("p"),Qa.textContent=Qm,vi=o(),Ka=a("p"),Ka.textContent=Km,bi=o(),ja=a("p"),ja.textContent=jm,_i=o(),Za=a("ol"),Za.innerHTML=Zm,xi=o(),Xa=a("p"),Xa.innerHTML=Xm,$i=o(),Ja=a("p"),Ja.innerHTML=Jm,yi=o(),ue=a("div"),d(yt.$$.fragment),wi=o(),Ya=a("p"),Ya.textContent=Ym,jr=o(),wt=a("div"),d(Ct.$$.fragment),Zr=o(),X=a("div"),d(At.$$.fragment),Ci=o(),fe=a("div"),d(Lt.$$.fragment),Ai=o(),er=a("p"),er.textContent=el,Xr=o(),d(Tt.$$.fragment),Jr=o(),$r=a("p"),this.h()},l(e){const l=Cl("svelte-u9bgzb",document.head);Z=r(l,"META",{name:!0,content:!0}),l.forEach(i),yr=n(e),ir=r(e,"P",{}),s(ir).forEach(i),wr=n(e),c(ve.$$.fragment,e),Cr=n(e),be=r(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1c6qm22"&&(be.innerHTML=Ti),Ar=n(e),c(_e.$$.fragment,e),Lr=n(e),c(xe.$$.fragment,e),Tr=n(e),_=r(e,"DIV",{class:!0});var y=s(_);c($e.$$.fragment,y),To=n(y),zt=r(y,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-1330e7"&&(zt.textContent=zi),zo=n(y),Dt=r(y,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-9cjiwr"&&(Dt.textContent=Di),Do=n(y),qt=r(y,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-kvfsh7"&&(qt.textContent=qi),qo=n(y),mr=r(y,"BLOCKQUOTE",{});var tl=s(mr);lr=r(tl,"BLOCKQUOTE",{});var al=s(lr);ye=r(al,"BLOCKQUOTE",{});var eo=s(ye);c(we.$$.fragment,eo),Po=n(eo),Pt=r(eo,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-180ncmf"&&(Pt.textContent=Pi),eo.forEach(i),al.forEach(i),tl.forEach(i),Mo=n(y),sr=r(y,"BLOCKQUOTE",{});var rl=s(sr);pr=r(rl,"BLOCKQUOTE",{});var ol=s(pr);Ce=r(ol,"BLOCKQUOTE",{});var to=s(Ce);c(Ae.$$.fragment,to),ko=n(to),Mt=r(to,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-6yrpk7"&&(Mt.textContent=Mi),to.forEach(i),ol.forEach(i),rl.forEach(i),Eo=n(y),dr=r(y,"BLOCKQUOTE",{});var nl=s(dr);cr=r(nl,"BLOCKQUOTE",{});var il=s(cr);Le=r(il,"BLOCKQUOTE",{});var ao=s(Le);c(Te.$$.fragment,ao),No=n(ao),kt=r(ao,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-1vmtu70"&&(kt.textContent=ki),ao.forEach(i),il.forEach(i),nl.forEach(i),Oo=n(y),gr=r(y,"BLOCKQUOTE",{});var ml=s(gr);ur=r(ml,"BLOCKQUOTE",{});var ll=s(ur);ze=r(ll,"BLOCKQUOTE",{});var ro=s(ze);c(De.$$.fragment,ro),Io=n(ro),Et=r(ro,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-15ovmpe"&&(Et.textContent=Ei),ro.forEach(i),ll.forEach(i),ml.forEach(i),Fo=n(y),Nt=r(y,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-sgpn75"&&(Nt.textContent=Ni),Ho=n(y),Ot=r(y,"OL",{"data-svelte-h":!0}),m(Ot)!=="svelte-psaz57"&&(Ot.innerHTML=Oi),y.forEach(i),zr=n(e),x=r(e,"DIV",{class:!0});var D=s(x);c(qe.$$.fragment,D),Bo=n(D),It=r(D,"P",{"data-svelte-h":!0}),m(It)!=="svelte-1h2sspw"&&(It.textContent=Ii),Ro=n(D),Ft=r(D,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-1tapwxe"&&(Ft.textContent=Fi),Go=n(D),Ht=r(D,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-kvfsh7"&&(Ht.textContent=Hi),So=n(D),Bt=r(D,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Bt)!=="svelte-m875zf"&&(Bt.innerHTML=Bi),Vo=n(D),Rt=r(D,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Rt)!=="svelte-1mioyvo"&&(Rt.innerHTML=Ri),Wo=n(D),Gt=r(D,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Gt)!=="svelte-ji9gfr"&&(Gt.innerHTML=Gi),Uo=n(D),St=r(D,"BLOCKQUOTE",{"data-svelte-h":!0}),m(St)!=="svelte-tvmm3x"&&(St.innerHTML=Si),D.forEach(i),Dr=n(e),w=r(e,"DIV",{class:!0});var E=s(w);c(Pe.$$.fragment,E),Qo=n(E),Vt=r(E,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-1rcjgrx"&&(Vt.textContent=Vi),Ko=n(E),Wt=r(E,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-13jhmtj"&&(Wt.textContent=Wi),jo=n(E),Ut=r(E,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-kvfsh7"&&(Ut.textContent=Ui),Zo=n(E),fr=r(E,"BLOCKQUOTE",{});var sl=s(fr);hr=r(sl,"BLOCKQUOTE",{});var pl=s(hr);Me=r(pl,"BLOCKQUOTE",{});var oo=s(Me);c(ke.$$.fragment,oo),Xo=n(oo),Qt=r(oo,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-haob3t"&&(Qt.textContent=Qi),oo.forEach(i),pl.forEach(i),sl.forEach(i),Jo=n(E),vr=r(E,"BLOCKQUOTE",{});var dl=s(vr);br=r(dl,"BLOCKQUOTE",{});var cl=s(br);Ee=r(cl,"BLOCKQUOTE",{});var no=s(Ee);c(Ne.$$.fragment,no),Yo=n(no),Kt=r(no,"P",{"data-svelte-h":!0}),m(Kt)!=="svelte-1fen2ms"&&(Kt.textContent=Ki),no.forEach(i),cl.forEach(i),dl.forEach(i),en=n(E),_r=r(E,"BLOCKQUOTE",{});var gl=s(_r);xr=r(gl,"BLOCKQUOTE",{});var ul=s(xr);Oe=r(ul,"BLOCKQUOTE",{});var io=s(Oe);c(Ie.$$.fragment,io),tn=n(io),jt=r(io,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-18pqamq"&&(jt.textContent=ji),io.forEach(i),ul.forEach(i),gl.forEach(i),E.forEach(i),qr=n(e),c(Fe.$$.fragment,e),Pr=n(e),A=r(e,"DIV",{class:!0});var I=s(A);c(He.$$.fragment,I),an=n(I),Zt=r(I,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-1hnunr4"&&(Zt.textContent=Zi),rn=n(I),Xt=r(I,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-1cjb7xo"&&(Xt.textContent=Xi),on=n(I),Jt=r(I,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1347q2l"&&(Jt.innerHTML=Ji),nn=n(I),Yt=r(I,"UL",{"data-svelte-h":!0}),m(Yt)!=="svelte-12x3l9q"&&(Yt.innerHTML=Yi),mn=n(I),J=r(I,"DIV",{class:!0});var mo=s(J);c(Be.$$.fragment,mo),ln=n(mo),ea=r(mo,"P",{"data-svelte-h":!0}),m(ea)!=="svelte-1gr03w4"&&(ea.textContent=em),mo.forEach(i),I.forEach(i),Mr=n(e),L=r(e,"DIV",{class:!0});var F=s(L);c(Re.$$.fragment,F),sn=n(F),ta=r(F,"P",{"data-svelte-h":!0}),m(ta)!=="svelte-1j9mkxe"&&(ta.textContent=tm),pn=n(F),aa=r(F,"P",{"data-svelte-h":!0}),m(aa)!=="svelte-1xvyiun"&&(aa.innerHTML=am),dn=n(F),ra=r(F,"P",{"data-svelte-h":!0}),m(ra)!=="svelte-1i7ubkr"&&(ra.innerHTML=rm),cn=n(F),oa=r(F,"P",{"data-svelte-h":!0}),m(oa)!=="svelte-96f97i"&&(oa.innerHTML=om),gn=n(F),Y=r(F,"DIV",{class:!0});var lo=s(Y);c(Ge.$$.fragment,lo),un=n(lo),na=r(lo,"P",{"data-svelte-h":!0}),m(na)!=="svelte-1gr03w4"&&(na.textContent=nm),lo.forEach(i),F.forEach(i),kr=n(e),R=r(e,"DIV",{class:!0});var tr=s(R);c(Se.$$.fragment,tr),fn=n(tr),ia=r(tr,"P",{"data-svelte-h":!0}),m(ia)!=="svelte-19t8yzj"&&(ia.textContent=im),hn=n(tr),ma=r(tr,"P",{"data-svelte-h":!0}),m(ma)!=="svelte-aajaln"&&(ma.innerHTML=mm),tr.forEach(i),Er=n(e),T=r(e,"DIV",{class:!0});var H=s(T);c(Ve.$$.fragment,H),vn=n(H),la=r(H,"P",{"data-svelte-h":!0}),m(la)!=="svelte-1cuo0rh"&&(la.textContent=lm),bn=n(H),ee=r(H,"DIV",{class:!0});var so=s(ee);c(We.$$.fragment,so),_n=n(so),sa=r(so,"P",{"data-svelte-h":!0}),m(sa)!=="svelte-1jz1hl7"&&(sa.textContent=sm),so.forEach(i),xn=n(H),te=r(H,"DIV",{class:!0});var po=s(te);c(Ue.$$.fragment,po),$n=n(po),pa=r(po,"P",{"data-svelte-h":!0}),m(pa)!=="svelte-1y1oyzd"&&(pa.textContent=pm),po.forEach(i),yn=n(H),ae=r(H,"DIV",{class:!0});var co=s(ae);c(Qe.$$.fragment,co),wn=n(co),da=r(co,"P",{"data-svelte-h":!0}),m(da)!=="svelte-1gr03w4"&&(da.textContent=dm),co.forEach(i),Cn=n(H),re=r(H,"DIV",{class:!0});var go=s(re);c(Ke.$$.fragment,go),An=n(go),ca=r(go,"P",{"data-svelte-h":!0}),m(ca)!=="svelte-4lvf5h"&&(ca.textContent=cm),go.forEach(i),H.forEach(i),Nr=n(e),je=r(e,"DIV",{class:!0});var fl=s(je);c(Ze.$$.fragment,fl),fl.forEach(i),Or=n(e),P=r(e,"DIV",{class:!0});var Q=s(P);c(Xe.$$.fragment,Q),Ln=n(Q),ga=r(Q,"P",{"data-svelte-h":!0}),m(ga)!=="svelte-c51pd7"&&(ga.textContent=gm),Tn=n(Q),ua=r(Q,"P",{"data-svelte-h":!0}),m(ua)!=="svelte-1cgyzi6"&&(ua.innerHTML=um),zn=n(Q),fa=r(Q,"P",{"data-svelte-h":!0}),m(fa)!=="svelte-1pe3ewc"&&(fa.innerHTML=fm),Dn=n(Q),oe=r(Q,"DIV",{class:!0});var uo=s(oe);c(Je.$$.fragment,uo),qn=n(uo),ha=r(uo,"P",{"data-svelte-h":!0}),m(ha)!=="svelte-1gr03w4"&&(ha.textContent=hm),uo.forEach(i),Q.forEach(i),Ir=n(e),G=r(e,"DIV",{class:!0});var ar=s(G);c(Ye.$$.fragment,ar),Pn=n(ar),va=r(ar,"P",{"data-svelte-h":!0}),m(va)!=="svelte-acz7r2"&&(va.innerHTML=vm),Mn=n(ar),ne=r(ar,"DIV",{class:!0});var fo=s(ne);c(et.$$.fragment,fo),kn=n(fo),ba=r(fo,"P",{"data-svelte-h":!0}),m(ba)!=="svelte-1gr03w4"&&(ba.textContent=bm),fo.forEach(i),ar.forEach(i),Fr=n(e),S=r(e,"DIV",{class:!0});var rr=s(S);c(tt.$$.fragment,rr),En=n(rr),_a=r(rr,"P",{"data-svelte-h":!0}),m(_a)!=="svelte-bxurot"&&(_a.innerHTML=_m),Nn=n(rr),ie=r(rr,"DIV",{class:!0});var ho=s(ie);c(at.$$.fragment,ho),On=n(ho),xa=r(ho,"P",{"data-svelte-h":!0}),m(xa)!=="svelte-1siu6mf"&&(xa.textContent=xm),ho.forEach(i),rr.forEach(i),Hr=n(e),M=r(e,"DIV",{class:!0});var K=s(M);c(rt.$$.fragment,K),In=n(K),$a=r(K,"P",{"data-svelte-h":!0}),m($a)!=="svelte-d5zqgn"&&($a.innerHTML=$m),Fn=n(K),ya=r(K,"P",{"data-svelte-h":!0}),m(ya)!=="svelte-1wamkfv"&&(ya.innerHTML=ym),Hn=n(K),wa=r(K,"P",{"data-svelte-h":!0}),m(wa)!=="svelte-dty621"&&(wa.innerHTML=wm),Bn=n(K),me=r(K,"DIV",{class:!0});var vo=s(me);c(ot.$$.fragment,vo),Rn=n(vo),Ca=r(vo,"P",{"data-svelte-h":!0}),m(Ca)!=="svelte-1gr03w4"&&(Ca.textContent=Cm),vo.forEach(i),K.forEach(i),Br=n(e),O=r(e,"DIV",{class:!0});var he=s(O);c(nt.$$.fragment,he),Gn=n(he),Aa=r(he,"P",{"data-svelte-h":!0}),m(Aa)!=="svelte-vzcsb8"&&(Aa.textContent=Am),Sn=n(he),La=r(he,"P",{"data-svelte-h":!0}),m(La)!=="svelte-euart9"&&(La.innerHTML=Lm),Vn=n(he),le=r(he,"DIV",{class:!0});var bo=s(le);c(it.$$.fragment,bo),Wn=n(bo),Ta=r(bo,"P",{"data-svelte-h":!0}),m(Ta)!=="svelte-1gr03w4"&&(Ta.textContent=Tm),bo.forEach(i),he.forEach(i),Rr=n(e),V=r(e,"DIV",{class:!0});var or=s(V);c(mt.$$.fragment,or),Un=n(or),za=r(or,"P",{"data-svelte-h":!0}),m(za)!=="svelte-pwyp7b"&&(za.textContent=zm),Qn=n(or),se=r(or,"DIV",{class:!0});var _o=s(se);c(lt.$$.fragment,_o),Kn=n(_o),Da=r(_o,"P",{"data-svelte-h":!0}),m(Da)!=="svelte-1gr03w4"&&(Da.textContent=Dm),_o.forEach(i),or.forEach(i),Gr=n(e),st=r(e,"DIV",{class:!0});var hl=s(st);c(pt.$$.fragment,hl),hl.forEach(i),Sr=n(e),C=r(e,"DIV",{class:!0});var N=s(C);c(dt.$$.fragment,N),jn=n(N),qa=r(N,"P",{"data-svelte-h":!0}),m(qa)!=="svelte-wmmdpx"&&(qa.textContent=qm),Zn=n(N),Pa=r(N,"P",{"data-svelte-h":!0}),m(Pa)!=="svelte-12dyngi"&&(Pa.innerHTML=Pm),Xn=n(N),Ma=r(N,"P",{"data-svelte-h":!0}),m(Ma)!=="svelte-qjjdis"&&(Ma.textContent=Mm),Jn=n(N),ka=r(N,"P",{"data-svelte-h":!0}),m(ka)!=="svelte-rosfou"&&(ka.textContent=km),Yn=n(N),Ea=r(N,"P",{"data-svelte-h":!0}),m(Ea)!=="svelte-hlwvkn"&&(Ea.textContent=Em),ei=n(N),pe=r(N,"DIV",{class:!0});var xo=s(pe);c(ct.$$.fragment,xo),ti=n(xo),Na=r(xo,"P",{"data-svelte-h":!0}),m(Na)!=="svelte-1gr03w4"&&(Na.textContent=Nm),xo.forEach(i),N.forEach(i),Vr=n(e),z=r(e,"DIV",{class:!0});var B=s(z);c(gt.$$.fragment,B),ai=n(B),Oa=r(B,"P",{"data-svelte-h":!0}),m(Oa)!=="svelte-1ss2c23"&&(Oa.textContent=Om),ri=n(B),Ia=r(B,"P",{"data-svelte-h":!0}),m(Ia)!=="svelte-ewqetr"&&(Ia.innerHTML=Im),oi=n(B),Fa=r(B,"P",{"data-svelte-h":!0}),m(Fa)!=="svelte-1q705lb"&&(Fa.innerHTML=Fm),ni=n(B),Ha=r(B,"P",{"data-svelte-h":!0}),m(Ha)!=="svelte-14ul3re"&&(Ha.innerHTML=Hm),ii=n(B),de=r(B,"DIV",{class:!0});var $o=s(de);c(ut.$$.fragment,$o),mi=n($o),Ba=r($o,"P",{"data-svelte-h":!0}),m(Ba)!=="svelte-1gr03w4"&&(Ba.textContent=Bm),$o.forEach(i),B.forEach(i),Wr=n(e),k=r(e,"DIV",{class:!0});var j=s(k);c(ft.$$.fragment,j),li=n(j),Ra=r(j,"P",{"data-svelte-h":!0}),m(Ra)!=="svelte-3mtxcr"&&(Ra.textContent=Rm),si=n(j),Ga=r(j,"P",{"data-svelte-h":!0}),m(Ga)!=="svelte-797qvx"&&(Ga.innerHTML=Gm),pi=n(j),Sa=r(j,"P",{"data-svelte-h":!0}),m(Sa)!=="svelte-1qa39gq"&&(Sa.innerHTML=Sm),di=n(j),ce=r(j,"DIV",{class:!0});var yo=s(ce);c(ht.$$.fragment,yo),ci=n(yo),Va=r(yo,"P",{"data-svelte-h":!0}),m(Va)!=="svelte-1gr03w4"&&(Va.textContent=Vm),yo.forEach(i),j.forEach(i),Ur=n(e),W=r(e,"DIV",{class:!0});var nr=s(W);c(vt.$$.fragment,nr),gi=n(nr),Wa=r(nr,"P",{"data-svelte-h":!0}),m(Wa)!=="svelte-5vv99d"&&(Wa.textContent=Wm),ui=n(nr),ge=r(nr,"DIV",{class:!0});var wo=s(ge);c(bt.$$.fragment,wo),fi=n(wo),Ua=r(wo,"P",{"data-svelte-h":!0}),m(Ua)!=="svelte-1gr03w4"&&(Ua.textContent=Um),wo.forEach(i),nr.forEach(i),Qr=n(e),_t=r(e,"DIV",{class:!0});var vl=s(_t);c(xt.$$.fragment,vl),vl.forEach(i),Kr=n(e),$=r(e,"DIV",{class:!0});var q=s($);c($t.$$.fragment,q),hi=n(q),Qa=r(q,"P",{"data-svelte-h":!0}),m(Qa)!=="svelte-1tqv0s5"&&(Qa.textContent=Qm),vi=n(q),Ka=r(q,"P",{"data-svelte-h":!0}),m(Ka)!=="svelte-g10xv4"&&(Ka.textContent=Km),bi=n(q),ja=r(q,"P",{"data-svelte-h":!0}),m(ja)!=="svelte-1acg3vg"&&(ja.textContent=jm),_i=n(q),Za=r(q,"OL",{"data-svelte-h":!0}),m(Za)!=="svelte-15y6o6y"&&(Za.innerHTML=Zm),xi=n(q),Xa=r(q,"P",{"data-svelte-h":!0}),m(Xa)!=="svelte-1yvkj2h"&&(Xa.innerHTML=Xm),$i=n(q),Ja=r(q,"P",{"data-svelte-h":!0}),m(Ja)!=="svelte-53x1ow"&&(Ja.innerHTML=Jm),yi=n(q),ue=r(q,"DIV",{class:!0});var Co=s(ue);c(yt.$$.fragment,Co),wi=n(Co),Ya=r(Co,"P",{"data-svelte-h":!0}),m(Ya)!=="svelte-1gr03w4"&&(Ya.textContent=Ym),Co.forEach(i),q.forEach(i),jr=n(e),wt=r(e,"DIV",{class:!0});var bl=s(wt);c(Ct.$$.fragment,bl),bl.forEach(i),Zr=n(e),X=r(e,"DIV",{class:!0});var Ao=s(X);c(At.$$.fragment,Ao),Ci=n(Ao),fe=r(Ao,"DIV",{class:!0});var Lo=s(fe);c(Lt.$$.fragment,Lo),Ai=n(Lo),er=r(Lo,"P",{"data-svelte-h":!0}),m(er)!=="svelte-1gr03w4"&&(er.textContent=el),Lo.forEach(i),Ao.forEach(i),Xr=n(e),c(Tt.$$.fragment,e),Jr=n(e),$r=r(e,"P",{}),s($r).forEach(i),this.h()},h(){v(Z,"name","hf:doc:metadata"),v(Z,"content",Tl),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,Z),p(e,yr,l),p(e,ir,l),p(e,wr,l),g(ve,e,l),p(e,Cr,l),p(e,be,l),p(e,Ar,l),g(_e,e,l),p(e,Lr,l),g(xe,e,l),p(e,Tr,l),p(e,_,l),g($e,_,null),t(_,To),t(_,zt),t(_,zo),t(_,Dt),t(_,Do),t(_,qt),t(_,qo),t(_,mr),t(mr,lr),t(lr,ye),g(we,ye,null),t(ye,Po),t(ye,Pt),t(_,Mo),t(_,sr),t(sr,pr),t(pr,Ce),g(Ae,Ce,null),t(Ce,ko),t(Ce,Mt),t(_,Eo),t(_,dr),t(dr,cr),t(cr,Le),g(Te,Le,null),t(Le,No),t(Le,kt),t(_,Oo),t(_,gr),t(gr,ur),t(ur,ze),g(De,ze,null),t(ze,Io),t(ze,Et),t(_,Fo),t(_,Nt),t(_,Ho),t(_,Ot),p(e,zr,l),p(e,x,l),g(qe,x,null),t(x,Bo),t(x,It),t(x,Ro),t(x,Ft),t(x,Go),t(x,Ht),t(x,So),t(x,Bt),t(x,Vo),t(x,Rt),t(x,Wo),t(x,Gt),t(x,Uo),t(x,St),p(e,Dr,l),p(e,w,l),g(Pe,w,null),t(w,Qo),t(w,Vt),t(w,Ko),t(w,Wt),t(w,jo),t(w,Ut),t(w,Zo),t(w,fr),t(fr,hr),t(hr,Me),g(ke,Me,null),t(Me,Xo),t(Me,Qt),t(w,Jo),t(w,vr),t(vr,br),t(br,Ee),g(Ne,Ee,null),t(Ee,Yo),t(Ee,Kt),t(w,en),t(w,_r),t(_r,xr),t(xr,Oe),g(Ie,Oe,null),t(Oe,tn),t(Oe,jt),p(e,qr,l),g(Fe,e,l),p(e,Pr,l),p(e,A,l),g(He,A,null),t(A,an),t(A,Zt),t(A,rn),t(A,Xt),t(A,on),t(A,Jt),t(A,nn),t(A,Yt),t(A,mn),t(A,J),g(Be,J,null),t(J,ln),t(J,ea),p(e,Mr,l),p(e,L,l),g(Re,L,null),t(L,sn),t(L,ta),t(L,pn),t(L,aa),t(L,dn),t(L,ra),t(L,cn),t(L,oa),t(L,gn),t(L,Y),g(Ge,Y,null),t(Y,un),t(Y,na),p(e,kr,l),p(e,R,l),g(Se,R,null),t(R,fn),t(R,ia),t(R,hn),t(R,ma),p(e,Er,l),p(e,T,l),g(Ve,T,null),t(T,vn),t(T,la),t(T,bn),t(T,ee),g(We,ee,null),t(ee,_n),t(ee,sa),t(T,xn),t(T,te),g(Ue,te,null),t(te,$n),t(te,pa),t(T,yn),t(T,ae),g(Qe,ae,null),t(ae,wn),t(ae,da),t(T,Cn),t(T,re),g(Ke,re,null),t(re,An),t(re,ca),p(e,Nr,l),p(e,je,l),g(Ze,je,null),p(e,Or,l),p(e,P,l),g(Xe,P,null),t(P,Ln),t(P,ga),t(P,Tn),t(P,ua),t(P,zn),t(P,fa),t(P,Dn),t(P,oe),g(Je,oe,null),t(oe,qn),t(oe,ha),p(e,Ir,l),p(e,G,l),g(Ye,G,null),t(G,Pn),t(G,va),t(G,Mn),t(G,ne),g(et,ne,null),t(ne,kn),t(ne,ba),p(e,Fr,l),p(e,S,l),g(tt,S,null),t(S,En),t(S,_a),t(S,Nn),t(S,ie),g(at,ie,null),t(ie,On),t(ie,xa),p(e,Hr,l),p(e,M,l),g(rt,M,null),t(M,In),t(M,$a),t(M,Fn),t(M,ya),t(M,Hn),t(M,wa),t(M,Bn),t(M,me),g(ot,me,null),t(me,Rn),t(me,Ca),p(e,Br,l),p(e,O,l),g(nt,O,null),t(O,Gn),t(O,Aa),t(O,Sn),t(O,La),t(O,Vn),t(O,le),g(it,le,null),t(le,Wn),t(le,Ta),p(e,Rr,l),p(e,V,l),g(mt,V,null),t(V,Un),t(V,za),t(V,Qn),t(V,se),g(lt,se,null),t(se,Kn),t(se,Da),p(e,Gr,l),p(e,st,l),g(pt,st,null),p(e,Sr,l),p(e,C,l),g(dt,C,null),t(C,jn),t(C,qa),t(C,Zn),t(C,Pa),t(C,Xn),t(C,Ma),t(C,Jn),t(C,ka),t(C,Yn),t(C,Ea),t(C,ei),t(C,pe),g(ct,pe,null),t(pe,ti),t(pe,Na),p(e,Vr,l),p(e,z,l),g(gt,z,null),t(z,ai),t(z,Oa),t(z,ri),t(z,Ia),t(z,oi),t(z,Fa),t(z,ni),t(z,Ha),t(z,ii),t(z,de),g(ut,de,null),t(de,mi),t(de,Ba),p(e,Wr,l),p(e,k,l),g(ft,k,null),t(k,li),t(k,Ra),t(k,si),t(k,Ga),t(k,pi),t(k,Sa),t(k,di),t(k,ce),g(ht,ce,null),t(ce,ci),t(ce,Va),p(e,Ur,l),p(e,W,l),g(vt,W,null),t(W,gi),t(W,Wa),t(W,ui),t(W,ge),g(bt,ge,null),t(ge,fi),t(ge,Ua),p(e,Qr,l),p(e,_t,l),g(xt,_t,null),p(e,Kr,l),p(e,$,l),g($t,$,null),t($,hi),t($,Qa),t($,vi),t($,Ka),t($,bi),t($,ja),t($,_i),t($,Za),t($,xi),t($,Xa),t($,$i),t($,Ja),t($,yi),t($,ue),g(yt,ue,null),t(ue,wi),t(ue,Ya),p(e,jr,l),p(e,wt,l),g(Ct,wt,null),p(e,Zr,l),p(e,X,l),g(At,X,null),t(X,Ci),t(X,fe),g(Lt,fe,null),t(fe,Ai),t(fe,er),p(e,Xr,l),g(Tt,e,l),p(e,Jr,l),p(e,$r,l),Yr=!0},p:xl,i(e){Yr||(u(ve.$$.fragment,e),u(_e.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(we.$$.fragment,e),u(Ae.$$.fragment,e),u(Te.$$.fragment,e),u(De.$$.fragment,e),u(qe.$$.fragment,e),u(Pe.$$.fragment,e),u(ke.$$.fragment,e),u(Ne.$$.fragment,e),u(Ie.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Ve.$$.fragment,e),u(We.$$.fragment,e),u(Ue.$$.fragment,e),u(Qe.$$.fragment,e),u(Ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(rt.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(mt.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(ht.$$.fragment,e),u(vt.$$.fragment,e),u(bt.$$.fragment,e),u(xt.$$.fragment,e),u($t.$$.fragment,e),u(yt.$$.fragment,e),u(Ct.$$.fragment,e),u(At.$$.fragment,e),u(Lt.$$.fragment,e),u(Tt.$$.fragment,e),Yr=!0)},o(e){f(ve.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Ae.$$.fragment,e),f(Te.$$.fragment,e),f(De.$$.fragment,e),f(qe.$$.fragment,e),f(Pe.$$.fragment,e),f(ke.$$.fragment,e),f(Ne.$$.fragment,e),f(Ie.$$.fragment,e),f(Fe.$$.fragment,e),f(He.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Ve.$$.fragment,e),f(We.$$.fragment,e),f(Ue.$$.fragment,e),f(Qe.$$.fragment,e),f(Ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Je.$$.fragment,e),f(Ye.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(it.$$.fragment,e),f(mt.$$.fragment,e),f(lt.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(vt.$$.fragment,e),f(bt.$$.fragment,e),f(xt.$$.fragment,e),f($t.$$.fragment,e),f(yt.$$.fragment,e),f(Ct.$$.fragment,e),f(At.$$.fragment,e),f(Lt.$$.fragment,e),f(Tt.$$.fragment,e),Yr=!1},d(e){e&&(i(yr),i(ir),i(wr),i(Cr),i(be),i(Ar),i(Lr),i(Tr),i(_),i(zr),i(x),i(Dr),i(w),i(qr),i(Pr),i(A),i(Mr),i(L),i(kr),i(R),i(Er),i(T),i(Nr),i(je),i(Or),i(P),i(Ir),i(G),i(Fr),i(S),i(Hr),i(M),i(Br),i(O),i(Rr),i(V),i(Gr),i(st),i(Sr),i(C),i(Vr),i(z),i(Wr),i(k),i(Ur),i(W),i(Qr),i(_t),i(Kr),i($),i(jr),i(wt),i(Zr),i(X),i(Xr),i(Jr),i($r)),i(Z),h(ve,e),h(_e,e),h(xe,e),h($e),h(we),h(Ae),h(Te),h(De),h(qe),h(Pe),h(ke),h(Ne),h(Ie),h(Fe,e),h(He),h(Be),h(Re),h(Ge),h(Se),h(Ve),h(We),h(Ue),h(Qe),h(Ke),h(Ze),h(Xe),h(Je),h(Ye),h(et),h(tt),h(at),h(rt),h(ot),h(nt),h(it),h(mt),h(lt),h(pt),h(dt),h(ct),h(gt),h(ut),h(ft),h(ht),h(vt),h(bt),h(xt),h($t),h(yt),h(Ct),h(At),h(Lt),h(Tt,e)}}}const Tl='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer_v2","sections":[],"depth":3}],"depth":2}],"depth":1}';function zl(Li){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends yl{constructor(Z){super(),wl(this,Z,zl,Ll,_l,{})}}export{kl as component};
