import{s as Jt,o as $t,n as Ye}from"../chunks/scheduler.8c3d61f6.js";import{S as jt,i as At,g as r,s,r as g,A as Ut,h as l,f as n,c as o,j as ue,u,x as d,k as fe,y as v,a,v as f,d as h,t as _,w as b}from"../chunks/index.589a98e8.js";import{T as tt}from"../chunks/Tip.42aa8582.js";import{D as nt}from"../chunks/Docstring.27406313.js";import{C as pe}from"../chunks/CodeBlock.36627b28.js";import{E as It}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as at,E as Ct}from"../chunks/EditOnGithub.e5a8d9cb.js";function kt(P){let i,w='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){i=r("p"),i.innerHTML=w},l(p){i=l(p,"P",{"data-svelte-h":!0}),d(i)!=="svelte-1qn15hi"&&(i.innerHTML=w)},m(p,c){a(p,i,c)},p:Ye,d(p){p&&n(i)}}}function St(P){let i,w="Notice that while initializing <code>pipe</code>, you’re setting <code>text_encoder</code> to <code>None</code> so that it’s not loaded.";return{c(){i=r("p"),i.innerHTML=w},l(p){i=l(p,"P",{"data-svelte-h":!0}),d(i)!=="svelte-1of5pjk"&&(i.innerHTML=w)},m(p,c){a(p,i,c)},p:Ye,d(p){p&&n(i)}}}function Bt(P){let i,w="Text embeddings computed in 8-bit can impact the quality of the generated images because of the information loss in the representation space caused by the reduced precision. It’s recommended to compare the outputs with and without 8-bit.";return{c(){i=r("p"),i.textContent=w},l(p){i=l(p,"P",{"data-svelte-h":!0}),d(i)!=="svelte-1rutysd"&&(i.textContent=w)},m(p,c){a(p,i,c)},p:Ye,d(p){p&&n(i)}}}function Gt(P){let i,w="Examples:",p,c,M;return c=new pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUGl4QXJ0U2lnbWFQaXBlbGluZSUwQSUwQSUyMyUyMFlvdSUyMGNhbiUyMHJlcGxhY2UlMjB0aGUlMjBjaGVja3BvaW50JTIwaWQlMjB3aXRoJTIwJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVNpZ21hLVhMLTItNTEyLU1TJTIyJTIwdG9vLiUwQXBpcGUlMjAlM0QlMjBQaXhBcnRTaWdtYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQSUyMyUyMEVuYWJsZSUyMG1lbW9yeSUyMG9wdGltaXphdGlvbnMuJTBBJTIzJTIwcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBzbWFsbCUyMGNhY3R1cyUyMHdpdGglMjBhJTIwaGFwcHklMjBmYWNlJTIwaW4lMjB0aGUlMjBTYWhhcmElMjBkZXNlcnQuJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtSigmaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can replace the checkpoint id with &quot;PixArt-alpha/PixArt-Sigma-XL-2-512-MS&quot; too.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PixArtSigmaPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable memory optimizations.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pipe.enable_model_cpu_offload()</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=r("p"),i.textContent=w,p=s(),g(c.$$.fragment)},l(m){i=l(m,"P",{"data-svelte-h":!0}),d(i)!=="svelte-kvfsh7"&&(i.textContent=w),p=o(m),u(c.$$.fragment,m)},m(m,T){a(m,i,T),a(m,p,T),f(c,m,T),M=!0},p:Ye,i(m){M||(h(c.$$.fragment,m),M=!0)},o(m){_(c.$$.fragment,m),M=!1},d(m){m&&(n(i),n(p)),b(c,m)}}}function Zt(P){let i,w,p,c,M,m,T,it='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/header_collage_sigma.jpg"/>',he,k,st='<a href="https://huggingface.co/papers/2403.04692" rel="nofollow">PixArt-Σ: Weak-to-Strong Training of Diffusion Transformer for 4K Text-to-Image Generation</a> is Junsong Chen, Jincheng Yu, Chongjian Ge, Lewei Yao, Enze Xie, Yue Wu, Zhongdao Wang, James Kwok, Ping Luo, Huchuan Lu, and Zhenguo Li.',_e,S,ot="The abstract from the paper is:",be,B,rt="<em>In this paper, we introduce PixArt-Σ, a Diffusion Transformer model (DiT) capable of directly generating images at 4K resolution. PixArt-Σ represents a significant advancement over its predecessor, PixArt-α, offering images of markedly higher fidelity and improved alignment with text prompts. A key feature of PixArt-Σ is its training efficiency. Leveraging the foundational pre-training of PixArt-α, it evolves from the ‘weaker’ baseline to a ‘stronger’ model via incorporating higher quality data, a process we term “weak-to-strong training”. The advancements in PixArt-Σ are twofold: (1) High-Quality Training Data: PixArt-Σ incorporates superior-quality image data, paired with more precise and detailed image captions. (2) Efficient Token Compression: we propose a novel attention module within the DiT framework that compresses both keys and values, significantly improving efficiency and facilitating ultra-high-resolution image generation. Thanks to these improvements, PixArt-Σ achieves superior image quality and user prompt adherence capabilities with significantly smaller model size (0.6B parameters) than existing text-to-image diffusion models, such as SDXL (2.6B parameters) and SD Cascade (5.1B parameters). Moreover, PixArt-Σ’s capability to generate 4K images supports the creation of high-resolution posters and wallpapers, efficiently bolstering the production of highquality visual content in industries such as film and gaming.</em>",we,G,lt='You can find the original codebase at <a href="https://github.com/PixArt-alpha/PixArt-sigma" rel="nofollow">PixArt-alpha/PixArt-sigma</a> and all the available checkpoints at <a href="https://huggingface.co/PixArt-alpha" rel="nofollow">PixArt-alpha</a>.',xe,Z,pt="Some notes about this pipeline:",Me,W,dt='<li>It uses a Transformer backbone (instead of a UNet) for denoising. As such it has a similar architecture as <a href="https://hf.co/docs/transformers/model_doc/dit" rel="nofollow">DiT</a>.</li> <li>It was trained using text conditions computed from T5. This aspect makes the pipeline better at following complex text prompts with intricate details.</li> <li>It is good at producing high-resolution images at different aspect ratios. To get the best results, the authors recommend some size brackets which can be found <a href="https://github.com/PixArt-alpha/PixArt-sigma/blob/master/diffusion/data/datasets/utils.py" rel="nofollow">here</a>.</li> <li>It rivals the quality of state-of-the-art text-to-image generation systems (as of this writing) such as PixArt-α, Stable Diffusion XL, Playground V2.0 and DALL-E 3, while being more efficient than them.</li> <li>It shows the ability of generating super high resolution images, such as 2048px or even 4K.</li> <li>It shows that text-to-image models can grow from a weak model to a stronger one through several improvements (VAEs, datasets, and so on.)</li>',ve,j,Te,L,ye,H,mt='Run the <a href="/docs/diffusers/pr_8449/en/api/pipelines/pixart_sigma#diffusers.PixArtSigmaPipeline">PixArtSigmaPipeline</a> with under 8GB GPU VRAM by loading the text encoder in 8-bit precision. Let’s walk through a full-fledged example.',Pe,V,ct='First, install the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library:',Je,E,$e,X,gt="Then load the text encoder in 8-bit:",je,R,Ae,Q,ut="Now, use the <code>pipe</code> to encode a prompt:",Ue,q,Ie,N,ft="Since text embeddings have been computed, remove the <code>text_encoder</code> and <code>pipe</code> from the memory, and free up some GPU VRAM:",Ce,Y,ke,D,ht="Then compute the latents with the prompt embeddings as inputs:",Se,F,Be,A,Ge,z,_t="Once the latents are computed, pass it off to the VAE to decode into a real image:",Ze,O,We,K,bt='By deleting components you aren’t using and flushing the GPU VRAM, you should be able to run <a href="/docs/diffusers/pr_8449/en/api/pipelines/pixart_sigma#diffusers.PixArtSigmaPipeline">PixArtSigmaPipeline</a> with under 8GB GPU VRAM.',Le,ee,wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/8bits_cat.png"/>',He,te,xt='If you want a report of your memory-usage, run this <a href="https://gist.github.com/sayakpaul/3ae0f847001d342af27018a96f467e4e" rel="nofollow">script</a>.',Ve,U,Ee,ne,Mt="While loading the <code>text_encoder</code>, you set <code>load_in_8bit</code> to <code>True</code>. You could also specify <code>load_in_4bit</code> to bring your memory requirements down even further to under 7GB.",Xe,ae,Re,x,ie,De,de,vt="Pipeline for text-to-image generation using PixArt-Sigma.",Fe,J,se,ze,me,Tt="Function invoked when calling the pipeline for generation.",Oe,I,Ke,C,oe,et,ce,yt="Encodes the prompt into text encoder hidden states.",Qe,re,qe,ge,Ne;return M=new at({props:{title:"PixArt-Σ",local:"pixart-σ",headingTag:"h1"}}),j=new tt({props:{$$slots:{default:[kt]},$$scope:{ctx:P}}}),L=new at({props:{title:"Inference with under 8GB GPU VRAM",local:"inference-with-under-8gb-gpu-vram",headingTag:"h2"}}),E=new pe({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes",wrap:!1}}),R=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFBpeEFydFNpZ21hUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBQaXhBcnRTaWdtYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtU2lnbWEtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtSigmaPipeline
<span class="hljs-keyword">import</span> torch

text_encoder = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
pipe = PixArtSigmaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    text_encoder=text_encoder,
    transformer=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>
)`,wrap:!1}}),q=new pe({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmN1dGUlMjBjYXQlMjIlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcHJvbXB0X2F0dGVudGlvbl9tYXNrJTJDJTIwbmVnYXRpdmVfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2F0dGVudGlvbl9tYXNrJTIwJTNEJTIwcGlwZS5lbmNvZGVfcHJvbXB0KHByb21wdCk=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    prompt = <span class="hljs-string">&quot;cute cat&quot;</span>
    prompt_embeds, prompt_attention_mask, negative_embeds, negative_prompt_attention_mask = pipe.encode_prompt(prompt)`,wrap:!1}}),Y=new pe({props:{code:"aW1wb3J0JTIwZ2MlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTBBZGVsJTIwdGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZSUwQWZsdXNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gc

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()

<span class="hljs-keyword">del</span> text_encoder
<span class="hljs-keyword">del</span> pipe
flush()`,wrap:!1}}),F=new pe({props:{code:"cGlwZSUyMCUzRCUyMFBpeEFydFNpZ21hUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlBpeEFydC1hbHBoYSUyRlBpeEFydC1TaWdtYS1YTC0yLTEwMjQtTVMlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWxhdGVudHMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfYXR0ZW50aW9uX21hc2slM0Rwcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slM0RuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIlMkMlMEEpLmltYWdlcyUwQSUwQWRlbCUyMHBpcGUudHJhbnNmb3JtZXIlMEFmbHVzaCgp",highlighted:`pipe = PixArtSigmaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-Sigma-XL-2-1024-MS&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

latents = pipe(
    negative_prompt=<span class="hljs-literal">None</span>,
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    prompt_attention_mask=prompt_attention_mask,
    negative_prompt_attention_mask=negative_prompt_attention_mask,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images

<span class="hljs-keyword">del</span> pipe.transformer
flush()`,wrap:!1}}),A=new tt({props:{$$slots:{default:[St]},$$scope:{ctx:P}}}),O=new pe({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZS52YWUuZGVjb2RlKGxhdGVudHMlMjAlMkYlMjBwaXBlLnZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSU1QjAlNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    image = pipe.vae.decode(latents / pipe.vae.config.scaling_factor, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
image = pipe.image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),U=new tt({props:{warning:!0,$$slots:{default:[Bt]},$$scope:{ctx:P}}}),ae=new at({props:{title:"PixArtSigmaPipeline",local:"diffusers.PixArtSigmaPipeline",headingTag:"h2"}}),ie=new nt({props:{name:"class diffusers.PixArtSigmaPipeline",anchor:"diffusers.PixArtSigmaPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKL"},{name:"transformer",val:": PixArtTransformer2DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],source:"https://github.com/huggingface/diffusers/blob/vr_8449/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L176"}}),se=new nt({props:{name:"__call__",anchor:"diffusers.PixArtSigmaPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": List = None"},{name:"sigmas",val:": List = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"max_sequence_length",val:": int = 300"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_8449/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.PixArtSigmaPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 300) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_8449/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L609",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_8449/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_8449/en/api/pipelines/ddpm#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),I=new It({props:{anchor:"diffusers.PixArtSigmaPipeline.__call__.example",$$slots:{default:[Gt]},$$scope:{ctx:P}}}),oe=new nt({props:{name:"encode_prompt",anchor:"diffusers.PixArtSigmaPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha, it&#x2019;s should be the embeddings of the &quot;&quot;
string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.PixArtSigmaPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/vr_8449/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_sigma.py#L218"}}),re=new Ct({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/pixart_sigma.md"}}),{c(){i=r("meta"),w=s(),p=r("p"),c=s(),g(M.$$.fragment),m=s(),T=r("p"),T.innerHTML=it,he=s(),k=r("p"),k.innerHTML=st,_e=s(),S=r("p"),S.textContent=ot,be=s(),B=r("p"),B.innerHTML=rt,we=s(),G=r("p"),G.innerHTML=lt,xe=s(),Z=r("p"),Z.textContent=pt,Me=s(),W=r("ul"),W.innerHTML=dt,ve=s(),g(j.$$.fragment),Te=s(),g(L.$$.fragment),ye=s(),H=r("p"),H.innerHTML=mt,Pe=s(),V=r("p"),V.innerHTML=ct,Je=s(),g(E.$$.fragment),$e=s(),X=r("p"),X.textContent=gt,je=s(),g(R.$$.fragment),Ae=s(),Q=r("p"),Q.innerHTML=ut,Ue=s(),g(q.$$.fragment),Ie=s(),N=r("p"),N.innerHTML=ft,Ce=s(),g(Y.$$.fragment),ke=s(),D=r("p"),D.textContent=ht,Se=s(),g(F.$$.fragment),Be=s(),g(A.$$.fragment),Ge=s(),z=r("p"),z.textContent=_t,Ze=s(),g(O.$$.fragment),We=s(),K=r("p"),K.innerHTML=bt,Le=s(),ee=r("p"),ee.innerHTML=wt,He=s(),te=r("p"),te.innerHTML=xt,Ve=s(),g(U.$$.fragment),Ee=s(),ne=r("p"),ne.innerHTML=Mt,Xe=s(),g(ae.$$.fragment),Re=s(),x=r("div"),g(ie.$$.fragment),De=s(),de=r("p"),de.textContent=vt,Fe=s(),J=r("div"),g(se.$$.fragment),ze=s(),me=r("p"),me.textContent=Tt,Oe=s(),g(I.$$.fragment),Ke=s(),C=r("div"),g(oe.$$.fragment),et=s(),ce=r("p"),ce.textContent=yt,Qe=s(),g(re.$$.fragment),qe=s(),ge=r("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);i=l(t,"META",{name:!0,content:!0}),t.forEach(n),w=o(e),p=l(e,"P",{}),ue(p).forEach(n),c=o(e),u(M.$$.fragment,e),m=o(e),T=l(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1h02zzr"&&(T.innerHTML=it),he=o(e),k=l(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1i25npg"&&(k.innerHTML=st),_e=o(e),S=l(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1cwsb16"&&(S.textContent=ot),be=o(e),B=l(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-12smxu3"&&(B.innerHTML=rt),we=o(e),G=l(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-8e6u65"&&(G.innerHTML=lt),xe=o(e),Z=l(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-v1sn1g"&&(Z.textContent=pt),Me=o(e),W=l(e,"UL",{"data-svelte-h":!0}),d(W)!=="svelte-8ca6jo"&&(W.innerHTML=dt),ve=o(e),u(j.$$.fragment,e),Te=o(e),u(L.$$.fragment,e),ye=o(e),H=l(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-juq3tu"&&(H.innerHTML=mt),Pe=o(e),V=l(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-c2h3fb"&&(V.innerHTML=ct),Je=o(e),u(E.$$.fragment,e),$e=o(e),X=l(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-5r7318"&&(X.textContent=gt),je=o(e),u(R.$$.fragment,e),Ae=o(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-rj1jgt"&&(Q.innerHTML=ut),Ue=o(e),u(q.$$.fragment,e),Ie=o(e),N=l(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1ux3xow"&&(N.innerHTML=ft),Ce=o(e),u(Y.$$.fragment,e),ke=o(e),D=l(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-w3d4de"&&(D.textContent=ht),Se=o(e),u(F.$$.fragment,e),Be=o(e),u(A.$$.fragment,e),Ge=o(e),z=l(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1yf7wfg"&&(z.textContent=_t),Ze=o(e),u(O.$$.fragment,e),We=o(e),K=l(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-13hbz43"&&(K.innerHTML=bt),Le=o(e),ee=l(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1g55ccf"&&(ee.innerHTML=wt),He=o(e),te=l(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-11lvu0m"&&(te.innerHTML=xt),Ve=o(e),u(U.$$.fragment,e),Ee=o(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1i82z60"&&(ne.innerHTML=Mt),Xe=o(e),u(ae.$$.fragment,e),Re=o(e),x=l(e,"DIV",{class:!0});var y=ue(x);u(ie.$$.fragment,y),De=o(y),de=l(y,"P",{"data-svelte-h":!0}),d(de)!=="svelte-bjkp5a"&&(de.textContent=vt),Fe=o(y),J=l(y,"DIV",{class:!0});var $=ue(J);u(se.$$.fragment,$),ze=o($),me=l($,"P",{"data-svelte-h":!0}),d(me)!=="svelte-v78lg8"&&(me.textContent=Tt),Oe=o($),u(I.$$.fragment,$),$.forEach(n),Ke=o(y),C=l(y,"DIV",{class:!0});var le=ue(C);u(oe.$$.fragment,le),et=o(le),ce=l(le,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-16q0ax1"&&(ce.textContent=yt),le.forEach(n),y.forEach(n),Qe=o(e),u(re.$$.fragment,e),qe=o(e),ge=l(e,"P",{}),ue(ge).forEach(n),this.h()},h(){fe(i,"name","hf:doc:metadata"),fe(i,"content",Wt),fe(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),fe(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),fe(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){v(document.head,i),a(e,w,t),a(e,p,t),a(e,c,t),f(M,e,t),a(e,m,t),a(e,T,t),a(e,he,t),a(e,k,t),a(e,_e,t),a(e,S,t),a(e,be,t),a(e,B,t),a(e,we,t),a(e,G,t),a(e,xe,t),a(e,Z,t),a(e,Me,t),a(e,W,t),a(e,ve,t),f(j,e,t),a(e,Te,t),f(L,e,t),a(e,ye,t),a(e,H,t),a(e,Pe,t),a(e,V,t),a(e,Je,t),f(E,e,t),a(e,$e,t),a(e,X,t),a(e,je,t),f(R,e,t),a(e,Ae,t),a(e,Q,t),a(e,Ue,t),f(q,e,t),a(e,Ie,t),a(e,N,t),a(e,Ce,t),f(Y,e,t),a(e,ke,t),a(e,D,t),a(e,Se,t),f(F,e,t),a(e,Be,t),f(A,e,t),a(e,Ge,t),a(e,z,t),a(e,Ze,t),f(O,e,t),a(e,We,t),a(e,K,t),a(e,Le,t),a(e,ee,t),a(e,He,t),a(e,te,t),a(e,Ve,t),f(U,e,t),a(e,Ee,t),a(e,ne,t),a(e,Xe,t),f(ae,e,t),a(e,Re,t),a(e,x,t),f(ie,x,null),v(x,De),v(x,de),v(x,Fe),v(x,J),f(se,J,null),v(J,ze),v(J,me),v(J,Oe),f(I,J,null),v(x,Ke),v(x,C),f(oe,C,null),v(C,et),v(C,ce),a(e,Qe,t),f(re,e,t),a(e,qe,t),a(e,ge,t),Ne=!0},p(e,[t]){const y={};t&2&&(y.$$scope={dirty:t,ctx:e}),j.$set(y);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),A.$set($);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),U.$set(le);const Pt={};t&2&&(Pt.$$scope={dirty:t,ctx:e}),I.$set(Pt)},i(e){Ne||(h(M.$$.fragment,e),h(j.$$.fragment,e),h(L.$$.fragment,e),h(E.$$.fragment,e),h(R.$$.fragment,e),h(q.$$.fragment,e),h(Y.$$.fragment,e),h(F.$$.fragment,e),h(A.$$.fragment,e),h(O.$$.fragment,e),h(U.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(I.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),Ne=!0)},o(e){_(M.$$.fragment,e),_(j.$$.fragment,e),_(L.$$.fragment,e),_(E.$$.fragment,e),_(R.$$.fragment,e),_(q.$$.fragment,e),_(Y.$$.fragment,e),_(F.$$.fragment,e),_(A.$$.fragment,e),_(O.$$.fragment,e),_(U.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(I.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),Ne=!1},d(e){e&&(n(w),n(p),n(c),n(m),n(T),n(he),n(k),n(_e),n(S),n(be),n(B),n(we),n(G),n(xe),n(Z),n(Me),n(W),n(ve),n(Te),n(ye),n(H),n(Pe),n(V),n(Je),n($e),n(X),n(je),n(Ae),n(Q),n(Ue),n(Ie),n(N),n(Ce),n(ke),n(D),n(Se),n(Be),n(Ge),n(z),n(Ze),n(We),n(K),n(Le),n(ee),n(He),n(te),n(Ve),n(Ee),n(ne),n(Xe),n(Re),n(x),n(Qe),n(qe),n(ge)),n(i),b(M,e),b(j,e),b(L,e),b(E,e),b(R,e),b(q,e),b(Y,e),b(F,e),b(A,e),b(O,e),b(U,e),b(ae,e),b(ie),b(se),b(I),b(oe),b(re,e)}}}const Wt='{"title":"PixArt-Σ","local":"pixart-σ","sections":[{"title":"Inference with under 8GB GPU VRAM","local":"inference-with-under-8gb-gpu-vram","sections":[],"depth":2},{"title":"PixArtSigmaPipeline","local":"diffusers.PixArtSigmaPipeline","sections":[],"depth":2}],"depth":1}';function Lt(P){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends jt{constructor(i){super(),At(this,i,Lt,Zt,Jt,{})}}export{Nt as component};
