import{s as _e,n as Te,o as ke}from"../chunks/scheduler.a2b4ca8e.js";import{S as xe,i as Pe,g as a,s as l,r as V,A as Ce,h as r,f as o,c as n,j as be,u as X,x as s,k as we,y as Le,a as i,v as Y,d as ee,t as te,w as oe}from"../chunks/index.f6e1d51d.js";import{C as je}from"../chunks/CodeBlock.9607aa3b.js";import{H as ye,E as $e}from"../chunks/EditOnGithub.d27dc01b.js";function Me(ie){let d,M,j,O,c,H,p,le=`As reinforcement learning algorithms are historically challenging to debug, it’s important to pay careful attention to logging.
By default, the TRL <a href="/docs/trl/pr_1743/en/trainer#trl.PPOTrainer">PPOTrainer</a> saves a lot of relevant information to <code>wandb</code> or <code>tensorboard</code>.`,q,h,ne='Upon initialization, pass one of these two options to the <a href="/docs/trl/pr_1743/en/trainer#trl.PPOConfig">PPOConfig</a>:',z,m,U,f,ae="If you want to log with tensorboard, add the kwarg <code>project_kwargs={&quot;logging_dir&quot;: PATH_TO_LOGS}</code> to the PPOConfig.",A,u,K,g,re="Here’s a brief explanation for the logged metrics provided in the data:",E,v,se="Key metrics to monitor. We want to maximize the reward, maintain a low KL divergence, and maximize entropy:",I,b,de="<li><code>env/reward_mean</code>: The average reward obtained from the environment. Alias <code>ppo/mean_scores</code>, which is sed to specifically monitor the reward model.</li> <li><code>env/reward_std</code>: The standard deviation of the reward obtained from the environment. Alias `<code>ppo/std_scores</code>, which is sed to specifically monitor the reward model.</li> <li><code>env/reward_dist</code>: The histogram distribution of the reward obtained from the environment.</li> <li><code>objective/kl</code>: The mean Kullback-Leibler (KL) divergence between the old and new policies. It measures how much the new policy deviates from the old policy. The KL divergence is used to compute the KL penalty in the objective function.</li> <li><code>objective/kl_dist</code>: The histogram distribution of the <code>objective/kl</code>.</li> <li><code>objective/kl_coef</code>: The coefficient for Kullback-Leibler (KL) divergence in the objective function.</li> <li><code>ppo/mean_non_score_reward</code>: The <strong>KL penalty</strong> calculated by <code>objective/kl * objective/kl_coef</code> as the total reward for optimization to prevent the new policy from deviating too far from the old policy.</li> <li><code>objective/entropy</code>: The entropy of the model’s policy, calculated by <code>-logprobs.sum(-1).mean()</code>. High entropy means the model’s actions are more random, which can be beneficial for exploration.</li>",J,w,ce="Training stats:",S,y,pe='<li><code>ppo/learning_rate</code>: The learning rate for the PPO algorithm.</li> <li><code>ppo/policy/entropy</code>: The entropy of the model’s policy, calculated by <code>pd = torch.nn.functional.softmax(logits, dim=-1); entropy = torch.logsumexp(logits, dim=-1) - torch.sum(pd * logits, dim=-1)</code>. It measures the randomness of the policy.</li> <li><code>ppo/policy/clipfrac</code>: The fraction of probability ratios (old policy / new policy) that fell outside the clipping range in the PPO objective. This can be used to monitor the optimization process.</li> <li><code>ppo/policy/approxkl</code>: The approximate KL divergence between the old and new policies, measured by <code>0.5 * masked_mean((logprobs - old_logprobs) ** 2, mask)</code>, corresponding to the <code>k2</code> estimator in <a href="http://joschu.net/blog/kl-approx.html" rel="nofollow">http://joschu.net/blog/kl-approx.html</a></li> <li><code>ppo/policy/policykl</code>: Similar to <code>ppo/policy/approxkl</code>, but measured by <code>masked_mean(old_logprobs - logprobs, mask)</code>, corresponding to the <code>k1</code> estimator in <a href="http://joschu.net/blog/kl-approx.html" rel="nofollow">http://joschu.net/blog/kl-approx.html</a></li> <li><code>ppo/policy/ratio</code>:  The histogram distribution of the ratio between the new and old policies, used to compute the PPO objective.</li> <li><code>ppo/policy/advantages_mean</code>: The average of the GAE (Generalized Advantage Estimation) advantage estimates. The advantage function measures how much better an action is compared to the average action at a state.</li> <li><code>ppo/policy/advantages</code>: The histogram distribution of <code>ppo/policy/advantages_mean</code>.</li> <li><code>ppo/returns/mean</code>: The mean of the TD(λ) returns, calculated by <code>returns = advantage + values</code>, another indicator of model performance. See <a href="https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/" rel="nofollow">https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/</a> for more details.</li> <li><code>ppo/returns/var</code>: The variance of the TD(λ) returns, calculated by <code>returns = advantage + values</code>, another indicator of model performance.</li> <li><code>ppo/val/mean</code>: The mean of the values, used to monitor the value function’s performance.</li> <li><code>ppo/val/var</code> : The variance of the values, used to monitor the value function’s performance.</li> <li><code>ppo/val/var_explained</code>: The explained variance for the value function, used to monitor the value function’s performance.</li> <li><code>ppo/val/clipfrac</code>: The fraction of the value function’s predicted values that are clipped.</li> <li><code>ppo/val/vpred</code>: The predicted values from the value function.</li> <li><code>ppo/val/error</code>: The mean squared error between the <code>ppo/val/vpred</code> and returns, used to monitor the value function’s performance.</li> <li><code>ppo/loss/policy</code>: The policy loss for the Proximal Policy Optimization (PPO) algorithm.</li> <li><code>ppo/loss/value</code>: The loss for the value function in the PPO algorithm. This value quantifies how well the function estimates the expected future rewards.</li> <li><code>ppo/loss/total</code>: The total loss for the PPO algorithm. It is the sum of the policy loss and the value function loss.</li>',G,_,he="Stats on queries, responses, and logprobs:",Z,T,me="<li><code>tokens/queries_len_mean</code>: The average length of the queries tokens.</li> <li><code>tokens/queries_len_std</code>: The standard deviation of the length of the queries tokens.</li> <li><code>tokens/queries_dist</code>: The histogram distribution of the length of the queries tokens.</li> <li><code>tokens/responses_len_mean</code>: The average length of the responses tokens.</li> <li><code>tokens/responses_len_std</code>: The standard deviation of the length of the responses tokens.</li> <li><code>tokens/responses_dist</code>: The histogram distribution of the length of the responses tokens. (Costa: inconsistent naming, should be <code>tokens/responses_len_dist</code>)</li> <li><code>objective/logprobs</code>: The histogram distribution of the log probabilities of the actions taken by the model.</li> <li><code>objective/ref_logprobs</code>: The histogram distribution of the log probabilities of the actions taken by the reference model.</li>",B,k,fe=`### Crucial values
During training, many values are logged, here are the most important ones:`,R,x,ue="<li><code>env/reward_mean</code>,<code>env/reward_std</code>, <code>env/reward_dist</code>: the properties of the reward distribution from the “environment” /  reward model</li> <li><code>ppo/mean_non_score_reward</code>: The mean negated KL penalty during training (shows the delta between the reference model and the new policy over the batch in the step)</li>",D,P,ge="Here are some parameters that are useful to monitor for stability (when these diverge or collapse to 0, try tuning variables):",N,C,ve="<li><code>ppo/loss/value</code>: it will spike / NaN when not going well.</li> <li><code>ppo/policy/ratio</code>: <code>ratio</code> being 1 is a baseline value, meaning that the probability of sampling a token is the same under the new and old policy. If the ratio is too high like 200, it means the probability of sampling a token is 200 times higher under the new policy than the old policy. This is a sign that the new policy is too different from the old policy, which will likely cause overoptimization and collapse training later on.</li> <li><code>ppo/policy/clipfrac</code> and <code>ppo/policy/approxkl</code>: if <code>ratio</code> is too high, the <code>ratio</code> is going to get clipped, resulting in high <code>clipfrac</code> and high <code>approxkl</code> as well.</li> <li><code>objective/kl</code>: it should stay positive so that the policy is not too far away from the reference policy.</li> <li><code>objective/kl_coef</code>: The target coefficient with <code>AdaptiveKLController</code>. Often increases before numerical instabilities.</li>",W,L,Q,$,F;return c=new ye({props:{title:"Logging",local:"logging",headingTag:"h1"}}),m=new je({props:{code:"Y29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RhcmdzLm1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBsb2dfd2l0aCUzRCU2MHdhbmRiJTYwJTJDJTIwJTIzJTIwb3IlMjAlNjB0ZW5zb3Jib2FyZCU2MCUwQSk=",highlighted:'config = PPOConfig(\n    model_name=args.model_name,\n    log_with=`wandb`, # <span class="hljs-literal">or</span> `tensorboard`\n)',wrap:!1}}),u=new ye({props:{title:"PPO Logging",local:"ppo-logging",headingTag:"h2"}}),L=new $e({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/logging.mdx"}}),{c(){d=a("meta"),M=l(),j=a("p"),O=l(),V(c.$$.fragment),H=l(),p=a("p"),p.innerHTML=le,q=l(),h=a("p"),h.innerHTML=ne,z=l(),V(m.$$.fragment),U=l(),f=a("p"),f.innerHTML=ae,A=l(),V(u.$$.fragment),K=l(),g=a("p"),g.textContent=re,E=l(),v=a("p"),v.textContent=se,I=l(),b=a("ol"),b.innerHTML=de,J=l(),w=a("p"),w.textContent=ce,S=l(),y=a("ol"),y.innerHTML=pe,G=l(),_=a("p"),_.textContent=he,Z=l(),T=a("ol"),T.innerHTML=me,B=l(),k=a("p"),k.textContent=fe,R=l(),x=a("ol"),x.innerHTML=ue,D=l(),P=a("p"),P.textContent=ge,N=l(),C=a("ol"),C.innerHTML=ve,W=l(),V(L.$$.fragment),Q=l(),$=a("p"),this.h()},l(e){const t=Ce("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(o),M=n(e),j=r(e,"P",{}),be(j).forEach(o),O=n(e),X(c.$$.fragment,e),H=n(e),p=r(e,"P",{"data-svelte-h":!0}),s(p)!=="svelte-rrhj3i"&&(p.innerHTML=le),q=n(e),h=r(e,"P",{"data-svelte-h":!0}),s(h)!=="svelte-5o4g4j"&&(h.innerHTML=ne),z=n(e),X(m.$$.fragment,e),U=n(e),f=r(e,"P",{"data-svelte-h":!0}),s(f)!=="svelte-9gqjy4"&&(f.innerHTML=ae),A=n(e),X(u.$$.fragment,e),K=n(e),g=r(e,"P",{"data-svelte-h":!0}),s(g)!=="svelte-50qxhy"&&(g.textContent=re),E=n(e),v=r(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1oysg7j"&&(v.textContent=se),I=n(e),b=r(e,"OL",{"data-svelte-h":!0}),s(b)!=="svelte-1c10na6"&&(b.innerHTML=de),J=n(e),w=r(e,"P",{"data-svelte-h":!0}),s(w)!=="svelte-ma4ajt"&&(w.textContent=ce),S=n(e),y=r(e,"OL",{"data-svelte-h":!0}),s(y)!=="svelte-1eo0hbb"&&(y.innerHTML=pe),G=n(e),_=r(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-1csidm3"&&(_.textContent=he),Z=n(e),T=r(e,"OL",{"data-svelte-h":!0}),s(T)!=="svelte-pvawsw"&&(T.innerHTML=me),B=n(e),k=r(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1rgkjbl"&&(k.textContent=fe),R=n(e),x=r(e,"OL",{"data-svelte-h":!0}),s(x)!=="svelte-wjaroo"&&(x.innerHTML=ue),D=n(e),P=r(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-1yomxw6"&&(P.textContent=ge),N=n(e),C=r(e,"OL",{"data-svelte-h":!0}),s(C)!=="svelte-zapvl9"&&(C.innerHTML=ve),W=n(e),X(L.$$.fragment,e),Q=n(e),$=r(e,"P",{}),be($).forEach(o),this.h()},h(){we(d,"name","hf:doc:metadata"),we(d,"content",Oe)},m(e,t){Le(document.head,d),i(e,M,t),i(e,j,t),i(e,O,t),Y(c,e,t),i(e,H,t),i(e,p,t),i(e,q,t),i(e,h,t),i(e,z,t),Y(m,e,t),i(e,U,t),i(e,f,t),i(e,A,t),Y(u,e,t),i(e,K,t),i(e,g,t),i(e,E,t),i(e,v,t),i(e,I,t),i(e,b,t),i(e,J,t),i(e,w,t),i(e,S,t),i(e,y,t),i(e,G,t),i(e,_,t),i(e,Z,t),i(e,T,t),i(e,B,t),i(e,k,t),i(e,R,t),i(e,x,t),i(e,D,t),i(e,P,t),i(e,N,t),i(e,C,t),i(e,W,t),Y(L,e,t),i(e,Q,t),i(e,$,t),F=!0},p:Te,i(e){F||(ee(c.$$.fragment,e),ee(m.$$.fragment,e),ee(u.$$.fragment,e),ee(L.$$.fragment,e),F=!0)},o(e){te(c.$$.fragment,e),te(m.$$.fragment,e),te(u.$$.fragment,e),te(L.$$.fragment,e),F=!1},d(e){e&&(o(M),o(j),o(O),o(H),o(p),o(q),o(h),o(z),o(U),o(f),o(A),o(K),o(g),o(E),o(v),o(I),o(b),o(J),o(w),o(S),o(y),o(G),o(_),o(Z),o(T),o(B),o(k),o(R),o(x),o(D),o(P),o(N),o(C),o(W),o(Q),o($)),o(d),oe(c,e),oe(m,e),oe(u,e),oe(L,e)}}}const Oe='{"title":"Logging","local":"logging","sections":[{"title":"PPO Logging","local":"ppo-logging","sections":[],"depth":2}],"depth":1}';function He(ie){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends xe{constructor(d){super(),Pe(this,d,He,Me,_e,{})}}export{Ke as component};
