import{s as Sl,o as Ql,n as Nl}from"../chunks/scheduler.8c3d61f6.js";import{S as Fl,i as El,g as a,s as i,r as p,A as Yl,h as r,f as l,c as n,j as Ll,u as f,x as o,k as g,y as Pl,a as s,v as u,d as c,t as m,w as d}from"../chunks/index.da70eac4.js";import{T as zl}from"../chunks/Tip.1d9b8c37.js";import{C as M}from"../chunks/CodeBlock.00a903b3.js";import{D as Dl}from"../chunks/DocNotebookDropdown.02900f6b.js";import{H as W,E as Al}from"../chunks/EditOnGithub.1e64e623.js";function ql(Ce){let h,b='💡 If you don’t have access to a GPU, you can use one for free from a GPU provider like <a href="https://colab.research.google.com/" rel="nofollow">Colab</a>!';return{c(){h=a("p"),h.innerHTML=b},l(y){h=r(y,"P",{"data-svelte-h":!0}),o(h)!=="svelte-5o248f"&&(h.innerHTML=b)},m(y,w){s(y,h,w)},p:Nl,d(y){y&&l(h)}}}function Kl(Ce){let h,b="💡 We strongly suggest always running your pipelines in <code>float16</code>, and so far, we’ve rarely seen any degradation in output quality.";return{c(){h=a("p"),h.innerHTML=b},l(y){h=r(y,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1i2b108"&&(h.innerHTML=b)},m(y,w){s(y,h,w)},p:Nl,d(y){y&&l(h)}}}function Ol(Ce){let h,b,y,w,k,Xe,V,xe,H,Ot='Getting the <a href="/docs/diffusers/pr_10048/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to generate images in a certain style or include what you want can be tricky. Often times, you have to run the <a href="/docs/diffusers/pr_10048/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> several times before you end up with an image you’re happy with. But generating something out of nothing is a computationally intensive process, especially if you’re running inference over and over again.',Le,I,el="This is why it’s important to get the most <em>computational</em> (speed) and <em>memory</em> (GPU vRAM) efficiency from the pipeline to reduce the time between inference cycles so you can iterate faster.",ze,B,tl='This tutorial walks you through how to generate faster and better with the <a href="/docs/diffusers/pr_10048/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Ne,C,ll='Begin by loading the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> model:',Se,R,Qe,X,sl="The example prompt you’ll use is a portrait of an old warrior chief, but feel free to use your own prompt:",Fe,x,Ee,L,Ye,J,Pe,z,il="One of the simplest ways to speed up inference is to place the pipeline on a GPU the same way you would with any PyTorch module:",De,N,Ae,S,nl='To make sure you can use the same image and improve on it, use a <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a> and set a seed for <a href="./using-diffusers/reusing_seeds">reproducibility</a>:',qe,Q,Ke,F,al="Now you can generate an image:",Oe,E,et,T,rl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',tt,Y,ol='This process took ~30 seconds on a T4 GPU (it might be faster if your allocated GPU is better than a T4). By default, the <a href="/docs/diffusers/pr_10048/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> runs inference with full <code>float32</code> precision for 50 inference steps. You can speed this up by switching to a lower precision like <code>float16</code> or running fewer inference steps.',lt,P,pl="Let’s start by loading the model in <code>float16</code> and generate an image:",st,D,it,Z,fl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',nt,A,ul="This time, it only took ~11 seconds to generate the image, which is almost 3x faster than before!",at,U,rt,q,cl='Another option is to reduce the number of inference steps. Choosing a more efficient scheduler could help decrease the number of steps without sacrificing output quality. You can find which schedulers are compatible with the current model in the <a href="/docs/diffusers/pr_10048/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> by calling the <code>compatibles</code> method:',ot,K,pt,O,ml='The Stable Diffusion model uses the <a href="/docs/diffusers/pr_10048/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> by default which usually requires ~50 inference steps, but more performant schedulers like <a href="/docs/diffusers/pr_10048/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>, require only ~20 or 25 inference steps. Use the <a href="/docs/diffusers/pr_10048/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> method to load a new scheduler:',ft,ee,ut,te,dl="Now set the <code>num_inference_steps</code> to 20:",ct,le,mt,j,hl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',dt,se,yl="Great, you’ve managed to cut the inference time to just 4 seconds! ⚡️",ht,ie,yt,ne,Ml="The other key to improving pipeline performance is consuming less memory, which indirectly implies more speed, since you’re often trying to maximize the number of images generated per second. The easiest way to see how many images you can generate at once is to try out different batch sizes until you get an <code>OutOfMemoryError</code> (OOM).",Mt,ae,bl="Create a function that’ll generate a batch of images from a list of prompts and <code>Generators</code>. Make sure to assign each <code>Generator</code> a seed so you can reuse it if it produces a good result.",bt,re,gt,oe,gl="Start with <code>batch_size=4</code> and see how much memory you’ve consumed:",wt,pe,Jt,fe,wl='Unless you have a GPU with more vRAM, the code above probably returned an <code>OOM</code> error! Most of the memory is taken up by the cross-attention layers. Instead of running this operation in a batch, you can run it sequentially to save a significant amount of memory. All you have to do is configure the pipeline to use the <a href="/docs/diffusers/pr_10048/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_attention_slicing">enable_attention_slicing()</a> function:',Tt,ue,Zt,ce,Jl="Now try increasing the <code>batch_size</code> to 8!",Ut,me,jt,v,Tl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',vt,de,Zl="Whereas before you couldn’t even generate a batch of 4 images, now you can generate a batch of 8 images at ~3.5 seconds per image! This is probably the fastest you can go on a T4 GPU without sacrificing quality.",$t,he,Gt,ye,Ul="In the last two sections, you learned how to optimize the speed of your pipeline by using <code>fp16</code>, reducing the number of inference steps by using a more performant scheduler, and enabling attention slicing to reduce memory consumption. Now you’re going to focus on how to improve the quality of generated images.",_t,Me,Wt,be,jl='The most obvious step is to use better checkpoints. The Stable Diffusion model is a good starting point, and since its official launch, several improved versions have also been released. However, using a newer version doesn’t automatically mean you’ll get better results. You’ll still have to experiment with different checkpoints yourself, and do a little research (such as using <a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">negative prompts</a>) to get the best results.',kt,ge,vl='As the field grows, there are more and more high-quality checkpoints finetuned to produce certain styles. Try exploring the <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a> and <a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a> to find one you’re interested in!',Vt,we,Ht,Je,$l='You can also try replacing the current pipeline components with a newer version. Let’s try loading the latest <a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autoencoder</a> from Stability AI into the pipeline, and generate some images:',It,Te,Bt,$,Gl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',Ct,Ze,Rt,Ue,_l="The text prompt you use to generate an image is super important, so much so that it is called <em>prompt engineering</em>. Some considerations to keep during prompt engineering are:",Xt,je,Wl="<li>How is the image or similar images of the one I want to generate stored on the internet?</li> <li>What additional detail can I give that steers the model towards the style I want?</li>",xt,ve,kl="With this in mind, let’s improve the prompt to include color and higher quality details:",Lt,$e,zt,Ge,Vl="Generate a batch of images with the new prompt:",Nt,_e,St,G,Hl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',Qt,We,Il="Pretty impressive! Let’s tweak the second image - corresponding to the <code>Generator</code> with a seed of <code>1</code> - a bit more by adding some text about the age of the subject:",Ft,ke,Et,_,Bl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',Yt,Ve,Pt,He,Cl='In this tutorial, you learned how to optimize a <a href="/docs/diffusers/pr_10048/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> for computational and memory efficiency as well as improving the quality of generated outputs. If you’re interested in making your pipeline even faster, take a look at the following resources:',Dt,Ie,Rl='<li>Learn how <a href="./optimization/torch2.0">PyTorch 2.0</a> and <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> can yield 5 - 300% faster inference speed. On an A100 GPU, inference can be up to 50% faster!</li> <li>If you can’t use PyTorch 2, we recommend you install <a href="./optimization/xformers">xFormers</a>. Its memory-efficient attention mechanism works great with PyTorch 1.13.1 for faster speed and reduced memory consumption.</li> <li>Other optimization techniques, such as model offloading, are covered in <a href="./optimization/fp16">this guide</a>.</li>',At,Be,qt,Re,Kt;return k=new W({props:{title:"Effective and efficient diffusion",local:"effective-and-efficient-diffusion",headingTag:"h1"}}),V=new Dl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"}]}}),R=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>',wrap:!1}}),L=new W({props:{title:"Speed",local:"speed",headingTag:"h2"}}),J=new zl({props:{$$slots:{default:[ql]},$$scope:{ctx:Ce}}}),N=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),Q=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`,wrap:!1}}),E=new M({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),U=new zl({props:{$$slots:{default:[Kl]},$$scope:{ctx:Ce}}}),K=new M({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnV0aWxzLmR1bW15X3RvcmNoX2FuZF90b3JjaHNkZV9vYmplY3RzLkRQTVNvbHZlclNERVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfaGV1bl9kaXNjcmV0ZS5IZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3BuZG0uUE5ETVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZXVsZXJfYW5jZXN0cmFsX2Rpc2NyZXRlLkV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RkaW0uRERJTVNjaGVkdWxlciUyQyUwQSU1RA==",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.utils.dummy_torch_and_torchsde_objects.DPMSolverSDEScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`,wrap:!1}}),ee=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),le=new M({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ie=new W({props:{title:"Memory",local:"memory",headingTag:"h2"}}),re=new M({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`,wrap:!1}}),pe=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCoqZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNENCkpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjAyJTJDJTIwMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),ue=new M({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()",wrap:!1}}),me=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),he=new W({props:{title:"Quality",local:"quality",headingTag:"h2"}}),Me=new W({props:{title:"Better checkpoints",local:"better-checkpoints",headingTag:"h3"}}),we=new W({props:{title:"Better pipeline components",local:"better-pipeline-components",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Ze=new W({props:{title:"Better prompt engineering",local:"better-prompt-engineering",headingTag:"h3"}}),$e=new M({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`,wrap:!1}}),_e=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),ke=new M({props:{code:"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",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of an old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),Ve=new W({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Be=new Al({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/stable_diffusion.md"}}),{c(){h=a("meta"),b=i(),y=a("p"),w=i(),p(k.$$.fragment),Xe=i(),p(V.$$.fragment),xe=i(),H=a("p"),H.innerHTML=Ot,Le=i(),I=a("p"),I.innerHTML=el,ze=i(),B=a("p"),B.innerHTML=tl,Ne=i(),C=a("p"),C.innerHTML=ll,Se=i(),p(R.$$.fragment),Qe=i(),X=a("p"),X.textContent=sl,Fe=i(),p(x.$$.fragment),Ee=i(),p(L.$$.fragment),Ye=i(),p(J.$$.fragment),Pe=i(),z=a("p"),z.textContent=il,De=i(),p(N.$$.fragment),Ae=i(),S=a("p"),S.innerHTML=nl,qe=i(),p(Q.$$.fragment),Ke=i(),F=a("p"),F.textContent=al,Oe=i(),p(E.$$.fragment),et=i(),T=a("div"),T.innerHTML=rl,tt=i(),Y=a("p"),Y.innerHTML=ol,lt=i(),P=a("p"),P.innerHTML=pl,st=i(),p(D.$$.fragment),it=i(),Z=a("div"),Z.innerHTML=fl,nt=i(),A=a("p"),A.textContent=ul,at=i(),p(U.$$.fragment),rt=i(),q=a("p"),q.innerHTML=cl,ot=i(),p(K.$$.fragment),pt=i(),O=a("p"),O.innerHTML=ml,ft=i(),p(ee.$$.fragment),ut=i(),te=a("p"),te.innerHTML=dl,ct=i(),p(le.$$.fragment),mt=i(),j=a("div"),j.innerHTML=hl,dt=i(),se=a("p"),se.textContent=yl,ht=i(),p(ie.$$.fragment),yt=i(),ne=a("p"),ne.innerHTML=Ml,Mt=i(),ae=a("p"),ae.innerHTML=bl,bt=i(),p(re.$$.fragment),gt=i(),oe=a("p"),oe.innerHTML=gl,wt=i(),p(pe.$$.fragment),Jt=i(),fe=a("p"),fe.innerHTML=wl,Tt=i(),p(ue.$$.fragment),Zt=i(),ce=a("p"),ce.innerHTML=Jl,Ut=i(),p(me.$$.fragment),jt=i(),v=a("div"),v.innerHTML=Tl,vt=i(),de=a("p"),de.textContent=Zl,$t=i(),p(he.$$.fragment),Gt=i(),ye=a("p"),ye.innerHTML=Ul,_t=i(),p(Me.$$.fragment),Wt=i(),be=a("p"),be.innerHTML=jl,kt=i(),ge=a("p"),ge.innerHTML=vl,Vt=i(),p(we.$$.fragment),Ht=i(),Je=a("p"),Je.innerHTML=$l,It=i(),p(Te.$$.fragment),Bt=i(),$=a("div"),$.innerHTML=Gl,Ct=i(),p(Ze.$$.fragment),Rt=i(),Ue=a("p"),Ue.innerHTML=_l,Xt=i(),je=a("ul"),je.innerHTML=Wl,xt=i(),ve=a("p"),ve.textContent=kl,Lt=i(),p($e.$$.fragment),zt=i(),Ge=a("p"),Ge.textContent=Vl,Nt=i(),p(_e.$$.fragment),St=i(),G=a("div"),G.innerHTML=Hl,Qt=i(),We=a("p"),We.innerHTML=Il,Ft=i(),p(ke.$$.fragment),Et=i(),_=a("div"),_.innerHTML=Bl,Yt=i(),p(Ve.$$.fragment),Pt=i(),He=a("p"),He.innerHTML=Cl,Dt=i(),Ie=a("ul"),Ie.innerHTML=Rl,At=i(),p(Be.$$.fragment),qt=i(),Re=a("p"),this.h()},l(e){const t=Yl("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(l),b=n(e),y=r(e,"P",{}),Ll(y).forEach(l),w=n(e),f(k.$$.fragment,e),Xe=n(e),f(V.$$.fragment,e),xe=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1cmorv"&&(H.innerHTML=Ot),Le=n(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1s9blmo"&&(I.innerHTML=el),ze=n(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-16vs90o"&&(B.innerHTML=tl),Ne=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1va5egq"&&(C.innerHTML=ll),Se=n(e),f(R.$$.fragment,e),Qe=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-10ouxny"&&(X.textContent=sl),Fe=n(e),f(x.$$.fragment,e),Ee=n(e),f(L.$$.fragment,e),Ye=n(e),f(J.$$.fragment,e),Pe=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-kanimh"&&(z.textContent=il),De=n(e),f(N.$$.fragment,e),Ae=n(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1vr43ia"&&(S.innerHTML=nl),qe=n(e),f(Q.$$.fragment,e),Ke=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-fvhhns"&&(F.textContent=al),Oe=n(e),f(E.$$.fragment,e),et=n(e),T=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1of5nwm"&&(T.innerHTML=rl),tt=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1s3m3xp"&&(Y.innerHTML=ol),lt=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-11ahf9b"&&(P.innerHTML=pl),st=n(e),f(D.$$.fragment,e),it=n(e),Z=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1why3l7"&&(Z.innerHTML=fl),nt=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-19ensh2"&&(A.textContent=ul),at=n(e),f(U.$$.fragment,e),rt=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-rjfsag"&&(q.innerHTML=cl),ot=n(e),f(K.$$.fragment,e),pt=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-yjtl7y"&&(O.innerHTML=ml),ft=n(e),f(ee.$$.fragment,e),ut=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-cj4zg7"&&(te.innerHTML=dl),ct=n(e),f(le.$$.fragment,e),mt=n(e),j=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-19w49w4"&&(j.innerHTML=hl),dt=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-t554e8"&&(se.textContent=yl),ht=n(e),f(ie.$$.fragment,e),yt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-xwat8v"&&(ne.innerHTML=Ml),Mt=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-ubghtf"&&(ae.innerHTML=bl),bt=n(e),f(re.$$.fragment,e),gt=n(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-136nem1"&&(oe.innerHTML=gl),wt=n(e),f(pe.$$.fragment,e),Jt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1x04i7s"&&(fe.innerHTML=wl),Tt=n(e),f(ue.$$.fragment,e),Zt=n(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1kyeye"&&(ce.innerHTML=Jl),Ut=n(e),f(me.$$.fragment,e),jt=n(e),v=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(v)!=="svelte-vxa9bu"&&(v.innerHTML=Tl),vt=n(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-8y2h2l"&&(de.textContent=Zl),$t=n(e),f(he.$$.fragment,e),Gt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-nie66e"&&(ye.innerHTML=Ul),_t=n(e),f(Me.$$.fragment,e),Wt=n(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-n6uci0"&&(be.innerHTML=jl),kt=n(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1m9vwtz"&&(ge.innerHTML=vl),Vt=n(e),f(we.$$.fragment,e),Ht=n(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-ss65n0"&&(Je.innerHTML=$l),It=n(e),f(Te.$$.fragment,e),Bt=n(e),$=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-610rhb"&&($.innerHTML=Gl),Ct=n(e),f(Ze.$$.fragment,e),Rt=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1cdb512"&&(Ue.innerHTML=_l),Xt=n(e),je=r(e,"UL",{"data-svelte-h":!0}),o(je)!=="svelte-o0cjrb"&&(je.innerHTML=Wl),xt=n(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-dljusi"&&(ve.textContent=kl),Lt=n(e),f($e.$$.fragment,e),zt=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-11z4mci"&&(Ge.textContent=Vl),Nt=n(e),f(_e.$$.fragment,e),St=n(e),G=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(G)!=="svelte-n1o5lk"&&(G.innerHTML=Hl),Qt=n(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-fmxgeo"&&(We.innerHTML=Il),Ft=n(e),f(ke.$$.fragment,e),Et=n(e),_=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(_)!=="svelte-1lkw2bx"&&(_.innerHTML=Bl),Yt=n(e),f(Ve.$$.fragment,e),Pt=n(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1loql8m"&&(He.innerHTML=Cl),Dt=n(e),Ie=r(e,"UL",{"data-svelte-h":!0}),o(Ie)!=="svelte-1vrqfkr"&&(Ie.innerHTML=Rl),At=n(e),f(Be.$$.fragment,e),qt=n(e),Re=r(e,"P",{}),Ll(Re).forEach(l),this.h()},h(){g(h,"name","hf:doc:metadata"),g(h,"content",es),g(T,"class","flex justify-center"),g(Z,"class","flex justify-center"),g(j,"class","flex justify-center"),g(v,"class","flex justify-center"),g($,"class","flex justify-center"),g(G,"class","flex justify-center"),g(_,"class","flex justify-center")},m(e,t){Pl(document.head,h),s(e,b,t),s(e,y,t),s(e,w,t),u(k,e,t),s(e,Xe,t),u(V,e,t),s(e,xe,t),s(e,H,t),s(e,Le,t),s(e,I,t),s(e,ze,t),s(e,B,t),s(e,Ne,t),s(e,C,t),s(e,Se,t),u(R,e,t),s(e,Qe,t),s(e,X,t),s(e,Fe,t),u(x,e,t),s(e,Ee,t),u(L,e,t),s(e,Ye,t),u(J,e,t),s(e,Pe,t),s(e,z,t),s(e,De,t),u(N,e,t),s(e,Ae,t),s(e,S,t),s(e,qe,t),u(Q,e,t),s(e,Ke,t),s(e,F,t),s(e,Oe,t),u(E,e,t),s(e,et,t),s(e,T,t),s(e,tt,t),s(e,Y,t),s(e,lt,t),s(e,P,t),s(e,st,t),u(D,e,t),s(e,it,t),s(e,Z,t),s(e,nt,t),s(e,A,t),s(e,at,t),u(U,e,t),s(e,rt,t),s(e,q,t),s(e,ot,t),u(K,e,t),s(e,pt,t),s(e,O,t),s(e,ft,t),u(ee,e,t),s(e,ut,t),s(e,te,t),s(e,ct,t),u(le,e,t),s(e,mt,t),s(e,j,t),s(e,dt,t),s(e,se,t),s(e,ht,t),u(ie,e,t),s(e,yt,t),s(e,ne,t),s(e,Mt,t),s(e,ae,t),s(e,bt,t),u(re,e,t),s(e,gt,t),s(e,oe,t),s(e,wt,t),u(pe,e,t),s(e,Jt,t),s(e,fe,t),s(e,Tt,t),u(ue,e,t),s(e,Zt,t),s(e,ce,t),s(e,Ut,t),u(me,e,t),s(e,jt,t),s(e,v,t),s(e,vt,t),s(e,de,t),s(e,$t,t),u(he,e,t),s(e,Gt,t),s(e,ye,t),s(e,_t,t),u(Me,e,t),s(e,Wt,t),s(e,be,t),s(e,kt,t),s(e,ge,t),s(e,Vt,t),u(we,e,t),s(e,Ht,t),s(e,Je,t),s(e,It,t),u(Te,e,t),s(e,Bt,t),s(e,$,t),s(e,Ct,t),u(Ze,e,t),s(e,Rt,t),s(e,Ue,t),s(e,Xt,t),s(e,je,t),s(e,xt,t),s(e,ve,t),s(e,Lt,t),u($e,e,t),s(e,zt,t),s(e,Ge,t),s(e,Nt,t),u(_e,e,t),s(e,St,t),s(e,G,t),s(e,Qt,t),s(e,We,t),s(e,Ft,t),u(ke,e,t),s(e,Et,t),s(e,_,t),s(e,Yt,t),u(Ve,e,t),s(e,Pt,t),s(e,He,t),s(e,Dt,t),s(e,Ie,t),s(e,At,t),u(Be,e,t),s(e,qt,t),s(e,Re,t),Kt=!0},p(e,[t]){const Xl={};t&2&&(Xl.$$scope={dirty:t,ctx:e}),J.$set(Xl);const xl={};t&2&&(xl.$$scope={dirty:t,ctx:e}),U.$set(xl)},i(e){Kt||(c(k.$$.fragment,e),c(V.$$.fragment,e),c(R.$$.fragment,e),c(x.$$.fragment,e),c(L.$$.fragment,e),c(J.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(E.$$.fragment,e),c(D.$$.fragment,e),c(U.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(ue.$$.fragment,e),c(me.$$.fragment,e),c(he.$$.fragment,e),c(Me.$$.fragment,e),c(we.$$.fragment,e),c(Te.$$.fragment,e),c(Ze.$$.fragment,e),c($e.$$.fragment,e),c(_e.$$.fragment,e),c(ke.$$.fragment,e),c(Ve.$$.fragment,e),c(Be.$$.fragment,e),Kt=!0)},o(e){m(k.$$.fragment,e),m(V.$$.fragment,e),m(R.$$.fragment,e),m(x.$$.fragment,e),m(L.$$.fragment,e),m(J.$$.fragment,e),m(N.$$.fragment,e),m(Q.$$.fragment,e),m(E.$$.fragment,e),m(D.$$.fragment,e),m(U.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(ue.$$.fragment,e),m(me.$$.fragment,e),m(he.$$.fragment,e),m(Me.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(Ze.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(ke.$$.fragment,e),m(Ve.$$.fragment,e),m(Be.$$.fragment,e),Kt=!1},d(e){e&&(l(b),l(y),l(w),l(Xe),l(xe),l(H),l(Le),l(I),l(ze),l(B),l(Ne),l(C),l(Se),l(Qe),l(X),l(Fe),l(Ee),l(Ye),l(Pe),l(z),l(De),l(Ae),l(S),l(qe),l(Ke),l(F),l(Oe),l(et),l(T),l(tt),l(Y),l(lt),l(P),l(st),l(it),l(Z),l(nt),l(A),l(at),l(rt),l(q),l(ot),l(pt),l(O),l(ft),l(ut),l(te),l(ct),l(mt),l(j),l(dt),l(se),l(ht),l(yt),l(ne),l(Mt),l(ae),l(bt),l(gt),l(oe),l(wt),l(Jt),l(fe),l(Tt),l(Zt),l(ce),l(Ut),l(jt),l(v),l(vt),l(de),l($t),l(Gt),l(ye),l(_t),l(Wt),l(be),l(kt),l(ge),l(Vt),l(Ht),l(Je),l(It),l(Bt),l($),l(Ct),l(Rt),l(Ue),l(Xt),l(je),l(xt),l(ve),l(Lt),l(zt),l(Ge),l(Nt),l(St),l(G),l(Qt),l(We),l(Ft),l(Et),l(_),l(Yt),l(Pt),l(He),l(Dt),l(Ie),l(At),l(qt),l(Re)),l(h),d(k,e),d(V,e),d(R,e),d(x,e),d(L,e),d(J,e),d(N,e),d(Q,e),d(E,e),d(D,e),d(U,e),d(K,e),d(ee,e),d(le,e),d(ie,e),d(re,e),d(pe,e),d(ue,e),d(me,e),d(he,e),d(Me,e),d(we,e),d(Te,e),d(Ze,e),d($e,e),d(_e,e),d(ke,e),d(Ve,e),d(Be,e)}}}const es='{"title":"Effective and efficient diffusion","local":"effective-and-efficient-diffusion","sections":[{"title":"Speed","local":"speed","sections":[],"depth":2},{"title":"Memory","local":"memory","sections":[],"depth":2},{"title":"Quality","local":"quality","sections":[{"title":"Better checkpoints","local":"better-checkpoints","sections":[],"depth":3},{"title":"Better pipeline components","local":"better-pipeline-components","sections":[],"depth":3},{"title":"Better prompt engineering","local":"better-prompt-engineering","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ts(Ce){return Ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class os extends Fl{constructor(h){super(),El(this,h,ts,Ol,Sl,{})}}export{os as component};
