import{s as $t,o as yt,n as Xe}from"../chunks/scheduler.d6170356.js";import{S as vt,i as jt,g as o,s as l,r as h,A as _t,h as p,f as a,c as n,j as Mt,u as d,x as r,k as Tt,y as Ct,a as s,v as f,d as m,t as g,w}from"../chunks/index.fcd4cc08.js";import{T as We}from"../chunks/Tip.b09c67cf.js";import{C as bt}from"../chunks/CodeBlock.7b16bdef.js";import{H as se,E as Jt}from"../chunks/EditOnGithub.da2b595c.js";function It(T){let i,u='This guide will take you through the process of integrating a <em>Sign-In with HF</em> button into any Space. If you’re seeking a fast and simple method to implement this in a <strong>Gradio</strong> Space, take a look at its <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">built-in integration</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1nqltc0"&&(i.innerHTML=u)},m(c,M){s(c,i,M)},p:Xe,d(c){c&&a(i)}}}function Ht(T){let i,u='You can also use the HF OAuth flow to create a “Sign in with HF” flow in any website or App, outside of Spaces. <a href="./oauth">Read our general OAuth page</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-138wjpm"&&(i.innerHTML=u)},m(c,M){s(c,i,M)},p:Xe,d(c){c&&a(i)}}}function Ut(T){let i,u="You should use <code>target=_blank</code> on the button to open the sign-in page in a new tab, unless you run the space outside its <code>iframe</code>. Otherwise, you might encounter issues with cookies on some browsers.";return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-9c51kn"&&(i.innerHTML=u)},m(c,M){s(c,i,M)},p:Xe,d(c){c&&a(i)}}}function St(T){let i,u,c,M,v,ne,j,Fe='You can enable a built-in sign-in flow in your Space by seamlessly creating and associating an <a href="https://developer.okta.com/blog/2019/10/21/illustrated-guide-to-oauth-and-oidc" rel="nofollow">OAuth/OpenID connect</a> app so users can log in with their HF account.',ie,_,Oe='This enables new use cases for your Space. For instance, when combined with <a href="https://huggingface.co/docs/hub/spaces-storage" rel="nofollow">Persistent Storage</a>, a generative AI Space could allow users to log in to access their previous generations, only accessible to them.',oe,b,pe,$,re,C,ce,J,Ne="All you need to do is add <code>hf_oauth: true</code> to your Space’s metadata inside your <code>README.md</code> file.",ue,I,Ye="Here’s an example of metadata for a Gradio Space:",he,H,de,U,Ve='You can check out the <a href="./spaces-config-reference">configuration reference docs</a> for more information.',fe,S,Qe='This will add the following <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">environment variables</a> to your space:',me,L,qe='<li><code>OAUTH_CLIENT_ID</code>: the client ID of your OAuth app (public)</li> <li><code>OAUTH_CLIENT_SECRET</code>: the client secret of your OAuth app</li> <li><code>OAUTH_SCOPES</code>: scopes accessible by your OAuth app.</li> <li><code>OPENID_PROVIDER_URL</code>: The URL of the OpenID provider. The OpenID metadata will be available at <a href="https://huggingface.co/.well-known/openid-configuration" rel="nofollow"><code>{OPENID_PROVIDER_URL}/.well-known/openid-configuration</code></a>.</li>',ge,x,De="As for any other environment variable, you can use them in your code by using <code>os.getenv(&quot;OAUTH_CLIENT_ID&quot;)</code>, for example.",we,G,Me,k,Ke="You can use any redirect URL you want, as long as it targets your Space.",Te,E,et='Note that <code>SPACE_HOST</code> is <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">available</a> as an environment variable.',be,R,tt="For example, you can use <code>https://{SPACE_HOST}/login/callback</code> as a redirect URI.",$e,B,ye,A,at="The following scopes are always included for Spaces:",ve,Z,st="<li><code>openid</code>: Get the ID token in addition to the access token.</li> <li><code>profile</code>: Get the user’s profile information (username, avatar, etc.)</li>",je,P,lt="Those scopes are optional and can be added by setting <code>hf_oauth_scopes</code> in your Space’s metadata:",_e,z,nt='<li><code>email</code>: Get the user’s email address.</li> <li><code>read-billing</code>: Know whether the user has a payment method set up.</li> <li><code>read-repos</code>: Get read access to the user’s personal repos.</li> <li><code>write-repos</code>: Get write/read access to the user’s personal repos.</li> <li><code>manage-repos</code>: Get full access to the user’s personal repos. Also grants repo creation and deletion.</li> <li><code>inference-api</code>: Get access to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>, you will be able to make inference requests on behalf of the user.</li> <li><code>write-discussions</code>: Open discussions and Pull Requests on behalf of the user as well as interact with discussions (including reactions, posting/editing comments, closing discussions, …). To open Pull Requests on private repos, you need to request the <code>read-repos</code> scope as well.</li>',Ce,W,Je,X,it="By default, the oauth app does not need to access organization resources.",Ie,F,ot="But some scopes like <code>read-repos</code> or <code>read-billing</code> apply to organizations as well.",He,O,pt="The user can select which organizations to grant access to when authorizing the app. If you require access to a specific organization, you can add <code>orgIds=ORG_ID</code> as a query parameter to the OAuth authorization URL. You have to replace <code>ORG_ID</code> with the organization ID, which is available in the <code>organizations.sub</code> field of the userinfo response.",Ue,N,Se,Y,rt='You now have all the information to add a “Sign-in with HF” button to your Space. Some libraries (<a href="https://github.com/lepture/authlib" rel="nofollow">Python</a>, <a href="https://github.com/panva/node-openid-client" rel="nofollow">NodeJS</a>) can help you implement the OpenID/OAuth protocol.',Le,V,ct='Gradio and huggingface.js also provide <strong>built-in support</strong>, making implementing the Sign-in with HF button a breeze; you can check out the associated guides with <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">gradio</a> and with <a href="https://huggingface.co/docs/huggingface.js/hub/README#oauth-login" rel="nofollow">huggingface.js</a>.',xe,Q,ut="Basically, you need to:",Ge,q,ht="<li>Redirect the user to <code>https://huggingface.co/oauth/authorize?redirect_uri={REDIRECT_URI}&amp;scope=openid%20profile&amp;client_id={CLIENT_ID}&amp;state={STATE}</code>, where <code>STATE</code> is a random string that you will need to verify later.</li> <li>Handle the callback on <code>/auth/callback</code> or <code>/login/callback</code> (or your own custom callback URL) and verify the <code>state</code> parameter.</li> <li>Use the <code>code</code> query parameter to get an access token and id token from <code>https://huggingface.co/oauth/token</code> (POST request with <code>client_id</code>, <code>code</code>, <code>grant_type=authorization_code</code> and <code>redirect_uri</code> as form data, and with <code>Authorization: Basic {base64(client_id:client_secret)}</code> as a header).</li>",ke,y,Ee,D,Re,K,dt='<li><a href="https://huggingface.co/spaces/Wauplin/gradio-oauth-test" rel="nofollow">Gradio test app</a></li> <li><a href="https://huggingface.co/spaces/huggingchat/chat-ui" rel="nofollow">Hugging Chat (NodeJS/SvelteKit)</a></li> <li><a href="https://huggingface.co/spaces/huggingfacejs/inference-widgets" rel="nofollow">Inference Widgets (Auth.js/SvelteKit)</a>, uses the <code>inference-api</code> scope to make inference requests on behalf of the user.</li> <li><a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">Client-Side in a Static Space (huggingface.js)</a> - very simple JavaScript example.</li>',Be,ee,ft="JS Code example:",Ae,te,Ze,ae,Pe,le,ze;return v=new se({props:{title:"Adding a Sign-In with HF button to your Space",local:"adding-a-sign-in-with-hf-button-to-your-space",headingTag:"h1"}}),b=new We({props:{$$slots:{default:[It]},$$scope:{ctx:T}}}),$=new We({props:{$$slots:{default:[Ht]},$$scope:{ctx:T}}}),C=new se({props:{title:"Create an OAuth app",local:"create-an-oauth-app",headingTag:"h2"}}),H=new bt({props:{code:"dGl0bGUlM0ElMjBHcmFkaW8lMjBPYXV0aCUyMFRlc3QlMEFlbW9qaSUzQSUyMCVGMCU5RiU4RiU4NiUwQWNvbG9yRnJvbSUzQSUyMHBpbmslMEFjb2xvclRvJTNBJTIwcGluayUwQXNkayUzQSUyMGdyYWRpbyUwQXNka192ZXJzaW9uJTNBJTIwMy40MC4wJTBBcHl0aG9uX3ZlcnNpb24lM0ElMjAzLjEwLjYlMEFhcHBfZmlsZSUzQSUyMGFwcC5weSUwQSUwQWhmX29hdXRoJTNBJTIwdHJ1ZSUwQSUyMyUyMG9wdGlvbmFsJTJDJTIwZGVmYXVsdCUyMGR1cmF0aW9uJTIwaXMlMjA4JTIwaG91cnMlMkY0ODAlMjBtaW51dGVzLiUyME1heCUyMGR1cmF0aW9uJTIwaXMlMjAzMCUyMGRheXMlMkY0MzIwMCUyMG1pbnV0ZXMuJTBBaGZfb2F1dGhfZXhwaXJhdGlvbl9taW51dGVzJTNBJTIwNDgwJTBBJTIzJTIwb3B0aW9uYWwlMkMlMjBzZWUlMjAlMjJTY29wZXMlMjIlMjBiZWxvdy4lMjAlMjJvcGVuaWQlMjBwcm9maWxlJTIyJTIwaXMlMjBhbHdheXMlMjBpbmNsdWRlZC4lMEFoZl9vYXV0aF9zY29wZXMlM0ElMEElMjAtJTIwcmVhZC1yZXBvcyUwQSUyMC0lMjB3cml0ZS1yZXBvcyUwQSUyMC0lMjBtYW5hZ2UtcmVwb3MlMEElMjAtJTIwaW5mZXJlbmNlLWFwaQ==",highlighted:`<span class="hljs-attr">title:</span> <span class="hljs-string">Gradio</span> <span class="hljs-string">Oauth</span> <span class="hljs-string">Test</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🏆</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">gradio</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">3.40</span><span class="hljs-number">.0</span>
<span class="hljs-attr">python_version:</span> <span class="hljs-number">3.10</span><span class="hljs-number">.6</span>
<span class="hljs-attr">app_file:</span> <span class="hljs-string">app.py</span>

<span class="hljs-attr">hf_oauth:</span> <span class="hljs-literal">true</span>
<span class="hljs-comment"># optional, default duration is 8 hours/480 minutes. Max duration is 30 days/43200 minutes.</span>
<span class="hljs-attr">hf_oauth_expiration_minutes:</span> <span class="hljs-number">480</span>
<span class="hljs-comment"># optional, see &quot;Scopes&quot; below. &quot;openid profile&quot; is always included.</span>
<span class="hljs-attr">hf_oauth_scopes:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">read-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">write-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">manage-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">inference-api</span>`,wrap:!1}}),G=new se({props:{title:"Redirect URLs",local:"redirect-urls",headingTag:"h2"}}),B=new se({props:{title:"Scopes",local:"scopes",headingTag:"h2"}}),W=new se({props:{title:"Accessing organization resources",local:"accessing-organization-resources",headingTag:"h2"}}),N=new se({props:{title:"Adding the button to your Space",local:"adding-the-button-to-your-space",headingTag:"h2"}}),y=new We({props:{warning:!0,$$slots:{default:[Ut]},$$scope:{ctx:T}}}),D=new se({props:{title:"Examples:",local:"examples",headingTag:"h2"}}),te=new bt({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC51c2VySW5mbyUyMGFtb25nJTIwb3RoZXIlMjB0aGluZ3MlMEFjb25zb2xlLmxvZyhvYXV0aFJlc3VsdCklM0I=",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.userInfo among other things</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),ae=new Jt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-oauth.md"}}),{c(){i=o("meta"),u=l(),c=o("p"),M=l(),h(v.$$.fragment),ne=l(),j=o("p"),j.innerHTML=Fe,ie=l(),_=o("p"),_.innerHTML=Oe,oe=l(),h(b.$$.fragment),pe=l(),h($.$$.fragment),re=l(),h(C.$$.fragment),ce=l(),J=o("p"),J.innerHTML=Ne,ue=l(),I=o("p"),I.textContent=Ye,he=l(),h(H.$$.fragment),de=l(),U=o("p"),U.innerHTML=Ve,fe=l(),S=o("p"),S.innerHTML=Qe,me=l(),L=o("ul"),L.innerHTML=qe,ge=l(),x=o("p"),x.innerHTML=De,we=l(),h(G.$$.fragment),Me=l(),k=o("p"),k.textContent=Ke,Te=l(),E=o("p"),E.innerHTML=et,be=l(),R=o("p"),R.innerHTML=tt,$e=l(),h(B.$$.fragment),ye=l(),A=o("p"),A.textContent=at,ve=l(),Z=o("ul"),Z.innerHTML=st,je=l(),P=o("p"),P.innerHTML=lt,_e=l(),z=o("ul"),z.innerHTML=nt,Ce=l(),h(W.$$.fragment),Je=l(),X=o("p"),X.textContent=it,Ie=l(),F=o("p"),F.innerHTML=ot,He=l(),O=o("p"),O.innerHTML=pt,Ue=l(),h(N.$$.fragment),Se=l(),Y=o("p"),Y.innerHTML=rt,Le=l(),V=o("p"),V.innerHTML=ct,xe=l(),Q=o("p"),Q.textContent=ut,Ge=l(),q=o("ul"),q.innerHTML=ht,ke=l(),h(y.$$.fragment),Ee=l(),h(D.$$.fragment),Re=l(),K=o("ul"),K.innerHTML=dt,Be=l(),ee=o("p"),ee.textContent=ft,Ae=l(),h(te.$$.fragment),Ze=l(),h(ae.$$.fragment),Pe=l(),le=o("p"),this.h()},l(e){const t=_t("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(a),u=n(e),c=p(e,"P",{}),Mt(c).forEach(a),M=n(e),d(v.$$.fragment,e),ne=n(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1nfjaew"&&(j.innerHTML=Fe),ie=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1t83yje"&&(_.innerHTML=Oe),oe=n(e),d(b.$$.fragment,e),pe=n(e),d($.$$.fragment,e),re=n(e),d(C.$$.fragment,e),ce=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1u00faw"&&(J.innerHTML=Ne),ue=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vlpqut"&&(I.textContent=Ye),he=n(e),d(H.$$.fragment,e),de=n(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-ml9rcy"&&(U.innerHTML=Ve),fe=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-12m1u10"&&(S.innerHTML=Qe),me=n(e),L=p(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-k73zcv"&&(L.innerHTML=qe),ge=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-qqxlx3"&&(x.innerHTML=De),we=n(e),d(G.$$.fragment,e),Me=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-eoih5g"&&(k.textContent=Ke),Te=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1a014a5"&&(E.innerHTML=et),be=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-4fyftp"&&(R.innerHTML=tt),$e=n(e),d(B.$$.fragment,e),ye=n(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-sd96qs"&&(A.textContent=at),ve=n(e),Z=p(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-3wn6r0"&&(Z.innerHTML=st),je=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-181zoj"&&(P.innerHTML=lt),_e=n(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1g6x6fv"&&(z.innerHTML=nt),Ce=n(e),d(W.$$.fragment,e),Je=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-10n2v6"&&(X.textContent=it),Ie=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-zh86jr"&&(F.innerHTML=ot),He=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-99lcmx"&&(O.innerHTML=pt),Ue=n(e),d(N.$$.fragment,e),Se=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1a3vuj4"&&(Y.innerHTML=rt),Le=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1k7h2p0"&&(V.innerHTML=ct),xe=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-g0kxak"&&(Q.textContent=ut),Ge=n(e),q=p(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-159xo4d"&&(q.innerHTML=ht),ke=n(e),d(y.$$.fragment,e),Ee=n(e),d(D.$$.fragment,e),Re=n(e),K=p(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-lipo2y"&&(K.innerHTML=dt),Be=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1g8zr10"&&(ee.textContent=ft),Ae=n(e),d(te.$$.fragment,e),Ze=n(e),d(ae.$$.fragment,e),Pe=n(e),le=p(e,"P",{}),Mt(le).forEach(a),this.h()},h(){Tt(i,"name","hf:doc:metadata"),Tt(i,"content",Lt)},m(e,t){Ct(document.head,i),s(e,u,t),s(e,c,t),s(e,M,t),f(v,e,t),s(e,ne,t),s(e,j,t),s(e,ie,t),s(e,_,t),s(e,oe,t),f(b,e,t),s(e,pe,t),f($,e,t),s(e,re,t),f(C,e,t),s(e,ce,t),s(e,J,t),s(e,ue,t),s(e,I,t),s(e,he,t),f(H,e,t),s(e,de,t),s(e,U,t),s(e,fe,t),s(e,S,t),s(e,me,t),s(e,L,t),s(e,ge,t),s(e,x,t),s(e,we,t),f(G,e,t),s(e,Me,t),s(e,k,t),s(e,Te,t),s(e,E,t),s(e,be,t),s(e,R,t),s(e,$e,t),f(B,e,t),s(e,ye,t),s(e,A,t),s(e,ve,t),s(e,Z,t),s(e,je,t),s(e,P,t),s(e,_e,t),s(e,z,t),s(e,Ce,t),f(W,e,t),s(e,Je,t),s(e,X,t),s(e,Ie,t),s(e,F,t),s(e,He,t),s(e,O,t),s(e,Ue,t),f(N,e,t),s(e,Se,t),s(e,Y,t),s(e,Le,t),s(e,V,t),s(e,xe,t),s(e,Q,t),s(e,Ge,t),s(e,q,t),s(e,ke,t),f(y,e,t),s(e,Ee,t),f(D,e,t),s(e,Re,t),s(e,K,t),s(e,Be,t),s(e,ee,t),s(e,Ae,t),f(te,e,t),s(e,Ze,t),f(ae,e,t),s(e,Pe,t),s(e,le,t),ze=!0},p(e,[t]){const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),b.$set(mt);const gt={};t&2&&(gt.$$scope={dirty:t,ctx:e}),$.$set(gt);const wt={};t&2&&(wt.$$scope={dirty:t,ctx:e}),y.$set(wt)},i(e){ze||(m(v.$$.fragment,e),m(b.$$.fragment,e),m($.$$.fragment,e),m(C.$$.fragment,e),m(H.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(W.$$.fragment,e),m(N.$$.fragment,e),m(y.$$.fragment,e),m(D.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),ze=!0)},o(e){g(v.$$.fragment,e),g(b.$$.fragment,e),g($.$$.fragment,e),g(C.$$.fragment,e),g(H.$$.fragment,e),g(G.$$.fragment,e),g(B.$$.fragment,e),g(W.$$.fragment,e),g(N.$$.fragment,e),g(y.$$.fragment,e),g(D.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),ze=!1},d(e){e&&(a(u),a(c),a(M),a(ne),a(j),a(ie),a(_),a(oe),a(pe),a(re),a(ce),a(J),a(ue),a(I),a(he),a(de),a(U),a(fe),a(S),a(me),a(L),a(ge),a(x),a(we),a(Me),a(k),a(Te),a(E),a(be),a(R),a($e),a(ye),a(A),a(ve),a(Z),a(je),a(P),a(_e),a(z),a(Ce),a(Je),a(X),a(Ie),a(F),a(He),a(O),a(Ue),a(Se),a(Y),a(Le),a(V),a(xe),a(Q),a(Ge),a(q),a(ke),a(Ee),a(Re),a(K),a(Be),a(ee),a(Ae),a(Ze),a(Pe),a(le)),a(i),w(v,e),w(b,e),w($,e),w(C,e),w(H,e),w(G,e),w(B,e),w(W,e),w(N,e),w(y,e),w(D,e),w(te,e),w(ae,e)}}}const Lt='{"title":"Adding a Sign-In with HF button to your Space","local":"adding-a-sign-in-with-hf-button-to-your-space","sections":[{"title":"Create an OAuth app","local":"create-an-oauth-app","sections":[],"depth":2},{"title":"Redirect URLs","local":"redirect-urls","sections":[],"depth":2},{"title":"Scopes","local":"scopes","sections":[],"depth":2},{"title":"Accessing organization resources","local":"accessing-organization-resources","sections":[],"depth":2},{"title":"Adding the button to your Space","local":"adding-the-button-to-your-space","sections":[],"depth":2},{"title":"Examples:","local":"examples","sections":[],"depth":2}],"depth":1}';function xt(T){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends vt{constructor(i){super(),jt(this,i,xt,St,$t,{})}}export{At as component};
