import{s as Fe,n as Se,o as Ye}from"../chunks/scheduler.f7e1785c.js";import{S as Ne,i as He,g as M,s as n,r as u,A as Xe,h as i,f as s,c as a,j as ze,u as p,x as o,k as Ae,y as Ve,a as t,v as r,d as c,t as d,w as j}from"../chunks/index.9f8f0838.js";import{C as m}from"../chunks/CodeBlock.b3510e34.js";import{H as Le,E as De}from"../chunks/EditOnGithub.5a9bb8c5.js";function Pe(Ce){let y,X,N,V,h,L,J,ge=`Dans ce cours, nous utiliserons la bibliothèque 🤗 <em>Datasets</em> pour travailler avec des jeux de données audio.
🤗 <em>Datasets</em> est une bibliothèque open-source permettant de télécharger et de préparer des jeux de données à partir de toutes les modalités, y compris l’audio.
La bibliothèque offre un accès facile à une sélection inégalée de jeux de données d’apprentissage automatique accessibles sur Hugging Face Hub.
De plus, 🤗 <em>Datasets</em> comprend de multiples fonctionnalités adaptées aux jeux de données audio simplifiant le travail avec de tels jeux de données pour les chercheurs et les praticiens.
Pour commencer à utiliser des jeux de données audio, assurez-vous que la 🤗 <em>Datasets</em> est installée :`,D,T,P,w,Ie=`L’une des principales caractéristiques déterminantes de 🤗 <em>Datasets</em>  est la possibilité de télécharger et de préparer un jeu de données en une seule ligne de code Python à l’aide de la fonction <code>load_dataset()</code>.
Chargeons et explorons un jeu de données audio appelé <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, qui contient des enregistrements de personnes posant des questions à un système bancaire électronique dans plusieurs langues et dialectes.
Pour charger le jeu de données MINDS-14, nous devons copier l’identifiant du jeu de données sur le Hub (<code>PolyAI/minds14</code>) et le transmettre à la fonction <code>load_dataset</code>.
Nous préciserons également que nous ne nous intéressons qu’au sous-ensemble australien (‘en-AU’) des données, et le limiterons à la division de l’entraînement :`,K,b,O,f,qe="<strong>Sortie :</strong>",ee,A,le,C,ve=`Le jeu de données contient 654 fichiers audio, chacun étant accompagné d’une transcription, d’une traduction en anglais et d’une étiquette indiquant l’intention derrière la requête de la personne.
La colonne audio contient les données audio brutes. Examinons de plus près l’un des exemples:`,se,g,te,I,$e="<strong>Sortie :</strong>",ne,q,ae,v,Ge="Vous remarquerez peut-être que la colonne audio contient plusieurs caractéristiques :",Me,$,ke=`<li><code>path</code> : le chemin d’accès au fichier audio (<code>*.wav</code> dans ce cas).</li> <li><code>array</code>: les données audio décodées, représentées sous la forme d’un tableau NumPy à 1 dimension.</li> <li><code>sampling_rate</code> : taux d’échantillonnage du fichier audio (8 000 Hz dans cet exemple).
Le <code>intent_class</code> est une catégorie de classification de l’enregistrement audio. Pour convertir ce nombre en une chaîne significative, nous pouvons utiliser la méthode <code>int2str()</code>:</li>`,ie,G,oe,k,xe="<strong>Sortie :</strong>",ue,x,pe,Z,Ze=`Si vous regardez la fonction de transcription, vous pouvez voir que le fichier audio a effectivement enregistré une personne posant une question sur le paiement d’une facture.
Si vous envisagez d’entraîner un classifieur audio sur ce sous-ensemble de données, vous n’aurez pas nécessairement besoin de toutes les caractéristiques.
Par exemple, le <code>lang_id</code> aura la même valeur pour tous les exemples et ne sera pas utile.
Les <code>english_transcription</code> dupliqueront probablement la <code>transcription</code> de ce sous-ensemble, afin que nous puissions les supprimer en toute sécurité.`,re,E,Ee="Vous pouvez facilement supprimer les caractéristiques non pertinentes à l’aide de la méthode <code>remove_columns</code> de 🤗 <em>Datasets</em> :",ce,B,de,Q,Be="<strong>Sortie :</strong>",je,W,me,_,Qe="Maintenant que nous avons chargé et inspecté le contenu brut du jeu de données, écoutons quelques exemples ! Nous utiliserons les fonctionnalités <code>Blocs</code> et <code>Audio</code> de <em>Gradio</em> pour décoder quelques échantillons aléatoires du jeu de données:",ye,R,Ue,z,We="Si vous le souhaitez, vous pouvez également visualiser certains des exemples. Traçons la forme d’onde pour le premier exemple.",he,F,Je,U,_e='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',Te,S,Re=`Essayez ! Téléchargez un autre dialecte ou une autre langue du jeu de données MINDS-14, écoutez et visualisez quelques exemples pour avoir une idée des variations du jeu de données.
Vous pouvez trouver la liste complète des langues disponibles <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">ici</a>.`,we,Y,be,H,fe;return h=new Le({props:{title:"Charger et explorer un jeu de données audio",local:"charger-et-explorer-un-jeu-de-données-audio",headingTag:"h1"}}),T=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),b=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),A=new m({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),g=new m({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),q=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),G=new m({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),x=new m({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),B=new m({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),W=new m({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),R=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),F=new m({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),Y=new De({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter1/load_and_explore.mdx"}}),{c(){y=M("meta"),X=n(),N=M("p"),V=n(),u(h.$$.fragment),L=n(),J=M("p"),J.innerHTML=ge,D=n(),u(T.$$.fragment),P=n(),w=M("p"),w.innerHTML=Ie,K=n(),u(b.$$.fragment),O=n(),f=M("p"),f.innerHTML=qe,ee=n(),u(A.$$.fragment),le=n(),C=M("p"),C.textContent=ve,se=n(),u(g.$$.fragment),te=n(),I=M("p"),I.innerHTML=$e,ne=n(),u(q.$$.fragment),ae=n(),v=M("p"),v.textContent=Ge,Me=n(),$=M("ul"),$.innerHTML=ke,ie=n(),u(G.$$.fragment),oe=n(),k=M("p"),k.innerHTML=xe,ue=n(),u(x.$$.fragment),pe=n(),Z=M("p"),Z.innerHTML=Ze,re=n(),E=M("p"),E.innerHTML=Ee,ce=n(),u(B.$$.fragment),de=n(),Q=M("p"),Q.innerHTML=Be,je=n(),u(W.$$.fragment),me=n(),_=M("p"),_.innerHTML=Qe,ye=n(),u(R.$$.fragment),Ue=n(),z=M("p"),z.textContent=We,he=n(),u(F.$$.fragment),Je=n(),U=M("div"),U.innerHTML=_e,Te=n(),S=M("p"),S.innerHTML=Re,we=n(),u(Y.$$.fragment),be=n(),H=M("p"),this.h()},l(e){const l=Xe("svelte-u9bgzb",document.head);y=i(l,"META",{name:!0,content:!0}),l.forEach(s),X=a(e),N=i(e,"P",{}),ze(N).forEach(s),V=a(e),p(h.$$.fragment,e),L=a(e),J=i(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-18l4dc2"&&(J.innerHTML=ge),D=a(e),p(T.$$.fragment,e),P=a(e),w=i(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-19ww6hu"&&(w.innerHTML=Ie),K=a(e),p(b.$$.fragment,e),O=a(e),f=i(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-dbzevp"&&(f.innerHTML=qe),ee=a(e),p(A.$$.fragment,e),le=a(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1dg8v72"&&(C.textContent=ve),se=a(e),p(g.$$.fragment,e),te=a(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-dbzevp"&&(I.innerHTML=$e),ne=a(e),p(q.$$.fragment,e),ae=a(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1p7dink"&&(v.textContent=Ge),Me=a(e),$=i(e,"UL",{"data-svelte-h":!0}),o($)!=="svelte-1hxtpp7"&&($.innerHTML=ke),ie=a(e),p(G.$$.fragment,e),oe=a(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-dbzevp"&&(k.innerHTML=xe),ue=a(e),p(x.$$.fragment,e),pe=a(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-19cohpx"&&(Z.innerHTML=Ze),re=a(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-hekgx8"&&(E.innerHTML=Ee),ce=a(e),p(B.$$.fragment,e),de=a(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-dbzevp"&&(Q.innerHTML=Be),je=a(e),p(W.$$.fragment,e),me=a(e),_=i(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-rbxail"&&(_.innerHTML=Qe),ye=a(e),p(R.$$.fragment,e),Ue=a(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-11t53jt"&&(z.textContent=We),he=a(e),p(F.$$.fragment,e),Je=a(e),U=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1ym6zda"&&(U.innerHTML=_e),Te=a(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-big3u0"&&(S.innerHTML=Re),we=a(e),p(Y.$$.fragment,e),be=a(e),H=i(e,"P",{}),ze(H).forEach(s),this.h()},h(){Ae(y,"name","hf:doc:metadata"),Ae(y,"content",Ke),Ae(U,"class","flex justify-center")},m(e,l){Ve(document.head,y),t(e,X,l),t(e,N,l),t(e,V,l),r(h,e,l),t(e,L,l),t(e,J,l),t(e,D,l),r(T,e,l),t(e,P,l),t(e,w,l),t(e,K,l),r(b,e,l),t(e,O,l),t(e,f,l),t(e,ee,l),r(A,e,l),t(e,le,l),t(e,C,l),t(e,se,l),r(g,e,l),t(e,te,l),t(e,I,l),t(e,ne,l),r(q,e,l),t(e,ae,l),t(e,v,l),t(e,Me,l),t(e,$,l),t(e,ie,l),r(G,e,l),t(e,oe,l),t(e,k,l),t(e,ue,l),r(x,e,l),t(e,pe,l),t(e,Z,l),t(e,re,l),t(e,E,l),t(e,ce,l),r(B,e,l),t(e,de,l),t(e,Q,l),t(e,je,l),r(W,e,l),t(e,me,l),t(e,_,l),t(e,ye,l),r(R,e,l),t(e,Ue,l),t(e,z,l),t(e,he,l),r(F,e,l),t(e,Je,l),t(e,U,l),t(e,Te,l),t(e,S,l),t(e,we,l),r(Y,e,l),t(e,be,l),t(e,H,l),fe=!0},p:Se,i(e){fe||(c(h.$$.fragment,e),c(T.$$.fragment,e),c(b.$$.fragment,e),c(A.$$.fragment,e),c(g.$$.fragment,e),c(q.$$.fragment,e),c(G.$$.fragment,e),c(x.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(Y.$$.fragment,e),fe=!0)},o(e){d(h.$$.fragment,e),d(T.$$.fragment,e),d(b.$$.fragment,e),d(A.$$.fragment,e),d(g.$$.fragment,e),d(q.$$.fragment,e),d(G.$$.fragment,e),d(x.$$.fragment,e),d(B.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(Y.$$.fragment,e),fe=!1},d(e){e&&(s(X),s(N),s(V),s(L),s(J),s(D),s(P),s(w),s(K),s(O),s(f),s(ee),s(le),s(C),s(se),s(te),s(I),s(ne),s(ae),s(v),s(Me),s($),s(ie),s(oe),s(k),s(ue),s(pe),s(Z),s(re),s(E),s(ce),s(de),s(Q),s(je),s(me),s(_),s(ye),s(Ue),s(z),s(he),s(Je),s(U),s(Te),s(S),s(we),s(be),s(H)),s(y),j(h,e),j(T,e),j(b,e),j(A,e),j(g,e),j(q,e),j(G,e),j(x,e),j(B,e),j(W,e),j(R,e),j(F,e),j(Y,e)}}}const Ke='{"title":"Charger et explorer un jeu de données audio","local":"charger-et-explorer-un-jeu-de-données-audio","sections":[],"depth":1}';function Oe(Ce){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nl extends Ne{constructor(y){super(),He(this,y,Oe,Pe,Fe,{})}}export{nl as component};
