import{s as fe,f as Ue,n as ge,o as Be}from"../chunks/scheduler.889ebb13.js";import{S as Ie,i as _e,g as i,s as n,r as h,A as Ge,h as o,f as e,c as a,j as be,u,x as p,k as Zs,y as ke,a as l,v as r,d as M,t as c,w}from"../chunks/index.ca18042b.js";import{C as y}from"../chunks/CodeBlock.1db71023.js";import{H as Ys}from"../chunks/Heading.3daa581c.js";import{E as Ce}from"../chunks/EditOnGithub.2e95618d.js";function $e(Ns){let j,Bt,Ut,It,d,_t,m,Ws,Gt,T,Rs="This course is framework-agnostic because we want to <strong>focus on the concepts of AI agents and avoid getting bogged down in the specifics of a particular framework</strong>.",kt,J,Es="Also, we want students to be able to use the concepts they learn in this course in their own projects, using any framework they like.",Ct,b,Qs="Therefore, for this Unit 1, we will use a dummy agent library and a simple serverless API to access our LLM engine.",$t,f,Vs="You probably wouldn’t use these in production, but they will serve as a good <strong>starting point for understanding how agents work</strong>.",vt,U,Fs="After this section, you’ll be ready to <strong>create a simple Agent</strong> using <code>smolagents</code>",xt,g,As="And in the following Units we will also use other AI Agent libraries like <code>LangGraph</code>, <code>LangChain</code>, and <code>LlamaIndex</code>.",Xt,B,Hs="To keep things simple we will use a simple Python function as a Tool and Agent.",qt,I,Ls="We will use built-in Python packages like <code>datetime</code> and <code>os</code> so that you can try it out in any environment.",Zt,_,zs='You can follow the process <a href="https://huggingface.co/agents-course/notebooks/blob/main/dummy_agent_library.ipynb" rel="nofollow">in this notebook</a> and <strong>run the code yourself</strong>.',Yt,G,Nt,k,Ss="In the Hugging Face ecosystem, there is a convenient feature called Serverless API that allows you to easily run inference on many models. There’s no installation or deployment required.",Wt,C,Rt,$,Et,v,Ps="output:",Qt,x,Vt,X,Os="As seen in the LLM section, if we just do decoding, <strong>the model will only stop when it predicts an EOS token</strong>, and this does not happen here because this is a conversational (chat) model and <strong>we didn’t apply the chat template it expects</strong>.",Ft,q,Ds='If we now add the special tokens related to the <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct">Llama-3.2-3B-Instruct model</a> that we’re using, the behavior changes and it now produces the expected EOS.',At,Z,Ht,Y,Ks="output:",Lt,N,zt,W,te="Using the “chat” method is a much more convenient and reliable way to apply chat templates:",St,R,Pt,E,se="output:",Ot,Q,Dt,V,ee="The chat method is the RECOMMENDED method to use in order to ensure a smooth transition between models, but since this notebook is only educational, we will keep using the “text_generation” method to understand the details.",Kt,F,ts,A,le="In the previous sections, we saw that the core of an agent library is to append information in the system prompt.",ss,H,ne="This system prompt is a bit more complex than the one we saw earlier, but it already contains:",es,L,ae="<li><strong>Information about the tools</strong></li> <li><strong>Cycle instructions</strong> (Thought → Action → Observation)</li>",ls,z,ns,S,ie="Since we are running the “text_generation” method, we need to apply the prompt manually:",as,P,is,O,oe="We can also do it like this, which is what happens inside the <code>chat</code> method :",os,D,ps,K,pe="The prompt now is :",hs,tt,us,st,he="Let’s decode!",rs,et,Ms,lt,ue="output:",cs,nt,ws,at,re="Do you see the issue?",ys,it,Me=`<p>The answer was hallucinated by the model. We need to stop to actually execute the function!
Let’s now stop on “Observation” so that we don’t hallucinate the actual function response.</p>`,js,ot,ds,pt,ce="output:",ms,ht,Ts,ut,we=`Much Better!
Let’s now create a dummy get weather function.  In a real situation, you would likely call an API.`,Js,rt,bs,Mt,ye="output:",fs,ct,Us,wt,je="Let’s concatenate the base prompt, the completion until function execution and the result of the function as an Observation and resume generation.",gs,yt,Bs,jt,de="Here is the new prompt:",Is,dt,_s,mt,me="Output:",Gs,Tt,ks,Cs,$s,Jt,Te="We learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by handling much of the heavy lifting for you.",vs,bt,Je="Now, we’re ready <strong>to create our first real Agent</strong> using the <code>smolagents</code> library.",xs,ft,Xs,gt,qs;return d=new Ys({props:{title:"Dummy Agent Library",local:"dummy-agent-library",headingTag:"h1"}}),G=new Ys({props:{title:"Serverless API",local:"serverless-api",headingTag:"h2"}}),C=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIzJTIwWW91JTIwbmVlZCUyMGElMjB0b2tlbiUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmhmLmNvJTJGc2V0dGluZ3MlMkZ0b2tlbnMlMkMlMjBlbnN1cmUlMjB0aGF0JTIweW91JTIwc2VsZWN0JTIwJ3JlYWQnJTIwYXMlMjB0aGUlMjB0b2tlbiUyMHR5cGUuJTIwSWYlMjB5b3UlMjBydW4lMjB0aGlzJTIwb24lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMGNhbiUyMHNldCUyMGl0JTIwdXAlMjBpbiUyMHRoZSUyMCUyMnNldHRpbmdzJTIyJTIwdGFiJTIwdW5kZXIlMjAlMjJzZWNyZXRzJTIyLiUyME1ha2UlMjBzdXJlJTIwdG8lMjBjYWxsJTIwaXQlMjAlMjJIRl9UT0tFTiUyMiUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUzRCUyMmhmX3h4eHh4eHh4eHh4eHh4JTIyJTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTIzJTIwaWYlMjB0aGUlMjBvdXRwdXRzJTIwZm9yJTIwbmV4dCUyMGNlbGxzJTIwYXJlJTIwd3JvbmclMkMlMjB0aGUlMjBmcmVlJTIwbW9kZWwlMjBtYXklMjBiZSUyMG92ZXJsb2FkZWQuJTIwWW91JTIwY2FuJTIwYWxzbyUyMHVzZSUyMHRoaXMlMjBwdWJsaWMlMjBlbmRwb2ludCUyMHRoYXQlMjBjb250YWlucyUyMExsYW1hLTMuMi0zQi1JbnN0cnVjdCUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmpjMjZtd2cyMjhta2o4ZHcudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment">## You need a token from https://hf.co/settings/tokens, ensure that you select &#x27;read&#x27; as the token type. If you run this on Google Colab, you can set it up in the &quot;settings&quot; tab under &quot;secrets&quot;. Make sure to call it &quot;HF_TOKEN&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>]=<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>

client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)
<span class="hljs-comment"># if the outputs for next cells are wrong, the free model may be overloaded. You can also use this public endpoint that contains Llama-3.2-3B-Instruct</span>
<span class="hljs-comment"># client = InferenceClient(&quot;https://jc26mwg228mkj8dw.us-east-1.aws.endpoints.huggingface.cloud&quot;)</span>`,wrap:!1}}),$=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`output = client.text_generation(
    <span class="hljs-string">&quot;The capital of France is&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),x=new y({props:{code:"UGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLg==",highlighted:'Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),Z=new y({props:{code:"cHJvbXB0JTNEJTIyJTIyJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTIyJTIyJTIyJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`prompt=<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
The capital of France is&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;&quot;&quot;&quot;</span>
output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),N=new y({props:{code:"VGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4=",highlighted:'The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),R=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQXByaW50KG91dHB1dC5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQp",highlighted:`output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The capital of France is&quot;</span>},
    ],
    stream=<span class="hljs-literal">False</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)
<span class="hljs-built_in">print</span>(output.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),Q=new y({props:{code:"UGFyaXMu",highlighted:"Paris.",wrap:!1}}),F=new Ys({props:{title:"Dummy Agent",local:"dummy-agent",headingTag:"h2"}}),z=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you <span class="hljs-keyword">use</span> the tools is by specifying a json blob.
Specifically, <span class="hljs-keyword">this</span> json should have an \`action\` key (<span class="hljs-keyword">with</span> the name of the tool to <span class="hljs-keyword">use</span>) <span class="hljs-keyword">and</span> an \`action_input\` key (<span class="hljs-keyword">with</span> the <span class="hljs-keyword">input</span> to the tool going here).

The only values that should be in the <span class="hljs-string">&quot;action&quot;</span> field are:
get_weather: Get the current weather in a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example <span class="hljs-keyword">use</span> : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS <span class="hljs-keyword">use</span> the following format:

Question: the <span class="hljs-keyword">input</span> question you must answer
Thought: you should <span class="hljs-keyword">always</span> think about one action to take. Only one action at a <span class="hljs-keyword">time</span> in <span class="hljs-keyword">this</span> format:
Action:

$JSON_BLOB (<span class="hljs-keyword">inside</span> markdown <span class="hljs-keyword">cell</span>)

Observation: the result of the action. This Observation is <span class="hljs-keyword">unique</span>, complete, <span class="hljs-keyword">and</span> the source of truth.
... (<span class="hljs-keyword">this</span> Thought/Action/Observation can <span class="hljs-keyword">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown <span class="hljs-keyword">and</span> only <span class="hljs-keyword">use</span> a SINGLE action at a <span class="hljs-keyword">time</span>.)

You must <span class="hljs-keyword">always</span> <span class="hljs-keyword">end</span> your <span class="hljs-keyword">output</span> <span class="hljs-keyword">with</span> the following format:

Thought: I now know the <span class="hljs-keyword">final</span> answer
Final Answer: the <span class="hljs-keyword">final</span> answer to the original <span class="hljs-keyword">input</span> question

Now <span class="hljs-keyword">begin</span>! Reminder to ALWAYS <span class="hljs-keyword">use</span> the exact characters \`Final Answer:\` when you provide a definitive answer.`,wrap:!1}}),P=new y({props:{code:"cHJvbXB0JTNEZiUyMiUyMiUyMiUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTdCU1lTVEVNX1BST01QVCU3RCUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwJTNGJTBBJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-attr">prompt</span>=f<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
{SYSTEM_PROMPT}
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weather in London ?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),D=new y({props:{code:"bWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjAlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather in London ?&quot;</span>},
    ]
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)

tokenizer.apply_chat_template(messages, <span class="hljs-keyword">tokenize</span>=<span class="hljs-keyword">False</span>,add_generation_prompt=<span class="hljs-keyword">True</span>)`,wrap:!1}}),tt=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have an \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),et=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),nt=new y({props:{code:"QWN0aW9uJTNBJTBBJTYwJTYwJTYwJTBBJTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb25faW5wdXQlMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RCUwQSU2MCU2MCU2MCUwQVRob3VnaHQlM0ElMjBJJTIwd2lsbCUyMGNoZWNrJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uLiUwQU9ic2VydmF0aW9uJTNBJTIwVGhlJTIwY3VycmVudCUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwbW9zdGx5JTIwY2xvdWR5JTIwd2l0aCUyMGElMjBoaWdoJTIwb2YlMjAxMiVDMiVCMEMlMjBhbmQlMjBhJTIwbG93JTIwb2YlMjA4JUMyJUIwQy4=",highlighted:`Action:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation: The current weather in London is mostly cloudy with a high of 12°C<span class="hljs-built_in"> and </span>a low of 8°C.`,wrap:!1}}),ot=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0QlNUIlMjJPYnNlcnZhdGlvbiUzQSUyMiU1RCUyMCUyMyUyMExldCdzJTIwc3RvcCUyMGJlZm9yZSUyMGFueSUyMGFjdHVhbCUyMGZ1bmN0aW9uJTIwaXMlMjBjYWxsZWQlMEEpJTBBJTBBcHJpbnQob3V0cHV0KQ==",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
    stop=[<span class="hljs-string">&quot;Observation:&quot;</span>] <span class="hljs-comment"># Let&#x27;s stop before any actual function is called</span>
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),ht=new y({props:{code:"QWN0aW9uJTNBJTBBJTYwJTYwJTYwJTBBJTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb25faW5wdXQlMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RCUwQSU2MCU2MCU2MCUwQVRob3VnaHQlM0ElMjBJJTIwd2lsbCUyMGNoZWNrJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uLiUwQU9ic2VydmF0aW9uJTNB",highlighted:`Action:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation:`,wrap:!1}}),rt=new y({props:{code:"JTIzJTIwRHVtbXklMjBmdW5jdGlvbiUwQWRlZiUyMGdldF93ZWF0aGVyKGxvY2F0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJ0aGUlMjB3ZWF0aGVyJTIwaW4lMjAlN0Jsb2NhdGlvbiU3RCUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24lMjIlMEElMEFnZXRfd2VhdGhlcignTG9uZG9uJyk=",highlighted:`<span class="hljs-comment"># Dummy function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;the weather in <span class="hljs-subst">{location}</span> is sunny with low temperatures. \\n&quot;</span>

get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)`,wrap:!1}}),ct=new y({props:{code:"J3RoZSUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24n",highlighted:'<span class="hljs-symbol">&#x27;the</span> weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n&#x27;',wrap:!1}}),yt=new y({props:{code:"bmV3X3Byb21wdCUyMCUzRCUyMHByb21wdCUyMCUyQiUyMG91dHB1dCUyMCUyQiUyMGdldF93ZWF0aGVyKCdMb25kb24nKSUwQWZpbmFsX291dHB1dCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwbmV3X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTBBKSUwQSUwQXByaW50KGZpbmFsX291dHB1dCk=",highlighted:`new_prompt = prompt + output + get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)
final_output = client.text_generation(
    new_prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(final_output)`,wrap:!1}}),dt=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
    Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Action</span>:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Thought: I will check the weather <span class="hljs-built_in">in</span> London.
Observation:the weather <span class="hljs-built_in">in</span> London is sunny <span class="hljs-built_in">with</span> low temperatures. `,wrap:!1}}),Tt=new y({props:{code:"RmluYWwlMjBBbnN3ZXIlM0ElMjBUaGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4=",highlighted:'<span class="hljs-keyword">Final</span> Answer: The weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures.',wrap:!1}}),ft=new Ce({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/dummy-agent-library.mdx"}}),{c(){j=i("meta"),Bt=n(),Ut=i("p"),It=n(),h(d.$$.fragment),_t=n(),m=i("img"),Gt=n(),T=i("p"),T.innerHTML=Rs,kt=n(),J=i("p"),J.textContent=Es,Ct=n(),b=i("p"),b.textContent=Qs,$t=n(),f=i("p"),f.innerHTML=Vs,vt=n(),U=i("p"),U.innerHTML=Fs,xt=n(),g=i("p"),g.innerHTML=As,Xt=n(),B=i("p"),B.textContent=Hs,qt=n(),I=i("p"),I.innerHTML=Ls,Zt=n(),_=i("p"),_.innerHTML=zs,Yt=n(),h(G.$$.fragment),Nt=n(),k=i("p"),k.textContent=Ss,Wt=n(),h(C.$$.fragment),Rt=n(),h($.$$.fragment),Et=n(),v=i("p"),v.textContent=Ps,Qt=n(),h(x.$$.fragment),Vt=n(),X=i("p"),X.innerHTML=Os,Ft=n(),q=i("p"),q.innerHTML=Ds,At=n(),h(Z.$$.fragment),Ht=n(),Y=i("p"),Y.textContent=Ks,Lt=n(),h(N.$$.fragment),zt=n(),W=i("p"),W.textContent=te,St=n(),h(R.$$.fragment),Pt=n(),E=i("p"),E.textContent=se,Ot=n(),h(Q.$$.fragment),Dt=n(),V=i("p"),V.textContent=ee,Kt=n(),h(F.$$.fragment),ts=n(),A=i("p"),A.textContent=le,ss=n(),H=i("p"),H.textContent=ne,es=n(),L=i("ol"),L.innerHTML=ae,ls=n(),h(z.$$.fragment),ns=n(),S=i("p"),S.textContent=ie,as=n(),h(P.$$.fragment),is=n(),O=i("p"),O.innerHTML=oe,os=n(),h(D.$$.fragment),ps=n(),K=i("p"),K.textContent=pe,hs=n(),h(tt.$$.fragment),us=n(),st=i("p"),st.textContent=he,rs=n(),h(et.$$.fragment),Ms=n(),lt=i("p"),lt.textContent=ue,cs=n(),h(nt.$$.fragment),ws=n(),at=i("p"),at.textContent=re,ys=n(),it=i("blockquote"),it.innerHTML=Me,js=n(),h(ot.$$.fragment),ds=n(),pt=i("p"),pt.textContent=ce,ms=n(),h(ht.$$.fragment),Ts=n(),ut=i("p"),ut.textContent=we,Js=n(),h(rt.$$.fragment),bs=n(),Mt=i("p"),Mt.textContent=ye,fs=n(),h(ct.$$.fragment),Us=n(),wt=i("p"),wt.textContent=je,gs=n(),h(yt.$$.fragment),Bs=n(),jt=i("p"),jt.textContent=de,Is=n(),h(dt.$$.fragment),_s=n(),mt=i("p"),mt.textContent=me,Gs=n(),h(Tt.$$.fragment),ks=n(),Cs=i("hr"),$s=n(),Jt=i("p"),Jt.innerHTML=Te,vs=n(),bt=i("p"),bt.innerHTML=Je,xs=n(),h(ft.$$.fragment),Xs=n(),gt=i("p"),this.h()},l(t){const s=Ge("svelte-u9bgzb",document.head);j=o(s,"META",{name:!0,content:!0}),s.forEach(e),Bt=a(t),Ut=o(t,"P",{}),be(Ut).forEach(e),It=a(t),u(d.$$.fragment,t),_t=a(t),m=o(t,"IMG",{src:!0,alt:!0}),Gt=a(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1rwfam6"&&(T.innerHTML=Rs),kt=a(t),J=o(t,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1pvln0h"&&(J.textContent=Es),Ct=a(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-17n0axy"&&(b.textContent=Qs),$t=a(t),f=o(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1ssvh5p"&&(f.innerHTML=Vs),vt=a(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-r0w337"&&(U.innerHTML=Fs),xt=a(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-9snja6"&&(g.innerHTML=As),Xt=a(t),B=o(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-scmak8"&&(B.textContent=Hs),qt=a(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-10qtj1b"&&(I.innerHTML=Ls),Zt=a(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1fa85bb"&&(_.innerHTML=zs),Yt=a(t),u(G.$$.fragment,t),Nt=a(t),k=o(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1y7mhy7"&&(k.textContent=Ss),Wt=a(t),u(C.$$.fragment,t),Rt=a(t),u($.$$.fragment,t),Et=a(t),v=o(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1wueeet"&&(v.textContent=Ps),Qt=a(t),u(x.$$.fragment,t),Vt=a(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14l0pz9"&&(X.innerHTML=Os),Ft=a(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1891xc3"&&(q.innerHTML=Ds),At=a(t),u(Z.$$.fragment,t),Ht=a(t),Y=o(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1wueeet"&&(Y.textContent=Ks),Lt=a(t),u(N.$$.fragment,t),zt=a(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-10i9u01"&&(W.textContent=te),St=a(t),u(R.$$.fragment,t),Pt=a(t),E=o(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1wueeet"&&(E.textContent=se),Ot=a(t),u(Q.$$.fragment,t),Dt=a(t),V=o(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-o9oayq"&&(V.textContent=ee),Kt=a(t),u(F.$$.fragment,t),ts=a(t),A=o(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-xr84ar"&&(A.textContent=le),ss=a(t),H=o(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1m7y210"&&(H.textContent=ne),es=a(t),L=o(t,"OL",{"data-svelte-h":!0}),p(L)!=="svelte-27sevg"&&(L.innerHTML=ae),ls=a(t),u(z.$$.fragment,t),ns=a(t),S=o(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1jc27vd"&&(S.textContent=ie),as=a(t),u(P.$$.fragment,t),is=a(t),O=o(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1letw4p"&&(O.innerHTML=oe),os=a(t),u(D.$$.fragment,t),ps=a(t),K=o(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-u9o4sn"&&(K.textContent=pe),hs=a(t),u(tt.$$.fragment,t),us=a(t),st=o(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-18yryy0"&&(st.textContent=he),rs=a(t),u(et.$$.fragment,t),Ms=a(t),lt=o(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1wueeet"&&(lt.textContent=ue),cs=a(t),u(nt.$$.fragment,t),ws=a(t),at=o(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-azbr52"&&(at.textContent=re),ys=a(t),it=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),p(it)!=="svelte-12w90z8"&&(it.innerHTML=Me),js=a(t),u(ot.$$.fragment,t),ds=a(t),pt=o(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1wueeet"&&(pt.textContent=ce),ms=a(t),u(ht.$$.fragment,t),Ts=a(t),ut=o(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-1ndvzyl"&&(ut.textContent=we),Js=a(t),u(rt.$$.fragment,t),bs=a(t),Mt=o(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1wueeet"&&(Mt.textContent=ye),fs=a(t),u(ct.$$.fragment,t),Us=a(t),wt=o(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-18w5bdv"&&(wt.textContent=je),gs=a(t),u(yt.$$.fragment,t),Bs=a(t),jt=o(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-smcbfz"&&(jt.textContent=de),Is=a(t),u(dt.$$.fragment,t),_s=a(t),mt=o(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1wuxk0l"&&(mt.textContent=me),Gs=a(t),u(Tt.$$.fragment,t),ks=a(t),Cs=o(t,"HR",{}),$s=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-1qq5buo"&&(Jt.innerHTML=Te),vs=a(t),bt=o(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-1ef9lfw"&&(bt.innerHTML=Je),xs=a(t),u(ft.$$.fragment,t),Xs=a(t),gt=o(t,"P",{}),be(gt).forEach(e),this.h()},h(){Zs(j,"name","hf:doc:metadata"),Zs(j,"content",ve),Ue(m.src,Ws="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-unit1sub3DONE.jpg")||Zs(m,"src",Ws),Zs(m,"alt","Unit 1 planning")},m(t,s){ke(document.head,j),l(t,Bt,s),l(t,Ut,s),l(t,It,s),r(d,t,s),l(t,_t,s),l(t,m,s),l(t,Gt,s),l(t,T,s),l(t,kt,s),l(t,J,s),l(t,Ct,s),l(t,b,s),l(t,$t,s),l(t,f,s),l(t,vt,s),l(t,U,s),l(t,xt,s),l(t,g,s),l(t,Xt,s),l(t,B,s),l(t,qt,s),l(t,I,s),l(t,Zt,s),l(t,_,s),l(t,Yt,s),r(G,t,s),l(t,Nt,s),l(t,k,s),l(t,Wt,s),r(C,t,s),l(t,Rt,s),r($,t,s),l(t,Et,s),l(t,v,s),l(t,Qt,s),r(x,t,s),l(t,Vt,s),l(t,X,s),l(t,Ft,s),l(t,q,s),l(t,At,s),r(Z,t,s),l(t,Ht,s),l(t,Y,s),l(t,Lt,s),r(N,t,s),l(t,zt,s),l(t,W,s),l(t,St,s),r(R,t,s),l(t,Pt,s),l(t,E,s),l(t,Ot,s),r(Q,t,s),l(t,Dt,s),l(t,V,s),l(t,Kt,s),r(F,t,s),l(t,ts,s),l(t,A,s),l(t,ss,s),l(t,H,s),l(t,es,s),l(t,L,s),l(t,ls,s),r(z,t,s),l(t,ns,s),l(t,S,s),l(t,as,s),r(P,t,s),l(t,is,s),l(t,O,s),l(t,os,s),r(D,t,s),l(t,ps,s),l(t,K,s),l(t,hs,s),r(tt,t,s),l(t,us,s),l(t,st,s),l(t,rs,s),r(et,t,s),l(t,Ms,s),l(t,lt,s),l(t,cs,s),r(nt,t,s),l(t,ws,s),l(t,at,s),l(t,ys,s),l(t,it,s),l(t,js,s),r(ot,t,s),l(t,ds,s),l(t,pt,s),l(t,ms,s),r(ht,t,s),l(t,Ts,s),l(t,ut,s),l(t,Js,s),r(rt,t,s),l(t,bs,s),l(t,Mt,s),l(t,fs,s),r(ct,t,s),l(t,Us,s),l(t,wt,s),l(t,gs,s),r(yt,t,s),l(t,Bs,s),l(t,jt,s),l(t,Is,s),r(dt,t,s),l(t,_s,s),l(t,mt,s),l(t,Gs,s),r(Tt,t,s),l(t,ks,s),l(t,Cs,s),l(t,$s,s),l(t,Jt,s),l(t,vs,s),l(t,bt,s),l(t,xs,s),r(ft,t,s),l(t,Xs,s),l(t,gt,s),qs=!0},p:ge,i(t){qs||(M(d.$$.fragment,t),M(G.$$.fragment,t),M(C.$$.fragment,t),M($.$$.fragment,t),M(x.$$.fragment,t),M(Z.$$.fragment,t),M(N.$$.fragment,t),M(R.$$.fragment,t),M(Q.$$.fragment,t),M(F.$$.fragment,t),M(z.$$.fragment,t),M(P.$$.fragment,t),M(D.$$.fragment,t),M(tt.$$.fragment,t),M(et.$$.fragment,t),M(nt.$$.fragment,t),M(ot.$$.fragment,t),M(ht.$$.fragment,t),M(rt.$$.fragment,t),M(ct.$$.fragment,t),M(yt.$$.fragment,t),M(dt.$$.fragment,t),M(Tt.$$.fragment,t),M(ft.$$.fragment,t),qs=!0)},o(t){c(d.$$.fragment,t),c(G.$$.fragment,t),c(C.$$.fragment,t),c($.$$.fragment,t),c(x.$$.fragment,t),c(Z.$$.fragment,t),c(N.$$.fragment,t),c(R.$$.fragment,t),c(Q.$$.fragment,t),c(F.$$.fragment,t),c(z.$$.fragment,t),c(P.$$.fragment,t),c(D.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),c(nt.$$.fragment,t),c(ot.$$.fragment,t),c(ht.$$.fragment,t),c(rt.$$.fragment,t),c(ct.$$.fragment,t),c(yt.$$.fragment,t),c(dt.$$.fragment,t),c(Tt.$$.fragment,t),c(ft.$$.fragment,t),qs=!1},d(t){t&&(e(Bt),e(Ut),e(It),e(_t),e(m),e(Gt),e(T),e(kt),e(J),e(Ct),e(b),e($t),e(f),e(vt),e(U),e(xt),e(g),e(Xt),e(B),e(qt),e(I),e(Zt),e(_),e(Yt),e(Nt),e(k),e(Wt),e(Rt),e(Et),e(v),e(Qt),e(Vt),e(X),e(Ft),e(q),e(At),e(Ht),e(Y),e(Lt),e(zt),e(W),e(St),e(Pt),e(E),e(Ot),e(Dt),e(V),e(Kt),e(ts),e(A),e(ss),e(H),e(es),e(L),e(ls),e(ns),e(S),e(as),e(is),e(O),e(os),e(ps),e(K),e(hs),e(us),e(st),e(rs),e(Ms),e(lt),e(cs),e(ws),e(at),e(ys),e(it),e(js),e(ds),e(pt),e(ms),e(Ts),e(ut),e(Js),e(bs),e(Mt),e(fs),e(Us),e(wt),e(gs),e(Bs),e(jt),e(Is),e(_s),e(mt),e(Gs),e(ks),e(Cs),e($s),e(Jt),e(vs),e(bt),e(xs),e(Xs),e(gt)),e(j),w(d,t),w(G,t),w(C,t),w($,t),w(x,t),w(Z,t),w(N,t),w(R,t),w(Q,t),w(F,t),w(z,t),w(P,t),w(D,t),w(tt,t),w(et,t),w(nt,t),w(ot,t),w(ht,t),w(rt,t),w(ct,t),w(yt,t),w(dt,t),w(Tt,t),w(ft,t)}}}const ve='{"title":"Dummy Agent Library","local":"dummy-agent-library","sections":[{"title":"Serverless API","local":"serverless-api","sections":[],"depth":2},{"title":"Dummy Agent","local":"dummy-agent","sections":[],"depth":2}],"depth":1}';function xe(Ns){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends Ie{constructor(j){super(),_e(this,j,xe,$e,fe,{})}}export{We as component};
