import{s as We,o as Ee,n as Pe}from"../chunks/scheduler.8c3d61f6.js";import{S as Re,i as Ne,g as p,s as n,r as d,A as Be,h as o,f as s,c as i,j as Ie,u,x as c,k as He,y as Se,a as l,v as f,d as m,t as h,w}from"../chunks/index.589a98e8.js";import{T as ze}from"../chunks/Tip.42aa8582.js";import{C as A}from"../chunks/CodeBlock.36627b28.js";import{H as ye,E as Xe}from"../chunks/EditOnGithub.e5a8d9cb.js";function xe(x){let a,y='To learn more, take a look at the <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed Inference with 🤗 Accelerate</a> guide.';return{c(){a=p("p"),a.innerHTML=y},l(r){a=o(r,"P",{"data-svelte-h":!0}),c(a)!=="svelte-c8rg1s"&&(a.innerHTML=y)},m(r,M){l(r,a,M)},p:Pe,d(r){r&&s(a)}}}function Ae(x){let a,y='You can use <code>device_map</code> within a <a href="/docs/diffusers/pr_7930/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to distribute its model-level components on multiple devices. Refer to the <a href="../tutorials/inference_with_big_models#device-placement">Device placement</a> guide to learn more.';return{c(){a=p("p"),a.innerHTML=y},l(r){a=o(r,"P",{"data-svelte-h":!0}),c(a)!=="svelte-v30zuz"&&(a.innerHTML=y)},m(r,M){l(r,a,M)},p:Pe,d(r){r&&s(a)}}}function Ve(x){let a,y,r,M,J,Y,g,Me='On distributed setups, you can run inference across multiple GPUs with 🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> or <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a>, which is useful for generating with multiple prompts in parallel.',D,$,be="This guide will show you how to use 🤗 Accelerate and PyTorch Distributed for distributed inference.",L,_,Q,U,Te='🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> is a library designed to make it easy to train or run inference across distributed setups. It simplifies the process of setting up the distributed environment, allowing you to focus on your PyTorch code.',F,j,Je='To begin, create a Python file and initialize an <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> to create a distributed environment; your setup is automatically detected so you don’t need to explicitly define the <code>rank</code> or <code>world_size</code>. Move the <a href="/docs/diffusers/pr_7930/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>distributed_state.device</code> to assign a GPU to each process.',q,Z,ge='Now use the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',K,v,O,C,$e="Use the <code>--num_processes</code> argument to specify the number of GPUs to use, and call <code>accelerate launch</code> to run the script:",ee,G,te,b,se,k,le,I,_e='PyTorch supports <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow"><code>DistributedDataParallel</code></a> which enables data parallelism.',ne,H,Ue='To start, create a Python file and import <code>torch.distributed</code> and <code>torch.multiprocessing</code> to set up the distributed process group and to spawn the processes for inference on each GPU. You should also initialize a <a href="/docs/diffusers/pr_7930/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',ie,z,ae,P,je='You’ll want to create a function to run inference; <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow"><code>init_process_group</code></a> handles creating a distributed environment with the type of backend to use, the <code>rank</code> of the current process, and the <code>world_size</code> or the number of processes participating. If you’re running inference in parallel over 2 GPUs, then the <code>world_size</code> is 2.',re,W,Ze='Move the <a href="/docs/diffusers/pr_7930/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process, where each process handles a different prompt:',pe,E,oe,R,ve='To run the distributed inference, call <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow"><code>mp.spawn</code></a> to run the <code>run_inference</code> function on the number of GPUs defined in <code>world_size</code>:',ce,N,de,B,Ce="Once you’ve completed the inference script, use the <code>--nproc_per_node</code> argument to specify the number of GPUs to use and call <code>torchrun</code> to run the script:",ue,S,fe,T,me,X,he,V,we;return J=new ye({props:{title:"Distributed inference with multiple GPUs",local:"distributed-inference-with-multiple-gpus",headingTag:"h1"}}),_=new ye({props:{title:"🤗 Accelerate",local:"-accelerate",headingTag:"h2"}}),v=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFkaXN0cmlidXRlZF9zdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBcGlwZWxpbmUudG8oZGlzdHJpYnV0ZWRfc3RhdGUuZGV2aWNlKSUwQSUwQXdpdGglMjBkaXN0cmlidXRlZF9zdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJhJTIwZG9nJTIyJTJDJTIwJTIyYSUyMGNhdCUyMiU1RCklMjBhcyUyMHByb21wdCUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCkuaW1hZ2VzJTVCMCU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdC5zYXZlKGYlMjJyZXN1bHRfJTdCZGlzdHJpYnV0ZWRfc3RhdGUucHJvY2Vzc19pbmRleCU3RC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)

<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),G=new A({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),b=new ze({props:{$$slots:{default:[xe]},$$scope:{ctx:x}}}),k=new ye({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),z=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzZCUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

sd = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),E=new A({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBzZC50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    sd.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),N=new A({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),S=new A({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),T=new ze({props:{warning:!1,$$slots:{default:[Ae]},$$scope:{ctx:x}}}),X=new Xe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/distributed_inference.md"}}),{c(){a=p("meta"),y=n(),r=p("p"),M=n(),d(J.$$.fragment),Y=n(),g=p("p"),g.innerHTML=Me,D=n(),$=p("p"),$.textContent=be,L=n(),d(_.$$.fragment),Q=n(),U=p("p"),U.innerHTML=Te,F=n(),j=p("p"),j.innerHTML=Je,q=n(),Z=p("p"),Z.innerHTML=ge,K=n(),d(v.$$.fragment),O=n(),C=p("p"),C.innerHTML=$e,ee=n(),d(G.$$.fragment),te=n(),d(b.$$.fragment),se=n(),d(k.$$.fragment),le=n(),I=p("p"),I.innerHTML=_e,ne=n(),H=p("p"),H.innerHTML=Ue,ie=n(),d(z.$$.fragment),ae=n(),P=p("p"),P.innerHTML=je,re=n(),W=p("p"),W.innerHTML=Ze,pe=n(),d(E.$$.fragment),oe=n(),R=p("p"),R.innerHTML=ve,ce=n(),d(N.$$.fragment),de=n(),B=p("p"),B.innerHTML=Ce,ue=n(),d(S.$$.fragment),fe=n(),d(T.$$.fragment),me=n(),d(X.$$.fragment),he=n(),V=p("p"),this.h()},l(e){const t=Be("svelte-u9bgzb",document.head);a=o(t,"META",{name:!0,content:!0}),t.forEach(s),y=i(e),r=o(e,"P",{}),Ie(r).forEach(s),M=i(e),u(J.$$.fragment,e),Y=i(e),g=o(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-a7bv7i"&&(g.innerHTML=Me),D=i(e),$=o(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1qu3csy"&&($.textContent=be),L=i(e),u(_.$$.fragment,e),Q=i(e),U=o(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-13uq1g2"&&(U.innerHTML=Te),F=i(e),j=o(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-nehalx"&&(j.innerHTML=Je),q=i(e),Z=o(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1iuwz8b"&&(Z.innerHTML=ge),K=i(e),u(v.$$.fragment,e),O=i(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1ohh8as"&&(C.innerHTML=$e),ee=i(e),u(G.$$.fragment,e),te=i(e),u(b.$$.fragment,e),se=i(e),u(k.$$.fragment,e),le=i(e),I=o(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-jtiddl"&&(I.innerHTML=_e),ne=i(e),H=o(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-16c8zsi"&&(H.innerHTML=Ue),ie=i(e),u(z.$$.fragment,e),ae=i(e),P=o(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-qkdvuf"&&(P.innerHTML=je),re=i(e),W=o(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-gaebob"&&(W.innerHTML=Ze),pe=i(e),u(E.$$.fragment,e),oe=i(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1ecd3vq"&&(R.innerHTML=ve),ce=i(e),u(N.$$.fragment,e),de=i(e),B=o(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-ykaora"&&(B.innerHTML=Ce),ue=i(e),u(S.$$.fragment,e),fe=i(e),u(T.$$.fragment,e),me=i(e),u(X.$$.fragment,e),he=i(e),V=o(e,"P",{}),Ie(V).forEach(s),this.h()},h(){He(a,"name","hf:doc:metadata"),He(a,"content",Ye)},m(e,t){Se(document.head,a),l(e,y,t),l(e,r,t),l(e,M,t),f(J,e,t),l(e,Y,t),l(e,g,t),l(e,D,t),l(e,$,t),l(e,L,t),f(_,e,t),l(e,Q,t),l(e,U,t),l(e,F,t),l(e,j,t),l(e,q,t),l(e,Z,t),l(e,K,t),f(v,e,t),l(e,O,t),l(e,C,t),l(e,ee,t),f(G,e,t),l(e,te,t),f(b,e,t),l(e,se,t),f(k,e,t),l(e,le,t),l(e,I,t),l(e,ne,t),l(e,H,t),l(e,ie,t),f(z,e,t),l(e,ae,t),l(e,P,t),l(e,re,t),l(e,W,t),l(e,pe,t),f(E,e,t),l(e,oe,t),l(e,R,t),l(e,ce,t),f(N,e,t),l(e,de,t),l(e,B,t),l(e,ue,t),f(S,e,t),l(e,fe,t),f(T,e,t),l(e,me,t),f(X,e,t),l(e,he,t),l(e,V,t),we=!0},p(e,[t]){const Ge={};t&2&&(Ge.$$scope={dirty:t,ctx:e}),b.$set(Ge);const ke={};t&2&&(ke.$$scope={dirty:t,ctx:e}),T.$set(ke)},i(e){we||(m(J.$$.fragment,e),m(_.$$.fragment,e),m(v.$$.fragment,e),m(G.$$.fragment,e),m(b.$$.fragment,e),m(k.$$.fragment,e),m(z.$$.fragment,e),m(E.$$.fragment,e),m(N.$$.fragment,e),m(S.$$.fragment,e),m(T.$$.fragment,e),m(X.$$.fragment,e),we=!0)},o(e){h(J.$$.fragment,e),h(_.$$.fragment,e),h(v.$$.fragment,e),h(G.$$.fragment,e),h(b.$$.fragment,e),h(k.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(T.$$.fragment,e),h(X.$$.fragment,e),we=!1},d(e){e&&(s(y),s(r),s(M),s(Y),s(g),s(D),s($),s(L),s(Q),s(U),s(F),s(j),s(q),s(Z),s(K),s(O),s(C),s(ee),s(te),s(se),s(le),s(I),s(ne),s(H),s(ie),s(ae),s(P),s(re),s(W),s(pe),s(oe),s(R),s(ce),s(de),s(B),s(ue),s(fe),s(me),s(he),s(V)),s(a),w(J,e),w(_,e),w(v,e),w(G,e),w(b,e),w(k,e),w(z,e),w(E,e),w(N,e),w(S,e),w(T,e),w(X,e)}}}const Ye='{"title":"Distributed inference with multiple GPUs","local":"distributed-inference-with-multiple-gpus","sections":[{"title":"🤗 Accelerate","local":"-accelerate","sections":[],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2}],"depth":1}';function De(x){return Ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Re{constructor(a){super(),Ne(this,a,De,Ve,We,{})}}export{Oe as component};
