import{s as io,o as co,n as tr}from"../chunks/scheduler.9bc65507.js";import{S as mo,i as po,g as l,s,r as p,A as fo,h as i,f as t,c as a,j as $,u as f,x as d,k as b,y as o,a as n,v as u,d as h,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as la}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.86474e80.js";import{C as sr}from"../chunks/CodeBlock.54a9f38d.js";import{E as ia}from"../chunks/ExampleCodeBlock.034f3a73.js";import{H as pe,E as uo}from"../chunks/EditOnGithub.922df6ba.js";function ho(J){let c,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/pr_30929/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/pr_30929/ja/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kig2ch"&&(c.innerHTML=T)},m(v,x){n(v,c,x)},p:tr,d(v){v&&t(c)}}}function go(J){let c,T="Examples:",v,x,C;return x=new sr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(x.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(x,m,I),C=!0},p:tr,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function _o(J){let c,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=l("p"),c.textContent=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-15rpg4"&&(c.textContent=T)},m(v,x){n(v,c,x)},p:tr,d(v){v&&t(c)}}}function vo(J){let c,T=`This class method is simply calling <a href="/docs/transformers/pr_30929/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/pr_30929/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-9221w4"&&(c.innerHTML=T)},m(v,x){n(v,c,x)},p:tr,d(v){v&&t(c)}}}function xo(J){let c,T="Examples:",v,x,C;return x=new sr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(x.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(x,m,I),C=!0},p:tr,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function $o(J){let c,T="Example:",v,x,C;return x=new sr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(x.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(x,m,I),C=!0},p:tr,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function bo(J){let c,T,v,x,C,m,I,da="Transformers ライブラリでは、プロセッサは 2 つの異なる意味を持ちます。",ar,fe,ca=`<li><a href="../model_doc/wav2vec2">Wav2Vec2</a> などのマルチモーダル モデルの入力を前処理するオブジェクト (音声とテキスト)
または <a href="../model_doc/clip">CLIP</a> (テキストとビジョン)</li> <li>古いバージョンのライブラリで GLUE または SQUAD のデータを前処理するために使用されていたオブジェクトは非推奨になりました。</li>`,or,ue,nr,he,ma=`マルチモーダル モデルでは、オブジェクトが複数のモダリティ (テキスト、
視覚と音声）。これは、2 つ以上の処理オブジェクトをグループ化するプロセッサーと呼ばれるオブジェクトによって処理されます。
トークナイザー (テキスト モダリティ用)、画像プロセッサー (視覚用)、特徴抽出器 (オーディオ用) など。`,lr,ge,pa="これらのプロセッサは、保存およびロード機能を実装する次の基本クラスを継承します。",ir,y,_e,is,Mt,fa="This is a mixin used to provide saving/loading functionality for all processor classes.",ds,F,ve,cs,wt,ua="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",ms,Z,xe,ps,Tt,ha="Instantiate a processor associated with a pretrained model.",fs,R,us,G,$e,hs,Ct,ga=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,gs,q,be,_s,Pt,_a="Upload the processor files to the 🤗 Model Hub.",vs,W,xs,V,ye,$s,It,va=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,bs,Q,ys,z,Me,Ms,jt,xa=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/pr_30929/ja/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ws,Y,Ts,A,we,Cs,Xt,$a="Serializes this instance to a Python dictionary.",Ps,O,Te,Is,Jt,ba="Save this instance to a JSON file.",js,K,Ce,Xs,kt,ya="Serializes this instance to a JSON string.",dr,Pe,cr,Ie,Ma=`すべてのプロセッサは、同じアーキテクチャに従っています。
<a href="/docs/transformers/pr_30929/ja/main_classes/processors#transformers.DataProcessor">DataProcessor</a>。プロセッサは次のリストを返します。
<a href="/docs/transformers/pr_30929/ja/main_classes/processors#transformers.InputExample">InputExample</a>。これら
<a href="/docs/transformers/pr_30929/ja/main_classes/processors#transformers.InputExample">InputExample</a> は次のように変換できます。
<code>~data.processors.utils.Input features</code> をモデルにフィードします。`,mr,P,je,Js,Ut,wa="Base class for data converters for sequence classification data sets.",ks,ee,Xe,Us,Lt,Ta='Gets a collection of <a href="/docs/transformers/pr_30929/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Ls,te,Je,Zs,Zt,Ca="Gets an example from a dict with tensorflow tensors.",qs,re,ke,Vs,qt,Pa="Gets the list of labels for this data set.",zs,se,Ue,Es,Vt,Ia='Gets a collection of <a href="/docs/transformers/pr_30929/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',Hs,ae,Le,Ns,zt,ja='Gets a collection of <a href="/docs/transformers/pr_30929/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Bs,oe,Ze,Ss,Et,Xa=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,pr,k,qe,Ds,Ht,Ja="A single training/test example for simple sequence classification.",Fs,ne,Ve,Rs,Nt,ka="Serializes this instance to a JSON string.",fr,U,ze,Gs,Bt,Ua="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",Ws,le,Ee,Qs,St,La="Serializes this instance to a JSON string.",ur,He,hr,Ne,Za=`<a href="https://gluebenchmark.com/" rel="nofollow">一般言語理解評価 (GLUE)</a> は、
既存の NLU タスクの多様なセットにわたるモデルのパフォーマンス。紙と同時発売された <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A
自然言語理解のためのマルチタスクベンチマークおよび分析プラットフォーム</a>`,gr,Be,qa=`このライブラリは、MRPC、MNLI、MNLI (不一致)、CoLA、SST2、STSB、
QQP、QNLI、RTE、WNLI。`,_r,Se,Va="それらのプロセッサは次のとおりです。",vr,De,za="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",xr,Fe,Ea=`さらに、次のメソッドを使用して、データ ファイルから値をロードし、それらをリストに変換することができます。
<a href="/docs/transformers/pr_30929/ja/main_classes/processors#transformers.InputExample">InputExample</a>。`,$r,N,Re,Ys,Dt,Ha="Loads a data file into a list of <code>InputFeatures</code>",br,Ge,yr,We,Na=`<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">クロスリンガル NLI コーパス (XNLI)</a> は、
言語を超えたテキスト表現の品質。 XNLI は、<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a> に基づくクラウドソースのデータセットです。テキストのペアには、15 個のテキスト含意アノテーションがラベル付けされています。
さまざまな言語 (英語などの高リソース言語とスワヒリ語などの低リソース言語の両方を含む)。`,Mr,Qe,Ba='論文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> と同時にリリースされました。',wr,Ye,Sa="このライブラリは、XNLI データをロードするプロセッサをホストします。",Tr,Ae,Da="<li><code>~data.processors.utils.XnliProcessor</code></li>",Cr,Oe,Fa="テストセットにはゴールドラベルが付いているため、評価はテストセットで行われますのでご了承ください。",Pr,Ke,Ra='これらのプロセッサを使用する例は、<a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> スクリプトに示されています。',Ir,et,jr,tt,Ga=`<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">The Stanford Question Answering Dataset (SQuAD)</a> は、次のベンチマークです。
質問応答に関するモデルのパフォーマンスを評価します。 v1.1 と v2.0 の 2 つのバージョンが利用可能です。最初のバージョン
(v1.1) は、論文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ question for Machine Comprehension of Text</a> とともにリリースされました。 2 番目のバージョン (v2.0) は、論文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t と同時にリリースされました。
知っておくべき: SQuAD の答えられない質問</a>。`,Xr,rt,Wa="このライブラリは、次の 2 つのバージョンのそれぞれのプロセッサをホストします。",Jr,st,kr,at,Qa="それらのプロセッサは次のとおりです。",Ur,ot,Ya="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",Lr,nt,Aa="どちらも抽象クラス <code>~data.processors.utils.SquadProcessor</code> を継承しています。",Zr,X,lt,As,Ft,Oa=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,Os,ie,it,Ks,Rt,Ka="Returns the evaluation example from the data directory.",ea,E,dt,ta,Gt,eo="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ra,de,sa,ce,ct,aa,Wt,to="Returns the training examples from the data directory.",qr,mt,ro=`さらに、次のメソッドを使用して、SQuAD の例を次の形式に変換できます。
モデルの入力として使用できる <code>~data.processors.utils.SquadFeatures</code>。`,Vr,L,pt,oa,Qt,so=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,na,me,zr,ft,ao=`これらのプロセッサと前述の方法は、データを含むファイルだけでなく、
<em>tensorflow_datasets</em> パッケージ。以下に例を示します。`,Er,ut,Hr,ht,oo="以下にプロセッサを使用した例と、データ ファイルを使用した変換方法を示します。",Nr,gt,Br,_t,no="<em>tensorflow_datasets</em> の使用は、データ ファイルを使用するのと同じくらい簡単です。",Sr,vt,Dr,xt,lo='これらのプロセッサを使用する別の例は、<a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> スクリプトに示されています。',Fr,$t,Rr,rr,Gr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"Multi-modal processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L57"}}),ve=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),xe=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/pr_30929/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/pr_30929/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L412"}}),R=new la({props:{$$slots:{default:[ho]},$$scope:{ctx:J}}}),$e=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L257",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),be=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/utils/hub.py#L809"}}),W=new ia({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[go]},$$scope:{ctx:J}}}),ye=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L476"}}),Q=new la({props:{warning:!0,$$slots:{default:[_o]},$$scope:{ctx:J}}}),Me=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/pr_30929/ja/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L168"}}),Y=new la({props:{$$slots:{default:[vo]},$$scope:{ctx:J}}}),we=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L103",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Te=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L152"}}),Ce=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/processing_utils.py#L141",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Pe=new pe({props:{title:"Deprecated processors",local:"transformers.DataProcessor",headingTag:"h2"}}),je=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L80"}}),Xe=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L97"}}),Je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L83"}}),ke=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L105"}}),Ue=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L101"}}),Le=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L93"}}),Ze=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L109"}}),qe=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L29"}}),Ve=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L49"}}),ze=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L54"}}),Ee=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/utils.py#L75"}}),He=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Re=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),Ge=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),et=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),st=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),lt=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/squad.py#L541"}}),it=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/squad.py#L629"}}),dt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),de=new ia({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[xo]},$$scope:{ctx:J}}}),ct=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/squad.py#L607"}}),pt=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/vr_30929/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new ia({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[$o]},$$scope:{ctx:J}}}),ut=new pe({props:{title:"Example usage",local:"example-usage",headingTag:"h3"}}),gt=new sr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),vt=new sr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),$t=new uo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/main_classes/processors.md"}}),{c(){c=l("meta"),T=s(),v=l("p"),x=s(),p(C.$$.fragment),m=s(),I=l("p"),I.textContent=da,ar=s(),fe=l("ul"),fe.innerHTML=ca,or=s(),p(ue.$$.fragment),nr=s(),he=l("p"),he.textContent=ma,lr=s(),ge=l("p"),ge.textContent=pa,ir=s(),y=l("div"),p(_e.$$.fragment),is=s(),Mt=l("p"),Mt.textContent=fa,ds=s(),F=l("div"),p(ve.$$.fragment),cs=s(),wt=l("p"),wt.innerHTML=ua,ms=s(),Z=l("div"),p(xe.$$.fragment),ps=s(),Tt=l("p"),Tt.textContent=ha,fs=s(),p(R.$$.fragment),us=s(),G=l("div"),p($e.$$.fragment),hs=s(),Ct=l("p"),Ct.innerHTML=ga,gs=s(),q=l("div"),p(be.$$.fragment),_s=s(),Pt=l("p"),Pt.textContent=_a,vs=s(),p(W.$$.fragment),xs=s(),V=l("div"),p(ye.$$.fragment),$s=s(),It=l("p"),It.innerHTML=va,bs=s(),p(Q.$$.fragment),ys=s(),z=l("div"),p(Me.$$.fragment),Ms=s(),jt=l("p"),jt.innerHTML=xa,ws=s(),p(Y.$$.fragment),Ts=s(),A=l("div"),p(we.$$.fragment),Cs=s(),Xt=l("p"),Xt.textContent=$a,Ps=s(),O=l("div"),p(Te.$$.fragment),Is=s(),Jt=l("p"),Jt.textContent=ba,js=s(),K=l("div"),p(Ce.$$.fragment),Xs=s(),kt=l("p"),kt.textContent=ya,dr=s(),p(Pe.$$.fragment),cr=s(),Ie=l("p"),Ie.innerHTML=Ma,mr=s(),P=l("div"),p(je.$$.fragment),Js=s(),Ut=l("p"),Ut.textContent=wa,ks=s(),ee=l("div"),p(Xe.$$.fragment),Us=s(),Lt=l("p"),Lt.innerHTML=Ta,Ls=s(),te=l("div"),p(Je.$$.fragment),Zs=s(),Zt=l("p"),Zt.textContent=Ca,qs=s(),re=l("div"),p(ke.$$.fragment),Vs=s(),qt=l("p"),qt.textContent=Pa,zs=s(),se=l("div"),p(Ue.$$.fragment),Es=s(),Vt=l("p"),Vt.innerHTML=Ia,Hs=s(),ae=l("div"),p(Le.$$.fragment),Ns=s(),zt=l("p"),zt.innerHTML=ja,Bs=s(),oe=l("div"),p(Ze.$$.fragment),Ss=s(),Et=l("p"),Et.textContent=Xa,pr=s(),k=l("div"),p(qe.$$.fragment),Ds=s(),Ht=l("p"),Ht.textContent=Ja,Fs=s(),ne=l("div"),p(Ve.$$.fragment),Rs=s(),Nt=l("p"),Nt.textContent=ka,fr=s(),U=l("div"),p(ze.$$.fragment),Gs=s(),Bt=l("p"),Bt.textContent=Ua,Ws=s(),le=l("div"),p(Ee.$$.fragment),Qs=s(),St=l("p"),St.textContent=La,ur=s(),p(He.$$.fragment),hr=s(),Ne=l("p"),Ne.innerHTML=Za,gr=s(),Be=l("p"),Be.textContent=qa,_r=s(),Se=l("p"),Se.textContent=Va,vr=s(),De=l("ul"),De.innerHTML=za,xr=s(),Fe=l("p"),Fe.innerHTML=Ea,$r=s(),N=l("div"),p(Re.$$.fragment),Ys=s(),Dt=l("p"),Dt.innerHTML=Ha,br=s(),p(Ge.$$.fragment),yr=s(),We=l("p"),We.innerHTML=Na,Mr=s(),Qe=l("p"),Qe.innerHTML=Ba,wr=s(),Ye=l("p"),Ye.textContent=Sa,Tr=s(),Ae=l("ul"),Ae.innerHTML=Da,Cr=s(),Oe=l("p"),Oe.textContent=Fa,Pr=s(),Ke=l("p"),Ke.innerHTML=Ra,Ir=s(),p(et.$$.fragment),jr=s(),tt=l("p"),tt.innerHTML=Ga,Xr=s(),rt=l("p"),rt.textContent=Wa,Jr=s(),p(st.$$.fragment),kr=s(),at=l("p"),at.textContent=Qa,Ur=s(),ot=l("ul"),ot.innerHTML=Ya,Lr=s(),nt=l("p"),nt.innerHTML=Aa,Zr=s(),X=l("div"),p(lt.$$.fragment),As=s(),Ft=l("p"),Ft.textContent=Oa,Os=s(),ie=l("div"),p(it.$$.fragment),Ks=s(),Rt=l("p"),Rt.textContent=Ka,ea=s(),E=l("div"),p(dt.$$.fragment),ta=s(),Gt=l("p"),Gt.innerHTML=eo,ra=s(),p(de.$$.fragment),sa=s(),ce=l("div"),p(ct.$$.fragment),aa=s(),Wt=l("p"),Wt.textContent=to,qr=s(),mt=l("p"),mt.innerHTML=ro,Vr=s(),L=l("div"),p(pt.$$.fragment),oa=s(),Qt=l("p"),Qt.textContent=so,na=s(),p(me.$$.fragment),zr=s(),ft=l("p"),ft.innerHTML=ao,Er=s(),p(ut.$$.fragment),Hr=s(),ht=l("p"),ht.textContent=oo,Nr=s(),p(gt.$$.fragment),Br=s(),_t=l("p"),_t.innerHTML=no,Sr=s(),p(vt.$$.fragment),Dr=s(),xt=l("p"),xt.innerHTML=lo,Fr=s(),p($t.$$.fragment),Rr=s(),rr=l("p"),this.h()},l(e){const r=fo("svelte-u9bgzb",document.head);c=i(r,"META",{name:!0,content:!0}),r.forEach(t),T=a(e),v=i(e,"P",{}),$(v).forEach(t),x=a(e),f(C.$$.fragment,e),m=a(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-4gs895"&&(I.textContent=da),ar=a(e),fe=i(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-1h23xz2"&&(fe.innerHTML=ca),or=a(e),f(ue.$$.fragment,e),nr=a(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-hbbv64"&&(he.textContent=ma),lr=a(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-t565jj"&&(ge.textContent=pa),ir=a(e),y=i(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),is=a(w),Mt=i(w,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1s4wckx"&&(Mt.textContent=fa),ds=a(w),F=i(w,"DIV",{class:!0});var bt=$(F);f(ve.$$.fragment,bt),cs=a(bt),wt=i(bt,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1i2d3vx"&&(wt.innerHTML=ua),bt.forEach(t),ms=a(w),Z=i(w,"DIV",{class:!0});var B=$(Z);f(xe.$$.fragment,B),ps=a(B),Tt=i(B,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1cj8dcb"&&(Tt.textContent=ha),fs=a(B),f(R.$$.fragment,B),B.forEach(t),us=a(w),G=i(w,"DIV",{class:!0});var yt=$(G);f($e.$$.fragment,yt),hs=a(yt),Ct=i(yt,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-hsvutq"&&(Ct.innerHTML=ga),yt.forEach(t),gs=a(w),q=i(w,"DIV",{class:!0});var S=$(q);f(be.$$.fragment,S),_s=a(S),Pt=i(S,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1cwsjho"&&(Pt.textContent=_a),vs=a(S),f(W.$$.fragment,S),S.forEach(t),xs=a(w),V=i(w,"DIV",{class:!0});var D=$(V);f(ye.$$.fragment,D),$s=a(D),It=i(D,"P",{"data-svelte-h":!0}),d(It)!=="svelte-hhsvto"&&(It.innerHTML=va),bs=a(D),f(Q.$$.fragment,D),D.forEach(t),ys=a(w),z=i(w,"DIV",{class:!0});var Yt=$(z);f(Me.$$.fragment,Yt),Ms=a(Yt),jt=i(Yt,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1qm3wy"&&(jt.innerHTML=xa),ws=a(Yt),f(Y.$$.fragment,Yt),Yt.forEach(t),Ts=a(w),A=i(w,"DIV",{class:!0});var Wr=$(A);f(we.$$.fragment,Wr),Cs=a(Wr),Xt=i(Wr,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1ww3wqq"&&(Xt.textContent=$a),Wr.forEach(t),Ps=a(w),O=i(w,"DIV",{class:!0});var Qr=$(O);f(Te.$$.fragment,Qr),Is=a(Qr),Jt=i(Qr,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1g70y32"&&(Jt.textContent=ba),Qr.forEach(t),js=a(w),K=i(w,"DIV",{class:!0});var Yr=$(K);f(Ce.$$.fragment,Yr),Xs=a(Yr),kt=i(Yr,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-5ayq1f"&&(kt.textContent=ya),Yr.forEach(t),w.forEach(t),dr=a(e),f(Pe.$$.fragment,e),cr=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-9vqs2o"&&(Ie.innerHTML=Ma),mr=a(e),P=i(e,"DIV",{class:!0});var j=$(P);f(je.$$.fragment,j),Js=a(j),Ut=i(j,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1bsw04k"&&(Ut.textContent=wa),ks=a(j),ee=i(j,"DIV",{class:!0});var Ar=$(ee);f(Xe.$$.fragment,Ar),Us=a(Ar),Lt=i(Ar,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-xz19bh"&&(Lt.innerHTML=Ta),Ar.forEach(t),Ls=a(j),te=i(j,"DIV",{class:!0});var Or=$(te);f(Je.$$.fragment,Or),Zs=a(Or),Zt=i(Or,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-pplryq"&&(Zt.textContent=Ca),Or.forEach(t),qs=a(j),re=i(j,"DIV",{class:!0});var Kr=$(re);f(ke.$$.fragment,Kr),Vs=a(Kr),qt=i(Kr,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-3oqyjr"&&(qt.textContent=Pa),Kr.forEach(t),zs=a(j),se=i(j,"DIV",{class:!0});var es=$(se);f(Ue.$$.fragment,es),Es=a(es),Vt=i(es,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-907m6"&&(Vt.innerHTML=Ia),es.forEach(t),Hs=a(j),ae=i(j,"DIV",{class:!0});var ts=$(ae);f(Le.$$.fragment,ts),Ns=a(ts),zt=i(ts,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-h71p1s"&&(zt.innerHTML=ja),ts.forEach(t),Bs=a(j),oe=i(j,"DIV",{class:!0});var rs=$(oe);f(Ze.$$.fragment,rs),Ss=a(rs),Et=i(rs,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-1jevh15"&&(Et.textContent=Xa),rs.forEach(t),j.forEach(t),pr=a(e),k=i(e,"DIV",{class:!0});var At=$(k);f(qe.$$.fragment,At),Ds=a(At),Ht=i(At,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-vkt0pi"&&(Ht.textContent=Ja),Fs=a(At),ne=i(At,"DIV",{class:!0});var ss=$(ne);f(Ve.$$.fragment,ss),Rs=a(ss),Nt=i(ss,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-5ayq1f"&&(Nt.textContent=ka),ss.forEach(t),At.forEach(t),fr=a(e),U=i(e,"DIV",{class:!0});var Ot=$(U);f(ze.$$.fragment,Ot),Gs=a(Ot),Bt=i(Ot,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-168wf64"&&(Bt.textContent=Ua),Ws=a(Ot),le=i(Ot,"DIV",{class:!0});var as=$(le);f(Ee.$$.fragment,as),Qs=a(as),St=i(as,"P",{"data-svelte-h":!0}),d(St)!=="svelte-5ayq1f"&&(St.textContent=La),as.forEach(t),Ot.forEach(t),ur=a(e),f(He.$$.fragment,e),hr=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-dz9ydi"&&(Ne.innerHTML=Za),gr=a(e),Be=i(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1lukeag"&&(Be.textContent=qa),_r=a(e),Se=i(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-w2nqkz"&&(Se.textContent=Va),vr=a(e),De=i(e,"UL",{"data-svelte-h":!0}),d(De)!=="svelte-my8qym"&&(De.innerHTML=za),xr=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-zymzkw"&&(Fe.innerHTML=Ea),$r=a(e),N=i(e,"DIV",{class:!0});var os=$(N);f(Re.$$.fragment,os),Ys=a(os),Dt=i(os,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-5lvrve"&&(Dt.innerHTML=Ha),os.forEach(t),br=a(e),f(Ge.$$.fragment,e),yr=a(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1cfncyx"&&(We.innerHTML=Na),Mr=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-10048a6"&&(Qe.innerHTML=Ba),wr=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1z0bn35"&&(Ye.textContent=Sa),Tr=a(e),Ae=i(e,"UL",{"data-svelte-h":!0}),d(Ae)!=="svelte-1e2xq99"&&(Ae.innerHTML=Da),Cr=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1d3nf11"&&(Oe.textContent=Fa),Pr=a(e),Ke=i(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-7zvs7i"&&(Ke.innerHTML=Ra),Ir=a(e),f(et.$$.fragment,e),jr=a(e),tt=i(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-5cjvlv"&&(tt.innerHTML=Ga),Xr=a(e),rt=i(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-10uynke"&&(rt.textContent=Wa),Jr=a(e),f(st.$$.fragment,e),kr=a(e),at=i(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-w2nqkz"&&(at.textContent=Qa),Ur=a(e),ot=i(e,"UL",{"data-svelte-h":!0}),d(ot)!=="svelte-1qiv3qf"&&(ot.innerHTML=Ya),Lr=a(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-ii491f"&&(nt.innerHTML=Aa),Zr=a(e),X=i(e,"DIV",{class:!0});var H=$(X);f(lt.$$.fragment,H),As=a(H),Ft=i(H,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-173gxyd"&&(Ft.textContent=Oa),Os=a(H),ie=i(H,"DIV",{class:!0});var ns=$(ie);f(it.$$.fragment,ns),Ks=a(ns),Rt=i(ns,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-wmaktk"&&(Rt.textContent=Ka),ns.forEach(t),ea=a(H),E=i(H,"DIV",{class:!0});var Kt=$(E);f(dt.$$.fragment,Kt),ta=a(Kt),Gt=i(Kt,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-11nqnea"&&(Gt.innerHTML=eo),ra=a(Kt),f(de.$$.fragment,Kt),Kt.forEach(t),sa=a(H),ce=i(H,"DIV",{class:!0});var ls=$(ce);f(ct.$$.fragment,ls),aa=a(ls),Wt=i(ls,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-d5zv1x"&&(Wt.textContent=to),ls.forEach(t),H.forEach(t),qr=a(e),mt=i(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-18mz77q"&&(mt.innerHTML=ro),Vr=a(e),L=i(e,"DIV",{class:!0});var er=$(L);f(pt.$$.fragment,er),oa=a(er),Qt=i(er,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-169nh0g"&&(Qt.textContent=so),na=a(er),f(me.$$.fragment,er),er.forEach(t),zr=a(e),ft=i(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1esudax"&&(ft.innerHTML=ao),Er=a(e),f(ut.$$.fragment,e),Hr=a(e),ht=i(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-3glna9"&&(ht.textContent=oo),Nr=a(e),f(gt.$$.fragment,e),Br=a(e),_t=i(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-jzuhjq"&&(_t.innerHTML=no),Sr=a(e),f(vt.$$.fragment,e),Dr=a(e),xt=i(e,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-fac3c8"&&(xt.innerHTML=lo),Fr=a(e),f($t.$$.fragment,e),Rr=a(e),rr=i(e,"P",{}),$(rr).forEach(t),this.h()},h(){b(c,"name","hf:doc:metadata"),b(c,"content",yo),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){o(document.head,c),n(e,T,r),n(e,v,r),n(e,x,r),u(C,e,r),n(e,m,r),n(e,I,r),n(e,ar,r),n(e,fe,r),n(e,or,r),u(ue,e,r),n(e,nr,r),n(e,he,r),n(e,lr,r),n(e,ge,r),n(e,ir,r),n(e,y,r),u(_e,y,null),o(y,is),o(y,Mt),o(y,ds),o(y,F),u(ve,F,null),o(F,cs),o(F,wt),o(y,ms),o(y,Z),u(xe,Z,null),o(Z,ps),o(Z,Tt),o(Z,fs),u(R,Z,null),o(y,us),o(y,G),u($e,G,null),o(G,hs),o(G,Ct),o(y,gs),o(y,q),u(be,q,null),o(q,_s),o(q,Pt),o(q,vs),u(W,q,null),o(y,xs),o(y,V),u(ye,V,null),o(V,$s),o(V,It),o(V,bs),u(Q,V,null),o(y,ys),o(y,z),u(Me,z,null),o(z,Ms),o(z,jt),o(z,ws),u(Y,z,null),o(y,Ts),o(y,A),u(we,A,null),o(A,Cs),o(A,Xt),o(y,Ps),o(y,O),u(Te,O,null),o(O,Is),o(O,Jt),o(y,js),o(y,K),u(Ce,K,null),o(K,Xs),o(K,kt),n(e,dr,r),u(Pe,e,r),n(e,cr,r),n(e,Ie,r),n(e,mr,r),n(e,P,r),u(je,P,null),o(P,Js),o(P,Ut),o(P,ks),o(P,ee),u(Xe,ee,null),o(ee,Us),o(ee,Lt),o(P,Ls),o(P,te),u(Je,te,null),o(te,Zs),o(te,Zt),o(P,qs),o(P,re),u(ke,re,null),o(re,Vs),o(re,qt),o(P,zs),o(P,se),u(Ue,se,null),o(se,Es),o(se,Vt),o(P,Hs),o(P,ae),u(Le,ae,null),o(ae,Ns),o(ae,zt),o(P,Bs),o(P,oe),u(Ze,oe,null),o(oe,Ss),o(oe,Et),n(e,pr,r),n(e,k,r),u(qe,k,null),o(k,Ds),o(k,Ht),o(k,Fs),o(k,ne),u(Ve,ne,null),o(ne,Rs),o(ne,Nt),n(e,fr,r),n(e,U,r),u(ze,U,null),o(U,Gs),o(U,Bt),o(U,Ws),o(U,le),u(Ee,le,null),o(le,Qs),o(le,St),n(e,ur,r),u(He,e,r),n(e,hr,r),n(e,Ne,r),n(e,gr,r),n(e,Be,r),n(e,_r,r),n(e,Se,r),n(e,vr,r),n(e,De,r),n(e,xr,r),n(e,Fe,r),n(e,$r,r),n(e,N,r),u(Re,N,null),o(N,Ys),o(N,Dt),n(e,br,r),u(Ge,e,r),n(e,yr,r),n(e,We,r),n(e,Mr,r),n(e,Qe,r),n(e,wr,r),n(e,Ye,r),n(e,Tr,r),n(e,Ae,r),n(e,Cr,r),n(e,Oe,r),n(e,Pr,r),n(e,Ke,r),n(e,Ir,r),u(et,e,r),n(e,jr,r),n(e,tt,r),n(e,Xr,r),n(e,rt,r),n(e,Jr,r),u(st,e,r),n(e,kr,r),n(e,at,r),n(e,Ur,r),n(e,ot,r),n(e,Lr,r),n(e,nt,r),n(e,Zr,r),n(e,X,r),u(lt,X,null),o(X,As),o(X,Ft),o(X,Os),o(X,ie),u(it,ie,null),o(ie,Ks),o(ie,Rt),o(X,ea),o(X,E),u(dt,E,null),o(E,ta),o(E,Gt),o(E,ra),u(de,E,null),o(X,sa),o(X,ce),u(ct,ce,null),o(ce,aa),o(ce,Wt),n(e,qr,r),n(e,mt,r),n(e,Vr,r),n(e,L,r),u(pt,L,null),o(L,oa),o(L,Qt),o(L,na),u(me,L,null),n(e,zr,r),n(e,ft,r),n(e,Er,r),u(ut,e,r),n(e,Hr,r),n(e,ht,r),n(e,Nr,r),u(gt,e,r),n(e,Br,r),n(e,_t,r),n(e,Sr,r),u(vt,e,r),n(e,Dr,r),n(e,xt,r),n(e,Fr,r),u($t,e,r),n(e,Rr,r),n(e,rr,r),Gr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),R.$set(w);const bt={};r&2&&(bt.$$scope={dirty:r,ctx:e}),W.$set(bt);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),Q.$set(B);const yt={};r&2&&(yt.$$scope={dirty:r,ctx:e}),Y.$set(yt);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),de.$set(S);const D={};r&2&&(D.$$scope={dirty:r,ctx:e}),me.$set(D)},i(e){Gr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(R.$$.fragment,e),h($e.$$.fragment,e),h(be.$$.fragment,e),h(W.$$.fragment,e),h(ye.$$.fragment,e),h(Q.$$.fragment,e),h(Me.$$.fragment,e),h(Y.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(je.$$.fragment,e),h(Xe.$$.fragment,e),h(Je.$$.fragment,e),h(ke.$$.fragment,e),h(Ue.$$.fragment,e),h(Le.$$.fragment,e),h(Ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Re.$$.fragment,e),h(Ge.$$.fragment,e),h(et.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(de.$$.fragment,e),h(ct.$$.fragment,e),h(pt.$$.fragment,e),h(me.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),h($t.$$.fragment,e),Gr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(R.$$.fragment,e),g($e.$$.fragment,e),g(be.$$.fragment,e),g(W.$$.fragment,e),g(ye.$$.fragment,e),g(Q.$$.fragment,e),g(Me.$$.fragment,e),g(Y.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(je.$$.fragment,e),g(Xe.$$.fragment,e),g(Je.$$.fragment,e),g(ke.$$.fragment,e),g(Ue.$$.fragment,e),g(Le.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(ze.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Re.$$.fragment,e),g(Ge.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(de.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(me.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(vt.$$.fragment,e),g($t.$$.fragment,e),Gr=!1},d(e){e&&(t(T),t(v),t(x),t(m),t(I),t(ar),t(fe),t(or),t(nr),t(he),t(lr),t(ge),t(ir),t(y),t(dr),t(cr),t(Ie),t(mr),t(P),t(pr),t(k),t(fr),t(U),t(ur),t(hr),t(Ne),t(gr),t(Be),t(_r),t(Se),t(vr),t(De),t(xr),t(Fe),t($r),t(N),t(br),t(yr),t(We),t(Mr),t(Qe),t(wr),t(Ye),t(Tr),t(Ae),t(Cr),t(Oe),t(Pr),t(Ke),t(Ir),t(jr),t(tt),t(Xr),t(rt),t(Jr),t(kr),t(at),t(Ur),t(ot),t(Lr),t(nt),t(Zr),t(X),t(qr),t(mt),t(Vr),t(L),t(zr),t(ft),t(Er),t(Hr),t(ht),t(Nr),t(Br),t(_t),t(Sr),t(Dr),t(xt),t(Fr),t(Rr),t(rr)),t(c),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_(R),_($e),_(be),_(W),_(ye),_(Q),_(Me),_(Y),_(we),_(Te),_(Ce),_(Pe,e),_(je),_(Xe),_(Je),_(ke),_(Ue),_(Le),_(Ze),_(qe),_(Ve),_(ze),_(Ee),_(He,e),_(Re),_(Ge,e),_(et,e),_(st,e),_(lt),_(it),_(dt),_(de),_(ct),_(pt),_(me),_(ut,e),_(gt,e),_(vt,e),_($t,e)}}}const yo='{"title":"Processors","local":"processors","sections":[{"title":"Multi-modal processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"Deprecated processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example usage","local":"example-usage","sections":[],"depth":3}],"depth":2}],"depth":1}';function Mo(J){return co(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jo extends mo{constructor(c){super(),po(this,c,Mo,bo,io,{})}}export{Jo as component};
