import{s as el,n as sl,o as ll}from"../chunks/scheduler.b108d059.js";import{S as tl,i as al,g as c,s as a,r as p,A as nl,h as y,f as l,c as n,j as Ks,u as M,x as T,k as Os,y as pl,a as t,v as m,d as i,t as o,w as r}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.7b00c886.js";import{H as J,E as Ml}from"../chunks/getInferenceSnippets.c4049bda.js";function ml(gs){let d,be,Ue,fe,j,Ie,u,Gs="This section includes exercises that will help you apply the concepts of chat templates and supervised fine-tuning.",Ze,U,Be,w,Cs="Chat templates help structure interactions between users and AI models, ensuring consistent and contextually appropriate responses.",ge,b,Ge,f,$s="First, let’s set up the environment.",Ce,I,$e,Z,Re,B,We,g,Rs="Let’s explore how to use a chat template with the <code>SmolLM2</code> model. We’ll define a simple conversation and apply the chat template.",ke,G,Xe,C,Fe,$,Ws="The tokenizer represents the conversation as a string with special tokens to describe the role of the user and the assistant.",ve,R,Ve,W,ks="<strong>Output:</strong>",ze,k,Se,X,Xs="Note that the conversation is represented as above but with a further assistant message.",Qe,F,Ee,v,Fs="<strong>Output:</strong>",Ne,V,He,z,vs="Of course, the tokenizer also tokenizes the conversation and special token as ids that relate to the model’s vocabulary.",_e,S,xe,Q,Vs="<strong>Output:</strong>",Ye,E,Ae,N,qe,H,zs="Take a dataset from the Hugging Face hub and process it for SFT.",De,_,Ss="<strong>Difficulty Levels</strong>",Le,x,Qs="<li>🐢 Convert the <code>HuggingFaceTB/smoltalk</code> dataset into chatml format.</li> <li>🐕 Convert the <code>openai/gsm8k</code> dataset into chatml format.</li>",Pe,Y,Ke,A,Oe,q,es,D,Es="This section demonstrates how to fine-tune the <code>HuggingFaceTB/SmolLM2-135M</code> model using the <code>SFTTrainer</code> from the <code>trl</code> library.",ss,L,ls,P,Ns="Take a dataset from the Hugging Face hub and finetune a model on it.",ts,K,Hs="<strong>Difficulty Levels</strong>",as,O,_s="<li>🐢 Use the <code>HuggingFaceTB/smoltalk</code> dataset</li> <li>🐕 Try out the <code>bigcode/the-stack-smol</code> dataset and finetune a code generation model on a specific subset <code>data/python</code>.</li> <li>🦁 Select a dataset that relates to a real world use case your interested in</li>",ns,ee,ps,se,Ms,le,xs="Here we will try out the base model which does not have a chat template.",ms,te,is,ae,os,ne,Ys="We will load a sample dataset and format it for training. The dataset should be structured with input-output pairs, where each input is a prompt and the output is the expected response from the model.",rs,pe,As="TRL will format input messages based on the model’s chat templates. They need to be represented as a list of dictionaries with the keys: <code>role</code> and <code>content</code>.",cs,Me,ys,me,qs='🦁 If your dataset is not in a format that TRL can convert to the chat template, you will need to process it. Refer to the <a href="../chat_templates.md">module</a>',Ts,ie,hs,oe,Ds="The <code>SFTTrainer</code> is configured with various parameters that control the training process. These include the number of training steps, batch size, learning rate, and evaluation strategy. Adjust these parameters based on your specific requirements and computational resources.",Js,re,ds,ce,js,ye,Ls="With the trainer configured, we can now proceed to train the model.",us,Te,Us,he,ws,Je,bs,de,Ps="🐕 Use the fine-tuned to model generate a response, just like with the base example.",fs,je,Is,ue,Zs,we,Bs;return j=new J({props:{title:"Exercises",local:"exercises",headingTag:"h1"}}),U=new J({props:{title:"Exploring Chat Templates with SmolLM2",local:"exploring-chat-templates-with-smollm2",headingTag:"h2"}}),b=new J({props:{title:"Setup",local:"setup",headingTag:"h3"}}),I=new h({props:{code:"JTIzJTIwSW5zdGFsbCUyMHRoZSUyMHJlcXVpcmVtZW50cyUyMGluJTIwR29vZ2xlJTIwQ29sYWIlMEElMjMlMjAhcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwdHJsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBJTBBJTIzJTIwQXV0aGVudGljYXRlJTIwdG8lMjBIdWdnaW5nJTIwRmFjZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBsb2dpbiUwQSUwQWxvZ2luKCklMEElMEElMjMlMjBmb3IlMjBjb252ZW5pZW5jZSUyMHlvdSUyMGNhbiUyMGNyZWF0ZSUyMGFuJTIwZW52aXJvbm1lbnQlMjB2YXJpYWJsZSUyMGNvbnRhaW5pbmclMjB5b3VyJTIwaHViJTIwdG9rZW4lMjBhcyUyMEhGX1RPS0VO",highlighted:`<span class="hljs-comment"># Install the requirements in Google Colab</span>
<span class="hljs-comment"># !pip install transformers datasets trl huggingface_hub</span>

<span class="hljs-comment"># Authenticate to Hugging Face</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()

<span class="hljs-comment"># for convenience you can create an environment variable containing your hub token as HF_TOKEN</span>`,wrap:!1}}),Z=new h({props:{code:"JTIzJTIwSW1wb3J0JTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBzZXR1cF9jaGF0X2Zvcm1hdCUwQWltcG9ydCUyMHRvcmNo",highlighted:`<span class="hljs-comment"># Import necessary libraries</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> setup_chat_format
<span class="hljs-keyword">import</span> torch`,wrap:!1}}),B=new J({props:{title:"SmolLM2 Chat Template",local:"smollm2-chat-template",headingTag:"h3"}}),G=new h({props:{code:"JTIzJTIwRHluYW1pY2FsbHklMjBzZXQlMjB0aGUlMjBkZXZpY2UlMEFkZXZpY2UlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUwQSUyMCUyMCUyMCUyMGVsc2UlMjAlMjJtcHMlMjIlMjBpZiUyMHRvcmNoLmJhY2tlbmRzLm1wcy5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEEpJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0yLTEzNU0lMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBwcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRG1vZGVsX25hbWUlMEEpLnRvKGRldmljZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChwcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRG1vZGVsX25hbWUpJTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-comment"># Dynamically set the device</span>
device = (
    <span class="hljs-string">&quot;cuda&quot;</span>
    <span class="hljs-keyword">if</span> torch.cuda.is_available()
    <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
)

model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-135M&quot;</span>
model = AutoModelForCausalLM.from_pretrained(
    pretrained_model_name_or_path=model_name
).to(device)
tokenizer = AutoTokenizer.from_pretrained(pretrained_model_name_or_path=model_name)
model, tokenizer = setup_chat_format(model=model, tokenizer=tokenizer)`,wrap:!1}}),C=new h({props:{code:"JTIzJTIwRGVmaW5lJTIwbWVzc2FnZXMlMjBmb3IlMjBTbW9sTE0yJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjB3ZWxsJTJDJTIwdGhhbmslMjB5b3UhJTIwSG93JTIwY2FuJTIwSSUyMGFzc2lzdCUyMHlvdSUyMHRvZGF5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVE",highlighted:`<span class="hljs-comment"># Define messages for SmolLM2</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing well, thank you! How can I assist you today?&quot;</span>,
    },
]`,wrap:!1}}),R=new h({props:{code:"aW5wdXRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RGYWxzZSklMEElMEFwcmludCglMjJDb252ZXJzYXRpb24lMjB3aXRoJTIwdGVtcGxhdGUlM0ElMjIlMkMlMjBpbnB1dF90ZXh0KQ==",highlighted:`input_text = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Conversation with template:&quot;</span>, input_text)`,wrap:!1}}),k=new h({props:{code:"Q29udmVyc2F0aW9uJTIwd2l0aCUyMHRlbXBsYXRlJTNBJTIwJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGVsbG8lMkMlMjBob3clMjBhcmUlMjB5b3UlM0YlM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQUknbSUyMGRvaW5nJTIwd2VsbCUyQyUyMHRoYW5rJTIweW91ISUyMEhvdyUyMGNhbiUyMEklMjBhc3Npc3QlMjB5b3UlMjB0b2RheSUzRiUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`Conversation <span class="hljs-built_in">with</span> template: &lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;user</span>
Hello, how are you?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;m doing well, thank you! How can I assist you today?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),F=new h({props:{code:"aW5wdXRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUwQSklMEElMEFwcmludCglMjJDb252ZXJzYXRpb24lMjBkZWNvZGVkJTNBJTIyJTJDJTIwdG9rZW5pemVyLmRlY29kZSh0b2tlbl9pZHMlM0RpbnB1dF90ZXh0KSk=",highlighted:`input_text = tokenizer.apply_chat_template(
    messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Conversation decoded:&quot;</span>, tokenizer.decode(token_ids=input_text))`,wrap:!1}}),V=new h({props:{code:"Q29udmVyc2F0aW9uJTIwZGVjb2RlZCUzQSUyMCUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMHdlbGwlMkMlMjB0aGFuayUyMHlvdSElMjBIb3clMjBjYW4lMjBJJTIwYXNzaXN0JTIweW91JTIwdG9kYXklM0YlM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudA==",highlighted:`Conversation decoded: &lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;user</span>
Hello, how are you?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;m doing well, thank you! How can I assist you today?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>`,wrap:!1}}),S=new h({props:{code:"aW5wdXRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMEFwcmludCglMjJDb252ZXJzYXRpb24lMjB0b2tlbml6ZWQlM0ElMjIlMkMlMjBpbnB1dF90ZXh0KQ==",highlighted:`input_text = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Conversation tokenized:&quot;</span>, input_text)`,wrap:!1}}),E=new h({props:{code:"Q29udmVyc2F0aW9uJTIwdG9rZW5pemVkJTNBJTIwJTVCMSUyQyUyMDQwOTMlMkMlMjAxOTglMkMlMjAxOTU1NiUyQyUyMDI4JTJDJTIwNjM4JTJDJTIwMzU5JTJDJTIwMzQ2JTJDJTIwNDclMkMlMjAyJTJDJTIwMTk4JTJDJTIwMSUyQyUyMDUyMCUyQyUyMDk1MzElMkMlMjAxOTglMkMlMjA1NyUyQyUyMDUyNDglMkMlMjAyNTY3JTJDJTIwODc2JTJDJTIwMjglMkMlMjA5OTg0JTJDJTIwMzQ2JTJDJTIwMTclMkMlMjAxMDczJTJDJTIwNDE2JTJDJTIwMzM5JTJDJTIwNDIzNyUyQyUyMDM0NiUyQyUyMDE4MzQlMkMlMjA0NyUyQyUyMDIlMkMlMjAxOTglMkMlMjAxJTJDJTIwNTIwJTJDJTIwOTUzMSUyQyUyMDE5OCU1RA==",highlighted:'<span class="hljs-attr">Conversation tokenized:</span> [<span class="hljs-number">1</span>, <span class="hljs-number">4093</span>, <span class="hljs-number">198</span>, <span class="hljs-number">19556</span>, <span class="hljs-number">28</span>, <span class="hljs-number">638</span>, <span class="hljs-number">359</span>, <span class="hljs-number">346</span>, <span class="hljs-number">47</span>, <span class="hljs-number">2</span>, <span class="hljs-number">198</span>, <span class="hljs-number">1</span>, <span class="hljs-number">520</span>, <span class="hljs-number">9531</span>, <span class="hljs-number">198</span>, <span class="hljs-number">57</span>, <span class="hljs-number">5248</span>, <span class="hljs-number">2567</span>, <span class="hljs-number">876</span>, <span class="hljs-number">28</span>, <span class="hljs-number">9984</span>, <span class="hljs-number">346</span>, <span class="hljs-number">17</span>, <span class="hljs-number">1073</span>, <span class="hljs-number">416</span>, <span class="hljs-number">339</span>, <span class="hljs-number">4237</span>, <span class="hljs-number">346</span>, <span class="hljs-number">1834</span>, <span class="hljs-number">47</span>, <span class="hljs-number">2</span>, <span class="hljs-number">198</span>, <span class="hljs-number">1</span>, <span class="hljs-number">520</span>, <span class="hljs-number">9531</span>, <span class="hljs-number">198</span>]',wrap:!1}}),N=new J({props:{title:"Exercise: Process a dataset for SFT",local:"exercise-process-a-dataset-for-sft",headingTag:"h3"}}),Y=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIySHVnZ2luZ0ZhY2VUQiUyRnNtb2x0YWxrJTIyJTJDJTIwJTIyZXZlcnlkYXktY29udmVyc2F0aW9ucyUyMiklMEElMEElMEFkZWYlMjBwcm9jZXNzX2RhdGFzZXQoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRPRE8lM0ElMjAlRjAlOUYlOTAlQTIlMjBDb252ZXJ0JTIwdGhlJTIwc2FtcGxlJTIwaW50byUyMGElMjBjaGF0JTIwZm9ybWF0JTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwdGhlJTIwdG9rZW5pemVyJ3MlMjBtZXRob2QlMjB0byUyMGFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBJTBBZHMlMjAlM0QlMjBkcy5tYXAocHJvY2Vzc19kYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;HuggingFaceTB/smoltalk&quot;</span>, <span class="hljs-string">&quot;everyday-conversations&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_dataset</span>(<span class="hljs-params">sample</span>):
    <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> 🐢 Convert the sample into a chat format</span>
    <span class="hljs-comment"># use the tokenizer&#x27;s method to apply the chat template</span>
    <span class="hljs-keyword">return</span> sample


ds = ds.<span class="hljs-built_in">map</span>(process_dataset)`,wrap:!1}}),A=new h({props:{code:"ZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyb3BlbmFpJTJGZ3NtOGslMjIlMkMlMjAlMjJtYWluJTIyKSUwQSUwQSUwQWRlZiUyMHByb2Nlc3NfZGF0YXNldChzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVE9ETyUzQSUyMCVGMCU5RiU5MCU5NSUyMENvbnZlcnQlMjB0aGUlMjBzYW1wbGUlMjBpbnRvJTIwYSUyMGNoYXQlMjBmb3JtYXQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAxLiUyMGNyZWF0ZSUyMGElMjBtZXNzYWdlJTIwZm9ybWF0JTIwd2l0aCUyMHRoZSUyMHJvbGUlMjBhbmQlMjBjb250ZW50JTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwMi4lMjBhcHBseSUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHRvJTIwdGhlJTIwc2FtcGxlcyUyMHVzaW5nJTIwdGhlJTIwdG9rZW5pemVyJ3MlMjBtZXRob2QlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzYW1wbGUlMEElMEElMEFkcyUyMCUzRCUyMGRzLm1hcChwcm9jZXNzX2RhdGFzZXQp",highlighted:`ds = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&quot;main&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_dataset</span>(<span class="hljs-params">sample</span>):
    <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> 🐕 Convert the sample into a chat format</span>

    <span class="hljs-comment"># 1. create a message format with the role and content</span>

    <span class="hljs-comment"># 2. apply the chat template to the samples using the tokenizer&#x27;s method</span>

    <span class="hljs-keyword">return</span> sample


ds = ds.<span class="hljs-built_in">map</span>(process_dataset)`,wrap:!1}}),q=new J({props:{title:"Supervised Fine-Tuning with SFTTrainer",local:"supervised-fine-tuning-with-sfttrainer",headingTag:"h2"}}),L=new J({props:{title:"Exercise: Fine-Tuning SmolLM2 with SFTTrainer",local:"exercise-fine-tuning-smollm2-with-sfttrainer",headingTag:"h3"}}),ee=new h({props:{code:"JTIzJTIwSW1wb3J0JTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwc2V0dXBfY2hhdF9mb3JtYXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTBBJTIwJTIwJTIwJTIwZWxzZSUyMCUyMm1wcyUyMiUyMGlmJTIwdG9yY2guYmFja2VuZHMubXBzLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQSklMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjB0b2tlbml6ZXIlMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTItMTM1TSUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMHByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEbW9kZWxfbmFtZSUwQSkudG8oZGV2aWNlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEbW9kZWxfbmFtZSklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMEFtb2RlbCUyQyUyMHRva2VuaXplciUyMCUzRCUyMHNldHVwX2NoYXRfZm9ybWF0KG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBJTIzJTIwU2V0JTIwb3VyJTIwbmFtZSUyMGZvciUyMHRoZSUyMGZpbmV0dW5lJTIwdG8lMjBiZSUyMHNhdmVkJTIwJTI2JTJGJTIwdXBsb2FkZWQlMjB0byUwQWZpbmV0dW5lX25hbWUlMjAlM0QlMjAlMjJTbW9sTE0yLUZULU15RGF0YXNldCUyMiUwQWZpbmV0dW5lX3RhZ3MlMjAlM0QlMjAlNUIlMjJzbW9sLWNvdXJzZSUyMiUyQyUyMCUyMm1vZHVsZV8xJTIyJTVE",highlighted:`<span class="hljs-comment"># Import necessary libraries</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, setup_chat_format
<span class="hljs-keyword">import</span> torch

device = (
    <span class="hljs-string">&quot;cuda&quot;</span>
    <span class="hljs-keyword">if</span> torch.cuda.is_available()
    <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
)

<span class="hljs-comment"># Load the model and tokenizer</span>
model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-135M&quot;</span>
model = AutoModelForCausalLM.from_pretrained(
    pretrained_model_name_or_path=model_name
).to(device)
tokenizer = AutoTokenizer.from_pretrained(pretrained_model_name_or_path=model_name)

<span class="hljs-comment"># Set up the chat format</span>
model, tokenizer = setup_chat_format(model=model, tokenizer=tokenizer)

<span class="hljs-comment"># Set our name for the finetune to be saved &amp;/ uploaded to</span>
finetune_name = <span class="hljs-string">&quot;SmolLM2-FT-MyDataset&quot;</span>
finetune_tags = [<span class="hljs-string">&quot;smol-course&quot;</span>, <span class="hljs-string">&quot;module_1&quot;</span>]`,wrap:!1}}),se=new J({props:{title:"Generate with the base model",local:"generate-with-the-base-model",headingTag:"h3"}}),te=new h({props:{code:"JTIzJTIwTGV0J3MlMjB0ZXN0JTIwdGhlJTIwYmFzZSUyMG1vZGVsJTIwYmVmb3JlJTIwdHJhaW5pbmclMEFwcm9tcHQlMjAlM0QlMjAlMjJXcml0ZSUyMGElMjBoYWlrdSUyMGFib3V0JTIwcHJvZ3JhbW1pbmclMjIlMEElMEElMjMlMjBGb3JtYXQlMjB3aXRoJTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHByb21wdCU3RCU1RCUwQWZvcm1hdHRlZF9wcm9tcHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMjByZXNwb25zZSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihmb3JtYXR0ZWRfcHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwKSUwQXByaW50KCUyMkJlZm9yZSUyMHRyYWluaW5nJTNBJTIyKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-comment"># Let&#x27;s test the base model before training</span>
prompt = <span class="hljs-string">&quot;Write a haiku about programming&quot;</span>

<span class="hljs-comment"># Format with template</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
formatted_prompt = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Generate response</span>
inputs = tokenizer(formatted_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Before training:&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ae=new J({props:{title:"Dataset Preparation",local:"dataset-preparation",headingTag:"h3"}}),Me=new h({props:{code:"JTIzJTIwTG9hZCUyMGElMjBzYW1wbGUlMjBkYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwVE9ETyUzQSUyMGRlZmluZSUyMHlvdXIlMjBkYXRhc2V0JTIwYW5kJTIwY29uZmlnJTIwdXNpbmclMjB0aGUlMjBwYXRoJTIwYW5kJTIwbmFtZSUyMHBhcmFtZXRlcnMlMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldChwYXRoJTNEJTIySHVnZ2luZ0ZhY2VUQiUyRnNtb2x0YWxrJTIyJTJDJTIwbmFtZSUzRCUyMmV2ZXJ5ZGF5LWNvbnZlcnNhdGlvbnMlMjIp",highlighted:`<span class="hljs-comment"># Load a sample dataset</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> define your dataset and config using the path and name parameters</span>
ds = load_dataset(path=<span class="hljs-string">&quot;HuggingFaceTB/smoltalk&quot;</span>, name=<span class="hljs-string">&quot;everyday-conversations&quot;</span>)`,wrap:!1}}),ie=new J({props:{title:"Configuring the SFTTrainer",local:"configuring-the-sfttrainer",headingTag:"h3"}}),re=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># Configure the SFTTrainer</span>
sft_config = SFTConfig(
    output_dir=<span class="hljs-string">&quot;./sft_output&quot;</span>,
    max_steps=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># Adjust based on dataset size and desired training duration</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Set according to your GPU memory capacity</span>
    learning_rate=<span class="hljs-number">5e-5</span>,  <span class="hljs-comment"># Common starting point for fine-tuning</span>
    logging_steps=<span class="hljs-number">10</span>,  <span class="hljs-comment"># Frequency of logging training metrics</span>
    save_steps=<span class="hljs-number">100</span>,  <span class="hljs-comment"># Frequency of saving model checkpoints</span>
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,  <span class="hljs-comment"># Evaluate the model at regular intervals</span>
    eval_steps=<span class="hljs-number">50</span>,  <span class="hljs-comment"># Frequency of evaluation</span>
    use_mps_device=(
        <span class="hljs-literal">True</span> <span class="hljs-keyword">if</span> device == <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">False</span>
    ),  <span class="hljs-comment"># Use MPS for mixed precision training</span>
    hub_model_id=finetune_name,  <span class="hljs-comment"># Set a unique name for your model</span>
)

<span class="hljs-comment"># Initialize the SFTTrainer</span>
trainer = SFTTrainer(
    model=model,
    args=sft_config,
    train_dataset=ds[<span class="hljs-string">&quot;train&quot;</span>],
    tokenizer=tokenizer,
    eval_dataset=ds[<span class="hljs-string">&quot;test&quot;</span>],
)

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> 🦁 🐕 align the SFTTrainer params with your chosen dataset. For example, if you are using the \`bigcode/the-stack-smol\` dataset, you will need to choose the \`content\` column</span>`,wrap:!1}}),ce=new J({props:{title:"Training the Model",local:"training-the-model",headingTag:"h3"}}),Te=new h({props:{code:"JTIzJTIwVHJhaW4lMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIudHJhaW4oKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBtb2RlbCUwQXRyYWluZXIuc2F2ZV9tb2RlbChmJTIyLiUyRiU3QmZpbmV0dW5lX25hbWUlN0QlMjIp",highlighted:`<span class="hljs-comment"># Train the model</span>
trainer.train()

<span class="hljs-comment"># Save the model</span>
trainer.save_model(<span class="hljs-string">f&quot;./<span class="hljs-subst">{finetune_name}</span>&quot;</span>)`,wrap:!1}}),he=new h({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yih0YWdzJTNEZmluZXR1bmVfdGFncyk=",highlighted:"trainer.push_to_hub(tags=finetune_tags)",wrap:!1}}),Je=new J({props:{title:"Bonus Exercise: Generate with fine-tuned model",local:"bonus-exercise-generate-with-fine-tuned-model",headingTag:"h3"}}),je=new h({props:{code:"JTIzJTIwVGVzdCUyMHRoZSUyMGZpbmUtdHVuZWQlMjBtb2RlbCUyMG9uJTIwdGhlJTIwc2FtZSUyMHByb21wdCUwQSUwQSUyMyUyMExldCdzJTIwdGVzdCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyMGJlZm9yZSUyMHRyYWluaW5nJTBBcHJvbXB0JTIwJTNEJTIwJTIyV3JpdGUlMjBhJTIwaGFpa3UlMjBhYm91dCUyMHByb2dyYW1taW5nJTIyJTBBJTBBJTIzJTIwRm9ybWF0JTIwd2l0aCUyMHRlbXBsYXRlJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBwcm9tcHQlN0QlNUQlMEFmb3JtYXR0ZWRfcHJvbXB0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwcmVzcG9uc2UlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZm9ybWF0dGVkX3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEElMEElMjMlMjBUT0RPJTNBJTIwdXNlJTIwdGhlJTIwZmluZS10dW5lZCUyMHRvJTIwbW9kZWwlMjBnZW5lcmF0ZSUyMGElMjByZXNwb25zZSUyQyUyMGp1c3QlMjBsaWtlJTIwd2l0aCUyMHRoZSUyMGJhc2UlMjBleGFtcGxlLg==",highlighted:`<span class="hljs-comment"># Test the fine-tuned model on the same prompt</span>

<span class="hljs-comment"># Let&#x27;s test the base model before training</span>
prompt = <span class="hljs-string">&quot;Write a haiku about programming&quot;</span>

<span class="hljs-comment"># Format with template</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
formatted_prompt = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Generate response</span>
inputs = tokenizer(formatted_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> use the fine-tuned to model generate a response, just like with the base example.</span>`,wrap:!1}}),ue=new Ml({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/exercises.md"}}),{c(){d=c("meta"),be=a(),Ue=c("p"),fe=a(),p(j.$$.fragment),Ie=a(),u=c("p"),u.textContent=Gs,Ze=a(),p(U.$$.fragment),Be=a(),w=c("p"),w.textContent=Cs,ge=a(),p(b.$$.fragment),Ge=a(),f=c("p"),f.textContent=$s,Ce=a(),p(I.$$.fragment),$e=a(),p(Z.$$.fragment),Re=a(),p(B.$$.fragment),We=a(),g=c("p"),g.innerHTML=Rs,ke=a(),p(G.$$.fragment),Xe=a(),p(C.$$.fragment),Fe=a(),$=c("p"),$.textContent=Ws,ve=a(),p(R.$$.fragment),Ve=a(),W=c("p"),W.innerHTML=ks,ze=a(),p(k.$$.fragment),Se=a(),X=c("p"),X.textContent=Xs,Qe=a(),p(F.$$.fragment),Ee=a(),v=c("p"),v.innerHTML=Fs,Ne=a(),p(V.$$.fragment),He=a(),z=c("p"),z.textContent=vs,_e=a(),p(S.$$.fragment),xe=a(),Q=c("p"),Q.innerHTML=Vs,Ye=a(),p(E.$$.fragment),Ae=a(),p(N.$$.fragment),qe=a(),H=c("p"),H.textContent=zs,De=a(),_=c("p"),_.innerHTML=Ss,Le=a(),x=c("ul"),x.innerHTML=Qs,Pe=a(),p(Y.$$.fragment),Ke=a(),p(A.$$.fragment),Oe=a(),p(q.$$.fragment),es=a(),D=c("p"),D.innerHTML=Es,ss=a(),p(L.$$.fragment),ls=a(),P=c("p"),P.textContent=Ns,ts=a(),K=c("p"),K.innerHTML=Hs,as=a(),O=c("ul"),O.innerHTML=_s,ns=a(),p(ee.$$.fragment),ps=a(),p(se.$$.fragment),Ms=a(),le=c("p"),le.textContent=xs,ms=a(),p(te.$$.fragment),is=a(),p(ae.$$.fragment),os=a(),ne=c("p"),ne.textContent=Ys,rs=a(),pe=c("p"),pe.innerHTML=As,cs=a(),p(Me.$$.fragment),ys=a(),me=c("p"),me.innerHTML=qs,Ts=a(),p(ie.$$.fragment),hs=a(),oe=c("p"),oe.innerHTML=Ds,Js=a(),p(re.$$.fragment),ds=a(),p(ce.$$.fragment),js=a(),ye=c("p"),ye.textContent=Ls,us=a(),p(Te.$$.fragment),Us=a(),p(he.$$.fragment),ws=a(),p(Je.$$.fragment),bs=a(),de=c("p"),de.textContent=Ps,fs=a(),p(je.$$.fragment),Is=a(),p(ue.$$.fragment),Zs=a(),we=c("p"),this.h()},l(e){const s=nl("svelte-u9bgzb",document.head);d=y(s,"META",{name:!0,content:!0}),s.forEach(l),be=n(e),Ue=y(e,"P",{}),Ks(Ue).forEach(l),fe=n(e),M(j.$$.fragment,e),Ie=n(e),u=y(e,"P",{"data-svelte-h":!0}),T(u)!=="svelte-z3z6h5"&&(u.textContent=Gs),Ze=n(e),M(U.$$.fragment,e),Be=n(e),w=y(e,"P",{"data-svelte-h":!0}),T(w)!=="svelte-e7npfc"&&(w.textContent=Cs),ge=n(e),M(b.$$.fragment,e),Ge=n(e),f=y(e,"P",{"data-svelte-h":!0}),T(f)!=="svelte-1kj6cb4"&&(f.textContent=$s),Ce=n(e),M(I.$$.fragment,e),$e=n(e),M(Z.$$.fragment,e),Re=n(e),M(B.$$.fragment,e),We=n(e),g=y(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1yduqkq"&&(g.innerHTML=Rs),ke=n(e),M(G.$$.fragment,e),Xe=n(e),M(C.$$.fragment,e),Fe=n(e),$=y(e,"P",{"data-svelte-h":!0}),T($)!=="svelte-1diq6o6"&&($.textContent=Ws),ve=n(e),M(R.$$.fragment,e),Ve=n(e),W=y(e,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1mvdyro"&&(W.innerHTML=ks),ze=n(e),M(k.$$.fragment,e),Se=n(e),X=y(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-ewpong"&&(X.textContent=Xs),Qe=n(e),M(F.$$.fragment,e),Ee=n(e),v=y(e,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1mvdyro"&&(v.innerHTML=Fs),Ne=n(e),M(V.$$.fragment,e),He=n(e),z=y(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-25kjcl"&&(z.textContent=vs),_e=n(e),M(S.$$.fragment,e),xe=n(e),Q=y(e,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-1mvdyro"&&(Q.innerHTML=Vs),Ye=n(e),M(E.$$.fragment,e),Ae=n(e),M(N.$$.fragment,e),qe=n(e),H=y(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-1vudotd"&&(H.textContent=zs),De=n(e),_=y(e,"P",{"data-svelte-h":!0}),T(_)!=="svelte-dxd7vd"&&(_.innerHTML=Ss),Le=n(e),x=y(e,"UL",{"data-svelte-h":!0}),T(x)!=="svelte-1390s6y"&&(x.innerHTML=Qs),Pe=n(e),M(Y.$$.fragment,e),Ke=n(e),M(A.$$.fragment,e),Oe=n(e),M(q.$$.fragment,e),es=n(e),D=y(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1l2ckli"&&(D.innerHTML=Es),ss=n(e),M(L.$$.fragment,e),ls=n(e),P=y(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1d2wq5l"&&(P.textContent=Ns),ts=n(e),K=y(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-dxd7vd"&&(K.innerHTML=Hs),as=n(e),O=y(e,"UL",{"data-svelte-h":!0}),T(O)!=="svelte-vutl8b"&&(O.innerHTML=_s),ns=n(e),M(ee.$$.fragment,e),ps=n(e),M(se.$$.fragment,e),Ms=n(e),le=y(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-9sa5e6"&&(le.textContent=xs),ms=n(e),M(te.$$.fragment,e),is=n(e),M(ae.$$.fragment,e),os=n(e),ne=y(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-1ndxv2w"&&(ne.textContent=Ys),rs=n(e),pe=y(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-oaaj34"&&(pe.innerHTML=As),cs=n(e),M(Me.$$.fragment,e),ys=n(e),me=y(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-1eaag4q"&&(me.innerHTML=qs),Ts=n(e),M(ie.$$.fragment,e),hs=n(e),oe=y(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-y4qzty"&&(oe.innerHTML=Ds),Js=n(e),M(re.$$.fragment,e),ds=n(e),M(ce.$$.fragment,e),js=n(e),ye=y(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-xp045b"&&(ye.textContent=Ls),us=n(e),M(Te.$$.fragment,e),Us=n(e),M(he.$$.fragment,e),ws=n(e),M(Je.$$.fragment,e),bs=n(e),de=y(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-thi7sh"&&(de.textContent=Ps),fs=n(e),M(je.$$.fragment,e),Is=n(e),M(ue.$$.fragment,e),Zs=n(e),we=y(e,"P",{}),Ks(we).forEach(l),this.h()},h(){Os(d,"name","hf:doc:metadata"),Os(d,"content",il)},m(e,s){pl(document.head,d),t(e,be,s),t(e,Ue,s),t(e,fe,s),m(j,e,s),t(e,Ie,s),t(e,u,s),t(e,Ze,s),m(U,e,s),t(e,Be,s),t(e,w,s),t(e,ge,s),m(b,e,s),t(e,Ge,s),t(e,f,s),t(e,Ce,s),m(I,e,s),t(e,$e,s),m(Z,e,s),t(e,Re,s),m(B,e,s),t(e,We,s),t(e,g,s),t(e,ke,s),m(G,e,s),t(e,Xe,s),m(C,e,s),t(e,Fe,s),t(e,$,s),t(e,ve,s),m(R,e,s),t(e,Ve,s),t(e,W,s),t(e,ze,s),m(k,e,s),t(e,Se,s),t(e,X,s),t(e,Qe,s),m(F,e,s),t(e,Ee,s),t(e,v,s),t(e,Ne,s),m(V,e,s),t(e,He,s),t(e,z,s),t(e,_e,s),m(S,e,s),t(e,xe,s),t(e,Q,s),t(e,Ye,s),m(E,e,s),t(e,Ae,s),m(N,e,s),t(e,qe,s),t(e,H,s),t(e,De,s),t(e,_,s),t(e,Le,s),t(e,x,s),t(e,Pe,s),m(Y,e,s),t(e,Ke,s),m(A,e,s),t(e,Oe,s),m(q,e,s),t(e,es,s),t(e,D,s),t(e,ss,s),m(L,e,s),t(e,ls,s),t(e,P,s),t(e,ts,s),t(e,K,s),t(e,as,s),t(e,O,s),t(e,ns,s),m(ee,e,s),t(e,ps,s),m(se,e,s),t(e,Ms,s),t(e,le,s),t(e,ms,s),m(te,e,s),t(e,is,s),m(ae,e,s),t(e,os,s),t(e,ne,s),t(e,rs,s),t(e,pe,s),t(e,cs,s),m(Me,e,s),t(e,ys,s),t(e,me,s),t(e,Ts,s),m(ie,e,s),t(e,hs,s),t(e,oe,s),t(e,Js,s),m(re,e,s),t(e,ds,s),m(ce,e,s),t(e,js,s),t(e,ye,s),t(e,us,s),m(Te,e,s),t(e,Us,s),m(he,e,s),t(e,ws,s),m(Je,e,s),t(e,bs,s),t(e,de,s),t(e,fs,s),m(je,e,s),t(e,Is,s),m(ue,e,s),t(e,Zs,s),t(e,we,s),Bs=!0},p:sl,i(e){Bs||(i(j.$$.fragment,e),i(U.$$.fragment,e),i(b.$$.fragment,e),i(I.$$.fragment,e),i(Z.$$.fragment,e),i(B.$$.fragment,e),i(G.$$.fragment,e),i(C.$$.fragment,e),i(R.$$.fragment,e),i(k.$$.fragment,e),i(F.$$.fragment,e),i(V.$$.fragment,e),i(S.$$.fragment,e),i(E.$$.fragment,e),i(N.$$.fragment,e),i(Y.$$.fragment,e),i(A.$$.fragment,e),i(q.$$.fragment,e),i(L.$$.fragment,e),i(ee.$$.fragment,e),i(se.$$.fragment,e),i(te.$$.fragment,e),i(ae.$$.fragment,e),i(Me.$$.fragment,e),i(ie.$$.fragment,e),i(re.$$.fragment,e),i(ce.$$.fragment,e),i(Te.$$.fragment,e),i(he.$$.fragment,e),i(Je.$$.fragment,e),i(je.$$.fragment,e),i(ue.$$.fragment,e),Bs=!0)},o(e){o(j.$$.fragment,e),o(U.$$.fragment,e),o(b.$$.fragment,e),o(I.$$.fragment,e),o(Z.$$.fragment,e),o(B.$$.fragment,e),o(G.$$.fragment,e),o(C.$$.fragment,e),o(R.$$.fragment,e),o(k.$$.fragment,e),o(F.$$.fragment,e),o(V.$$.fragment,e),o(S.$$.fragment,e),o(E.$$.fragment,e),o(N.$$.fragment,e),o(Y.$$.fragment,e),o(A.$$.fragment,e),o(q.$$.fragment,e),o(L.$$.fragment,e),o(ee.$$.fragment,e),o(se.$$.fragment,e),o(te.$$.fragment,e),o(ae.$$.fragment,e),o(Me.$$.fragment,e),o(ie.$$.fragment,e),o(re.$$.fragment,e),o(ce.$$.fragment,e),o(Te.$$.fragment,e),o(he.$$.fragment,e),o(Je.$$.fragment,e),o(je.$$.fragment,e),o(ue.$$.fragment,e),Bs=!1},d(e){e&&(l(be),l(Ue),l(fe),l(Ie),l(u),l(Ze),l(Be),l(w),l(ge),l(Ge),l(f),l(Ce),l($e),l(Re),l(We),l(g),l(ke),l(Xe),l(Fe),l($),l(ve),l(Ve),l(W),l(ze),l(Se),l(X),l(Qe),l(Ee),l(v),l(Ne),l(He),l(z),l(_e),l(xe),l(Q),l(Ye),l(Ae),l(qe),l(H),l(De),l(_),l(Le),l(x),l(Pe),l(Ke),l(Oe),l(es),l(D),l(ss),l(ls),l(P),l(ts),l(K),l(as),l(O),l(ns),l(ps),l(Ms),l(le),l(ms),l(is),l(os),l(ne),l(rs),l(pe),l(cs),l(ys),l(me),l(Ts),l(hs),l(oe),l(Js),l(ds),l(js),l(ye),l(us),l(Us),l(ws),l(bs),l(de),l(fs),l(Is),l(Zs),l(we)),l(d),r(j,e),r(U,e),r(b,e),r(I,e),r(Z,e),r(B,e),r(G,e),r(C,e),r(R,e),r(k,e),r(F,e),r(V,e),r(S,e),r(E,e),r(N,e),r(Y,e),r(A,e),r(q,e),r(L,e),r(ee,e),r(se,e),r(te,e),r(ae,e),r(Me,e),r(ie,e),r(re,e),r(ce,e),r(Te,e),r(he,e),r(Je,e),r(je,e),r(ue,e)}}}const il='{"title":"Exercises","local":"exercises","sections":[{"title":"Exploring Chat Templates with SmolLM2","local":"exploring-chat-templates-with-smollm2","sections":[{"title":"Setup","local":"setup","sections":[],"depth":3},{"title":"SmolLM2 Chat Template","local":"smollm2-chat-template","sections":[],"depth":3},{"title":"Exercise: Process a dataset for SFT","local":"exercise-process-a-dataset-for-sft","sections":[],"depth":3}],"depth":2},{"title":"Supervised Fine-Tuning with SFTTrainer","local":"supervised-fine-tuning-with-sfttrainer","sections":[{"title":"Exercise: Fine-Tuning SmolLM2 with SFTTrainer","local":"exercise-fine-tuning-smollm2-with-sfttrainer","sections":[],"depth":3},{"title":"Generate with the base model","local":"generate-with-the-base-model","sections":[],"depth":3},{"title":"Dataset Preparation","local":"dataset-preparation","sections":[],"depth":3},{"title":"Configuring the SFTTrainer","local":"configuring-the-sfttrainer","sections":[],"depth":3},{"title":"Training the Model","local":"training-the-model","sections":[],"depth":3},{"title":"Bonus Exercise: Generate with fine-tuned model","local":"bonus-exercise-generate-with-fine-tuned-model","sections":[],"depth":3}],"depth":2}],"depth":1}';function ol(gs){return ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends tl{constructor(d){super(),al(this,d,ol,ml,el,{})}}export{hl as component};
