import{s as Oe,n as Ke,o as et}from"../chunks/scheduler.362310b7.js";import{S as tt,i as st,g as i,s as l,r as p,A as nt,h as r,f as s,c as a,j as Ae,u as c,x as o,k as P,y as lt,a as n,v as m,d as h,t as d,w as u}from"../chunks/index.57dfc70d.js";import{C as A}from"../chunks/CodeBlock.d3c47f83.js";import{H as F,E as at}from"../chunks/EditOnGithub.9633c464.js";function it(Ze){let y,O,q,K,J,ee,f,te,g,Ge="Token streaming is the mode in which the server returns the tokens one by one as the model generates them. This enables showing progressive generations to the user rather than waiting for the whole generation. Streaming is an essential aspect of the end-user experience as it reduces latency, one of the most critical aspects of a smooth experience.",se,M,Ce='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual_360.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual-dark_360.gif"/>',ne,U,Se="With token streaming, the server can start returning the tokens one by one before having to generate the whole response. Users can have a sense of the generation’s quality before the end of the generation. This has different positive effects:",le,j,Ve="<li>Users can get results orders of magnitude earlier for extremely long queries.</li> <li>Seeing something in progress allows users to stop the generation if it’s not going in the direction they expect.</li> <li>Perceived latency is lower when results are shown in the early stages.</li> <li>When used in conversational UIs, the experience feels more natural.</li>",ae,b,Ee="For example, a system can generate 100 tokens per second. If the system generates 1000 tokens, with the non-streaming setup, users need to wait 10 seconds to get results. On the other hand, with the streaming setup, users get initial results immediately, and although end-to-end latency will be the same, they can see half of the generation after five seconds. Below you can see an interactive demo that shows non-streaming vs streaming side-by-side. Click <strong>generate</strong> below.",ie,T,He='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=light" width="850" height="350"></iframe>',re,w,We='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=dark" width="850" height="350"></iframe>',oe,v,pe,k,ce,I,Ne="To stream tokens with <code>InferenceClient</code>, simply pass <code>stream=True</code> and iterate over the response.",me,x,he,$,_e="If you want additional details, you can add <code>details=True</code>. In this case, you get a <code>TextGenerationStreamResponse</code> which contains additional information such as the probabilities and the tokens. For the final response in the stream, it also returns the full generated text.",de,B,ue,R,ze="The <code>huggingface_hub</code> library also comes with an <code>AsyncInferenceClient</code> in case you need to handle the requests concurrently.",ye,Z,Me,G,Te,C,Qe="To use the <code>generate_stream</code> endpoint with curl, you can add the <code>-N</code> flag, which disables curl default buffering and shows data as it arrives from the server",we,S,Je,V,fe,E,Ye=`First, we need to install the <code>@huggingface/inference</code> library.
<code>npm install @huggingface/inference</code>`,ge,H,Xe="If you’re using the free Inference API, you can use <code>HfInference</code>. If you’re using inference endpoints, you can use <code>HfInferenceEndpoint</code>.",Ue,W,Le="We can create a <code>HfInferenceEndpoint</code> providing our endpoint URL and credential.",je,N,be,_,ve,z,Fe="Under the hood, TGI uses Server-Sent Events (SSE). In an SSE Setup, a client sends a request with the data, opening an HTTP connection and subscribing to updates. Afterward, the server sends data to the client. There is no need for further requests; the server will keep sending the data. SSEs are unidirectional, meaning the client does not send other requests to the server. SSE sends data over HTTP, making it easy to use.",ke,Q,qe="SSEs are different than:",Ie,Y,De="<li>Polling: where the client keeps calling the server to get data. This means that the server might return empty responses and cause overhead.</li> <li>Webhooks: where there is a bi-directional connection. The server can send information to the client, but the client can also send data to the server after the first request. Webhooks are more complex to operate as they don’t only use HTTP.</li>",xe,X,Pe="If there are too many requests at the same time, TGI returns an HTTP Error with an <code>overloaded</code> error type (<code>huggingface_hub</code> returns <code>OverloadedError</code>). This allows the client to manage the overloaded server (e.g., it could display a busy error to the user or retry with a new request). To configure the maximum number of concurrent requests, you can specify <code>--max_concurrent_requests</code>, allowing clients to handle backpressure.",$e,L,Be,D,Re;return J=new F({props:{title:"Streaming",local:"streaming",headingTag:"h1"}}),f=new F({props:{title:"What is Streaming?",local:"what-is-streaming",headingTag:"h2"}}),v=new F({props:{title:"How to use Streaming?",local:"how-to-use-streaming",headingTag:"h2"}}),k=new F({props:{title:"Streaming with Python",local:"streaming-with-python",headingTag:"h3"}}),x=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODA4MCUyMiklMEFmb3IlMjB0b2tlbiUyMGluJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJIb3clMjBkbyUyMHlvdSUyMG1ha2UlMjBjaGVlc2UlM0YlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiklMEElMEElMjMlMjBUbyUwQSUyMyUyMG1ha2UlMEElMjMlMjBjaGVlc2UlMEElMjMlMkMlMEElMjMlMjB5b3UlMEElMjMlMjBuZWVkJTBBJTIzJTIwdG8lMEElMjMlMjBzdGFydCUwQSUyMyUyMHdpdGglMEElMjMlMjBtaWxrJTBBJTIzLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;How do you make cheese?&quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># To</span>
<span class="hljs-comment"># make</span>
<span class="hljs-comment"># cheese</span>
<span class="hljs-comment">#,</span>
<span class="hljs-comment"># you</span>
<span class="hljs-comment"># need</span>
<span class="hljs-comment"># to</span>
<span class="hljs-comment"># start</span>
<span class="hljs-comment"># with</span>
<span class="hljs-comment"># milk</span>
<span class="hljs-comment">#.</span>`,wrap:!1}}),B=new A({props:{code:"Zm9yJTIwZGV0YWlscyUyMGluJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJIb3clMjBkbyUyMHlvdSUyMG1ha2UlMjBjaGVlc2UlM0YlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyJTJDJTIwZGV0YWlscyUzRFRydWUlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbHMpJTBBJTBBJTIzVGV4dEdlbmVyYXRpb25TdHJlYW1SZXNwb25zZSh0b2tlbiUzRFRva2VuKGlkJTNEMTkzJTJDJTIwdGV4dCUzRCclNUNuJyUyQyUyMGxvZ3Byb2IlM0QtMC4wMDczNTg1NTElMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwZ2VuZXJhdGVkX3RleHQlM0ROb25lJTJDJTIwZGV0YWlscyUzRE5vbmUpJTBBJTIzVGV4dEdlbmVyYXRpb25TdHJlYW1SZXNwb25zZSh0b2tlbiUzRFRva2VuKGlkJTNEMjA0NCUyQyUyMHRleHQlM0QnVG8nJTJDJTIwbG9ncHJvYiUzRC0xLjEzNTc0MjIlMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwZ2VuZXJhdGVkX3RleHQlM0ROb25lJTJDJTIwZGV0YWlscyUzRE5vbmUpJTBBJTIzVGV4dEdlbmVyYXRpb25TdHJlYW1SZXNwb25zZSh0b2tlbiUzRFRva2VuKGlkJTNENzE3JTJDJTIwdGV4dCUzRCclMjBtYWtlJyUyQyUyMGxvZ3Byb2IlM0QtMC4wMDk4NDE5MTklMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwZ2VuZXJhdGVkX3RleHQlM0ROb25lJTJDJTIwZGV0YWlscyUzRE5vbmUpJTBBJTIzLi4uJTBBJTIzVGV4dEdlbmVyYXRpb25TdHJlYW1SZXNwb25zZSh0b2tlbiUzRFRva2VuKGlkJTNEMjUlMkMlMjB0ZXh0JTNEJy4nJTJDJTIwbG9ncHJvYiUzRC0xLjM0MDgyMDMlMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwZ2VuZXJhdGVkX3RleHQlM0QnJTVDblRvJTIwbWFrZSUyMGNoZWVzZSUyQyUyMHlvdSUyMG5lZWQlMjB0byUyMHN0YXJ0JTIwd2l0aCUyMG1pbGsuJyUyQyUyMGRldGFpbHMlM0RTdHJlYW1EZXRhaWxzKGZpbmlzaF9yZWFzb24lM0QlM0NGaW5pc2hSZWFzb24uTGVuZ3RoJTNBJTIwJ2xlbmd0aCclM0UlMkMlMjBnZW5lcmF0ZWRfdG9rZW5zJTNEMTIlMkMlMjBzZWVkJTNETm9uZSkp",highlighted:`<span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;How do you make cheese?&quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(details)

<span class="hljs-comment">#TextGenerationStreamResponse(token=Token(id=193, text=&#x27;\\n&#x27;, logprob=-0.007358551, special=False), generated_text=None, details=None)</span>
<span class="hljs-comment">#TextGenerationStreamResponse(token=Token(id=2044, text=&#x27;To&#x27;, logprob=-1.1357422, special=False), generated_text=None, details=None)</span>
<span class="hljs-comment">#TextGenerationStreamResponse(token=Token(id=717, text=&#x27; make&#x27;, logprob=-0.009841919, special=False), generated_text=None, details=None)</span>
<span class="hljs-comment">#...</span>
<span class="hljs-comment">#TextGenerationStreamResponse(token=Token(id=25, text=&#x27;.&#x27;, logprob=-1.3408203, special=False), generated_text=&#x27;\\nTo make cheese, you need to start with milk.&#x27;, details=StreamDetails(finish_reason=&lt;FinishReason.Length: &#x27;length&#x27;&gt;, generated_tokens=12, seed=None))</span>`,wrap:!1}}),Z=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTgwODAlMjIpJTBBYXN5bmMlMjBmb3IlMjB0b2tlbiUyMGluJTIwYXdhaXQlMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkhvdyUyMGRvJTIweW91JTIwbWFrZSUyMGNoZWVzZSUzRiUyMiUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4pJTBBJTBBJTIzJTIwVG8lMEElMjMlMjBtYWtlJTBBJTIzJTIwY2hlZXNlJTBBJTIzJTJDJTBBJTIzJTIweW91JTBBJTIzJTIwbmVlZCUwQSUyMyUyMHRvJTBBJTIzJTIwc3RhcnQlMEElMjMlMjB3aXRoJTBBJTIzJTIwbWlsayUwQSUyMy4=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

client = AsyncInferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
<span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;How do you make cheese?&quot;</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># To</span>
<span class="hljs-comment"># make</span>
<span class="hljs-comment"># cheese</span>
<span class="hljs-comment">#,</span>
<span class="hljs-comment"># you</span>
<span class="hljs-comment"># need</span>
<span class="hljs-comment"># to</span>
<span class="hljs-comment"># start</span>
<span class="hljs-comment"># with</span>
<span class="hljs-comment"># milk</span>
<span class="hljs-comment">#.</span>`,wrap:!1}}),G=new F({props:{title:"Streaming with cURL",local:"streaming-with-curl",headingTag:"h3"}}),S=new A({props:{code:"Y3VybCUyMC1OJTIwMTI3LjAuMC4xJTNBODA4MCUyRmdlbmVyYXRlX3N0cmVhbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMmlucHV0cyUyMiUzQSUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiUyQyUyMnBhcmFtZXRlcnMlMjIlM0ElN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQTIwJTdEJTdEJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJ0NvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbic=",highlighted:`curl -N <span class="hljs-number">127.0</span>.<span class="hljs-number">0.1</span>:<span class="hljs-number">8080</span>/generate_stream \\
    -X POST \\
    -d &#x27;{<span class="hljs-string">&quot;inputs&quot;</span>:<span class="hljs-string">&quot;What is Deep Learning?&quot;</span>,<span class="hljs-string">&quot;parameters&quot;</span>:{<span class="hljs-string">&quot;max_new_tokens&quot;</span>:<span class="hljs-number">20</span>}}&#x27; \\
    -H <span class="hljs-symbol">&#x27;Content</span>-<span class="hljs-keyword">Type</span>: application/json&#x27;`,wrap:!1}}),V=new F({props:{title:"Streaming with JavaScript",local:"streaming-with-javascript",headingTag:"h3"}}),N=new A({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2VFbmRwb2ludCUyMCU3RCUyMGZyb20lMjAnJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UnJTBBJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEhmSW5mZXJlbmNlRW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGWU9VUl9FTkRQT0lOVC5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQnJTJDJTIwJ2hmX1lPVVJfVE9LRU4nKSUwQSUwQSUyRiUyRiUyMHByb21wdCUwQWNvbnN0JTIwcHJvbXB0JTIwJTNEJTIwJ1doYXQlMjBjYW4lMjB5b3UlMjBkbyUyMGluJTIwTnVyZW1iZXJnJTJDJTIwR2VybWFueSUzRiUyMEdpdmUlMjBtZSUyMDMlMjBUaXBzJyUwQSUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwaGYudGV4dEdlbmVyYXRpb25TdHJlYW0oJTdCJTIwaW5wdXRzJTNBJTIwcHJvbXB0JTIwJTdEKSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwciUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMCUyRiUyRiUyMHlpZWxkJTIwdGhlJTIwZ2VuZXJhdGVkJTIwdG9rZW4lMEElMjAlMjBwcm9jZXNzLnN0ZG91dC53cml0ZShyLnRva2VuLnRleHQpJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInferenceEndpoint</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInferenceEndpoint</span>(<span class="hljs-string">&#x27;https://YOUR_ENDPOINT.endpoints.huggingface.cloud&#x27;</span>, <span class="hljs-string">&#x27;hf_YOUR_TOKEN&#x27;</span>)

<span class="hljs-comment">// prompt</span>
<span class="hljs-keyword">const</span> prompt = <span class="hljs-string">&#x27;What can you do in Nuremberg, Germany? Give me 3 Tips&#x27;</span>

<span class="hljs-keyword">const</span> stream = hf.<span class="hljs-title function_">textGenerationStream</span>({ <span class="hljs-attr">inputs</span>: prompt })
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> r <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-comment">// yield the generated token</span>
  process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(r.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>)
}`,wrap:!1}}),_=new F({props:{title:"How does Streaming work under the hood?",local:"how-does-streaming-work-under-the-hood",headingTag:"h2"}}),L=new at({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/conceptual/streaming.md"}}),{c(){y=i("meta"),O=l(),q=i("p"),K=l(),p(J.$$.fragment),ee=l(),p(f.$$.fragment),te=l(),g=i("p"),g.textContent=Ge,se=l(),M=i("div"),M.innerHTML=Ce,ne=l(),U=i("p"),U.textContent=Se,le=l(),j=i("ul"),j.innerHTML=Ve,ae=l(),b=i("p"),b.innerHTML=Ee,ie=l(),T=i("div"),T.innerHTML=He,re=l(),w=i("div"),w.innerHTML=We,oe=l(),p(v.$$.fragment),pe=l(),p(k.$$.fragment),ce=l(),I=i("p"),I.innerHTML=Ne,me=l(),p(x.$$.fragment),he=l(),$=i("p"),$.innerHTML=_e,de=l(),p(B.$$.fragment),ue=l(),R=i("p"),R.innerHTML=ze,ye=l(),p(Z.$$.fragment),Me=l(),p(G.$$.fragment),Te=l(),C=i("p"),C.innerHTML=Qe,we=l(),p(S.$$.fragment),Je=l(),p(V.$$.fragment),fe=l(),E=i("p"),E.innerHTML=Ye,ge=l(),H=i("p"),H.innerHTML=Xe,Ue=l(),W=i("p"),W.innerHTML=Le,je=l(),p(N.$$.fragment),be=l(),p(_.$$.fragment),ve=l(),z=i("p"),z.textContent=Fe,ke=l(),Q=i("p"),Q.textContent=qe,Ie=l(),Y=i("ul"),Y.innerHTML=De,xe=l(),X=i("p"),X.innerHTML=Pe,$e=l(),p(L.$$.fragment),Be=l(),D=i("p"),this.h()},l(e){const t=nt("svelte-u9bgzb",document.head);y=r(t,"META",{name:!0,content:!0}),t.forEach(s),O=a(e),q=r(e,"P",{}),Ae(q).forEach(s),K=a(e),c(J.$$.fragment,e),ee=a(e),c(f.$$.fragment,e),te=a(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-18otp1w"&&(g.textContent=Ge),se=a(e),M=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(M)!=="svelte-1mls61x"&&(M.innerHTML=Ce),ne=a(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1i4w8o9"&&(U.textContent=Se),le=a(e),j=r(e,"UL",{"data-svelte-h":!0}),o(j)!=="svelte-1sljm14"&&(j.innerHTML=Ve),ae=a(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-doyuuq"&&(b.innerHTML=Ee),ie=a(e),T=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-7ia471"&&(T.innerHTML=He),re=a(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1wj2bw6"&&(w.innerHTML=We),oe=a(e),c(v.$$.fragment,e),pe=a(e),c(k.$$.fragment,e),ce=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-16qpzge"&&(I.innerHTML=Ne),me=a(e),c(x.$$.fragment,e),he=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-wt9qrx"&&($.innerHTML=_e),de=a(e),c(B.$$.fragment,e),ue=a(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1nblluv"&&(R.innerHTML=ze),ye=a(e),c(Z.$$.fragment,e),Me=a(e),c(G.$$.fragment,e),Te=a(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-dr4syr"&&(C.innerHTML=Qe),we=a(e),c(S.$$.fragment,e),Je=a(e),c(V.$$.fragment,e),fe=a(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-16sqqc4"&&(E.innerHTML=Ye),ge=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1qwkxte"&&(H.innerHTML=Xe),Ue=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-5nogh0"&&(W.innerHTML=Le),je=a(e),c(N.$$.fragment,e),be=a(e),c(_.$$.fragment,e),ve=a(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1wghvdx"&&(z.textContent=Fe),ke=a(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-m95rqi"&&(Q.textContent=qe),Ie=a(e),Y=r(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-1vpfo5b"&&(Y.innerHTML=De),xe=a(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-jbqwxg"&&(X.innerHTML=Pe),$e=a(e),c(L.$$.fragment,e),Be=a(e),D=r(e,"P",{}),Ae(D).forEach(s),this.h()},h(){P(y,"name","hf:doc:metadata"),P(y,"content",rt),P(M,"class","flex justify-center"),P(T,"class","block dark:hidden"),P(w,"class","hidden dark:block")},m(e,t){lt(document.head,y),n(e,O,t),n(e,q,t),n(e,K,t),m(J,e,t),n(e,ee,t),m(f,e,t),n(e,te,t),n(e,g,t),n(e,se,t),n(e,M,t),n(e,ne,t),n(e,U,t),n(e,le,t),n(e,j,t),n(e,ae,t),n(e,b,t),n(e,ie,t),n(e,T,t),n(e,re,t),n(e,w,t),n(e,oe,t),m(v,e,t),n(e,pe,t),m(k,e,t),n(e,ce,t),n(e,I,t),n(e,me,t),m(x,e,t),n(e,he,t),n(e,$,t),n(e,de,t),m(B,e,t),n(e,ue,t),n(e,R,t),n(e,ye,t),m(Z,e,t),n(e,Me,t),m(G,e,t),n(e,Te,t),n(e,C,t),n(e,we,t),m(S,e,t),n(e,Je,t),m(V,e,t),n(e,fe,t),n(e,E,t),n(e,ge,t),n(e,H,t),n(e,Ue,t),n(e,W,t),n(e,je,t),m(N,e,t),n(e,be,t),m(_,e,t),n(e,ve,t),n(e,z,t),n(e,ke,t),n(e,Q,t),n(e,Ie,t),n(e,Y,t),n(e,xe,t),n(e,X,t),n(e,$e,t),m(L,e,t),n(e,Be,t),n(e,D,t),Re=!0},p:Ke,i(e){Re||(h(J.$$.fragment,e),h(f.$$.fragment,e),h(v.$$.fragment,e),h(k.$$.fragment,e),h(x.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(S.$$.fragment,e),h(V.$$.fragment,e),h(N.$$.fragment,e),h(_.$$.fragment,e),h(L.$$.fragment,e),Re=!0)},o(e){d(J.$$.fragment,e),d(f.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(x.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(S.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(_.$$.fragment,e),d(L.$$.fragment,e),Re=!1},d(e){e&&(s(O),s(q),s(K),s(ee),s(te),s(g),s(se),s(M),s(ne),s(U),s(le),s(j),s(ae),s(b),s(ie),s(T),s(re),s(w),s(oe),s(pe),s(ce),s(I),s(me),s(he),s($),s(de),s(ue),s(R),s(ye),s(Me),s(Te),s(C),s(we),s(Je),s(fe),s(E),s(ge),s(H),s(Ue),s(W),s(je),s(be),s(ve),s(z),s(ke),s(Q),s(Ie),s(Y),s(xe),s(X),s($e),s(Be),s(D)),s(y),u(J,e),u(f,e),u(v,e),u(k,e),u(x,e),u(B,e),u(Z,e),u(G,e),u(S,e),u(V,e),u(N,e),u(_,e),u(L,e)}}}const rt='{"title":"Streaming","local":"streaming","sections":[{"title":"What is Streaming?","local":"what-is-streaming","sections":[],"depth":2},{"title":"How to use Streaming?","local":"how-to-use-streaming","sections":[{"title":"Streaming with Python","local":"streaming-with-python","sections":[],"depth":3},{"title":"Streaming with cURL","local":"streaming-with-curl","sections":[],"depth":3},{"title":"Streaming with JavaScript","local":"streaming-with-javascript","sections":[],"depth":3}],"depth":2},{"title":"How does Streaming work under the hood?","local":"how-does-streaming-work-under-the-hood","sections":[],"depth":2}],"depth":1}';function ot(Ze){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends tt{constructor(y){super(),st(this,y,ot,it,Oe,{})}}export{dt as component};
