import{s as dd,o as cd,n as k}from"../chunks/scheduler.7da89386.js";import{S as ud,i as gd,g as m,s as l,r as u,A as hd,h as d,f as i,c as r,j as v,u as g,x as $,k as j,y as a,a as c,v as h,d as f,t as b,w as M}from"../chunks/index.20910acc.js";import{T as C}from"../chunks/Tip.53e22153.js";import{D as J}from"../chunks/Docstring.8bc1b1a0.js";import{C as R}from"../chunks/CodeBlock.143bd81e.js";import{E as U}from"../chunks/ExampleCodeBlock.ccb32d81.js";import{H as x}from"../chunks/getInferenceSnippets.a59ed46d.js";function fd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function bd(w){let n,T="Example of text generation:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1bvu0cy"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Md(w){let n,T="Example using <code>transformers.pipelines</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function yd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Td(w){let n,T="Example of feature extraction:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-12vwt80"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function _d(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function $d(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function wd(w){let n,T="Example of text generation:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1bvu0cy"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function vd(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function jd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Jd(w){let n,T="Example of single-label classification:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-ykxpe4"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function kd(w){let n,T="Example using <code>transformers.pipelines</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function xd(w){let n,T="Example using zero-shot-classification <code>transformers.pipelines</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1vtj8d2"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Ud(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Rd(w){let n,T="Example of token classification:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-rtgw80"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Zd(w){let n,T="Example using <code>transformers.pipelines</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Wd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Cd(w){let n,T="Example of mutliple choice:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-lfckvi"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Fd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Id(w){let n,T="Example of question answering:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1ml1brl"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Gd(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Vd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Xd(w){let n,T="Example of image classification:",o,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1nh3zco"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Nd(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Sd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function zd(w){let n,T="Example of semantic segmentation:",o,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1wzzaup"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Bd(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function qd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Od(w){let n,T="Example of audio classification:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1mp8f15"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Ed(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Hd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Ld(w){let n,T="Example of audio frame classification:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-12boqdm"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Qd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Yd(w){let n,T="Example of CTC:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-mdyxnj"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Ad(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function Pd(w){let n,T="Example of text generation:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1bvu0cy"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Dd(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function Kd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function ec(w){let n,T="Example of Audio XVector:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1kzdm5c"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function tc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function nc(w){let n,T="Example of text generation:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1bvu0cy"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function sc(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function oc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function ac(w){let n,T="Example of pix2struct:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-11ikyn3"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function lc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function rc(w){let n,T="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-6kynse"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function ic(w){let n,T="Example using <code>transformers.pipelines</code>(only if the task is supported):",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-xxeb0k"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function pc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(o){n=d(o,"P",{"data-svelte-h":!0}),$(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(o,s){c(o,n,s)},p:k,d(o){o&&i(n)}}}function mc(w){let n,T="Example of feature extraction:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-12vwt80"&&(n.textContent=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function dc(w){let n,T="Example using <code>transformers.pipeline</code>:",o,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,o=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),$(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),o=r(t),g(s.$$.fragment,t)},m(t,_){c(t,n,_),c(t,o,_),h(s,t,_),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(i(n),i(o)),M(s,t)}}}function cc(w){let n,T,o,s,y,t,_,Za,cn,Vp="The following ORT classes are available for instantiating a base model class without a specific head.",Wa,un,Ca,Z,gn,Hl,ro,Xp="Base class for implementing models using ONNX Runtime.",Ll,io,Np=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,Ql,po,Sp="Class attributes:",Yl,mo,zp=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,Al,rt,hn,Pl,co,Bp="Returns whether this model can generate sequences with <code>.generate()</code>.",Dl,W,fn,Kl,uo,qp="Instantiate a pretrained model from a pre-trained model configuration.",er,go,Op=`provider (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>):
ONNX Runtime provider to use for loading the model.
See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for possible providers.
providers (<code>Optional[Sequence[str]]</code>, defaults to <code>None</code>):
List of execution providers to use for loading the model.
This argument takes precedence over the <code>provider</code> argument.
provider_options (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>):
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .
session_options (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>),:
ONNX Runtime session options to use for loading the model.
use_io_binding (<code>Optional[bool]</code>, defaults to <code>None</code>):
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.
kwargs (<code>Dict[str, Any]</code>):
Will be passed to the underlying model loading methods.`,tr,ho,Ep="<p>Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)</p>",nr,fo,Hp=`use_cache (<code>Optional[bool]</code>, defaults to <code>True</code>):
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,sr,bo,Lp="<p>Parameters for ORTModelForCausalLM</p>",or,Mo,Qp=`use_merged (<code>Optional[bool]</code>, defaults to <code>None</code>):
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,Fa,bn,Ia,Mn,Yp="The following ORT classes are available for the following natural language processing tasks.",Ga,yn,Va,ee,Tn,ar,yo,Ap=`ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt-bigcode, gpt_neo, gpt_neox, gptj, llama.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,lr,To,Pp='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',rr,B,_n,ir,_o,Dp="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",pr,it,mr,pt,dr,mt,Xa,$n,Na,te,wn,cr,$o,Kp=`ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ur,wo,em='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',gr,q,vn,hr,vo,tm="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",fr,dt,br,ct,Mr,ut,Sa,jn,za,ne,Jn,yr,jo,nm=`Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot-small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Tr,Jo,sm="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",_r,O,kn,$r,ko,om="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",wr,gt,vr,ht,jr,ft,Ba,xn,qa,V,Un,Jr,xo,am=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,kr,Uo,lm=`This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,xr,Ro,rm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ur,G,Rn,Rr,Zo,im="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",Zr,bt,Wr,Mt,Cr,yt,Fr,Tt,Oa,Zn,Ea,X,Wn,Ir,Wo,pm=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Gr,Co,mm=`This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Vr,Fo,dm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Xr,E,Cn,Nr,Io,cm="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",Sr,_t,zr,$t,Br,wt,Ha,Fn,La,N,In,qr,Go,um=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Or,Vo,gm=`This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Er,Xo,hm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Hr,Re,Gn,Lr,No,fm="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",Qr,vt,Yr,jt,Qa,Vn,Ya,se,Xn,Ar,So,bm=`ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Pr,zo,Mm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Dr,H,Nn,Kr,Bo,ym="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",ei,Jt,ti,kt,ni,xt,Aa,Sn,Pa,zn,Tm="The following ORT classes are available for the following computer vision tasks.",Da,Bn,Ka,oe,qn,si,qo,_m=`ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec-vision, deit, dinov2, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, swinv2, vit.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,oi,Oo,$m='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ai,L,On,li,Eo,wm="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",ri,Ut,ii,Rt,pi,Zt,el,En,tl,ae,Hn,mi,Ho,vm=`ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports maskformer, segformer.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,di,Lo,jm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ci,Q,Ln,ui,Qo,Jm="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",gi,Wt,hi,Ct,fi,Ft,nl,Qn,sl,Yn,km="The following ORT classes are available for the following audio tasks.",ol,An,al,S,Pn,bi,Yo,xm=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,Mi,Ao,Um=`This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,yi,Po,Rm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ti,Y,Dn,_i,Do,Zm="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",$i,It,wi,Gt,vi,Vt,ll,Kn,rl,le,es,ji,Ko,Wm=`ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ji,ea,Cm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ki,Ze,ts,xi,ta,Fm="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",Ui,Xt,Ri,Nt,il,ns,pl,re,ss,Zi,na,Im=`ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Wi,sa,Gm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ci,We,os,Fi,oa,Vm="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",Ii,St,Gi,zt,ml,as,dl,ie,ls,Vi,aa,Xm=`Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Xi,la,Nm="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",Ni,A,rs,Si,ra,Sm="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",zi,Bt,Bi,qt,qi,Ot,cl,is,ul,pe,ps,Oi,ia,zm=`ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ei,pa,Bm='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Hi,Ce,ms,Li,ma,qm="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",Qi,Et,Yi,Ht,gl,ds,hl,cs,Om="The following ORT classes are available for the following multimodal tasks.",fl,us,bl,me,gs,Ai,da,Em=`VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Pi,ca,Hm="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",Di,P,hs,Ki,ua,Lm="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",ep,Lt,tp,Qt,np,Yt,Ml,fs,yl,de,bs,sp,ga,Qm=`Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.
This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,op,ha,Ym="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",ap,Fe,Ms,lp,fa,Am="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",rp,At,ip,Pt,Tl,ys,_l,Ts,Pm="The following ORT classes are available for the following custom tasks.",$l,_s,wl,ce,$s,pp,ba,Dm=`ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,mp,Ma,Km='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',dp,D,ws,cp,ya,ed="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",up,Dt,gp,Kt,hp,en,vl,vs,jl,ue,js,fp,Ta,td=`ONNX Model for feature-extraction task.
This model inherits from <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,bp,_a,nd='This class should be initialized using the <a href="/docs/optimum/pr_26/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Mp,K,Js,yp,$a,sd="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",Tp,tn,_p,nn,$p,sn,Jl,ks,kl,xs,xl,et,Us,wp,on,Rs,vp,wa,od="Call self as a function.",Ul,Zs,Rl,tt,Ws,jp,an,Cs,Jp,va,ad="Call self as a function.",Zl,Fs,Wl,nt,Is,kp,ln,Gs,xp,ja,ld="Call self as a function.",Cl,Vs,Fl,st,Xs,Up,rn,Ns,Rp,Ja,rd="Call self as a function.",Il,Ss,Gl,ot,zs,Zp,pn,Bs,Wp,ka,id="Call self as a function.",Vl,qs,Xl,at,Os,Cp,mn,Es,Fp,xa,pd="Call self as a function.",Nl,Hs,Sl,lt,Ls,Ip,dn,Qs,Gp,Ua,md="Call self as a function.",zl,Ra,Bl;return y=new x({props:{title:"Models",local:"models",headingTag:"h1"}}),_=new x({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),un=new x({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),gn=new J({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.-",description:'<strong>-</strong> config (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> &#x2014; The configuration of the model. &#x2014;',name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> session (<code>~onnxruntime.InferenceSession</code>) &#x2014; The ONNX Runtime InferenceSession that is running the model. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to use I/O bindings with **ONNX Runtime &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.with",description:"<strong>with</strong> the CUDAExecutionProvider**, this can significantly speedup inference depending on the task. &#x2014;",name:"with"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> model_save_dir (<code>Path</code>) &#x2014; The directory where the model exported to ONNX is saved. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.By",description:"<strong>By</strong> defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the &#x2014;",name:"By"},{anchor:"optimum.onnxruntime.ORTModel.cache",description:"<strong>cache</strong> directory is used. &#x2014;",name:"cache"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L126"}}),hn=new J({props:{name:"can_generate",anchor:"optimum.onnxruntime.ORTModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L565"}}),fn=new J({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": typing.Union[str, pathlib.Path]"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"},{name:"export",val:": bool = False"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": str = 'main'"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"trust_remote_code",val:": bool = False"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"providers",val:": typing.Optional[collections.abc.Sequence[str]] = None"},{name:"provider_options",val:": typing.Union[collections.abc.Sequence[dict[str, typing.Any]], dict[str, typing.Any], NoneType] = None"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.export",description:`<strong>export</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> needs to be exported to the targeted format.`,name:"export"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
Deprecated. Please use the <code>token</code> argument instead.`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L437",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`}}),bn=new x({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),yn=new x({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),Tn=new J({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_decoder.py#L122"}}),_n=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_decoder.py#L239"}}),it=new C({props:{$$slots:{default:[fd]},$$scope:{ctx:w}}}),pt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[bd]},$$scope:{ctx:w}}}),mt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[Md]},$$scope:{ctx:w}}}),$n=new x({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),wn=new J({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L750"}}),vn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L756"}}),dt=new C({props:{$$slots:{default:[yd]},$$scope:{ctx:w}}}),ct=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[Td]},$$scope:{ctx:w}}}),ut=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[_d]},$$scope:{ctx:w}}}),jn=new x({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),Jn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_seq2seq.py#L1285"}}),kn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_seq2seq.py#L1292"}}),gt=new C({props:{$$slots:{default:[$d]},$$scope:{ctx:w}}}),ht=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[wd]},$$scope:{ctx:w}}}),ft=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[vd]},$$scope:{ctx:w}}}),xn=new x({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),Un=new J({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L966"}}),Rn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L974"}}),bt=new C({props:{$$slots:{default:[jd]},$$scope:{ctx:w}}}),Mt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[Jd]},$$scope:{ctx:w}}}),yt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[kd]},$$scope:{ctx:w}}}),Tt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[xd]},$$scope:{ctx:w}}}),Zn=new x({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),Wn=new J({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1067"}}),Cn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1076"}}),_t=new C({props:{$$slots:{default:[Ud]},$$scope:{ctx:w}}}),$t=new U({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[Rd]},$$scope:{ctx:w}}}),wt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[Zd]},$$scope:{ctx:w}}}),Fn=new x({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),In=new J({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1163"}}),Gn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1171"}}),vt=new C({props:{$$slots:{default:[Wd]},$$scope:{ctx:w}}}),jt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[Cd]},$$scope:{ctx:w}}}),Vn=new x({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Xn=new J({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L850"}}),Nn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L856"}}),Jt=new C({props:{$$slots:{default:[Fd]},$$scope:{ctx:w}}}),kt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[Id]},$$scope:{ctx:w}}}),xt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[Gd]},$$scope:{ctx:w}}}),Sn=new x({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),Bn=new x({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),qn=new J({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1268"}}),On=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1274"}}),Ut=new C({props:{$$slots:{default:[Vd]},$$scope:{ctx:w}}}),Rt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[Xd]},$$scope:{ctx:w}}}),Zt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[Nd]},$$scope:{ctx:w}}}),En=new x({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),Hn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1364"}}),Ln=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1370"}}),Wt=new C({props:{$$slots:{default:[Sd]},$$scope:{ctx:w}}}),Ct=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[zd]},$$scope:{ctx:w}}}),Ft=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[Bd]},$$scope:{ctx:w}}}),Qn=new x({props:{title:"Audio",local:"audio",headingTag:"h2"}}),An=new x({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),Pn=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1464"}}),Dn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1472"}}),It=new C({props:{$$slots:{default:[qd]},$$scope:{ctx:w}}}),Gt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[Od]},$$scope:{ctx:w}}}),Vt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[Ed]},$$scope:{ctx:w}}}),Kn=new x({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),es=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1751"}}),ts=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1757"}}),Xt=new C({props:{$$slots:{default:[Hd]},$$scope:{ctx:w}}}),Nt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[Ld]},$$scope:{ctx:w}}}),ns=new x({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),ss=new J({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1562"}}),os=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1568"}}),St=new C({props:{$$slots:{default:[Qd]},$$scope:{ctx:w}}}),zt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[Yd]},$$scope:{ctx:w}}}),as=new x({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),ls=new J({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_seq2seq.py#L1380"}}),rs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"cache_position",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_seq2seq.py#L1401"}}),Bt=new C({props:{$$slots:{default:[Ad]},$$scope:{ctx:w}}}),qt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[Pd]},$$scope:{ctx:w}}}),Ot=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[Dd]},$$scope:{ctx:w}}}),is=new x({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),ps=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1664"}}),ms=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1670"}}),Et=new C({props:{$$slots:{default:[Kd]},$$scope:{ctx:w}}}),Ht=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[ec]},$$scope:{ctx:w}}}),ds=new x({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),us=new x({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),gs=new J({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_seq2seq.py#L1512"}}),hs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_seq2seq.py#L1521"}}),Lt=new C({props:{$$slots:{default:[tc]},$$scope:{ctx:w}}}),Qt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[nc]},$$scope:{ctx:w}}}),Yt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[sc]},$$scope:{ctx:w}}}),fs=new x({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),bs=new J({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_seq2seq.py#L1606"}}),Ms=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[tuple[tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_seq2seq.py#L1616"}}),At=new C({props:{$$slots:{default:[oc]},$$scope:{ctx:w}}}),Pt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[ac]},$$scope:{ctx:w}}}),ys=new x({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),_s=new x({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),$s=new J({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1930"}}),ws=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**model_inputs",val:": typing.Union[torch.Tensor, numpy.ndarray]"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L1934"}}),Dt=new C({props:{$$slots:{default:[lc]},$$scope:{ctx:w}}}),Kt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[rc]},$$scope:{ctx:w}}}),en=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[ic]},$$scope:{ctx:w}}}),vs=new x({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),js=new J({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L618"}}),Js=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"position_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"visual_embeds",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"visual_attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"visual_token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/onnxruntime/modeling_ort.py#L624"}}),tn=new C({props:{$$slots:{default:[pc]},$$scope:{ctx:w}}}),nn=new U({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[mc]},$$scope:{ctx:w}}}),sn=new U({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[dc]},$$scope:{ctx:w}}}),ks=new x({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),xs=new x({props:{title:"ORTDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",headingTag:"h4"}}),Us=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/utils/dummy_diffusers_objects.py#L18"}}),Rs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Zs=new x({props:{title:"ORTStableDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",headingTag:"h4"}}),Ws=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/utils/dummy_diffusers_objects.py#L62"}}),Cs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Fs=new x({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Is=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/utils/dummy_diffusers_objects.py#L73"}}),Gs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Vs=new x({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Xs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/utils/dummy_diffusers_objects.py#L84"}}),Ns=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ss=new x({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),zs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/utils/dummy_diffusers_objects.py#L95"}}),Bs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),qs=new x({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),Os=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/utils/dummy_diffusers_objects.py#L106"}}),Es=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Hs=new x({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),Ls=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-onnx/blob/vr_26/optimum/utils/dummy_diffusers_objects.py#L128"}}),Qs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),{c(){n=m("meta"),T=l(),o=m("p"),s=l(),u(y.$$.fragment),t=l(),u(_.$$.fragment),Za=l(),cn=m("p"),cn.textContent=Vp,Wa=l(),u(un.$$.fragment),Ca=l(),Z=m("div"),u(gn.$$.fragment),Hl=l(),ro=m("p"),ro.textContent=Xp,Ll=l(),io=m("p"),io.innerHTML=Np,Ql=l(),po=m("p"),po.textContent=Sp,Yl=l(),mo=m("ul"),mo.innerHTML=zp,Al=l(),rt=m("div"),u(hn.$$.fragment),Pl=l(),co=m("p"),co.innerHTML=Bp,Dl=l(),W=m("div"),u(fn.$$.fragment),Kl=l(),uo=m("p"),uo.textContent=qp,er=l(),go=m("p"),go.innerHTML=Op,tr=l(),ho=m("blockquote"),ho.innerHTML=Ep,nr=l(),fo=m("p"),fo.innerHTML=Hp,sr=l(),bo=m("blockquote"),bo.innerHTML=Lp,or=l(),Mo=m("p"),Mo.innerHTML=Qp,Fa=l(),u(bn.$$.fragment),Ia=l(),Mn=m("p"),Mn.textContent=Yp,Ga=l(),u(yn.$$.fragment),Va=l(),ee=m("div"),u(Tn.$$.fragment),ar=l(),yo=m("p"),yo.innerHTML=Ap,lr=l(),To=m("p"),To.innerHTML=Pp,rr=l(),B=m("div"),u(_n.$$.fragment),ir=l(),_o=m("p"),_o.innerHTML=Dp,pr=l(),u(it.$$.fragment),mr=l(),u(pt.$$.fragment),dr=l(),u(mt.$$.fragment),Xa=l(),u($n.$$.fragment),Na=l(),te=m("div"),u(wn.$$.fragment),cr=l(),$o=m("p"),$o.innerHTML=Kp,ur=l(),wo=m("p"),wo.innerHTML=em,gr=l(),q=m("div"),u(vn.$$.fragment),hr=l(),vo=m("p"),vo.innerHTML=tm,fr=l(),u(dt.$$.fragment),br=l(),u(ct.$$.fragment),Mr=l(),u(ut.$$.fragment),Sa=l(),u(jn.$$.fragment),za=l(),ne=m("div"),u(Jn.$$.fragment),yr=l(),jo=m("p"),jo.innerHTML=nm,Tr=l(),Jo=m("p"),Jo.innerHTML=sm,_r=l(),O=m("div"),u(kn.$$.fragment),$r=l(),ko=m("p"),ko.innerHTML=om,wr=l(),u(gt.$$.fragment),vr=l(),u(ht.$$.fragment),jr=l(),u(ft.$$.fragment),Ba=l(),u(xn.$$.fragment),qa=l(),V=m("div"),u(Un.$$.fragment),Jr=l(),xo=m("p"),xo.textContent=am,kr=l(),Uo=m("p"),Uo.innerHTML=lm,xr=l(),Ro=m("p"),Ro.innerHTML=rm,Ur=l(),G=m("div"),u(Rn.$$.fragment),Rr=l(),Zo=m("p"),Zo.innerHTML=im,Zr=l(),u(bt.$$.fragment),Wr=l(),u(Mt.$$.fragment),Cr=l(),u(yt.$$.fragment),Fr=l(),u(Tt.$$.fragment),Oa=l(),u(Zn.$$.fragment),Ea=l(),X=m("div"),u(Wn.$$.fragment),Ir=l(),Wo=m("p"),Wo.textContent=pm,Gr=l(),Co=m("p"),Co.innerHTML=mm,Vr=l(),Fo=m("p"),Fo.innerHTML=dm,Xr=l(),E=m("div"),u(Cn.$$.fragment),Nr=l(),Io=m("p"),Io.innerHTML=cm,Sr=l(),u(_t.$$.fragment),zr=l(),u($t.$$.fragment),Br=l(),u(wt.$$.fragment),Ha=l(),u(Fn.$$.fragment),La=l(),N=m("div"),u(In.$$.fragment),qr=l(),Go=m("p"),Go.textContent=um,Or=l(),Vo=m("p"),Vo.innerHTML=gm,Er=l(),Xo=m("p"),Xo.innerHTML=hm,Hr=l(),Re=m("div"),u(Gn.$$.fragment),Lr=l(),No=m("p"),No.innerHTML=fm,Qr=l(),u(vt.$$.fragment),Yr=l(),u(jt.$$.fragment),Qa=l(),u(Vn.$$.fragment),Ya=l(),se=m("div"),u(Xn.$$.fragment),Ar=l(),So=m("p"),So.innerHTML=bm,Pr=l(),zo=m("p"),zo.innerHTML=Mm,Dr=l(),H=m("div"),u(Nn.$$.fragment),Kr=l(),Bo=m("p"),Bo.innerHTML=ym,ei=l(),u(Jt.$$.fragment),ti=l(),u(kt.$$.fragment),ni=l(),u(xt.$$.fragment),Aa=l(),u(Sn.$$.fragment),Pa=l(),zn=m("p"),zn.textContent=Tm,Da=l(),u(Bn.$$.fragment),Ka=l(),oe=m("div"),u(qn.$$.fragment),si=l(),qo=m("p"),qo.innerHTML=_m,oi=l(),Oo=m("p"),Oo.innerHTML=$m,ai=l(),L=m("div"),u(On.$$.fragment),li=l(),Eo=m("p"),Eo.innerHTML=wm,ri=l(),u(Ut.$$.fragment),ii=l(),u(Rt.$$.fragment),pi=l(),u(Zt.$$.fragment),el=l(),u(En.$$.fragment),tl=l(),ae=m("div"),u(Hn.$$.fragment),mi=l(),Ho=m("p"),Ho.innerHTML=vm,di=l(),Lo=m("p"),Lo.innerHTML=jm,ci=l(),Q=m("div"),u(Ln.$$.fragment),ui=l(),Qo=m("p"),Qo.innerHTML=Jm,gi=l(),u(Wt.$$.fragment),hi=l(),u(Ct.$$.fragment),fi=l(),u(Ft.$$.fragment),nl=l(),u(Qn.$$.fragment),sl=l(),Yn=m("p"),Yn.textContent=km,ol=l(),u(An.$$.fragment),al=l(),S=m("div"),u(Pn.$$.fragment),bi=l(),Yo=m("p"),Yo.textContent=xm,Mi=l(),Ao=m("p"),Ao.innerHTML=Um,yi=l(),Po=m("p"),Po.innerHTML=Rm,Ti=l(),Y=m("div"),u(Dn.$$.fragment),_i=l(),Do=m("p"),Do.innerHTML=Zm,$i=l(),u(It.$$.fragment),wi=l(),u(Gt.$$.fragment),vi=l(),u(Vt.$$.fragment),ll=l(),u(Kn.$$.fragment),rl=l(),le=m("div"),u(es.$$.fragment),ji=l(),Ko=m("p"),Ko.innerHTML=Wm,Ji=l(),ea=m("p"),ea.innerHTML=Cm,ki=l(),Ze=m("div"),u(ts.$$.fragment),xi=l(),ta=m("p"),ta.innerHTML=Fm,Ui=l(),u(Xt.$$.fragment),Ri=l(),u(Nt.$$.fragment),il=l(),u(ns.$$.fragment),pl=l(),re=m("div"),u(ss.$$.fragment),Zi=l(),na=m("p"),na.innerHTML=Im,Wi=l(),sa=m("p"),sa.innerHTML=Gm,Ci=l(),We=m("div"),u(os.$$.fragment),Fi=l(),oa=m("p"),oa.innerHTML=Vm,Ii=l(),u(St.$$.fragment),Gi=l(),u(zt.$$.fragment),ml=l(),u(as.$$.fragment),dl=l(),ie=m("div"),u(ls.$$.fragment),Vi=l(),aa=m("p"),aa.innerHTML=Xm,Xi=l(),la=m("p"),la.innerHTML=Nm,Ni=l(),A=m("div"),u(rs.$$.fragment),Si=l(),ra=m("p"),ra.innerHTML=Sm,zi=l(),u(Bt.$$.fragment),Bi=l(),u(qt.$$.fragment),qi=l(),u(Ot.$$.fragment),cl=l(),u(is.$$.fragment),ul=l(),pe=m("div"),u(ps.$$.fragment),Oi=l(),ia=m("p"),ia.innerHTML=zm,Ei=l(),pa=m("p"),pa.innerHTML=Bm,Hi=l(),Ce=m("div"),u(ms.$$.fragment),Li=l(),ma=m("p"),ma.innerHTML=qm,Qi=l(),u(Et.$$.fragment),Yi=l(),u(Ht.$$.fragment),gl=l(),u(ds.$$.fragment),hl=l(),cs=m("p"),cs.textContent=Om,fl=l(),u(us.$$.fragment),bl=l(),me=m("div"),u(gs.$$.fragment),Ai=l(),da=m("p"),da.innerHTML=Em,Pi=l(),ca=m("p"),ca.innerHTML=Hm,Di=l(),P=m("div"),u(hs.$$.fragment),Ki=l(),ua=m("p"),ua.innerHTML=Lm,ep=l(),u(Lt.$$.fragment),tp=l(),u(Qt.$$.fragment),np=l(),u(Yt.$$.fragment),Ml=l(),u(fs.$$.fragment),yl=l(),de=m("div"),u(bs.$$.fragment),sp=l(),ga=m("p"),ga.innerHTML=Qm,op=l(),ha=m("p"),ha.innerHTML=Ym,ap=l(),Fe=m("div"),u(Ms.$$.fragment),lp=l(),fa=m("p"),fa.innerHTML=Am,rp=l(),u(At.$$.fragment),ip=l(),u(Pt.$$.fragment),Tl=l(),u(ys.$$.fragment),_l=l(),Ts=m("p"),Ts.textContent=Pm,$l=l(),u(_s.$$.fragment),wl=l(),ce=m("div"),u($s.$$.fragment),pp=l(),ba=m("p"),ba.innerHTML=Dm,mp=l(),Ma=m("p"),Ma.innerHTML=Km,dp=l(),D=m("div"),u(ws.$$.fragment),cp=l(),ya=m("p"),ya.innerHTML=ed,up=l(),u(Dt.$$.fragment),gp=l(),u(Kt.$$.fragment),hp=l(),u(en.$$.fragment),vl=l(),u(vs.$$.fragment),jl=l(),ue=m("div"),u(js.$$.fragment),fp=l(),Ta=m("p"),Ta.innerHTML=td,bp=l(),_a=m("p"),_a.innerHTML=nd,Mp=l(),K=m("div"),u(Js.$$.fragment),yp=l(),$a=m("p"),$a.innerHTML=sd,Tp=l(),u(tn.$$.fragment),_p=l(),u(nn.$$.fragment),$p=l(),u(sn.$$.fragment),Jl=l(),u(ks.$$.fragment),kl=l(),u(xs.$$.fragment),xl=l(),et=m("div"),u(Us.$$.fragment),wp=l(),on=m("div"),u(Rs.$$.fragment),vp=l(),wa=m("p"),wa.textContent=od,Ul=l(),u(Zs.$$.fragment),Rl=l(),tt=m("div"),u(Ws.$$.fragment),jp=l(),an=m("div"),u(Cs.$$.fragment),Jp=l(),va=m("p"),va.textContent=ad,Zl=l(),u(Fs.$$.fragment),Wl=l(),nt=m("div"),u(Is.$$.fragment),kp=l(),ln=m("div"),u(Gs.$$.fragment),xp=l(),ja=m("p"),ja.textContent=ld,Cl=l(),u(Vs.$$.fragment),Fl=l(),st=m("div"),u(Xs.$$.fragment),Up=l(),rn=m("div"),u(Ns.$$.fragment),Rp=l(),Ja=m("p"),Ja.textContent=rd,Il=l(),u(Ss.$$.fragment),Gl=l(),ot=m("div"),u(zs.$$.fragment),Zp=l(),pn=m("div"),u(Bs.$$.fragment),Wp=l(),ka=m("p"),ka.textContent=id,Vl=l(),u(qs.$$.fragment),Xl=l(),at=m("div"),u(Os.$$.fragment),Cp=l(),mn=m("div"),u(Es.$$.fragment),Fp=l(),xa=m("p"),xa.textContent=pd,Nl=l(),u(Hs.$$.fragment),Sl=l(),lt=m("div"),u(Ls.$$.fragment),Ip=l(),dn=m("div"),u(Qs.$$.fragment),Gp=l(),Ua=m("p"),Ua.textContent=md,zl=l(),Ra=m("p"),this.h()},l(e){const p=hd("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(i),T=r(e),o=d(e,"P",{}),v(o).forEach(i),s=r(e),g(y.$$.fragment,e),t=r(e),g(_.$$.fragment,e),Za=r(e),cn=d(e,"P",{"data-svelte-h":!0}),$(cn)!=="svelte-uyecg"&&(cn.textContent=Vp),Wa=r(e),g(un.$$.fragment,e),Ca=r(e),Z=d(e,"DIV",{class:!0});var F=v(Z);g(gn.$$.fragment,F),Hl=r(F),ro=d(F,"P",{"data-svelte-h":!0}),$(ro)!=="svelte-12yueui"&&(ro.textContent=Xp),Ll=r(F),io=d(F,"P",{"data-svelte-h":!0}),$(io)!=="svelte-zarm0s"&&(io.innerHTML=Np),Ql=r(F),po=d(F,"P",{"data-svelte-h":!0}),$(po)!=="svelte-wz8va1"&&(po.textContent=Sp),Yl=r(F),mo=d(F,"UL",{"data-svelte-h":!0}),$(mo)!=="svelte-qpxha0"&&(mo.innerHTML=zp),Al=r(F),rt=d(F,"DIV",{class:!0});var Ys=v(rt);g(hn.$$.fragment,Ys),Pl=r(Ys),co=d(Ys,"P",{"data-svelte-h":!0}),$(co)!=="svelte-1r2xt0l"&&(co.innerHTML=Bp),Ys.forEach(i),Dl=r(F),W=d(F,"DIV",{class:!0});var I=v(W);g(fn.$$.fragment,I),Kl=r(I),uo=d(I,"P",{"data-svelte-h":!0}),$(uo)!=="svelte-18vxhwp"&&(uo.textContent=qp),er=r(I),go=d(I,"P",{"data-svelte-h":!0}),$(go)!=="svelte-1mrbn81"&&(go.innerHTML=Op),tr=r(I),ho=d(I,"BLOCKQUOTE",{"data-svelte-h":!0}),$(ho)!=="svelte-1uv5y3f"&&(ho.innerHTML=Ep),nr=r(I),fo=d(I,"P",{"data-svelte-h":!0}),$(fo)!=="svelte-vzi3zk"&&(fo.innerHTML=Hp),sr=r(I),bo=d(I,"BLOCKQUOTE",{"data-svelte-h":!0}),$(bo)!=="svelte-xq6lc5"&&(bo.innerHTML=Lp),or=r(I),Mo=d(I,"P",{"data-svelte-h":!0}),$(Mo)!=="svelte-111jrpf"&&(Mo.innerHTML=Qp),I.forEach(i),F.forEach(i),Fa=r(e),g(bn.$$.fragment,e),Ia=r(e),Mn=d(e,"P",{"data-svelte-h":!0}),$(Mn)!=="svelte-1tlroh"&&(Mn.textContent=Yp),Ga=r(e),g(yn.$$.fragment,e),Va=r(e),ee=d(e,"DIV",{class:!0});var Ie=v(ee);g(Tn.$$.fragment,Ie),ar=r(Ie),yo=d(Ie,"P",{"data-svelte-h":!0}),$(yo)!=="svelte-79bpr6"&&(yo.innerHTML=Ap),lr=r(Ie),To=d(Ie,"P",{"data-svelte-h":!0}),$(To)!=="svelte-l92blw"&&(To.innerHTML=Pp),rr=r(Ie),B=d(Ie,"DIV",{class:!0});var ge=v(B);g(_n.$$.fragment,ge),ir=r(ge),_o=d(ge,"P",{"data-svelte-h":!0}),$(_o)!=="svelte-1ox9av6"&&(_o.innerHTML=Dp),pr=r(ge),g(it.$$.fragment,ge),mr=r(ge),g(pt.$$.fragment,ge),dr=r(ge),g(mt.$$.fragment,ge),ge.forEach(i),Ie.forEach(i),Xa=r(e),g($n.$$.fragment,e),Na=r(e),te=d(e,"DIV",{class:!0});var Ge=v(te);g(wn.$$.fragment,Ge),cr=r(Ge),$o=d(Ge,"P",{"data-svelte-h":!0}),$($o)!=="svelte-1neu3y9"&&($o.innerHTML=Kp),ur=r(Ge),wo=d(Ge,"P",{"data-svelte-h":!0}),$(wo)!=="svelte-l92blw"&&(wo.innerHTML=em),gr=r(Ge),q=d(Ge,"DIV",{class:!0});var he=v(q);g(vn.$$.fragment,he),hr=r(he),vo=d(he,"P",{"data-svelte-h":!0}),$(vo)!=="svelte-1xqof9m"&&(vo.innerHTML=tm),fr=r(he),g(dt.$$.fragment,he),br=r(he),g(ct.$$.fragment,he),Mr=r(he),g(ut.$$.fragment,he),he.forEach(i),Ge.forEach(i),Sa=r(e),g(jn.$$.fragment,e),za=r(e),ne=d(e,"DIV",{class:!0});var Ve=v(ne);g(Jn.$$.fragment,Ve),yr=r(Ve),jo=d(Ve,"P",{"data-svelte-h":!0}),$(jo)!=="svelte-1r520uu"&&(jo.innerHTML=nm),Tr=r(Ve),Jo=d(Ve,"P",{"data-svelte-h":!0}),$(Jo)!=="svelte-10uuk2l"&&(Jo.innerHTML=sm),_r=r(Ve),O=d(Ve,"DIV",{class:!0});var fe=v(O);g(kn.$$.fragment,fe),$r=r(fe),ko=d(fe,"P",{"data-svelte-h":!0}),$(ko)!=="svelte-n65k7h"&&(ko.innerHTML=om),wr=r(fe),g(gt.$$.fragment,fe),vr=r(fe),g(ht.$$.fragment,fe),jr=r(fe),g(ft.$$.fragment,fe),fe.forEach(i),Ve.forEach(i),Ba=r(e),g(xn.$$.fragment,e),qa=r(e),V=d(e,"DIV",{class:!0});var be=v(V);g(Un.$$.fragment,be),Jr=r(be),xo=d(be,"P",{"data-svelte-h":!0}),$(xo)!=="svelte-1fcejq5"&&(xo.textContent=am),kr=r(be),Uo=d(be,"P",{"data-svelte-h":!0}),$(Uo)!=="svelte-cle55h"&&(Uo.innerHTML=lm),xr=r(be),Ro=d(be,"P",{"data-svelte-h":!0}),$(Ro)!=="svelte-l92blw"&&(Ro.innerHTML=rm),Ur=r(be),G=d(be,"DIV",{class:!0});var z=v(G);g(Rn.$$.fragment,z),Rr=r(z),Zo=d(z,"P",{"data-svelte-h":!0}),$(Zo)!=="svelte-1plx9t"&&(Zo.innerHTML=im),Zr=r(z),g(bt.$$.fragment,z),Wr=r(z),g(Mt.$$.fragment,z),Cr=r(z),g(yt.$$.fragment,z),Fr=r(z),g(Tt.$$.fragment,z),z.forEach(i),be.forEach(i),Oa=r(e),g(Zn.$$.fragment,e),Ea=r(e),X=d(e,"DIV",{class:!0});var Me=v(X);g(Wn.$$.fragment,Me),Ir=r(Me),Wo=d(Me,"P",{"data-svelte-h":!0}),$(Wo)!=="svelte-1uwjkkt"&&(Wo.textContent=pm),Gr=r(Me),Co=d(Me,"P",{"data-svelte-h":!0}),$(Co)!=="svelte-cle55h"&&(Co.innerHTML=mm),Vr=r(Me),Fo=d(Me,"P",{"data-svelte-h":!0}),$(Fo)!=="svelte-l92blw"&&(Fo.innerHTML=dm),Xr=r(Me),E=d(Me,"DIV",{class:!0});var ye=v(E);g(Cn.$$.fragment,ye),Nr=r(ye),Io=d(ye,"P",{"data-svelte-h":!0}),$(Io)!=="svelte-xk2xch"&&(Io.innerHTML=cm),Sr=r(ye),g(_t.$$.fragment,ye),zr=r(ye),g($t.$$.fragment,ye),Br=r(ye),g(wt.$$.fragment,ye),ye.forEach(i),Me.forEach(i),Ha=r(e),g(Fn.$$.fragment,e),La=r(e),N=d(e,"DIV",{class:!0});var Te=v(N);g(In.$$.fragment,Te),qr=r(Te),Go=d(Te,"P",{"data-svelte-h":!0}),$(Go)!=="svelte-dcahwi"&&(Go.textContent=um),Or=r(Te),Vo=d(Te,"P",{"data-svelte-h":!0}),$(Vo)!=="svelte-cle55h"&&(Vo.innerHTML=gm),Er=r(Te),Xo=d(Te,"P",{"data-svelte-h":!0}),$(Xo)!=="svelte-l92blw"&&(Xo.innerHTML=hm),Hr=r(Te),Re=d(Te,"DIV",{class:!0});var Xe=v(Re);g(Gn.$$.fragment,Xe),Lr=r(Xe),No=d(Xe,"P",{"data-svelte-h":!0}),$(No)!=="svelte-qesv8n"&&(No.innerHTML=fm),Qr=r(Xe),g(vt.$$.fragment,Xe),Yr=r(Xe),g(jt.$$.fragment,Xe),Xe.forEach(i),Te.forEach(i),Qa=r(e),g(Vn.$$.fragment,e),Ya=r(e),se=d(e,"DIV",{class:!0});var Ne=v(se);g(Xn.$$.fragment,Ne),Ar=r(Ne),So=d(Ne,"P",{"data-svelte-h":!0}),$(So)!=="svelte-1q3ks0m"&&(So.innerHTML=bm),Pr=r(Ne),zo=d(Ne,"P",{"data-svelte-h":!0}),$(zo)!=="svelte-l92blw"&&(zo.innerHTML=Mm),Dr=r(Ne),H=d(Ne,"DIV",{class:!0});var _e=v(H);g(Nn.$$.fragment,_e),Kr=r(_e),Bo=d(_e,"P",{"data-svelte-h":!0}),$(Bo)!=="svelte-1dng7rw"&&(Bo.innerHTML=ym),ei=r(_e),g(Jt.$$.fragment,_e),ti=r(_e),g(kt.$$.fragment,_e),ni=r(_e),g(xt.$$.fragment,_e),_e.forEach(i),Ne.forEach(i),Aa=r(e),g(Sn.$$.fragment,e),Pa=r(e),zn=d(e,"P",{"data-svelte-h":!0}),$(zn)!=="svelte-1h2y3wu"&&(zn.textContent=Tm),Da=r(e),g(Bn.$$.fragment,e),Ka=r(e),oe=d(e,"DIV",{class:!0});var Se=v(oe);g(qn.$$.fragment,Se),si=r(Se),qo=d(Se,"P",{"data-svelte-h":!0}),$(qo)!=="svelte-5cd34a"&&(qo.innerHTML=_m),oi=r(Se),Oo=d(Se,"P",{"data-svelte-h":!0}),$(Oo)!=="svelte-l92blw"&&(Oo.innerHTML=$m),ai=r(Se),L=d(Se,"DIV",{class:!0});var $e=v(L);g(On.$$.fragment,$e),li=r($e),Eo=d($e,"P",{"data-svelte-h":!0}),$(Eo)!=="svelte-1azuqx"&&(Eo.innerHTML=wm),ri=r($e),g(Ut.$$.fragment,$e),ii=r($e),g(Rt.$$.fragment,$e),pi=r($e),g(Zt.$$.fragment,$e),$e.forEach(i),Se.forEach(i),el=r(e),g(En.$$.fragment,e),tl=r(e),ae=d(e,"DIV",{class:!0});var ze=v(ae);g(Hn.$$.fragment,ze),mi=r(ze),Ho=d(ze,"P",{"data-svelte-h":!0}),$(Ho)!=="svelte-1agyym4"&&(Ho.innerHTML=vm),di=r(ze),Lo=d(ze,"P",{"data-svelte-h":!0}),$(Lo)!=="svelte-l92blw"&&(Lo.innerHTML=jm),ci=r(ze),Q=d(ze,"DIV",{class:!0});var we=v(Q);g(Ln.$$.fragment,we),ui=r(we),Qo=d(we,"P",{"data-svelte-h":!0}),$(Qo)!=="svelte-1s27jle"&&(Qo.innerHTML=Jm),gi=r(we),g(Wt.$$.fragment,we),hi=r(we),g(Ct.$$.fragment,we),fi=r(we),g(Ft.$$.fragment,we),we.forEach(i),ze.forEach(i),nl=r(e),g(Qn.$$.fragment,e),sl=r(e),Yn=d(e,"P",{"data-svelte-h":!0}),$(Yn)!=="svelte-liyjdz"&&(Yn.textContent=km),ol=r(e),g(An.$$.fragment,e),al=r(e),S=d(e,"DIV",{class:!0});var ve=v(S);g(Pn.$$.fragment,ve),bi=r(ve),Yo=d(ve,"P",{"data-svelte-h":!0}),$(Yo)!=="svelte-1uwrr47"&&(Yo.textContent=xm),Mi=r(ve),Ao=d(ve,"P",{"data-svelte-h":!0}),$(Ao)!=="svelte-cle55h"&&(Ao.innerHTML=Um),yi=r(ve),Po=d(ve,"P",{"data-svelte-h":!0}),$(Po)!=="svelte-l92blw"&&(Po.innerHTML=Rm),Ti=r(ve),Y=d(ve,"DIV",{class:!0});var je=v(Y);g(Dn.$$.fragment,je),_i=r(je),Do=d(je,"P",{"data-svelte-h":!0}),$(Do)!=="svelte-p67kxo"&&(Do.innerHTML=Zm),$i=r(je),g(It.$$.fragment,je),wi=r(je),g(Gt.$$.fragment,je),vi=r(je),g(Vt.$$.fragment,je),je.forEach(i),ve.forEach(i),ll=r(e),g(Kn.$$.fragment,e),rl=r(e),le=d(e,"DIV",{class:!0});var Be=v(le);g(es.$$.fragment,Be),ji=r(Be),Ko=d(Be,"P",{"data-svelte-h":!0}),$(Ko)!=="svelte-mtth25"&&(Ko.innerHTML=Wm),Ji=r(Be),ea=d(Be,"P",{"data-svelte-h":!0}),$(ea)!=="svelte-l92blw"&&(ea.innerHTML=Cm),ki=r(Be),Ze=d(Be,"DIV",{class:!0});var qe=v(Ze);g(ts.$$.fragment,qe),xi=r(qe),ta=d(qe,"P",{"data-svelte-h":!0}),$(ta)!=="svelte-18aced7"&&(ta.innerHTML=Fm),Ui=r(qe),g(Xt.$$.fragment,qe),Ri=r(qe),g(Nt.$$.fragment,qe),qe.forEach(i),Be.forEach(i),il=r(e),g(ns.$$.fragment,e),pl=r(e),re=d(e,"DIV",{class:!0});var Oe=v(re);g(ss.$$.fragment,Oe),Zi=r(Oe),na=d(Oe,"P",{"data-svelte-h":!0}),$(na)!=="svelte-1ikc0s5"&&(na.innerHTML=Im),Wi=r(Oe),sa=d(Oe,"P",{"data-svelte-h":!0}),$(sa)!=="svelte-l92blw"&&(sa.innerHTML=Gm),Ci=r(Oe),We=d(Oe,"DIV",{class:!0});var Ee=v(We);g(os.$$.fragment,Ee),Fi=r(Ee),oa=d(Ee,"P",{"data-svelte-h":!0}),$(oa)!=="svelte-1szjv6u"&&(oa.innerHTML=Vm),Ii=r(Ee),g(St.$$.fragment,Ee),Gi=r(Ee),g(zt.$$.fragment,Ee),Ee.forEach(i),Oe.forEach(i),ml=r(e),g(as.$$.fragment,e),dl=r(e),ie=d(e,"DIV",{class:!0});var He=v(ie);g(ls.$$.fragment,He),Vi=r(He),aa=d(He,"P",{"data-svelte-h":!0}),$(aa)!=="svelte-1ermegf"&&(aa.innerHTML=Xm),Xi=r(He),la=d(He,"P",{"data-svelte-h":!0}),$(la)!=="svelte-10uuk2l"&&(la.innerHTML=Nm),Ni=r(He),A=d(He,"DIV",{class:!0});var Je=v(A);g(rs.$$.fragment,Je),Si=r(Je),ra=d(Je,"P",{"data-svelte-h":!0}),$(ra)!=="svelte-1e3zkhy"&&(ra.innerHTML=Sm),zi=r(Je),g(Bt.$$.fragment,Je),Bi=r(Je),g(qt.$$.fragment,Je),qi=r(Je),g(Ot.$$.fragment,Je),Je.forEach(i),He.forEach(i),cl=r(e),g(is.$$.fragment,e),ul=r(e),pe=d(e,"DIV",{class:!0});var Le=v(pe);g(ps.$$.fragment,Le),Oi=r(Le),ia=d(Le,"P",{"data-svelte-h":!0}),$(ia)!=="svelte-1fue2r1"&&(ia.innerHTML=zm),Ei=r(Le),pa=d(Le,"P",{"data-svelte-h":!0}),$(pa)!=="svelte-l92blw"&&(pa.innerHTML=Bm),Hi=r(Le),Ce=d(Le,"DIV",{class:!0});var Qe=v(Ce);g(ms.$$.fragment,Qe),Li=r(Qe),ma=d(Qe,"P",{"data-svelte-h":!0}),$(ma)!=="svelte-1fuxgrl"&&(ma.innerHTML=qm),Qi=r(Qe),g(Et.$$.fragment,Qe),Yi=r(Qe),g(Ht.$$.fragment,Qe),Qe.forEach(i),Le.forEach(i),gl=r(e),g(ds.$$.fragment,e),hl=r(e),cs=d(e,"P",{"data-svelte-h":!0}),$(cs)!=="svelte-1gk58z"&&(cs.textContent=Om),fl=r(e),g(us.$$.fragment,e),bl=r(e),me=d(e,"DIV",{class:!0});var Ye=v(me);g(gs.$$.fragment,Ye),Ai=r(Ye),da=d(Ye,"P",{"data-svelte-h":!0}),$(da)!=="svelte-1yey1ie"&&(da.innerHTML=Em),Pi=r(Ye),ca=d(Ye,"P",{"data-svelte-h":!0}),$(ca)!=="svelte-10uuk2l"&&(ca.innerHTML=Hm),Di=r(Ye),P=d(Ye,"DIV",{class:!0});var ke=v(P);g(hs.$$.fragment,ke),Ki=r(ke),ua=d(ke,"P",{"data-svelte-h":!0}),$(ua)!=="svelte-11xalzp"&&(ua.innerHTML=Lm),ep=r(ke),g(Lt.$$.fragment,ke),tp=r(ke),g(Qt.$$.fragment,ke),np=r(ke),g(Yt.$$.fragment,ke),ke.forEach(i),Ye.forEach(i),Ml=r(e),g(fs.$$.fragment,e),yl=r(e),de=d(e,"DIV",{class:!0});var Ae=v(de);g(bs.$$.fragment,Ae),sp=r(Ae),ga=d(Ae,"P",{"data-svelte-h":!0}),$(ga)!=="svelte-1eubaty"&&(ga.innerHTML=Qm),op=r(Ae),ha=d(Ae,"P",{"data-svelte-h":!0}),$(ha)!=="svelte-10uuk2l"&&(ha.innerHTML=Ym),ap=r(Ae),Fe=d(Ae,"DIV",{class:!0});var Pe=v(Fe);g(Ms.$$.fragment,Pe),lp=r(Pe),fa=d(Pe,"P",{"data-svelte-h":!0}),$(fa)!=="svelte-eywb10"&&(fa.innerHTML=Am),rp=r(Pe),g(At.$$.fragment,Pe),ip=r(Pe),g(Pt.$$.fragment,Pe),Pe.forEach(i),Ae.forEach(i),Tl=r(e),g(ys.$$.fragment,e),_l=r(e),Ts=d(e,"P",{"data-svelte-h":!0}),$(Ts)!=="svelte-1n8n3ms"&&(Ts.textContent=Pm),$l=r(e),g(_s.$$.fragment,e),wl=r(e),ce=d(e,"DIV",{class:!0});var De=v(ce);g($s.$$.fragment,De),pp=r(De),ba=d(De,"P",{"data-svelte-h":!0}),$(ba)!=="svelte-1qykinu"&&(ba.innerHTML=Dm),mp=r(De),Ma=d(De,"P",{"data-svelte-h":!0}),$(Ma)!=="svelte-l92blw"&&(Ma.innerHTML=Km),dp=r(De),D=d(De,"DIV",{class:!0});var xe=v(D);g(ws.$$.fragment,xe),cp=r(xe),ya=d(xe,"P",{"data-svelte-h":!0}),$(ya)!=="svelte-1usnw5b"&&(ya.innerHTML=ed),up=r(xe),g(Dt.$$.fragment,xe),gp=r(xe),g(Kt.$$.fragment,xe),hp=r(xe),g(en.$$.fragment,xe),xe.forEach(i),De.forEach(i),vl=r(e),g(vs.$$.fragment,e),jl=r(e),ue=d(e,"DIV",{class:!0});var Ke=v(ue);g(js.$$.fragment,Ke),fp=r(Ke),Ta=d(Ke,"P",{"data-svelte-h":!0}),$(Ta)!=="svelte-1rizz5l"&&(Ta.innerHTML=td),bp=r(Ke),_a=d(Ke,"P",{"data-svelte-h":!0}),$(_a)!=="svelte-l92blw"&&(_a.innerHTML=nd),Mp=r(Ke),K=d(Ke,"DIV",{class:!0});var Ue=v(K);g(Js.$$.fragment,Ue),yp=r(Ue),$a=d(Ue,"P",{"data-svelte-h":!0}),$($a)!=="svelte-iqwqsz"&&($a.innerHTML=sd),Tp=r(Ue),g(tn.$$.fragment,Ue),_p=r(Ue),g(nn.$$.fragment,Ue),$p=r(Ue),g(sn.$$.fragment,Ue),Ue.forEach(i),Ke.forEach(i),Jl=r(e),g(ks.$$.fragment,e),kl=r(e),g(xs.$$.fragment,e),xl=r(e),et=d(e,"DIV",{class:!0});var As=v(et);g(Us.$$.fragment,As),wp=r(As),on=d(As,"DIV",{class:!0});var Ps=v(on);g(Rs.$$.fragment,Ps),vp=r(Ps),wa=d(Ps,"P",{"data-svelte-h":!0}),$(wa)!=="svelte-1eed40t"&&(wa.textContent=od),Ps.forEach(i),As.forEach(i),Ul=r(e),g(Zs.$$.fragment,e),Rl=r(e),tt=d(e,"DIV",{class:!0});var Ds=v(tt);g(Ws.$$.fragment,Ds),jp=r(Ds),an=d(Ds,"DIV",{class:!0});var Ks=v(an);g(Cs.$$.fragment,Ks),Jp=r(Ks),va=d(Ks,"P",{"data-svelte-h":!0}),$(va)!=="svelte-1eed40t"&&(va.textContent=ad),Ks.forEach(i),Ds.forEach(i),Zl=r(e),g(Fs.$$.fragment,e),Wl=r(e),nt=d(e,"DIV",{class:!0});var eo=v(nt);g(Is.$$.fragment,eo),kp=r(eo),ln=d(eo,"DIV",{class:!0});var to=v(ln);g(Gs.$$.fragment,to),xp=r(to),ja=d(to,"P",{"data-svelte-h":!0}),$(ja)!=="svelte-1eed40t"&&(ja.textContent=ld),to.forEach(i),eo.forEach(i),Cl=r(e),g(Vs.$$.fragment,e),Fl=r(e),st=d(e,"DIV",{class:!0});var no=v(st);g(Xs.$$.fragment,no),Up=r(no),rn=d(no,"DIV",{class:!0});var so=v(rn);g(Ns.$$.fragment,so),Rp=r(so),Ja=d(so,"P",{"data-svelte-h":!0}),$(Ja)!=="svelte-1eed40t"&&(Ja.textContent=rd),so.forEach(i),no.forEach(i),Il=r(e),g(Ss.$$.fragment,e),Gl=r(e),ot=d(e,"DIV",{class:!0});var oo=v(ot);g(zs.$$.fragment,oo),Zp=r(oo),pn=d(oo,"DIV",{class:!0});var ao=v(pn);g(Bs.$$.fragment,ao),Wp=r(ao),ka=d(ao,"P",{"data-svelte-h":!0}),$(ka)!=="svelte-1eed40t"&&(ka.textContent=id),ao.forEach(i),oo.forEach(i),Vl=r(e),g(qs.$$.fragment,e),Xl=r(e),at=d(e,"DIV",{class:!0});var lo=v(at);g(Os.$$.fragment,lo),Cp=r(lo),mn=d(lo,"DIV",{class:!0});var ql=v(mn);g(Es.$$.fragment,ql),Fp=r(ql),xa=d(ql,"P",{"data-svelte-h":!0}),$(xa)!=="svelte-1eed40t"&&(xa.textContent=pd),ql.forEach(i),lo.forEach(i),Nl=r(e),g(Hs.$$.fragment,e),Sl=r(e),lt=d(e,"DIV",{class:!0});var Ol=v(lt);g(Ls.$$.fragment,Ol),Ip=r(Ol),dn=d(Ol,"DIV",{class:!0});var El=v(dn);g(Qs.$$.fragment,El),Gp=r(El),Ua=d(El,"P",{"data-svelte-h":!0}),$(Ua)!=="svelte-1eed40t"&&(Ua.textContent=md),El.forEach(i),Ol.forEach(i),zl=r(e),Ra=d(e,"P",{}),v(Ra).forEach(i),this.h()},h(){j(n,"name","hf:doc:metadata"),j(n,"content",uc),j(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){a(document.head,n),c(e,T,p),c(e,o,p),c(e,s,p),h(y,e,p),c(e,t,p),h(_,e,p),c(e,Za,p),c(e,cn,p),c(e,Wa,p),h(un,e,p),c(e,Ca,p),c(e,Z,p),h(gn,Z,null),a(Z,Hl),a(Z,ro),a(Z,Ll),a(Z,io),a(Z,Ql),a(Z,po),a(Z,Yl),a(Z,mo),a(Z,Al),a(Z,rt),h(hn,rt,null),a(rt,Pl),a(rt,co),a(Z,Dl),a(Z,W),h(fn,W,null),a(W,Kl),a(W,uo),a(W,er),a(W,go),a(W,tr),a(W,ho),a(W,nr),a(W,fo),a(W,sr),a(W,bo),a(W,or),a(W,Mo),c(e,Fa,p),h(bn,e,p),c(e,Ia,p),c(e,Mn,p),c(e,Ga,p),h(yn,e,p),c(e,Va,p),c(e,ee,p),h(Tn,ee,null),a(ee,ar),a(ee,yo),a(ee,lr),a(ee,To),a(ee,rr),a(ee,B),h(_n,B,null),a(B,ir),a(B,_o),a(B,pr),h(it,B,null),a(B,mr),h(pt,B,null),a(B,dr),h(mt,B,null),c(e,Xa,p),h($n,e,p),c(e,Na,p),c(e,te,p),h(wn,te,null),a(te,cr),a(te,$o),a(te,ur),a(te,wo),a(te,gr),a(te,q),h(vn,q,null),a(q,hr),a(q,vo),a(q,fr),h(dt,q,null),a(q,br),h(ct,q,null),a(q,Mr),h(ut,q,null),c(e,Sa,p),h(jn,e,p),c(e,za,p),c(e,ne,p),h(Jn,ne,null),a(ne,yr),a(ne,jo),a(ne,Tr),a(ne,Jo),a(ne,_r),a(ne,O),h(kn,O,null),a(O,$r),a(O,ko),a(O,wr),h(gt,O,null),a(O,vr),h(ht,O,null),a(O,jr),h(ft,O,null),c(e,Ba,p),h(xn,e,p),c(e,qa,p),c(e,V,p),h(Un,V,null),a(V,Jr),a(V,xo),a(V,kr),a(V,Uo),a(V,xr),a(V,Ro),a(V,Ur),a(V,G),h(Rn,G,null),a(G,Rr),a(G,Zo),a(G,Zr),h(bt,G,null),a(G,Wr),h(Mt,G,null),a(G,Cr),h(yt,G,null),a(G,Fr),h(Tt,G,null),c(e,Oa,p),h(Zn,e,p),c(e,Ea,p),c(e,X,p),h(Wn,X,null),a(X,Ir),a(X,Wo),a(X,Gr),a(X,Co),a(X,Vr),a(X,Fo),a(X,Xr),a(X,E),h(Cn,E,null),a(E,Nr),a(E,Io),a(E,Sr),h(_t,E,null),a(E,zr),h($t,E,null),a(E,Br),h(wt,E,null),c(e,Ha,p),h(Fn,e,p),c(e,La,p),c(e,N,p),h(In,N,null),a(N,qr),a(N,Go),a(N,Or),a(N,Vo),a(N,Er),a(N,Xo),a(N,Hr),a(N,Re),h(Gn,Re,null),a(Re,Lr),a(Re,No),a(Re,Qr),h(vt,Re,null),a(Re,Yr),h(jt,Re,null),c(e,Qa,p),h(Vn,e,p),c(e,Ya,p),c(e,se,p),h(Xn,se,null),a(se,Ar),a(se,So),a(se,Pr),a(se,zo),a(se,Dr),a(se,H),h(Nn,H,null),a(H,Kr),a(H,Bo),a(H,ei),h(Jt,H,null),a(H,ti),h(kt,H,null),a(H,ni),h(xt,H,null),c(e,Aa,p),h(Sn,e,p),c(e,Pa,p),c(e,zn,p),c(e,Da,p),h(Bn,e,p),c(e,Ka,p),c(e,oe,p),h(qn,oe,null),a(oe,si),a(oe,qo),a(oe,oi),a(oe,Oo),a(oe,ai),a(oe,L),h(On,L,null),a(L,li),a(L,Eo),a(L,ri),h(Ut,L,null),a(L,ii),h(Rt,L,null),a(L,pi),h(Zt,L,null),c(e,el,p),h(En,e,p),c(e,tl,p),c(e,ae,p),h(Hn,ae,null),a(ae,mi),a(ae,Ho),a(ae,di),a(ae,Lo),a(ae,ci),a(ae,Q),h(Ln,Q,null),a(Q,ui),a(Q,Qo),a(Q,gi),h(Wt,Q,null),a(Q,hi),h(Ct,Q,null),a(Q,fi),h(Ft,Q,null),c(e,nl,p),h(Qn,e,p),c(e,sl,p),c(e,Yn,p),c(e,ol,p),h(An,e,p),c(e,al,p),c(e,S,p),h(Pn,S,null),a(S,bi),a(S,Yo),a(S,Mi),a(S,Ao),a(S,yi),a(S,Po),a(S,Ti),a(S,Y),h(Dn,Y,null),a(Y,_i),a(Y,Do),a(Y,$i),h(It,Y,null),a(Y,wi),h(Gt,Y,null),a(Y,vi),h(Vt,Y,null),c(e,ll,p),h(Kn,e,p),c(e,rl,p),c(e,le,p),h(es,le,null),a(le,ji),a(le,Ko),a(le,Ji),a(le,ea),a(le,ki),a(le,Ze),h(ts,Ze,null),a(Ze,xi),a(Ze,ta),a(Ze,Ui),h(Xt,Ze,null),a(Ze,Ri),h(Nt,Ze,null),c(e,il,p),h(ns,e,p),c(e,pl,p),c(e,re,p),h(ss,re,null),a(re,Zi),a(re,na),a(re,Wi),a(re,sa),a(re,Ci),a(re,We),h(os,We,null),a(We,Fi),a(We,oa),a(We,Ii),h(St,We,null),a(We,Gi),h(zt,We,null),c(e,ml,p),h(as,e,p),c(e,dl,p),c(e,ie,p),h(ls,ie,null),a(ie,Vi),a(ie,aa),a(ie,Xi),a(ie,la),a(ie,Ni),a(ie,A),h(rs,A,null),a(A,Si),a(A,ra),a(A,zi),h(Bt,A,null),a(A,Bi),h(qt,A,null),a(A,qi),h(Ot,A,null),c(e,cl,p),h(is,e,p),c(e,ul,p),c(e,pe,p),h(ps,pe,null),a(pe,Oi),a(pe,ia),a(pe,Ei),a(pe,pa),a(pe,Hi),a(pe,Ce),h(ms,Ce,null),a(Ce,Li),a(Ce,ma),a(Ce,Qi),h(Et,Ce,null),a(Ce,Yi),h(Ht,Ce,null),c(e,gl,p),h(ds,e,p),c(e,hl,p),c(e,cs,p),c(e,fl,p),h(us,e,p),c(e,bl,p),c(e,me,p),h(gs,me,null),a(me,Ai),a(me,da),a(me,Pi),a(me,ca),a(me,Di),a(me,P),h(hs,P,null),a(P,Ki),a(P,ua),a(P,ep),h(Lt,P,null),a(P,tp),h(Qt,P,null),a(P,np),h(Yt,P,null),c(e,Ml,p),h(fs,e,p),c(e,yl,p),c(e,de,p),h(bs,de,null),a(de,sp),a(de,ga),a(de,op),a(de,ha),a(de,ap),a(de,Fe),h(Ms,Fe,null),a(Fe,lp),a(Fe,fa),a(Fe,rp),h(At,Fe,null),a(Fe,ip),h(Pt,Fe,null),c(e,Tl,p),h(ys,e,p),c(e,_l,p),c(e,Ts,p),c(e,$l,p),h(_s,e,p),c(e,wl,p),c(e,ce,p),h($s,ce,null),a(ce,pp),a(ce,ba),a(ce,mp),a(ce,Ma),a(ce,dp),a(ce,D),h(ws,D,null),a(D,cp),a(D,ya),a(D,up),h(Dt,D,null),a(D,gp),h(Kt,D,null),a(D,hp),h(en,D,null),c(e,vl,p),h(vs,e,p),c(e,jl,p),c(e,ue,p),h(js,ue,null),a(ue,fp),a(ue,Ta),a(ue,bp),a(ue,_a),a(ue,Mp),a(ue,K),h(Js,K,null),a(K,yp),a(K,$a),a(K,Tp),h(tn,K,null),a(K,_p),h(nn,K,null),a(K,$p),h(sn,K,null),c(e,Jl,p),h(ks,e,p),c(e,kl,p),h(xs,e,p),c(e,xl,p),c(e,et,p),h(Us,et,null),a(et,wp),a(et,on),h(Rs,on,null),a(on,vp),a(on,wa),c(e,Ul,p),h(Zs,e,p),c(e,Rl,p),c(e,tt,p),h(Ws,tt,null),a(tt,jp),a(tt,an),h(Cs,an,null),a(an,Jp),a(an,va),c(e,Zl,p),h(Fs,e,p),c(e,Wl,p),c(e,nt,p),h(Is,nt,null),a(nt,kp),a(nt,ln),h(Gs,ln,null),a(ln,xp),a(ln,ja),c(e,Cl,p),h(Vs,e,p),c(e,Fl,p),c(e,st,p),h(Xs,st,null),a(st,Up),a(st,rn),h(Ns,rn,null),a(rn,Rp),a(rn,Ja),c(e,Il,p),h(Ss,e,p),c(e,Gl,p),c(e,ot,p),h(zs,ot,null),a(ot,Zp),a(ot,pn),h(Bs,pn,null),a(pn,Wp),a(pn,ka),c(e,Vl,p),h(qs,e,p),c(e,Xl,p),c(e,at,p),h(Os,at,null),a(at,Cp),a(at,mn),h(Es,mn,null),a(mn,Fp),a(mn,xa),c(e,Nl,p),h(Hs,e,p),c(e,Sl,p),c(e,lt,p),h(Ls,lt,null),a(lt,Ip),a(lt,dn),h(Qs,dn,null),a(dn,Gp),a(dn,Ua),c(e,zl,p),c(e,Ra,p),Bl=!0},p(e,[p]){const F={};p&2&&(F.$$scope={dirty:p,ctx:e}),it.$set(F);const Ys={};p&2&&(Ys.$$scope={dirty:p,ctx:e}),pt.$set(Ys);const I={};p&2&&(I.$$scope={dirty:p,ctx:e}),mt.$set(I);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:e}),dt.$set(Ie);const ge={};p&2&&(ge.$$scope={dirty:p,ctx:e}),ct.$set(ge);const Ge={};p&2&&(Ge.$$scope={dirty:p,ctx:e}),ut.$set(Ge);const he={};p&2&&(he.$$scope={dirty:p,ctx:e}),gt.$set(he);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),ht.$set(Ve);const fe={};p&2&&(fe.$$scope={dirty:p,ctx:e}),ft.$set(fe);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),bt.$set(be);const z={};p&2&&(z.$$scope={dirty:p,ctx:e}),Mt.$set(z);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),yt.$set(Me);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),Tt.$set(ye);const Te={};p&2&&(Te.$$scope={dirty:p,ctx:e}),_t.$set(Te);const Xe={};p&2&&(Xe.$$scope={dirty:p,ctx:e}),$t.$set(Xe);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),wt.$set(Ne);const _e={};p&2&&(_e.$$scope={dirty:p,ctx:e}),vt.$set(_e);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:e}),jt.$set(Se);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),Jt.$set($e);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),kt.$set(ze);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),xt.$set(we);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),Ut.$set(ve);const je={};p&2&&(je.$$scope={dirty:p,ctx:e}),Rt.$set(je);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:e}),Zt.$set(Be);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:e}),Wt.$set(qe);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),Ct.$set(Oe);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:e}),Ft.$set(Ee);const He={};p&2&&(He.$$scope={dirty:p,ctx:e}),It.$set(He);const Je={};p&2&&(Je.$$scope={dirty:p,ctx:e}),Gt.$set(Je);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:e}),Vt.$set(Le);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),Xt.$set(Qe);const Ye={};p&2&&(Ye.$$scope={dirty:p,ctx:e}),Nt.$set(Ye);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),St.$set(ke);const Ae={};p&2&&(Ae.$$scope={dirty:p,ctx:e}),zt.$set(Ae);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:e}),Bt.$set(Pe);const De={};p&2&&(De.$$scope={dirty:p,ctx:e}),qt.$set(De);const xe={};p&2&&(xe.$$scope={dirty:p,ctx:e}),Ot.$set(xe);const Ke={};p&2&&(Ke.$$scope={dirty:p,ctx:e}),Et.$set(Ke);const Ue={};p&2&&(Ue.$$scope={dirty:p,ctx:e}),Ht.$set(Ue);const As={};p&2&&(As.$$scope={dirty:p,ctx:e}),Lt.$set(As);const Ps={};p&2&&(Ps.$$scope={dirty:p,ctx:e}),Qt.$set(Ps);const Ds={};p&2&&(Ds.$$scope={dirty:p,ctx:e}),Yt.$set(Ds);const Ks={};p&2&&(Ks.$$scope={dirty:p,ctx:e}),At.$set(Ks);const eo={};p&2&&(eo.$$scope={dirty:p,ctx:e}),Pt.$set(eo);const to={};p&2&&(to.$$scope={dirty:p,ctx:e}),Dt.$set(to);const no={};p&2&&(no.$$scope={dirty:p,ctx:e}),Kt.$set(no);const so={};p&2&&(so.$$scope={dirty:p,ctx:e}),en.$set(so);const oo={};p&2&&(oo.$$scope={dirty:p,ctx:e}),tn.$set(oo);const ao={};p&2&&(ao.$$scope={dirty:p,ctx:e}),nn.$set(ao);const lo={};p&2&&(lo.$$scope={dirty:p,ctx:e}),sn.$set(lo)},i(e){Bl||(f(y.$$.fragment,e),f(_.$$.fragment,e),f(un.$$.fragment,e),f(gn.$$.fragment,e),f(hn.$$.fragment,e),f(fn.$$.fragment,e),f(bn.$$.fragment,e),f(yn.$$.fragment,e),f(Tn.$$.fragment,e),f(_n.$$.fragment,e),f(it.$$.fragment,e),f(pt.$$.fragment,e),f(mt.$$.fragment,e),f($n.$$.fragment,e),f(wn.$$.fragment,e),f(vn.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(ut.$$.fragment,e),f(jn.$$.fragment,e),f(Jn.$$.fragment,e),f(kn.$$.fragment,e),f(gt.$$.fragment,e),f(ht.$$.fragment,e),f(ft.$$.fragment,e),f(xn.$$.fragment,e),f(Un.$$.fragment,e),f(Rn.$$.fragment,e),f(bt.$$.fragment,e),f(Mt.$$.fragment,e),f(yt.$$.fragment,e),f(Tt.$$.fragment,e),f(Zn.$$.fragment,e),f(Wn.$$.fragment,e),f(Cn.$$.fragment,e),f(_t.$$.fragment,e),f($t.$$.fragment,e),f(wt.$$.fragment,e),f(Fn.$$.fragment,e),f(In.$$.fragment,e),f(Gn.$$.fragment,e),f(vt.$$.fragment,e),f(jt.$$.fragment,e),f(Vn.$$.fragment,e),f(Xn.$$.fragment,e),f(Nn.$$.fragment,e),f(Jt.$$.fragment,e),f(kt.$$.fragment,e),f(xt.$$.fragment,e),f(Sn.$$.fragment,e),f(Bn.$$.fragment,e),f(qn.$$.fragment,e),f(On.$$.fragment,e),f(Ut.$$.fragment,e),f(Rt.$$.fragment,e),f(Zt.$$.fragment,e),f(En.$$.fragment,e),f(Hn.$$.fragment,e),f(Ln.$$.fragment,e),f(Wt.$$.fragment,e),f(Ct.$$.fragment,e),f(Ft.$$.fragment,e),f(Qn.$$.fragment,e),f(An.$$.fragment,e),f(Pn.$$.fragment,e),f(Dn.$$.fragment,e),f(It.$$.fragment,e),f(Gt.$$.fragment,e),f(Vt.$$.fragment,e),f(Kn.$$.fragment,e),f(es.$$.fragment,e),f(ts.$$.fragment,e),f(Xt.$$.fragment,e),f(Nt.$$.fragment,e),f(ns.$$.fragment,e),f(ss.$$.fragment,e),f(os.$$.fragment,e),f(St.$$.fragment,e),f(zt.$$.fragment,e),f(as.$$.fragment,e),f(ls.$$.fragment,e),f(rs.$$.fragment,e),f(Bt.$$.fragment,e),f(qt.$$.fragment,e),f(Ot.$$.fragment,e),f(is.$$.fragment,e),f(ps.$$.fragment,e),f(ms.$$.fragment,e),f(Et.$$.fragment,e),f(Ht.$$.fragment,e),f(ds.$$.fragment,e),f(us.$$.fragment,e),f(gs.$$.fragment,e),f(hs.$$.fragment,e),f(Lt.$$.fragment,e),f(Qt.$$.fragment,e),f(Yt.$$.fragment,e),f(fs.$$.fragment,e),f(bs.$$.fragment,e),f(Ms.$$.fragment,e),f(At.$$.fragment,e),f(Pt.$$.fragment,e),f(ys.$$.fragment,e),f(_s.$$.fragment,e),f($s.$$.fragment,e),f(ws.$$.fragment,e),f(Dt.$$.fragment,e),f(Kt.$$.fragment,e),f(en.$$.fragment,e),f(vs.$$.fragment,e),f(js.$$.fragment,e),f(Js.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(sn.$$.fragment,e),f(ks.$$.fragment,e),f(xs.$$.fragment,e),f(Us.$$.fragment,e),f(Rs.$$.fragment,e),f(Zs.$$.fragment,e),f(Ws.$$.fragment,e),f(Cs.$$.fragment,e),f(Fs.$$.fragment,e),f(Is.$$.fragment,e),f(Gs.$$.fragment,e),f(Vs.$$.fragment,e),f(Xs.$$.fragment,e),f(Ns.$$.fragment,e),f(Ss.$$.fragment,e),f(zs.$$.fragment,e),f(Bs.$$.fragment,e),f(qs.$$.fragment,e),f(Os.$$.fragment,e),f(Es.$$.fragment,e),f(Hs.$$.fragment,e),f(Ls.$$.fragment,e),f(Qs.$$.fragment,e),Bl=!0)},o(e){b(y.$$.fragment,e),b(_.$$.fragment,e),b(un.$$.fragment,e),b(gn.$$.fragment,e),b(hn.$$.fragment,e),b(fn.$$.fragment,e),b(bn.$$.fragment,e),b(yn.$$.fragment,e),b(Tn.$$.fragment,e),b(_n.$$.fragment,e),b(it.$$.fragment,e),b(pt.$$.fragment,e),b(mt.$$.fragment,e),b($n.$$.fragment,e),b(wn.$$.fragment,e),b(vn.$$.fragment,e),b(dt.$$.fragment,e),b(ct.$$.fragment,e),b(ut.$$.fragment,e),b(jn.$$.fragment,e),b(Jn.$$.fragment,e),b(kn.$$.fragment,e),b(gt.$$.fragment,e),b(ht.$$.fragment,e),b(ft.$$.fragment,e),b(xn.$$.fragment,e),b(Un.$$.fragment,e),b(Rn.$$.fragment,e),b(bt.$$.fragment,e),b(Mt.$$.fragment,e),b(yt.$$.fragment,e),b(Tt.$$.fragment,e),b(Zn.$$.fragment,e),b(Wn.$$.fragment,e),b(Cn.$$.fragment,e),b(_t.$$.fragment,e),b($t.$$.fragment,e),b(wt.$$.fragment,e),b(Fn.$$.fragment,e),b(In.$$.fragment,e),b(Gn.$$.fragment,e),b(vt.$$.fragment,e),b(jt.$$.fragment,e),b(Vn.$$.fragment,e),b(Xn.$$.fragment,e),b(Nn.$$.fragment,e),b(Jt.$$.fragment,e),b(kt.$$.fragment,e),b(xt.$$.fragment,e),b(Sn.$$.fragment,e),b(Bn.$$.fragment,e),b(qn.$$.fragment,e),b(On.$$.fragment,e),b(Ut.$$.fragment,e),b(Rt.$$.fragment,e),b(Zt.$$.fragment,e),b(En.$$.fragment,e),b(Hn.$$.fragment,e),b(Ln.$$.fragment,e),b(Wt.$$.fragment,e),b(Ct.$$.fragment,e),b(Ft.$$.fragment,e),b(Qn.$$.fragment,e),b(An.$$.fragment,e),b(Pn.$$.fragment,e),b(Dn.$$.fragment,e),b(It.$$.fragment,e),b(Gt.$$.fragment,e),b(Vt.$$.fragment,e),b(Kn.$$.fragment,e),b(es.$$.fragment,e),b(ts.$$.fragment,e),b(Xt.$$.fragment,e),b(Nt.$$.fragment,e),b(ns.$$.fragment,e),b(ss.$$.fragment,e),b(os.$$.fragment,e),b(St.$$.fragment,e),b(zt.$$.fragment,e),b(as.$$.fragment,e),b(ls.$$.fragment,e),b(rs.$$.fragment,e),b(Bt.$$.fragment,e),b(qt.$$.fragment,e),b(Ot.$$.fragment,e),b(is.$$.fragment,e),b(ps.$$.fragment,e),b(ms.$$.fragment,e),b(Et.$$.fragment,e),b(Ht.$$.fragment,e),b(ds.$$.fragment,e),b(us.$$.fragment,e),b(gs.$$.fragment,e),b(hs.$$.fragment,e),b(Lt.$$.fragment,e),b(Qt.$$.fragment,e),b(Yt.$$.fragment,e),b(fs.$$.fragment,e),b(bs.$$.fragment,e),b(Ms.$$.fragment,e),b(At.$$.fragment,e),b(Pt.$$.fragment,e),b(ys.$$.fragment,e),b(_s.$$.fragment,e),b($s.$$.fragment,e),b(ws.$$.fragment,e),b(Dt.$$.fragment,e),b(Kt.$$.fragment,e),b(en.$$.fragment,e),b(vs.$$.fragment,e),b(js.$$.fragment,e),b(Js.$$.fragment,e),b(tn.$$.fragment,e),b(nn.$$.fragment,e),b(sn.$$.fragment,e),b(ks.$$.fragment,e),b(xs.$$.fragment,e),b(Us.$$.fragment,e),b(Rs.$$.fragment,e),b(Zs.$$.fragment,e),b(Ws.$$.fragment,e),b(Cs.$$.fragment,e),b(Fs.$$.fragment,e),b(Is.$$.fragment,e),b(Gs.$$.fragment,e),b(Vs.$$.fragment,e),b(Xs.$$.fragment,e),b(Ns.$$.fragment,e),b(Ss.$$.fragment,e),b(zs.$$.fragment,e),b(Bs.$$.fragment,e),b(qs.$$.fragment,e),b(Os.$$.fragment,e),b(Es.$$.fragment,e),b(Hs.$$.fragment,e),b(Ls.$$.fragment,e),b(Qs.$$.fragment,e),Bl=!1},d(e){e&&(i(T),i(o),i(s),i(t),i(Za),i(cn),i(Wa),i(Ca),i(Z),i(Fa),i(Ia),i(Mn),i(Ga),i(Va),i(ee),i(Xa),i(Na),i(te),i(Sa),i(za),i(ne),i(Ba),i(qa),i(V),i(Oa),i(Ea),i(X),i(Ha),i(La),i(N),i(Qa),i(Ya),i(se),i(Aa),i(Pa),i(zn),i(Da),i(Ka),i(oe),i(el),i(tl),i(ae),i(nl),i(sl),i(Yn),i(ol),i(al),i(S),i(ll),i(rl),i(le),i(il),i(pl),i(re),i(ml),i(dl),i(ie),i(cl),i(ul),i(pe),i(gl),i(hl),i(cs),i(fl),i(bl),i(me),i(Ml),i(yl),i(de),i(Tl),i(_l),i(Ts),i($l),i(wl),i(ce),i(vl),i(jl),i(ue),i(Jl),i(kl),i(xl),i(et),i(Ul),i(Rl),i(tt),i(Zl),i(Wl),i(nt),i(Cl),i(Fl),i(st),i(Il),i(Gl),i(ot),i(Vl),i(Xl),i(at),i(Nl),i(Sl),i(lt),i(zl),i(Ra)),i(n),M(y,e),M(_,e),M(un,e),M(gn),M(hn),M(fn),M(bn,e),M(yn,e),M(Tn),M(_n),M(it),M(pt),M(mt),M($n,e),M(wn),M(vn),M(dt),M(ct),M(ut),M(jn,e),M(Jn),M(kn),M(gt),M(ht),M(ft),M(xn,e),M(Un),M(Rn),M(bt),M(Mt),M(yt),M(Tt),M(Zn,e),M(Wn),M(Cn),M(_t),M($t),M(wt),M(Fn,e),M(In),M(Gn),M(vt),M(jt),M(Vn,e),M(Xn),M(Nn),M(Jt),M(kt),M(xt),M(Sn,e),M(Bn,e),M(qn),M(On),M(Ut),M(Rt),M(Zt),M(En,e),M(Hn),M(Ln),M(Wt),M(Ct),M(Ft),M(Qn,e),M(An,e),M(Pn),M(Dn),M(It),M(Gt),M(Vt),M(Kn,e),M(es),M(ts),M(Xt),M(Nt),M(ns,e),M(ss),M(os),M(St),M(zt),M(as,e),M(ls),M(rs),M(Bt),M(qt),M(Ot),M(is,e),M(ps),M(ms),M(Et),M(Ht),M(ds,e),M(us,e),M(gs),M(hs),M(Lt),M(Qt),M(Yt),M(fs,e),M(bs),M(Ms),M(At),M(Pt),M(ys,e),M(_s,e),M($s),M(ws),M(Dt),M(Kt),M(en),M(vs,e),M(js),M(Js),M(tn),M(nn),M(sn),M(ks,e),M(xs,e),M(Us),M(Rs),M(Zs,e),M(Ws),M(Cs),M(Fs,e),M(Is),M(Gs),M(Vs,e),M(Xs),M(Ns),M(Ss,e),M(zs),M(Bs),M(qs,e),M(Os),M(Es),M(Hs,e),M(Ls),M(Qs)}}}const uc='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function gc(w){return cd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $c extends ud{constructor(n){super(),gd(this,n,gc,cc,dd,{})}}export{$c as component};
