import{s as Ey,n as fy,o as vy}from"../chunks/scheduler.f6b352c8.js";import{S as Gy,i as Wy,g as i,s as n,r as e,A as Vy,h as T,f as a,c as t,j as Ny,u as y,x as c,k as Ry,y as gy,a as M,v as J,d as p,t as j,w as o}from"../chunks/index.b90df637.js";import{C as w}from"../chunks/CodeBlock.e5718f9d.js";import{H as U,E as Xy}from"../chunks/getInferenceSnippets.1e3ae0bf.js";function ky(ee){let r,ka,ga,Qa,I,Ya,m,ye="This tutorial will teach you how to use RobotProcessor, a powerful pipeline system for preprocessing robot observations and postprocessing actions. You’ll learn how to create modular, composable data transformations that make your robot learning pipelines more maintainable and reproducible.",Sa,C,Je="<strong>You’ll learn:</strong>",za,d,pe="<li>What RobotProcessor is and why it’s better than alternatives</li> <li>How to create and compose processor steps</li> <li>How to save, load, and share your processors</li> <li>Advanced features for debugging and customization</li>",Fa,u,_a,b,je="Before diving into code, let’s understand the real problems RobotProcessor solves. If you’ve worked with robots and learned policies, you’ve likely encountered these challenges:",Ha,h,qa,A,oe="Your environment might output observations with keys like <code>&quot;rgb_camera_front&quot;</code> and <code>&quot;joint_positions&quot;</code>, but your pre-trained policy expects <code>&quot;observation.images.wrist&quot;</code> and <code>&quot;observation.state&quot;</code>. You need to rename these keys consistently across your pipeline.",$a,B,xa,Z,ie="Your robot’s camera captures 1920x1080 RGB images, but your policy was trained on 224x224 cropped images focusing on the workspace. You need to:",Ka,N,Te="<li>Crop out the relevant workspace area</li> <li>Resize to the expected dimensions</li> <li>Convert from uint8 [0,255] to float32 [0,1]</li> <li>Ensure the right channel ordering (HWC vs CHW)</li> <li>Move everything to GPU efficiently</li>",La,R,Da,E,ce="Your policy outputs desired end-effector positions in Cartesian space, but your robot expects joint angles. You need to:",Pa,f,Ue="<li>Apply inverse kinematics to convert positions to joint angles</li> <li>Handle singularities and out-of-reach positions</li> <li>Smooth the resulting trajectories to avoid jerky movements</li> <li>Clip values to respect joint limits</li>",Oa,v,lM,G,we="Your environment provides joint positions, but your policy also needs velocities and accelerations. You need to:",sM,W,re="<li>Calculate velocities from position differences</li> <li>Maintain a buffer of past states</li> <li>Handle episode boundaries correctly</li>",aM,V,MM,g,Ie="You want to deploy the same policy on different robots with varying:",nM,X,me="<li>Camera setups (different resolutions, positions)</li> <li>Joint configurations (6-DOF vs 7-DOF arms)</li> <li>Control frequencies (10Hz vs 30Hz)</li> <li>Safety limits and workspace boundaries</li>",tM,k,eM,Q,Ce="During data collection, you need to:",yM,Y,de="<li>Record raw sensor data for dataset creation</li> <li>Apply the same preprocessing as during deployment</li> <li>Ensure reproducibility across different operators</li> <li>Share preprocessing configurations with collaborators</li>",JM,S,ue="RobotProcessor solves all these problems by providing a modular, composable system where each transformation is a separate, shareable component. Let’s see how.",pM,z,jM,F,be="If you’ve worked with robot learning before, you’ve likely written preprocessing code like this:",oM,_,iM,H,he="This approach has several problems:",TM,q,Ae="<li><strong>Mixed concerns</strong>: Image processing, tensor conversion, device management all in one function</li> <li><strong>Hard to test</strong>: Can’t test image processing separately from state processing</li> <li><strong>Device management scattered</strong>: Easy to forget <code>.to(device)</code> calls</li> <li><strong>No standardized format</strong>: Each project reinvents the wheel</li> <li><strong>Difficult to share</strong>: Can’t easily reuse this preprocessing in other projects</li>",cM,$,Be="RobotProcessor solves these issues by providing a declarative pipeline approach where each transformation is a separate, testable, shareable component.",UM,x,wM,K,Ze="RobotProcessor works with two data formats:",rM,L,IM,D,Ne="An <code>EnvTransition</code> is a dictionary that represents a complete transition in the environment:",mM,P,CM,O,dM,ll,Re="This is the format used by LeRobot datasets and replay buffers:",uM,sl,bM,al,hM,Ml,Ee="RobotProcessor automatically handles both formats:",AM,nl,BM,tl,ZM,el,fe="Use the <code>TransitionKey</code> enum to access dictionary elements:",NM,yl,RM,Jl,EM,pl,ve="RobotProcessor uses these default conversion functions:",fM,jl,vM,ol,GM,il,Ge="You can customize how RobotProcessor converts between formats:",WM,Tl,VM,cl,gM,Ul,We="The <code>to_output</code> function determines what format is returned when you call the processor with a batch dictionary. Sometimes you want to output <code>EnvTransition</code> dictionaries even when you input batch dictionaries:",XM,wl,kM,rl,QM,Il,Ve="This is particularly useful for environment interaction where you want consistent dictionary output:",YM,ml,SM,Cl,zM,dl,ge="<strong>Use EnvTransition dictionary output when:</strong>",FM,ul,Xe="<li>Environment interaction and real-time control</li> <li>You need to access individual transition components frequently</li> <li>Working with gym environments that expect structured data</li> <li>You need the flexibility of dictionary operations</li>",_M,bl,ke="<strong>Use batch dictionary output when:</strong>",HM,hl,Qe="<li>Training with LeRobot datasets</li> <li>Working with DataLoaders and batched processing</li> <li>Interfacing with existing LeRobot training code</li> <li>You need the standardized “next.*” key format</li>",qM,Al,$M,Bl,xM,Zl,Ye="The default conversion uses “next.*” prefixes because this matches the standard format used by LeRobot datasets and follows the convention that rewards, done flags, and truncated flags are the result of taking an action (i.e., they come from the “next” state):",KM,Nl,LM,Rl,DM,El,Se="Let’s create a processor that properly handles image and state preprocessing:",PM,fl,OM,vl,ln,Gl,ze="RobotProcessor seamlessly works with LeRobot’s batch dictionary format:",sn,Wl,an,Vl,Mn,gl,Fe="RobotProcessor works great with replay buffers for online learning:",nn,Xl,tn,kl,en,Ql,_e="A processor step must follow certain conventions. Let’s create a complete example that shows all required and optional methods:",yn,Yl,Jn,Sl,pn,zl,He="These two methods serve different purposes and it’s crucial to use them correctly:",jn,Fl,on,_l,Tn,Hl,qe="The <code>complementary_data</code> field is perfect for passing information between steps without polluting the info dictionary:",cn,ql,Un,$l,wn,xl,$e="One of the most powerful features of RobotProcessor is the ability to override step configurations when loading from saved checkpoints. This is particularly useful for handling non-serializable objects like environment instances, database connections, or hardware interfaces that can’t be saved to JSON.",rn,Kl,In,Ll,xe="Imagine you have a processor step that needs a live gym environment:",mn,Dl,Cn,Pl,Ke="If you try to save and load this processor normally, the <code>env</code> parameter will be lost because it can’t be serialized to JSON.",dn,Ol,un,ls,Le="The <code>overrides</code> parameter in <code>from_pretrained()</code> allows you to provide non-serializable objects when loading:",bn,ss,hn,as,An,Ms,De="The <code>overrides</code> parameter is a dictionary where:",Bn,ns,Pe="<li><strong>Keys</strong> are step identifiers (class names for unregistered steps, registry names for registered steps)</li> <li><strong>Values</strong> are dictionaries of parameter overrides that get merged with saved configurations</li>",Zn,ts,Nn,es,Oe="The loading process:",Rn,ys,ly="<li>Load saved configuration from JSON</li> <li>For each step, check if overrides exist for that step</li> <li>Merge override parameters with saved parameters (overrides take precedence)</li> <li>Instantiate the step with merged configuration</li> <li>Load any saved tensor state</li>",En,Js,fn,ps,vn,js,Gn,os,Wn,is,Vn,Ts,gn,cs,Xn,Us,kn,ws,sy="The override system uses exact string matching:",Qn,rs,Yn,Is,ay="Use the registry name (the string passed to <code>@ProcessorStepRegistry.register()</code>):",Sn,ms,zn,Cs,Fn,ds,My="Use the exact class name:",_n,us,Hn,bs,qn,hs,ny="The override system provides helpful error messages:",$n,As,xn,Bs,Kn,Zs,Ln,Ns,Dn,Rs,Pn,Es,ty="When you have multiple steps of the same class, all instances get the same override:",On,fs,lt,vs,ey="To override steps individually, use different classes or register with different names:",st,Gs,at,Ws,Mt,Vs,nt,gs,yy="When creating steps that need non-serializable objects, design them with overrides in mind:",tt,Xs,et,ks,yt,Qs,Jy="Register steps with descriptive names to make overrides clearer:",Jt,Ys,pt,Ss,jt,zs,py="Include clear documentation about what overrides are needed:",ot,Fs,it,_s,Tt,Hs,jy="Create configuration helpers for different deployment environments:",ct,qs,Ut,$s,wt,xs,oy="Overrides work seamlessly with Hugging Face Hub sharing:",rt,Ks,It,Ls,iy="This enables sharing of preprocessing logic while allowing each user to provide their own environment-specific dependencies.",mt,Ds,Ct,Ps,Ty="Here’s a complete example showing proper device management and all features:",dt,Os,ut,la,bt,sa,cy="Let’s see how RobotProcessor elegantly solves the scenarios we discussed earlier:",ht,aa,At,Ma,Uy="When your environment and policy speak different “languages”:",Bt,na,Zt,ta,Nt,ea,wy="When you need to crop and resize images to focus on the manipulation workspace:",Rt,ya,Et,Ja,ft,pa,ry="Now you can compose these steps into robot-specific pipelines:",vt,ja,Gt,oa,Iy="The beauty of this approach is that:",Wt,ia,my="<li><strong>Each transformation is tested independently</strong> - The IK solver can be validated separately from image cropping</li> <li><strong>Configurations are shareable</strong> - Other labs can use your exact preprocessing setup</li> <li><strong>Pipelines are composable</strong> - Mix and match steps for different robots</li> <li><strong>Everything is version controlled</strong> - Use Hub revisions to track changes</li>",Vt,Ta,gt,ca,Xt,Ua,kt,wa,Qt,ra,Yt,Ia,St,ma,zt,Ca,Ft,da,_t,ua,Ht,ba,Cy="Here’s how to use RobotProcessor in a real robot control loop, showing both tuple and batch formats:",qt,ha,$t,Aa,xt,Ba,dy="Use the full power of <code>RobotProcessor</code> for debugging:",Kt,Za,Lt,Na,Dt,Ra,uy="RobotProcessor provides a powerful, modular approach to data preprocessing in robotics:",Pt,Ea,by="<li><strong>Dual format support</strong>: Works seamlessly with both EnvTransition dictionaries and batch dictionaries</li> <li><strong>Automatic format conversion</strong>: Converts between dictionary and batch formats as needed</li> <li><strong>LeRobot integration</strong>: Native support for LeRobotDataset and ReplayBuffer formats</li> <li><strong>Clear separation of concerns</strong>: Each transformation is a separate, testable unit</li> <li><strong>Proper state management</strong>: Clear distinction between config (JSON) and state (tensors)</li> <li><strong>Device-aware</strong>: Seamless GPU/CPU transfers with <code>.to(device)</code></li> <li><strong>Inter-step communication</strong>: Use <code>complementary_data</code> for passing information</li> <li><strong>Easy sharing</strong>: Push to Hugging Face Hub for reproducibility</li> <li><strong>Type safety</strong>: Use <code>TransitionKey</code> instead of magic numbers</li> <li><strong>Debugging tools</strong>: Step through transformations and add monitoring hooks</li> <li><strong>Flexible conversion</strong>: Customize <code>to_transition</code> and <code>to_output</code> functions for specific needs</li>",Ot,fa,hy="Key advantages of the dual format approach:",le,va,Ay="<li><strong>Environment interaction</strong>: Use dictionary format for real-time robot control</li> <li><strong>Training/evaluation</strong>: Use batch format for dataset processing and model training</li> <li><strong>Seamless integration</strong>: Same processor works with both formats automatically</li> <li><strong>Backward compatibility</strong>: Existing code using either format continues to work</li> <li><strong>Output format control</strong>: Use <code>to_output</code> to control return format regardless of input format</li> <li><strong>Performance optimization</strong>: Avoid unnecessary format conversions during time-critical operations</li>",se,Ga,By="By following these patterns, your preprocessing code becomes more maintainable, shareable, and robust while being compatible with the entire LeRobot ecosystem.",ae,Wa,Zy='For the full API reference, see the <a href="/api/processor">RobotProcessor API documentation</a>.',Me,Va,ne,Xa,te;return I=new U({props:{title:"RobotProcessor: The Art of Processing Robot Data",local:"robotprocessor-the-art-of-processing-robot-data",headingTag:"h1"}}),u=new U({props:{title:"Real-World Scenarios: When You Need RobotProcessor",local:"real-world-scenarios-when-you-need-robotprocessor",headingTag:"h2"}}),h=new U({props:{title:"Observation Key Mismatches",local:"observation-key-mismatches",headingTag:"h3"}}),B=new U({props:{title:"Image Preprocessing Requirements",local:"image-preprocessing-requirements",headingTag:"h3"}}),R=new U({props:{title:"Coordinate System Transformations",local:"coordinate-system-transformations",headingTag:"h3"}}),v=new U({props:{title:"State Augmentation",local:"state-augmentation",headingTag:"h3"}}),V=new U({props:{title:"Multi-Robot Deployment",local:"multi-robot-deployment",headingTag:"h3"}}),k=new U({props:{title:"Data Collection and Training",local:"data-collection-and-training",headingTag:"h3"}}),z=new U({props:{title:"Why RobotProcessor?",local:"why-robotprocessor",headingTag:"h2"}}),_=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Traditional procedural approach - hard to maintain and share</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_observation</span>(<span class="hljs-params">obs, device=<span class="hljs-string">&#x27;cuda&#x27;</span></span>):
    processed_obs = {}

    <span class="hljs-comment"># Process images</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;pixels&quot;</span> <span class="hljs-keyword">in</span> obs:
        <span class="hljs-keyword">for</span> cam_name, img <span class="hljs-keyword">in</span> obs[<span class="hljs-string">&quot;pixels&quot;</span>].items():
            <span class="hljs-comment"># Convert uint8 [0, 255] to float32 [0, 1]</span>
            img = img.astype(np.float32) / <span class="hljs-number">255.0</span>
            <span class="hljs-comment"># Convert from HWC to CHW format</span>
            img = np.transpose(img, (<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
            <span class="hljs-comment"># Add batch dimension</span>
            img = np.expand_dims(img, axis=<span class="hljs-number">0</span>)
            <span class="hljs-comment"># Convert to torch and move to device</span>
            img = torch.from_numpy(img).to(device)
            <span class="hljs-comment"># Pad to standard size</span>
            <span class="hljs-keyword">if</span> img.shape[-<span class="hljs-number">2</span>:] != (<span class="hljs-number">224</span>, <span class="hljs-number">224</span>):
                img = F.pad(img, (<span class="hljs-number">0</span>, <span class="hljs-number">224</span> - img.shape[-<span class="hljs-number">1</span>], <span class="hljs-number">0</span>, <span class="hljs-number">224</span> - img.shape[-<span class="hljs-number">2</span>]))
            processed_obs[<span class="hljs-string">f&quot;observation.images.<span class="hljs-subst">{cam_name}</span>&quot;</span>] = img

    <span class="hljs-comment"># Process state</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;agent_pos&quot;</span> <span class="hljs-keyword">in</span> obs:
        state = torch.from_numpy(obs[<span class="hljs-string">&quot;agent_pos&quot;</span>]).<span class="hljs-built_in">float</span>()
        state = state.unsqueeze(<span class="hljs-number">0</span>).to(device)
        processed_obs[<span class="hljs-string">&quot;observation.state&quot;</span>] = state

    <span class="hljs-keyword">return</span> processed_obs`,wrap:!1}}),x=new U({props:{title:"Understanding EnvTransition and Batch Format",local:"understanding-envtransition-and-batch-format",headingTag:"h2"}}),L=new U({props:{title:"1. EnvTransition Dictionary Format",local:"1-envtransition-dictionary-format",headingTag:"h3"}}),P=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> TransitionKey

<span class="hljs-comment"># EnvTransition structure:</span>
transition = {
    TransitionKey.OBSERVATION: {<span class="hljs-string">&quot;observation.image&quot;</span>: ..., <span class="hljs-string">&quot;observation.state&quot;</span>: ...},  <span class="hljs-comment"># observation at time t</span>
    TransitionKey.ACTION: [<span class="hljs-number">0.1</span>, -<span class="hljs-number">0.2</span>, <span class="hljs-number">0.3</span>],                                          <span class="hljs-comment"># action taken at time t</span>
    TransitionKey.REWARD: <span class="hljs-number">1.0</span>,                                                       <span class="hljs-comment"># reward received</span>
    TransitionKey.DONE: <span class="hljs-literal">False</span>,                                                       <span class="hljs-comment"># episode done flag</span>
    TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,                                                  <span class="hljs-comment"># episode truncated flag</span>
    TransitionKey.INFO: {<span class="hljs-string">&quot;success&quot;</span>: <span class="hljs-literal">True</span>},                                           <span class="hljs-comment"># additional info from environment</span>
    TransitionKey.COMPLEMENTARY_DATA: {<span class="hljs-string">&quot;step_idx&quot;</span>: <span class="hljs-number">42</span>}                              <span class="hljs-comment"># complementary_data for inter-step communication</span>
}`,wrap:!1}}),O=new U({props:{title:"2. Batch Dictionary Format",local:"2-batch-dictionary-format",headingTag:"h3"}}),sl=new w({props:{code:"JTIzJTIwQmF0Y2glMjBkaWN0aW9uYXJ5JTIwZm9ybWF0JTIwKHVzZWQlMjBieSUyMExlUm9ib3REYXRhc2V0JTJDJTIwUmVwbGF5QnVmZmVyKSUwQWJhdGNoJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uaW1hZ2UlMjIlM0ElMjB0b3JjaC50ZW5zb3IoLi4uKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEltYWdlJTIwb2JzZXJ2YXRpb25zJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uc3RhdGUlMjIlM0ElMjB0b3JjaC50ZW5zb3IoLi4uKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFN0YXRlJTIwb2JzZXJ2YXRpb25zJTBBJTIwJTIwJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwdG9yY2gudGVuc29yKC4uLiklMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBY3Rpb25zJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5yZXdhcmQlMjIlM0ElMjB0b3JjaC50ZW5zb3IoLi4uKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFJld2FyZHMlMEElMjAlMjAlMjAlMjAlMjJuZXh0LmRvbmUlMjIlM0ElMjB0b3JjaC50ZW5zb3IoLi4uKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERvbmUlMjBmbGFncyUwQSUyMCUyMCUyMCUyMCUyMm5leHQudHJ1bmNhdGVkJTIyJTNBJTIwdG9yY2gudGVuc29yKC4uLiklMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUcnVuY2F0ZWQlMjBmbGFncyUwQSUyMCUyMCUyMCUyMCUyMmluZm8lMjIlM0ElMjAlN0IuLi4lN0QlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBJbmZvJTIwZGljdGlvbmFyeSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFkZGl0aW9uYWwlMjBrZXlzJTIwYXJlJTIwcHJlc2VydmVkJTIwYnV0JTIwaWdub3JlZCUyMGR1cmluZyUyMGNvbnZlcnNpb24lMEElN0Q=",highlighted:`<span class="hljs-comment"># Batch dictionary format (used by LeRobotDataset, ReplayBuffer)</span>
batch = {
    <span class="hljs-string">&quot;observation.image&quot;</span>: torch.tensor(...),      <span class="hljs-comment"># Image observations</span>
    <span class="hljs-string">&quot;observation.state&quot;</span>: torch.tensor(...),      <span class="hljs-comment"># State observations</span>
    <span class="hljs-string">&quot;action&quot;</span>: torch.tensor(...),                 <span class="hljs-comment"># Actions</span>
    <span class="hljs-string">&quot;next.reward&quot;</span>: torch.tensor(...),            <span class="hljs-comment"># Rewards</span>
    <span class="hljs-string">&quot;next.done&quot;</span>: torch.tensor(...),              <span class="hljs-comment"># Done flags</span>
    <span class="hljs-string">&quot;next.truncated&quot;</span>: torch.tensor(...),         <span class="hljs-comment"># Truncated flags</span>
    <span class="hljs-string">&quot;info&quot;</span>: {...},                               <span class="hljs-comment"># Info dictionary</span>
    <span class="hljs-comment"># Additional keys are preserved but ignored during conversion</span>
}`,wrap:!1}}),al=new U({props:{title:"Automatic Format Conversion",local:"automatic-format-conversion",headingTag:"h3"}}),nl=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yLnBpcGVsaW5lJTIwaW1wb3J0JTIwUm9ib3RQcm9jZXNzb3IlMEFmcm9tJTIwbGVyb2JvdC5wcm9jZXNzb3Iub2JzZXJ2YXRpb25fcHJvY2Vzc29yJTIwaW1wb3J0JTIwSW1hZ2VQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglNUJJbWFnZVByb2Nlc3NvcigpJTVEKSUwQSUwQSUyMyUyMFdvcmtzJTIwd2l0aCUyMEVudlRyYW5zaXRpb24lMjBkaWN0aW9uYXJpZXMlMEF0cmFuc2l0aW9uJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwVHJhbnNpdGlvbktleS5PQlNFUlZBVElPTiUzQSUyMCU3QiUyMnBpeGVscyUyMiUzQSUyMGltYWdlX2FycmF5JTdEJTJDJTBBJTIwJTIwJTIwJTIwVHJhbnNpdGlvbktleS5BQ1RJT04lM0ElMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwVHJhbnNpdGlvbktleS5SRVdBUkQlM0ElMjAwLjAlMkMlMEElMjAlMjAlMjAlMjBUcmFuc2l0aW9uS2V5LkRPTkUlM0ElMjBGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMFRyYW5zaXRpb25LZXkuVFJVTkNBVEVEJTNBJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjBUcmFuc2l0aW9uS2V5LklORk8lM0ElMjAlN0IlN0QlMkMlMEElMjAlMjAlMjAlMjBUcmFuc2l0aW9uS2V5LkNPTVBMRU1FTlRBUllfREFUQSUzQSUyMCU3QiU3RCUwQSU3RCUwQXByb2Nlc3NlZF90cmFuc2l0aW9uJTIwJTNEJTIwcHJvY2Vzc29yKHRyYW5zaXRpb24pJTIwJTIwJTIzJTIwUmV0dXJucyUyMEVudlRyYW5zaXRpb24lMjBkaWN0aW9uYXJ5JTBBJTBBJTIzJTIwQWxzbyUyMHdvcmtzJTIwd2l0aCUyMGJhdGNoJTIwZGljdGlvbmFyaWVzJTBBYmF0Y2glMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5waXhlbHMlMjIlM0ElMjBpbWFnZV90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjBhY3Rpb25fdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5yZXdhcmQlMjIlM0ElMjByZXdhcmRfdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5kb25lJTIyJTNBJTIwZG9uZV90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJuZXh0LnRydW5jYXRlZCUyMiUzQSUyMHRydW5jYXRlZF90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJpbmZvJTIyJTNBJTIwaW5mb19kaWN0JTBBJTdEJTBBcHJvY2Vzc2VkX2JhdGNoJTIwJTNEJTIwcHJvY2Vzc29yKGJhdGNoKSUyMCUyMCUyMyUyMFJldHVybnMlMjBiYXRjaCUyMGRpY3Rpb25hcnk=",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor
<span class="hljs-keyword">from</span> lerobot.processor.observation_processor <span class="hljs-keyword">import</span> ImageProcessor

processor = RobotProcessor([ImageProcessor()])

<span class="hljs-comment"># Works with EnvTransition dictionaries</span>
transition = {
    TransitionKey.OBSERVATION: {<span class="hljs-string">&quot;pixels&quot;</span>: image_array},
    TransitionKey.ACTION: <span class="hljs-literal">None</span>,
    TransitionKey.REWARD: <span class="hljs-number">0.0</span>,
    TransitionKey.DONE: <span class="hljs-literal">False</span>,
    TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,
    TransitionKey.INFO: {},
    TransitionKey.COMPLEMENTARY_DATA: {}
}
processed_transition = processor(transition)  <span class="hljs-comment"># Returns EnvTransition dictionary</span>

<span class="hljs-comment"># Also works with batch dictionaries</span>
batch = {
    <span class="hljs-string">&quot;observation.pixels&quot;</span>: image_tensor,
    <span class="hljs-string">&quot;action&quot;</span>: action_tensor,
    <span class="hljs-string">&quot;next.reward&quot;</span>: reward_tensor,
    <span class="hljs-string">&quot;next.done&quot;</span>: done_tensor,
    <span class="hljs-string">&quot;next.truncated&quot;</span>: truncated_tensor,
    <span class="hljs-string">&quot;info&quot;</span>: info_dict
}
processed_batch = processor(batch)  <span class="hljs-comment"># Returns batch dictionary</span>`,wrap:!1}}),tl=new U({props:{title:"Using TransitionKey",local:"using-transitionkey",headingTag:"h3"}}),yl=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yLnBpcGVsaW5lJTIwaW1wb3J0JTIwVHJhbnNpdGlvbktleSUwQSUwQSUyMyUyMEdvb2QlMjAtJTIwdXNpbmclMjBUcmFuc2l0aW9uS2V5JTBBb2JzJTIwJTNEJTIwdHJhbnNpdGlvbiU1QlRyYW5zaXRpb25LZXkuT0JTRVJWQVRJT04lNUQlMEFhY3Rpb24lMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbktleS5BQ1RJT04lNUQlMEFyZXdhcmQlMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbktleS5SRVdBUkQlNUQlMEFkb25lJTIwJTNEJTIwdHJhbnNpdGlvbiU1QlRyYW5zaXRpb25LZXkuRE9ORSU1RCUwQXRydW5jYXRlZCUyMCUzRCUyMHRyYW5zaXRpb24lNUJUcmFuc2l0aW9uS2V5LlRSVU5DQVRFRCU1RCUwQWluZm8lMjAlM0QlMjB0cmFuc2l0aW9uJTVCVHJhbnNpdGlvbktleS5JTkZPJTVEJTBBY29tcF9kYXRhJTIwJTNEJTIwdHJhbnNpdGlvbiU1QlRyYW5zaXRpb25LZXkuQ09NUExFTUVOVEFSWV9EQVRBJTVEJTBBJTBBJTIzJTIwQWx0ZXJuYXRpdmUlMjAtJTIwdXNpbmclMjAuZ2V0KCklMjBmb3IlMjBvcHRpb25hbCUyMGFjY2VzcyUwQW9icyUyMCUzRCUyMHRyYW5zaXRpb24uZ2V0KFRyYW5zaXRpb25LZXkuT0JTRVJWQVRJT04pJTBBYWN0aW9uJTIwJTNEJTIwdHJhbnNpdGlvbi5nZXQoVHJhbnNpdGlvbktleS5BQ1RJT04p",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> TransitionKey

<span class="hljs-comment"># Good - using TransitionKey</span>
obs = transition[TransitionKey.OBSERVATION]
action = transition[TransitionKey.ACTION]
reward = transition[TransitionKey.REWARD]
done = transition[TransitionKey.DONE]
truncated = transition[TransitionKey.TRUNCATED]
info = transition[TransitionKey.INFO]
comp_data = transition[TransitionKey.COMPLEMENTARY_DATA]

<span class="hljs-comment"># Alternative - using .get() for optional access</span>
obs = transition.get(TransitionKey.OBSERVATION)
action = transition.get(TransitionKey.ACTION)`,wrap:!1}}),Jl=new U({props:{title:"Default Conversion Functions",local:"default-conversion-functions",headingTag:"h3"}}),jl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_default_batch_to_transition</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-string">&quot;&quot;&quot;Default conversion from batch dict to EnvTransition dictionary.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Extract observation keys (anything starting with &quot;observation.&quot;)</span>
    observation_keys = {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items() <span class="hljs-keyword">if</span> k.startswith(<span class="hljs-string">&quot;observation.&quot;</span>)}
    observation = observation_keys <span class="hljs-keyword">if</span> observation_keys <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>

    <span class="hljs-comment"># Extract padding and task keys for complementary data</span>
    pad_keys = {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items() <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;_is_pad&quot;</span> <span class="hljs-keyword">in</span> k}
    task_key = {<span class="hljs-string">&quot;task&quot;</span>: batch[<span class="hljs-string">&quot;task&quot;</span>]} <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;task&quot;</span> <span class="hljs-keyword">in</span> batch <span class="hljs-keyword">else</span> {}
    complementary_data = {**pad_keys, **task_key} <span class="hljs-keyword">if</span> pad_keys <span class="hljs-keyword">or</span> task_key <span class="hljs-keyword">else</span> {}

    transition = {
        TransitionKey.OBSERVATION: observation,
        TransitionKey.ACTION: batch.get(<span class="hljs-string">&quot;action&quot;</span>),
        TransitionKey.REWARD: batch.get(<span class="hljs-string">&quot;next.reward&quot;</span>, <span class="hljs-number">0.0</span>),
        TransitionKey.DONE: batch.get(<span class="hljs-string">&quot;next.done&quot;</span>, <span class="hljs-literal">False</span>),
        TransitionKey.TRUNCATED: batch.get(<span class="hljs-string">&quot;next.truncated&quot;</span>, <span class="hljs-literal">False</span>),
        TransitionKey.INFO: batch.get(<span class="hljs-string">&quot;info&quot;</span>, {}),
        TransitionKey.COMPLEMENTARY_DATA: complementary_data,
    }
    <span class="hljs-keyword">return</span> transition

<span class="hljs-keyword">def</span> <span class="hljs-title function_">_default_transition_to_batch</span>(<span class="hljs-params">transition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Default conversion from EnvTransition dictionary to batch dict.&quot;&quot;&quot;</span>
    batch = {
        <span class="hljs-string">&quot;action&quot;</span>: transition.get(TransitionKey.ACTION),
        <span class="hljs-string">&quot;next.reward&quot;</span>: transition.get(TransitionKey.REWARD, <span class="hljs-number">0.0</span>),
        <span class="hljs-string">&quot;next.done&quot;</span>: transition.get(TransitionKey.DONE, <span class="hljs-literal">False</span>),
        <span class="hljs-string">&quot;next.truncated&quot;</span>: transition.get(TransitionKey.TRUNCATED, <span class="hljs-literal">False</span>),
        <span class="hljs-string">&quot;info&quot;</span>: transition.get(TransitionKey.INFO, {}),
    }

    <span class="hljs-comment"># Add padding and task data from complementary_data</span>
    complementary_data = transition.get(TransitionKey.COMPLEMENTARY_DATA)
    <span class="hljs-keyword">if</span> complementary_data:
        pad_data = {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> complementary_data.items() <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;_is_pad&quot;</span> <span class="hljs-keyword">in</span> k}
        batch.update(pad_data)
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;task&quot;</span> <span class="hljs-keyword">in</span> complementary_data:
            batch[<span class="hljs-string">&quot;task&quot;</span>] = complementary_data[<span class="hljs-string">&quot;task&quot;</span>]

    <span class="hljs-comment"># Handle observation - flatten dict to observation.* keys if it&#x27;s a dict</span>
    observation = transition.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(observation, <span class="hljs-built_in">dict</span>):
        batch.update(observation)

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ol=new U({props:{title:"Custom Conversion Functions",local:"custom-conversion-functions",headingTag:"h3"}}),Tl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_batch_to_transition</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-string">&quot;&quot;&quot;Custom conversion from batch dict to EnvTransition dictionary.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Extract observation keys (anything starting with &quot;observation.&quot;)</span>
    observation = {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items() <span class="hljs-keyword">if</span> k.startswith(<span class="hljs-string">&quot;observation.&quot;</span>)}

    <span class="hljs-keyword">return</span> {
        TransitionKey.OBSERVATION: observation,
        TransitionKey.ACTION: batch.get(<span class="hljs-string">&quot;action&quot;</span>),
        TransitionKey.REWARD: batch.get(<span class="hljs-string">&quot;reward&quot;</span>, <span class="hljs-number">0.0</span>),  <span class="hljs-comment"># Use &quot;reward&quot; instead of &quot;next.reward&quot;</span>
        TransitionKey.DONE: batch.get(<span class="hljs-string">&quot;done&quot;</span>, <span class="hljs-literal">False</span>),  <span class="hljs-comment"># Use &quot;done&quot; instead of &quot;next.done&quot;</span>
        TransitionKey.TRUNCATED: batch.get(<span class="hljs-string">&quot;truncated&quot;</span>, <span class="hljs-literal">False</span>),
        TransitionKey.INFO: batch.get(<span class="hljs-string">&quot;info&quot;</span>, {}),
        TransitionKey.COMPLEMENTARY_DATA: batch.get(<span class="hljs-string">&quot;complementary_data&quot;</span>, {})
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_transition_to_batch</span>(<span class="hljs-params">transition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Custom conversion from EnvTransition dictionary to batch dict.&quot;&quot;&quot;</span>
    batch = {
        <span class="hljs-string">&quot;action&quot;</span>: transition.get(TransitionKey.ACTION),
        <span class="hljs-string">&quot;reward&quot;</span>: transition.get(TransitionKey.REWARD),        <span class="hljs-comment"># Use &quot;reward&quot; instead of &quot;next.reward&quot;</span>
        <span class="hljs-string">&quot;done&quot;</span>: transition.get(TransitionKey.DONE),            <span class="hljs-comment"># Use &quot;done&quot; instead of &quot;next.done&quot;</span>
        <span class="hljs-string">&quot;truncated&quot;</span>: transition.get(TransitionKey.TRUNCATED),
        <span class="hljs-string">&quot;info&quot;</span>: transition.get(TransitionKey.INFO),
    }

    <span class="hljs-comment"># Flatten observation dict</span>
    obs = transition.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        batch.update(obs)

    <span class="hljs-keyword">return</span> batch

<span class="hljs-comment"># Use custom converters</span>
processor = RobotProcessor(
    steps=[ImageProcessor()],
    to_transition=custom_batch_to_transition,
    to_output=custom_transition_to_batch
)`,wrap:!1}}),cl=new U({props:{title:"Advanced: Controlling Output Format with to_output",local:"advanced-controlling-output-format-with-tooutput",headingTag:"h3"}}),wl=new w({props:{code:"JTIzJTIwSWRlbnRpdHklMjBmdW5jdGlvbiUyMHRvJTIwYWx3YXlzJTIwcmV0dXJuJTIwRW52VHJhbnNpdGlvbiUyMGRpY3Rpb25hcmllcyUwQWRlZiUyMGtlZXBfYXNfdHJhbnNpdGlvbih0cmFuc2l0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFsd2F5cyUyMHJldHVybiUyMEVudlRyYW5zaXRpb24lMjBkaWN0aW9uYXJ5JTIwcmVnYXJkbGVzcyUyMG9mJTIwaW5wdXQlMjBmb3JtYXQuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNpdGlvbiUwQSUwQSUyMyUyMFByb2Nlc3NvciUyMHRoYXQlMjBhbHdheXMlMjBvdXRwdXRzJTIwRW52VHJhbnNpdGlvbiUyMGRpY3Rpb25hcmllcyUwQXByb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHN0ZXBzJTNEJTVCSW1hZ2VQcm9jZXNzb3IoKSUyQyUyMFN0YXRlUHJvY2Vzc29yKCklNUQlMkMlMEElMjAlMjAlMjAlMjB0b19vdXRwdXQlM0RrZWVwX2FzX3RyYW5zaXRpb24lMjAlMjAlMjMlMjBBbHdheXMlMjByZXR1cm4lMjBkaWN0aW9uYXJ5JTIwZm9ybWF0JTBBKSUwQSUwQSUyMyUyMEV2ZW4lMjB3aGVuJTIwY2FsbGVkJTIwd2l0aCUyMGJhdGNoJTIwZGljdCUyQyUyMHJldHVybnMlMjBFbnZUcmFuc2l0aW9uJTIwZGljdGlvbmFyeSUwQWJhdGNoJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uaW1hZ2UlMjIlM0ElMjBpbWFnZV90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjBhY3Rpb25fdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5yZXdhcmQlMjIlM0ElMjByZXdhcmRfdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5kb25lJTIyJTNBJTIwZG9uZV90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJuZXh0LnRydW5jYXRlZCUyMiUzQSUyMHRydW5jYXRlZF90ZW5zb3IlMkMlMEElMjAlMjAlMjAlMjAlMjJpbmZvJTIyJTNBJTIwaW5mb19kaWN0JTBBJTdEJTBBJTBBcmVzdWx0JTIwJTNEJTIwcHJvY2Vzc29yKGJhdGNoKSUyMCUyMCUyMyUyMFJldHVybnMlMjBFbnZUcmFuc2l0aW9uJTIwZGljdGlvbmFyeSUyQyUyMG5vdCUyMGJhdGNoJTIwZGljdCElMEFwcmludCh0eXBlKHJlc3VsdCkpJTIwJTIwJTIzJTIwJTNDY2xhc3MlMjAnZGljdCclM0U=",highlighted:`<span class="hljs-comment"># Identity function to always return EnvTransition dictionaries</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">keep_as_transition</span>(<span class="hljs-params">transition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Always return EnvTransition dictionary regardless of input format.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> transition

<span class="hljs-comment"># Processor that always outputs EnvTransition dictionaries</span>
processor = RobotProcessor(
    steps=[ImageProcessor(), StateProcessor()],
    to_output=keep_as_transition  <span class="hljs-comment"># Always return dictionary format</span>
)

<span class="hljs-comment"># Even when called with batch dict, returns EnvTransition dictionary</span>
batch = {
    <span class="hljs-string">&quot;observation.image&quot;</span>: image_tensor,
    <span class="hljs-string">&quot;action&quot;</span>: action_tensor,
    <span class="hljs-string">&quot;next.reward&quot;</span>: reward_tensor,
    <span class="hljs-string">&quot;next.done&quot;</span>: done_tensor,
    <span class="hljs-string">&quot;next.truncated&quot;</span>: truncated_tensor,
    <span class="hljs-string">&quot;info&quot;</span>: info_dict
}

result = processor(batch)  <span class="hljs-comment"># Returns EnvTransition dictionary, not batch dict!</span>
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(result))  <span class="hljs-comment"># &lt;class &#x27;dict&#x27;&gt;</span>`,wrap:!1}}),rl=new U({props:{title:"Real-World Example: Environment Interaction",local:"real-world-example-environment-interaction",headingTag:"h3"}}),ml=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.observation_processor <span class="hljs-keyword">import</span> VanillaObservationProcessor

<span class="hljs-comment"># Create processor that always outputs EnvTransition for environment interaction</span>
<span class="hljs-comment"># This avoids format conversion overhead during real-time control</span>
env_processor = RobotProcessor(
    [VanillaObservationProcessor()],
    to_transition=<span class="hljs-keyword">lambda</span> x: x,  <span class="hljs-comment"># Pass through - no conversion needed</span>
    to_output=<span class="hljs-keyword">lambda</span> x: x,      <span class="hljs-comment"># Always return EnvTransition dictionary</span>
)

<span class="hljs-comment"># Environment interaction loop</span>
env = make_env()
obs, info = env.reset()

<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
    <span class="hljs-comment"># Create transition - input is already in dictionary format</span>
    transition = {
        TransitionKey.OBSERVATION: obs,
        TransitionKey.ACTION: <span class="hljs-literal">None</span>,
        TransitionKey.REWARD: <span class="hljs-number">0.0</span>,
        TransitionKey.DONE: <span class="hljs-literal">False</span>,
        TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,
        TransitionKey.INFO: info,
        TransitionKey.COMPLEMENTARY_DATA: {<span class="hljs-string">&quot;step&quot;</span>: step}
    }

    <span class="hljs-comment"># Process - output is guaranteed to be EnvTransition dictionary</span>
    processed_transition = env_processor(transition)
    processed_obs = processed_transition[TransitionKey.OBSERVATION]

    <span class="hljs-comment"># Use with policy</span>
    action = policy.select_action(processed_obs)
    obs, reward, done, truncated, info = env.step(action)

    <span class="hljs-keyword">if</span> done <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),Cl=new U({props:{title:"When to Use Different Output Formats",local:"when-to-use-different-output-formats",headingTag:"h3"}}),Al=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># For environment interaction - use dictionary output</span>
env_processor = RobotProcessor(
    steps=[ImageProcessor(), StateProcessor()],
    to_output=<span class="hljs-keyword">lambda</span> x: x  <span class="hljs-comment"># Return EnvTransition dictionary</span>
)

<span class="hljs-comment"># For training - use batch output (default)</span>
train_processor = RobotProcessor(
    steps=[ImageProcessor(), StateProcessor(), NormalizerProcessor(...)],
    <span class="hljs-comment"># to_output defaults to _default_transition_to_batch</span>
)

<span class="hljs-comment"># Training loop</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    processed_batch = train_processor(batch)  <span class="hljs-comment"># Returns batch dict</span>
    loss = model.compute_loss(processed_batch)

<span class="hljs-comment"># Environment loop</span>
<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
    transition = {
        TransitionKey.OBSERVATION: obs,
        TransitionKey.ACTION: <span class="hljs-literal">None</span>,
        TransitionKey.REWARD: <span class="hljs-number">0.0</span>,
        TransitionKey.DONE: <span class="hljs-literal">False</span>,
        TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,
        TransitionKey.INFO: info,
        TransitionKey.COMPLEMENTARY_DATA: {}
    }
    processed_transition = env_processor(transition)  <span class="hljs-comment"># Returns EnvTransition dictionary</span>
    obs = processed_transition[TransitionKey.OBSERVATION]
    action = policy.select_action(obs)`,wrap:!1}}),Bl=new U({props:{title:"Why “next.reward”, “next.done”, “next.truncated”?",local:"why-nextreward-nextdone-nexttruncated",headingTag:"h3"}}),Nl=new w({props:{code:"JTIzJTIwU3RhbmRhcmQlMjBSTCUyMHRyYW5zaXRpb24lMjBmb3JtYXQlMEElMjMlMjAoc190JTJDJTIwYV90JTJDJTIwcl8lN0J0JTJCMSU3RCUyQyUyMGRvbmVfJTdCdCUyQjElN0QlMkMlMjB0cnVuY2F0ZWRfJTdCdCUyQjElN0QpJTBBJTIzJTIwJTIwJTVFJTIwJTIwJTIwJTIwJTIwJTVFJTIwJTIwJTIwJTIwJTIwJTVFJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVFJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVFJTBBJTIzJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTIzJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJCLS0lMjBSZXN1bHQlMjBvZiUyMGFjdGlvbiUyMGFfdCUwQSUyMyUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tJTIwUmVzdWx0JTIwb2YlMjBhY3Rpb24lMjBhX3QlMEElMjMlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMkItLSUyMFJlc3VsdCUyMG9mJTIwYWN0aW9uJTIwYV90JTBBJTIzJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTJCLS0lMjBBY3Rpb24lMjB0YWtlbiUyMGluJTIwc3RhdGUlMjBzX3QlMEElMjMlMjAlMjAlMkItLSUyMFN0YXRlJTIwYXQlMjB0aW1lJTIwdCUwQSUwQWJhdGNoJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24uc3RhdGUlMjIlM0ElMjBzX3QlMkMlMEElMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjBhX3QlMkMlMEElMjAlMjAlMjAlMjAlMjJuZXh0LnJld2FyZCUyMiUzQSUyMHJfJTdCdCUyQjElN0QlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBSZXdhcmQlMjByZWNlaXZlZCUyMGFmdGVyJTIwdGFraW5nJTIwYWN0aW9uJTBBJTIwJTIwJTIwJTIwJTIybmV4dC5kb25lJTIyJTNBJTIwZG9uZV8lN0J0JTJCMSU3RCUyQyUyMCUyMCUyMCUyMCUyMCUyMyUyMERvbmUlMjBmbGFnJTIwYWZ0ZXIlMjB0YWtpbmclMjBhY3Rpb24lMEElMjAlMjAlMjAlMjAlMjJuZXh0LnRydW5jYXRlZCUyMiUzQSUyMHRydW5jYXRlZF8lN0J0JTJCMSU3RCUyQyUyMCUyMCUyMyUyMFRydW5jYXRlZCUyMGZsYWclMjBhZnRlciUyMHRha2luZyUyMGFjdGlvbiUwQSU3RA==",highlighted:`<span class="hljs-comment"># Standard RL transition format</span>
<span class="hljs-comment"># (s_t, a_t, r_{t+1}, done_{t+1}, truncated_{t+1})</span>
<span class="hljs-comment">#  ^     ^     ^        ^           ^</span>
<span class="hljs-comment">#  |     |     |        |           |</span>
<span class="hljs-comment">#  |     |     |        |           +-- Result of action a_t</span>
<span class="hljs-comment">#  |     |     |        +-- Result of action a_t</span>
<span class="hljs-comment">#  |     |     +-- Result of action a_t</span>
<span class="hljs-comment">#  |     +-- Action taken in state s_t</span>
<span class="hljs-comment">#  +-- State at time t</span>

batch = {
    <span class="hljs-string">&quot;observation.state&quot;</span>: s_t,
    <span class="hljs-string">&quot;action&quot;</span>: a_t,
    <span class="hljs-string">&quot;next.reward&quot;</span>: r_{t+<span class="hljs-number">1</span>},      <span class="hljs-comment"># Reward received after taking action</span>
    <span class="hljs-string">&quot;next.done&quot;</span>: done_{t+<span class="hljs-number">1</span>},     <span class="hljs-comment"># Done flag after taking action</span>
    <span class="hljs-string">&quot;next.truncated&quot;</span>: truncated_{t+<span class="hljs-number">1</span>},  <span class="hljs-comment"># Truncated flag after taking action</span>
}`,wrap:!1}}),Rl=new U({props:{title:"Your First RobotProcessor",local:"your-first-robotprocessor",headingTag:"h2"}}),fl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor, TransitionKey
<span class="hljs-keyword">from</span> lerobot.processor.observation_processor <span class="hljs-keyword">import</span> ImageProcessor, StateProcessor
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># Create sample data</span>
observation = {
    <span class="hljs-string">&quot;pixels&quot;</span>: {
        <span class="hljs-string">&quot;camera_front&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, (<span class="hljs-number">480</span>, <span class="hljs-number">640</span>, <span class="hljs-number">3</span>), dtype=np.uint8),
        <span class="hljs-string">&quot;camera_side&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, (<span class="hljs-number">480</span>, <span class="hljs-number">640</span>, <span class="hljs-number">3</span>), dtype=np.uint8)
    },
    <span class="hljs-string">&quot;agent_pos&quot;</span>: np.array([<span class="hljs-number">0.1</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.6</span>, <span class="hljs-number">0.7</span>], dtype=np.float32)
}

<span class="hljs-comment"># Create a full transition</span>
transition = {
    TransitionKey.OBSERVATION: observation,
    TransitionKey.ACTION: <span class="hljs-literal">None</span>,
    TransitionKey.REWARD: <span class="hljs-number">0.0</span>,
    TransitionKey.DONE: <span class="hljs-literal">False</span>,
    TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,
    TransitionKey.INFO: {},
    TransitionKey.COMPLEMENTARY_DATA: {}
}

<span class="hljs-comment"># Create and use the processor</span>
processor = RobotProcessor([
    ImageProcessor(),  <span class="hljs-comment"># Converts uint8[0,255] to float32[0,1], HWC to CHW, adds batch dim</span>
    StateProcessor(),  <span class="hljs-comment"># Converts numpy arrays to torch tensors, adds batch dim</span>
])

processed_transition = processor(transition)
processed_obs = processed_transition[TransitionKey.OBSERVATION]

<span class="hljs-comment"># Check the results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Original keys:&quot;</span>, observation.keys())
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Processed keys:&quot;</span>, processed_obs.keys())
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Image shape:&quot;</span>, processed_obs[<span class="hljs-string">&quot;observation.images.camera_front&quot;</span>].shape)  <span class="hljs-comment"># [1, 3, 480, 640]</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Image dtype:&quot;</span>, processed_obs[<span class="hljs-string">&quot;observation.images.camera_front&quot;</span>].dtype)   <span class="hljs-comment"># torch.float32</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Image range:&quot;</span>, processed_obs[<span class="hljs-string">&quot;observation.images.camera_front&quot;</span>].<span class="hljs-built_in">min</span>().item(),
      <span class="hljs-string">&quot;to&quot;</span>, processed_obs[<span class="hljs-string">&quot;observation.images.camera_front&quot;</span>].<span class="hljs-built_in">max</span>().item())      <span class="hljs-comment"># 0.0 to 1.0</span>`,wrap:!1}}),vl=new U({props:{title:"Working with LeRobot Datasets and Replay Buffers",local:"working-with-lerobot-datasets-and-replay-buffers",headingTag:"h2"}}),Wl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset
<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor
<span class="hljs-keyword">from</span> lerobot.processor.normalize_processor <span class="hljs-keyword">import</span> NormalizerProcessor
<span class="hljs-keyword">from</span> lerobot.configs.types <span class="hljs-keyword">import</span> FeatureType, NormalizationMode, PolicyFeature

<span class="hljs-comment"># Load a dataset</span>
dataset = LeRobotDataset(<span class="hljs-string">&quot;lerobot/pusht&quot;</span>)

<span class="hljs-comment"># Define features and normalization</span>
features = {
    <span class="hljs-string">&quot;observation.image&quot;</span>: PolicyFeature(FeatureType.VISUAL, (<span class="hljs-number">3</span>, <span class="hljs-number">96</span>, <span class="hljs-number">96</span>)),
    <span class="hljs-string">&quot;observation.state&quot;</span>: PolicyFeature(FeatureType.STATE, (<span class="hljs-number">2</span>,)),
    <span class="hljs-string">&quot;action&quot;</span>: PolicyFeature(FeatureType.ACTION, (<span class="hljs-number">2</span>,)),
}

norm_map = {
    FeatureType.VISUAL: NormalizationMode.MEAN_STD,
    FeatureType.STATE: NormalizationMode.MIN_MAX,
    FeatureType.ACTION: NormalizationMode.MEAN_STD,
}

<span class="hljs-comment"># Create processor with normalization</span>
processor = RobotProcessor([
    NormalizerProcessor.from_lerobot_dataset(dataset, features, norm_map),
])

<span class="hljs-comment"># Process a batch from the dataset</span>
batch = dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Get first batch</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Original batch keys:&quot;</span>, <span class="hljs-built_in">list</span>(batch.keys()))
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Original image shape:&quot;</span>, batch[<span class="hljs-string">&quot;observation.image&quot;</span>].shape)

<span class="hljs-comment"># Process the batch - automatically converts to/from batch format</span>
processed_batch = processor(batch)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Processed batch keys:&quot;</span>, <span class="hljs-built_in">list</span>(processed_batch.keys()))
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Processed image range:&quot;</span>, processed_batch[<span class="hljs-string">&quot;observation.image&quot;</span>].<span class="hljs-built_in">min</span>().item(),
      <span class="hljs-string">&quot;to&quot;</span>, processed_batch[<span class="hljs-string">&quot;observation.image&quot;</span>].<span class="hljs-built_in">max</span>().item())

<span class="hljs-comment"># Use with DataLoader</span>
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

dataloader = DataLoader(dataset, batch_size=<span class="hljs-number">32</span>, shuffle=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-comment"># Process entire batch at once</span>
    processed_batch = processor(batch)

    <span class="hljs-comment"># Use processed batch for training</span>
    <span class="hljs-comment"># model.train_step(processed_batch)</span>
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Vl=new U({props:{title:"Integration with Replay Buffers",local:"integration-with-replay-buffers",headingTag:"h2"}}),Xl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.common.utils.buffer <span class="hljs-keyword">import</span> ReplayBuffer
<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor
<span class="hljs-keyword">from</span> lerobot.processor.device_processor <span class="hljs-keyword">import</span> DeviceProcessor

<span class="hljs-comment"># Create replay buffer</span>
buffer = ReplayBuffer(capacity=<span class="hljs-number">10000</span>)

<span class="hljs-comment"># Create processor for online data</span>
online_processor = RobotProcessor([
    ImageProcessor(),
    StateProcessor(),
    DeviceProcessor(device=<span class="hljs-string">&quot;cuda&quot;</span>),
])

<span class="hljs-comment"># During environment interaction</span>
env = make_env()
obs, info = env.reset()

<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
    <span class="hljs-comment"># Raw environment observation</span>
    transition = {
        TransitionKey.OBSERVATION: obs,
        TransitionKey.ACTION: <span class="hljs-literal">None</span>,
        TransitionKey.REWARD: <span class="hljs-number">0.0</span>,
        TransitionKey.DONE: <span class="hljs-literal">False</span>,
        TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,
        TransitionKey.INFO: info,
        TransitionKey.COMPLEMENTARY_DATA: {}
    }

    <span class="hljs-comment"># Process for policy input</span>
    processed_transition = online_processor(transition)
    processed_obs = processed_transition[TransitionKey.OBSERVATION]

    <span class="hljs-comment"># Get action from policy</span>
    action = policy.select_action(processed_obs)

    <span class="hljs-comment"># Execute action</span>
    next_obs, reward, done, truncated, info = env.step(action)

    <span class="hljs-comment"># Store in replay buffer (can store either format)</span>
    buffer.add(obs, action, reward, next_obs, done, truncated, info)

    obs = next_obs
    <span class="hljs-keyword">if</span> done <span class="hljs-keyword">or</span> truncated:
        obs, info = env.reset()

<span class="hljs-comment"># Sample and process batches for training</span>
batch = buffer.sample(batch_size=<span class="hljs-number">32</span>)
processed_batch = online_processor(batch)  <span class="hljs-comment"># Processes entire batch</span>`,wrap:!1}}),kl=new U({props:{title:"Creating Custom Steps: The ProcessorStep Protocol",local:"creating-custom-steps-the-processorstep-protocol",headingTag:"h2"}}),Yl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImagePadder</span>:
    <span class="hljs-string">&quot;&quot;&quot;Pad images to a standard size for batch processing.&quot;&quot;&quot;</span>

    target_height: <span class="hljs-built_in">int</span> = <span class="hljs-number">224</span>
    target_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">224</span>
    pad_value: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.0</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        <span class="hljs-string">&quot;&quot;&quot;Main processing method - required for all steps.&quot;&quot;&quot;</span>
        obs = transition.get(TransitionKey.OBSERVATION)

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Process all image observations</span>
        processed_obs = <span class="hljs-built_in">dict</span>(obs)  <span class="hljs-comment"># Create a copy</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(processed_obs.keys()):
            <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;observation.images.&quot;</span>):
                img = processed_obs[key]
                <span class="hljs-comment"># Calculate padding</span>
                _, _, h, w = img.shape
                pad_h = <span class="hljs-built_in">max</span>(<span class="hljs-number">0</span>, self.target_height - h)
                pad_w = <span class="hljs-built_in">max</span>(<span class="hljs-number">0</span>, self.target_width - w)

                <span class="hljs-keyword">if</span> pad_h &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> pad_w &gt; <span class="hljs-number">0</span>:
                    <span class="hljs-comment"># Pad symmetrically</span>
                    pad_left = pad_w // <span class="hljs-number">2</span>
                    pad_right = pad_w - pad_left
                    pad_top = pad_h // <span class="hljs-number">2</span>
                    pad_bottom = pad_h - pad_top

                    img = F.pad(img, (pad_left, pad_right, pad_top, pad_bottom),
                               mode=<span class="hljs-string">&#x27;constant&#x27;</span>, value=self.pad_value)

                processed_obs[key] = img

        <span class="hljs-comment"># Return modified transition</span>
        new_transition = transition.copy()
        new_transition[TransitionKey.OBSERVATION] = processed_obs
        <span class="hljs-keyword">return</span> new_transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return JSON-serializable configuration - required for save/load.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;target_height&quot;</span>: self.target_height,
            <span class="hljs-string">&quot;target_width&quot;</span>: self.target_width,
            <span class="hljs-string">&quot;pad_value&quot;</span>: self.pad_value
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-string">&quot;&quot;&quot;Return tensor state - only include torch.Tensor objects!&quot;&quot;&quot;</span>
        <span class="hljs-comment"># This step has no learnable parameters</span>
        <span class="hljs-keyword">return</span> {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Load tensor state - required if state_dict returns non-empty dict.&quot;&quot;&quot;</span>
        <span class="hljs-comment"># Nothing to load for this step</span>
        <span class="hljs-keyword">pass</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">reset</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Reset internal state at episode boundaries - required for stateful steps.&quot;&quot;&quot;</span>
        <span class="hljs-comment"># This step is stateless, so nothing to reset</span>
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),Sl=new U({props:{title:"Important: get_config vs state_dict",local:"important-getconfig-vs-statedict",headingTag:"h3"}}),Fl=new w({props:{code:"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",highlighted:`<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AdaptiveNormalizer</span>:
    <span class="hljs-string">&quot;&quot;&quot;Example showing proper use of get_config and state_dict.&quot;&quot;&quot;</span>

    learning_rate: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.01</span>
    epsilon: <span class="hljs-built_in">float</span> = <span class="hljs-number">1e-8</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__post_init__</span>(<span class="hljs-params">self</span>):
        self.running_mean = <span class="hljs-literal">None</span>
        self.running_var = <span class="hljs-literal">None</span>
        self.num_samples = <span class="hljs-number">0</span>  <span class="hljs-comment"># Python int, not tensor</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-string">&quot;&quot;&quot;ONLY Python objects that can be JSON serialized!&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;learning_rate&quot;</span>: self.learning_rate,  <span class="hljs-comment"># float ✓</span>
            <span class="hljs-string">&quot;epsilon&quot;</span>: self.epsilon,              <span class="hljs-comment"># float ✓</span>
            <span class="hljs-string">&quot;num_samples&quot;</span>: self.num_samples,      <span class="hljs-comment"># int ✓</span>
            <span class="hljs-comment"># &quot;running_mean&quot;: self.running_mean,  # torch.Tensor ✗ WRONG!</span>
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-string">&quot;&quot;&quot;ONLY torch.Tensor objects!&quot;&quot;&quot;</span>
        <span class="hljs-keyword">if</span> self.running_mean <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> {}
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;running_mean&quot;</span>: self.running_mean,    <span class="hljs-comment"># torch.Tensor ✓</span>
            <span class="hljs-string">&quot;running_var&quot;</span>: self.running_var,      <span class="hljs-comment"># torch.Tensor ✓</span>
            <span class="hljs-comment"># &quot;num_samples&quot;: self.num_samples,    # int ✗ WRONG!</span>
            <span class="hljs-comment"># Instead, convert to tensor if needed:</span>
            <span class="hljs-string">&quot;num_samples_tensor&quot;</span>: torch.tensor(self.num_samples)
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Load tensors and convert back to Python types if needed.&quot;&quot;&quot;</span>
        self.running_mean = state.get(<span class="hljs-string">&quot;running_mean&quot;</span>)
        self.running_var = state.get(<span class="hljs-string">&quot;running_var&quot;</span>)
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;num_samples_tensor&quot;</span> <span class="hljs-keyword">in</span> state:
            self.num_samples = <span class="hljs-built_in">int</span>(state[<span class="hljs-string">&quot;num_samples_tensor&quot;</span>].item())`,wrap:!1}}),_l=new U({props:{title:"Using Complementary Data for Inter-Step Communication",local:"using-complementary-data-for-inter-step-communication",headingTag:"h2"}}),ql=new w({props:{code:"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",highlighted:`<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImageStatisticsCalculator</span>:
    <span class="hljs-string">&quot;&quot;&quot;Calculate image statistics and pass to next steps.&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition.get(TransitionKey.OBSERVATION)
        comp_data = transition.get(TransitionKey.COMPLEMENTARY_DATA) <span class="hljs-keyword">or</span> {}

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Calculate statistics for all images</span>
        image_stats = {}
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> obs:
            <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;observation.images.&quot;</span>):
                img = obs[key]
                stats = {
                    <span class="hljs-string">&quot;mean&quot;</span>: img.mean().item(),
                    <span class="hljs-string">&quot;std&quot;</span>: img.std().item(),
                    <span class="hljs-string">&quot;min&quot;</span>: img.<span class="hljs-built_in">min</span>().item(),
                    <span class="hljs-string">&quot;max&quot;</span>: img.<span class="hljs-built_in">max</span>().item(),
                }
                image_stats[key] = stats

        <span class="hljs-comment"># Store in complementary_data for next steps</span>
        comp_data = <span class="hljs-built_in">dict</span>(comp_data)  <span class="hljs-comment"># Make a copy</span>
        comp_data[<span class="hljs-string">&quot;image_statistics&quot;</span>] = image_stats

        <span class="hljs-comment"># Return transition with updated complementary_data</span>
        new_transition = transition.copy()
        new_transition[TransitionKey.COMPLEMENTARY_DATA] = comp_data
        <span class="hljs-keyword">return</span> new_transition

<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AdaptiveBrightnessAdjuster</span>:
    <span class="hljs-string">&quot;&quot;&quot;Adjust brightness based on statistics from previous step.&quot;&quot;&quot;</span>

    target_brightness: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.5</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition.get(TransitionKey.OBSERVATION)
        comp_data = transition.get(TransitionKey.COMPLEMENTARY_DATA) <span class="hljs-keyword">or</span> {}

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;image_statistics&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> comp_data:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Use statistics from previous step</span>
        image_stats = comp_data[<span class="hljs-string">&quot;image_statistics&quot;</span>]

        processed_obs = <span class="hljs-built_in">dict</span>(obs)  <span class="hljs-comment"># Create a copy</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> processed_obs:
            <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;observation.images.&quot;</span>) <span class="hljs-keyword">and</span> key <span class="hljs-keyword">in</span> image_stats:
                current_mean = image_stats[key][<span class="hljs-string">&quot;mean&quot;</span>]
                brightness_adjust = self.target_brightness - current_mean

                <span class="hljs-comment"># Adjust brightness</span>
                processed_obs[key] = torch.clamp(processed_obs[key] + brightness_adjust, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)

        new_transition = transition.copy()
        new_transition[TransitionKey.OBSERVATION] = processed_obs
        <span class="hljs-keyword">return</span> new_transition

<span class="hljs-comment"># Use them together</span>
processor = RobotProcessor([
    ImageProcessor(),
    ImageStatisticsCalculator(),  <span class="hljs-comment"># Calculates stats</span>
    AdaptiveBrightnessAdjuster(), <span class="hljs-comment"># Uses stats from previous step</span>
])`,wrap:!1}}),$l=new U({props:{title:"Loading Processors with Overrides: Handling Non-Serializable Objects",local:"loading-processors-with-overrides-handling-non-serializable-objects",headingTag:"h2"}}),Kl=new U({props:{title:"The Problem: Non-Serializable Parameters",local:"the-problem-non-serializable-parameters",headingTag:"h3"}}),Dl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">import</span> gym

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;action_repeat_step&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ActionRepeatStep</span>:
    <span class="hljs-string">&quot;&quot;&quot;Step that repeats actions using environment feedback.&quot;&quot;&quot;</span>

    repeat_count: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>
    env: gym.Env = <span class="hljs-literal">None</span>  <span class="hljs-comment"># This can&#x27;t be serialized to JSON!</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        action = transition.get(TransitionKey.ACTION)

        <span class="hljs-keyword">if</span> self.env <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> action <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-comment"># Repeat action multiple times in environment</span>
            total_reward = <span class="hljs-number">0</span>
            <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.repeat_count):
                _, r, d, t, _ = self.env.step(action)
                total_reward += r
                <span class="hljs-keyword">if</span> d <span class="hljs-keyword">or</span> t:
                    <span class="hljs-keyword">break</span>

            <span class="hljs-comment"># Update reward in transition</span>
            new_transition = transition.copy()
            new_transition[TransitionKey.REWARD] = total_reward
            <span class="hljs-keyword">return</span> new_transition

        <span class="hljs-keyword">return</span> transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-comment"># Note: env is NOT included because it&#x27;s not serializable</span>
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;repeat_count&quot;</span>: self.repeat_count}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-keyword">return</span> {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),Ol=new U({props:{title:"The Solution: Override Parameters",local:"the-solution-override-parameters",headingTag:"h3"}}),ss=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yLnBpcGVsaW5lJTIwaW1wb3J0JTIwUm9ib3RQcm9jZXNzb3IlMEElMEElMjMlMjBDcmVhdGUlMjBwcm9jZXNzb3IlMjB3aXRoJTIwZW52aXJvbm1lbnQlMEFlbnYlMjAlM0QlMjBneW0ubWFrZSglMjJDYXJ0UG9sZS12MSUyMiklMEFhY3Rpb25fc3RlcCUyMCUzRCUyMEFjdGlvblJlcGVhdFN0ZXAocmVwZWF0X2NvdW50JTNEMiUyQyUyMGVudiUzRGVudiklMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglNUJhY3Rpb25fc3RlcCU1RCUyQyUyMG5hbWUlM0QlMjJDYXJ0UG9sZVByb2Nlc3NvciUyMiklMEElMEElMjMlMjBTYXZlJTIwdGhlJTIwcHJvY2Vzc29yJTIwKGVudiUyMHdvbid0JTIwYmUlMjBzYXZlZCklMEFwcm9jZXNzb3Iuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZjYXJ0cG9sZV9wcm9jZXNzb3IlMjIpJTBBJTBBJTIzJTIwTGF0ZXIlMkMlMjBsb2FkJTIwd2l0aCUyMGVudmlyb25tZW50JTIwb3ZlcnJpZGUlMEFuZXdfZW52JTIwJTNEJTIwZ3ltLm1ha2UoJTIyQ2FydFBvbGUtdjElMjIpJTBBbG9hZGVkX3Byb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGY2FydHBvbGVfcHJvY2Vzc29yJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3ZlcnJpZGVzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWN0aW9uX3JlcGVhdF9zdGVwJTIyJTNBJTIwJTdCJTIyZW52JTIyJTNBJTIwbmV3X2VudiU3RCUyMCUyMCUyMyUyMFByb3ZpZGUlMjB0aGUlMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMCU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor

<span class="hljs-comment"># Create processor with environment</span>
env = gym.make(<span class="hljs-string">&quot;CartPole-v1&quot;</span>)
action_step = ActionRepeatStep(repeat_count=<span class="hljs-number">2</span>, env=env)
processor = RobotProcessor([action_step], name=<span class="hljs-string">&quot;CartPoleProcessor&quot;</span>)

<span class="hljs-comment"># Save the processor (env won&#x27;t be saved)</span>
processor.save_pretrained(<span class="hljs-string">&quot;./cartpole_processor&quot;</span>)

<span class="hljs-comment"># Later, load with environment override</span>
new_env = gym.make(<span class="hljs-string">&quot;CartPole-v1&quot;</span>)
loaded_processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;./cartpole_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;action_repeat_step&quot;</span>: {<span class="hljs-string">&quot;env&quot;</span>: new_env}  <span class="hljs-comment"># Provide the environment</span>
    }
)`,wrap:!1}}),as=new U({props:{title:"How Overrides Work",local:"how-overrides-work",headingTag:"h3"}}),ts=new w({props:{code:"b3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyU3RlcENsYXNzTmFtZSUyMiUzQSUyMCU3QiUyMnBhcmFtMSUyMiUzQSUyMCUyMm5ld192YWx1ZSUyMiUyQyUyMCUyMnBhcmFtMiUyMiUzQSUyMDQyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVnaXN0ZXJlZF9zdGVwX25hbWUlMjIlM0ElMjAlN0IlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTJDJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDAuMDElN0QlMEElN0Q=",highlighted:`overrides = {
    <span class="hljs-string">&quot;StepClassName&quot;</span>: {<span class="hljs-string">&quot;param1&quot;</span>: <span class="hljs-string">&quot;new_value&quot;</span>, <span class="hljs-string">&quot;param2&quot;</span>: <span class="hljs-number">42</span>},
    <span class="hljs-string">&quot;registered_step_name&quot;</span>: {<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda&quot;</span>, <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">0.01</span>}
}`,wrap:!1}}),Js=new U({props:{title:"Real-World Examples",local:"real-world-examples",headingTag:"h3"}}),ps=new U({props:{title:"Example 1: Environment-Dependent Steps",local:"example-1-environment-dependent-steps",headingTag:"h4"}}),js=new w({props:{code:"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",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;ik_solver_step&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">InverseKinematicsStep</span>:
    <span class="hljs-string">&quot;&quot;&quot;Convert Cartesian positions to joint angles.&quot;&quot;&quot;</span>

    robot_model: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;ur5&quot;</span>
    solver_timeout: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.1</span>
    kinematics_solver: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Non-serializable solver instance</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs, action, reward, done, truncated, info, comp_data = transition

        <span class="hljs-keyword">if</span> self.kinematics_solver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> action <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-comment"># Convert Cartesian action to joint angles</span>
            joint_angles = self.kinematics_solver.solve(action, timeout=self.solver_timeout)
            action = joint_angles

        <span class="hljs-keyword">return</span> (obs, action, reward, done, truncated, info, comp_data)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;robot_model&quot;</span>: self.robot_model,
            <span class="hljs-string">&quot;solver_timeout&quot;</span>: self.solver_timeout
        }

<span class="hljs-comment"># Save processor without solver</span>
processor = RobotProcessor([InverseKinematicsStep(robot_model=<span class="hljs-string">&quot;ur5&quot;</span>)])
processor.save_pretrained(<span class="hljs-string">&quot;./robot_processor&quot;</span>)

<span class="hljs-comment"># Load with solver instance</span>
<span class="hljs-keyword">from</span> robotics_toolbox <span class="hljs-keyword">import</span> URKinematics
solver = URKinematics(<span class="hljs-string">&quot;ur5&quot;</span>)

loaded_processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;./robot_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;ik_solver_step&quot;</span>: {
            <span class="hljs-string">&quot;kinematics_solver&quot;</span>: solver,
            <span class="hljs-string">&quot;solver_timeout&quot;</span>: <span class="hljs-number">0.05</span>  <span class="hljs-comment"># Also override timeout</span>
        }
    }
)`,wrap:!1}}),os=new U({props:{title:"Example 2: Device and Hardware Configuration",local:"example-2-device-and-hardware-configuration",headingTag:"h4"}}),is=new w({props:{code:"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",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;camera_capture_step&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">CameraCaptureStep</span>:
    <span class="hljs-string">&quot;&quot;&quot;Capture images from physical camera.&quot;&quot;&quot;</span>

    camera_id: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span>
    resolution: <span class="hljs-built_in">tuple</span> = (<span class="hljs-number">640</span>, <span class="hljs-number">480</span>)
    camera_interface: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Hardware interface</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;camera_id&quot;</span>: self.camera_id,
            <span class="hljs-string">&quot;resolution&quot;</span>: self.resolution
        }

<span class="hljs-comment"># Deploy on different robots with different camera setups</span>
<span class="hljs-comment"># Robot A</span>
camera_a = CameraInterface(<span class="hljs-string">&quot;/dev/video0&quot;</span>)
processor_a = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/vision_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;camera_capture_step&quot;</span>: {
            <span class="hljs-string">&quot;camera_interface&quot;</span>: camera_a,
            <span class="hljs-string">&quot;resolution&quot;</span>: (<span class="hljs-number">1920</span>, <span class="hljs-number">1080</span>)  <span class="hljs-comment"># High-res camera</span>
        }
    }
)

<span class="hljs-comment"># Robot B</span>
camera_b = CameraInterface(<span class="hljs-string">&quot;/dev/video1&quot;</span>)
processor_b = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/vision_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;camera_capture_step&quot;</span>: {
            <span class="hljs-string">&quot;camera_interface&quot;</span>: camera_b,
            <span class="hljs-string">&quot;resolution&quot;</span>: (<span class="hljs-number">640</span>, <span class="hljs-number">480</span>)  <span class="hljs-comment"># Lower-res camera</span>
        }
    }
)`,wrap:!1}}),Ts=new U({props:{title:"Example 3: Multiple Environment Deployment",local:"example-3-multiple-environment-deployment",headingTag:"h4"}}),cs=new w({props:{code:"JTIzJTIwVHJhaW5pbmclMjBwcm9jZXNzb3IlMjB0aGF0JTIwd29ya3MlMjB3aXRoJTIwc2ltdWxhdGlvbiUwQSU0MFByb2Nlc3NvclN0ZXBSZWdpc3RyeS5yZWdpc3RlciglMjJwaHlzaWNzX3ZhbGlkYXRvciUyMiklMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFBoeXNpY3NWYWxpZGF0b3JTdGVwJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVmFsaWRhdGUlMjBhY3Rpb25zJTIwYWdhaW5zdCUyMHBoeXNpY3MlMjBjb25zdHJhaW50cy4lMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjBtYXhfZm9yY2UlM0ElMjBmbG9hdCUyMCUzRCUyMDEwMC4wJTBBJTIwJTIwJTIwJTIwcGh5c2ljc19lbmdpbmUlM0ElMjBBbnklMjAlM0QlMjBOb25lJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2V0X2NvbmZpZyhzZWxmKSUyMC0lM0UlMjBkaWN0JTVCc3RyJTJDJTIwQW55JTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybWF4X2ZvcmNlJTIyJTNBJTIwc2VsZi5tYXhfZm9yY2UlN0QlMEElMEElMjMlMjBEaWZmZXJlbnQlMjBwaHlzaWNzJTIwZW5naW5lcyUyMGZvciUyMGRpZmZlcmVudCUyMGVudmlyb25tZW50cyUwQWltcG9ydCUyMHB5YnVsbGV0JTIwYXMlMjBwYiUwQWltcG9ydCUyMG11am9jbyUwQSUwQSUyMyUyMFNpbXVsYXRpb24lMjBkZXBsb3ltZW50JTBBc2ltX2VuZ2luZSUyMCUzRCUyMHBiLmNvbm5lY3QocGIuRElSRUNUKSUwQXNpbV9wcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc2hhcmVkJTJGY29udHJvbF9wcm9jZXNzb3IlMjIlMkMlMEElMjAlMjAlMjAlMjBvdmVycmlkZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwaHlzaWNzX3ZhbGlkYXRvciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBoeXNpY3NfZW5naW5lJTIyJTNBJTIwc2ltX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9mb3JjZSUyMiUzQSUyMDE1MC4wJTIwJTIwJTIzJTIwSGlnaGVyJTIwbGltaXRzJTIwaW4lMjBzaW0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBJTBBJTIzJTIwUmVhbCUyMHJvYm90JTIwZGVwbG95bWVudCUwQXJlYWxfZW5naW5lJTIwJTNEJTIwUmVhbFJvYm90SW50ZXJmYWNlKCklMEFyZWFsX3Byb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzaGFyZWQlMkZjb250cm9sX3Byb2Nlc3NvciUyMiUyQyUwQSUyMCUyMCUyMCUyMG92ZXJyaWRlcyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBoeXNpY3NfdmFsaWRhdG9yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGh5c2ljc19lbmdpbmUlMjIlM0ElMjByZWFsX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9mb3JjZSUyMiUzQSUyMDUwLjAlMjAlMjAlMjMlMjBDb25zZXJ2YXRpdmUlMjBsaW1pdHMlMjBvbiUyMHJlYWwlMjByb2JvdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSk=",highlighted:`<span class="hljs-comment"># Training processor that works with simulation</span>
<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;physics_validator&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">PhysicsValidatorStep</span>:
    <span class="hljs-string">&quot;&quot;&quot;Validate actions against physics constraints.&quot;&quot;&quot;</span>

    max_force: <span class="hljs-built_in">float</span> = <span class="hljs-number">100.0</span>
    physics_engine: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;max_force&quot;</span>: self.max_force}

<span class="hljs-comment"># Different physics engines for different environments</span>
<span class="hljs-keyword">import</span> pybullet <span class="hljs-keyword">as</span> pb
<span class="hljs-keyword">import</span> mujoco

<span class="hljs-comment"># Simulation deployment</span>
sim_engine = pb.connect(pb.DIRECT)
sim_processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/control_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;physics_validator&quot;</span>: {
            <span class="hljs-string">&quot;physics_engine&quot;</span>: sim_engine,
            <span class="hljs-string">&quot;max_force&quot;</span>: <span class="hljs-number">150.0</span>  <span class="hljs-comment"># Higher limits in sim</span>
        }
    }
)

<span class="hljs-comment"># Real robot deployment</span>
real_engine = RealRobotInterface()
real_processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/control_processor&quot;</span>,
    overrides={
        <span class="hljs-string">&quot;physics_validator&quot;</span>: {
            <span class="hljs-string">&quot;physics_engine&quot;</span>: real_engine,
            <span class="hljs-string">&quot;max_force&quot;</span>: <span class="hljs-number">50.0</span>  <span class="hljs-comment"># Conservative limits on real robot</span>
        }
    }
)`,wrap:!1}}),Us=new U({props:{title:"Override Key Matching Rules",local:"override-key-matching-rules",headingTag:"h3"}}),rs=new U({props:{title:"For Registered Steps",local:"for-registered-steps",headingTag:"h4"}}),ms=new w({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMm15X2N1c3RvbV9zdGVwJTIyKSUwQWNsYXNzJTIwTXlTdGVwJTNBJTBBJTIwJTIwJTIwJTIwcGFzcyUwQSUwQSUyMyUyMFVzZSUyMHJlZ2lzdHJ5JTIwbmFtZSUyMGluJTIwb3ZlcnJpZGVzJTBBb3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTIybXlfY3VzdG9tX3N0ZXAlMjIlM0ElMjAlN0IlMjJwYXJhbSUyMiUzQSUyMCUyMnZhbHVlJTIyJTdEJTdE",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;my_custom_step&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Use registry name in overrides</span>
overrides = {<span class="hljs-string">&quot;my_custom_step&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-string">&quot;value&quot;</span>}}`,wrap:!1}}),Cs=new U({props:{title:"For Unregistered Steps",local:"for-unregistered-steps",headingTag:"h4"}}),us=new w({props:{code:"Y2xhc3MlMjBNeVVucmVnaXN0ZXJlZFN0ZXAlM0ElMEElMjAlMjAlMjAlMjBwYXNzJTBBJTBBJTIzJTIwVXNlJTIwY2xhc3MlMjBuYW1lJTIwaW4lMjBvdmVycmlkZXMlMEFvdmVycmlkZXMlMjAlM0QlMjAlN0IlMjJNeVVucmVnaXN0ZXJlZFN0ZXAlMjIlM0ElMjAlN0IlMjJwYXJhbSUyMiUzQSUyMCUyMnZhbHVlJTIyJTdEJTdE",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyUnregisteredStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Use class name in overrides</span>
overrides = {<span class="hljs-string">&quot;MyUnregisteredStep&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-string">&quot;value&quot;</span>}}`,wrap:!1}}),bs=new U({props:{title:"Error Handling and Validation",local:"error-handling-and-validation",headingTag:"h3"}}),As=new U({props:{title:"Invalid Override Keys",local:"invalid-override-keys",headingTag:"h4"}}),Bs=new w({props:{code:"JTIzJTIwVGhpcyUyMHdpbGwlMjByYWlzZSUyMEtleUVycm9yJTIwd2l0aCUyMGhlbHBmdWwlMjBtZXNzYWdlJTBBb3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTIyTm9uRXhpc3RlbnRTdGVwJTIyJTNBJTIwJTdCJTIycGFyYW0lMjIlM0ElMjAlMjJ2YWx1ZSUyMiU3RCU3RCUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHByb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHJvY2Vzc29yJTIyJTJDJTIwb3ZlcnJpZGVzJTNEb3ZlcnJpZGVzKSUwQWV4Y2VwdCUyMEtleUVycm9yJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZSklMEElMjAlMjAlMjAlMjAlMjMlMjBPdXRwdXQlM0ElMjBPdmVycmlkZSUyMGtleXMlMjAlNUInTm9uRXhpc3RlbnRTdGVwJyU1RCUyMGRvJTIwbm90JTIwbWF0Y2glMjBhbnklMjBzdGVwJTIwaW4lMjB0aGUlMjBzYXZlZCUyMGNvbmZpZ3VyYXRpb24uJTBBJTIwJTIwJTIwJTIwJTIzJTIwQXZhaWxhYmxlJTIwc3RlcCUyMGtleXMlM0ElMjAlNUInQWN0dWFsU3RlcE5hbWUnJTJDJTIwJ0Fub3RoZXJTdGVwTmFtZSclNUQ=",highlighted:`<span class="hljs-comment"># This will raise KeyError with helpful message</span>
overrides = {<span class="hljs-string">&quot;NonExistentStep&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-string">&quot;value&quot;</span>}}

<span class="hljs-keyword">try</span>:
    processor = RobotProcessor.from_pretrained(<span class="hljs-string">&quot;./processor&quot;</span>, overrides=overrides)
<span class="hljs-keyword">except</span> KeyError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(e)
    <span class="hljs-comment"># Output: Override keys [&#x27;NonExistentStep&#x27;] do not match any step in the saved configuration.</span>
    <span class="hljs-comment"># Available step keys: [&#x27;ActualStepName&#x27;, &#x27;AnotherStepName&#x27;]</span>`,wrap:!1}}),Zs=new U({props:{title:"Instantiation Errors",local:"instantiation-errors",headingTag:"h4"}}),Ns=new w({props:{code:"JTIzJTIwSW52YWxpZCUyMHBhcmFtZXRlciUyMHR5cGVzJTIwYXJlJTIwY2F1Z2h0JTBBb3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTIyTXlTdGVwJTIyJTNBJTIwJTdCJTIybnVtZXJpY19wYXJhbSUyMiUzQSUyMCUyMm5vdF9hX251bWJlciUyMiU3RCU3RCUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHByb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHJvY2Vzc29yJTIyJTJDJTIwb3ZlcnJpZGVzJTNEb3ZlcnJpZGVzKSUwQWV4Y2VwdCUyMFZhbHVlRXJyb3IlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjBwcmludChlKSUwQSUyMCUyMCUyMCUyMCUyMyUyME91dHB1dCUzQSUyMEZhaWxlZCUyMHRvJTIwaW5zdGFudGlhdGUlMjBwcm9jZXNzb3IlMjBzdGVwJTIwJ015U3RlcCclMjB3aXRoJTIwY29uZmlnJTNBJTIwJTdCLi4uJTdE",highlighted:`<span class="hljs-comment"># Invalid parameter types are caught</span>
overrides = {<span class="hljs-string">&quot;MyStep&quot;</span>: {<span class="hljs-string">&quot;numeric_param&quot;</span>: <span class="hljs-string">&quot;not_a_number&quot;</span>}}

<span class="hljs-keyword">try</span>:
    processor = RobotProcessor.from_pretrained(<span class="hljs-string">&quot;./processor&quot;</span>, overrides=overrides)
<span class="hljs-keyword">except</span> ValueError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(e)
    <span class="hljs-comment"># Output: Failed to instantiate processor step &#x27;MyStep&#x27; with config: {...}</span>`,wrap:!1}}),Rs=new U({props:{title:"Multiple Steps with Same Class Name",local:"multiple-steps-with-same-class-name",headingTag:"h3"}}),fs=new w({props:{code:"c3RlcDElMjAlM0QlMjBNeVN0ZXAocGFyYW0lM0QxKSUwQXN0ZXAyJTIwJTNEJTIwTXlTdGVwKHBhcmFtJTNEMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvciglNUJzdGVwMSUyQyUyMHN0ZXAyJTVEKSUwQSUwQSUyMyUyMEJvdGglMjBzdGVwcyUyMHdpbGwlMjBnZXQlMjB0aGUlMjBvdmVycmlkZSUwQW92ZXJyaWRlcyUyMCUzRCUyMCU3QiUyMk15U3RlcCUyMiUzQSUyMCU3QiUyMnBhcmFtJTIyJTNBJTIwOTk5JTdEJTdEJTBBbG9hZGVkJTIwJTNEJTIwUm9ib3RQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwcm9jZXNzb3IlMjIlMkMlMjBvdmVycmlkZXMlM0RvdmVycmlkZXMpJTBBJTIzJTIwQm90aCUyMHN0ZXBzJTIwbm93JTIwaGF2ZSUyMHBhcmFtJTNEOTk5",highlighted:`step1 = MyStep(param=<span class="hljs-number">1</span>)
step2 = MyStep(param=<span class="hljs-number">2</span>)
processor = RobotProcessor([step1, step2])

<span class="hljs-comment"># Both steps will get the override</span>
overrides = {<span class="hljs-string">&quot;MyStep&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-number">999</span>}}
loaded = RobotProcessor.from_pretrained(<span class="hljs-string">&quot;./processor&quot;</span>, overrides=overrides)
<span class="hljs-comment"># Both steps now have param=999</span>`,wrap:!1}}),Gs=new w({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMnN0ZXBfMSUyMiklMEFjbGFzcyUyME15U3RlcCUzQSUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEElNDBQcm9jZXNzb3JTdGVwUmVnaXN0cnkucmVnaXN0ZXIoJTIyc3RlcF8yJTIyKSUwQWNsYXNzJTIwTXlTdGVwJTNBJTIwJTIwJTIzJTIwU2FtZSUyMGNsYXNzJTJDJTIwZGlmZmVyZW50JTIwcmVnaXN0cnklMjBuYW1lcyUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEElMjMlMjBOb3clMjB5b3UlMjBjYW4lMjBvdmVycmlkZSUyMHRoZW0lMjBzZXBhcmF0ZWx5JTBBb3ZlcnJpZGVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyc3RlcF8xJTIyJTNBJTIwJTdCJTIycGFyYW0lMjIlM0ElMjAxJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RlcF8yJTIyJTNBJTIwJTdCJTIycGFyYW0lMjIlM0ElMjAyJTdEJTBBJTdE",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;step_1&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;step_2&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyStep</span>:  <span class="hljs-comment"># Same class, different registry names</span>
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Now you can override them separately</span>
overrides = {
    <span class="hljs-string">&quot;step_1&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-number">1</span>},
    <span class="hljs-string">&quot;step_2&quot;</span>: {<span class="hljs-string">&quot;param&quot;</span>: <span class="hljs-number">2</span>}
}`,wrap:!1}}),Ws=new U({props:{title:"Best Practices for Overrides",local:"best-practices-for-overrides",headingTag:"h3"}}),Vs=new U({props:{title:"1. Design Steps for Overrides",local:"1-design-steps-for-overrides",headingTag:"h4"}}),Xs=new w({props:{code:"JTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBXZWxsRGVzaWduZWRTdGVwJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2VyaWFsaXphYmxlJTIwY29uZmlndXJhdGlvbiUwQSUyMCUyMCUyMCUyMHRpbWVvdXQlM0ElMjBmbG9hdCUyMCUzRCUyMDEuMCUwQSUyMCUyMCUyMCUyMHJldHJ5X2NvdW50JTNBJTIwaW50JTIwJTNEJTIwMyUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME5vbi1zZXJpYWxpemFibGUlMjBvYmplY3RzJTIwd2l0aCUyMGRlZmF1bHQlMjBOb25lJTBBJTIwJTIwJTIwJTIwZGF0YWJhc2UlM0ElMjBBbnklMjAlM0QlMjBOb25lJTBBJTIwJTIwJTIwJTIwYXBpX2NsaWVudCUzQSUyMEFueSUyMCUzRCUyME5vbmUlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX3Bvc3RfaW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVmFsaWRhdGUlMjB0aGF0JTIwcmVxdWlyZWQlMjBub24tc2VyaWFsaXphYmxlJTIwb2JqZWN0cyUyMGFyZSUyMHByb3ZpZGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmRhdGFiYXNlJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBWYWx1ZUVycm9yKCUyMmRhdGFiYXNlJTIwbXVzdCUyMGJlJTIwcHJvdmlkZWQlMjB2aWElMjBvdmVycmlkZXMlMjIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2V0X2NvbmZpZyhzZWxmKSUyMC0lM0UlMjBkaWN0JTVCc3RyJTJDJTIwQW55JTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwT25seSUyMGluY2x1ZGUlMjBzZXJpYWxpemFibGUlMjBwYXJhbWV0ZXJzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGltZW91dCUyMiUzQSUyMHNlbGYudGltZW91dCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJldHJ5X2NvdW50JTIyJTNBJTIwc2VsZi5yZXRyeV9jb3VudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">WellDesignedStep</span>:
    <span class="hljs-comment"># Serializable configuration</span>
    timeout: <span class="hljs-built_in">float</span> = <span class="hljs-number">1.0</span>
    retry_count: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>

    <span class="hljs-comment"># Non-serializable objects with default None</span>
    database: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>
    api_client: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__post_init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># Validate that required non-serializable objects are provided</span>
        <span class="hljs-keyword">if</span> self.database <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;database must be provided via overrides&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-comment"># Only include serializable parameters</span>
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;timeout&quot;</span>: self.timeout,
            <span class="hljs-string">&quot;retry_count&quot;</span>: self.retry_count
        }`,wrap:!1}}),ks=new U({props:{title:"2. Use Registry Names for Clarity",local:"2-use-registry-names-for-clarity",headingTag:"h4"}}),Ys=new w({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMnJvYm90X2FybV9jb250cm9sbGVyJTIyKSUwQWNsYXNzJTIwQXJtQ29udHJvbFN0ZXAlM0ElMEElMjAlMjAlMjAlMjBwYXNzJTBBJTBBJTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMmdyaXBwZXJfY29udHJvbGxlciUyMiklMEFjbGFzcyUyMEdyaXBwZXJDb250cm9sU3RlcCUzQSUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEElMjMlMjBDbGVhciUyMG92ZXJyaWRlJTIwa2V5cyUwQW92ZXJyaWRlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJvYm90X2FybV9jb250cm9sbGVyJTIyJTNBJTIwJTdCJTIyam9pbnRfbGltaXRzJTIyJTNBJTIwYXJtX2xpbWl0cyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyaXBwZXJfY29udHJvbGxlciUyMiUzQSUyMCU3QiUyMmZvcmNlX2xpbWl0JTIyJTNBJTIwZ3JpcHBlcl9mb3JjZSU3RCUwQSU3RA==",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;robot_arm_controller&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ArmControlStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;gripper_controller&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">GripperControlStep</span>:
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Clear override keys</span>
overrides = {
    <span class="hljs-string">&quot;robot_arm_controller&quot;</span>: {<span class="hljs-string">&quot;joint_limits&quot;</span>: arm_limits},
    <span class="hljs-string">&quot;gripper_controller&quot;</span>: {<span class="hljs-string">&quot;force_limit&quot;</span>: gripper_force}
}`,wrap:!1}}),Ss=new U({props:{title:"3. Document Override Requirements",local:"3-document-override-requirements",headingTag:"h4"}}),Fs=new w({props:{code:"JTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMnZpc2lvbl9wcm9jZXNzb3IlMjIpJTBBY2xhc3MlMjBWaXNpb25Qcm9jZXNzb3IlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJQcm9jZXNzJTIwY2FtZXJhJTIwaW1hZ2VzJTIwZm9yJTIwcm9ib3QlMjB2aXNpb24uJTBBJTBBJTIwJTIwJTIwJTIwUmVxdWlyZWQlMjBvdmVycmlkZXMlMjB3aGVuJTIwbG9hZGluZyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbWVyYV9pbnRlcmZhY2UlM0ElMjBIYXJkd2FyZSUyMGNhbWVyYSUyMGludGVyZmFjZSUyMG9iamVjdCUwQSUwQSUyMCUyMCUyMCUyME9wdGlvbmFsJTIwb3ZlcnJpZGVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzb2x1dGlvbiUzQSUyMENhbWVyYSUyMHJlc29sdXRpb24lMjB0dXBsZSUyMChkZWZhdWx0JTNBJTIwKDY0MCUyQyUyMDQ4MCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnBzJTNBJTIwQ2FtZXJhJTIwZnJhbWUlMjByYXRlJTIwKGRlZmF1bHQlM0ElMjAzMCklMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBjYW1lcmFfaW50ZXJmYWNlJTNBJTIwQW55JTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMHJlc29sdXRpb24lM0ElMjB0dXBsZSUyMCUzRCUyMCg2NDAlMkMlMjA0ODApJTBBJTIwJTIwJTIwJTIwZnBzJTNBJTIwaW50JTIwJTNEJTIwMzA=",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;vision_processor&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">VisionProcessor</span>:
    <span class="hljs-string">&quot;&quot;&quot;Process camera images for robot vision.

    Required overrides when loading:
        camera_interface: Hardware camera interface object

    Optional overrides:
        resolution: Camera resolution tuple (default: (640, 480))
        fps: Camera frame rate (default: 30)
    &quot;&quot;&quot;</span>
    camera_interface: <span class="hljs-type">Any</span> = <span class="hljs-literal">None</span>
    resolution: <span class="hljs-built_in">tuple</span> = (<span class="hljs-number">640</span>, <span class="hljs-number">480</span>)
    fps: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>`,wrap:!1}}),_s=new U({props:{title:"4. Environment-Specific Configuration Files",local:"4-environment-specific-configuration-files",headingTag:"h4"}}),qs=new w({props:{code:"JTIzJTIwY29uZmlnJTJGc2ltdWxhdGlvbi5weSUwQWRlZiUyMGdldF9zaW11bGF0aW9uX292ZXJyaWRlcygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2FtZXJhX3N0ZXAlMjIlM0ElMjAlN0IlMjJjYW1lcmFfaW50ZXJmYWNlJTIyJTNBJTIwU2ltQ2FtZXJhKCklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwaHlzaWNzX3N0ZXAlMjIlM0ElMjAlN0IlMjJlbmdpbmUlMjIlM0ElMjBTaW1QaHlzaWNzKCklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250cm9sX3N0ZXAlMjIlM0ElMjAlN0IlMjJzYWZldHlfbGltaXRzJTIyJTNBJTIwRmFsc2UlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElMjMlMjBjb25maWclMkZwcm9kdWN0aW9uLnB5JTBBZGVmJTIwZ2V0X3Byb2R1Y3Rpb25fb3ZlcnJpZGVzKCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1lcmFfc3RlcCUyMiUzQSUyMCU3QiUyMmNhbWVyYV9pbnRlcmZhY2UlMjIlM0ElMjBSZWFsQ2FtZXJhKCUyMiUyRmRldiUyRnZpZGVvMCUyMiklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwaHlzaWNzX3N0ZXAlMjIlM0ElMjAlN0IlMjJlbmdpbmUlMjIlM0ElMjBSZWFsUGh5c2ljcygpJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udHJvbF9zdGVwJTIyJTNBJTIwJTdCJTIyc2FmZXR5X2xpbWl0cyUyMiUzQSUyMFRydWUlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElMjMlMjBVc2FnZSUwQWZyb20lMjBjb25maWcucHJvZHVjdGlvbiUyMGltcG9ydCUyMGdldF9wcm9kdWN0aW9uX292ZXJyaWRlcyUwQXByb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzaGFyZWQlMkZwcm9jZXNzb3IlMjIlMkMlMEElMjAlMjAlMjAlMjBvdmVycmlkZXMlM0RnZXRfcHJvZHVjdGlvbl9vdmVycmlkZXMoKSUwQSk=",highlighted:`<span class="hljs-comment"># config/simulation.py</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_simulation_overrides</span>():
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;camera_step&quot;</span>: {<span class="hljs-string">&quot;camera_interface&quot;</span>: SimCamera()},
        <span class="hljs-string">&quot;physics_step&quot;</span>: {<span class="hljs-string">&quot;engine&quot;</span>: SimPhysics()},
        <span class="hljs-string">&quot;control_step&quot;</span>: {<span class="hljs-string">&quot;safety_limits&quot;</span>: <span class="hljs-literal">False</span>}
    }

<span class="hljs-comment"># config/production.py</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_production_overrides</span>():
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;camera_step&quot;</span>: {<span class="hljs-string">&quot;camera_interface&quot;</span>: RealCamera(<span class="hljs-string">&quot;/dev/video0&quot;</span>)},
        <span class="hljs-string">&quot;physics_step&quot;</span>: {<span class="hljs-string">&quot;engine&quot;</span>: RealPhysics()},
        <span class="hljs-string">&quot;control_step&quot;</span>: {<span class="hljs-string">&quot;safety_limits&quot;</span>: <span class="hljs-literal">True</span>}
    }

<span class="hljs-comment"># Usage</span>
<span class="hljs-keyword">from</span> config.production <span class="hljs-keyword">import</span> get_production_overrides
processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;shared/processor&quot;</span>,
    overrides=get_production_overrides()
)`,wrap:!1}}),$s=new U({props:{title:"Integration with Hub Sharing",local:"integration-with-hub-sharing",headingTag:"h3"}}),Ks=new w({props:{code:"JTIzJTIwU2F2ZSUyMHByb2Nlc3NvciUyMHdpdGhvdXQlMjBub24tc2VyaWFsaXphYmxlJTIwb2JqZWN0cyUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJteS1sYWIlMkZyb2JvdC1wcm9jZXNzb3IlMjIpJTBBJTBBJTIzJTIwQW55b25lJTIwY2FuJTIwbG9hZCUyMGFuZCUyMHByb3ZpZGUlMjB0aGVpciUyMG93biUyMGVudmlyb25tZW50JTBBaW1wb3J0JTIwZ3ltJTBBbG9jYWxfZW52JTIwJTNEJTIwZ3ltLm1ha2UoJTIyTXlSb2JvdEVudi12MSUyMiklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybXktbGFiJTJGcm9ib3QtcHJvY2Vzc29yJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3ZlcnJpZGVzJTNEJTdCJTIyZW52X3N0ZXAlMjIlM0ElMjAlN0IlMjJlbnYlMjIlM0ElMjBsb2NhbF9lbnYlN0QlN0QlMEEp",highlighted:`<span class="hljs-comment"># Save processor without non-serializable objects</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-lab/robot-processor&quot;</span>)

<span class="hljs-comment"># Anyone can load and provide their own environment</span>
<span class="hljs-keyword">import</span> gym
local_env = gym.make(<span class="hljs-string">&quot;MyRobotEnv-v1&quot;</span>)

processor = RobotProcessor.from_pretrained(
    <span class="hljs-string">&quot;my-lab/robot-processor&quot;</span>,
    overrides={<span class="hljs-string">&quot;env_step&quot;</span>: {<span class="hljs-string">&quot;env&quot;</span>: local_env}}
)`,wrap:!1}}),Ds=new U({props:{title:"Complete Example: Device-Aware Processing Pipeline",local:"complete-example-device-aware-processing-pipeline",headingTag:"h2"}}),Os=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor, ProcessorStepRegistry, TransitionKey
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;device_mover&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DeviceMover</span>:
    <span class="hljs-string">&quot;&quot;&quot;Move all tensors to specified device.&quot;&quot;&quot;</span>

    device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cuda&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition.get(TransitionKey.OBSERVATION)

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Move all tensor observations to device</span>
        processed_obs = <span class="hljs-built_in">dict</span>(obs)  <span class="hljs-comment"># Create a copy</span>
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> processed_obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                processed_obs[key] = value.to(self.device)

        <span class="hljs-comment"># Also handle action if present</span>
        action = transition.get(TransitionKey.ACTION)
        <span class="hljs-keyword">if</span> action <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> <span class="hljs-built_in">isinstance</span>(action, torch.Tensor):
            action = action.to(self.device)
            new_transition = transition.copy()
            new_transition[TransitionKey.OBSERVATION] = processed_obs
            new_transition[TransitionKey.ACTION] = action
            <span class="hljs-keyword">return</span> new_transition

        new_transition = transition.copy()
        new_transition[TransitionKey.OBSERVATION] = processed_obs
        <span class="hljs-keyword">return</span> new_transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-built_in">str</span>(self.device)}

<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;running_normalizer&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RunningNormalizer</span>:
    <span class="hljs-string">&quot;&quot;&quot;Normalize using running statistics with proper device handling.&quot;&quot;&quot;</span>

    feature_dim: <span class="hljs-built_in">int</span>
    momentum: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.1</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__post_init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># Initialize as None - will be created on first call with correct device</span>
        self.running_mean = <span class="hljs-literal">None</span>
        self.running_var = <span class="hljs-literal">None</span>
        self.initialized = <span class="hljs-literal">False</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition.get(TransitionKey.OBSERVATION)

        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;observation.state&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> obs:
            <span class="hljs-keyword">return</span> transition

        state = obs[<span class="hljs-string">&quot;observation.state&quot;</span>]

        <span class="hljs-comment"># Initialize on first call with correct device</span>
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.initialized:
            device = state.device
            self.running_mean = torch.zeros(self.feature_dim, device=device)
            self.running_var = torch.ones(self.feature_dim, device=device)
            self.initialized = <span class="hljs-literal">True</span>

        <span class="hljs-comment"># Update statistics</span>
        <span class="hljs-keyword">with</span> torch.no_grad():
            batch_mean = state.mean(dim=<span class="hljs-number">0</span>)
            batch_var = state.var(dim=<span class="hljs-number">0</span>, unbiased=<span class="hljs-literal">False</span>)

            self.running_mean = (<span class="hljs-number">1</span> - self.momentum) * self.running_mean + self.momentum * batch_mean
            self.running_var = (<span class="hljs-number">1</span> - self.momentum) * self.running_var + self.momentum * batch_var

        <span class="hljs-comment"># Normalize</span>
        state_normalized = (state - self.running_mean) / (self.running_var + <span class="hljs-number">1e-8</span>).sqrt()
        processed_obs = <span class="hljs-built_in">dict</span>(obs)  <span class="hljs-comment"># Create a copy</span>
        processed_obs[<span class="hljs-string">&quot;observation.state&quot;</span>] = state_normalized

        new_transition = transition.copy()
        new_transition[TransitionKey.OBSERVATION] = processed_obs
        <span class="hljs-keyword">return</span> new_transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;feature_dim&quot;</span>: self.feature_dim,
            <span class="hljs-string">&quot;momentum&quot;</span>: self.momentum,
            <span class="hljs-string">&quot;initialized&quot;</span>: self.initialized
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.initialized:
            <span class="hljs-keyword">return</span> {}
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;running_mean&quot;</span>: self.running_mean,
            <span class="hljs-string">&quot;running_var&quot;</span>: self.running_var
        }

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">if</span> state:
            self.running_mean = state[<span class="hljs-string">&quot;running_mean&quot;</span>]
            self.running_var = state[<span class="hljs-string">&quot;running_var&quot;</span>]
            self.initialized = <span class="hljs-literal">True</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">reset</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-comment"># Don&#x27;t reset statistics - they persist across episodes</span>
        <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Create a complete pipeline</span>
processor = RobotProcessor([
    ImageProcessor(),      <span class="hljs-comment"># Convert images to float32 [0,1]</span>
    StateProcessor(),      <span class="hljs-comment"># Convert states to torch tensors</span>
    ImagePadder(target_height=<span class="hljs-number">224</span>, target_width=<span class="hljs-number">224</span>), <span class="hljs-comment"># Pad images to standard size</span>
    DeviceMover(<span class="hljs-string">&quot;cuda&quot;</span>),   <span class="hljs-comment"># Move everything to GPU</span>
    RunningNormalizer(<span class="hljs-number">7</span>),  <span class="hljs-comment"># Normalize states</span>
], name=<span class="hljs-string">&quot;CompletePreprocessor&quot;</span>)

<span class="hljs-comment"># The processor handles device transfers automatically</span>
processor = processor.to(<span class="hljs-string">&quot;cuda&quot;</span>)  <span class="hljs-comment"># Moves all stateful components to GPU</span>

<span class="hljs-comment"># Use it</span>
obs = {
    <span class="hljs-string">&quot;pixels&quot;</span>: {<span class="hljs-string">&quot;cam&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, (<span class="hljs-number">200</span>, <span class="hljs-number">300</span>, <span class="hljs-number">3</span>), dtype=np.uint8)},
    <span class="hljs-string">&quot;agent_pos&quot;</span>: np.random.randn(<span class="hljs-number">7</span>).astype(np.float32)
}
transition = {
    TransitionKey.OBSERVATION: obs,
    TransitionKey.ACTION: <span class="hljs-literal">None</span>,
    TransitionKey.REWARD: <span class="hljs-number">0.0</span>,
    TransitionKey.DONE: <span class="hljs-literal">False</span>,
    TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,
    TransitionKey.INFO: {},
    TransitionKey.COMPLEMENTARY_DATA: {}
}

<span class="hljs-comment"># Everything is processed and on GPU</span>
processed = processor(transition)
<span class="hljs-built_in">print</span>(processed[TransitionKey.OBSERVATION][<span class="hljs-string">&quot;observation.images.cam&quot;</span>].device)  <span class="hljs-comment"># cuda:0</span>`,wrap:!1}}),la=new U({props:{title:"Solving Real-World Problems with RobotProcessor",local:"solving-real-world-problems-with-robotprocessor",headingTag:"h2"}}),aa=new U({props:{title:"Renaming Observation Keys",local:"renaming-observation-keys",headingTag:"h3"}}),na=new w({props:{code:"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",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;key_remapper&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">KeyRemapper</span>:
    <span class="hljs-string">&quot;&quot;&quot;Rename observation keys to match policy expectations.&quot;&quot;&quot;</span>

    key_mapping: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>] = field(default_factory=<span class="hljs-keyword">lambda</span>: {
        <span class="hljs-string">&quot;rgb_camera_front&quot;</span>: <span class="hljs-string">&quot;observation.images.wrist&quot;</span>,
        <span class="hljs-string">&quot;joint_positions&quot;</span>: <span class="hljs-string">&quot;observation.state&quot;</span>,
        <span class="hljs-string">&quot;gripper_state&quot;</span>: <span class="hljs-string">&quot;observation.gripper&quot;</span>
    })

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition.get(TransitionKey.OBSERVATION)
        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        <span class="hljs-comment"># Create new observation with renamed keys</span>
        processed_obs = <span class="hljs-built_in">dict</span>(obs)  <span class="hljs-comment"># Create a copy</span>
        renamed_obs = {}
        <span class="hljs-keyword">for</span> old_key, new_key <span class="hljs-keyword">in</span> self.key_mapping.items():
            <span class="hljs-keyword">if</span> old_key <span class="hljs-keyword">in</span> processed_obs:
                renamed_obs[new_key] = processed_obs[old_key]

        <span class="hljs-comment"># Keep any unmapped keys as-is</span>
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> processed_obs.items():
            <span class="hljs-keyword">if</span> key <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> self.key_mapping:
                renamed_obs[key] = value

        new_transition = transition.copy()
        new_transition[TransitionKey.OBSERVATION] = renamed_obs
        <span class="hljs-keyword">return</span> new_transition`,wrap:!1}}),ta=new U({props:{title:"Workspace-Focused Image Processing",local:"workspace-focused-image-processing",headingTag:"h3"}}),ya=new w({props:{code:"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",highlighted:`<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;workspace_cropper&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">WorkspaceCropper</span>:
    <span class="hljs-string">&quot;&quot;&quot;Crop and resize images to focus on robot workspace.&quot;&quot;&quot;</span>

    crop_bbox: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>] = (<span class="hljs-number">400</span>, <span class="hljs-number">200</span>, <span class="hljs-number">1200</span>, <span class="hljs-number">800</span>)  <span class="hljs-comment"># (x1, y1, x2, y2)</span>
    output_size: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>] = (<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        obs = transition.get(TransitionKey.OBSERVATION)
        <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">return</span> transition

        processed_obs = <span class="hljs-built_in">dict</span>(obs)  <span class="hljs-comment"># Create a copy</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(processed_obs.keys()):
            <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;observation.images.&quot;</span>):
                img = processed_obs[key]
                <span class="hljs-comment"># Crop to workspace</span>
                x1, y1, x2, y2 = self.crop_bbox
                img_cropped = img[:, :, y1:y2, x1:x2]
                <span class="hljs-comment"># Resize to expected dimensions</span>
                img_resized = F.interpolate(
                    img_cropped,
                    size=self.output_size,
                    mode=<span class="hljs-string">&#x27;bilinear&#x27;</span>,
                    align_corners=<span class="hljs-literal">False</span>
                )
                processed_obs[key] = img_resized

        new_transition = transition.copy()
        new_transition[TransitionKey.OBSERVATION] = processed_obs
        <span class="hljs-keyword">return</span> new_transition`,wrap:!1}}),Ja=new U({props:{title:"Building Complete Pipelines for Different Robots",local:"building-complete-pipelines-for-different-robots",headingTag:"h3"}}),ja=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Pipeline for Robot A with wrist camera</span>
robot_a_processor = RobotProcessor([
    <span class="hljs-comment"># Observation preprocessing</span>
    KeyRemapper({
        <span class="hljs-string">&quot;wrist_rgb&quot;</span>: <span class="hljs-string">&quot;observation.images.wrist&quot;</span>,
        <span class="hljs-string">&quot;arm_joints&quot;</span>: <span class="hljs-string">&quot;observation.state&quot;</span>
    }),
    ImageProcessor(),
    WorkspaceCropper(crop_bbox=(<span class="hljs-number">300</span>, <span class="hljs-number">100</span>, <span class="hljs-number">900</span>, <span class="hljs-number">700</span>), output_size=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)),
    StateProcessor(),
    VelocityCalculator(state_key=<span class="hljs-string">&quot;observation.state&quot;</span>),
    DeviceMover(<span class="hljs-string">&quot;cuda&quot;</span>),

    <span class="hljs-comment"># Action postprocessing</span>
    ActionSmoother(alpha=<span class="hljs-number">0.2</span>),
], name=<span class="hljs-string">&quot;RobotA_ACT_Processor&quot;</span>)

<span class="hljs-comment"># Pipeline for Robot B with overhead camera</span>
robot_b_processor = RobotProcessor([
    <span class="hljs-comment"># Different key mapping for Robot B</span>
    KeyRemapper({
        <span class="hljs-string">&quot;overhead_cam&quot;</span>: <span class="hljs-string">&quot;observation.images.wrist&quot;</span>,  <span class="hljs-comment"># Reuse same policy!</span>
        <span class="hljs-string">&quot;joint_encoders&quot;</span>: <span class="hljs-string">&quot;observation.state&quot;</span>
    }),
    ImageProcessor(),
    WorkspaceCropper(crop_bbox=(<span class="hljs-number">100</span>, <span class="hljs-number">50</span>, <span class="hljs-number">1100</span>, <span class="hljs-number">950</span>), output_size=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)),
    StateProcessor(),
    VelocityCalculator(state_key=<span class="hljs-string">&quot;observation.state&quot;</span>),
    DeviceMover(<span class="hljs-string">&quot;cuda&quot;</span>),

    ActionSmoother(alpha=<span class="hljs-number">0.3</span>),  <span class="hljs-comment"># Different smoothing</span>
], name=<span class="hljs-string">&quot;RobotB_ACT_Processor&quot;</span>)

<span class="hljs-comment"># Share processors with the community</span>
robot_a_processor.push_to_hub(<span class="hljs-string">&quot;my-lab/robot-a-act-processor&quot;</span>)
robot_b_processor.push_to_hub(<span class="hljs-string">&quot;my-lab/robot-b-act-processor&quot;</span>)

<span class="hljs-comment"># Now anyone can use the same preprocessing</span>
processor = RobotProcessor.from_pretrained(<span class="hljs-string">&quot;my-lab/robot-a-act-processor&quot;</span>)`,wrap:!1}}),Ta=new U({props:{title:"Best Practices for Processor Steps",local:"best-practices-for-processor-steps",headingTag:"h2"}}),ca=new U({props:{title:"1. Always Check for None",local:"1-always-check-for-none",headingTag:"h3"}}),Ua=new w({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwb2JzJTIwJTNEJTIwdHJhbnNpdGlvbi5nZXQoVHJhbnNpdGlvbktleS5PQlNFUlZBVElPTiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBjaGVjayUyMGlmJTIwb2JzZXJ2YXRpb24lMjBleGlzdHMlMEElMjAlMjAlMjAlMjBpZiUyMG9icyUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHRyYW5zaXRpb24lMEElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHNvJTIwY2hlY2slMjBmb3IlMjBzcGVjaWZpYyUyMGtleXMlMEElMjAlMjAlMjAlMjBpZiUyMCUyMm9ic2VydmF0aW9uLnN0YXRlJTIyJTIwbm90JTIwaW4lMjBvYnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFuc2l0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
    obs = transition.get(TransitionKey.OBSERVATION)

    <span class="hljs-comment"># Always check if observation exists</span>
    <span class="hljs-keyword">if</span> obs <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> transition

    <span class="hljs-comment"># Also check for specific keys</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;observation.state&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> obs:
        <span class="hljs-keyword">return</span> transition`,wrap:!1}}),wa=new U({props:{title:"2. Preserve Transition Structure",local:"2-preserve-transition-structure",headingTag:"h3"}}),ra=new w({props:{code:"JTIzJTIwR29vZCUyMC0lMjBwcmVzZXJ2ZSUyMGFsbCUyMGVsZW1lbnRzJTBBcmV0dXJuJTIwKG1vZGlmaWVkX29icyUyQyUyMCp0cmFuc2l0aW9uJTVCMSUzQSU1RCklMEElMEElMjMlMjBCYWQlMjAtJTIwbG9zaW5nJTIwaW5mb3JtYXRpb24lMEFyZXR1cm4lMjAobW9kaWZpZWRfb2JzJTJDJTIwTm9uZSUyQyUyMDAuMCUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAlN0IlN0QlMkMlMjAlN0IlN0Qp",highlighted:`<span class="hljs-comment"># Good - preserve all elements</span>
<span class="hljs-keyword">return</span> (modified_obs, *transition[<span class="hljs-number">1</span>:])

<span class="hljs-comment"># Bad - losing information</span>
<span class="hljs-keyword">return</span> (modified_obs, <span class="hljs-literal">None</span>, <span class="hljs-number">0.0</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>, {}, {})`,wrap:!1}}),Ia=new U({props:{title:"3. Clone When Storing State",local:"3-clone-when-storing-state",headingTag:"h3"}}),ma=new w({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwb2JzJTIwJTNEJTIwdHJhbnNpdGlvbi5nZXQoVHJhbnNpdGlvbktleS5PQlNFUlZBVElPTiklMEElMEElMjAlMjAlMjAlMjBpZiUyMHNlbGYuc3RvcmVfcHJldmlvdXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHb29kJTIwLSUyMGNsb25lJTIwdG8lMjBhdm9pZCUyMHJlZmVyZW5jZSUyMGlzc3VlcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucHJldmlvdXNfc3RhdGUlMjAlM0QlMjBvYnMlNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiU1RC5jbG9uZSgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQmFkJTIwLSUyMHN0b3JlcyUyMHJlZmVyZW5jZSUyMHRoYXQlMjBtaWdodCUyMGJlJTIwbW9kaWZpZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBzZWxmLnByZXZpb3VzX3N0YXRlJTIwJTNEJTIwb2JzJTVCJTIyb2JzZXJ2YXRpb24uc3RhdGUlMjIlNUQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
    obs = transition.get(TransitionKey.OBSERVATION)

    <span class="hljs-keyword">if</span> self.store_previous:
        <span class="hljs-comment"># Good - clone to avoid reference issues</span>
        self.previous_state = obs[<span class="hljs-string">&quot;observation.state&quot;</span>].clone()

        <span class="hljs-comment"># Bad - stores reference that might be modified</span>
        <span class="hljs-comment"># self.previous_state = obs[&quot;observation.state&quot;]</span>`,wrap:!1}}),Ca=new U({props:{title:"4. Handle Device Transfers in state_dict",local:"4-handle-device-transfers-in-statedict",headingTag:"h3"}}),da=new w({props:{code:"ZGVmJTIwc3RhdGVfZGljdChzZWxmKSUyMC0lM0UlMjBEaWN0JTVCc3RyJTJDJTIwdG9yY2guVGVuc29yJTVEJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmJ1ZmZlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiU3RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEdvb2QlMjAtJTIwY2xvbmUlMjB0byUyMGF2b2lkJTIwbWVtb3J5JTIwc2hhcmluZyUyMGlzc3VlcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmJ1ZmZlciUyMiUzQSUyMHNlbGYuYnVmZmVyLmNsb25lKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
    <span class="hljs-keyword">if</span> self.buffer <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> {}

    <span class="hljs-comment"># Good - clone to avoid memory sharing issues</span>
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;buffer&quot;</span>: self.buffer.clone()}`,wrap:!1}}),ua=new U({props:{title:"Complete Policy Example with Pre and Post Processing",local:"complete-policy-example-with-pre-and-post-processing",headingTag:"h2"}}),ha=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessor, ProcessorStepRegistry, TransitionKey
<span class="hljs-keyword">from</span> lerobot.policies.act.modeling_act <span class="hljs-keyword">import</span> ACTPolicy
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time

<span class="hljs-comment"># Create preprocessing pipeline</span>
preprocessor = RobotProcessor([
    ImageProcessor(),
    StateProcessor(),
    ImagePadder(target_height=<span class="hljs-number">224</span>, target_width=<span class="hljs-number">224</span>),
    DeviceMover(<span class="hljs-string">&quot;cuda&quot;</span>),
    RunningNormalizer(feature_dim=<span class="hljs-number">14</span>),  <span class="hljs-comment"># For 14-DOF robot</span>
], name=<span class="hljs-string">&quot;ACTPreprocessor&quot;</span>)

<span class="hljs-comment"># Create postprocessing pipeline for actions</span>
<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;action_clipper&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ActionClipper</span>:
    <span class="hljs-string">&quot;&quot;&quot;Clip actions to safe ranges.&quot;&quot;&quot;</span>
    min_value: <span class="hljs-built_in">float</span> = -<span class="hljs-number">1.0</span>
    max_value: <span class="hljs-built_in">float</span> = <span class="hljs-number">1.0</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        action = transition.get(TransitionKey.ACTION)

        <span class="hljs-keyword">if</span> action <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            action = torch.clamp(action, self.min_value, self.max_value)
            new_transition = transition.copy()
            new_transition[TransitionKey.ACTION] = action
            <span class="hljs-keyword">return</span> new_transition

        <span class="hljs-keyword">return</span> transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;min_value&quot;</span>: self.min_value, <span class="hljs-string">&quot;max_value&quot;</span>: self.max_value}

postprocessor = RobotProcessor([
    ActionClipper(min_value=-<span class="hljs-number">0.5</span>, max_value=<span class="hljs-number">0.5</span>),
    ActionSmoother(alpha=<span class="hljs-number">0.3</span>),
], name=<span class="hljs-string">&quot;ACTPostprocessor&quot;</span>)

<span class="hljs-comment"># Load policy</span>
policy = ACTPolicy.from_pretrained(<span class="hljs-string">&quot;lerobot/act_aloha_sim_transfer_cube_human&quot;</span>)

<span class="hljs-comment"># Move everything to GPU</span>
preprocessor = preprocessor.to(<span class="hljs-string">&quot;cuda&quot;</span>)
postprocessor = postprocessor.to(<span class="hljs-string">&quot;cuda&quot;</span>)
policy = policy.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Control loop using EnvTransition format</span>
env = make_robot_env()
obs, info = env.reset()

<span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Episode <span class="hljs-subst">{episode + <span class="hljs-number">1</span>}</span>&quot;</span>)

    <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-comment"># Create transition with raw observation</span>
        transition = {
            TransitionKey.OBSERVATION: obs,
            TransitionKey.ACTION: <span class="hljs-literal">None</span>,
            TransitionKey.REWARD: <span class="hljs-number">0.0</span>,
            TransitionKey.DONE: <span class="hljs-literal">False</span>,
            TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,
            TransitionKey.INFO: info,
            TransitionKey.COMPLEMENTARY_DATA: {<span class="hljs-string">&quot;step&quot;</span>: step}
        }

        <span class="hljs-comment"># Preprocess - works with dictionary format</span>
        processed_transition = preprocessor(transition)
        processed_obs = processed_transition.get(TransitionKey.OBSERVATION)

        <span class="hljs-comment"># Get action from policy</span>
        <span class="hljs-keyword">with</span> torch.no_grad():
            action = policy.select_action(processed_obs)

        <span class="hljs-comment"># Postprocess action</span>
        action_transition = {
            TransitionKey.OBSERVATION: processed_obs,
            TransitionKey.ACTION: action,
            TransitionKey.REWARD: <span class="hljs-number">0.0</span>,
            TransitionKey.DONE: <span class="hljs-literal">False</span>,
            TransitionKey.TRUNCATED: <span class="hljs-literal">False</span>,
            TransitionKey.INFO: info,
            TransitionKey.COMPLEMENTARY_DATA: {<span class="hljs-string">&quot;raw_action&quot;</span>: action.clone()}  <span class="hljs-comment"># Store raw action in complementary_data</span>
        }
        processed_action_transition = postprocessor(action_transition)
        final_action = processed_action_transition.get(TransitionKey.ACTION)

        <span class="hljs-comment"># Execute action</span>
        obs, reward, terminated, truncated, info = env.step(final_action.cpu().numpy())

        <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
            <span class="hljs-comment"># Reset at episode boundary</span>
            preprocessor.reset()
            postprocessor.reset()
            obs, info = env.reset()
            <span class="hljs-keyword">break</span>

    <span class="hljs-comment"># Save preprocessor with learned statistics</span>
    preprocessor.save_pretrained(<span class="hljs-string">f&quot;./checkpoints/preprocessor_ep<span class="hljs-subst">{episode}</span>&quot;</span>)

<span class="hljs-comment"># Alternative: Using batch dictionary format</span>
<span class="hljs-comment"># This is useful when integrating with existing LeRobot training code</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">control_loop_with_batch_format</span>():
    <span class="hljs-string">&quot;&quot;&quot;Example using batch dictionary format.&quot;&quot;&quot;</span>
    obs, info = env.reset()

    <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-comment"># Create batch dictionary</span>
        batch = {
            <span class="hljs-string">&quot;observation.image&quot;</span>: torch.from_numpy(obs[<span class="hljs-string">&quot;pixels&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>),
            <span class="hljs-string">&quot;observation.state&quot;</span>: torch.from_numpy(obs[<span class="hljs-string">&quot;agent_pos&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>),
            <span class="hljs-string">&quot;action&quot;</span>: torch.zeros(<span class="hljs-number">1</span>, <span class="hljs-number">7</span>),  <span class="hljs-comment"># Placeholder</span>
            <span class="hljs-string">&quot;next.reward&quot;</span>: torch.tensor([<span class="hljs-number">0.0</span>]),
            <span class="hljs-string">&quot;next.done&quot;</span>: torch.tensor([<span class="hljs-literal">False</span>]),
            <span class="hljs-string">&quot;next.truncated&quot;</span>: torch.tensor([<span class="hljs-literal">False</span>]),
            <span class="hljs-string">&quot;info&quot;</span>: info,
        }

        <span class="hljs-comment"># Preprocess - works with batch format</span>
        processed_batch = preprocessor(batch)

        <span class="hljs-comment"># Get action from policy</span>
        <span class="hljs-keyword">with</span> torch.no_grad():
            action = policy.select_action({
                k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> processed_batch.items()
                <span class="hljs-keyword">if</span> k.startswith(<span class="hljs-string">&quot;observation.&quot;</span>)
            })

        <span class="hljs-comment"># Add action to batch for postprocessing</span>
        processed_batch[<span class="hljs-string">&quot;action&quot;</span>] = action

        <span class="hljs-comment"># Postprocess</span>
        final_batch = postprocessor(processed_batch)
        final_action = final_batch[<span class="hljs-string">&quot;action&quot;</span>]

        <span class="hljs-comment"># Execute action</span>
        obs, reward, terminated, truncated, info = env.step(final_action.cpu().numpy())

        <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
            <span class="hljs-keyword">break</span>

<span class="hljs-comment"># Push final version to hub</span>
preprocessor.push_to_hub(<span class="hljs-string">&quot;my-username/act-preprocessor&quot;</span>)
postprocessor.push_to_hub(<span class="hljs-string">&quot;my-username/act-postprocessor&quot;</span>)`,wrap:!1}}),Aa=new U({props:{title:"Debugging and Monitoring",local:"debugging-and-monitoring",headingTag:"h2"}}),Za=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Enable detailed logging</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">log_observation_shapes</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    obs = transition.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{step_idx}</span> observations:&quot;</span>)
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{key}</span>: shape=<span class="hljs-subst">{value.shape}</span>, device=<span class="hljs-subst">{value.device}</span>, dtype=<span class="hljs-subst">{value.dtype}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>

processor.register_after_step_hook(log_observation_shapes)

<span class="hljs-comment"># Monitor complementary data flow</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">monitor_complementary_data</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    comp_data = transition.get(TransitionKey.COMPLEMENTARY_DATA)
    <span class="hljs-keyword">if</span> comp_data:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{step_idx}</span> complementary_data: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(comp_data.keys())}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>

processor.register_before_step_hook(monitor_complementary_data)

<span class="hljs-comment"># Validate data integrity</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">validate_tensors</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    obs = transition.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                <span class="hljs-keyword">if</span> torch.isnan(value).<span class="hljs-built_in">any</span>():
                    <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;NaN detected in <span class="hljs-subst">{key}</span> after step <span class="hljs-subst">{step_idx}</span>&quot;</span>)
                <span class="hljs-keyword">if</span> torch.isinf(value).<span class="hljs-built_in">any</span>():
                    <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Inf detected in <span class="hljs-subst">{key}</span> after step <span class="hljs-subst">{step_idx}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>

processor.register_after_step_hook(validate_tensors)`,wrap:!1}}),Na=new U({props:{title:"Summary",local:"summary",headingTag:"h2"}}),Va=new Xy({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/processor_tutorial.mdx"}}),{c(){r=i("meta"),ka=n(),ga=i("p"),Qa=n(),e(I.$$.fragment),Ya=n(),m=i("p"),m.textContent=ye,Sa=n(),C=i("p"),C.innerHTML=Je,za=n(),d=i("ol"),d.innerHTML=pe,Fa=n(),e(u.$$.fragment),_a=n(),b=i("p"),b.textContent=je,Ha=n(),e(h.$$.fragment),qa=n(),A=i("p"),A.innerHTML=oe,$a=n(),e(B.$$.fragment),xa=n(),Z=i("p"),Z.textContent=ie,Ka=n(),N=i("ul"),N.innerHTML=Te,La=n(),e(R.$$.fragment),Da=n(),E=i("p"),E.textContent=ce,Pa=n(),f=i("ul"),f.innerHTML=Ue,Oa=n(),e(v.$$.fragment),lM=n(),G=i("p"),G.textContent=we,sM=n(),W=i("ul"),W.innerHTML=re,aM=n(),e(V.$$.fragment),MM=n(),g=i("p"),g.textContent=Ie,nM=n(),X=i("ul"),X.innerHTML=me,tM=n(),e(k.$$.fragment),eM=n(),Q=i("p"),Q.textContent=Ce,yM=n(),Y=i("ul"),Y.innerHTML=de,JM=n(),S=i("p"),S.textContent=ue,pM=n(),e(z.$$.fragment),jM=n(),F=i("p"),F.textContent=be,oM=n(),e(_.$$.fragment),iM=n(),H=i("p"),H.textContent=he,TM=n(),q=i("ul"),q.innerHTML=Ae,cM=n(),$=i("p"),$.textContent=Be,UM=n(),e(x.$$.fragment),wM=n(),K=i("p"),K.textContent=Ze,rM=n(),e(L.$$.fragment),IM=n(),D=i("p"),D.innerHTML=Ne,mM=n(),e(P.$$.fragment),CM=n(),e(O.$$.fragment),dM=n(),ll=i("p"),ll.textContent=Re,uM=n(),e(sl.$$.fragment),bM=n(),e(al.$$.fragment),hM=n(),Ml=i("p"),Ml.textContent=Ee,AM=n(),e(nl.$$.fragment),BM=n(),e(tl.$$.fragment),ZM=n(),el=i("p"),el.innerHTML=fe,NM=n(),e(yl.$$.fragment),RM=n(),e(Jl.$$.fragment),EM=n(),pl=i("p"),pl.textContent=ve,fM=n(),e(jl.$$.fragment),vM=n(),e(ol.$$.fragment),GM=n(),il=i("p"),il.textContent=Ge,WM=n(),e(Tl.$$.fragment),VM=n(),e(cl.$$.fragment),gM=n(),Ul=i("p"),Ul.innerHTML=We,XM=n(),e(wl.$$.fragment),kM=n(),e(rl.$$.fragment),QM=n(),Il=i("p"),Il.textContent=Ve,YM=n(),e(ml.$$.fragment),SM=n(),e(Cl.$$.fragment),zM=n(),dl=i("p"),dl.innerHTML=ge,FM=n(),ul=i("ul"),ul.innerHTML=Xe,_M=n(),bl=i("p"),bl.innerHTML=ke,HM=n(),hl=i("ul"),hl.innerHTML=Qe,qM=n(),e(Al.$$.fragment),$M=n(),e(Bl.$$.fragment),xM=n(),Zl=i("p"),Zl.textContent=Ye,KM=n(),e(Nl.$$.fragment),LM=n(),e(Rl.$$.fragment),DM=n(),El=i("p"),El.textContent=Se,PM=n(),e(fl.$$.fragment),OM=n(),e(vl.$$.fragment),ln=n(),Gl=i("p"),Gl.textContent=ze,sn=n(),e(Wl.$$.fragment),an=n(),e(Vl.$$.fragment),Mn=n(),gl=i("p"),gl.textContent=Fe,nn=n(),e(Xl.$$.fragment),tn=n(),e(kl.$$.fragment),en=n(),Ql=i("p"),Ql.textContent=_e,yn=n(),e(Yl.$$.fragment),Jn=n(),e(Sl.$$.fragment),pn=n(),zl=i("p"),zl.textContent=He,jn=n(),e(Fl.$$.fragment),on=n(),e(_l.$$.fragment),Tn=n(),Hl=i("p"),Hl.innerHTML=qe,cn=n(),e(ql.$$.fragment),Un=n(),e($l.$$.fragment),wn=n(),xl=i("p"),xl.textContent=$e,rn=n(),e(Kl.$$.fragment),In=n(),Ll=i("p"),Ll.textContent=xe,mn=n(),e(Dl.$$.fragment),Cn=n(),Pl=i("p"),Pl.innerHTML=Ke,dn=n(),e(Ol.$$.fragment),un=n(),ls=i("p"),ls.innerHTML=Le,bn=n(),e(ss.$$.fragment),hn=n(),e(as.$$.fragment),An=n(),Ms=i("p"),Ms.innerHTML=De,Bn=n(),ns=i("ul"),ns.innerHTML=Pe,Zn=n(),e(ts.$$.fragment),Nn=n(),es=i("p"),es.textContent=Oe,Rn=n(),ys=i("ol"),ys.innerHTML=ly,En=n(),e(Js.$$.fragment),fn=n(),e(ps.$$.fragment),vn=n(),e(js.$$.fragment),Gn=n(),e(os.$$.fragment),Wn=n(),e(is.$$.fragment),Vn=n(),e(Ts.$$.fragment),gn=n(),e(cs.$$.fragment),Xn=n(),e(Us.$$.fragment),kn=n(),ws=i("p"),ws.textContent=sy,Qn=n(),e(rs.$$.fragment),Yn=n(),Is=i("p"),Is.innerHTML=ay,Sn=n(),e(ms.$$.fragment),zn=n(),e(Cs.$$.fragment),Fn=n(),ds=i("p"),ds.textContent=My,_n=n(),e(us.$$.fragment),Hn=n(),e(bs.$$.fragment),qn=n(),hs=i("p"),hs.textContent=ny,$n=n(),e(As.$$.fragment),xn=n(),e(Bs.$$.fragment),Kn=n(),e(Zs.$$.fragment),Ln=n(),e(Ns.$$.fragment),Dn=n(),e(Rs.$$.fragment),Pn=n(),Es=i("p"),Es.textContent=ty,On=n(),e(fs.$$.fragment),lt=n(),vs=i("p"),vs.textContent=ey,st=n(),e(Gs.$$.fragment),at=n(),e(Ws.$$.fragment),Mt=n(),e(Vs.$$.fragment),nt=n(),gs=i("p"),gs.textContent=yy,tt=n(),e(Xs.$$.fragment),et=n(),e(ks.$$.fragment),yt=n(),Qs=i("p"),Qs.textContent=Jy,Jt=n(),e(Ys.$$.fragment),pt=n(),e(Ss.$$.fragment),jt=n(),zs=i("p"),zs.textContent=py,ot=n(),e(Fs.$$.fragment),it=n(),e(_s.$$.fragment),Tt=n(),Hs=i("p"),Hs.textContent=jy,ct=n(),e(qs.$$.fragment),Ut=n(),e($s.$$.fragment),wt=n(),xs=i("p"),xs.textContent=oy,rt=n(),e(Ks.$$.fragment),It=n(),Ls=i("p"),Ls.textContent=iy,mt=n(),e(Ds.$$.fragment),Ct=n(),Ps=i("p"),Ps.textContent=Ty,dt=n(),e(Os.$$.fragment),ut=n(),e(la.$$.fragment),bt=n(),sa=i("p"),sa.textContent=cy,ht=n(),e(aa.$$.fragment),At=n(),Ma=i("p"),Ma.textContent=Uy,Bt=n(),e(na.$$.fragment),Zt=n(),e(ta.$$.fragment),Nt=n(),ea=i("p"),ea.textContent=wy,Rt=n(),e(ya.$$.fragment),Et=n(),e(Ja.$$.fragment),ft=n(),pa=i("p"),pa.textContent=ry,vt=n(),e(ja.$$.fragment),Gt=n(),oa=i("p"),oa.textContent=Iy,Wt=n(),ia=i("ol"),ia.innerHTML=my,Vt=n(),e(Ta.$$.fragment),gt=n(),e(ca.$$.fragment),Xt=n(),e(Ua.$$.fragment),kt=n(),e(wa.$$.fragment),Qt=n(),e(ra.$$.fragment),Yt=n(),e(Ia.$$.fragment),St=n(),e(ma.$$.fragment),zt=n(),e(Ca.$$.fragment),Ft=n(),e(da.$$.fragment),_t=n(),e(ua.$$.fragment),Ht=n(),ba=i("p"),ba.textContent=Cy,qt=n(),e(ha.$$.fragment),$t=n(),e(Aa.$$.fragment),xt=n(),Ba=i("p"),Ba.innerHTML=dy,Kt=n(),e(Za.$$.fragment),Lt=n(),e(Na.$$.fragment),Dt=n(),Ra=i("p"),Ra.textContent=uy,Pt=n(),Ea=i("ul"),Ea.innerHTML=by,Ot=n(),fa=i("p"),fa.textContent=hy,le=n(),va=i("ul"),va.innerHTML=Ay,se=n(),Ga=i("p"),Ga.textContent=By,ae=n(),Wa=i("p"),Wa.innerHTML=Zy,Me=n(),e(Va.$$.fragment),ne=n(),Xa=i("p"),this.h()},l(l){const s=Vy("svelte-u9bgzb",document.head);r=T(s,"META",{name:!0,content:!0}),s.forEach(a),ka=t(l),ga=T(l,"P",{}),Ny(ga).forEach(a),Qa=t(l),y(I.$$.fragment,l),Ya=t(l),m=T(l,"P",{"data-svelte-h":!0}),c(m)!=="svelte-16ovulj"&&(m.textContent=ye),Sa=t(l),C=T(l,"P",{"data-svelte-h":!0}),c(C)!=="svelte-xo8ua7"&&(C.innerHTML=Je),za=t(l),d=T(l,"OL",{"data-svelte-h":!0}),c(d)!=="svelte-14gsfpg"&&(d.innerHTML=pe),Fa=t(l),y(u.$$.fragment,l),_a=t(l),b=T(l,"P",{"data-svelte-h":!0}),c(b)!=="svelte-kvhb1i"&&(b.textContent=je),Ha=t(l),y(h.$$.fragment,l),qa=t(l),A=T(l,"P",{"data-svelte-h":!0}),c(A)!=="svelte-tezn1r"&&(A.innerHTML=oe),$a=t(l),y(B.$$.fragment,l),xa=t(l),Z=T(l,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-d65w2e"&&(Z.textContent=ie),Ka=t(l),N=T(l,"UL",{"data-svelte-h":!0}),c(N)!=="svelte-be9yol"&&(N.innerHTML=Te),La=t(l),y(R.$$.fragment,l),Da=t(l),E=T(l,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1agogwi"&&(E.textContent=ce),Pa=t(l),f=T(l,"UL",{"data-svelte-h":!0}),c(f)!=="svelte-fcjkyc"&&(f.innerHTML=Ue),Oa=t(l),y(v.$$.fragment,l),lM=t(l),G=T(l,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1axr7bh"&&(G.textContent=we),sM=t(l),W=T(l,"UL",{"data-svelte-h":!0}),c(W)!=="svelte-cvl01e"&&(W.innerHTML=re),aM=t(l),y(V.$$.fragment,l),MM=t(l),g=T(l,"P",{"data-svelte-h":!0}),c(g)!=="svelte-15htyyt"&&(g.textContent=Ie),nM=t(l),X=T(l,"UL",{"data-svelte-h":!0}),c(X)!=="svelte-1nhg0be"&&(X.innerHTML=me),tM=t(l),y(k.$$.fragment,l),eM=t(l),Q=T(l,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-ku9g5b"&&(Q.textContent=Ce),yM=t(l),Y=T(l,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-sglc80"&&(Y.innerHTML=de),JM=t(l),S=T(l,"P",{"data-svelte-h":!0}),c(S)!=="svelte-pldmn"&&(S.textContent=ue),pM=t(l),y(z.$$.fragment,l),jM=t(l),F=T(l,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1q7iht5"&&(F.textContent=be),oM=t(l),y(_.$$.fragment,l),iM=t(l),H=T(l,"P",{"data-svelte-h":!0}),c(H)!=="svelte-l0tugm"&&(H.textContent=he),TM=t(l),q=T(l,"UL",{"data-svelte-h":!0}),c(q)!=="svelte-1j8spr5"&&(q.innerHTML=Ae),cM=t(l),$=T(l,"P",{"data-svelte-h":!0}),c($)!=="svelte-643t46"&&($.textContent=Be),UM=t(l),y(x.$$.fragment,l),wM=t(l),K=T(l,"P",{"data-svelte-h":!0}),c(K)!=="svelte-il9qki"&&(K.textContent=Ze),rM=t(l),y(L.$$.fragment,l),IM=t(l),D=T(l,"P",{"data-svelte-h":!0}),c(D)!=="svelte-iv3ap"&&(D.innerHTML=Ne),mM=t(l),y(P.$$.fragment,l),CM=t(l),y(O.$$.fragment,l),dM=t(l),ll=T(l,"P",{"data-svelte-h":!0}),c(ll)!=="svelte-12e7en9"&&(ll.textContent=Re),uM=t(l),y(sl.$$.fragment,l),bM=t(l),y(al.$$.fragment,l),hM=t(l),Ml=T(l,"P",{"data-svelte-h":!0}),c(Ml)!=="svelte-ji1fs7"&&(Ml.textContent=Ee),AM=t(l),y(nl.$$.fragment,l),BM=t(l),y(tl.$$.fragment,l),ZM=t(l),el=T(l,"P",{"data-svelte-h":!0}),c(el)!=="svelte-1n00b6w"&&(el.innerHTML=fe),NM=t(l),y(yl.$$.fragment,l),RM=t(l),y(Jl.$$.fragment,l),EM=t(l),pl=T(l,"P",{"data-svelte-h":!0}),c(pl)!=="svelte-bfip3"&&(pl.textContent=ve),fM=t(l),y(jl.$$.fragment,l),vM=t(l),y(ol.$$.fragment,l),GM=t(l),il=T(l,"P",{"data-svelte-h":!0}),c(il)!=="svelte-7rcxgy"&&(il.textContent=Ge),WM=t(l),y(Tl.$$.fragment,l),VM=t(l),y(cl.$$.fragment,l),gM=t(l),Ul=T(l,"P",{"data-svelte-h":!0}),c(Ul)!=="svelte-k46it3"&&(Ul.innerHTML=We),XM=t(l),y(wl.$$.fragment,l),kM=t(l),y(rl.$$.fragment,l),QM=t(l),Il=T(l,"P",{"data-svelte-h":!0}),c(Il)!=="svelte-1izad3p"&&(Il.textContent=Ve),YM=t(l),y(ml.$$.fragment,l),SM=t(l),y(Cl.$$.fragment,l),zM=t(l),dl=T(l,"P",{"data-svelte-h":!0}),c(dl)!=="svelte-uau8q1"&&(dl.innerHTML=ge),FM=t(l),ul=T(l,"UL",{"data-svelte-h":!0}),c(ul)!=="svelte-1flp2ov"&&(ul.innerHTML=Xe),_M=t(l),bl=T(l,"P",{"data-svelte-h":!0}),c(bl)!=="svelte-525nud"&&(bl.innerHTML=ke),HM=t(l),hl=T(l,"UL",{"data-svelte-h":!0}),c(hl)!=="svelte-1j9pije"&&(hl.innerHTML=Qe),qM=t(l),y(Al.$$.fragment,l),$M=t(l),y(Bl.$$.fragment,l),xM=t(l),Zl=T(l,"P",{"data-svelte-h":!0}),c(Zl)!=="svelte-y9nyoq"&&(Zl.textContent=Ye),KM=t(l),y(Nl.$$.fragment,l),LM=t(l),y(Rl.$$.fragment,l),DM=t(l),El=T(l,"P",{"data-svelte-h":!0}),c(El)!=="svelte-r9z2ng"&&(El.textContent=Se),PM=t(l),y(fl.$$.fragment,l),OM=t(l),y(vl.$$.fragment,l),ln=t(l),Gl=T(l,"P",{"data-svelte-h":!0}),c(Gl)!=="svelte-cuz5jq"&&(Gl.textContent=ze),sn=t(l),y(Wl.$$.fragment,l),an=t(l),y(Vl.$$.fragment,l),Mn=t(l),gl=T(l,"P",{"data-svelte-h":!0}),c(gl)!=="svelte-1th7p1r"&&(gl.textContent=Fe),nn=t(l),y(Xl.$$.fragment,l),tn=t(l),y(kl.$$.fragment,l),en=t(l),Ql=T(l,"P",{"data-svelte-h":!0}),c(Ql)!=="svelte-qo4qpu"&&(Ql.textContent=_e),yn=t(l),y(Yl.$$.fragment,l),Jn=t(l),y(Sl.$$.fragment,l),pn=t(l),zl=T(l,"P",{"data-svelte-h":!0}),c(zl)!=="svelte-8dvr44"&&(zl.textContent=He),jn=t(l),y(Fl.$$.fragment,l),on=t(l),y(_l.$$.fragment,l),Tn=t(l),Hl=T(l,"P",{"data-svelte-h":!0}),c(Hl)!=="svelte-1jmnnok"&&(Hl.innerHTML=qe),cn=t(l),y(ql.$$.fragment,l),Un=t(l),y($l.$$.fragment,l),wn=t(l),xl=T(l,"P",{"data-svelte-h":!0}),c(xl)!=="svelte-10ekozt"&&(xl.textContent=$e),rn=t(l),y(Kl.$$.fragment,l),In=t(l),Ll=T(l,"P",{"data-svelte-h":!0}),c(Ll)!=="svelte-1301hmt"&&(Ll.textContent=xe),mn=t(l),y(Dl.$$.fragment,l),Cn=t(l),Pl=T(l,"P",{"data-svelte-h":!0}),c(Pl)!=="svelte-1bz6q0d"&&(Pl.innerHTML=Ke),dn=t(l),y(Ol.$$.fragment,l),un=t(l),ls=T(l,"P",{"data-svelte-h":!0}),c(ls)!=="svelte-1gw56hk"&&(ls.innerHTML=Le),bn=t(l),y(ss.$$.fragment,l),hn=t(l),y(as.$$.fragment,l),An=t(l),Ms=T(l,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-185kvde"&&(Ms.innerHTML=De),Bn=t(l),ns=T(l,"UL",{"data-svelte-h":!0}),c(ns)!=="svelte-1ys0gox"&&(ns.innerHTML=Pe),Zn=t(l),y(ts.$$.fragment,l),Nn=t(l),es=T(l,"P",{"data-svelte-h":!0}),c(es)!=="svelte-1yer834"&&(es.textContent=Oe),Rn=t(l),ys=T(l,"OL",{"data-svelte-h":!0}),c(ys)!=="svelte-16797s5"&&(ys.innerHTML=ly),En=t(l),y(Js.$$.fragment,l),fn=t(l),y(ps.$$.fragment,l),vn=t(l),y(js.$$.fragment,l),Gn=t(l),y(os.$$.fragment,l),Wn=t(l),y(is.$$.fragment,l),Vn=t(l),y(Ts.$$.fragment,l),gn=t(l),y(cs.$$.fragment,l),Xn=t(l),y(Us.$$.fragment,l),kn=t(l),ws=T(l,"P",{"data-svelte-h":!0}),c(ws)!=="svelte-smkkj9"&&(ws.textContent=sy),Qn=t(l),y(rs.$$.fragment,l),Yn=t(l),Is=T(l,"P",{"data-svelte-h":!0}),c(Is)!=="svelte-mitdng"&&(Is.innerHTML=ay),Sn=t(l),y(ms.$$.fragment,l),zn=t(l),y(Cs.$$.fragment,l),Fn=t(l),ds=T(l,"P",{"data-svelte-h":!0}),c(ds)!=="svelte-1ia3674"&&(ds.textContent=My),_n=t(l),y(us.$$.fragment,l),Hn=t(l),y(bs.$$.fragment,l),qn=t(l),hs=T(l,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-1kcnd4q"&&(hs.textContent=ny),$n=t(l),y(As.$$.fragment,l),xn=t(l),y(Bs.$$.fragment,l),Kn=t(l),y(Zs.$$.fragment,l),Ln=t(l),y(Ns.$$.fragment,l),Dn=t(l),y(Rs.$$.fragment,l),Pn=t(l),Es=T(l,"P",{"data-svelte-h":!0}),c(Es)!=="svelte-1bch8ue"&&(Es.textContent=ty),On=t(l),y(fs.$$.fragment,l),lt=t(l),vs=T(l,"P",{"data-svelte-h":!0}),c(vs)!=="svelte-15dk5dx"&&(vs.textContent=ey),st=t(l),y(Gs.$$.fragment,l),at=t(l),y(Ws.$$.fragment,l),Mt=t(l),y(Vs.$$.fragment,l),nt=t(l),gs=T(l,"P",{"data-svelte-h":!0}),c(gs)!=="svelte-1cv9gnq"&&(gs.textContent=yy),tt=t(l),y(Xs.$$.fragment,l),et=t(l),y(ks.$$.fragment,l),yt=t(l),Qs=T(l,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-ts1p6o"&&(Qs.textContent=Jy),Jt=t(l),y(Ys.$$.fragment,l),pt=t(l),y(Ss.$$.fragment,l),jt=t(l),zs=T(l,"P",{"data-svelte-h":!0}),c(zs)!=="svelte-6jxcgy"&&(zs.textContent=py),ot=t(l),y(Fs.$$.fragment,l),it=t(l),y(_s.$$.fragment,l),Tt=t(l),Hs=T(l,"P",{"data-svelte-h":!0}),c(Hs)!=="svelte-hnye80"&&(Hs.textContent=jy),ct=t(l),y(qs.$$.fragment,l),Ut=t(l),y($s.$$.fragment,l),wt=t(l),xs=T(l,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-c2quxz"&&(xs.textContent=oy),rt=t(l),y(Ks.$$.fragment,l),It=t(l),Ls=T(l,"P",{"data-svelte-h":!0}),c(Ls)!=="svelte-1e4iate"&&(Ls.textContent=iy),mt=t(l),y(Ds.$$.fragment,l),Ct=t(l),Ps=T(l,"P",{"data-svelte-h":!0}),c(Ps)!=="svelte-zr0qdb"&&(Ps.textContent=Ty),dt=t(l),y(Os.$$.fragment,l),ut=t(l),y(la.$$.fragment,l),bt=t(l),sa=T(l,"P",{"data-svelte-h":!0}),c(sa)!=="svelte-aylawg"&&(sa.textContent=cy),ht=t(l),y(aa.$$.fragment,l),At=t(l),Ma=T(l,"P",{"data-svelte-h":!0}),c(Ma)!=="svelte-xcmc3w"&&(Ma.textContent=Uy),Bt=t(l),y(na.$$.fragment,l),Zt=t(l),y(ta.$$.fragment,l),Nt=t(l),ea=T(l,"P",{"data-svelte-h":!0}),c(ea)!=="svelte-1tfzl84"&&(ea.textContent=wy),Rt=t(l),y(ya.$$.fragment,l),Et=t(l),y(Ja.$$.fragment,l),ft=t(l),pa=T(l,"P",{"data-svelte-h":!0}),c(pa)!=="svelte-12z69rp"&&(pa.textContent=ry),vt=t(l),y(ja.$$.fragment,l),Gt=t(l),oa=T(l,"P",{"data-svelte-h":!0}),c(oa)!=="svelte-whgag1"&&(oa.textContent=Iy),Wt=t(l),ia=T(l,"OL",{"data-svelte-h":!0}),c(ia)!=="svelte-1uaq31e"&&(ia.innerHTML=my),Vt=t(l),y(Ta.$$.fragment,l),gt=t(l),y(ca.$$.fragment,l),Xt=t(l),y(Ua.$$.fragment,l),kt=t(l),y(wa.$$.fragment,l),Qt=t(l),y(ra.$$.fragment,l),Yt=t(l),y(Ia.$$.fragment,l),St=t(l),y(ma.$$.fragment,l),zt=t(l),y(Ca.$$.fragment,l),Ft=t(l),y(da.$$.fragment,l),_t=t(l),y(ua.$$.fragment,l),Ht=t(l),ba=T(l,"P",{"data-svelte-h":!0}),c(ba)!=="svelte-17ie6dg"&&(ba.textContent=Cy),qt=t(l),y(ha.$$.fragment,l),$t=t(l),y(Aa.$$.fragment,l),xt=t(l),Ba=T(l,"P",{"data-svelte-h":!0}),c(Ba)!=="svelte-1g9mait"&&(Ba.innerHTML=dy),Kt=t(l),y(Za.$$.fragment,l),Lt=t(l),y(Na.$$.fragment,l),Dt=t(l),Ra=T(l,"P",{"data-svelte-h":!0}),c(Ra)!=="svelte-1dunpoe"&&(Ra.textContent=uy),Pt=t(l),Ea=T(l,"UL",{"data-svelte-h":!0}),c(Ea)!=="svelte-uxpc92"&&(Ea.innerHTML=by),Ot=t(l),fa=T(l,"P",{"data-svelte-h":!0}),c(fa)!=="svelte-14gl1jw"&&(fa.textContent=hy),le=t(l),va=T(l,"UL",{"data-svelte-h":!0}),c(va)!=="svelte-n8z8xr"&&(va.innerHTML=Ay),se=t(l),Ga=T(l,"P",{"data-svelte-h":!0}),c(Ga)!=="svelte-69g816"&&(Ga.textContent=By),ae=t(l),Wa=T(l,"P",{"data-svelte-h":!0}),c(Wa)!=="svelte-1t287zt"&&(Wa.innerHTML=Zy),Me=t(l),y(Va.$$.fragment,l),ne=t(l),Xa=T(l,"P",{}),Ny(Xa).forEach(a),this.h()},h(){Ry(r,"name","hf:doc:metadata"),Ry(r,"content",Qy)},m(l,s){gy(document.head,r),M(l,ka,s),M(l,ga,s),M(l,Qa,s),J(I,l,s),M(l,Ya,s),M(l,m,s),M(l,Sa,s),M(l,C,s),M(l,za,s),M(l,d,s),M(l,Fa,s),J(u,l,s),M(l,_a,s),M(l,b,s),M(l,Ha,s),J(h,l,s),M(l,qa,s),M(l,A,s),M(l,$a,s),J(B,l,s),M(l,xa,s),M(l,Z,s),M(l,Ka,s),M(l,N,s),M(l,La,s),J(R,l,s),M(l,Da,s),M(l,E,s),M(l,Pa,s),M(l,f,s),M(l,Oa,s),J(v,l,s),M(l,lM,s),M(l,G,s),M(l,sM,s),M(l,W,s),M(l,aM,s),J(V,l,s),M(l,MM,s),M(l,g,s),M(l,nM,s),M(l,X,s),M(l,tM,s),J(k,l,s),M(l,eM,s),M(l,Q,s),M(l,yM,s),M(l,Y,s),M(l,JM,s),M(l,S,s),M(l,pM,s),J(z,l,s),M(l,jM,s),M(l,F,s),M(l,oM,s),J(_,l,s),M(l,iM,s),M(l,H,s),M(l,TM,s),M(l,q,s),M(l,cM,s),M(l,$,s),M(l,UM,s),J(x,l,s),M(l,wM,s),M(l,K,s),M(l,rM,s),J(L,l,s),M(l,IM,s),M(l,D,s),M(l,mM,s),J(P,l,s),M(l,CM,s),J(O,l,s),M(l,dM,s),M(l,ll,s),M(l,uM,s),J(sl,l,s),M(l,bM,s),J(al,l,s),M(l,hM,s),M(l,Ml,s),M(l,AM,s),J(nl,l,s),M(l,BM,s),J(tl,l,s),M(l,ZM,s),M(l,el,s),M(l,NM,s),J(yl,l,s),M(l,RM,s),J(Jl,l,s),M(l,EM,s),M(l,pl,s),M(l,fM,s),J(jl,l,s),M(l,vM,s),J(ol,l,s),M(l,GM,s),M(l,il,s),M(l,WM,s),J(Tl,l,s),M(l,VM,s),J(cl,l,s),M(l,gM,s),M(l,Ul,s),M(l,XM,s),J(wl,l,s),M(l,kM,s),J(rl,l,s),M(l,QM,s),M(l,Il,s),M(l,YM,s),J(ml,l,s),M(l,SM,s),J(Cl,l,s),M(l,zM,s),M(l,dl,s),M(l,FM,s),M(l,ul,s),M(l,_M,s),M(l,bl,s),M(l,HM,s),M(l,hl,s),M(l,qM,s),J(Al,l,s),M(l,$M,s),J(Bl,l,s),M(l,xM,s),M(l,Zl,s),M(l,KM,s),J(Nl,l,s),M(l,LM,s),J(Rl,l,s),M(l,DM,s),M(l,El,s),M(l,PM,s),J(fl,l,s),M(l,OM,s),J(vl,l,s),M(l,ln,s),M(l,Gl,s),M(l,sn,s),J(Wl,l,s),M(l,an,s),J(Vl,l,s),M(l,Mn,s),M(l,gl,s),M(l,nn,s),J(Xl,l,s),M(l,tn,s),J(kl,l,s),M(l,en,s),M(l,Ql,s),M(l,yn,s),J(Yl,l,s),M(l,Jn,s),J(Sl,l,s),M(l,pn,s),M(l,zl,s),M(l,jn,s),J(Fl,l,s),M(l,on,s),J(_l,l,s),M(l,Tn,s),M(l,Hl,s),M(l,cn,s),J(ql,l,s),M(l,Un,s),J($l,l,s),M(l,wn,s),M(l,xl,s),M(l,rn,s),J(Kl,l,s),M(l,In,s),M(l,Ll,s),M(l,mn,s),J(Dl,l,s),M(l,Cn,s),M(l,Pl,s),M(l,dn,s),J(Ol,l,s),M(l,un,s),M(l,ls,s),M(l,bn,s),J(ss,l,s),M(l,hn,s),J(as,l,s),M(l,An,s),M(l,Ms,s),M(l,Bn,s),M(l,ns,s),M(l,Zn,s),J(ts,l,s),M(l,Nn,s),M(l,es,s),M(l,Rn,s),M(l,ys,s),M(l,En,s),J(Js,l,s),M(l,fn,s),J(ps,l,s),M(l,vn,s),J(js,l,s),M(l,Gn,s),J(os,l,s),M(l,Wn,s),J(is,l,s),M(l,Vn,s),J(Ts,l,s),M(l,gn,s),J(cs,l,s),M(l,Xn,s),J(Us,l,s),M(l,kn,s),M(l,ws,s),M(l,Qn,s),J(rs,l,s),M(l,Yn,s),M(l,Is,s),M(l,Sn,s),J(ms,l,s),M(l,zn,s),J(Cs,l,s),M(l,Fn,s),M(l,ds,s),M(l,_n,s),J(us,l,s),M(l,Hn,s),J(bs,l,s),M(l,qn,s),M(l,hs,s),M(l,$n,s),J(As,l,s),M(l,xn,s),J(Bs,l,s),M(l,Kn,s),J(Zs,l,s),M(l,Ln,s),J(Ns,l,s),M(l,Dn,s),J(Rs,l,s),M(l,Pn,s),M(l,Es,s),M(l,On,s),J(fs,l,s),M(l,lt,s),M(l,vs,s),M(l,st,s),J(Gs,l,s),M(l,at,s),J(Ws,l,s),M(l,Mt,s),J(Vs,l,s),M(l,nt,s),M(l,gs,s),M(l,tt,s),J(Xs,l,s),M(l,et,s),J(ks,l,s),M(l,yt,s),M(l,Qs,s),M(l,Jt,s),J(Ys,l,s),M(l,pt,s),J(Ss,l,s),M(l,jt,s),M(l,zs,s),M(l,ot,s),J(Fs,l,s),M(l,it,s),J(_s,l,s),M(l,Tt,s),M(l,Hs,s),M(l,ct,s),J(qs,l,s),M(l,Ut,s),J($s,l,s),M(l,wt,s),M(l,xs,s),M(l,rt,s),J(Ks,l,s),M(l,It,s),M(l,Ls,s),M(l,mt,s),J(Ds,l,s),M(l,Ct,s),M(l,Ps,s),M(l,dt,s),J(Os,l,s),M(l,ut,s),J(la,l,s),M(l,bt,s),M(l,sa,s),M(l,ht,s),J(aa,l,s),M(l,At,s),M(l,Ma,s),M(l,Bt,s),J(na,l,s),M(l,Zt,s),J(ta,l,s),M(l,Nt,s),M(l,ea,s),M(l,Rt,s),J(ya,l,s),M(l,Et,s),J(Ja,l,s),M(l,ft,s),M(l,pa,s),M(l,vt,s),J(ja,l,s),M(l,Gt,s),M(l,oa,s),M(l,Wt,s),M(l,ia,s),M(l,Vt,s),J(Ta,l,s),M(l,gt,s),J(ca,l,s),M(l,Xt,s),J(Ua,l,s),M(l,kt,s),J(wa,l,s),M(l,Qt,s),J(ra,l,s),M(l,Yt,s),J(Ia,l,s),M(l,St,s),J(ma,l,s),M(l,zt,s),J(Ca,l,s),M(l,Ft,s),J(da,l,s),M(l,_t,s),J(ua,l,s),M(l,Ht,s),M(l,ba,s),M(l,qt,s),J(ha,l,s),M(l,$t,s),J(Aa,l,s),M(l,xt,s),M(l,Ba,s),M(l,Kt,s),J(Za,l,s),M(l,Lt,s),J(Na,l,s),M(l,Dt,s),M(l,Ra,s),M(l,Pt,s),M(l,Ea,s),M(l,Ot,s),M(l,fa,s),M(l,le,s),M(l,va,s),M(l,se,s),M(l,Ga,s),M(l,ae,s),M(l,Wa,s),M(l,Me,s),J(Va,l,s),M(l,ne,s),M(l,Xa,s),te=!0},p:fy,i(l){te||(p(I.$$.fragment,l),p(u.$$.fragment,l),p(h.$$.fragment,l),p(B.$$.fragment,l),p(R.$$.fragment,l),p(v.$$.fragment,l),p(V.$$.fragment,l),p(k.$$.fragment,l),p(z.$$.fragment,l),p(_.$$.fragment,l),p(x.$$.fragment,l),p(L.$$.fragment,l),p(P.$$.fragment,l),p(O.$$.fragment,l),p(sl.$$.fragment,l),p(al.$$.fragment,l),p(nl.$$.fragment,l),p(tl.$$.fragment,l),p(yl.$$.fragment,l),p(Jl.$$.fragment,l),p(jl.$$.fragment,l),p(ol.$$.fragment,l),p(Tl.$$.fragment,l),p(cl.$$.fragment,l),p(wl.$$.fragment,l),p(rl.$$.fragment,l),p(ml.$$.fragment,l),p(Cl.$$.fragment,l),p(Al.$$.fragment,l),p(Bl.$$.fragment,l),p(Nl.$$.fragment,l),p(Rl.$$.fragment,l),p(fl.$$.fragment,l),p(vl.$$.fragment,l),p(Wl.$$.fragment,l),p(Vl.$$.fragment,l),p(Xl.$$.fragment,l),p(kl.$$.fragment,l),p(Yl.$$.fragment,l),p(Sl.$$.fragment,l),p(Fl.$$.fragment,l),p(_l.$$.fragment,l),p(ql.$$.fragment,l),p($l.$$.fragment,l),p(Kl.$$.fragment,l),p(Dl.$$.fragment,l),p(Ol.$$.fragment,l),p(ss.$$.fragment,l),p(as.$$.fragment,l),p(ts.$$.fragment,l),p(Js.$$.fragment,l),p(ps.$$.fragment,l),p(js.$$.fragment,l),p(os.$$.fragment,l),p(is.$$.fragment,l),p(Ts.$$.fragment,l),p(cs.$$.fragment,l),p(Us.$$.fragment,l),p(rs.$$.fragment,l),p(ms.$$.fragment,l),p(Cs.$$.fragment,l),p(us.$$.fragment,l),p(bs.$$.fragment,l),p(As.$$.fragment,l),p(Bs.$$.fragment,l),p(Zs.$$.fragment,l),p(Ns.$$.fragment,l),p(Rs.$$.fragment,l),p(fs.$$.fragment,l),p(Gs.$$.fragment,l),p(Ws.$$.fragment,l),p(Vs.$$.fragment,l),p(Xs.$$.fragment,l),p(ks.$$.fragment,l),p(Ys.$$.fragment,l),p(Ss.$$.fragment,l),p(Fs.$$.fragment,l),p(_s.$$.fragment,l),p(qs.$$.fragment,l),p($s.$$.fragment,l),p(Ks.$$.fragment,l),p(Ds.$$.fragment,l),p(Os.$$.fragment,l),p(la.$$.fragment,l),p(aa.$$.fragment,l),p(na.$$.fragment,l),p(ta.$$.fragment,l),p(ya.$$.fragment,l),p(Ja.$$.fragment,l),p(ja.$$.fragment,l),p(Ta.$$.fragment,l),p(ca.$$.fragment,l),p(Ua.$$.fragment,l),p(wa.$$.fragment,l),p(ra.$$.fragment,l),p(Ia.$$.fragment,l),p(ma.$$.fragment,l),p(Ca.$$.fragment,l),p(da.$$.fragment,l),p(ua.$$.fragment,l),p(ha.$$.fragment,l),p(Aa.$$.fragment,l),p(Za.$$.fragment,l),p(Na.$$.fragment,l),p(Va.$$.fragment,l),te=!0)},o(l){j(I.$$.fragment,l),j(u.$$.fragment,l),j(h.$$.fragment,l),j(B.$$.fragment,l),j(R.$$.fragment,l),j(v.$$.fragment,l),j(V.$$.fragment,l),j(k.$$.fragment,l),j(z.$$.fragment,l),j(_.$$.fragment,l),j(x.$$.fragment,l),j(L.$$.fragment,l),j(P.$$.fragment,l),j(O.$$.fragment,l),j(sl.$$.fragment,l),j(al.$$.fragment,l),j(nl.$$.fragment,l),j(tl.$$.fragment,l),j(yl.$$.fragment,l),j(Jl.$$.fragment,l),j(jl.$$.fragment,l),j(ol.$$.fragment,l),j(Tl.$$.fragment,l),j(cl.$$.fragment,l),j(wl.$$.fragment,l),j(rl.$$.fragment,l),j(ml.$$.fragment,l),j(Cl.$$.fragment,l),j(Al.$$.fragment,l),j(Bl.$$.fragment,l),j(Nl.$$.fragment,l),j(Rl.$$.fragment,l),j(fl.$$.fragment,l),j(vl.$$.fragment,l),j(Wl.$$.fragment,l),j(Vl.$$.fragment,l),j(Xl.$$.fragment,l),j(kl.$$.fragment,l),j(Yl.$$.fragment,l),j(Sl.$$.fragment,l),j(Fl.$$.fragment,l),j(_l.$$.fragment,l),j(ql.$$.fragment,l),j($l.$$.fragment,l),j(Kl.$$.fragment,l),j(Dl.$$.fragment,l),j(Ol.$$.fragment,l),j(ss.$$.fragment,l),j(as.$$.fragment,l),j(ts.$$.fragment,l),j(Js.$$.fragment,l),j(ps.$$.fragment,l),j(js.$$.fragment,l),j(os.$$.fragment,l),j(is.$$.fragment,l),j(Ts.$$.fragment,l),j(cs.$$.fragment,l),j(Us.$$.fragment,l),j(rs.$$.fragment,l),j(ms.$$.fragment,l),j(Cs.$$.fragment,l),j(us.$$.fragment,l),j(bs.$$.fragment,l),j(As.$$.fragment,l),j(Bs.$$.fragment,l),j(Zs.$$.fragment,l),j(Ns.$$.fragment,l),j(Rs.$$.fragment,l),j(fs.$$.fragment,l),j(Gs.$$.fragment,l),j(Ws.$$.fragment,l),j(Vs.$$.fragment,l),j(Xs.$$.fragment,l),j(ks.$$.fragment,l),j(Ys.$$.fragment,l),j(Ss.$$.fragment,l),j(Fs.$$.fragment,l),j(_s.$$.fragment,l),j(qs.$$.fragment,l),j($s.$$.fragment,l),j(Ks.$$.fragment,l),j(Ds.$$.fragment,l),j(Os.$$.fragment,l),j(la.$$.fragment,l),j(aa.$$.fragment,l),j(na.$$.fragment,l),j(ta.$$.fragment,l),j(ya.$$.fragment,l),j(Ja.$$.fragment,l),j(ja.$$.fragment,l),j(Ta.$$.fragment,l),j(ca.$$.fragment,l),j(Ua.$$.fragment,l),j(wa.$$.fragment,l),j(ra.$$.fragment,l),j(Ia.$$.fragment,l),j(ma.$$.fragment,l),j(Ca.$$.fragment,l),j(da.$$.fragment,l),j(ua.$$.fragment,l),j(ha.$$.fragment,l),j(Aa.$$.fragment,l),j(Za.$$.fragment,l),j(Na.$$.fragment,l),j(Va.$$.fragment,l),te=!1},d(l){l&&(a(ka),a(ga),a(Qa),a(Ya),a(m),a(Sa),a(C),a(za),a(d),a(Fa),a(_a),a(b),a(Ha),a(qa),a(A),a($a),a(xa),a(Z),a(Ka),a(N),a(La),a(Da),a(E),a(Pa),a(f),a(Oa),a(lM),a(G),a(sM),a(W),a(aM),a(MM),a(g),a(nM),a(X),a(tM),a(eM),a(Q),a(yM),a(Y),a(JM),a(S),a(pM),a(jM),a(F),a(oM),a(iM),a(H),a(TM),a(q),a(cM),a($),a(UM),a(wM),a(K),a(rM),a(IM),a(D),a(mM),a(CM),a(dM),a(ll),a(uM),a(bM),a(hM),a(Ml),a(AM),a(BM),a(ZM),a(el),a(NM),a(RM),a(EM),a(pl),a(fM),a(vM),a(GM),a(il),a(WM),a(VM),a(gM),a(Ul),a(XM),a(kM),a(QM),a(Il),a(YM),a(SM),a(zM),a(dl),a(FM),a(ul),a(_M),a(bl),a(HM),a(hl),a(qM),a($M),a(xM),a(Zl),a(KM),a(LM),a(DM),a(El),a(PM),a(OM),a(ln),a(Gl),a(sn),a(an),a(Mn),a(gl),a(nn),a(tn),a(en),a(Ql),a(yn),a(Jn),a(pn),a(zl),a(jn),a(on),a(Tn),a(Hl),a(cn),a(Un),a(wn),a(xl),a(rn),a(In),a(Ll),a(mn),a(Cn),a(Pl),a(dn),a(un),a(ls),a(bn),a(hn),a(An),a(Ms),a(Bn),a(ns),a(Zn),a(Nn),a(es),a(Rn),a(ys),a(En),a(fn),a(vn),a(Gn),a(Wn),a(Vn),a(gn),a(Xn),a(kn),a(ws),a(Qn),a(Yn),a(Is),a(Sn),a(zn),a(Fn),a(ds),a(_n),a(Hn),a(qn),a(hs),a($n),a(xn),a(Kn),a(Ln),a(Dn),a(Pn),a(Es),a(On),a(lt),a(vs),a(st),a(at),a(Mt),a(nt),a(gs),a(tt),a(et),a(yt),a(Qs),a(Jt),a(pt),a(jt),a(zs),a(ot),a(it),a(Tt),a(Hs),a(ct),a(Ut),a(wt),a(xs),a(rt),a(It),a(Ls),a(mt),a(Ct),a(Ps),a(dt),a(ut),a(bt),a(sa),a(ht),a(At),a(Ma),a(Bt),a(Zt),a(Nt),a(ea),a(Rt),a(Et),a(ft),a(pa),a(vt),a(Gt),a(oa),a(Wt),a(ia),a(Vt),a(gt),a(Xt),a(kt),a(Qt),a(Yt),a(St),a(zt),a(Ft),a(_t),a(Ht),a(ba),a(qt),a($t),a(xt),a(Ba),a(Kt),a(Lt),a(Dt),a(Ra),a(Pt),a(Ea),a(Ot),a(fa),a(le),a(va),a(se),a(Ga),a(ae),a(Wa),a(Me),a(ne),a(Xa)),a(r),o(I,l),o(u,l),o(h,l),o(B,l),o(R,l),o(v,l),o(V,l),o(k,l),o(z,l),o(_,l),o(x,l),o(L,l),o(P,l),o(O,l),o(sl,l),o(al,l),o(nl,l),o(tl,l),o(yl,l),o(Jl,l),o(jl,l),o(ol,l),o(Tl,l),o(cl,l),o(wl,l),o(rl,l),o(ml,l),o(Cl,l),o(Al,l),o(Bl,l),o(Nl,l),o(Rl,l),o(fl,l),o(vl,l),o(Wl,l),o(Vl,l),o(Xl,l),o(kl,l),o(Yl,l),o(Sl,l),o(Fl,l),o(_l,l),o(ql,l),o($l,l),o(Kl,l),o(Dl,l),o(Ol,l),o(ss,l),o(as,l),o(ts,l),o(Js,l),o(ps,l),o(js,l),o(os,l),o(is,l),o(Ts,l),o(cs,l),o(Us,l),o(rs,l),o(ms,l),o(Cs,l),o(us,l),o(bs,l),o(As,l),o(Bs,l),o(Zs,l),o(Ns,l),o(Rs,l),o(fs,l),o(Gs,l),o(Ws,l),o(Vs,l),o(Xs,l),o(ks,l),o(Ys,l),o(Ss,l),o(Fs,l),o(_s,l),o(qs,l),o($s,l),o(Ks,l),o(Ds,l),o(Os,l),o(la,l),o(aa,l),o(na,l),o(ta,l),o(ya,l),o(Ja,l),o(ja,l),o(Ta,l),o(ca,l),o(Ua,l),o(wa,l),o(ra,l),o(Ia,l),o(ma,l),o(Ca,l),o(da,l),o(ua,l),o(ha,l),o(Aa,l),o(Za,l),o(Na,l),o(Va,l)}}}const Qy='{"title":"RobotProcessor: The Art of Processing Robot Data","local":"robotprocessor-the-art-of-processing-robot-data","sections":[{"title":"Real-World Scenarios: When You Need RobotProcessor","local":"real-world-scenarios-when-you-need-robotprocessor","sections":[{"title":"Observation Key Mismatches","local":"observation-key-mismatches","sections":[],"depth":3},{"title":"Image Preprocessing Requirements","local":"image-preprocessing-requirements","sections":[],"depth":3},{"title":"Coordinate System Transformations","local":"coordinate-system-transformations","sections":[],"depth":3},{"title":"State Augmentation","local":"state-augmentation","sections":[],"depth":3},{"title":"Multi-Robot Deployment","local":"multi-robot-deployment","sections":[],"depth":3},{"title":"Data Collection and Training","local":"data-collection-and-training","sections":[],"depth":3}],"depth":2},{"title":"Why RobotProcessor?","local":"why-robotprocessor","sections":[],"depth":2},{"title":"Understanding EnvTransition and Batch Format","local":"understanding-envtransition-and-batch-format","sections":[{"title":"1. EnvTransition Dictionary Format","local":"1-envtransition-dictionary-format","sections":[],"depth":3},{"title":"2. Batch Dictionary Format","local":"2-batch-dictionary-format","sections":[],"depth":3},{"title":"Automatic Format Conversion","local":"automatic-format-conversion","sections":[],"depth":3},{"title":"Using TransitionKey","local":"using-transitionkey","sections":[],"depth":3},{"title":"Default Conversion Functions","local":"default-conversion-functions","sections":[],"depth":3},{"title":"Custom Conversion Functions","local":"custom-conversion-functions","sections":[],"depth":3},{"title":"Advanced: Controlling Output Format with to_output","local":"advanced-controlling-output-format-with-tooutput","sections":[],"depth":3},{"title":"Real-World Example: Environment Interaction","local":"real-world-example-environment-interaction","sections":[],"depth":3},{"title":"When to Use Different Output Formats","local":"when-to-use-different-output-formats","sections":[],"depth":3},{"title":"Why “next.reward”, “next.done”, “next.truncated”?","local":"why-nextreward-nextdone-nexttruncated","sections":[],"depth":3}],"depth":2},{"title":"Your First RobotProcessor","local":"your-first-robotprocessor","sections":[],"depth":2},{"title":"Working with LeRobot Datasets and Replay Buffers","local":"working-with-lerobot-datasets-and-replay-buffers","sections":[],"depth":2},{"title":"Integration with Replay Buffers","local":"integration-with-replay-buffers","sections":[],"depth":2},{"title":"Creating Custom Steps: The ProcessorStep Protocol","local":"creating-custom-steps-the-processorstep-protocol","sections":[{"title":"Important: get_config vs state_dict","local":"important-getconfig-vs-statedict","sections":[],"depth":3}],"depth":2},{"title":"Using Complementary Data for Inter-Step Communication","local":"using-complementary-data-for-inter-step-communication","sections":[],"depth":2},{"title":"Loading Processors with Overrides: Handling Non-Serializable Objects","local":"loading-processors-with-overrides-handling-non-serializable-objects","sections":[{"title":"The Problem: Non-Serializable Parameters","local":"the-problem-non-serializable-parameters","sections":[],"depth":3},{"title":"The Solution: Override Parameters","local":"the-solution-override-parameters","sections":[],"depth":3},{"title":"How Overrides Work","local":"how-overrides-work","sections":[],"depth":3},{"title":"Real-World Examples","local":"real-world-examples","sections":[{"title":"Example 1: Environment-Dependent Steps","local":"example-1-environment-dependent-steps","sections":[],"depth":4},{"title":"Example 2: Device and Hardware Configuration","local":"example-2-device-and-hardware-configuration","sections":[],"depth":4},{"title":"Example 3: Multiple Environment Deployment","local":"example-3-multiple-environment-deployment","sections":[],"depth":4}],"depth":3},{"title":"Override Key Matching Rules","local":"override-key-matching-rules","sections":[{"title":"For Registered Steps","local":"for-registered-steps","sections":[],"depth":4},{"title":"For Unregistered Steps","local":"for-unregistered-steps","sections":[],"depth":4}],"depth":3},{"title":"Error Handling and Validation","local":"error-handling-and-validation","sections":[{"title":"Invalid Override Keys","local":"invalid-override-keys","sections":[],"depth":4},{"title":"Instantiation Errors","local":"instantiation-errors","sections":[],"depth":4}],"depth":3},{"title":"Multiple Steps with Same Class Name","local":"multiple-steps-with-same-class-name","sections":[],"depth":3},{"title":"Best Practices for Overrides","local":"best-practices-for-overrides","sections":[{"title":"1. Design Steps for Overrides","local":"1-design-steps-for-overrides","sections":[],"depth":4},{"title":"2. Use Registry Names for Clarity","local":"2-use-registry-names-for-clarity","sections":[],"depth":4},{"title":"3. Document Override Requirements","local":"3-document-override-requirements","sections":[],"depth":4},{"title":"4. Environment-Specific Configuration Files","local":"4-environment-specific-configuration-files","sections":[],"depth":4}],"depth":3},{"title":"Integration with Hub Sharing","local":"integration-with-hub-sharing","sections":[],"depth":3}],"depth":2},{"title":"Complete Example: Device-Aware Processing Pipeline","local":"complete-example-device-aware-processing-pipeline","sections":[],"depth":2},{"title":"Solving Real-World Problems with RobotProcessor","local":"solving-real-world-problems-with-robotprocessor","sections":[{"title":"Renaming Observation Keys","local":"renaming-observation-keys","sections":[],"depth":3},{"title":"Workspace-Focused Image Processing","local":"workspace-focused-image-processing","sections":[],"depth":3},{"title":"Building Complete Pipelines for Different Robots","local":"building-complete-pipelines-for-different-robots","sections":[],"depth":3}],"depth":2},{"title":"Best Practices for Processor Steps","local":"best-practices-for-processor-steps","sections":[{"title":"1. Always Check for None","local":"1-always-check-for-none","sections":[],"depth":3},{"title":"2. Preserve Transition Structure","local":"2-preserve-transition-structure","sections":[],"depth":3},{"title":"3. Clone When Storing State","local":"3-clone-when-storing-state","sections":[],"depth":3},{"title":"4. Handle Device Transfers in state_dict","local":"4-handle-device-transfers-in-statedict","sections":[],"depth":3}],"depth":2},{"title":"Complete Policy Example with Pre and Post Processing","local":"complete-policy-example-with-pre-and-post-processing","sections":[],"depth":2},{"title":"Debugging and Monitoring","local":"debugging-and-monitoring","sections":[],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function Yy(ee){return vy(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hy extends Gy{constructor(r){super(),Wy(this,r,Yy,ky,Ey,{})}}export{Hy as component};
