import{s as Io,n as Ro,o as Ho}from"../chunks/scheduler.85c25b89.js";import{S as Eo,i as Go,g as o,s as a,r as p,A as So,h as n,f as i,c as r,j as u,u as d,x as s,k as v,y as t,a as l,v as c,d as g,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.7e31ccde.js";import{H as wa,E as Oo}from"../chunks/EditOnGithub.b65eee75.js";function Bo(Nr){let G,Gt,Ht,St,te,Ot,ae,Fr="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",Bt,re,Vt,oe,qt,S,ne,Aa,Oe,Ir=`Legacy optimizer factory for backwards compatibility.
NOTE: Use create_optimizer_v2 for new code.`,Wt,z,ie,La,Be,Rr="Create an optimizer.",Ca,Ve,Hr=`TODO currently the model is passed in and all parameters are selected for optimization.
For more general use an interface that allows selection of parameters to optimize and lr groups, one of:`,Ta,qe,Er="<li>a filter fn interface that further breaks params into groups in a weight_decay compatible fashion</li> <li>expose the parameters interface and leave it up to caller</li>",kt,me,jt,x,se,Da,We,Gr="Implements AdaBelief algorithm. Modified from Adam in PyTorch",za,ke,Sr="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Ma,je,Or=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Pa,Ue,Br='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Na,O,le,Fa,Ze,Vr="Performs a single optimization step.",Ut,L,pe,Ia,Qe,qr=`Implements Adafactor algorithm.
This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,Ra,Xe,Wr=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,Ha,Je,kr=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,Ea,B,de,Ga,Ke,jr="Performs a single optimization step.",Zt,$,ce,Sa,Ye,Ur="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",Oa,V,ge,Ba,et,Zr="Gets all parameters in all param_groups with gradients",Va,q,fe,qa,tt,Qr="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",Wa,W,he,ka,at,Xr="Performs a single optimization step.",ja,k,ue,Ua,rt,Jr="Zeros out the accumalated hessian traces.",Qt,ve,be,Xt,C,_e,Za,ot,Kr="Implements AdamW algorithm.",Qa,nt,Yr=`The original Adam algorithm was proposed in <code>Adam: A Method for Stochastic Optimization</code><em>.
The AdamW variant was proposed in <code>Decoupled Weight Decay Regularization</code></em>.`,Xa,it,eo=`.. _Adam\\: A Method for Stochastic Optimization:
<a href="https://arxiv.org/abs/1412.6980" rel="nofollow">https://arxiv.org/abs/1412.6980</a>
.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,Ja,j,ye,Ka,mt,to="Performs a single optimization step.",Jt,T,xe,Ya,st,ao=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,er,lt,ro="LAMB was proposed in <code>Large Batch Optimization for Deep Learning: Training BERT in 76 minutes</code>_.",tr,pt,oo=`.. _Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:
<a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,ar,U,$e,rr,dt,no="Performs a single optimization step.",Kt,M,we,or,ct,io="LARS for PyTorch",nr,gt,mo='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',ir,Z,Ae,mr,ft,so="Performs a single optimization step.",Yt,Le,Ce,ea,y,Te,sr,ht,lo=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,lr,ut,po='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',pr,vt,co=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,dr,bt,go=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,cr,_t,fo="On sparse problems both weight_decay and momentum should be set to 0.",gr,Q,De,fr,yt,ho="Performs a single optimization step.",ta,w,ze,hr,xt,uo="Implements Nadam algorithm (a variant of Adam based on Nesterov momentum).",ur,$t,vo="It has been proposed in <code>Incorporating Nesterov Momentum into Adam</code>__.",vr,wt,bo='<strong><a href="http://cs229.stanford.edu/proj2015/054_report.pdf" rel="nofollow">http://cs229.stanford.edu/proj2015/054_report.pdf</a></strong> <a href="http://www.cs.toronto.edu/~fritz/absps/momentum.pdf" rel="nofollow">http://www.cs.toronto.edu/~fritz/absps/momentum.pdf</a>',br,At,_o=`Originally taken from: <a href="https://github.com/pytorch/pytorch/pull/1408" rel="nofollow">https://github.com/pytorch/pytorch/pull/1408</a>
NOTE: Has potential issues but does work well on some problems.`,_r,X,Me,yr,Lt,yo="Performs a single optimization step.",aa,I,Pe,xr,Ct,xo="Implements Novograd algorithm.",$r,J,Ne,wr,Tt,$o="Performs a single optimization step.",ra,Fe,Ie,oa,_,Re,Ar,Dt,wo="Implements RMSprop algorithm (TensorFlow style epsilon)",Lr,zt,Ao=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,Cr,Mt,Lo="Noteworthy changes include:",Tr,Pt,Co="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",Dr,Nt,To=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,zr,Ft,Do=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,Mr,K,He,Pr,It,zo="Performs a single optimization step.",na,Ee,Ge,ia,Se,ma,Et,sa;return te=new wa({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),re=new wa({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),oe=new wa({props:{title:"Factory functions",local:"timm.optim.create_optimizer",headingTag:"h3"}}),ne=new b({props:{name:"timm.optim.create_optimizer",anchor:"timm.optim.create_optimizer",parameters:[{name:"args",val:""},{name:"model",val:""},{name:"filter_bias_and_bn",val:" = True"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/optim_factory.py#L183"}}),ie=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:""},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": Optional = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": Optional = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": Optional = None"},{name:"param_group_fn",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> (nn.Module) &#x2014; model containing parameters to optimize
opt &#x2014; name of optimizer to create
lr &#x2014; initial learning rate
weight_decay &#x2014; weight decay to apply in optimizer
momentum &#x2014;  momentum for momentum based optimizers (others may use betas via kwargs)
foreach &#x2014; Enable / disable foreach (multi-tensor) operation if True / False. Choose safe default if None
filter_bias_and_bn &#x2014;  filter out bias, bn and other 1d params from weight decay
**kwargs &#x2014; extra optimizer specific kwargs to pass through`,name:"model_or_params"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/optim_factory.py#L194",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Optimizer</p>
`}}),me=new wa({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),se=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adabelief.py#L6"}}),le=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adabelief.py#L89"}}),pe=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:""},{name:"lr",val:" = None"},{name:"eps",val:" = 1e-30"},{name:"eps_scale",val:" = 0.001"},{name:"clip_threshold",val:" = 1.0"},{name:"decay_rate",val:" = -0.8"},{name:"betas",val:" = None"},{name:"weight_decay",val:" = 0.0"},{name:"scale_parameter",val:" = True"},{name:"warmup_init",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adafactor.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adafactor.lr",description:"<strong>lr</strong> (float, optional) &#x2014; external learning rate (default: None)",name:"lr"},{anchor:"timm.optim.Adafactor.eps",description:`<strong>eps</strong> (tuple[float, float]) &#x2014; regularization constants for square gradient
and parameter scale respectively (default: (1e-30, 1e-3))`,name:"eps"},{anchor:"timm.optim.Adafactor.clip_threshold",description:"<strong>clip_threshold</strong> (float) &#x2014; threshold of root mean square of final gradient update (default: 1.0)",name:"clip_threshold"},{anchor:"timm.optim.Adafactor.decay_rate",description:"<strong>decay_rate</strong> (float) &#x2014; coefficient used to compute running averages of square gradient (default: -0.8)",name:"decay_rate"},{anchor:"timm.optim.Adafactor.beta1",description:"<strong>beta1</strong> (float) &#x2014; coefficient used for computing running averages of gradient (default: None)",name:"beta1"},{anchor:"timm.optim.Adafactor.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adafactor.scale_parameter",description:"<strong>scale_parameter</strong> (bool) &#x2014; if True, learning rate is scaled by root mean square of parameter (default: True)",name:"scale_parameter"},{anchor:"timm.optim.Adafactor.warmup_init",description:`<strong>warmup_init</strong> (bool) &#x2014; time-dependent learning rate computation depends on
whether warm-up initialization is being used (default: False)`,name:"warmup_init"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adafactor.py#L16"}}),de=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adafactor.py#L79"}}),ce=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adahessian.py#L9"}}),ge=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adahessian.py#L58"}}),fe=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adahessian.py#L74"}}),he=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adahessian.py#L102"}}),ue=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adahessian.py#L65"}}),be=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adamp.py#L43"}}),_e=new b({props:{name:"class timm.optim.AdamW",anchor:"timm.optim.AdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.AdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.AdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"},{anchor:"timm.optim.AdamW.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adamw.py#L12"}}),ye=new b({props:{name:"step",anchor:"timm.optim.AdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/adamw.py#L58"}}),xe=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"bias_correction",val:" = True"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-06"},{name:"weight_decay",val:" = 0.01"},{name:"grad_averaging",val:" = True"},{name:"max_grad_norm",val:" = 1.0"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Lamb.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:`<strong>grad_averaging</strong> (bool, optional) &#x2014; whether apply (1-beta2) to grad when
calculating running averages of gradient. (default: True)`,name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> (float, optional) &#x2014; value used to clip global grad norm (default: 1.0)",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LAMBC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:`<strong>always_adapt</strong> (boolean, optional) &#x2014; Apply adaptive learning rate to 0.0
weight decay parameter (default: False)`,name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/lamb.py#L60"}}),$e=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/lamb.py#L96"}}),we=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/lars.py#L17"}}),Ae=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/lars.py#L75"}}),Ce=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/lookahead.py#L15"}}),Te=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/madgrad.py#L24"}}),De=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": Optional = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/madgrad.py#L85"}}),ze=new b({props:{name:"class timm.optim.Nadam",anchor:"timm.optim.Nadam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.002"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"schedule_decay",val:" = 0.004"}],parametersDescription:[{anchor:"timm.optim.Nadam.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.Nadam.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 2e-3)",name:"lr"},{anchor:"timm.optim.Nadam.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square`,name:"betas"},{anchor:"timm.optim.Nadam.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Nadam.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Nadam.schedule_decay",description:"<strong>schedule_decay</strong> (float, optional) &#x2014; momentum schedule decay (default: 4e-3)",name:"schedule_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/nadam.py#L7"}}),Me=new b({props:{name:"step",anchor:"timm.optim.Nadam.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Nadam.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/nadam.py#L43"}}),Pe=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:`<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)
grad_averaging &#x2014; gradient averaging`,name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/nvnovograd.py#L13"}}),Ne=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/nvnovograd.py#L54"}}),Ie=new b({props:{name:"class timm.optim.RAdam",anchor:"timm.optim.RAdam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/radam.py#L10"}}),Re=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.01"},{name:"alpha",val:" = 0.9"},{name:"eps",val:" = 1e-10"},{name:"weight_decay",val:" = 0"},{name:"momentum",val:" = 0.0"},{name:"centered",val:" = False"},{name:"decoupled_decay",val:" = False"},{name:"lr_in_momentum",val:" = True"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-2)",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> (float, optional) &#x2014; smoothing (decay) constant (default: 0.9)",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-10)`,name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:`<strong>centered</strong> (bool, optional)  &#x2014; if <code>True</code>, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance`,name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> (bool, optional) &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:`<strong>lr_in_momentum</strong> (bool, optional) &#x2014; learning rate scaling is included in the momentum buffer
update as per defaults in Tensorflow`,name:"lr_in_momentum"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/rmsprop_tf.py#L14"}}),He=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/rmsprop_tf.py#L72"}}),Ge=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/vr_2213/timm/optim/sgdp.py#L19"}}),Se=new Oo({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){G=o("meta"),Gt=a(),Ht=o("p"),St=a(),p(te.$$.fragment),Ot=a(),ae=o("p"),ae.innerHTML=Fr,Bt=a(),p(re.$$.fragment),Vt=a(),p(oe.$$.fragment),qt=a(),S=o("div"),p(ne.$$.fragment),Aa=a(),Oe=o("p"),Oe.textContent=Ir,Wt=a(),z=o("div"),p(ie.$$.fragment),La=a(),Be=o("p"),Be.textContent=Rr,Ca=a(),Ve=o("p"),Ve.textContent=Hr,Ta=a(),qe=o("ul"),qe.innerHTML=Er,kt=a(),p(me.$$.fragment),jt=a(),x=o("div"),p(se.$$.fragment),Da=a(),We=o("p"),We.textContent=Gr,za=a(),ke=o("p"),ke.textContent=Sr,Ma=a(),je=o("p"),je.innerHTML=Or,Pa=a(),Ue=o("ul"),Ue.innerHTML=Br,Na=a(),O=o("div"),p(le.$$.fragment),Fa=a(),Ze=o("p"),Ze.textContent=Vr,Ut=a(),L=o("div"),p(pe.$$.fragment),Ia=a(),Qe=o("p"),Qe.innerHTML=qr,Ra=a(),Xe=o("p"),Xe.innerHTML=Wr,Ha=a(),Je=o("p"),Je.innerHTML=kr,Ea=a(),B=o("div"),p(de.$$.fragment),Ga=a(),Ke=o("p"),Ke.textContent=jr,Zt=a(),$=o("div"),p(ce.$$.fragment),Sa=a(),Ye=o("p"),Ye.textContent=Ur,Oa=a(),V=o("div"),p(ge.$$.fragment),Ba=a(),et=o("p"),et.textContent=Zr,Va=a(),q=o("div"),p(fe.$$.fragment),qa=a(),tt=o("p"),tt.textContent=Qr,Wa=a(),W=o("div"),p(he.$$.fragment),ka=a(),at=o("p"),at.textContent=Xr,ja=a(),k=o("div"),p(ue.$$.fragment),Ua=a(),rt=o("p"),rt.textContent=Jr,Qt=a(),ve=o("div"),p(be.$$.fragment),Xt=a(),C=o("div"),p(_e.$$.fragment),Za=a(),ot=o("p"),ot.textContent=Kr,Qa=a(),nt=o("p"),nt.innerHTML=Yr,Xa=a(),it=o("p"),it.innerHTML=eo,Ja=a(),j=o("div"),p(ye.$$.fragment),Ka=a(),mt=o("p"),mt.textContent=to,Jt=a(),T=o("div"),p(xe.$$.fragment),Ya=a(),st=o("p"),st.innerHTML=ao,er=a(),lt=o("p"),lt.innerHTML=ro,tr=a(),pt=o("p"),pt.innerHTML=oo,ar=a(),U=o("div"),p($e.$$.fragment),rr=a(),dt=o("p"),dt.textContent=no,Kt=a(),M=o("div"),p(we.$$.fragment),or=a(),ct=o("p"),ct.textContent=io,nr=a(),gt=o("p"),gt.innerHTML=mo,ir=a(),Z=o("div"),p(Ae.$$.fragment),mr=a(),ft=o("p"),ft.textContent=so,Yt=a(),Le=o("div"),p(Ce.$$.fragment),ea=a(),y=o("div"),p(Te.$$.fragment),sr=a(),ht=o("p"),ht.textContent=lo,lr=a(),ut=o("p"),ut.innerHTML=po,pr=a(),vt=o("p"),vt.textContent=co,dr=a(),bt=o("p"),bt.textContent=go,cr=a(),_t=o("p"),_t.textContent=fo,gr=a(),Q=o("div"),p(De.$$.fragment),fr=a(),yt=o("p"),yt.textContent=ho,ta=a(),w=o("div"),p(ze.$$.fragment),hr=a(),xt=o("p"),xt.textContent=uo,ur=a(),$t=o("p"),$t.innerHTML=vo,vr=a(),wt=o("p"),wt.innerHTML=bo,br=a(),At=o("p"),At.innerHTML=_o,_r=a(),X=o("div"),p(Me.$$.fragment),yr=a(),Lt=o("p"),Lt.textContent=yo,aa=a(),I=o("div"),p(Pe.$$.fragment),xr=a(),Ct=o("p"),Ct.textContent=xo,$r=a(),J=o("div"),p(Ne.$$.fragment),wr=a(),Tt=o("p"),Tt.textContent=$o,ra=a(),Fe=o("div"),p(Ie.$$.fragment),oa=a(),_=o("div"),p(Re.$$.fragment),Ar=a(),Dt=o("p"),Dt.textContent=wo,Lr=a(),zt=o("p"),zt.textContent=Ao,Cr=a(),Mt=o("p"),Mt.textContent=Lo,Tr=a(),Pt=o("ol"),Pt.innerHTML=Co,Dr=a(),Nt=o("p"),Nt.innerHTML=To,zr=a(),Ft=o("p"),Ft.innerHTML=Do,Mr=a(),K=o("div"),p(He.$$.fragment),Pr=a(),It=o("p"),It.textContent=zo,na=a(),Ee=o("div"),p(Ge.$$.fragment),ia=a(),p(Se.$$.fragment),ma=a(),Et=o("p"),this.h()},l(e){const m=So("svelte-u9bgzb",document.head);G=n(m,"META",{name:!0,content:!0}),m.forEach(i),Gt=r(e),Ht=n(e,"P",{}),u(Ht).forEach(i),St=r(e),d(te.$$.fragment,e),Ot=r(e),ae=n(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1c6qm22"&&(ae.innerHTML=Fr),Bt=r(e),d(re.$$.fragment,e),Vt=r(e),d(oe.$$.fragment,e),qt=r(e),S=n(e,"DIV",{class:!0});var la=u(S);d(ne.$$.fragment,la),Aa=r(la),Oe=n(la,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1dlcrvh"&&(Oe.textContent=Ir),la.forEach(i),Wt=r(e),z=n(e,"DIV",{class:!0});var Y=u(z);d(ie.$$.fragment,Y),La=r(Y),Be=n(Y,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-12lpmmq"&&(Be.textContent=Rr),Ca=r(Y),Ve=n(Y,"P",{"data-svelte-h":!0}),s(Ve)!=="svelte-ocfv4n"&&(Ve.textContent=Hr),Ta=r(Y),qe=n(Y,"UL",{"data-svelte-h":!0}),s(qe)!=="svelte-qarx5u"&&(qe.innerHTML=Er),Y.forEach(i),kt=r(e),d(me.$$.fragment,e),jt=r(e),x=n(e,"DIV",{class:!0});var P=u(x);d(se.$$.fragment,P),Da=r(P),We=n(P,"P",{"data-svelte-h":!0}),s(We)!=="svelte-1hnunr4"&&(We.textContent=Gr),za=r(P),ke=n(P,"P",{"data-svelte-h":!0}),s(ke)!=="svelte-1cjb7xo"&&(ke.textContent=Sr),Ma=r(P),je=n(P,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1347q2l"&&(je.innerHTML=Or),Pa=r(P),Ue=n(P,"UL",{"data-svelte-h":!0}),s(Ue)!=="svelte-12x3l9q"&&(Ue.innerHTML=Br),Na=r(P),O=n(P,"DIV",{class:!0});var pa=u(O);d(le.$$.fragment,pa),Fa=r(pa),Ze=n(pa,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1gr03w4"&&(Ze.textContent=Vr),pa.forEach(i),P.forEach(i),Ut=r(e),L=n(e,"DIV",{class:!0});var R=u(L);d(pe.$$.fragment,R),Ia=r(R),Qe=n(R,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1pwmpx3"&&(Qe.innerHTML=qr),Ra=r(R),Xe=n(R,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-1i7ubkr"&&(Xe.innerHTML=Wr),Ha=r(R),Je=n(R,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-96f97i"&&(Je.innerHTML=kr),Ea=r(R),B=n(R,"DIV",{class:!0});var da=u(B);d(de.$$.fragment,da),Ga=r(da),Ke=n(da,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-1gr03w4"&&(Ke.textContent=jr),da.forEach(i),R.forEach(i),Zt=r(e),$=n(e,"DIV",{class:!0});var N=u($);d(ce.$$.fragment,N),Sa=r(N),Ye=n(N,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-1cuo0rh"&&(Ye.textContent=Ur),Oa=r(N),V=n(N,"DIV",{class:!0});var ca=u(V);d(ge.$$.fragment,ca),Ba=r(ca),et=n(ca,"P",{"data-svelte-h":!0}),s(et)!=="svelte-1jz1hl7"&&(et.textContent=Zr),ca.forEach(i),Va=r(N),q=n(N,"DIV",{class:!0});var ga=u(q);d(fe.$$.fragment,ga),qa=r(ga),tt=n(ga,"P",{"data-svelte-h":!0}),s(tt)!=="svelte-1y1oyzd"&&(tt.textContent=Qr),ga.forEach(i),Wa=r(N),W=n(N,"DIV",{class:!0});var fa=u(W);d(he.$$.fragment,fa),ka=r(fa),at=n(fa,"P",{"data-svelte-h":!0}),s(at)!=="svelte-1gr03w4"&&(at.textContent=Xr),fa.forEach(i),ja=r(N),k=n(N,"DIV",{class:!0});var ha=u(k);d(ue.$$.fragment,ha),Ua=r(ha),rt=n(ha,"P",{"data-svelte-h":!0}),s(rt)!=="svelte-4lvf5h"&&(rt.textContent=Jr),ha.forEach(i),N.forEach(i),Qt=r(e),ve=n(e,"DIV",{class:!0});var Mo=u(ve);d(be.$$.fragment,Mo),Mo.forEach(i),Xt=r(e),C=n(e,"DIV",{class:!0});var H=u(C);d(_e.$$.fragment,H),Za=r(H),ot=n(H,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-c51pd7"&&(ot.textContent=Kr),Qa=r(H),nt=n(H,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-1cgyzi6"&&(nt.innerHTML=Yr),Xa=r(H),it=n(H,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1pe3ewc"&&(it.innerHTML=eo),Ja=r(H),j=n(H,"DIV",{class:!0});var ua=u(j);d(ye.$$.fragment,ua),Ka=r(ua),mt=n(ua,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-1gr03w4"&&(mt.textContent=to),ua.forEach(i),H.forEach(i),Jt=r(e),T=n(e,"DIV",{class:!0});var E=u(T);d(xe.$$.fragment,E),Ya=r(E),st=n(E,"P",{"data-svelte-h":!0}),s(st)!=="svelte-d5zqgn"&&(st.innerHTML=ao),er=r(E),lt=n(E,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1wamkfv"&&(lt.innerHTML=ro),tr=r(E),pt=n(E,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-dty621"&&(pt.innerHTML=oo),ar=r(E),U=n(E,"DIV",{class:!0});var va=u(U);d($e.$$.fragment,va),rr=r(va),dt=n(va,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-1gr03w4"&&(dt.textContent=no),va.forEach(i),E.forEach(i),Kt=r(e),M=n(e,"DIV",{class:!0});var ee=u(M);d(we.$$.fragment,ee),or=r(ee),ct=n(ee,"P",{"data-svelte-h":!0}),s(ct)!=="svelte-vzcsb8"&&(ct.textContent=io),nr=r(ee),gt=n(ee,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-euart9"&&(gt.innerHTML=mo),ir=r(ee),Z=n(ee,"DIV",{class:!0});var ba=u(Z);d(Ae.$$.fragment,ba),mr=r(ba),ft=n(ba,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-1gr03w4"&&(ft.textContent=so),ba.forEach(i),ee.forEach(i),Yt=r(e),Le=n(e,"DIV",{class:!0});var Po=u(Le);d(Ce.$$.fragment,Po),Po.forEach(i),ea=r(e),y=n(e,"DIV",{class:!0});var D=u(y);d(Te.$$.fragment,D),sr=r(D),ht=n(D,"P",{"data-svelte-h":!0}),s(ht)!=="svelte-wmmdpx"&&(ht.textContent=lo),lr=r(D),ut=n(D,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-12dyngi"&&(ut.innerHTML=po),pr=r(D),vt=n(D,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-qjjdis"&&(vt.textContent=co),dr=r(D),bt=n(D,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-rosfou"&&(bt.textContent=go),cr=r(D),_t=n(D,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-hlwvkn"&&(_t.textContent=fo),gr=r(D),Q=n(D,"DIV",{class:!0});var _a=u(Q);d(De.$$.fragment,_a),fr=r(_a),yt=n(_a,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-1gr03w4"&&(yt.textContent=ho),_a.forEach(i),D.forEach(i),ta=r(e),w=n(e,"DIV",{class:!0});var F=u(w);d(ze.$$.fragment,F),hr=r(F),xt=n(F,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-1ss2c23"&&(xt.textContent=uo),ur=r(F),$t=n(F,"P",{"data-svelte-h":!0}),s($t)!=="svelte-ewqetr"&&($t.innerHTML=vo),vr=r(F),wt=n(F,"P",{"data-svelte-h":!0}),s(wt)!=="svelte-1q705lb"&&(wt.innerHTML=bo),br=r(F),At=n(F,"P",{"data-svelte-h":!0}),s(At)!=="svelte-14ul3re"&&(At.innerHTML=_o),_r=r(F),X=n(F,"DIV",{class:!0});var ya=u(X);d(Me.$$.fragment,ya),yr=r(ya),Lt=n(ya,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-1gr03w4"&&(Lt.textContent=yo),ya.forEach(i),F.forEach(i),aa=r(e),I=n(e,"DIV",{class:!0});var Rt=u(I);d(Pe.$$.fragment,Rt),xr=r(Rt),Ct=n(Rt,"P",{"data-svelte-h":!0}),s(Ct)!=="svelte-5vv99d"&&(Ct.textContent=xo),$r=r(Rt),J=n(Rt,"DIV",{class:!0});var xa=u(J);d(Ne.$$.fragment,xa),wr=r(xa),Tt=n(xa,"P",{"data-svelte-h":!0}),s(Tt)!=="svelte-1gr03w4"&&(Tt.textContent=$o),xa.forEach(i),Rt.forEach(i),ra=r(e),Fe=n(e,"DIV",{class:!0});var No=u(Fe);d(Ie.$$.fragment,No),No.forEach(i),oa=r(e),_=n(e,"DIV",{class:!0});var A=u(_);d(Re.$$.fragment,A),Ar=r(A),Dt=n(A,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-1tqv0s5"&&(Dt.textContent=wo),Lr=r(A),zt=n(A,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-g10xv4"&&(zt.textContent=Ao),Cr=r(A),Mt=n(A,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-1acg3vg"&&(Mt.textContent=Lo),Tr=r(A),Pt=n(A,"OL",{"data-svelte-h":!0}),s(Pt)!=="svelte-15y6o6y"&&(Pt.innerHTML=Co),Dr=r(A),Nt=n(A,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1yvkj2h"&&(Nt.innerHTML=To),zr=r(A),Ft=n(A,"P",{"data-svelte-h":!0}),s(Ft)!=="svelte-53x1ow"&&(Ft.innerHTML=Do),Mr=r(A),K=n(A,"DIV",{class:!0});var $a=u(K);d(He.$$.fragment,$a),Pr=r($a),It=n($a,"P",{"data-svelte-h":!0}),s(It)!=="svelte-1gr03w4"&&(It.textContent=zo),$a.forEach(i),A.forEach(i),na=r(e),Ee=n(e,"DIV",{class:!0});var Fo=u(Ee);d(Ge.$$.fragment,Fo),Fo.forEach(i),ia=r(e),d(Se.$$.fragment,e),ma=r(e),Et=n(e,"P",{}),u(Et).forEach(i),this.h()},h(){v(G,"name","hf:doc:metadata"),v(G,"content",Vo),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,m){t(document.head,G),l(e,Gt,m),l(e,Ht,m),l(e,St,m),c(te,e,m),l(e,Ot,m),l(e,ae,m),l(e,Bt,m),c(re,e,m),l(e,Vt,m),c(oe,e,m),l(e,qt,m),l(e,S,m),c(ne,S,null),t(S,Aa),t(S,Oe),l(e,Wt,m),l(e,z,m),c(ie,z,null),t(z,La),t(z,Be),t(z,Ca),t(z,Ve),t(z,Ta),t(z,qe),l(e,kt,m),c(me,e,m),l(e,jt,m),l(e,x,m),c(se,x,null),t(x,Da),t(x,We),t(x,za),t(x,ke),t(x,Ma),t(x,je),t(x,Pa),t(x,Ue),t(x,Na),t(x,O),c(le,O,null),t(O,Fa),t(O,Ze),l(e,Ut,m),l(e,L,m),c(pe,L,null),t(L,Ia),t(L,Qe),t(L,Ra),t(L,Xe),t(L,Ha),t(L,Je),t(L,Ea),t(L,B),c(de,B,null),t(B,Ga),t(B,Ke),l(e,Zt,m),l(e,$,m),c(ce,$,null),t($,Sa),t($,Ye),t($,Oa),t($,V),c(ge,V,null),t(V,Ba),t(V,et),t($,Va),t($,q),c(fe,q,null),t(q,qa),t(q,tt),t($,Wa),t($,W),c(he,W,null),t(W,ka),t(W,at),t($,ja),t($,k),c(ue,k,null),t(k,Ua),t(k,rt),l(e,Qt,m),l(e,ve,m),c(be,ve,null),l(e,Xt,m),l(e,C,m),c(_e,C,null),t(C,Za),t(C,ot),t(C,Qa),t(C,nt),t(C,Xa),t(C,it),t(C,Ja),t(C,j),c(ye,j,null),t(j,Ka),t(j,mt),l(e,Jt,m),l(e,T,m),c(xe,T,null),t(T,Ya),t(T,st),t(T,er),t(T,lt),t(T,tr),t(T,pt),t(T,ar),t(T,U),c($e,U,null),t(U,rr),t(U,dt),l(e,Kt,m),l(e,M,m),c(we,M,null),t(M,or),t(M,ct),t(M,nr),t(M,gt),t(M,ir),t(M,Z),c(Ae,Z,null),t(Z,mr),t(Z,ft),l(e,Yt,m),l(e,Le,m),c(Ce,Le,null),l(e,ea,m),l(e,y,m),c(Te,y,null),t(y,sr),t(y,ht),t(y,lr),t(y,ut),t(y,pr),t(y,vt),t(y,dr),t(y,bt),t(y,cr),t(y,_t),t(y,gr),t(y,Q),c(De,Q,null),t(Q,fr),t(Q,yt),l(e,ta,m),l(e,w,m),c(ze,w,null),t(w,hr),t(w,xt),t(w,ur),t(w,$t),t(w,vr),t(w,wt),t(w,br),t(w,At),t(w,_r),t(w,X),c(Me,X,null),t(X,yr),t(X,Lt),l(e,aa,m),l(e,I,m),c(Pe,I,null),t(I,xr),t(I,Ct),t(I,$r),t(I,J),c(Ne,J,null),t(J,wr),t(J,Tt),l(e,ra,m),l(e,Fe,m),c(Ie,Fe,null),l(e,oa,m),l(e,_,m),c(Re,_,null),t(_,Ar),t(_,Dt),t(_,Lr),t(_,zt),t(_,Cr),t(_,Mt),t(_,Tr),t(_,Pt),t(_,Dr),t(_,Nt),t(_,zr),t(_,Ft),t(_,Mr),t(_,K),c(He,K,null),t(K,Pr),t(K,It),l(e,na,m),l(e,Ee,m),c(Ge,Ee,null),l(e,ia,m),c(Se,e,m),l(e,ma,m),l(e,Et,m),sa=!0},p:Ro,i(e){sa||(g(te.$$.fragment,e),g(re.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(ie.$$.fragment,e),g(me.$$.fragment,e),g(se.$$.fragment,e),g(le.$$.fragment,e),g(pe.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(be.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(we.$$.fragment,e),g(Ae.$$.fragment,e),g(Ce.$$.fragment,e),g(Te.$$.fragment,e),g(De.$$.fragment,e),g(ze.$$.fragment,e),g(Me.$$.fragment,e),g(Pe.$$.fragment,e),g(Ne.$$.fragment,e),g(Ie.$$.fragment,e),g(Re.$$.fragment,e),g(He.$$.fragment,e),g(Ge.$$.fragment,e),g(Se.$$.fragment,e),sa=!0)},o(e){f(te.$$.fragment,e),f(re.$$.fragment,e),f(oe.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(me.$$.fragment,e),f(se.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(be.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Ae.$$.fragment,e),f(Ce.$$.fragment,e),f(Te.$$.fragment,e),f(De.$$.fragment,e),f(ze.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(Ne.$$.fragment,e),f(Ie.$$.fragment,e),f(Re.$$.fragment,e),f(He.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),sa=!1},d(e){e&&(i(Gt),i(Ht),i(St),i(Ot),i(ae),i(Bt),i(Vt),i(qt),i(S),i(Wt),i(z),i(kt),i(jt),i(x),i(Ut),i(L),i(Zt),i($),i(Qt),i(ve),i(Xt),i(C),i(Jt),i(T),i(Kt),i(M),i(Yt),i(Le),i(ea),i(y),i(ta),i(w),i(aa),i(I),i(ra),i(Fe),i(oa),i(_),i(na),i(Ee),i(ia),i(ma),i(Et)),i(G),h(te,e),h(re,e),h(oe,e),h(ne),h(ie),h(me,e),h(se),h(le),h(pe),h(de),h(ce),h(ge),h(fe),h(he),h(ue),h(be),h(_e),h(ye),h(xe),h($e),h(we),h(Ae),h(Ce),h(Te),h(De),h(ze),h(Me),h(Pe),h(Ne),h(Ie),h(Re),h(He),h(Ge),h(Se,e)}}}const Vo='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer","sections":[],"depth":3},{"title":"Optimizer Classes","local":"timm.optim.AdaBelief","sections":[],"depth":3}],"depth":2}],"depth":1}';function qo(Nr){return Ho(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zo extends Eo{constructor(G){super(),Go(this,G,qo,Bo,Io,{})}}export{Zo as component};
