# A deep dive on the NPC-Playground

## The Tech Stack

To create this demo, the teams used three main tools:

- [Cubzh](https://github.com/cubzh/cubzh): the cross-platform UGC (User Generated Content) game engine.

- [Gigax](https://github.com/GigaxGames/gigax): the engine for smart NPCs.

- [Hugging Face Spaces](https://huggingface.co/spaces): the most convenient online environment to host and iterate on game concepts in an open-source fashion.

## What is Cubzh?

[Cubzh](https://github.com/cubzh/cubzh) is a cross-platform UGC game engine, that aims to provide an open-source alternative to Roblox.

It offers a **rich gaming environment where users can create their own game experiences and play with friends**.

<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/181_npc-gigax-cubzh/gigax.gif" alt="Cubzh"/>

In Cubzh, you can:

- **Create your own worlds items and avatars**.

- Build fast, using community **made voxel items** (+25K so far in the library) and **open-source Lua modules**.

- **Code games using a simple yet powerful Lua scripting API**.

Cubzh is in public Alpha. You can download and play Cubzh for free on Desktop via [Steam](https://store.steampowered.com/app/1386770/Cubzh_Open_Alpha/), [Epic Game Store](https://store.epicgames.com/en-US/p/cubzh-3cc767), or on Mobile via [Apple's App Store](https://apps.apple.com/th/app/cubzh/id1478257849), [Google Play Store](https://play.google.com/store/apps/details?id=com.voxowl.pcubes.android&hl=en&gl=US&pli=1) or even play directly from your [browser](https://app.cu.bzh/).

In this demo, Cubzh serves as the **game engine** running directly within a Hugging Face Space, users can easily clone it to experiment with custom scripts and NPC personas.


## What is Gigax?

[Gigax](https://github.com/GigaxGames/gigax) is the platform game developers use to run **LLM-powered NPCs at scale**.

Gigax has fine-tuned large language models for NPC interactions, **using the "function calling" principle.**

It's easier to think about this in terms of input/output flow:

- In **input**, the model reads [a text description](https://github.com/GigaxGames/gigax/blob/main/gigax/prompt.py) of a 3D scene, alongside a description of the recent events and a list of the NPC's available actions (e.g., `<say>`, `<jump>`, `<attack>`, etc.).

- The model then **outputs** one of these actions using parameters that refer to 3D entities that exist in the scene, e.g. `say NPC1 "Hello, Captain!"`.

<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/181_npc-gigax-cubzh/gigax.png" alt="gigax" />

Gigax has **open-sourced their stack!** 
You can clone their [inference stack on Github](https://github.com/GigaxGames/gigax).
For this demo, their models are hosted in the cloud, but you can [download them yourself on the 🤗 Hub](https://huggingface.co/Gigax):
- [Phi-3 fine-tuned model](https://huggingface.co/Gigax/NPC-LLM-3_8B)
- [Mistral-7B fine-tuned model](https://huggingface.co/Gigax/NPC-LLM-7B)


<EditOnGithub source="https://github.com/huggingface/making-games-with-ai-course/blob/main/units/en/unit3/demo.mdx" />