# Code Assistants 👩‍💻

Code Assistants are helpful when you **need help coding a function or when you find a bug in your code and want to know why**.

## Unity Muse Chat 💸 🔒

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/muse.jpg" alt="Muse chat" />

Muse Chat is a **conversation AI in Unity Editor** that can answer your Unity questions and help you with code and debugging.

What's impressive about this tool is that **it's context-aware of the project.** This means it has information about your project, the game objects, etc., so you don't need **to explain it in the prompt.**

It's a handy **tool to accelerate your game development workflow**.

For instance, I'm using it to help me build the next unit demo: it's an **action-adventure game about aliens 👽 invading a space station. Your goal is to outsmart them and flee.**

<iframe width="560" height="315" src="https://www.youtube.com/embed/MJyUCiZB0uw?si=1eXnLU9hbMaNi4wm" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

You can win the game by leaving the station, but to do that, you need to find your equipment, escape hatch password, etc., without getting noticed.

Sounds exciting? **It's a demo you'll be able to play and modify during this course 🔥**

For this game, I need the red light to flicker **to convey the sense of alertness in the space station.**

So, I clicked on my point light and **asked Muse how to create this.**

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/musechat_example_1.png" alt="Muse chat Example 1" />

What's impressive about Muse is that in addition to providing the code, it shared with me a **well-defined explanation of why the code works this way and its sources.**

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/musechat_example_2.png" alt="Muse chat Example 2" />
<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/musechat_example_3.png" alt="Muse chat Example 3" />
<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/musechat_example_4.png" alt="Muse chat Example 4" />

And this is the result:

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/light.gif" alt="Muse chat Light example" />


If you want to try it:

👉 [Muse Website (15 days free)](https://unity.com/products/muse)

👉 [They wrote a tutorial on the best practices](https://learn.unity.com/tutorial/get-started-with-muse-chat#)

## GitHub Copilot 💸 🔒

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/github_copilot.jpg" alt="GitHub Copilot" />

If you're not using Unity but another game engine, you should use GitHub Copilot. **It's one of my favorite tools when I code in Python.**

**Copilot is not a free tool**, but it's **free for verified students, teachers, and maintainers of popular open-source projects**. So, if you contributed to open-source projects, **you are eligible to use it for free.**

👉 [Copilot Website](https://github.com/features/copilot)

<EditOnGithub source="https://github.com/huggingface/making-games-with-ai-course/blob/main/units/en/unit2/code-assistants.mdx" />