# 2D Assets Generation 🎮

One **of the most critical elements in game development for 2D games is the ability to produce high-quality 2D assets with a beautiful aesthetic.**

For a long time, AI was **unusable because of its lack of consistency** (you were not able to generate the perfectly same character in multiple generations, for instance). Fortunately, with LoRA and other innovations, this problem is a thing of the past.

In this section, I'll present my favorite tool it's [Scenario](https://www.scenario.com/) ❤️ It's an impressive tool **we will use in a future Unit of the course.**


## Scenario 🤗🔒💸

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/scenario.jpg" alt="Scenario"/>

[Scenario](https://www.scenario.com/) is a platform that allows you **to generate 2D assets using text-to-image models and fine-tune these models with specific styles.**

The foundation model is Stable Diffusion (SD 1.5 and SDXL), two **open-source models.**

The power of Scenario comes from its platform and its powerful tools.

First, you can **easily fine-tune your own LoRA** using generated images or original ones.

Or you can **create a composition using Scenario’s library of Platform Models** and even blend them with your own.

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/ScenarioLoRAComposition_new.png" alt="Scenario Scene Example" />

You can do the same for characters.

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/ScenarioCharacterLoRAComposition_new.png" alt="Scenario Character Example" />

- With the upscaler tool you can increase **the quality of the output up to 10k resolution** and **correct some artifacts made by the generation.**

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/upscale.gif" alt="Upscaler" />

Here you can see some examples of content you can make with it:

- **A platformer**

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/ScenarioPlatformerImage_new.png" alt="Scenario Example" />

To see an example in video 👇

<iframe width="560" height="315" src="https://www.youtube.com/embed/txrCuIQlb80?si=IVxf5VKgcLmQCIgz&amp;start=3" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

If you want to make your own platformer then, check this tutorial 👉  [Designing a Unity Platformer Level: Scenario Development](https://help.scenario.com/designing-a-unity-platformer-level-scenario-development)

- **Buildings for 2D RTS Games**

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/rts_example1.gif" alt="Scenario RTS example" />

See in video **how easy it is to reskin your isometric building assets** 👇

<iframe width="560" height="315" src="https://www.youtube.com/embed/45dh2pMllRw?si=tKd-Qn5wCt7X_ITc" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit2/rts.png" alt="Scenario RTS example" />

Tutorial: Build an Isometric City 👉 https://www.scenario.com/post/isometric-city-builder

There are so much more tools and features to cover, **but the best is that you try them by yourself** 👉 https://www.scenario.com/

Scenario Documentation 👉 https://help.scenario.com/

Scenario Twitter Profile (for the latest updates) 👉 https://twitter.com/Scenario_gg


<EditOnGithub source="https://github.com/huggingface/making-games-with-ai-course/blob/main/units/en/unit2/2d-generation.mdx" />