# What is Hugging Face 🤗?

Hugging Face is a platform where users can **upload, find and download pre-trained AI models in more than 35 different tasks from text generation with Llama v2, speech-to-text with Whisper, text-to-speech (AI voices) with Coqui to 3D generation**.

For many of these models, Hugging Face also provides a service called Inference API that allows you to use them via simple API calls. This service is free for prototyping and experimentation, but is subject to rate limiting. There are also paid inference services for production workloads.

## So how can I select a Sentence Similarity Model on Hugging Face 🤗?

All the AI models are listed here https://huggingface.co/models. On the left of this page, you have the differents tasks.

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit1/unity/models1.jpg" alt="HF models 1"/>


In our case you want to select Sentence Similarity.

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit1/unity/models2.jpg" alt="HF models 2"/>

Now we have a list of Sentence Similarity models (approximately 3,000).

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit1/unity/models3.jpg" alt="HF models 3"/>

If you click on one of them, you'll usually see a widget, that allows you to **try the model directly on your browser**. This way you can test and see if it fits your needs.

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/unit1/unity/models4.jpg" alt="HF models 4"/>


Now that we understood Sentence Similarity, the difference between local and remote model inference, and what's Hugging Face, we're ready to make our demo 🤖!

<EditOnGithub source="https://github.com/huggingface/making-games-with-ai-course/blob/main/units/en/unit1/what-is-hf.mdx" />