# Step 1: Crafting the Game Idea 💡

The first step to build a compelling demo is to **have a compelling game idea**. But how do you find the perfect one?

This video, from [AskGameDev](https://www.youtube.com/@AskGamedev) gives nice advice. In addition to them, we wrote ours below.

<iframe width="560" height="315" src="https://www.youtube.com/embed/fDqnw5pNebk?si=83Au99UbYkCmSSJ2" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

## Advice 1: Embrace Your Constraints

Innovation often **thrives within limitations**. Identify your current skill set and consider games that align with your abilities. 

For example, I'm currently developing a detective game demo where players must interview suspects to unveil the culprit. Because **I can't animate human face even with current tools (would take too much time and too expansive)** I decided that the game will use a phone system to interview suspects.

## Advice 2: Draw Inspiration from Your Favorites Games

Explore the games you love playing. **Is there a specific element within a game that captivates you?**

Maybe there's a small feature or mechanic you'd like to recreate in your own project.

## Advice 3: Think how you can add AI to improve the gameplay

Consider how incorporating AI elements can make your this small game feature or mechanic you like better?

## Advice 4: Beware of the Scope Curse

No you'll not build a Starfield clone. Keep your project manageable by **defining clear boundaries**. 

Your Game Demo needs to be very small: it's a working prototype, not a full game. Remember **it's better to get a working very small demo that you can iterate after the course than a big idea with awesome features that does not work**.

Don't hesitate to check this video:

<iframe width="560" height="315" src="https://www.youtube.com/embed/bh0F9m1O4gk?si=TKjyXGL1oqjuIvGE" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

## Advice 5: Brainstorm with HuggingChat

If you're stuck, why not typing some game ideas you have and **ask the help of [Hugging Chat](https://huggingface.co/chat/)**?

<img src="https://huggingface.co/datasets/huggingface-ml-4-games-course/course-images/resolve/main/en/demo-unit1/huggingchat.jpg" alt="Hugging Chat"/>


---
Now that **your idea is defined**, it's time to write the Game Design Document, which is your one page document **that will help you plan and manage the development of your game demo**.



<EditOnGithub source="https://github.com/huggingface/making-games-with-ai-course/blob/main/units/en/demo1/game-idea.mdx" />