# Introduction:

<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit13/thumbnail.png" alt="Unit bonus 4 thumbnail"/>

Welcome to this bonus unit, where you will **train a robot agent to complete a mini-game level using imitation learning.**

At the end of the unit, **you will have a trained agent capable of solving the level as in the video**:

<video src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit13/onnx_inference_test.mp4" type="video/mp4" controls autoplay loop mute />


## Objectives:

- Learn how to use imitation learning with Godot RL Agents by training an agent to complete a mini-game environment using human-recorded expert demonstrations.

## Prerequisites and requirements:

- It is recommended that you complete the previous chapter ([Godot RL Agents](https://huggingface.co/learn/deep-rl-course/unitbonus3/godotrl)) before starting this tutorial,
- Some familiarity with Godot is recommended, although completing the tutorial does not require any gdscript coding knowledge,
- Godot with .NET support (tested to work with [4.3.dev5 .NET](https://godotengine.org/article/dev-snapshot-godot-4-3-dev-5/), may work with newer versions too),
- Godot RL Agents (you can use `pip install godot-rl` in the venv/conda env),
- [Imitation library](https://huggingface.co/learn/deep-rl-course/unitbonus5/train-our-robot),
- Time: ~1-2 hours to complete the project and training. It can be outside of this range depending on the hardware used.


<EditOnGithub source="https://github.com/huggingface/deep-rl-class/blob/main/units/en/unitbonus5/introduction.mdx" />