# Student Works

Since the launch of the Deep Reinforcement Learning Course, **many students have created amazing projects that you should check out and consider participating in**.

If you've created an interesting project, don't hesitate to [add it to this list by opening a pull request on the GitHub repository](https://github.com/huggingface/deep-rl-class).

The projects are **arranged based on the date of publication in this page**.


## Space Scavanger AI

This project is a space game environment with trained neural network for AI.

AI is trained by Reinforcement learning algorithm based on UnityMLAgents and RLlib frameworks.

<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit12/spacescavangerai.png" alt="Space Scavanger AI"/>

Play the Game here 👉  https://swingshuffle.itch.io/spacescalvagerai

Check the Unity project here 👉 https://github.com/HighExecutor/SpaceScalvagerAI


## Neural Nitro 🏎️

<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit12/neuralnitro.png" alt="Neural Nitro" />

In this project, Sookeyy created a low poly racing game and trained a car to drive.

Check out the demo here 👉 https://sookeyy.itch.io/neuralnitro


## Space War 🚀

<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit12/spacewar.jpg" alt="SpaceWar" />

In this project, Eric Dong recreates Bill Seiler's 1985 version of Space War in Pygame and uses reinforcement learning (RL) to train AI agents.

This project is currently in development!

### Demo

Dev/Edge version:
* https://e-dong.itch.io/spacewar-dev

Stable version:
* https://e-dong.itch.io/spacewar
* https://huggingface.co/spaces/EricofRL/SpaceWarRL

### Community blog posts

TBA

### Other links

Check out the source here 👉 https://github.com/e-dong/space-war-rl  
Check out his blog here 👉 https://dev.to/edong/space-war-rl-0-series-introduction-25dh


## Decision Transformers for Trading

In this project, student has explored training a Decision Transformer for stock trading. In phase-1, offline training has been implemented. He intends to incorporate online fine-tuning in the next version.

<figure>
<img src="https://github.com/user-attachments/assets/41e3bc10-2594-4c05-b48f-17666cc8fb1c" alt="DT for Trading"/>

<figcaption> 
    
Source: <a href="https://www.youtube.com/watch?v=w4Bw8WYL8Ps"> Stanford CS25: V1 I Decision Transformer: Reinforcement Learning via Sequence Modeling</a> </figcaption>

</figure>

Check out the source here 👉 https://github.com/ra9hur/Decision-Transformers-For-Trading


<EditOnGithub source="https://github.com/huggingface/deep-rl-class/blob/main/units/en/unitbonus3/student-works.mdx" />