import{s as ll,f as bt,o as sl}from"../chunks/scheduler.37c15a92.js";import{S as nl,i as ol,g as a,s as n,r as d,A as al,h as i,f as l,c as o,j as Tt,u as m,x as p,k as T,y as il,a as s,v as M,d as h,t as y,w as u,m as Ut,n as Jt}from"../chunks/index.7cb9c9b8.js";import{T as ut}from"../chunks/Tip.d10b3fc9.js";import{C as wt}from"../chunks/CodeBlock.abae2786.js";import{H as J,E as cl}from"../chunks/getInferenceSnippets.15b814d1.js";function rl(b){let c;return{c(){c=Ut("You can search for “robot” in the FileSystem search.")},l(r){c=Jt(r,"You can search for “robot” in the FileSystem search.")},m(r,w){s(r,c,w)},d(r){r&&l(c)}}}function pl(b){let c;return{c(){c=Ut("You might have to collapse the “robot” branch to find it more easily, or you can type `aicontroller` in the Filter box above the `Robot` node.")},l(r){c=Jt(r,"You might have to collapse the “robot” branch to find it more easily, or you can type `aicontroller` in the Filter box above the `Robot` node.")},m(r,w){s(r,c,w)},d(r){r&&l(c)}}}function dl(b){let c;return{c(){c=Ut("You can search for “demo” in the FileSystem search, and you can search for “aicontroller” in the scene's filter box.")},l(r){c=Jt(r,"You can search for “demo” in the FileSystem search, and you can search for “aicontroller” in the scene's filter box.")},m(r,w){s(r,c,w)},d(r){r&&l(c)}}}function ml(b){let c;return{c(){c=Ut('Note that the demos will only be saved if we have recorded at least one complete episode and closed the game window by clicking on "X" or pressing ALT+F4. Using the stop button in Godot editor will not save the demos. It’s best to try recording just one episode first, then check if you see "expert_demos.json" in the filesystem or in the Godot project folder.')},l(r){c=Jt(r,'Note that the demos will only be saved if we have recorded at least one complete episode and closed the game window by clicking on "X" or pressing ALT+F4. Using the stop button in Godot editor will not save the demos. It’s best to try recording just one episode first, then check if you see "expert_demos.json" in the filesystem or in the Godot project folder.')},m(r,w){s(r,c,w)},d(r){r&&l(c)}}}function Ml(b){let c,r,w,Ue,Z,Je,g,ft='To get started, download the project from <a href="https://huggingface.co/ivan267/imitation-learning-tutorial-godot-project/tree/main" rel="nofollow">here</a> (click on the download icon next to <code>GDRL-IL-Project.zip</code>). The zip file features both the “Starter” and “Complete” projects.',be,_,jt="The game code is already implemented in the starter project and the nodes are configured. We will focus on:",Te,G,vt="<li>Implementing the code for the AIController node,</li> <li>Recording expert demonstrations,</li> <li>Training the agent and exporting an .onnx file which we can use for inference in Godot.</li>",fe,W,je,S,It="Extract the zip file, open Godot, click “Import” and navigate to the <code>Starter\\Godot</code> folder of the extracted archive.",ve,k,Ie,f,Ze,B,Zt="This scene contains a couple of different nodes, including the <code>robot</code> node, which contains the visual shape of the robot, <code>CameraXRotation</code> node which is used to rotate the camera “up-down” using the mouse in human control modes. The AI agent does not control this node since it is not necessary for learning the task. <code>RaycastSensors</code> node contains two Raycast sensors that help the agent to “sense” parts of the game world, including walls, floors, etc.",ge,X,gt,_e,V,Ge,j,We,C,Se,$,ke,Y,_t="In <code>get_obs()</code>, we first get the obs from the two Raycast sensors added to the <code>AIController3D</code> node in the inspector, and add them to the obs, then we get the relative position vectors to chest, lever, key, and raft, which we separate into directions and distances, and then we add them to the obs as well.",Be,Q,Gt="We also add other game state info to the obs:",Xe,x,Wt="<li>has the lever has been pulled,</li> <li>was the key collected,</li> <li>was the chest opened,</li> <li>is the player on floor (also determines whether the player can jump),</li> <li>the normalized local velocity of the player.</li>",Ve,R,St="We convert boolean values such as <code>_is_lever_pulled</code> to floats (0 or 1).",Ce,F,kt="In <code>get_reward()</code>, we only need to return the current reward.",$e,N,Ye,E,Qe,A,xe,z,Re,D,Bt="For <code>get_action()</code> (only needed if using the demo record mode), we need to provide the actions that we want the agent to send when it encounters the same state. It is important for the values to be in the correct range (<code>-1.0 to 1.0</code>), which is why we have the <code>-1 + 2 * variable</code> for boolean states, and in the correct order, as defined in <code>get_action_space()</code>.",Fe,H,Xt="In demo record mode, <code>set_action()</code> is called without providing actions, as we need to set the action values based on human input. In training/inference modes, the method is called with an <code>action</code> argument containing values for all of the actions provided by the RL model, so we have an <code>if/else</code> to handle both cases.",Ne,O,Vt="More info is included in the code comments.",Ee,q,Ae,L,ze,K,Ct="This code part records mouse movement in case of human control and demo record modes.",De,P,$t="<strong>Finally, save the script. We are ready for the next step.</strong>",He,ee,Oe,v,qe,te,Yt,Le,le,Qt="You don’t need to make any changes as everything is preset, but let’s go over the things you would need to set in your own env:",Ke,se,xt="The scene contains modified <code>Level &gt; Robot &gt; AIController3D</code> node settings:",Pe,ne,Rt="<li><code>Control Mode</code> is set to <code>Record Expert Demos</code></li> <li><code>Expert Demo Save Path</code> is filled out</li> <li><code>Action Repeat</code> is set to the same value as is set for the <code>Sync</code> node in <code>training_scene</code> and <code>onnx_inference_scene</code>. This means that every action set by the agent is repeated for 3 physics frames. The setting in <code>AIController</code> adds the same action repeat to the human input (which introduces some lag) to match the same behavior. This is a fairly low value which doesn’t introduce much lag. If you change this value, make sure to change it in all 3 places.</li> <li><code>Remove Last Episode</code> key allows us to set a key that can be used to remove a failed episode during recording, without having to restart the entire session. E.g. if the robot falls in the water and the game resets, we can use this key to remove the previously recorded episode while recording the next one. It is set to <code>R</code>, but you can change it to any key by clicking on it, and then clicking on the <code>Configure</code> button.</li>",et,oe,Ft="Another way to make episode recording easier in challenging environments is to slow down the environment during recording. This can easily be done by clicking on the <code>Sync</code> node in the scene, and adjusting the <code>Speed Up</code> property (set to 1 by default).",tt,ae,lt,I,st,ie,Nt="Make sure that you are still in the <code>demo_record_scene</code>, <code>press F6</code> and the demo recording will start.",nt,ce,Et="Controls:",ot,re,At="<li>mouse controls the camera (if you need to adjust mouse sensitivity, open the <code>robot</code> scene, click on the <code>Robot</code> node and adjust the <code>Rotation Speed</code>, keep it the same value for recording demos, training and inference),</li> <li><code>WASD</code> controls the player movement,</li> <li><code>SPACE</code> jumps,</li> <li><code>E</code> activates the lever and opens the chest</li>",at,pe,zt="You can take a few practice first to get familiar with the env. If you wish to skip recording demos, you can also find the pre-recorded demos in the completed project and use the <code>expert_demos.json</code> file from there.",it,de,Dt="The recorded demos should include at least 22-24 complete successful episodes. Multiple demo files can also be used in the training stage, so you don’t have to record all demos in one go (you can change the file name using the <code>Expert Demo Save Path</code> property mentioned before).",ct,me,Ht="Recording 23 episodes took me ~10 minutes (as the key has 2 alternating spawning positions, 22 or 24 would provide an equal distribution of key positions in the demos, but it is fairly close). When approaching the lever or chest, I pressed and held the <code>E</code> key slightly longer to ensure the action is recorded for multiple steps when near those objects. I also removed a couple of episodes that I didn’t complete successfully by pressing the <code>R</code> key during the following episode.",rt,Me,Ot="Here’s a sped-up video of the demo recording process:",pt,U,qt,dt,he,mt,ye,Lt="You can export the game from Godot using <code>Project &gt; Export</code>.",Mt,ue,ht,we,yt;return Z=new J({props:{title:"Getting started:",local:"getting-started",headingTag:"h1"}}),W=new J({props:{title:"Open the starter project in Godot",local:"open-the-starter-project-in-godot",headingTag:"h3"}}),k=new J({props:{title:"Open the robot scene",local:"open-the-robot-scene",headingTag:"h3"}}),f=new ut({props:{$$slots:{default:[rl]},$$scope:{ctx:b}}}),V=new J({props:{title:"Click on the scroll next to AIController3D to open the script for editing",local:"click-on-the-scroll-next-to-aicontroller3d-to-open-the-script-for-editing",headingTag:"h3"}}),j=new ut({props:{$$slots:{default:[pl]},$$scope:{ctx:b}}}),C=new J({props:{title:"Replace the get_obs() and get_reward() methods with the implementation below:",local:"replace-the-getobs-and-getreward-methods-with-the-implementation-below",headingTag:"h3"}}),$=new wt({props:{code:"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",highlighted:`func get_obs() -&gt; Dictionary:
	var observations: Array[<span class="hljs-built_in">float</span>] = []
	<span class="hljs-keyword">for</span> raycast_sensor <span class="hljs-keyword">in</span> raycast_sensors:
		observations.append_array(raycast_sensor.get_observation())

	var level_size = <span class="hljs-number">16.0</span>

	var chest_local = to_local(chest.global_position)
	var chest_direction = chest_local.normalized()
	var chest_distance = clampf(chest_local.length(), <span class="hljs-number">0.0</span>, level_size)
	
	var lever_local = to_local(lever.global_position)
	var lever_direction = lever_local.normalized()
	var lever_distance = clampf(lever_local.length(), <span class="hljs-number">0.0</span>, level_size)
		
	var key_local = to_local(key.global_position)
	var key_direction = key_local.normalized()
	var key_distance = clampf(key_local.length(), <span class="hljs-number">0.0</span>, level_size)
	
	var raft_local = to_local(raft.global_position)
	var raft_direction = raft_local.normalized()
	var raft_distance = clampf(raft_local.length(), <span class="hljs-number">0.0</span>, level_size)
	
	var player_speed = player.global_basis.inverse() * player.velocity.limit_length(<span class="hljs-number">5.0</span>) / <span class="hljs-number">5.0</span>

	(
		observations
		.append_array(
			[
				chest_direction.x,
				chest_direction.y,
				chest_direction.z,
				chest_distance,
				lever_direction.x,
				lever_direction.y,
				lever_direction.z,
				lever_distance,
				key_direction.x,
				key_direction.y,
				key_direction.z,
				key_distance,
				raft_direction.x,
				raft_direction.y,
				raft_direction.z,
				raft_distance,
				raft.movement_direction_multiplier,
				<span class="hljs-built_in">float</span>(player._is_lever_pulled),
				<span class="hljs-built_in">float</span>(player._is_chest_opened),
				<span class="hljs-built_in">float</span>(player._is_key_collected),
				<span class="hljs-built_in">float</span>(player.is_on_floor()),
				player_speed.x,
				player_speed.y,
				player_speed.z,
			]
		)
	)
	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>: observations}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">return</span> reward`,wrap:!1}}),N=new J({props:{title:"Replace the _physics_process() and reset() methods with the implementation below:",local:"replace-the-physicsprocess-and-reset-methods-with-the-implementation-below",headingTag:"h3"}}),E=new wt({props:{code:"ZnVuYyUyMF9waHlzaWNzX3Byb2Nlc3MoZGVsdGElM0ElMjBmbG9hdCklMjAtJTNFJTIwdm9pZCUzQSUwQSUwOSUyMyUyMFJlc2V0JTIwb24lMjB0aW1lb3V0JTJDJTIwdGhpcyUyMGlzJTIwaW1wbGVtZW50ZWQlMjBpbiUyMHBhcmVudCUyMGNsYXNzJTIwdG8lMjBzZXQlMjBuZWVkc19yZXNldCUyMHRvJTIwdHJ1ZSUyQyUwQSUwOSUyMyUyMHdlJTIwYXJlJTIwcmUtaW1wbGVtZW50aW5nJTIwaGVyZSUyMHRvJTIwY2FsbCUyMHBsYXllci5nYW1lX292ZXIoKSUyMHRoYXQlMjBoYW5kbGVzJTIwdGhlJTIwZ2FtZSUyMHJlc2V0LiUwQSUwOW5fc3RlcHMlMjAlMkIlM0QlMjAxJTBBJTA5aWYlMjBuX3N0ZXBzJTIwJTNFJTIwcmVzZXRfYWZ0ZXIlM0ElMEElMDklMDlwbGF5ZXIuZ2FtZV9vdmVyKCklMEElMEElMDklMjMlMjBJbiUyMHRyYWluaW5nJTIwb3IlMjBvbm54JTIwaW5mZXJlbmNlJTIwbW9kZXMlMkMlMjB0aGlzJTIwbWV0aG9kJTIwd2lsbCUyMGJlJTIwY2FsbGVkJTIwYnklMjBzeW5jJTIwbm9kZSUyMHdpdGglMjBhY3Rpb25zJTIwcHJvdmlkZWQlMkMlMEElMDklMjMlMjBGb3IlMjBleHBlcnQlMjBkZW1vJTIwcmVjb3JkaW5nJTIwbW9kZSUyQyUyMGl0JTIwd2lsbCUyMGJlJTIwY2FsbGVkJTIwd2l0aG91dCUyMGFueSUyMGFjdGlvbnMlMjAoYXMlMjB3ZSUyMHNldCUyMHRoZSUyMGFjdGlvbnMlMjBiYXNlZCUyMG9uJTIwaHVtYW4lMjBpbnB1dCklMkMlMEElMDklMjMlMjBGb3IlMjBodW1hbiUyMGNvbnRyb2wlMjBtb2RlJTIwdGhlJTIwbWV0aG9kJTIwd2lsbCUyMG5vdCUyMGJlJTIwY2FsbGVkJTJDJTIwc28lMjB3ZSUyMGNhbGwlMjBpdCUyMGhlcmUlMjB3aXRob3V0JTIwYW55JTIwYWN0aW9ucyUyMHByb3ZpZGVkLiUwQSUwOWlmJTIwY29udHJvbF9tb2RlJTIwJTNEJTNEJTIwQ29udHJvbE1vZGVzLkhVTUFOJTNBJTBBJTA5JTA5c2V0X2FjdGlvbigpJTBBJTBBJTA5JTIzJTIwUmVzZXQlMjB0aGUlMjBnYW1lJTIwZmFzdGVyJTIwaWYlMjB0aGUlMjBsZXZlciUyMGlzJTIwbm90JTIwcHVsbGVkLiUwQSUwOXN0ZXBzX3dpdGhvdXRfbGV2ZXJfcHVsbGVkJTIwJTJCJTNEJTIwMSUwQSUwOWlmJTIwc3RlcHNfd2l0aG91dF9sZXZlcl9wdWxsZWQlMjAlM0UlMjAyMDAlMjBhbmQlMjAobm90JTIwcGxheWVyLl9pc19sZXZlcl9wdWxsZWQpJTNBJTBBJTA5JTA5cGxheWVyLmdhbWVfb3ZlcigpJTBBJTBBZnVuYyUyMHJlc2V0KCklM0ElMEElMDlzdXBlci5yZXNldCgpJTBBJTA5c3RlcHNfd2l0aG91dF9sZXZlcl9wdWxsZWQlMjAlM0QlMjAw",highlighted:`func _physics_process(delta: <span class="hljs-built_in">float</span>) -&gt; void:
	<span class="hljs-comment"># Reset on timeout, this is implemented in parent class to set needs_reset to true,</span>
	<span class="hljs-comment"># we are re-implementing here to call player.game_over() that handles the game reset.</span>
	n_steps += <span class="hljs-number">1</span>
	<span class="hljs-keyword">if</span> n_steps &gt; reset_after:
		player.game_over()

	<span class="hljs-comment"># In training or onnx inference modes, this method will be called by sync node with actions provided,</span>
	<span class="hljs-comment"># For expert demo recording mode, it will be called without any actions (as we set the actions based on human input),</span>
	<span class="hljs-comment"># For human control mode the method will not be called, so we call it here without any actions provided.</span>
	<span class="hljs-keyword">if</span> control_mode == ControlModes.HUMAN:
		set_action()

	<span class="hljs-comment"># Reset the game faster if the lever is not pulled.</span>
	steps_without_lever_pulled += <span class="hljs-number">1</span>
	<span class="hljs-keyword">if</span> steps_without_lever_pulled &gt; <span class="hljs-number">200</span> <span class="hljs-keyword">and</span> (<span class="hljs-keyword">not</span> player._is_lever_pulled):
		player.game_over()

func reset():
	<span class="hljs-built_in">super</span>.reset()
	steps_without_lever_pulled = <span class="hljs-number">0</span>`,wrap:!1}}),A=new J({props:{title:"Replace the get_action_space() , get_action() , and set_action() methods with the implementation below:",local:"replace-the-getactionspace--getaction--and-setaction-methods-with-the-implementation-below",headingTag:"h3"}}),z=new wt({props:{code:"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",highlighted:`<span class="hljs-comment"># Defines the actions for the AI agent (&quot;size&quot;: 2 means 2 floats for this action)</span>
func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;movement&quot;</span>: {<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>},
		<span class="hljs-string">&quot;rotation&quot;</span>: {<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>},
		<span class="hljs-string">&quot;jump&quot;</span>: {<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>},
		<span class="hljs-string">&quot;use_action&quot;</span>: {<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>}
	}

<span class="hljs-comment"># We return the action values in the same order as defined in get_action_space() (important), but all in one array</span>
<span class="hljs-comment"># For actions of size 1, we return 1 float in the array, for size 2, 2 floats in the array, etc.</span>
<span class="hljs-comment"># set_action is called just before get_action by the sync node, so we can read the newly set values</span>
func get_action():
	<span class="hljs-keyword">return</span> [
		<span class="hljs-comment"># &quot;movement&quot; action values</span>
		player.requested_movement.x,
		player.requested_movement.y,
		<span class="hljs-comment"># &quot;rotation&quot; action value</span>
		player.requested_rotation.x,
		<span class="hljs-comment"># &quot;jump&quot; action value (-1 if not requested, 1 if requested)</span>
		-<span class="hljs-number">1.0</span> + <span class="hljs-number">2.0</span> * <span class="hljs-built_in">float</span>(player.jump_requested),
		<span class="hljs-comment"># &quot;use_action&quot; action value (-1 if not requested, 1 if requested)</span>
		-<span class="hljs-number">1.0</span> + <span class="hljs-number">2.0</span> * <span class="hljs-built_in">float</span>(player.use_action_requested)
	]

<span class="hljs-comment"># Here we set human control and AI control actions to the robot</span>
func set_action(action = null) -&gt; void:
	<span class="hljs-comment"># If there&#x27;s no action provided, it means that AI is not controlling the robot (human control),</span>
	<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> action:
		<span class="hljs-comment"># Only rotate if the mouse has moved since the last set_action call</span>
		<span class="hljs-keyword">if</span> previous_mouse_movement == mouse_movement:
			mouse_movement = Vector2.ZERO

		player.requested_movement = Input.get_vector(
			<span class="hljs-string">&quot;move_left&quot;</span>, <span class="hljs-string">&quot;move_right&quot;</span>, <span class="hljs-string">&quot;move_forward&quot;</span>, <span class="hljs-string">&quot;move_back&quot;</span>
		)
		player.requested_rotation = mouse_movement

		var use_action = Input.is_action_pressed(<span class="hljs-string">&quot;requested_action&quot;</span>)
		var jump = Input.is_action_pressed(<span class="hljs-string">&quot;requested_jump&quot;</span>)

		player.use_action_requested = use_action
		player.jump_requested = jump

		previous_mouse_movement = mouse_movement	
	<span class="hljs-keyword">else</span>:
		<span class="hljs-comment"># If there is action provided, we set the actions received from the AI agent </span>
		player.requested_movement = Vector2(action.movement[<span class="hljs-number">0</span>], action.movement[<span class="hljs-number">1</span>])
		<span class="hljs-comment"># The agent only rotates the robot along the Y axis, no need to rotate the camera along X axis</span>
		player.requested_rotation = Vector2(action.rotation[<span class="hljs-number">0</span>], <span class="hljs-number">0.0</span>)
		player.jump_requested = <span class="hljs-built_in">bool</span>(action.jump[<span class="hljs-number">0</span>] &gt; <span class="hljs-number">0</span>)
		player.use_action_requested = <span class="hljs-built_in">bool</span>(action.use_action[<span class="hljs-number">0</span>] &gt; <span class="hljs-number">0</span>)`,wrap:!1}}),q=new J({props:{title:"Replace the _input method with the implementation below:",local:"replace-the-input-method-with-the-implementation-below",headingTag:"h3"}}),L=new wt({props:{code:"JTIzJTIwUmVjb3JkJTIwbW91c2UlMjBtb3ZlbWVudCUyMGZvciUyMGh1bWFuJTIwYW5kJTIwZGVtb19yZWNvcmQlMjBtb2RlcyUwQSUyMyUyMFdlJTIwZG9uJ3QlMjBkaXJlY3RseSUyMHJvdGF0ZSUyMGluJTIwaW5wdXQlMjB0byUyMGFsbG93JTIwZm9yJTIwZnJhbWUlMjBza2lwcGluZyUyMChhY3Rpb25fcmVwZWF0JTIwc2V0dGluZyklMjB3aGljaCUwQSUyMyUyMHdpbGwlMjBhbHNvJTIwYmUlMjBhcHBsaWVkJTIwdG8lMjB0aGUlMjBBSSUyMGFnZW50JTIwaW4lMjB0cmFpbmluZyUyRmluZmVyZW5jZSUyMG1vZGVzLiUwQWZ1bmMlMjBfaW5wdXQoZXZlbnQpJTNBJTBBJTA5aWYlMjBub3QlMjAoaGV1cmlzdGljJTIwJTNEJTNEJTIwJTIyaHVtYW4lMjIlMjBvciUyMGhldXJpc3RpYyUyMCUzRCUzRCUyMCUyMmRlbW9fcmVjb3JkJTIyKSUzQSUwQSUwOSUwOXJldHVybiUwQSUwQSUwOWlmJTIwZXZlbnQlMjBpcyUyMElucHV0RXZlbnRNb3VzZU1vdGlvbiUzQSUwQSUwOSUwOXZhciUyMG1vdmVtZW50X3NjYWxlJTNBJTIwZmxvYXQlMjAlM0QlMjAwLjAwNSUwQSUwOSUwOW1vdXNlX21vdmVtZW50LnklMjAlM0QlMjBjbGFtcGYoZXZlbnQucmVsYXRpdmUueSUyMColMjBtb3ZlbWVudF9zY2FsZSUyQyUyMC0xLjAlMkMlMjAxLjApJTBBJTA5JTA5bW91c2VfbW92ZW1lbnQueCUyMCUzRCUyMGNsYW1wZihldmVudC5yZWxhdGl2ZS54JTIwKiUyMG1vdmVtZW50X3NjYWxlJTJDJTIwLTEuMCUyQyUyMDEuMCk=",highlighted:`<span class="hljs-comment"># Record mouse movement for human and demo_record modes</span>
<span class="hljs-comment"># We don&#x27;t directly rotate in input to allow for frame skipping (action_repeat setting) which</span>
<span class="hljs-comment"># will also be applied to the AI agent in training/inference modes.</span>
func _<span class="hljs-built_in">input</span>(event):
	<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> (heuristic == <span class="hljs-string">&quot;human&quot;</span> <span class="hljs-keyword">or</span> heuristic == <span class="hljs-string">&quot;demo_record&quot;</span>):
		<span class="hljs-keyword">return</span>

	<span class="hljs-keyword">if</span> event <span class="hljs-keyword">is</span> InputEventMouseMotion:
		var movement_scale: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.005</span>
		mouse_movement.y = clampf(event.relative.y * movement_scale, -<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>)
		mouse_movement.x = clampf(event.relative.x * movement_scale, -<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>)`,wrap:!1}}),ee=new J({props:{title:"Open the demo record scene, and click on AIController3D node",local:"open-the-demo-record-scene-and-click-on-aicontroller3d-node",headingTag:"h3"}}),v=new ut({props:{$$slots:{default:[dl]},$$scope:{ctx:b}}}),ae=new J({props:{title:"Let’s record some demos:",local:"lets-record-some-demos",headingTag:"h3"}}),I=new ut({props:{$$slots:{default:[ml]},$$scope:{ctx:b}}}),he=new J({props:{title:"Export the game for training:",local:"export-the-game-for-training",headingTag:"h3"}}),ue=new cl({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unitbonus5/getting-started.mdx"}}),{c(){c=a("meta"),r=n(),w=a("p"),Ue=n(),d(Z.$$.fragment),Je=n(),g=a("p"),g.innerHTML=ft,be=n(),_=a("p"),_.textContent=jt,Te=n(),G=a("ul"),G.innerHTML=vt,fe=n(),d(W.$$.fragment),je=n(),S=a("p"),S.innerHTML=It,ve=n(),d(k.$$.fragment),Ie=n(),d(f.$$.fragment),Ze=n(),B=a("p"),B.innerHTML=Zt,ge=n(),X=a("img"),_e=n(),d(V.$$.fragment),Ge=n(),d(j.$$.fragment),We=n(),d(C.$$.fragment),Se=n(),d($.$$.fragment),ke=n(),Y=a("p"),Y.innerHTML=_t,Be=n(),Q=a("p"),Q.textContent=Gt,Xe=n(),x=a("ul"),x.innerHTML=Wt,Ve=n(),R=a("p"),R.innerHTML=St,Ce=n(),F=a("p"),F.innerHTML=kt,$e=n(),d(N.$$.fragment),Ye=n(),d(E.$$.fragment),Qe=n(),d(A.$$.fragment),xe=n(),d(z.$$.fragment),Re=n(),D=a("p"),D.innerHTML=Bt,Fe=n(),H=a("p"),H.innerHTML=Xt,Ne=n(),O=a("p"),O.textContent=Vt,Ee=n(),d(q.$$.fragment),Ae=n(),d(L.$$.fragment),ze=n(),K=a("p"),K.textContent=Ct,De=n(),P=a("p"),P.innerHTML=$t,He=n(),d(ee.$$.fragment),Oe=n(),d(v.$$.fragment),qe=n(),te=a("img"),Le=n(),le=a("p"),le.textContent=Qt,Ke=n(),se=a("p"),se.innerHTML=xt,Pe=n(),ne=a("ul"),ne.innerHTML=Rt,et=n(),oe=a("p"),oe.innerHTML=Ft,tt=n(),d(ae.$$.fragment),lt=n(),d(I.$$.fragment),st=n(),ie=a("p"),ie.innerHTML=Nt,nt=n(),ce=a("p"),ce.textContent=Et,ot=n(),re=a("ul"),re.innerHTML=At,at=n(),pe=a("p"),pe.innerHTML=zt,it=n(),de=a("p"),de.innerHTML=Dt,ct=n(),me=a("p"),me.innerHTML=Ht,rt=n(),Me=a("p"),Me.textContent=Ot,pt=n(),U=a("video"),dt=n(),d(he.$$.fragment),mt=n(),ye=a("p"),ye.innerHTML=Lt,Mt=n(),d(ue.$$.fragment),ht=n(),we=a("p"),this.h()},l(e){const t=al("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(l),r=o(e),w=i(e,"P",{}),Tt(w).forEach(l),Ue=o(e),m(Z.$$.fragment,e),Je=o(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1qb7a4d"&&(g.innerHTML=ft),be=o(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1amr1o0"&&(_.textContent=jt),Te=o(e),G=i(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-1y323ju"&&(G.innerHTML=vt),fe=o(e),m(W.$$.fragment,e),je=o(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-npkgc1"&&(S.innerHTML=It),ve=o(e),m(k.$$.fragment,e),Ie=o(e),m(f.$$.fragment,e),Ze=o(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1ube8yo"&&(B.innerHTML=Zt),ge=o(e),X=i(e,"IMG",{src:!0,alt:!0}),_e=o(e),m(V.$$.fragment,e),Ge=o(e),m(j.$$.fragment,e),We=o(e),m(C.$$.fragment,e),Se=o(e),m($.$$.fragment,e),ke=o(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-jh3wu3"&&(Y.innerHTML=_t),Be=o(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1fea4rp"&&(Q.textContent=Gt),Xe=o(e),x=i(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-1h1wquf"&&(x.innerHTML=Wt),Ve=o(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-13tyx2h"&&(R.innerHTML=St),Ce=o(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-n47bel"&&(F.innerHTML=kt),$e=o(e),m(N.$$.fragment,e),Ye=o(e),m(E.$$.fragment,e),Qe=o(e),m(A.$$.fragment,e),xe=o(e),m(z.$$.fragment,e),Re=o(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-zwgvhy"&&(D.innerHTML=Bt),Fe=o(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1u26gdc"&&(H.innerHTML=Xt),Ne=o(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1pngomy"&&(O.textContent=Vt),Ee=o(e),m(q.$$.fragment,e),Ae=o(e),m(L.$$.fragment,e),ze=o(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-16wo2en"&&(K.textContent=Ct),De=o(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1xk6pzp"&&(P.innerHTML=$t),He=o(e),m(ee.$$.fragment,e),Oe=o(e),m(v.$$.fragment,e),qe=o(e),te=i(e,"IMG",{src:!0,alt:!0}),Le=o(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-140ih9d"&&(le.textContent=Qt),Ke=o(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1kxoy08"&&(se.innerHTML=xt),Pe=o(e),ne=i(e,"UL",{"data-svelte-h":!0}),p(ne)!=="svelte-1me19ds"&&(ne.innerHTML=Rt),et=o(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1vrpmg4"&&(oe.innerHTML=Ft),tt=o(e),m(ae.$$.fragment,e),lt=o(e),m(I.$$.fragment,e),st=o(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1u58l5w"&&(ie.innerHTML=Nt),nt=o(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-955cdc"&&(ce.textContent=Et),ot=o(e),re=i(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-lgd0ry"&&(re.innerHTML=At),at=o(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-7gdr6v"&&(pe.innerHTML=zt),it=o(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1kchvdy"&&(de.innerHTML=Dt),ct=o(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-h82rtc"&&(me.innerHTML=Ht),rt=o(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-6wv9et"&&(Me.textContent=Ot),pt=o(e),U=i(e,"VIDEO",{src:!0,type:!0,mute:!0}),Tt(U).forEach(l),dt=o(e),m(he.$$.fragment,e),mt=o(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-57pgql"&&(ye.innerHTML=Lt),Mt=o(e),m(ue.$$.fragment,e),ht=o(e),we=i(e,"P",{}),Tt(we).forEach(l),this.h()},h(){T(c,"name","hf:doc:metadata"),T(c,"content",hl),bt(X.src,gt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit13/open-robot-scene.jpg")||T(X,"src",gt),T(X,"alt","open robot scene"),bt(te.src,Yt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit13/demo_record_scene.jpg")||T(te,"src",Yt),T(te,"alt","open robot scene"),bt(U.src,qt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit13/demo_record.mp4")||T(U,"src",qt),T(U,"type","video/mp4"),U.controls=!0,U.autoplay=!0,U.loop=!0,T(U,"mute","")},m(e,t){il(document.head,c),s(e,r,t),s(e,w,t),s(e,Ue,t),M(Z,e,t),s(e,Je,t),s(e,g,t),s(e,be,t),s(e,_,t),s(e,Te,t),s(e,G,t),s(e,fe,t),M(W,e,t),s(e,je,t),s(e,S,t),s(e,ve,t),M(k,e,t),s(e,Ie,t),M(f,e,t),s(e,Ze,t),s(e,B,t),s(e,ge,t),s(e,X,t),s(e,_e,t),M(V,e,t),s(e,Ge,t),M(j,e,t),s(e,We,t),M(C,e,t),s(e,Se,t),M($,e,t),s(e,ke,t),s(e,Y,t),s(e,Be,t),s(e,Q,t),s(e,Xe,t),s(e,x,t),s(e,Ve,t),s(e,R,t),s(e,Ce,t),s(e,F,t),s(e,$e,t),M(N,e,t),s(e,Ye,t),M(E,e,t),s(e,Qe,t),M(A,e,t),s(e,xe,t),M(z,e,t),s(e,Re,t),s(e,D,t),s(e,Fe,t),s(e,H,t),s(e,Ne,t),s(e,O,t),s(e,Ee,t),M(q,e,t),s(e,Ae,t),M(L,e,t),s(e,ze,t),s(e,K,t),s(e,De,t),s(e,P,t),s(e,He,t),M(ee,e,t),s(e,Oe,t),M(v,e,t),s(e,qe,t),s(e,te,t),s(e,Le,t),s(e,le,t),s(e,Ke,t),s(e,se,t),s(e,Pe,t),s(e,ne,t),s(e,et,t),s(e,oe,t),s(e,tt,t),M(ae,e,t),s(e,lt,t),M(I,e,t),s(e,st,t),s(e,ie,t),s(e,nt,t),s(e,ce,t),s(e,ot,t),s(e,re,t),s(e,at,t),s(e,pe,t),s(e,it,t),s(e,de,t),s(e,ct,t),s(e,me,t),s(e,rt,t),s(e,Me,t),s(e,pt,t),s(e,U,t),s(e,dt,t),M(he,e,t),s(e,mt,t),s(e,ye,t),s(e,Mt,t),M(ue,e,t),s(e,ht,t),s(e,we,t),yt=!0},p(e,[t]){const Kt={};t&2&&(Kt.$$scope={dirty:t,ctx:e}),f.$set(Kt);const Pt={};t&2&&(Pt.$$scope={dirty:t,ctx:e}),j.$set(Pt);const el={};t&2&&(el.$$scope={dirty:t,ctx:e}),v.$set(el);const tl={};t&2&&(tl.$$scope={dirty:t,ctx:e}),I.$set(tl)},i(e){yt||(h(Z.$$.fragment,e),h(W.$$.fragment,e),h(k.$$.fragment,e),h(f.$$.fragment,e),h(V.$$.fragment,e),h(j.$$.fragment,e),h(C.$$.fragment,e),h($.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(L.$$.fragment,e),h(ee.$$.fragment,e),h(v.$$.fragment,e),h(ae.$$.fragment,e),h(I.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),yt=!0)},o(e){y(Z.$$.fragment,e),y(W.$$.fragment,e),y(k.$$.fragment,e),y(f.$$.fragment,e),y(V.$$.fragment,e),y(j.$$.fragment,e),y(C.$$.fragment,e),y($.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(A.$$.fragment,e),y(z.$$.fragment,e),y(q.$$.fragment,e),y(L.$$.fragment,e),y(ee.$$.fragment,e),y(v.$$.fragment,e),y(ae.$$.fragment,e),y(I.$$.fragment,e),y(he.$$.fragment,e),y(ue.$$.fragment,e),yt=!1},d(e){e&&(l(r),l(w),l(Ue),l(Je),l(g),l(be),l(_),l(Te),l(G),l(fe),l(je),l(S),l(ve),l(Ie),l(Ze),l(B),l(ge),l(X),l(_e),l(Ge),l(We),l(Se),l(ke),l(Y),l(Be),l(Q),l(Xe),l(x),l(Ve),l(R),l(Ce),l(F),l($e),l(Ye),l(Qe),l(xe),l(Re),l(D),l(Fe),l(H),l(Ne),l(O),l(Ee),l(Ae),l(ze),l(K),l(De),l(P),l(He),l(Oe),l(qe),l(te),l(Le),l(le),l(Ke),l(se),l(Pe),l(ne),l(et),l(oe),l(tt),l(lt),l(st),l(ie),l(nt),l(ce),l(ot),l(re),l(at),l(pe),l(it),l(de),l(ct),l(me),l(rt),l(Me),l(pt),l(U),l(dt),l(mt),l(ye),l(Mt),l(ht),l(we)),l(c),u(Z,e),u(W,e),u(k,e),u(f,e),u(V,e),u(j,e),u(C,e),u($,e),u(N,e),u(E,e),u(A,e),u(z,e),u(q,e),u(L,e),u(ee,e),u(v,e),u(ae,e),u(I,e),u(he,e),u(ue,e)}}}const hl='{"title":"Getting started:","local":"getting-started","sections":[{"title":"Open the starter project in Godot","local":"open-the-starter-project-in-godot","sections":[],"depth":3},{"title":"Open the robot scene","local":"open-the-robot-scene","sections":[],"depth":3},{"title":"Click on the scroll next to AIController3D to open the script for editing","local":"click-on-the-scroll-next-to-aicontroller3d-to-open-the-script-for-editing","sections":[],"depth":3},{"title":"Replace the get_obs() and get_reward() methods with the implementation below:","local":"replace-the-getobs-and-getreward-methods-with-the-implementation-below","sections":[],"depth":3},{"title":"Replace the _physics_process() and reset() methods with the implementation below:","local":"replace-the-physicsprocess-and-reset-methods-with-the-implementation-below","sections":[],"depth":3},{"title":"Replace the get_action_space() , get_action() , and set_action() methods with the implementation below:","local":"replace-the-getactionspace--getaction--and-setaction-methods-with-the-implementation-below","sections":[],"depth":3},{"title":"Replace the _input method with the implementation below:","local":"replace-the-input-method-with-the-implementation-below","sections":[],"depth":3},{"title":"Open the demo record scene, and click on AIController3D node","local":"open-the-demo-record-scene-and-click-on-aicontroller3d-node","sections":[],"depth":3},{"title":"Let’s record some demos:","local":"lets-record-some-demos","sections":[],"depth":3},{"title":"Export the game for training:","local":"export-the-game-for-training","sections":[],"depth":3}],"depth":1}';function yl(b){return sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends nl{constructor(c){super(),ol(this,c,yl,Ml,ll,{})}}export{Tl as component};
