import{s as Ie,o as Be,n as ae}from"../chunks/scheduler.6062bdaf.js";import{S as Xe,i as We,g as i,s as l,r as c,A as Re,h as p,f as n,c as a,j as Ze,u,x as r,k as Ne,y as Ge,a as s,v as M,d as h,t as d,w as f}from"../chunks/index.4bca734e.js";import{T as le}from"../chunks/Tip.b9ac1f03.js";import{C as w}from"../chunks/CodeBlock.fa01571c.js";import{H as ut,E as He}from"../chunks/EditOnGithub.74ab2baa.js";function Ve(T){let o,j=`A good way to implement a custom ONNX configuration is to look at the existing configuration implementations in the
<code>optimum/exporters/onnx/model_configs.py</code> file.`,m,g,x=`Also, if the architecture you are trying to add is (very) similar to an architecture that is already supported
(for instance adding support for ALBERT when BERT is already supported), trying to simply inheriting from this class
might work.`;return{c(){o=i("p"),o.innerHTML=j,m=l(),g=i("p"),g.textContent=x},l(y){o=p(y,"P",{"data-svelte-h":!0}),r(o)!=="svelte-sqy8xm"&&(o.innerHTML=j),m=a(y),g=p(y,"P",{"data-svelte-h":!0}),r(g)!=="svelte-179x1bi"&&(g.textContent=x)},m(y,b){s(y,o,b),s(y,m,b),s(y,g,b)},p:ae,d(y){y&&(n(o),n(m),n(g))}}}function Le(T){let o,j="Check out <code>BartOnnxConfig</code> for an advanced example.";return{c(){o=i("p"),o.innerHTML=j},l(m){o=p(m,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1lu1znn"&&(o.innerHTML=j)},m(m,g){s(m,o,g)},p:ae,d(m){m&&n(o)}}}function Oe(T){let o,j=`If your model is larger than 2GB, you will see that many additional files are created during the export. This is
<em>expected</em> because ONNX uses <a href="https://developers.google.com/protocol-buffers/" rel="nofollow">Protocol Buffers</a> to store the model
and these have a size limit of 2GB. See the <a href="https://github.com/onnx/onnx/blob/master/docs/ExternalData.md" rel="nofollow">ONNX documentation</a>
for instructions on how to load models with external data.`;return{c(){o=i("p"),o.innerHTML=j},l(m){o=p(m,"P",{"data-svelte-h":!0}),r(o)!=="svelte-iixhlv"&&(o.innerHTML=j)},m(m,g){s(m,o,g)},p:ae,d(m){m&&n(o)}}}function Fe(T){let o,j,m,g,x,y,b,oe="If you wish to export a model whose architecture is not already supported by the library, these are the main steps to follow:",ht,C,ie='<li>Implement a custom ONNX configuration.</li> <li>Register the ONNX configuration in the <a href="/docs/optimum/pr_1878/en/exporters/task_manager#optimum.exporters.TasksManager">TasksManager</a>.</li> <li>Export the model to ONNX.</li> <li>Validate the outputs of the original and exported models.</li>',dt,$,pe="In this section, we’ll look at how BERT was implemented to show what’s involved with each step.",ft,v,gt,A,re=`Let’s start with the ONNX configuration object. We provide a 3-level <a href="/exporters/onnx/package_reference/configuration">class hierarchy</a>,
and to add support for a model, inheriting from the right middle-end class will be the way to go most of the time. You might have to
implement a middle-end class yourself if you are adding an architecture handling a modality and/or case never seen before.`,yt,U,jt,k,me=`When inheriting from a middle-end class, look for the one handling the same modality / category of models as the one you
are trying to support.`,bt,E,xt,Z,ce=`Since BERT is an encoder-based model for text, its configuration inherits from the middle-end class <a href="/docs/optimum/pr_1878/en/exporters/onnx/package_reference/configuration#optimum.exporters.onnx.TextEncoderOnnxConfig">TextEncoderOnnxConfig</a>.
In <code>optimum/exporters/onnx/model_configs.py</code>:`,wt,N,Tt,I,ue=`First let’s explain what <code>TextEncoderOnnxConfig</code> is all about. While most of the features are already implemented in <code>OnnxConfig</code>,
this class is modality-agnostic, meaning that it does not know what kind of inputs it should handle. The way input generation is
handled is via the <code>DUMMY_INPUT_GENERATOR_CLASSES</code> attribute, which is a tuple of <a href="/docs/optimum/pr_1878/en/utils/dummy_input_generators#optimum.utils.DummyInputGenerator">DummyInputGenerator</a>s.
Here we are making a modality-aware configuration inheriting from <code>OnnxConfig</code> by specifying
<code>DUMMY_INPUT_GENERATOR_CLASSES = (DummyTextInputGenerator,)</code>.`,Ut,B,Me="Then comes the model-specific class, <code>BertOnnxConfig</code>. Two class attributes are specified here:",_t,X,he=`<li><code>NORMALIZED_CONFIG_CLASS</code>: this must be a <a href="/docs/optimum/pr_1878/en/utils/normalized_config#optimum.utils.NormalizedConfig">NormalizedConfig</a>, it basically allows
the input generator to access the model config attributes in a generic way.</li> <li><code>ATOL_FOR_VALIDATION</code>: it is used when validating the exported model against the original one, this is the absolute
acceptable tolerance for the output values difference.</li>`,Jt,W,de=`Every configuration object must implement the <a href="/docs/optimum/pr_1878/en/exporters/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a> property and return a mapping, where each key corresponds to an
input name, and each value indicates the axes in that input that are dynamic.
For BERT, we can see that three inputs are required: <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code>.
These inputs have the same shape of <code>(batch_size, sequence_length)</code> (except for the <code>multiple-choice</code> task) which is
why we see the same axes used in the configuration.`,Ct,R,fe="Once you have implemented an ONNX configuration, you can instantiate it by providing the base model’s configuration as follows:",$t,G,vt,H,ge=`The resulting object has several useful properties. For example, you can view the ONNX
operator set that will be used during the export:`,At,V,kt,L,ye="You can also view the outputs associated with the model as follows:",Et,O,Zt,F,je=`Notice that the outputs property follows the same structure as the inputs; it returns an
<code>OrderedDict</code> of named outputs and their shapes. The output structure is linked to the
choice of task that the configuration is initialised with. By default, the ONNX
configuration is initialized with the <code>default</code> task that corresponds to exporting a
model loaded with the <code>AutoModel</code> class. If you want to export a model for another task,
just provide a different task to the <code>task</code> argument when you initialize the ONNX
configuration. For example, if we wished to export BERT with a sequence
classification head, we could use:`,Nt,Q,It,_,Bt,z,Xt,S,be=`The <a href="/docs/optimum/pr_1878/en/exporters/task_manager#optimum.exporters.TasksManager">TasksManager</a> is the main entry-point to load a model given a name and a task,
and to get the proper configuration for a given (architecture, backend) couple. When adding support for the export to ONNX,
registering the configuration to the <code>TasksManager</code> will make the export available in the command line tool.`,Wt,q,xe="To do that, add an entry in the <code>_SUPPORTED_MODEL_TYPE</code> attribute:",Rt,Y,we=`<li>If the model is already supported for other backends than ONNX, it will already have an entry, so you will only need to
add an <code>onnx</code> key specifying the name of the configuration class.</li> <li>Otherwise, you will have to add the whole entry.</li>`,Gt,P,Te="For BERT, it looks as follows:",Ht,D,Vt,K,Lt,tt,Ue=`Once you have implemented the ONNX configuration, the next step is to export the model.
Here we can use the <code>export()</code> function provided by the <code>optimum.exporters.onnx</code> package.
This function expects the ONNX configuration, along with the base model, and the path to save the exported file:`,Ot,et,Ft,nt,_e=`The <code>onnx_inputs</code> and <code>onnx_outputs</code> returned by the <code>export()</code> function are lists of the keys defined in the <a href="/docs/optimum/pr_1878/en/exporters/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a>
and <a href="/docs/optimum/pr_1878/en/exporters/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a> properties of the configuration. Once the model is exported, you can test that the model is well formed as follows:`,Qt,st,zt,J,St,lt,qt,at,Je=`The final step is to validate that the outputs from the base and exported model agree within some absolute tolerance.
Here we can use the <code>validate_model_outputs()</code> function provided by the <code>optimum.exporters.onnx</code> package:`,Yt,ot,Pt,it,Dt,pt,Ce="Now that the support for the architectures has been implemented, and validated, there are two things left:",Kt,rt,$e='<li>Add your model architecture to the tests in <code>tests/exporters/test_onnx_export.py</code></li> <li>Create a PR on the <a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code> repo</a></li>',te,mt,ve="Thanks for you contribution!",ee,ct,ne,Mt,se;return x=new ut({props:{title:"Adding support for an unsupported architecture",local:"adding-support-for-an-unsupported-architecture",headingTag:"h1"}}),v=new ut({props:{title:"Implementing a custom ONNX configuration",local:"implementing-a-custom-onnx-configuration",headingTag:"h2"}}),U=new le({props:{$$slots:{default:[Ve]},$$scope:{ctx:T}}}),E=new ut({props:{title:"Example: Adding support for BERT",local:"example-adding-support-for-bert",headingTag:"h3"}}),N=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># This class is actually in optimum/exporters/onnx/config.py</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TextEncoderOnnxConfig</span>(<span class="hljs-title class_ inherited__">OnnxConfig</span>):
    <span class="hljs-comment"># Describes how to generate the dummy inputs.</span>
    DUMMY_INPUT_GENERATOR_CLASSES = (DummyTextInputGenerator,)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">BertOnnxConfig</span>(<span class="hljs-title class_ inherited__">TextEncoderOnnxConfig</span>):
    <span class="hljs-comment"># Specifies how to normalize the BertConfig, this is needed to access common attributes</span>
    <span class="hljs-comment"># during dummy input generation.</span>
    NORMALIZED_CONFIG_CLASS = NormalizedTextConfig
    <span class="hljs-comment"># Sets the absolute tolerance to when validating the exported ONNX model against the</span>
    <span class="hljs-comment"># reference model.</span>
    ATOL_FOR_VALIDATION = <span class="hljs-number">1e-4</span>

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Dict</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">str</span>]]:
        <span class="hljs-keyword">if</span> self.task == <span class="hljs-string">&quot;multiple-choice&quot;</span>:
            dynamic_axis = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;batch_size&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;num_choices&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;sequence_length&quot;</span>}
        <span class="hljs-keyword">else</span>:
            dynamic_axis = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;batch_size&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;sequence_length&quot;</span>}
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;input_ids&quot;</span>: dynamic_axis,
            <span class="hljs-string">&quot;attention_mask&quot;</span>: dynamic_axis,
            <span class="hljs-string">&quot;token_type_ids&quot;</span>: dynamic_axis,
        }`,wrap:!1}}),G=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEFmcm9tJTIwb3B0aW11bS5leHBvcnRlcnMub25ueC5tb2RlbF9jb25maWdzJTIwaW1wb3J0JTIwQmVydE9ubnhDb25maWclMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFvbm54X2NvbmZpZyUyMCUzRCUyMEJlcnRPbm54Q29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx.model_configs <span class="hljs-keyword">import</span> BertOnnxConfig
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config = BertOnnxConfig(config)`,wrap:!1}}),V=new w({props:{code:"cHJpbnQob25ueF9jb25maWcuREVGQVVMVF9PTk5YX09QU0VUKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config.DEFAULT_ONNX_OPSET)
<span class="hljs-number">11</span>`,wrap:!1}}),O=new w({props:{code:"cHJpbnQob25ueF9jb25maWcub3V0cHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config.outputs)
OrderedDict([(<span class="hljs-string">&#x27;last_hidden_state&#x27;</span>, {<span class="hljs-number">0</span>: <span class="hljs-string">&#x27;batch_size&#x27;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&#x27;sequence_length&#x27;</span>})])`,wrap:!1}}),Q=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFvbm54X2NvbmZpZ19mb3Jfc2VxX2NsZiUyMCUzRCUyMEJlcnRPbm54Q29uZmlnKGNvbmZpZyUyQyUyMHRhc2slM0QlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQXByaW50KG9ubnhfY29uZmlnX2Zvcl9zZXFfY2xmLm91dHB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config_for_seq_clf = BertOnnxConfig(config, task=<span class="hljs-string">&quot;text-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config_for_seq_clf.outputs)
OrderedDict([(<span class="hljs-string">&#x27;logits&#x27;</span>, {<span class="hljs-number">0</span>: <span class="hljs-string">&#x27;batch_size&#x27;</span>})])`,wrap:!1}}),_=new le({props:{$$slots:{default:[Le]},$$scope:{ctx:T}}}),z=new ut({props:{title:"Registering the ONNX configuration in the TasksManager",local:"registering-the-onnx-configuration-in-the-tasksmanager",headingTag:"h2"}}),D=new w({props:{code:"JTIwJTIwJTIwJTIwJTIyYmVydCUyMiUzQSUyMHN1cHBvcnRlZF90YXNrc19tYXBwaW5nKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlZmF1bHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmaWxsLW1hc2slMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybXVsdGlwbGUtY2hvaWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvbm54JTNEJTIyQmVydE9ubnhDb25maWclMjIlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`    <span class="hljs-string">&quot;bert&quot;</span>: supported_tasks_mapping(
        <span class="hljs-string">&quot;default&quot;</span>,
        <span class="hljs-string">&quot;fill-mask&quot;</span>,
        <span class="hljs-string">&quot;text-generation&quot;</span>,
        <span class="hljs-string">&quot;text-classification&quot;</span>,
        <span class="hljs-string">&quot;multiple-choice&quot;</span>,
        <span class="hljs-string">&quot;token-classification&quot;</span>,
        <span class="hljs-string">&quot;question-answering&quot;</span>,
        onnx=<span class="hljs-string">&quot;BertOnnxConfig&quot;</span>,
    )`,wrap:!1}}),K=new ut({props:{title:"Exporting the model",local:"exporting-the-model",headingTag:"h2"}}),et=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzJTIwaW1wb3J0JTIwVGFza3NNYW5hZ2VyJTBBZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLm9ubnglMjBpbXBvcnQlMjBleHBvcnQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBb25ueF9wYXRoJTIwJTNEJTIwUGF0aCglMjJtb2RlbC5vbm54JTIyKSUwQW9ubnhfY29uZmlnX2NvbnN0cnVjdG9yJTIwJTNEJTIwVGFza3NNYW5hZ2VyLmdldF9leHBvcnRlcl9jb25maWdfY29uc3RydWN0b3IoJTIyb25ueCUyMiUyQyUyMGJhc2VfbW9kZWwpJTBBb25ueF9jb25maWclMjAlM0QlMjBvbm54X2NvbmZpZ19jb25zdHJ1Y3RvcihiYXNlX21vZGVsLmNvbmZpZyklMEElMEFvbm54X2lucHV0cyUyQyUyMG9ubnhfb3V0cHV0cyUyMCUzRCUyMGV4cG9ydChiYXNlX21vZGVsJTJDJTIwb25ueF9jb25maWclMkMlMjBvbm54X3BhdGglMkMlMjBvbm54X2NvbmZpZy5ERUZBVUxUX09OTlhfT1BTRVQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters <span class="hljs-keyword">import</span> TasksManager
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx <span class="hljs-keyword">import</span> export
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>base_model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_path = Path(<span class="hljs-string">&quot;model.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config_constructor = TasksManager.get_exporter_config_constructor(<span class="hljs-string">&quot;onnx&quot;</span>, base_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config = onnx_config_constructor(base_model.config)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_inputs, onnx_outputs = export(base_model, onnx_config, onnx_path, onnx_config.DEFAULT_ONNX_OPSET)`,wrap:!1}}),st=new w({props:{code:"aW1wb3J0JTIwb25ueCUwQSUwQW9ubnhfbW9kZWwlMjAlM0QlMjBvbm54LmxvYWQoJTIybW9kZWwub25ueCUyMiklMEFvbm54LmNoZWNrZXIuY2hlY2tfbW9kZWwob25ueF9tb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnx

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = onnx.load(<span class="hljs-string">&quot;model.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx.checker.check_model(onnx_model)`,wrap:!1}}),J=new le({props:{$$slots:{default:[Oe]},$$scope:{ctx:T}}}),lt=new ut({props:{title:"Validating the model outputs",local:"validating-the-model-outputs",headingTag:"h2"}}),ot=new w({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLm9ubnglMjBpbXBvcnQlMjB2YWxpZGF0ZV9tb2RlbF9vdXRwdXRzJTBBJTBBdmFsaWRhdGVfbW9kZWxfb3V0cHV0cyglMEElMjAlMjAlMjAlMjBvbm54X2NvbmZpZyUyQyUyMGJhc2VfbW9kZWwlMkMlMjBvbm54X3BhdGglMkMlMjBvbm54X291dHB1dHMlMkMlMjBvbm54X2NvbmZpZy5BVE9MX0ZPUl9WQUxJREFUSU9OJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx <span class="hljs-keyword">import</span> validate_model_outputs

<span class="hljs-meta">&gt;&gt;&gt; </span>validate_model_outputs(
<span class="hljs-meta">... </span>    onnx_config, base_model, onnx_path, onnx_outputs, onnx_config.ATOL_FOR_VALIDATION
<span class="hljs-meta">... </span>)`,wrap:!1}}),it=new ut({props:{title:"Contributing the new configuration to 🤗 Optimum",local:"contributing-the-new-configuration-to--optimum",headingTag:"h2"}}),ct=new He({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/exporters/onnx/usage_guides/contribute.mdx"}}),{c(){o=i("meta"),j=l(),m=i("p"),g=l(),c(x.$$.fragment),y=l(),b=i("p"),b.textContent=oe,ht=l(),C=i("ol"),C.innerHTML=ie,dt=l(),$=i("p"),$.textContent=pe,ft=l(),c(v.$$.fragment),gt=l(),A=i("p"),A.innerHTML=re,yt=l(),c(U.$$.fragment),jt=l(),k=i("p"),k.textContent=me,bt=l(),c(E.$$.fragment),xt=l(),Z=i("p"),Z.innerHTML=ce,wt=l(),c(N.$$.fragment),Tt=l(),I=i("p"),I.innerHTML=ue,Ut=l(),B=i("p"),B.innerHTML=Me,_t=l(),X=i("ul"),X.innerHTML=he,Jt=l(),W=i("p"),W.innerHTML=de,Ct=l(),R=i("p"),R.textContent=fe,$t=l(),c(G.$$.fragment),vt=l(),H=i("p"),H.textContent=ge,At=l(),c(V.$$.fragment),kt=l(),L=i("p"),L.textContent=ye,Et=l(),c(O.$$.fragment),Zt=l(),F=i("p"),F.innerHTML=je,Nt=l(),c(Q.$$.fragment),It=l(),c(_.$$.fragment),Bt=l(),c(z.$$.fragment),Xt=l(),S=i("p"),S.innerHTML=be,Wt=l(),q=i("p"),q.innerHTML=xe,Rt=l(),Y=i("ul"),Y.innerHTML=we,Gt=l(),P=i("p"),P.textContent=Te,Ht=l(),c(D.$$.fragment),Vt=l(),c(K.$$.fragment),Lt=l(),tt=i("p"),tt.innerHTML=Ue,Ot=l(),c(et.$$.fragment),Ft=l(),nt=i("p"),nt.innerHTML=_e,Qt=l(),c(st.$$.fragment),zt=l(),c(J.$$.fragment),St=l(),c(lt.$$.fragment),qt=l(),at=i("p"),at.innerHTML=Je,Yt=l(),c(ot.$$.fragment),Pt=l(),c(it.$$.fragment),Dt=l(),pt=i("p"),pt.textContent=Ce,Kt=l(),rt=i("ol"),rt.innerHTML=$e,te=l(),mt=i("p"),mt.textContent=ve,ee=l(),c(ct.$$.fragment),ne=l(),Mt=i("p"),this.h()},l(t){const e=Re("svelte-u9bgzb",document.head);o=p(e,"META",{name:!0,content:!0}),e.forEach(n),j=a(t),m=p(t,"P",{}),Ze(m).forEach(n),g=a(t),u(x.$$.fragment,t),y=a(t),b=p(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-wyfgyh"&&(b.textContent=oe),ht=a(t),C=p(t,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-z8jhat"&&(C.innerHTML=ie),dt=a(t),$=p(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1faxzt5"&&($.textContent=pe),ft=a(t),u(v.$$.fragment,t),gt=a(t),A=p(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-h5ikbh"&&(A.innerHTML=re),yt=a(t),u(U.$$.fragment,t),jt=a(t),k=p(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1aazjya"&&(k.textContent=me),bt=a(t),u(E.$$.fragment,t),xt=a(t),Z=p(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-3ghhrr"&&(Z.innerHTML=ce),wt=a(t),u(N.$$.fragment,t),Tt=a(t),I=p(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vbw03c"&&(I.innerHTML=ue),Ut=a(t),B=p(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-jfkvll"&&(B.innerHTML=Me),_t=a(t),X=p(t,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-11u6p0s"&&(X.innerHTML=he),Jt=a(t),W=p(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1krh4hu"&&(W.innerHTML=de),Ct=a(t),R=p(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1hidcfs"&&(R.textContent=fe),$t=a(t),u(G.$$.fragment,t),vt=a(t),H=p(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-de93a2"&&(H.textContent=ge),At=a(t),u(V.$$.fragment,t),kt=a(t),L=p(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1wxissk"&&(L.textContent=ye),Et=a(t),u(O.$$.fragment,t),Zt=a(t),F=p(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-e8rha9"&&(F.innerHTML=je),Nt=a(t),u(Q.$$.fragment,t),It=a(t),u(_.$$.fragment,t),Bt=a(t),u(z.$$.fragment,t),Xt=a(t),S=p(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-7rlon2"&&(S.innerHTML=be),Wt=a(t),q=p(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1sb1s64"&&(q.innerHTML=xe),Rt=a(t),Y=p(t,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-glrx48"&&(Y.innerHTML=we),Gt=a(t),P=p(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-17sq7il"&&(P.textContent=Te),Ht=a(t),u(D.$$.fragment,t),Vt=a(t),u(K.$$.fragment,t),Lt=a(t),tt=p(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-dpvtiu"&&(tt.innerHTML=Ue),Ot=a(t),u(et.$$.fragment,t),Ft=a(t),nt=p(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1yklnut"&&(nt.innerHTML=_e),Qt=a(t),u(st.$$.fragment,t),zt=a(t),u(J.$$.fragment,t),St=a(t),u(lt.$$.fragment,t),qt=a(t),at=p(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-je0ksn"&&(at.innerHTML=Je),Yt=a(t),u(ot.$$.fragment,t),Pt=a(t),u(it.$$.fragment,t),Dt=a(t),pt=p(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-m5s9fa"&&(pt.textContent=Ce),Kt=a(t),rt=p(t,"OL",{"data-svelte-h":!0}),r(rt)!=="svelte-1eec8bu"&&(rt.innerHTML=$e),te=a(t),mt=p(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-zwsyvs"&&(mt.textContent=ve),ee=a(t),u(ct.$$.fragment,t),ne=a(t),Mt=p(t,"P",{}),Ze(Mt).forEach(n),this.h()},h(){Ne(o,"name","hf:doc:metadata"),Ne(o,"content",Qe)},m(t,e){Ge(document.head,o),s(t,j,e),s(t,m,e),s(t,g,e),M(x,t,e),s(t,y,e),s(t,b,e),s(t,ht,e),s(t,C,e),s(t,dt,e),s(t,$,e),s(t,ft,e),M(v,t,e),s(t,gt,e),s(t,A,e),s(t,yt,e),M(U,t,e),s(t,jt,e),s(t,k,e),s(t,bt,e),M(E,t,e),s(t,xt,e),s(t,Z,e),s(t,wt,e),M(N,t,e),s(t,Tt,e),s(t,I,e),s(t,Ut,e),s(t,B,e),s(t,_t,e),s(t,X,e),s(t,Jt,e),s(t,W,e),s(t,Ct,e),s(t,R,e),s(t,$t,e),M(G,t,e),s(t,vt,e),s(t,H,e),s(t,At,e),M(V,t,e),s(t,kt,e),s(t,L,e),s(t,Et,e),M(O,t,e),s(t,Zt,e),s(t,F,e),s(t,Nt,e),M(Q,t,e),s(t,It,e),M(_,t,e),s(t,Bt,e),M(z,t,e),s(t,Xt,e),s(t,S,e),s(t,Wt,e),s(t,q,e),s(t,Rt,e),s(t,Y,e),s(t,Gt,e),s(t,P,e),s(t,Ht,e),M(D,t,e),s(t,Vt,e),M(K,t,e),s(t,Lt,e),s(t,tt,e),s(t,Ot,e),M(et,t,e),s(t,Ft,e),s(t,nt,e),s(t,Qt,e),M(st,t,e),s(t,zt,e),M(J,t,e),s(t,St,e),M(lt,t,e),s(t,qt,e),s(t,at,e),s(t,Yt,e),M(ot,t,e),s(t,Pt,e),M(it,t,e),s(t,Dt,e),s(t,pt,e),s(t,Kt,e),s(t,rt,e),s(t,te,e),s(t,mt,e),s(t,ee,e),M(ct,t,e),s(t,ne,e),s(t,Mt,e),se=!0},p(t,[e]){const Ae={};e&2&&(Ae.$$scope={dirty:e,ctx:t}),U.$set(Ae);const ke={};e&2&&(ke.$$scope={dirty:e,ctx:t}),_.$set(ke);const Ee={};e&2&&(Ee.$$scope={dirty:e,ctx:t}),J.$set(Ee)},i(t){se||(h(x.$$.fragment,t),h(v.$$.fragment,t),h(U.$$.fragment,t),h(E.$$.fragment,t),h(N.$$.fragment,t),h(G.$$.fragment,t),h(V.$$.fragment,t),h(O.$$.fragment,t),h(Q.$$.fragment,t),h(_.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(K.$$.fragment,t),h(et.$$.fragment,t),h(st.$$.fragment,t),h(J.$$.fragment,t),h(lt.$$.fragment,t),h(ot.$$.fragment,t),h(it.$$.fragment,t),h(ct.$$.fragment,t),se=!0)},o(t){d(x.$$.fragment,t),d(v.$$.fragment,t),d(U.$$.fragment,t),d(E.$$.fragment,t),d(N.$$.fragment,t),d(G.$$.fragment,t),d(V.$$.fragment,t),d(O.$$.fragment,t),d(Q.$$.fragment,t),d(_.$$.fragment,t),d(z.$$.fragment,t),d(D.$$.fragment,t),d(K.$$.fragment,t),d(et.$$.fragment,t),d(st.$$.fragment,t),d(J.$$.fragment,t),d(lt.$$.fragment,t),d(ot.$$.fragment,t),d(it.$$.fragment,t),d(ct.$$.fragment,t),se=!1},d(t){t&&(n(j),n(m),n(g),n(y),n(b),n(ht),n(C),n(dt),n($),n(ft),n(gt),n(A),n(yt),n(jt),n(k),n(bt),n(xt),n(Z),n(wt),n(Tt),n(I),n(Ut),n(B),n(_t),n(X),n(Jt),n(W),n(Ct),n(R),n($t),n(vt),n(H),n(At),n(kt),n(L),n(Et),n(Zt),n(F),n(Nt),n(It),n(Bt),n(Xt),n(S),n(Wt),n(q),n(Rt),n(Y),n(Gt),n(P),n(Ht),n(Vt),n(Lt),n(tt),n(Ot),n(Ft),n(nt),n(Qt),n(zt),n(St),n(qt),n(at),n(Yt),n(Pt),n(Dt),n(pt),n(Kt),n(rt),n(te),n(mt),n(ee),n(ne),n(Mt)),n(o),f(x,t),f(v,t),f(U,t),f(E,t),f(N,t),f(G,t),f(V,t),f(O,t),f(Q,t),f(_,t),f(z,t),f(D,t),f(K,t),f(et,t),f(st,t),f(J,t),f(lt,t),f(ot,t),f(it,t),f(ct,t)}}}const Qe='{"title":"Adding support for an unsupported architecture","local":"adding-support-for-an-unsupported-architecture","sections":[{"title":"Implementing a custom ONNX configuration","local":"implementing-a-custom-onnx-configuration","sections":[{"title":"Example: Adding support for BERT","local":"example-adding-support-for-bert","sections":[],"depth":3}],"depth":2},{"title":"Registering the ONNX configuration in the TasksManager","local":"registering-the-onnx-configuration-in-the-tasksmanager","sections":[],"depth":2},{"title":"Exporting the model","local":"exporting-the-model","sections":[],"depth":2},{"title":"Validating the model outputs","local":"validating-the-model-outputs","sections":[],"depth":2},{"title":"Contributing the new configuration to 🤗 Optimum","local":"contributing-the-new-configuration-to--optimum","sections":[],"depth":2}],"depth":1}';function ze(T){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Xe{constructor(o){super(),We(this,o,ze,Fe,Ie,{})}}export{Ke as component};
