import{s as La,n as qa,o as Da}from"../chunks/scheduler.85c25b89.js";import{S as Ha,i as Pa,g as s,s as n,r as p,A as za,h as i,f as t,c as o,j as v,u as _,x as d,k as b,y as l,a as r,v as u,d as h,t as g,w as f}from"../chunks/index.c9bcf812.js";import{D as T}from"../chunks/Docstring.9ba0bc67.js";import{C as oa}from"../chunks/CodeBlock.94efc595.js";import{H as F}from"../chunks/Heading.3c6e5b17.js";import{E as Ba}from"../chunks/EditOnGithub.a0898460.js";function Wa(la){let $,Be,Pe,We,A,Qe,K,ra=`TRL supports the Kahneman-Tversky Optimization (KTO) Trainer for aligning language models with binary feedback data (e.g., upvote/downvote), as described in the <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">paper</a> by Kawin Ethayarajh, Winnie Xu, Niklas Muennighoff, Dan Jurafsky, and Douwe Kiela.
For a full example have a look at  <code>examples/scripts/kto.py</code>.`,Se,E,sa=`Depending on how good your base model is, you may or may not need to do SFT before KTO.
This is different from standard RLHF and DPO, which always require SFT.`,Ze,L,Re,q,ia="The KTO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",Xe,D,da="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",Ge,H,ma="for example:",Ve,P,Ye,z,ca=`where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired (<code>True</code>) or undesired (<code>False</code>).
A prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays. It is required that the dataset contains at least one desirable and one undesirable completion.`,et,B,tt,W,pa="The KTO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",at,Q,nt,S,_a="For a detailed example have a look at the <code>examples/scripts/kto.py</code> script. At a high level we need to initialize the <code>KTOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",ot,Z,ua="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",lt,R,ha=`The <code>desirable_weight</code> and <code>undesirable_weight</code> refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (<code>desirable_weight</code> <em>number of positives) to (<code>undesirable_weight</code></em> number of negatives) is in the range 1:1 to 4:3.`,rt,X,st,G,ga="After this one can then call:",it,V,dt,Y,mt,ee,fa="Given the binary signal data indicating whether a completion is desirable or undesirable for a prompt, we can optimize an implicit reward function that aligns with the key principles of Kahneman-Tversky’s prospect theory, such as reference dependence, loss aversion, and diminishing sensitivity.",ct,te,va=`The <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0.
The <code>KTOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;bco&quot;</code> argument.`,pt,ae,_t,ne,ba=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,ut,oe,Ta=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,ht,le,gt,m,re,Jt,Me,Ma="Initialize KTOTrainer.",kt,C,se,It,ye,ya="Compute the BCO loss for a batch of policy and reference model log probabilities.",Nt,U,ie,Ft,we,wa="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",At,y,de,Kt,xe,xa=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Et,$e,$a="Works both with or without labels.",Lt,O,me,qt,Ce,Ca="Compute the log probabilities of the given labels under the given logits.",Dt,j,ce,Ht,Ue,Ua="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",Pt,J,pe,zt,Oe,Oa="Generate samples from the model and reference model for the given batch of inputs.",Bt,w,_e,Wt,je,ja="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Qt,Je,Ja="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",St,x,ue,Zt,ke,ka="Returns the training <code>~torch.utils.data.DataLoader</code>.",Rt,Ie,Ia="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Xt,k,he,Gt,Ne,Na="Compute the KTO loss for a batch of policy and reference model log probabilities.",Vt,I,ge,Yt,Fe,Fa="Log <code>logs</code> on the various objects watching training, including stored metrics.",ea,N,fe,ta,Ae,Aa="Context manager for handling null reference model (that is, peft adapter manipulation).",ft,ve,vt,M,be,aa,Ke,Ka='KTOConfig collects all training arguments related to the <a href="/docs/trl/pr_1779/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a> class.',na,Ee,Ea=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,bt,Te,Tt,ze,Mt;return A=new F({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),L=new F({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),P=new oa({props:{code:"a3RvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`kto_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),B=new F({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),Q=new F({props:{title:"Using the KTOTrainer",local:"using-the-ktotrainer",headingTag:"h2"}}),X=new oa({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEtUT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMHVuZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSklMEElMEFrdG9fdHJhaW5lciUyMCUzRCUyMEtUT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByZWZfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = KTOConfig(
    beta=<span class="hljs-number">0.1</span>,
    desirable_weight=<span class="hljs-number">1.0</span>,
    undesirable_weight=<span class="hljs-number">1.0</span>,
)

kto_trainer = KTOTrainer(
    model,
    ref_model,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),V=new oa({props:{code:"a3RvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"kto_trainer.train()",wrap:!1}}),Y=new F({props:{title:"Loss Functions",local:"loss-functions",headingTag:"h2"}}),ae=new F({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),le=new F({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),re=new T({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"embedding_func",val:": Optional = None"},{name:"embedding_tokenizer",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.KTOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.KTOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L269"}}),se=new T({props:{name:"bco_loss",anchor:"trl.KTOTrainer.bco_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"chosen_embeddings",val:": Optional"},{name:"rejected_embeddings",val:": Optional"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L1225",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The delta value contains the moving average of all implicit rewards.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),ie=new T({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L976"}}),de=new T({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L1491"}}),me=new T({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L1048",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ce=new T({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L1275"}}),pe=new T({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L1405"}}),_e=new T({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L923"}}),ue=new T({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L882"}}),he=new T({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L1163",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),ge=new T({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L1547"}}),fe=new T({props:{name:"null_ref_context",anchor:"trl.KTOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_trainer.py#L870"}}),ve=new F({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),be=new T({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"loss_type",val:": Literal = 'kto'"},{name:"prompt_sample_size",val:": int = 1024"},{name:"min_density_ratio",val:": float = 0.5"},{name:"max_density_ratio",val:": float = 10.0"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.
loss_type &#x2014; (<code>Literal[&quot;kto&quot;, &quot;bco&quot;]</code>, <em>optional</em>):
The type of loss to use. Either <code>&quot;kto&quot;</code> the default KTO loss, <code>&quot;bco&quot;</code> loss from <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> paper.
prompt_sample_size &#x2014; (<code>int</code>, defaults to 1024):
Number of prompts that are fed to density ratio classifier.
min_density_ratio &#x2014; (<code>float</code>, defaults to 0.5):
The minimum value of the density ratio. The estimated density ratio is clamped to this value.
max_density_ratio &#x2014; (<code>float</code>, defaults to 10.0):
The maximum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/vr_1779/trl/trainer/kto_config.py#L22"}}),Te=new Ba({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/kto_trainer.mdx"}}),{c(){$=s("meta"),Be=n(),Pe=s("p"),We=n(),p(A.$$.fragment),Qe=n(),K=s("p"),K.innerHTML=ra,Se=n(),E=s("p"),E.textContent=sa,Ze=n(),p(L.$$.fragment),Re=n(),q=s("p"),q.textContent=ia,Xe=n(),D=s("ul"),D.innerHTML=da,Ge=n(),H=s("p"),H.textContent=ma,Ve=n(),p(P.$$.fragment),Ye=n(),z=s("p"),z.innerHTML=ca,et=n(),p(B.$$.fragment),tt=n(),W=s("p"),W.innerHTML=pa,at=n(),p(Q.$$.fragment),nt=n(),S=s("p"),S.innerHTML=_a,ot=n(),Z=s("p"),Z.innerHTML=ua,lt=n(),R=s("p"),R.innerHTML=ha,rt=n(),p(X.$$.fragment),st=n(),G=s("p"),G.textContent=ga,it=n(),p(V.$$.fragment),dt=n(),p(Y.$$.fragment),mt=n(),ee=s("p"),ee.textContent=fa,ct=n(),te=s("p"),te.innerHTML=va,pt=n(),p(ae.$$.fragment),_t=n(),ne=s("p"),ne.innerHTML=ba,ut=n(),oe=s("p"),oe.innerHTML=Ta,ht=n(),p(le.$$.fragment),gt=n(),m=s("div"),p(re.$$.fragment),Jt=n(),Me=s("p"),Me.textContent=Ma,kt=n(),C=s("div"),p(se.$$.fragment),It=n(),ye=s("p"),ye.textContent=ya,Nt=n(),U=s("div"),p(ie.$$.fragment),Ft=n(),we=s("p"),we.textContent=wa,At=n(),y=s("div"),p(de.$$.fragment),Kt=n(),xe=s("p"),xe.innerHTML=xa,Et=n(),$e=s("p"),$e.textContent=$a,Lt=n(),O=s("div"),p(me.$$.fragment),qt=n(),Ce=s("p"),Ce.textContent=Ca,Dt=n(),j=s("div"),p(ce.$$.fragment),Ht=n(),Ue=s("p"),Ue.textContent=Ua,Pt=n(),J=s("div"),p(pe.$$.fragment),zt=n(),Oe=s("p"),Oe.textContent=Oa,Bt=n(),w=s("div"),p(_e.$$.fragment),Wt=n(),je=s("p"),je.innerHTML=ja,Qt=n(),Je=s("p"),Je.innerHTML=Ja,St=n(),x=s("div"),p(ue.$$.fragment),Zt=n(),ke=s("p"),ke.innerHTML=ka,Rt=n(),Ie=s("p"),Ie.innerHTML=Ia,Xt=n(),k=s("div"),p(he.$$.fragment),Gt=n(),Ne=s("p"),Ne.textContent=Na,Vt=n(),I=s("div"),p(ge.$$.fragment),Yt=n(),Fe=s("p"),Fe.innerHTML=Fa,ea=n(),N=s("div"),p(fe.$$.fragment),ta=n(),Ae=s("p"),Ae.textContent=Aa,ft=n(),p(ve.$$.fragment),vt=n(),M=s("div"),p(be.$$.fragment),aa=n(),Ke=s("p"),Ke.innerHTML=Ka,na=n(),Ee=s("p"),Ee.innerHTML=Ea,bt=n(),p(Te.$$.fragment),Tt=n(),ze=s("p"),this.h()},l(e){const a=za("svelte-u9bgzb",document.head);$=i(a,"META",{name:!0,content:!0}),a.forEach(t),Be=o(e),Pe=i(e,"P",{}),v(Pe).forEach(t),We=o(e),_(A.$$.fragment,e),Qe=o(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-171dbf3"&&(K.innerHTML=ra),Se=o(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-z1e9ri"&&(E.textContent=sa),Ze=o(e),_(L.$$.fragment,e),Re=o(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1792bye"&&(q.textContent=ia),Xe=o(e),D=i(e,"UL",{"data-svelte-h":!0}),d(D)!=="svelte-1bk1n3o"&&(D.innerHTML=da),Ge=o(e),H=i(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1gl9mvz"&&(H.textContent=ma),Ve=o(e),_(P.$$.fragment,e),Ye=o(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1yefqq4"&&(z.innerHTML=ca),et=o(e),_(B.$$.fragment,e),tt=o(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-znx0uh"&&(W.innerHTML=pa),at=o(e),_(Q.$$.fragment,e),nt=o(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-6k9bp8"&&(S.innerHTML=_a),ot=o(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1eil2tw"&&(Z.innerHTML=ua),lt=o(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-ad0vsu"&&(R.innerHTML=ha),rt=o(e),_(X.$$.fragment,e),st=o(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1lg6q1l"&&(G.textContent=ga),it=o(e),_(V.$$.fragment,e),dt=o(e),_(Y.$$.fragment,e),mt=o(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-17cemnt"&&(ee.textContent=fa),ct=o(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-ohsb6n"&&(te.innerHTML=va),pt=o(e),_(ae.$$.fragment,e),_t=o(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-3kfva2"&&(ne.innerHTML=ba),ut=o(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1c01yo3"&&(oe.innerHTML=Ta),ht=o(e),_(le.$$.fragment,e),gt=o(e),m=i(e,"DIV",{class:!0});var c=v(m);_(re.$$.fragment,c),Jt=o(c),Me=i(c,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-hyhzxp"&&(Me.textContent=Ma),kt=o(c),C=i(c,"DIV",{class:!0});var yt=v(C);_(se.$$.fragment,yt),It=o(yt),ye=i(yt,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-2814fy"&&(ye.textContent=ya),yt.forEach(t),Nt=o(c),U=i(c,"DIV",{class:!0});var wt=v(U);_(ie.$$.fragment,wt),Ft=o(wt),we=i(wt,"P",{"data-svelte-h":!0}),d(we)!=="svelte-pt6g01"&&(we.textContent=wa),wt.forEach(t),At=o(c),y=i(c,"DIV",{class:!0});var Le=v(y);_(de.$$.fragment,Le),Kt=o(Le),xe=i(Le,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-8qlty5"&&(xe.innerHTML=xa),Et=o(Le),$e=i(Le,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1tyo99t"&&($e.textContent=$a),Le.forEach(t),Lt=o(c),O=i(c,"DIV",{class:!0});var xt=v(O);_(me.$$.fragment,xt),qt=o(xt),Ce=i(xt,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-4nmimv"&&(Ce.textContent=Ca),xt.forEach(t),Dt=o(c),j=i(c,"DIV",{class:!0});var $t=v(j);_(ce.$$.fragment,$t),Ht=o($t),Ue=i($t,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-db7iek"&&(Ue.textContent=Ua),$t.forEach(t),Pt=o(c),J=i(c,"DIV",{class:!0});var Ct=v(J);_(pe.$$.fragment,Ct),zt=o(Ct),Oe=i(Ct,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-18uwvbi"&&(Oe.textContent=Oa),Ct.forEach(t),Bt=o(c),w=i(c,"DIV",{class:!0});var qe=v(w);_(_e.$$.fragment,qe),Wt=o(qe),je=i(qe,"P",{"data-svelte-h":!0}),d(je)!=="svelte-xesobz"&&(je.innerHTML=ja),Qt=o(qe),Je=i(qe,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-qg43tm"&&(Je.innerHTML=Ja),qe.forEach(t),St=o(c),x=i(c,"DIV",{class:!0});var De=v(x);_(ue.$$.fragment,De),Zt=o(De),ke=i(De,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-dkae9b"&&(ke.innerHTML=ka),Rt=o(De),Ie=i(De,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-hmd5cw"&&(Ie.innerHTML=Ia),De.forEach(t),Xt=o(c),k=i(c,"DIV",{class:!0});var Ut=v(k);_(he.$$.fragment,Ut),Gt=o(Ut),Ne=i(Ut,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-svckwe"&&(Ne.textContent=Na),Ut.forEach(t),Vt=o(c),I=i(c,"DIV",{class:!0});var Ot=v(I);_(ge.$$.fragment,Ot),Yt=o(Ot),Fe=i(Ot,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-nqksfz"&&(Fe.innerHTML=Fa),Ot.forEach(t),ea=o(c),N=i(c,"DIV",{class:!0});var jt=v(N);_(fe.$$.fragment,jt),ta=o(jt),Ae=i(jt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-17kjsy4"&&(Ae.textContent=Aa),jt.forEach(t),c.forEach(t),ft=o(e),_(ve.$$.fragment,e),vt=o(e),M=i(e,"DIV",{class:!0});var He=v(M);_(be.$$.fragment,He),aa=o(He),Ke=i(He,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-4p3v71"&&(Ke.innerHTML=Ka),na=o(He),Ee=i(He,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1xl7jqc"&&(Ee.innerHTML=Ea),He.forEach(t),bt=o(e),_(Te.$$.fragment,e),Tt=o(e),ze=i(e,"P",{}),v(ze).forEach(t),this.h()},h(){b($,"name","hf:doc:metadata"),b($,"content",Qa),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){l(document.head,$),r(e,Be,a),r(e,Pe,a),r(e,We,a),u(A,e,a),r(e,Qe,a),r(e,K,a),r(e,Se,a),r(e,E,a),r(e,Ze,a),u(L,e,a),r(e,Re,a),r(e,q,a),r(e,Xe,a),r(e,D,a),r(e,Ge,a),r(e,H,a),r(e,Ve,a),u(P,e,a),r(e,Ye,a),r(e,z,a),r(e,et,a),u(B,e,a),r(e,tt,a),r(e,W,a),r(e,at,a),u(Q,e,a),r(e,nt,a),r(e,S,a),r(e,ot,a),r(e,Z,a),r(e,lt,a),r(e,R,a),r(e,rt,a),u(X,e,a),r(e,st,a),r(e,G,a),r(e,it,a),u(V,e,a),r(e,dt,a),u(Y,e,a),r(e,mt,a),r(e,ee,a),r(e,ct,a),r(e,te,a),r(e,pt,a),u(ae,e,a),r(e,_t,a),r(e,ne,a),r(e,ut,a),r(e,oe,a),r(e,ht,a),u(le,e,a),r(e,gt,a),r(e,m,a),u(re,m,null),l(m,Jt),l(m,Me),l(m,kt),l(m,C),u(se,C,null),l(C,It),l(C,ye),l(m,Nt),l(m,U),u(ie,U,null),l(U,Ft),l(U,we),l(m,At),l(m,y),u(de,y,null),l(y,Kt),l(y,xe),l(y,Et),l(y,$e),l(m,Lt),l(m,O),u(me,O,null),l(O,qt),l(O,Ce),l(m,Dt),l(m,j),u(ce,j,null),l(j,Ht),l(j,Ue),l(m,Pt),l(m,J),u(pe,J,null),l(J,zt),l(J,Oe),l(m,Bt),l(m,w),u(_e,w,null),l(w,Wt),l(w,je),l(w,Qt),l(w,Je),l(m,St),l(m,x),u(ue,x,null),l(x,Zt),l(x,ke),l(x,Rt),l(x,Ie),l(m,Xt),l(m,k),u(he,k,null),l(k,Gt),l(k,Ne),l(m,Vt),l(m,I),u(ge,I,null),l(I,Yt),l(I,Fe),l(m,ea),l(m,N),u(fe,N,null),l(N,ta),l(N,Ae),r(e,ft,a),u(ve,e,a),r(e,vt,a),r(e,M,a),u(be,M,null),l(M,aa),l(M,Ke),l(M,na),l(M,Ee),r(e,bt,a),u(Te,e,a),r(e,Tt,a),r(e,ze,a),Mt=!0},p:qa,i(e){Mt||(h(A.$$.fragment,e),h(L.$$.fragment,e),h(P.$$.fragment,e),h(B.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(_e.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(fe.$$.fragment,e),h(ve.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),Mt=!0)},o(e){g(A.$$.fragment,e),g(L.$$.fragment,e),g(P.$$.fragment,e),g(B.$$.fragment,e),g(Q.$$.fragment,e),g(X.$$.fragment,e),g(V.$$.fragment,e),g(Y.$$.fragment,e),g(ae.$$.fragment,e),g(le.$$.fragment,e),g(re.$$.fragment,e),g(se.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(_e.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),Mt=!1},d(e){e&&(t(Be),t(Pe),t(We),t(Qe),t(K),t(Se),t(E),t(Ze),t(Re),t(q),t(Xe),t(D),t(Ge),t(H),t(Ve),t(Ye),t(z),t(et),t(tt),t(W),t(at),t(nt),t(S),t(ot),t(Z),t(lt),t(R),t(rt),t(st),t(G),t(it),t(dt),t(mt),t(ee),t(ct),t(te),t(pt),t(_t),t(ne),t(ut),t(oe),t(ht),t(gt),t(m),t(ft),t(vt),t(M),t(bt),t(Tt),t(ze)),t($),f(A,e),f(L,e),f(P,e),f(B,e),f(Q,e),f(X,e),f(V,e),f(Y,e),f(ae,e),f(le,e),f(re),f(se),f(ie),f(de),f(me),f(ce),f(pe),f(_e),f(ue),f(he),f(ge),f(fe),f(ve,e),f(be),f(Te,e)}}}const Qa='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the KTOTrainer","local":"using-the-ktotrainer","sections":[],"depth":2},{"title":"Loss Functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function Sa(la){return Da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends Ha{constructor($){super(),Pa(this,$,Sa,Wa,La,{})}}export{en as component};
