import{s as lc,n as ac,o as dc}from"../chunks/scheduler.0219f8bd.js";import{S as ic,i as cc,g as a,s,r as p,A as pc,h as d,f as r,c as l,j as _,u as m,x as i,k as c,y as mc,a as o,v as n,d as u,t as h,w as f}from"../chunks/index.f61edf3b.js";import{C as ud}from"../chunks/CodeBlock.38e566ae.js";import{H as g,E as nc}from"../chunks/EditOnGithub.48fa589f.js";function uc(hd){let x,kr,Ir,Lr,T,jr,b,zr,v,fd="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",Ar,y,_d="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",Rr,$,Dr,M,gd='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li> <li><a href="#Callable+_call"><code>._call(...args)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li> <li><a href="#module_processors.data"><code>.data</code></a> : <code>Float32Array</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..enforce_size_divisibility"><code>~enforce_size_divisibility(size, divisor)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',Ur,Br,Wr,w,Nr,E,Gr,C,xd="Base class for feature extractors.",Yr,P,Td='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <a href="#Callable"><code>Callable</code></a>',Zr,H,bd='<li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li> <li><a href="#Callable+_call"><code>._call(...args)</code></a></li></ul></li>',Qr,Xr,Vr,J,qr,I,Sr,F,vd="Constructs a new FeatureExtractor instance.",Kr,k,yd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",Or,eo,to,L,ro,j,oo,z,$d=`This method should be implemented in subclasses to provide the
functionality of the callable object.`,so,A,Md='<strong>Kind</strong>: instance method of <a href="#module_processors.FeatureExtractor"><code>FeatureExtractor</code></a><br/> <strong>Overrides</strong>: <a href="#Callable+_call"><code>_call</code></a><br/> <strong>Throws</strong>:',lo,R,wd="<li><code>Error</code> If the subclass does not implement the `_call` method.</li>",ao,D,Ed="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>Array.&lt;any&gt;</code></td></tr></tbody>",io,co,po,U,mo,B,no,W,Cd="Feature extractor for image models.",uo,N,Pd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',ho,G,Hd='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',fo,_o,go,Y,xo,Z,To,Q,Jd="Constructs a new ImageFeatureExtractor instance.",bo,X,Id=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code> | <code>Object</code></td><td></td><td><p>The size to resize the image to.</p></td> </tr><tr><td>[config.do_flip_channel_order]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to flip the color channels from RGB to BGR.
Can be overridden by the <code>do_flip_channel_order</code> parameter in the <code>preprocess</code> method.</p></td></tr></tbody>`,vo,yo,$o,V,Mo,q,wo,S,Fd=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,Eo,K,kd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Co,O,Ld="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",Po,Ho,Jo,ee,Io,te,Fo,re,jd="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",ko,oe,zd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',Lo,se,Ad="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",jo,zo,Ao,le,Ro,ae,Do,de,Rd="Pad the image by a certain amount.",Uo,ie,Dd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',Bo,ce,Ud="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image (height, width, channels).</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",Wo,No,Go,pe,Yo,me,Zo,ne,Bd="Rescale the image’ pixel values by <code>this.rescale_factor</code>.",Qo,ue,Wd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a>',Xo,he,Nd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td><p>The pixel data to rescale.</p></td></tr></tbody>",Vo,qo,So,fe,Ko,_e,Oo,ge,Gd=`Find the target (width, height) dimension of the output image after
resizing given the input image and the desired size.`,es,xe,Yd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The target (width, height) dimension of the output image after resizing.',ts,Te,Zd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td> </tr><tr><td>size</td><td><code>any</code></td><td><p>The size to use for resizing the image.</p></td></tr></tbody>",rs,os,ss,be,ls,ve,as,ye,Qd="Resizes the image.",ds,$e,Xd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',is,Me,Vd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td></tr></tbody>",cs,ps,ms,we,ns,Ee,us,Ce,qd="Preprocesses the given image.",hs,Pe,Sd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',fs,He,Kd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",_s,gs,xs,Je,Ts,Ie,bs,Fe,Od=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,vs,ke,ei='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',ys,Le,ti="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",$s,Ms,ws,je,Es,ze,Cs,Ae,ri="Detr Feature Extractor.",Ps,Re,oi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',Hs,De,si='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',Js,Is,Fs,Ue,ks,Be,Ls,We,li=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,js,Ne,ai='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',zs,Ge,di="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",As,Rs,Ds,Ye,Us,Ze,Bs,Qe,ii='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Ws,Ns,Gs,Xe,Ys,Ve,Zs,qe,ci="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",Qs,Se,pi='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',Xs,Ke,mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",Vs,qs,Ss,Oe,Ks,et,Os,tt,ni="Checks whether the segment is valid or not.",el,rt,ui='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',tl,ot,hi="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",rl,ol,sl,st,ll,lt,al,at,fi="Computes the segments.",dl,dt,_i='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',il,it,gi="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",cl,pl,ml,ct,nl,pt,ul,mt,xi="Post-process the model output to generate the final panoptic segmentation.",hl,nt,Ti='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',fl,ut,bi="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",_l,gl,xl,ht,Tl,ft,bl,_t,vi="Represents a Processor that extracts features from an input.",vl,gt,yi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <a href="#Callable"><code>Callable</code></a>',yl,xt,$i='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',$l,Ml,wl,Tt,El,bt,Cl,vt,Mi="Creates a new Processor with the given feature extractor.",Pl,yt,wi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",Hl,Jl,Il,$t,Fl,Mt,kl,wt,Ei="Calls the feature_extractor function with the given input.",Ll,Et,Ci='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Overrides</strong>: <a href="#Callable+_call"><code>_call</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',jl,Ct,Pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",zl,Al,Rl,Pt,Dl,Ht,Ul,Jt,Hi="Represents a WhisperProcessor that extracts features from an audio input.",Bl,It,Ji='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',Wl,Nl,Gl,Ft,Yl,kt,Zl,Lt,Ii="Calls the feature_extractor function with the given audio input.",Ql,jt,Fi='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Xl,zt,ki="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Vl,ql,Sl,At,Kl,Rt,Ol,Dt,Li=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,ea,Ut,ji="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",ta,Bt,ra,Wt,zi="<strong>Example:</strong> Run an image through a processor.",oa,Nt,sa,Gt,Ai='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',la,aa,da,Yt,ia,Zt,ca,Qt,Ri="Instantiate one of the processor classes of the library from a pretrained model.",pa,Xt,Di=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,ma,Vt,Ui='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',na,qt,Bi=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,ua,ha,fa,St,_a,Kt,ga,Ot,Wi='<strong>Kind</strong>: static property of <a href="#module_processors"><code>processors</code></a>',xa,Ta,ba,er,va,tr,ya,rr,Ni="Converts bounding boxes from center format to corners format.",$a,or,Gi='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',Ma,sr,Yi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",wa,Ea,Ca,lr,Pa,ar,Ha,dr,Zi="Rounds the height and width down to the closest multiple of size_divisibility",Ja,ir,Qi='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>*</code> - The rounded size.',Ia,cr,Xi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>*</code></td><td><p>The size of the image</p></td> </tr><tr><td>divisor</td><td><code>number</code></td><td><p>The divisor to use.</p></td></tr></tbody>",Fa,ka,La,pr,ja,mr,za,nr,Vi=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,Aa,ur,qi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',Ra,Da,Ua,hr,Ba,fr,Wa,_r,Si='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Na,gr,Ki="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",Ga,Ya,Za,xr,Qa,Tr,Xa,br,Oi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Va,vr,ec="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",qa,Sa,Ka,yr,Oa,$r,ed,Mr,tc='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',td,wr,rc="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",rd,od,sd,Er,ld,Cr,ad,Pr,oc='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',dd,Hr,sc="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>[input_points]</td><td><code>Tensor</code></td> </tr><tr><td>[input_labels]</td><td><code>Tensor</code></td> </tr><tr><td>[input_boxes]</td><td><code>Tensor</code></td></tr></tbody>",id,cd,pd,Jr,md,Fr,nd;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),$=new ud({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWxldCUyMHByb2Nlc3NvciUyMCUzRCUyMGF3YWl0JTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJ29wZW5haSUyRndoaXNwZXItdGlueS5lbicpJTNCJTBBbGV0JTIwYXVkaW8lMjAlM0QlMjBhd2FpdCUyMHJlYWRfYXVkaW8oJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGbWxrLmZsYWMnJTJDJTIwMTYwMDApJTNCJTBBbGV0JTIwJTdCJTIwaW5wdXRfZmVhdHVyZXMlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMHByb2Nlc3NvcihhdWRpbyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDI0MDAwMCklMjAlNUIwLjQ3NTI5ODQ2NDI5ODI0ODMlMkMlMjAwLjU1OTcyNTg4MDYyMjg2MzglMkMlMjAwLjU2NDM0MTY2NDMxNDI3JTJDJTIwLi4uJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QjElMkMlMjA4MCUyQyUyMDMwMDAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2l6ZSUzQSUyMDI0MDAwMCUyQyUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),I=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),j=new g({props:{title:"featureExtractor._call(...args)",local:"featureextractorcallargs",headingTag:"h3"}}),B=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),Z=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),q=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),te=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),ae=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),me=new g({props:{title:"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>",local:"imagefeatureextractorrescalepixeldata--code-void-code",headingTag:"h3"}}),_e=new g({props:{title:"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>",local:"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code",headingTag:"h3"}}),ve=new g({props:{title:"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorresizeimage--code-promise--rawimage--code",headingTag:"h3"}}),Ee=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),Ie=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),ze=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),Be=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),Ze=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),Ve=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),et=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),lt=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),pt=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),ft=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),bt=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),Mt=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),Ht=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),kt=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),Rt=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),Bt=new ud({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),Nt=new ud({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Zt=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),Kt=new g({props:{title:"processors.data : <code> Float32Array </code>",local:"processorsdata--code-float32array-code",headingTag:"h2"}}),tr=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),ar=new g({props:{title:"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>",local:"processorsenforcesizedivisibilitysize-divisor--code--code",headingTag:"h2"}}),mr=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),fr=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),Tr=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),$r=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),Cr=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),Jr=new nc({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/processors.md"}}),{c(){x=a("meta"),kr=s(),Ir=a("p"),Lr=s(),T=a("a"),jr=s(),p(b.$$.fragment),zr=s(),v=a("p"),v.textContent=fd,Ar=s(),y=a("p"),y.innerHTML=_d,Rr=s(),p($.$$.fragment),Dr=s(),M=a("ul"),M.innerHTML=gd,Ur=s(),Br=a("hr"),Wr=s(),w=a("a"),Nr=s(),p(E.$$.fragment),Gr=s(),C=a("p"),C.textContent=xd,Yr=s(),P=a("p"),P.innerHTML=Td,Zr=s(),H=a("ul"),H.innerHTML=bd,Qr=s(),Xr=a("hr"),Vr=s(),J=a("a"),qr=s(),p(I.$$.fragment),Sr=s(),F=a("p"),F.textContent=vd,Kr=s(),k=a("table"),k.innerHTML=yd,Or=s(),eo=a("hr"),to=s(),L=a("a"),ro=s(),p(j.$$.fragment),oo=s(),z=a("p"),z.textContent=$d,so=s(),A=a("p"),A.innerHTML=Md,lo=s(),R=a("ul"),R.innerHTML=wd,ao=s(),D=a("table"),D.innerHTML=Ed,io=s(),co=a("hr"),po=s(),U=a("a"),mo=s(),p(B.$$.fragment),no=s(),W=a("p"),W.textContent=Cd,uo=s(),N=a("p"),N.innerHTML=Pd,ho=s(),G=a("ul"),G.innerHTML=Hd,fo=s(),_o=a("hr"),go=s(),Y=a("a"),xo=s(),p(Z.$$.fragment),To=s(),Q=a("p"),Q.textContent=Jd,bo=s(),X=a("table"),X.innerHTML=Id,vo=s(),yo=a("hr"),$o=s(),V=a("a"),Mo=s(),p(q.$$.fragment),wo=s(),S=a("p"),S.textContent=Fd,Eo=s(),K=a("p"),K.innerHTML=kd,Co=s(),O=a("table"),O.innerHTML=Ld,Po=s(),Ho=a("hr"),Jo=s(),ee=a("a"),Io=s(),p(te.$$.fragment),Fo=s(),re=a("p"),re.textContent=jd,ko=s(),oe=a("p"),oe.innerHTML=zd,Lo=s(),se=a("table"),se.innerHTML=Ad,jo=s(),zo=a("hr"),Ao=s(),le=a("a"),Ro=s(),p(ae.$$.fragment),Do=s(),de=a("p"),de.textContent=Rd,Uo=s(),ie=a("p"),ie.innerHTML=Dd,Bo=s(),ce=a("table"),ce.innerHTML=Ud,Wo=s(),No=a("hr"),Go=s(),pe=a("a"),Yo=s(),p(me.$$.fragment),Zo=s(),ne=a("p"),ne.innerHTML=Bd,Qo=s(),ue=a("p"),ue.innerHTML=Wd,Xo=s(),he=a("table"),he.innerHTML=Nd,Vo=s(),qo=a("hr"),So=s(),fe=a("a"),Ko=s(),p(_e.$$.fragment),Oo=s(),ge=a("p"),ge.textContent=Gd,es=s(),xe=a("p"),xe.innerHTML=Yd,ts=s(),Te=a("table"),Te.innerHTML=Zd,rs=s(),os=a("hr"),ss=s(),be=a("a"),ls=s(),p(ve.$$.fragment),as=s(),ye=a("p"),ye.textContent=Qd,ds=s(),$e=a("p"),$e.innerHTML=Xd,is=s(),Me=a("table"),Me.innerHTML=Vd,cs=s(),ps=a("hr"),ms=s(),we=a("a"),ns=s(),p(Ee.$$.fragment),us=s(),Ce=a("p"),Ce.textContent=qd,hs=s(),Pe=a("p"),Pe.innerHTML=Sd,fs=s(),He=a("table"),He.innerHTML=Kd,_s=s(),gs=a("hr"),xs=s(),Je=a("a"),Ts=s(),p(Ie.$$.fragment),bs=s(),Fe=a("p"),Fe.textContent=Od,vs=s(),ke=a("p"),ke.innerHTML=ei,ys=s(),Le=a("table"),Le.innerHTML=ti,$s=s(),Ms=a("hr"),ws=s(),je=a("a"),Es=s(),p(ze.$$.fragment),Cs=s(),Ae=a("p"),Ae.textContent=ri,Ps=s(),Re=a("p"),Re.innerHTML=oi,Hs=s(),De=a("ul"),De.innerHTML=si,Js=s(),Is=a("hr"),Fs=s(),Ue=a("a"),ks=s(),p(Be.$$.fragment),Ls=s(),We=a("p"),We.textContent=li,js=s(),Ne=a("p"),Ne.innerHTML=ai,zs=s(),Ge=a("table"),Ge.innerHTML=di,As=s(),Rs=a("hr"),Ds=s(),Ye=a("a"),Us=s(),p(Ze.$$.fragment),Bs=s(),Qe=a("p"),Qe.innerHTML=ii,Ws=s(),Ns=a("hr"),Gs=s(),Xe=a("a"),Ys=s(),p(Ve.$$.fragment),Zs=s(),qe=a("p"),qe.innerHTML=ci,Qs=s(),Se=a("p"),Se.innerHTML=pi,Xs=s(),Ke=a("table"),Ke.innerHTML=mi,Vs=s(),qs=a("hr"),Ss=s(),Oe=a("a"),Ks=s(),p(et.$$.fragment),Os=s(),tt=a("p"),tt.textContent=ni,el=s(),rt=a("p"),rt.innerHTML=ui,tl=s(),ot=a("table"),ot.innerHTML=hi,rl=s(),ol=a("hr"),sl=s(),st=a("a"),ll=s(),p(lt.$$.fragment),al=s(),at=a("p"),at.textContent=fi,dl=s(),dt=a("p"),dt.innerHTML=_i,il=s(),it=a("table"),it.innerHTML=gi,cl=s(),pl=a("hr"),ml=s(),ct=a("a"),nl=s(),p(pt.$$.fragment),ul=s(),mt=a("p"),mt.textContent=xi,hl=s(),nt=a("p"),nt.innerHTML=Ti,fl=s(),ut=a("table"),ut.innerHTML=bi,_l=s(),gl=a("hr"),xl=s(),ht=a("a"),Tl=s(),p(ft.$$.fragment),bl=s(),_t=a("p"),_t.textContent=vi,vl=s(),gt=a("p"),gt.innerHTML=yi,yl=s(),xt=a("ul"),xt.innerHTML=$i,$l=s(),Ml=a("hr"),wl=s(),Tt=a("a"),El=s(),p(bt.$$.fragment),Cl=s(),vt=a("p"),vt.textContent=Mi,Pl=s(),yt=a("table"),yt.innerHTML=wi,Hl=s(),Jl=a("hr"),Il=s(),$t=a("a"),Fl=s(),p(Mt.$$.fragment),kl=s(),wt=a("p"),wt.textContent=Ei,Ll=s(),Et=a("p"),Et.innerHTML=Ci,jl=s(),Ct=a("table"),Ct.innerHTML=Pi,zl=s(),Al=a("hr"),Rl=s(),Pt=a("a"),Dl=s(),p(Ht.$$.fragment),Ul=s(),Jt=a("p"),Jt.textContent=Hi,Bl=s(),It=a("p"),It.innerHTML=Ji,Wl=s(),Nl=a("hr"),Gl=s(),Ft=a("a"),Yl=s(),p(kt.$$.fragment),Zl=s(),Lt=a("p"),Lt.textContent=Ii,Ql=s(),jt=a("p"),jt.innerHTML=Fi,Xl=s(),zt=a("table"),zt.innerHTML=ki,Vl=s(),ql=a("hr"),Sl=s(),At=a("a"),Kl=s(),p(Rt.$$.fragment),Ol=s(),Dt=a("p"),Dt.innerHTML=Li,ea=s(),Ut=a("p"),Ut.innerHTML=ji,ta=s(),p(Bt.$$.fragment),ra=s(),Wt=a("p"),Wt.innerHTML=zi,oa=s(),p(Nt.$$.fragment),sa=s(),Gt=a("p"),Gt.innerHTML=Ai,la=s(),aa=a("hr"),da=s(),Yt=a("a"),ia=s(),p(Zt.$$.fragment),ca=s(),Qt=a("p"),Qt.textContent=Ri,pa=s(),Xt=a("p"),Xt.innerHTML=Di,ma=s(),Vt=a("p"),Vt.innerHTML=Ui,na=s(),qt=a("table"),qt.innerHTML=Bi,ua=s(),ha=a("hr"),fa=s(),St=a("a"),_a=s(),p(Kt.$$.fragment),ga=s(),Ot=a("p"),Ot.innerHTML=Wi,xa=s(),Ta=a("hr"),ba=s(),er=a("a"),va=s(),p(tr.$$.fragment),ya=s(),rr=a("p"),rr.textContent=Ni,$a=s(),or=a("p"),or.innerHTML=Gi,Ma=s(),sr=a("table"),sr.innerHTML=Yi,wa=s(),Ea=a("hr"),Ca=s(),lr=a("a"),Pa=s(),p(ar.$$.fragment),Ha=s(),dr=a("p"),dr.textContent=Zi,Ja=s(),ir=a("p"),ir.innerHTML=Qi,Ia=s(),cr=a("table"),cr.innerHTML=Xi,Fa=s(),ka=a("hr"),La=s(),pr=a("a"),ja=s(),p(mr.$$.fragment),za=s(),nr=a("p"),nr.textContent=Vi,Aa=s(),ur=a("p"),ur.innerHTML=qi,Ra=s(),Da=a("hr"),Ua=s(),hr=a("a"),Ba=s(),p(fr.$$.fragment),Wa=s(),_r=a("p"),_r.innerHTML=Si,Na=s(),gr=a("table"),gr.innerHTML=Ki,Ga=s(),Ya=a("hr"),Za=s(),xr=a("a"),Qa=s(),p(Tr.$$.fragment),Xa=s(),br=a("p"),br.innerHTML=Oi,Va=s(),vr=a("table"),vr.innerHTML=ec,qa=s(),Sa=a("hr"),Ka=s(),yr=a("a"),Oa=s(),p($r.$$.fragment),ed=s(),Mr=a("p"),Mr.innerHTML=tc,td=s(),wr=a("table"),wr.innerHTML=rc,rd=s(),od=a("hr"),sd=s(),Er=a("a"),ld=s(),p(Cr.$$.fragment),ad=s(),Pr=a("p"),Pr.innerHTML=oc,dd=s(),Hr=a("table"),Hr.innerHTML=sc,id=s(),cd=a("hr"),pd=s(),p(Jr.$$.fragment),md=s(),Fr=a("p"),this.h()},l(e){const t=pc("svelte-u9bgzb",document.head);x=d(t,"META",{name:!0,content:!0}),t.forEach(r),kr=l(e),Ir=d(e,"P",{}),_(Ir).forEach(r),Lr=l(e),T=d(e,"A",{id:!0,class:!0}),_(T).forEach(r),jr=l(e),m(b.$$.fragment,e),zr=l(e),v=d(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-w0rx8m"&&(v.textContent=fd),Ar=l(e),y=d(e,"P",{"data-svelte-h":!0}),i(y)!=="svelte-1olsie5"&&(y.innerHTML=_d),Rr=l(e),m($.$$.fragment,e),Dr=l(e),M=d(e,"UL",{"data-svelte-h":!0}),i(M)!=="svelte-q1j7vm"&&(M.innerHTML=gd),Ur=l(e),Br=d(e,"HR",{}),Wr=l(e),w=d(e,"A",{id:!0,class:!0}),_(w).forEach(r),Nr=l(e),m(E.$$.fragment,e),Gr=l(e),C=d(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-14r3pvv"&&(C.textContent=xd),Yr=l(e),P=d(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-13iv745"&&(P.innerHTML=Td),Zr=l(e),H=d(e,"UL",{"data-svelte-h":!0}),i(H)!=="svelte-16exrlt"&&(H.innerHTML=bd),Qr=l(e),Xr=d(e,"HR",{}),Vr=l(e),J=d(e,"A",{id:!0,class:!0}),_(J).forEach(r),qr=l(e),m(I.$$.fragment,e),Sr=l(e),F=d(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-k3m2wg"&&(F.textContent=vd),Kr=l(e),k=d(e,"TABLE",{"data-svelte-h":!0}),i(k)!=="svelte-rd7ds7"&&(k.innerHTML=yd),Or=l(e),eo=d(e,"HR",{}),to=l(e),L=d(e,"A",{id:!0,class:!0}),_(L).forEach(r),ro=l(e),m(j.$$.fragment,e),oo=l(e),z=d(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-8c74gj"&&(z.textContent=$d),so=l(e),A=d(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-syym47"&&(A.innerHTML=Md),lo=l(e),R=d(e,"UL",{"data-svelte-h":!0}),i(R)!=="svelte-7c1v8c"&&(R.innerHTML=wd),ao=l(e),D=d(e,"TABLE",{"data-svelte-h":!0}),i(D)!=="svelte-1v34kj"&&(D.innerHTML=Ed),io=l(e),co=d(e,"HR",{}),po=l(e),U=d(e,"A",{id:!0,class:!0}),_(U).forEach(r),mo=l(e),m(B.$$.fragment,e),no=l(e),W=d(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-8k8cys"&&(W.textContent=Cd),uo=l(e),N=d(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-18p52n5"&&(N.innerHTML=Pd),ho=l(e),G=d(e,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-1ne2ywl"&&(G.innerHTML=Hd),fo=l(e),_o=d(e,"HR",{}),go=l(e),Y=d(e,"A",{id:!0,class:!0}),_(Y).forEach(r),xo=l(e),m(Z.$$.fragment,e),To=l(e),Q=d(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1mp2vol"&&(Q.textContent=Jd),bo=l(e),X=d(e,"TABLE",{"data-svelte-h":!0}),i(X)!=="svelte-1131cyk"&&(X.innerHTML=Id),vo=l(e),yo=d(e,"HR",{}),$o=l(e),V=d(e,"A",{id:!0,class:!0}),_(V).forEach(r),Mo=l(e),m(q.$$.fragment,e),wo=l(e),S=d(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1q6eyx4"&&(S.textContent=Fd),Eo=l(e),K=d(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-ar7q77"&&(K.innerHTML=kd),Co=l(e),O=d(e,"TABLE",{"data-svelte-h":!0}),i(O)!=="svelte-klyf4z"&&(O.innerHTML=Ld),Po=l(e),Ho=d(e,"HR",{}),Jo=l(e),ee=d(e,"A",{id:!0,class:!0}),_(ee).forEach(r),Io=l(e),m(te.$$.fragment,e),Fo=l(e),re=d(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-7fx89a"&&(re.textContent=jd),ko=l(e),oe=d(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-65os4c"&&(oe.innerHTML=zd),Lo=l(e),se=d(e,"TABLE",{"data-svelte-h":!0}),i(se)!=="svelte-1dnvwno"&&(se.innerHTML=Ad),jo=l(e),zo=d(e,"HR",{}),Ao=l(e),le=d(e,"A",{id:!0,class:!0}),_(le).forEach(r),Ro=l(e),m(ae.$$.fragment,e),Do=l(e),de=d(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1mmkb9p"&&(de.textContent=Rd),Uo=l(e),ie=d(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-110o3sn"&&(ie.innerHTML=Dd),Bo=l(e),ce=d(e,"TABLE",{"data-svelte-h":!0}),i(ce)!=="svelte-mhh1xm"&&(ce.innerHTML=Ud),Wo=l(e),No=d(e,"HR",{}),Go=l(e),pe=d(e,"A",{id:!0,class:!0}),_(pe).forEach(r),Yo=l(e),m(me.$$.fragment,e),Zo=l(e),ne=d(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-pyd72v"&&(ne.innerHTML=Bd),Qo=l(e),ue=d(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-1isxmg1"&&(ue.innerHTML=Wd),Xo=l(e),he=d(e,"TABLE",{"data-svelte-h":!0}),i(he)!=="svelte-1e1ka8e"&&(he.innerHTML=Nd),Vo=l(e),qo=d(e,"HR",{}),So=l(e),fe=d(e,"A",{id:!0,class:!0}),_(fe).forEach(r),Ko=l(e),m(_e.$$.fragment,e),Oo=l(e),ge=d(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-8leww2"&&(ge.textContent=Gd),es=l(e),xe=d(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-eqxqo6"&&(xe.innerHTML=Yd),ts=l(e),Te=d(e,"TABLE",{"data-svelte-h":!0}),i(Te)!=="svelte-1n361ub"&&(Te.innerHTML=Zd),rs=l(e),os=d(e,"HR",{}),ss=l(e),be=d(e,"A",{id:!0,class:!0}),_(be).forEach(r),ls=l(e),m(ve.$$.fragment,e),as=l(e),ye=d(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-5iny39"&&(ye.textContent=Qd),ds=l(e),$e=d(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-ar7q77"&&($e.innerHTML=Xd),is=l(e),Me=d(e,"TABLE",{"data-svelte-h":!0}),i(Me)!=="svelte-d8vk38"&&(Me.innerHTML=Vd),cs=l(e),ps=d(e,"HR",{}),ms=l(e),we=d(e,"A",{id:!0,class:!0}),_(we).forEach(r),ns=l(e),m(Ee.$$.fragment,e),us=l(e),Ce=d(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-10g8wi9"&&(Ce.textContent=qd),hs=l(e),Pe=d(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-cd20o3"&&(Pe.innerHTML=Sd),fs=l(e),He=d(e,"TABLE",{"data-svelte-h":!0}),i(He)!=="svelte-1773mps"&&(He.innerHTML=Kd),_s=l(e),gs=d(e,"HR",{}),xs=l(e),Je=d(e,"A",{id:!0,class:!0}),_(Je).forEach(r),Ts=l(e),m(Ie.$$.fragment,e),bs=l(e),Fe=d(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-1uytqp8"&&(Fe.textContent=Od),vs=l(e),ke=d(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-1pa0uk8"&&(ke.innerHTML=ei),ys=l(e),Le=d(e,"TABLE",{"data-svelte-h":!0}),i(Le)!=="svelte-hch5rz"&&(Le.innerHTML=ti),$s=l(e),Ms=d(e,"HR",{}),ws=l(e),je=d(e,"A",{id:!0,class:!0}),_(je).forEach(r),Es=l(e),m(ze.$$.fragment,e),Cs=l(e),Ae=d(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-y1gxwn"&&(Ae.textContent=ri),Ps=l(e),Re=d(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-1xz91ac"&&(Re.innerHTML=oi),Hs=l(e),De=d(e,"UL",{"data-svelte-h":!0}),i(De)!=="svelte-1obx36y"&&(De.innerHTML=si),Js=l(e),Is=d(e,"HR",{}),Fs=l(e),Ue=d(e,"A",{id:!0,class:!0}),_(Ue).forEach(r),ks=l(e),m(Be.$$.fragment,e),Ls=l(e),We=d(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1ec3vsm"&&(We.textContent=li),js=l(e),Ne=d(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-6tjpr7"&&(Ne.innerHTML=ai),zs=l(e),Ge=d(e,"TABLE",{"data-svelte-h":!0}),i(Ge)!=="svelte-1px7bnv"&&(Ge.innerHTML=di),As=l(e),Rs=d(e,"HR",{}),Ds=l(e),Ye=d(e,"A",{id:!0,class:!0}),_(Ye).forEach(r),Us=l(e),m(Ze.$$.fragment,e),Bs=l(e),Qe=d(e,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-j2v54d"&&(Qe.innerHTML=ii),Ws=l(e),Ns=d(e,"HR",{}),Gs=l(e),Xe=d(e,"A",{id:!0,class:!0}),_(Xe).forEach(r),Ys=l(e),m(Ve.$$.fragment,e),Zs=l(e),qe=d(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-75c7d5"&&(qe.innerHTML=ci),Qs=l(e),Se=d(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-o8p6wm"&&(Se.innerHTML=pi),Xs=l(e),Ke=d(e,"TABLE",{"data-svelte-h":!0}),i(Ke)!=="svelte-yqya7v"&&(Ke.innerHTML=mi),Vs=l(e),qs=d(e,"HR",{}),Ss=l(e),Oe=d(e,"A",{id:!0,class:!0}),_(Oe).forEach(r),Ks=l(e),m(et.$$.fragment,e),Os=l(e),tt=d(e,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-gl8gb6"&&(tt.textContent=ni),el=l(e),rt=d(e,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-1qxvzd2"&&(rt.innerHTML=ui),tl=l(e),ot=d(e,"TABLE",{"data-svelte-h":!0}),i(ot)!=="svelte-1f7z42u"&&(ot.innerHTML=hi),rl=l(e),ol=d(e,"HR",{}),sl=l(e),st=d(e,"A",{id:!0,class:!0}),_(st).forEach(r),ll=l(e),m(lt.$$.fragment,e),al=l(e),at=d(e,"P",{"data-svelte-h":!0}),i(at)!=="svelte-7vs1p7"&&(at.textContent=fi),dl=l(e),dt=d(e,"P",{"data-svelte-h":!0}),i(dt)!=="svelte-15rcpil"&&(dt.innerHTML=_i),il=l(e),it=d(e,"TABLE",{"data-svelte-h":!0}),i(it)!=="svelte-3xdz32"&&(it.innerHTML=gi),cl=l(e),pl=d(e,"HR",{}),ml=l(e),ct=d(e,"A",{id:!0,class:!0}),_(ct).forEach(r),nl=l(e),m(pt.$$.fragment,e),ul=l(e),mt=d(e,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-frdp8m"&&(mt.textContent=xi),hl=l(e),nt=d(e,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-j2v54d"&&(nt.innerHTML=Ti),fl=l(e),ut=d(e,"TABLE",{"data-svelte-h":!0}),i(ut)!=="svelte-11rkhka"&&(ut.innerHTML=bi),_l=l(e),gl=d(e,"HR",{}),xl=l(e),ht=d(e,"A",{id:!0,class:!0}),_(ht).forEach(r),Tl=l(e),m(ft.$$.fragment,e),bl=l(e),_t=d(e,"P",{"data-svelte-h":!0}),i(_t)!=="svelte-o9f953"&&(_t.textContent=vi),vl=l(e),gt=d(e,"P",{"data-svelte-h":!0}),i(gt)!=="svelte-13iv745"&&(gt.innerHTML=yi),yl=l(e),xt=d(e,"UL",{"data-svelte-h":!0}),i(xt)!=="svelte-ceq7pc"&&(xt.innerHTML=$i),$l=l(e),Ml=d(e,"HR",{}),wl=l(e),Tt=d(e,"A",{id:!0,class:!0}),_(Tt).forEach(r),El=l(e),m(bt.$$.fragment,e),Cl=l(e),vt=d(e,"P",{"data-svelte-h":!0}),i(vt)!=="svelte-1naom0u"&&(vt.textContent=Mi),Pl=l(e),yt=d(e,"TABLE",{"data-svelte-h":!0}),i(yt)!=="svelte-ilxs6c"&&(yt.innerHTML=wi),Hl=l(e),Jl=d(e,"HR",{}),Il=l(e),$t=d(e,"A",{id:!0,class:!0}),_($t).forEach(r),Fl=l(e),m(Mt.$$.fragment,e),kl=l(e),wt=d(e,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-zbbm3j"&&(wt.textContent=Ei),Ll=l(e),Et=d(e,"P",{"data-svelte-h":!0}),i(Et)!=="svelte-1hik6yq"&&(Et.innerHTML=Ci),jl=l(e),Ct=d(e,"TABLE",{"data-svelte-h":!0}),i(Ct)!=="svelte-pm1u9z"&&(Ct.innerHTML=Pi),zl=l(e),Al=d(e,"HR",{}),Rl=l(e),Pt=d(e,"A",{id:!0,class:!0}),_(Pt).forEach(r),Dl=l(e),m(Ht.$$.fragment,e),Ul=l(e),Jt=d(e,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-17pib55"&&(Jt.textContent=Hi),Bl=l(e),It=d(e,"P",{"data-svelte-h":!0}),i(It)!=="svelte-1ljhyyr"&&(It.innerHTML=Ji),Wl=l(e),Nl=d(e,"HR",{}),Gl=l(e),Ft=d(e,"A",{id:!0,class:!0}),_(Ft).forEach(r),Yl=l(e),m(kt.$$.fragment,e),Zl=l(e),Lt=d(e,"P",{"data-svelte-h":!0}),i(Lt)!=="svelte-r5x3fh"&&(Lt.textContent=Ii),Ql=l(e),jt=d(e,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-1vpvonk"&&(jt.innerHTML=Fi),Xl=l(e),zt=d(e,"TABLE",{"data-svelte-h":!0}),i(zt)!=="svelte-nv3lon"&&(zt.innerHTML=ki),Vl=l(e),ql=d(e,"HR",{}),Sl=l(e),At=d(e,"A",{id:!0,class:!0}),_(At).forEach(r),Kl=l(e),m(Rt.$$.fragment,e),Ol=l(e),Dt=d(e,"P",{"data-svelte-h":!0}),i(Dt)!=="svelte-62dsf9"&&(Dt.innerHTML=Li),ea=l(e),Ut=d(e,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-11vd43e"&&(Ut.innerHTML=ji),ta=l(e),m(Bt.$$.fragment,e),ra=l(e),Wt=d(e,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-c0cgha"&&(Wt.innerHTML=zi),oa=l(e),m(Nt.$$.fragment,e),sa=l(e),Gt=d(e,"P",{"data-svelte-h":!0}),i(Gt)!=="svelte-wmyz1o"&&(Gt.innerHTML=Ai),la=l(e),aa=d(e,"HR",{}),da=l(e),Yt=d(e,"A",{id:!0,class:!0}),_(Yt).forEach(r),ia=l(e),m(Zt.$$.fragment,e),ca=l(e),Qt=d(e,"P",{"data-svelte-h":!0}),i(Qt)!=="svelte-jwfdp9"&&(Qt.textContent=Ri),pa=l(e),Xt=d(e,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-t85gxq"&&(Xt.innerHTML=Di),ma=l(e),Vt=d(e,"P",{"data-svelte-h":!0}),i(Vt)!=="svelte-y7m8db"&&(Vt.innerHTML=Ui),na=l(e),qt=d(e,"TABLE",{"data-svelte-h":!0}),i(qt)!=="svelte-1oj79mt"&&(qt.innerHTML=Bi),ua=l(e),ha=d(e,"HR",{}),fa=l(e),St=d(e,"A",{id:!0,class:!0}),_(St).forEach(r),_a=l(e),m(Kt.$$.fragment,e),ga=l(e),Ot=d(e,"P",{"data-svelte-h":!0}),i(Ot)!=="svelte-1kf99mp"&&(Ot.innerHTML=Wi),xa=l(e),Ta=d(e,"HR",{}),ba=l(e),er=d(e,"A",{id:!0,class:!0}),_(er).forEach(r),va=l(e),m(tr.$$.fragment,e),ya=l(e),rr=d(e,"P",{"data-svelte-h":!0}),i(rr)!=="svelte-kjzox5"&&(rr.textContent=Ni),$a=l(e),or=d(e,"P",{"data-svelte-h":!0}),i(or)!=="svelte-19qboln"&&(or.innerHTML=Gi),Ma=l(e),sr=d(e,"TABLE",{"data-svelte-h":!0}),i(sr)!=="svelte-1bv5sxq"&&(sr.innerHTML=Yi),wa=l(e),Ea=d(e,"HR",{}),Ca=l(e),lr=d(e,"A",{id:!0,class:!0}),_(lr).forEach(r),Pa=l(e),m(ar.$$.fragment,e),Ha=l(e),dr=d(e,"P",{"data-svelte-h":!0}),i(dr)!=="svelte-vlkbp"&&(dr.textContent=Zi),Ja=l(e),ir=d(e,"P",{"data-svelte-h":!0}),i(ir)!=="svelte-vmdbik"&&(ir.innerHTML=Qi),Ia=l(e),cr=d(e,"TABLE",{"data-svelte-h":!0}),i(cr)!=="svelte-4ldb45"&&(cr.innerHTML=Xi),Fa=l(e),ka=d(e,"HR",{}),La=l(e),pr=d(e,"A",{id:!0,class:!0}),_(pr).forEach(r),ja=l(e),m(mr.$$.fragment,e),za=l(e),nr=d(e,"P",{"data-svelte-h":!0}),i(nr)!=="svelte-2u8xbp"&&(nr.textContent=Vi),Aa=l(e),ur=d(e,"P",{"data-svelte-h":!0}),i(ur)!=="svelte-3xndnt"&&(ur.innerHTML=qi),Ra=l(e),Da=d(e,"HR",{}),Ua=l(e),hr=d(e,"A",{id:!0,class:!0}),_(hr).forEach(r),Ba=l(e),m(fr.$$.fragment,e),Wa=l(e),_r=d(e,"P",{"data-svelte-h":!0}),i(_r)!=="svelte-cy5pwv"&&(_r.innerHTML=Si),Na=l(e),gr=d(e,"TABLE",{"data-svelte-h":!0}),i(gr)!=="svelte-1dyar84"&&(gr.innerHTML=Ki),Ga=l(e),Ya=d(e,"HR",{}),Za=l(e),xr=d(e,"A",{id:!0,class:!0}),_(xr).forEach(r),Qa=l(e),m(Tr.$$.fragment,e),Xa=l(e),br=d(e,"P",{"data-svelte-h":!0}),i(br)!=="svelte-cy5pwv"&&(br.innerHTML=Oi),Va=l(e),vr=d(e,"TABLE",{"data-svelte-h":!0}),i(vr)!=="svelte-1cnys15"&&(vr.innerHTML=ec),qa=l(e),Sa=d(e,"HR",{}),Ka=l(e),yr=d(e,"A",{id:!0,class:!0}),_(yr).forEach(r),Oa=l(e),m($r.$$.fragment,e),ed=l(e),Mr=d(e,"P",{"data-svelte-h":!0}),i(Mr)!=="svelte-cy5pwv"&&(Mr.innerHTML=tc),td=l(e),wr=d(e,"TABLE",{"data-svelte-h":!0}),i(wr)!=="svelte-179cln2"&&(wr.innerHTML=rc),rd=l(e),od=d(e,"HR",{}),sd=l(e),Er=d(e,"A",{id:!0,class:!0}),_(Er).forEach(r),ld=l(e),m(Cr.$$.fragment,e),ad=l(e),Pr=d(e,"P",{"data-svelte-h":!0}),i(Pr)!=="svelte-cy5pwv"&&(Pr.innerHTML=oc),dd=l(e),Hr=d(e,"TABLE",{"data-svelte-h":!0}),i(Hr)!=="svelte-1nrm9i3"&&(Hr.innerHTML=sc),id=l(e),cd=d(e,"HR",{}),pd=l(e),m(Jr.$$.fragment,e),md=l(e),Fr=d(e,"P",{}),_(Fr).forEach(r),this.h()},h(){c(x,"name","hf:doc:metadata"),c(x,"content",hc),c(T,"id","module_processors"),c(T,"class","group"),c(w,"id","module_processors.FeatureExtractor"),c(w,"class","group"),c(J,"id","new_module_processors.FeatureExtractor_new"),c(J,"class","group"),c(L,"id","Callable+_call"),c(L,"class","group"),c(U,"id","module_processors.ImageFeatureExtractor"),c(U,"class","group"),c(Y,"id","new_module_processors.ImageFeatureExtractor_new"),c(Y,"class","group"),c(V,"id","module_processors.ImageFeatureExtractor+thumbnail"),c(V,"class","group"),c(ee,"id","module_processors.ImageFeatureExtractor+crop_margin"),c(ee,"class","group"),c(le,"id","module_processors.ImageFeatureExtractor+pad_image"),c(le,"class","group"),c(pe,"id","module_processors.ImageFeatureExtractor+rescale"),c(pe,"class","group"),c(fe,"id","module_processors.ImageFeatureExtractor+get_resize_output_image_size"),c(fe,"class","group"),c(be,"id","module_processors.ImageFeatureExtractor+resize"),c(be,"class","group"),c(we,"id","module_processors.ImageFeatureExtractor+preprocess"),c(we,"class","group"),c(Je,"id","module_processors.ImageFeatureExtractor+_call"),c(Je,"class","group"),c(je,"id","module_processors.DetrFeatureExtractor"),c(je,"class","group"),c(Ue,"id","module_processors.DetrFeatureExtractor+_call"),c(Ue,"class","group"),c(Ye,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),c(Ye,"class","group"),c(Xe,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),c(Xe,"class","group"),c(Oe,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),c(Oe,"class","group"),c(st,"id","module_processors.DetrFeatureExtractor+compute_segments"),c(st,"class","group"),c(ct,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),c(ct,"class","group"),c(ht,"id","module_processors.Processor"),c(ht,"class","group"),c(Tt,"id","new_module_processors.Processor_new"),c(Tt,"class","group"),c($t,"id","module_processors.Processor+_call"),c($t,"class","group"),c(Pt,"id","module_processors.WhisperProcessor"),c(Pt,"class","group"),c(Ft,"id","module_processors.WhisperProcessor+_call"),c(Ft,"class","group"),c(At,"id","module_processors.AutoProcessor"),c(At,"class","group"),c(Yt,"id","module_processors.AutoProcessor.from_pretrained"),c(Yt,"class","group"),c(St,"id","module_processors.data"),c(St,"class","group"),c(er,"id","module_processors..center_to_corners_format"),c(er,"class","group"),c(lr,"id","module_processors..enforce_size_divisibility"),c(lr,"class","group"),c(pr,"id","module_processors..HeightWidth"),c(pr,"class","group"),c(hr,"id","module_processors..ImageFeatureExtractorResult"),c(hr,"class","group"),c(xr,"id","module_processors..PreprocessedImage"),c(xr,"class","group"),c(yr,"id","module_processors..DetrFeatureExtractorResult"),c(yr,"class","group"),c(Er,"id","module_processors..SamImageProcessorResult"),c(Er,"class","group")},m(e,t){mc(document.head,x),o(e,kr,t),o(e,Ir,t),o(e,Lr,t),o(e,T,t),o(e,jr,t),n(b,e,t),o(e,zr,t),o(e,v,t),o(e,Ar,t),o(e,y,t),o(e,Rr,t),n($,e,t),o(e,Dr,t),o(e,M,t),o(e,Ur,t),o(e,Br,t),o(e,Wr,t),o(e,w,t),o(e,Nr,t),n(E,e,t),o(e,Gr,t),o(e,C,t),o(e,Yr,t),o(e,P,t),o(e,Zr,t),o(e,H,t),o(e,Qr,t),o(e,Xr,t),o(e,Vr,t),o(e,J,t),o(e,qr,t),n(I,e,t),o(e,Sr,t),o(e,F,t),o(e,Kr,t),o(e,k,t),o(e,Or,t),o(e,eo,t),o(e,to,t),o(e,L,t),o(e,ro,t),n(j,e,t),o(e,oo,t),o(e,z,t),o(e,so,t),o(e,A,t),o(e,lo,t),o(e,R,t),o(e,ao,t),o(e,D,t),o(e,io,t),o(e,co,t),o(e,po,t),o(e,U,t),o(e,mo,t),n(B,e,t),o(e,no,t),o(e,W,t),o(e,uo,t),o(e,N,t),o(e,ho,t),o(e,G,t),o(e,fo,t),o(e,_o,t),o(e,go,t),o(e,Y,t),o(e,xo,t),n(Z,e,t),o(e,To,t),o(e,Q,t),o(e,bo,t),o(e,X,t),o(e,vo,t),o(e,yo,t),o(e,$o,t),o(e,V,t),o(e,Mo,t),n(q,e,t),o(e,wo,t),o(e,S,t),o(e,Eo,t),o(e,K,t),o(e,Co,t),o(e,O,t),o(e,Po,t),o(e,Ho,t),o(e,Jo,t),o(e,ee,t),o(e,Io,t),n(te,e,t),o(e,Fo,t),o(e,re,t),o(e,ko,t),o(e,oe,t),o(e,Lo,t),o(e,se,t),o(e,jo,t),o(e,zo,t),o(e,Ao,t),o(e,le,t),o(e,Ro,t),n(ae,e,t),o(e,Do,t),o(e,de,t),o(e,Uo,t),o(e,ie,t),o(e,Bo,t),o(e,ce,t),o(e,Wo,t),o(e,No,t),o(e,Go,t),o(e,pe,t),o(e,Yo,t),n(me,e,t),o(e,Zo,t),o(e,ne,t),o(e,Qo,t),o(e,ue,t),o(e,Xo,t),o(e,he,t),o(e,Vo,t),o(e,qo,t),o(e,So,t),o(e,fe,t),o(e,Ko,t),n(_e,e,t),o(e,Oo,t),o(e,ge,t),o(e,es,t),o(e,xe,t),o(e,ts,t),o(e,Te,t),o(e,rs,t),o(e,os,t),o(e,ss,t),o(e,be,t),o(e,ls,t),n(ve,e,t),o(e,as,t),o(e,ye,t),o(e,ds,t),o(e,$e,t),o(e,is,t),o(e,Me,t),o(e,cs,t),o(e,ps,t),o(e,ms,t),o(e,we,t),o(e,ns,t),n(Ee,e,t),o(e,us,t),o(e,Ce,t),o(e,hs,t),o(e,Pe,t),o(e,fs,t),o(e,He,t),o(e,_s,t),o(e,gs,t),o(e,xs,t),o(e,Je,t),o(e,Ts,t),n(Ie,e,t),o(e,bs,t),o(e,Fe,t),o(e,vs,t),o(e,ke,t),o(e,ys,t),o(e,Le,t),o(e,$s,t),o(e,Ms,t),o(e,ws,t),o(e,je,t),o(e,Es,t),n(ze,e,t),o(e,Cs,t),o(e,Ae,t),o(e,Ps,t),o(e,Re,t),o(e,Hs,t),o(e,De,t),o(e,Js,t),o(e,Is,t),o(e,Fs,t),o(e,Ue,t),o(e,ks,t),n(Be,e,t),o(e,Ls,t),o(e,We,t),o(e,js,t),o(e,Ne,t),o(e,zs,t),o(e,Ge,t),o(e,As,t),o(e,Rs,t),o(e,Ds,t),o(e,Ye,t),o(e,Us,t),n(Ze,e,t),o(e,Bs,t),o(e,Qe,t),o(e,Ws,t),o(e,Ns,t),o(e,Gs,t),o(e,Xe,t),o(e,Ys,t),n(Ve,e,t),o(e,Zs,t),o(e,qe,t),o(e,Qs,t),o(e,Se,t),o(e,Xs,t),o(e,Ke,t),o(e,Vs,t),o(e,qs,t),o(e,Ss,t),o(e,Oe,t),o(e,Ks,t),n(et,e,t),o(e,Os,t),o(e,tt,t),o(e,el,t),o(e,rt,t),o(e,tl,t),o(e,ot,t),o(e,rl,t),o(e,ol,t),o(e,sl,t),o(e,st,t),o(e,ll,t),n(lt,e,t),o(e,al,t),o(e,at,t),o(e,dl,t),o(e,dt,t),o(e,il,t),o(e,it,t),o(e,cl,t),o(e,pl,t),o(e,ml,t),o(e,ct,t),o(e,nl,t),n(pt,e,t),o(e,ul,t),o(e,mt,t),o(e,hl,t),o(e,nt,t),o(e,fl,t),o(e,ut,t),o(e,_l,t),o(e,gl,t),o(e,xl,t),o(e,ht,t),o(e,Tl,t),n(ft,e,t),o(e,bl,t),o(e,_t,t),o(e,vl,t),o(e,gt,t),o(e,yl,t),o(e,xt,t),o(e,$l,t),o(e,Ml,t),o(e,wl,t),o(e,Tt,t),o(e,El,t),n(bt,e,t),o(e,Cl,t),o(e,vt,t),o(e,Pl,t),o(e,yt,t),o(e,Hl,t),o(e,Jl,t),o(e,Il,t),o(e,$t,t),o(e,Fl,t),n(Mt,e,t),o(e,kl,t),o(e,wt,t),o(e,Ll,t),o(e,Et,t),o(e,jl,t),o(e,Ct,t),o(e,zl,t),o(e,Al,t),o(e,Rl,t),o(e,Pt,t),o(e,Dl,t),n(Ht,e,t),o(e,Ul,t),o(e,Jt,t),o(e,Bl,t),o(e,It,t),o(e,Wl,t),o(e,Nl,t),o(e,Gl,t),o(e,Ft,t),o(e,Yl,t),n(kt,e,t),o(e,Zl,t),o(e,Lt,t),o(e,Ql,t),o(e,jt,t),o(e,Xl,t),o(e,zt,t),o(e,Vl,t),o(e,ql,t),o(e,Sl,t),o(e,At,t),o(e,Kl,t),n(Rt,e,t),o(e,Ol,t),o(e,Dt,t),o(e,ea,t),o(e,Ut,t),o(e,ta,t),n(Bt,e,t),o(e,ra,t),o(e,Wt,t),o(e,oa,t),n(Nt,e,t),o(e,sa,t),o(e,Gt,t),o(e,la,t),o(e,aa,t),o(e,da,t),o(e,Yt,t),o(e,ia,t),n(Zt,e,t),o(e,ca,t),o(e,Qt,t),o(e,pa,t),o(e,Xt,t),o(e,ma,t),o(e,Vt,t),o(e,na,t),o(e,qt,t),o(e,ua,t),o(e,ha,t),o(e,fa,t),o(e,St,t),o(e,_a,t),n(Kt,e,t),o(e,ga,t),o(e,Ot,t),o(e,xa,t),o(e,Ta,t),o(e,ba,t),o(e,er,t),o(e,va,t),n(tr,e,t),o(e,ya,t),o(e,rr,t),o(e,$a,t),o(e,or,t),o(e,Ma,t),o(e,sr,t),o(e,wa,t),o(e,Ea,t),o(e,Ca,t),o(e,lr,t),o(e,Pa,t),n(ar,e,t),o(e,Ha,t),o(e,dr,t),o(e,Ja,t),o(e,ir,t),o(e,Ia,t),o(e,cr,t),o(e,Fa,t),o(e,ka,t),o(e,La,t),o(e,pr,t),o(e,ja,t),n(mr,e,t),o(e,za,t),o(e,nr,t),o(e,Aa,t),o(e,ur,t),o(e,Ra,t),o(e,Da,t),o(e,Ua,t),o(e,hr,t),o(e,Ba,t),n(fr,e,t),o(e,Wa,t),o(e,_r,t),o(e,Na,t),o(e,gr,t),o(e,Ga,t),o(e,Ya,t),o(e,Za,t),o(e,xr,t),o(e,Qa,t),n(Tr,e,t),o(e,Xa,t),o(e,br,t),o(e,Va,t),o(e,vr,t),o(e,qa,t),o(e,Sa,t),o(e,Ka,t),o(e,yr,t),o(e,Oa,t),n($r,e,t),o(e,ed,t),o(e,Mr,t),o(e,td,t),o(e,wr,t),o(e,rd,t),o(e,od,t),o(e,sd,t),o(e,Er,t),o(e,ld,t),n(Cr,e,t),o(e,ad,t),o(e,Pr,t),o(e,dd,t),o(e,Hr,t),o(e,id,t),o(e,cd,t),o(e,pd,t),n(Jr,e,t),o(e,md,t),o(e,Fr,t),nd=!0},p:ac,i(e){nd||(u(b.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(I.$$.fragment,e),u(j.$$.fragment,e),u(B.$$.fragment,e),u(Z.$$.fragment,e),u(q.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(me.$$.fragment,e),u(_e.$$.fragment,e),u(ve.$$.fragment,e),u(Ee.$$.fragment,e),u(Ie.$$.fragment,e),u(ze.$$.fragment,e),u(Be.$$.fragment,e),u(Ze.$$.fragment,e),u(Ve.$$.fragment,e),u(et.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(ft.$$.fragment,e),u(bt.$$.fragment,e),u(Mt.$$.fragment,e),u(Ht.$$.fragment,e),u(kt.$$.fragment,e),u(Rt.$$.fragment,e),u(Bt.$$.fragment,e),u(Nt.$$.fragment,e),u(Zt.$$.fragment,e),u(Kt.$$.fragment,e),u(tr.$$.fragment,e),u(ar.$$.fragment,e),u(mr.$$.fragment,e),u(fr.$$.fragment,e),u(Tr.$$.fragment,e),u($r.$$.fragment,e),u(Cr.$$.fragment,e),u(Jr.$$.fragment,e),nd=!0)},o(e){h(b.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(I.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(q.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(me.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(Ee.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Be.$$.fragment,e),h(Ze.$$.fragment,e),h(Ve.$$.fragment,e),h(et.$$.fragment,e),h(lt.$$.fragment,e),h(pt.$$.fragment,e),h(ft.$$.fragment,e),h(bt.$$.fragment,e),h(Mt.$$.fragment,e),h(Ht.$$.fragment,e),h(kt.$$.fragment,e),h(Rt.$$.fragment,e),h(Bt.$$.fragment,e),h(Nt.$$.fragment,e),h(Zt.$$.fragment,e),h(Kt.$$.fragment,e),h(tr.$$.fragment,e),h(ar.$$.fragment,e),h(mr.$$.fragment,e),h(fr.$$.fragment,e),h(Tr.$$.fragment,e),h($r.$$.fragment,e),h(Cr.$$.fragment,e),h(Jr.$$.fragment,e),nd=!1},d(e){e&&(r(kr),r(Ir),r(Lr),r(T),r(jr),r(zr),r(v),r(Ar),r(y),r(Rr),r(Dr),r(M),r(Ur),r(Br),r(Wr),r(w),r(Nr),r(Gr),r(C),r(Yr),r(P),r(Zr),r(H),r(Qr),r(Xr),r(Vr),r(J),r(qr),r(Sr),r(F),r(Kr),r(k),r(Or),r(eo),r(to),r(L),r(ro),r(oo),r(z),r(so),r(A),r(lo),r(R),r(ao),r(D),r(io),r(co),r(po),r(U),r(mo),r(no),r(W),r(uo),r(N),r(ho),r(G),r(fo),r(_o),r(go),r(Y),r(xo),r(To),r(Q),r(bo),r(X),r(vo),r(yo),r($o),r(V),r(Mo),r(wo),r(S),r(Eo),r(K),r(Co),r(O),r(Po),r(Ho),r(Jo),r(ee),r(Io),r(Fo),r(re),r(ko),r(oe),r(Lo),r(se),r(jo),r(zo),r(Ao),r(le),r(Ro),r(Do),r(de),r(Uo),r(ie),r(Bo),r(ce),r(Wo),r(No),r(Go),r(pe),r(Yo),r(Zo),r(ne),r(Qo),r(ue),r(Xo),r(he),r(Vo),r(qo),r(So),r(fe),r(Ko),r(Oo),r(ge),r(es),r(xe),r(ts),r(Te),r(rs),r(os),r(ss),r(be),r(ls),r(as),r(ye),r(ds),r($e),r(is),r(Me),r(cs),r(ps),r(ms),r(we),r(ns),r(us),r(Ce),r(hs),r(Pe),r(fs),r(He),r(_s),r(gs),r(xs),r(Je),r(Ts),r(bs),r(Fe),r(vs),r(ke),r(ys),r(Le),r($s),r(Ms),r(ws),r(je),r(Es),r(Cs),r(Ae),r(Ps),r(Re),r(Hs),r(De),r(Js),r(Is),r(Fs),r(Ue),r(ks),r(Ls),r(We),r(js),r(Ne),r(zs),r(Ge),r(As),r(Rs),r(Ds),r(Ye),r(Us),r(Bs),r(Qe),r(Ws),r(Ns),r(Gs),r(Xe),r(Ys),r(Zs),r(qe),r(Qs),r(Se),r(Xs),r(Ke),r(Vs),r(qs),r(Ss),r(Oe),r(Ks),r(Os),r(tt),r(el),r(rt),r(tl),r(ot),r(rl),r(ol),r(sl),r(st),r(ll),r(al),r(at),r(dl),r(dt),r(il),r(it),r(cl),r(pl),r(ml),r(ct),r(nl),r(ul),r(mt),r(hl),r(nt),r(fl),r(ut),r(_l),r(gl),r(xl),r(ht),r(Tl),r(bl),r(_t),r(vl),r(gt),r(yl),r(xt),r($l),r(Ml),r(wl),r(Tt),r(El),r(Cl),r(vt),r(Pl),r(yt),r(Hl),r(Jl),r(Il),r($t),r(Fl),r(kl),r(wt),r(Ll),r(Et),r(jl),r(Ct),r(zl),r(Al),r(Rl),r(Pt),r(Dl),r(Ul),r(Jt),r(Bl),r(It),r(Wl),r(Nl),r(Gl),r(Ft),r(Yl),r(Zl),r(Lt),r(Ql),r(jt),r(Xl),r(zt),r(Vl),r(ql),r(Sl),r(At),r(Kl),r(Ol),r(Dt),r(ea),r(Ut),r(ta),r(ra),r(Wt),r(oa),r(sa),r(Gt),r(la),r(aa),r(da),r(Yt),r(ia),r(ca),r(Qt),r(pa),r(Xt),r(ma),r(Vt),r(na),r(qt),r(ua),r(ha),r(fa),r(St),r(_a),r(ga),r(Ot),r(xa),r(Ta),r(ba),r(er),r(va),r(ya),r(rr),r($a),r(or),r(Ma),r(sr),r(wa),r(Ea),r(Ca),r(lr),r(Pa),r(Ha),r(dr),r(Ja),r(ir),r(Ia),r(cr),r(Fa),r(ka),r(La),r(pr),r(ja),r(za),r(nr),r(Aa),r(ur),r(Ra),r(Da),r(Ua),r(hr),r(Ba),r(Wa),r(_r),r(Na),r(gr),r(Ga),r(Ya),r(Za),r(xr),r(Qa),r(Xa),r(br),r(Va),r(vr),r(qa),r(Sa),r(Ka),r(yr),r(Oa),r(ed),r(Mr),r(td),r(wr),r(rd),r(od),r(sd),r(Er),r(ld),r(ad),r(Pr),r(dd),r(Hr),r(id),r(cd),r(pd),r(md),r(Fr)),r(x),f(b,e),f($,e),f(E,e),f(I,e),f(j,e),f(B,e),f(Z,e),f(q,e),f(te,e),f(ae,e),f(me,e),f(_e,e),f(ve,e),f(Ee,e),f(Ie,e),f(ze,e),f(Be,e),f(Ze,e),f(Ve,e),f(et,e),f(lt,e),f(pt,e),f(ft,e),f(bt,e),f(Mt,e),f(Ht,e),f(kt,e),f(Rt,e),f(Bt,e),f(Nt,e),f(Zt,e),f(Kt,e),f(tr,e),f(ar,e),f(mr,e),f(fr,e),f(Tr,e),f($r,e),f(Cr,e),f(Jr,e)}}}const hc='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3},{"title":"featureExtractor._call(...args)","local":"featureextractorcallargs","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>","local":"imagefeatureextractorrescalepixeldata--code-void-code","sections":[],"depth":3},{"title":"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>","local":"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorresizeimage--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors.data : <code> Float32Array </code>","local":"processorsdata--code-float32array-code","sections":[],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>","local":"processorsenforcesizedivisibilitysize-divisor--code--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function fc(hd){return dc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bc extends ic{constructor(x){super(),cc(this,x,fc,uc,lc,{})}}export{bc as component};
