import{s as ct,n as ut,o as dt}from"../chunks/scheduler.7da89386.js";import{S as yt,i as ft,g as i,s,r as o,A as ht,h as p,f as l,c as n,j as rt,x as r,u as M,k as Mt,y as bt,a,v as c,d as u,t as d,w as y}from"../chunks/index.0b7befd3.js";import{C as tt}from"../chunks/CodeBlock.ce33a881.js";import{H as R}from"../chunks/Heading.8a936589.js";function wt(et){let m,_,$,k,f,lt='<a href="https://github.com/Xilinx/brevitas" rel="nofollow">Brevitas</a> is an AMD library for neural network quantization. 🤗 Optimum-AMD integrates with Brevitas so as to make it easier to quantize <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> models through Brevitas.',F,h,at="This integration also allows to export models quantized through Brevitas to ONNX.",x,b,st='For a refresher on quantization, please have a look at <a href="https://huggingface.co/docs/optimum/concept_guides/quantization" rel="nofollow">this documentation</a>.',I,w,nt='Please refer to <a href="/docs/optimum.amd/pr_150/en/brevitas/api_reference#optimum.amd.BrevitasQuantizer">~BrevitasQuantizer</a> and <a href="/docs/optimum.amd/pr_150/en/brevitas/api_reference#optimum.amd.BrevitasQuantizationConfig">~BrevitasQuantizationConfig</a> for all available options.',q,j,Q,J,it="Currently, only the following architectures are tested and supported:",Y,T,pt="<li>Llama</li> <li>OPT</li>",H,U,V,B,E,v,N,W,A,g,S,Z,mt="Brevitas models can be exported to ONNX using Optimum:",L,X,P,z,D,C,ot='A complete example is available at <a href="https://github.com/huggingface/optimum-amd/tree/main/examples/quantization/brevitas" rel="nofollow">https://github.com/huggingface/optimum-amd/tree/main/examples/quantization/brevitas</a>.',O,G,K;return j=new R({props:{title:"Supported models",local:"supported-models",headingTag:"h2"}}),U=new R({props:{title:"Dynamic quantization",local:"dynamic-quantization",headingTag:"h2"}}),B=new tt({props:{code:"ZnJvbSUyMG9wdGltdW0uYW1kJTIwaW1wb3J0JTIwQnJldml0YXNRdWFudGl6YXRpb25Db25maWclMkMlMjBCcmV2aXRhc1F1YW50aXplciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBJTIzJTIwUHJlcGFyZSUyMHRoZSUyMHF1YW50aXplciUyQyUyMHNwZWNpZnlpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTIwYW5kJTIwbG9hZGluZyUyMHRoZSUyMG1vZGVsLiUwQXFjb25maWclMjAlM0QlMjBCcmV2aXRhc1F1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBpc19zdGF0aWMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGFwcGx5X2dwdHElM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGFwcGx5X3dlaWdodF9lcXVhbGl6YXRpb24lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGFjdGl2YXRpb25zX2VxdWFsaXphdGlvbiUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0c19zeW1tZXRyaWMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYWN0aXZhdGlvbnNfc3ltbWV0cmljJTNERmFsc2UlMkMlMEEpJTBBJTBBcXVhbnRpemVyJTIwJTNEJTIwQnJldml0YXNRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBxdWFudGl6ZXIucXVhbnRpemUocWNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> optimum.amd <span class="hljs-keyword">import</span> BrevitasQuantizationConfig, BrevitasQuantizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Prepare the quantizer, specifying its configuration and loading the model.</span>
qconfig = BrevitasQuantizationConfig(
    is_static=<span class="hljs-literal">False</span>,
    apply_gptq=<span class="hljs-literal">False</span>,
    apply_weight_equalization=<span class="hljs-literal">False</span>,
    activations_equalization=<span class="hljs-literal">False</span>,
    weights_symmetric=<span class="hljs-literal">True</span>,
    activations_symmetric=<span class="hljs-literal">False</span>,
)

quantizer = BrevitasQuantizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)

model = quantizer.quantize(qconfig)`,wrap:!1}}),v=new R({props:{title:"Static quantization",local:"static-quantization",headingTag:"h2"}}),W=new tt({props:{code:"ZnJvbSUyMG9wdGltdW0uYW1kJTIwaW1wb3J0JTIwQnJldml0YXNRdWFudGl6YXRpb25Db25maWclMkMlMjBCcmV2aXRhc1F1YW50aXplciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBJTIzJTIwUHJlcGFyZSUyMHRoZSUyMHF1YW50aXplciUyQyUyMHNwZWNpZnlpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTIwYW5kJTIwbG9hZGluZyUyMHRoZSUyMG1vZGVsLiUwQXFjb25maWclMjAlM0QlMjBCcmV2aXRhc1F1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBpc19zdGF0aWMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXBwbHlfZ3B0cSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYXBwbHlfd2VpZ2h0X2VxdWFsaXphdGlvbiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBhY3RpdmF0aW9uc19lcXVhbGl6YXRpb24lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodHNfc3ltbWV0cmljJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGFjdGl2YXRpb25zX3N5bW1ldHJpYyUzREZhbHNlJTJDJTBBKSUwQSUwQXF1YW50aXplciUyMCUzRCUyMEJyZXZpdGFzUXVhbnRpemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIpJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMGRhdGElMjBmb3IlMjBjYWxpYnJhdGlvbiUyMGFuZCUyMGV2YWx1YXRpb24uJTBBY2FsaWJyYXRpb25fZGF0YXNldCUyMCUzRCUyMGdldF9kYXRhc2V0X2Zvcl9tb2RlbCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwcWNvbmZpZyUzRHFjb25maWclMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0QlMjJ3aWtpdGV4dDIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBuc2FtcGxlcyUzRDEyOCUyQyUwQSUyMCUyMCUyMCUyMHNlcWxlbiUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBxdWFudGl6ZXIucXVhbnRpemUocWNvbmZpZyUyQyUyMGNhbGlicmF0aW9uX2RhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> optimum.amd <span class="hljs-keyword">import</span> BrevitasQuantizationConfig, BrevitasQuantizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Prepare the quantizer, specifying its configuration and loading the model.</span>
qconfig = BrevitasQuantizationConfig(
    is_static=<span class="hljs-literal">True</span>,
    apply_gptq=<span class="hljs-literal">False</span>,
    apply_weight_equalization=<span class="hljs-literal">True</span>,
    activations_equalization=<span class="hljs-literal">False</span>,
    weights_symmetric=<span class="hljs-literal">True</span>,
    activations_symmetric=<span class="hljs-literal">False</span>,
)

quantizer = BrevitasQuantizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)

<span class="hljs-comment"># Load the data for calibration and evaluation.</span>
calibration_dataset = get_dataset_for_model(
    <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>,
    qconfig=qconfig,
    dataset_name=<span class="hljs-string">&quot;wikitext2&quot;</span>,
    tokenizer=tokenizer,
    nsamples=<span class="hljs-number">128</span>,
    seqlen=<span class="hljs-number">512</span>,
    split=<span class="hljs-string">&quot;train&quot;</span>,
)

model = quantizer.quantize(qconfig, calibration_dataset)`,wrap:!1}}),g=new R({props:{title:"Export Brevitas models to ONNX",local:"export-brevitas-models-to-onnx",headingTag:"h2"}}),X=new tt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5hbWQuYnJldml0YXMuZXhwb3J0JTIwaW1wb3J0JTIwb25ueF9leHBvcnRfZnJvbV9xdWFudGl6ZWRfbW9kZWwlMEElMEElMjMlMjBFeHBvcnQlMjB0byUyME9OTlglMjB0aHJvdWdoJTIwb3B0aW11bS5leHBvcnRlcnMuJTBBb25ueF9leHBvcnRfZnJvbV9xdWFudGl6ZWRfbW9kZWwobW9kZWwlMkMlMjAlMjJsbG1fcXVhbnRpemVkX29ubnglMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> optimum.amd.brevitas.export <span class="hljs-keyword">import</span> onnx_export_from_quantized_model

<span class="hljs-comment"># Export to ONNX through optimum.exporters.</span>
onnx_export_from_quantized_model(model, <span class="hljs-string">&quot;llm_quantized_onnx&quot;</span>)`,wrap:!1}}),z=new R({props:{title:"Complete example",local:"complete-example",headingTag:"h2"}}),{c(){m=i("meta"),_=s(),$=i("p"),k=s(),f=i("p"),f.innerHTML=lt,F=s(),h=i("p"),h.textContent=at,x=s(),b=i("p"),b.innerHTML=st,I=s(),w=i("p"),w.innerHTML=nt,q=s(),o(j.$$.fragment),Q=s(),J=i("p"),J.textContent=it,Y=s(),T=i("ul"),T.innerHTML=pt,H=s(),o(U.$$.fragment),V=s(),o(B.$$.fragment),E=s(),o(v.$$.fragment),N=s(),o(W.$$.fragment),A=s(),o(g.$$.fragment),S=s(),Z=i("p"),Z.textContent=mt,L=s(),o(X.$$.fragment),P=s(),o(z.$$.fragment),D=s(),C=i("p"),C.innerHTML=ot,O=s(),G=i("p"),this.h()},l(t){const e=ht("svelte-u9bgzb",document.head);m=p(e,"META",{name:!0,content:!0}),e.forEach(l),_=n(t),$=p(t,"P",{}),rt($).forEach(l),k=n(t),f=p(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-8zves6"&&(f.innerHTML=lt),F=n(t),h=p(t,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1n6klb2"&&(h.textContent=at),x=n(t),b=p(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1td8cv2"&&(b.innerHTML=st),I=n(t),w=p(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1ie73pd"&&(w.innerHTML=nt),q=n(t),M(j.$$.fragment,t),Q=n(t),J=p(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-15kp7je"&&(J.textContent=it),Y=n(t),T=p(t,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-1k4c4m8"&&(T.innerHTML=pt),H=n(t),M(U.$$.fragment,t),V=n(t),M(B.$$.fragment,t),E=n(t),M(v.$$.fragment,t),N=n(t),M(W.$$.fragment,t),A=n(t),M(g.$$.fragment,t),S=n(t),Z=p(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-122it0h"&&(Z.textContent=mt),L=n(t),M(X.$$.fragment,t),P=n(t),M(z.$$.fragment,t),D=n(t),C=p(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1ets5tt"&&(C.innerHTML=ot),O=n(t),G=p(t,"P",{}),rt(G).forEach(l),this.h()},h(){Mt(m,"name","hf:doc:metadata"),Mt(m,"content",jt)},m(t,e){bt(document.head,m),a(t,_,e),a(t,$,e),a(t,k,e),a(t,f,e),a(t,F,e),a(t,h,e),a(t,x,e),a(t,b,e),a(t,I,e),a(t,w,e),a(t,q,e),c(j,t,e),a(t,Q,e),a(t,J,e),a(t,Y,e),a(t,T,e),a(t,H,e),c(U,t,e),a(t,V,e),c(B,t,e),a(t,E,e),c(v,t,e),a(t,N,e),c(W,t,e),a(t,A,e),c(g,t,e),a(t,S,e),a(t,Z,e),a(t,L,e),c(X,t,e),a(t,P,e),c(z,t,e),a(t,D,e),a(t,C,e),a(t,O,e),a(t,G,e),K=!0},p:ut,i(t){K||(u(j.$$.fragment,t),u(U.$$.fragment,t),u(B.$$.fragment,t),u(v.$$.fragment,t),u(W.$$.fragment,t),u(g.$$.fragment,t),u(X.$$.fragment,t),u(z.$$.fragment,t),K=!0)},o(t){d(j.$$.fragment,t),d(U.$$.fragment,t),d(B.$$.fragment,t),d(v.$$.fragment,t),d(W.$$.fragment,t),d(g.$$.fragment,t),d(X.$$.fragment,t),d(z.$$.fragment,t),K=!1},d(t){t&&(l(_),l($),l(k),l(f),l(F),l(h),l(x),l(b),l(I),l(w),l(q),l(Q),l(J),l(Y),l(T),l(H),l(V),l(E),l(N),l(A),l(S),l(Z),l(L),l(P),l(D),l(C),l(O),l(G)),l(m),y(j,t),y(U,t),y(B,t),y(v,t),y(W,t),y(g,t),y(X,t),y(z,t)}}}const jt='{"title":"Supported models","local":"supported-models","sections":[],"depth":2}';function Jt(et){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends yt{constructor(m){super(),ft(this,m,Jt,wt,ct,{})}}export{Wt as component};
