import{s as wt,n as Tt,o as mt}from"../chunks/scheduler.f6319a2a.js";import{S as bt,i as ht,g as M,s as n,r as p,A as dt,h as o,f as s,c as a,j as Ut,u as y,x as i,k as Jt,y as It,a as e,v as u,d as r,t as c,w as j}from"../chunks/index.85aa684c.js";import{C as U}from"../chunks/CodeBlock.97b48fd2.js";import{D as Ct}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as Hl,E as gt}from"../chunks/EditOnGithub.006048dd.js";function Bt(Xl){let J,el,tl,nl,w,al,T,Ml,m,Yl="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>smolagents</code>.",ol,b,Ll="<p>Let’s start with the golden question: why not keep it simple and use a standard text-to-SQL pipeline?</p>",il,h,Fl="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",pl,d,zl="👉 Instead, an agent system is able to critically inspect outputs and decide if the query needs to be changed or not, thus giving it a huge performance boost.",yl,I,Dl="Let’s build this agent! 💪",ul,C,Kl="Run the line below to install required dependencies:",rl,g,cl,B,Pl=`To call the HF Inference API, you will need a valid token as your environment variable <code>HF_TOKEN</code>.
We use python-dotenv to load it.`,jl,f,Ul,Q,Ol="Then, we setup the SQL environment:",Jl,q,wl,A,Tl,W,lt="Now let’s make our SQL table retrievable by a tool.",ml,v,tt="The tool’s description attribute will be embedded in the LLM’s prompt by the agent system: it gives the LLM information about how to use the tool. This is where we want to describe the SQL table.",bl,Z,hl,k,dl,S,st='Now let’s build our tool. It needs the following: (read <a href="../tutorials/tools">the tool doc</a> for more detail)',Il,R,et="<li>A docstring with an <code>Args:</code> part listing arguments.</li> <li>Type hints on both inputs and output.</li>",Cl,E,gl,N,nt="Now let us create an agent that leverages this tool.",Bl,G,at="We use the <code>CodeAgent</code>, which is smolagents’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",fl,_,Mt="The model is the LLM that powers the agent system. <code>HfApiModel</code> allows you to call LLMs using HF’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API.",Ql,x,ql,V,Al,$,ot="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Wl,H,it="So let’s make a second table recording the names of waiters for each receipt_id!",vl,X,Zl,Y,pt="Since we changed the table, we update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",kl,L,Sl,F,yt='Since this request is a bit harder than the previous one, we’ll switch the LLM engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a>!',Rl,z,El,D,ut="It directly works! The setup was surprisingly simple, wasn’t it?",Nl,K,rt="This example is done! We’ve touched upon these concepts:",Gl,P,ct="<li>Building new tools.</li> <li>Updating a tool’s description.</li> <li>Switching to a stronger LLM helps agent reasoning.</li>",_l,O,jt="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",xl,ll,Vl,sl,$l;return w=new Hl({props:{title:"Text-to-SQL",local:"text-to-sql",headingTag:"h1"}}),T=new Ct({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"}]}}),g=new U({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcHl0aG9uLWRvdGVudiUyMHNxbGFsY2hlbXklMjAtLXVwZ3JhZGUlMjAtcQ==",highlighted:"!pip install smolagents python-dotenv sqlalchemy --upgrade -q",wrap:!1}}),f=new U({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),q=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),A=new Hl({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h3"}}),Z=new U({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`inspector = inspect(engine)
columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),k=new U({props:{code:"Q29sdW1ucyUzQSUwQSUyMCUyMC0lMjByZWNlaXB0X2lkJTNBJTIwSU5URUdFUiUwQSUyMCUyMC0lMjBjdXN0b21lcl9uYW1lJTNBJTIwVkFSQ0hBUigxNiklMEElMjAlMjAtJTIwcHJpY2UlM0ElMjBGTE9BVCUwQSUyMCUyMC0lMjB0aXAlM0ElMjBGTE9BVA==",highlighted:`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT`,wrap:!1}}),E=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),x=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzcWxfZW5naW5lJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RIZkFwaU1vZGVsKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiklMkMlMEEpJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

agent = CodeAgent(
    tools=[sql_engine],
    model=HfApiModel(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>),
)
agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)`,wrap:!1}}),V=new Hl({props:{title:"Level 2: Table joins",local:"level-2-table-joins",headingTag:"h3"}}),X=new U({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),L=new U({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
It can use the following tables:&quot;&quot;&quot;</span>

inspector = inspect(engine)
<span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),z=new U({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREhmQXBpTW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUyQyUwQSklMEElMEFhZ2VudC5ydW4oJTIyV2hpY2glMjB3YWl0ZXIlMjBnb3QlMjBtb3JlJTIwdG90YWwlMjBtb25leSUyMGZyb20lMjB0aXBzJTNGJTIyKQ==",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),ll=new gt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/text_to_sql.md"}}),{c(){J=M("meta"),el=n(),tl=M("p"),nl=n(),p(w.$$.fragment),al=n(),p(T.$$.fragment),Ml=n(),m=M("p"),m.innerHTML=Yl,ol=n(),b=M("blockquote"),b.innerHTML=Ll,il=n(),h=M("p"),h.textContent=Fl,pl=n(),d=M("p"),d.textContent=zl,yl=n(),I=M("p"),I.textContent=Dl,ul=n(),C=M("p"),C.textContent=Kl,rl=n(),p(g.$$.fragment),cl=n(),B=M("p"),B.innerHTML=Pl,jl=n(),p(f.$$.fragment),Ul=n(),Q=M("p"),Q.textContent=Ol,Jl=n(),p(q.$$.fragment),wl=n(),p(A.$$.fragment),Tl=n(),W=M("p"),W.textContent=lt,ml=n(),v=M("p"),v.textContent=tt,bl=n(),p(Z.$$.fragment),hl=n(),p(k.$$.fragment),dl=n(),S=M("p"),S.innerHTML=st,Il=n(),R=M("ul"),R.innerHTML=et,Cl=n(),p(E.$$.fragment),gl=n(),N=M("p"),N.textContent=nt,Bl=n(),G=M("p"),G.innerHTML=at,fl=n(),_=M("p"),_.innerHTML=Mt,Ql=n(),p(x.$$.fragment),ql=n(),p(V.$$.fragment),Al=n(),$=M("p"),$.textContent=ot,Wl=n(),H=M("p"),H.textContent=it,vl=n(),p(X.$$.fragment),Zl=n(),Y=M("p"),Y.innerHTML=pt,kl=n(),p(L.$$.fragment),Sl=n(),F=M("p"),F.innerHTML=yt,Rl=n(),p(z.$$.fragment),El=n(),D=M("p"),D.textContent=ut,Nl=n(),K=M("p"),K.textContent=rt,Gl=n(),P=M("ul"),P.innerHTML=ct,_l=n(),O=M("p"),O.textContent=jt,xl=n(),p(ll.$$.fragment),Vl=n(),sl=M("p"),this.h()},l(l){const t=dt("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(s),el=a(l),tl=o(l,"P",{}),Ut(tl).forEach(s),nl=a(l),y(w.$$.fragment,l),al=a(l),y(T.$$.fragment,l),Ml=a(l),m=o(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1rrh2b0"&&(m.innerHTML=Yl),ol=a(l),b=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(b)!=="svelte-1yhwgse"&&(b.innerHTML=Ll),il=a(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1hw7g6s"&&(h.textContent=Fl),pl=a(l),d=o(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-i6rawm"&&(d.textContent=zl),yl=a(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1tzrwc8"&&(I.textContent=Dl),ul=a(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-16cuoal"&&(C.textContent=Kl),rl=a(l),y(g.$$.fragment,l),cl=a(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1gx6n4r"&&(B.innerHTML=Pl),jl=a(l),y(f.$$.fragment,l),Ul=a(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-64yurm"&&(Q.textContent=Ol),Jl=a(l),y(q.$$.fragment,l),wl=a(l),y(A.$$.fragment,l),Tl=a(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-fdu5cw"&&(W.textContent=lt),ml=a(l),v=o(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-groxlc"&&(v.textContent=tt),bl=a(l),y(Z.$$.fragment,l),hl=a(l),y(k.$$.fragment,l),dl=a(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1snt6vj"&&(S.innerHTML=st),Il=a(l),R=o(l,"UL",{"data-svelte-h":!0}),i(R)!=="svelte-idbd3h"&&(R.innerHTML=et),Cl=a(l),y(E.$$.fragment,l),gl=a(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1t4r7cu"&&(N.textContent=nt),Bl=a(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-sv1k2f"&&(G.innerHTML=at),fl=a(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1krfyi9"&&(_.innerHTML=Mt),Ql=a(l),y(x.$$.fragment,l),ql=a(l),y(V.$$.fragment,l),Al=a(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-nr3fl7"&&($.textContent=ot),Wl=a(l),H=o(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1ru0803"&&(H.textContent=it),vl=a(l),y(X.$$.fragment,l),Zl=a(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-l5upel"&&(Y.innerHTML=pt),kl=a(l),y(L.$$.fragment,l),Sl=a(l),F=o(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1uns4lf"&&(F.innerHTML=yt),Rl=a(l),y(z.$$.fragment,l),El=a(l),D=o(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1umn140"&&(D.textContent=ut),Nl=a(l),K=o(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-13g6phr"&&(K.textContent=rt),Gl=a(l),P=o(l,"UL",{"data-svelte-h":!0}),i(P)!=="svelte-1pz5sot"&&(P.innerHTML=ct),_l=a(l),O=o(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-bt1f1w"&&(O.textContent=jt),xl=a(l),y(ll.$$.fragment,l),Vl=a(l),sl=o(l,"P",{}),Ut(sl).forEach(s),this.h()},h(){Jt(J,"name","hf:doc:metadata"),Jt(J,"content",ft)},m(l,t){It(document.head,J),e(l,el,t),e(l,tl,t),e(l,nl,t),u(w,l,t),e(l,al,t),u(T,l,t),e(l,Ml,t),e(l,m,t),e(l,ol,t),e(l,b,t),e(l,il,t),e(l,h,t),e(l,pl,t),e(l,d,t),e(l,yl,t),e(l,I,t),e(l,ul,t),e(l,C,t),e(l,rl,t),u(g,l,t),e(l,cl,t),e(l,B,t),e(l,jl,t),u(f,l,t),e(l,Ul,t),e(l,Q,t),e(l,Jl,t),u(q,l,t),e(l,wl,t),u(A,l,t),e(l,Tl,t),e(l,W,t),e(l,ml,t),e(l,v,t),e(l,bl,t),u(Z,l,t),e(l,hl,t),u(k,l,t),e(l,dl,t),e(l,S,t),e(l,Il,t),e(l,R,t),e(l,Cl,t),u(E,l,t),e(l,gl,t),e(l,N,t),e(l,Bl,t),e(l,G,t),e(l,fl,t),e(l,_,t),e(l,Ql,t),u(x,l,t),e(l,ql,t),u(V,l,t),e(l,Al,t),e(l,$,t),e(l,Wl,t),e(l,H,t),e(l,vl,t),u(X,l,t),e(l,Zl,t),e(l,Y,t),e(l,kl,t),u(L,l,t),e(l,Sl,t),e(l,F,t),e(l,Rl,t),u(z,l,t),e(l,El,t),e(l,D,t),e(l,Nl,t),e(l,K,t),e(l,Gl,t),e(l,P,t),e(l,_l,t),e(l,O,t),e(l,xl,t),u(ll,l,t),e(l,Vl,t),e(l,sl,t),$l=!0},p:Tt,i(l){$l||(r(w.$$.fragment,l),r(T.$$.fragment,l),r(g.$$.fragment,l),r(f.$$.fragment,l),r(q.$$.fragment,l),r(A.$$.fragment,l),r(Z.$$.fragment,l),r(k.$$.fragment,l),r(E.$$.fragment,l),r(x.$$.fragment,l),r(V.$$.fragment,l),r(X.$$.fragment,l),r(L.$$.fragment,l),r(z.$$.fragment,l),r(ll.$$.fragment,l),$l=!0)},o(l){c(w.$$.fragment,l),c(T.$$.fragment,l),c(g.$$.fragment,l),c(f.$$.fragment,l),c(q.$$.fragment,l),c(A.$$.fragment,l),c(Z.$$.fragment,l),c(k.$$.fragment,l),c(E.$$.fragment,l),c(x.$$.fragment,l),c(V.$$.fragment,l),c(X.$$.fragment,l),c(L.$$.fragment,l),c(z.$$.fragment,l),c(ll.$$.fragment,l),$l=!1},d(l){l&&(s(el),s(tl),s(nl),s(al),s(Ml),s(m),s(ol),s(b),s(il),s(h),s(pl),s(d),s(yl),s(I),s(ul),s(C),s(rl),s(cl),s(B),s(jl),s(Ul),s(Q),s(Jl),s(wl),s(Tl),s(W),s(ml),s(v),s(bl),s(hl),s(dl),s(S),s(Il),s(R),s(Cl),s(gl),s(N),s(Bl),s(G),s(fl),s(_),s(Ql),s(ql),s(Al),s($),s(Wl),s(H),s(vl),s(Zl),s(Y),s(kl),s(Sl),s(F),s(Rl),s(El),s(D),s(Nl),s(K),s(Gl),s(P),s(_l),s(O),s(xl),s(Vl),s(sl)),s(J),j(w,l),j(T,l),j(g,l),j(f,l),j(q,l),j(A,l),j(Z,l),j(k,l),j(E,l),j(x,l),j(V,l),j(X,l),j(L,l),j(z,l),j(ll,l)}}}const ft='{"title":"Text-to-SQL","local":"text-to-sql","sections":[{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":3},{"title":"Level 2: Table joins","local":"level-2-table-joins","sections":[],"depth":3}],"depth":1}';function Qt(Xl){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends bt{constructor(J){super(),ht(this,J,Qt,Bt,wt,{})}}export{kt as component};
