import{s as Rt,f as St,o as Vt,n as Pe}from"../chunks/scheduler.25b97de1.js";import{S as Xt,i as Gt,g as m,s as a,r as u,A as Ht,h as p,f as s,c as r,j as E,u as _,x as w,k as W,y as i,a as c,v as b,d as y,t as M,w as v}from"../chunks/index.d9030fc9.js";import{T as Tt}from"../chunks/Tip.baa67368.js";import{D}from"../chunks/Docstring.e257edda.js";import{C as bt}from"../chunks/CodeBlock.e6cd0d95.js";import{F as qt,M as Lt}from"../chunks/Markdown.7217f838.js";import{E as _t}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{P as Yt}from"../chunks/PipelineTag.5f100392.js";import{H as Ne,E as Dt}from"../chunks/EditOnGithub.91d95064.js";function At(C){let t,f="Example:",o,l,T;return l=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlaXRDb25maWclMkMlMjBCZWl0TW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQkVpVCUyMGJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCZWl0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQmVpdE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BeitConfig, BeitModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BEiT beit-base-patch16-224-pt22k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BeitConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the beit-base-patch16-224-pt22k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,o=a(),u(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=f),o=r(n),_(l.$$.fragment,n)},m(n,x){c(n,t,x),c(n,o,x),b(l,n,x),T=!0},p:Pe,i(n){T||(y(l.$$.fragment,n),T=!0)},o(n){M(l.$$.fragment,n),T=!1},d(n){n&&(s(t),s(o)),v(l,n)}}}function Qt(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(o,l){c(o,t,l)},p:Pe,d(o){o&&s(t)}}}function Ot(C){let t,f="Example:",o,l,T;return l=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmVpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitModel.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">197</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,o=a(),u(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=f),o=r(n),_(l.$$.fragment,n)},m(n,x){c(n,t,x),c(n,o,x),b(l,n,x),T=!0},p:Pe,i(n){T||(y(l.$$.fragment,n),T=!0)},o(n){M(l.$$.fragment,n),T=!1},d(n){n&&(s(t),s(o)),v(l,n)}}}function Kt(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(o,l){c(o,t,l)},p:Pe,d(o){o&&s(t)}}}function eo(C){let t,f="Examples:",o,l,T;return l=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMiklMEFtb2RlbCUyMCUzRCUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBJTBBbnVtX3BhdGNoZXMlMjAlM0QlMjAobW9kZWwuY29uZmlnLmltYWdlX3NpemUlMjAlMkYlMkYlMjBtb2RlbC5jb25maWcucGF0Y2hfc2l6ZSklMjAqKiUyMDIlMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEElMjMlMjBjcmVhdGUlMjByYW5kb20lMjBib29sZWFuJTIwbWFzayUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9wYXRjaGVzKSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQobG93JTNEMCUyQyUyMGhpZ2glM0QyJTJDJTIwc2l6ZSUzRCgxJTJDJTIwbnVtX3BhdGNoZXMpKS5ib29sKCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzJTJDJTIwYm9vbF9tYXNrZWRfcG9zJTNEYm9vbF9tYXNrZWRfcG9zKSUwQWxvc3MlMkMlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMkMlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits = outputs.loss, outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">196</span>, <span class="hljs-number">8192</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,o=a(),u(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=f),o=r(n),_(l.$$.fragment,n)},m(n,x){c(n,t,x),c(n,o,x),b(l,n,x),T=!0},p:Pe,i(n){T||(y(l.$$.fragment,n),T=!0)},o(n){M(l.$$.fragment,n),T=!1},d(n){n&&(s(t),s(o)),v(l,n)}}}function to(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(o,l){c(o,t,l)},p:Pe,d(o){o&&s(t)}}}function oo(C){let t,f="Example:",o,l,T;return l=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,o=a(),u(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=f),o=r(n),_(l.$$.fragment,n)},m(n,x){c(n,t,x),c(n,o,x),b(l,n,x),T=!0},p:Pe,i(n){T||(y(l.$$.fragment,n),T=!0)},o(n){M(l.$$.fragment,n),T=!1},d(n){n&&(s(t),s(o)),v(l,n)}}}function no(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(o,l){c(o,t,l)},p:Pe,d(o){o&&s(t)}}}function so(C){let t,f="Examples:",o,l,T;return l=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLWZpbmV0dW5lZC1hZGUtNjQwLTY0MCUyMiklMEFtb2RlbCUyMCUzRCUyMEJlaXRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLWZpbmV0dW5lZC1hZGUtNjQwLTY0MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjMlMjBsb2dpdHMlMjBhcmUlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fbGFiZWxzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-finetuned-ade-640-640&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-finetuned-ade-640-640&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># logits are of shape (batch_size, num_labels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,o=a(),u(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=f),o=r(n),_(l.$$.fragment,n)},m(n,x){c(n,t,x),c(n,o,x),b(l,n,x),T=!0},p:Pe,i(n){T||(y(l.$$.fragment,n),T=!0)},o(n){M(l.$$.fragment,n),T=!1},d(n){n&&(s(t),s(o)),v(l,n)}}}function ao(C){let t,f,o,l,T,n,x=`The bare Beit Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,De,U,Se,Ae,O,ct='The <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitModel">BeitModel</a> forward method, overrides the <code>__call__</code> special method.',Qe,X,dt,fe,ie,Ve,Xe,j,ae,je,ye,at=`Beit Model transformer with a ‘language’ modeling head on top. BEiT does masked image modeling by predicting
visual tokens of a Vector-Quantize Variational Autoencoder (VQ-VAE), whereas other vision models like ViT and DeiT
predict RGB pixel values. As a result, this class is incompatible with <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoModelForMaskedImageModeling">AutoModelForMaskedImageModeling</a>, so you
will need to use <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForMaskedImageModeling">BeitForMaskedImageModeling</a> directly if you wish to do masked image modeling with BEiT.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Me,L,ve,re,Ee,Ie='The <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForMaskedImageModeling">BeitForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',we,F,le,ke,Te,pe,Ge,z,He,Oe,K,mt=`Beit Model transformer with an image classification head on top (a linear layer on top of the average of the final
hidden states of the patch tokens) e.g. for ImageNet.`,Ke,ee,pt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,et,Z,qe,tt,J,Je='The <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',ge,G,rt,de,$e,xe,te,R,ze,ce,Le,We="Beit Model transformer with a semantic segmentation head on top e.g. for ADE20k, CityScapes.",Be,k,A=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ue,H,ue,it,_e,Re='The <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> forward method, overrides the <code>__call__</code> special method.',ot,q,nt,S,me;return t=new Ne({props:{title:"BeitModel",local:"transformers.BeitModel",headingTag:"h2"}}),l=new D({props:{name:"class transformers.BeitModel",anchor:"transformers.BeitModel",parameters:[{name:"config",val:": BeitConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.BeitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L700"}}),Se=new D({props:{name:"forward",anchor:"transformers.BeitModel.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"bool_masked_pos",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeitModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28071/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L731",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.models.beit.modeling_beit.BeitModelOutputWithPooling"
>transformers.models.beit.modeling_beit.BeitModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.models.beit.modeling_beit.BeitModelOutputWithPooling"
>transformers.models.beit.modeling_beit.BeitModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new Tt({props:{$$slots:{default:[Qt]},$$scope:{ctx:C}}}),fe=new _t({props:{anchor:"transformers.BeitModel.forward.example",$$slots:{default:[Ot]},$$scope:{ctx:C}}}),Ve=new Ne({props:{title:"BeitForMaskedImageModeling",local:"transformers.BeitForMaskedImageModeling",headingTag:"h2"}}),ae=new D({props:{name:"class transformers.BeitForMaskedImageModeling",anchor:"transformers.BeitForMaskedImageModeling",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L816"}}),ve=new D({props:{name:"forward",anchor:"transformers.BeitForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"bool_masked_pos",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeitForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForMaskedImageModeling.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28071/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.BeitForMaskedImageModeling.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L837",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),F=new Tt({props:{$$slots:{default:[Kt]},$$scope:{ctx:C}}}),ke=new _t({props:{anchor:"transformers.BeitForMaskedImageModeling.forward.example",$$slots:{default:[eo]},$$scope:{ctx:C}}}),pe=new Ne({props:{title:"BeitForImageClassification",local:"transformers.BeitForImageClassification",headingTag:"h2"}}),He=new D({props:{name:"class transformers.BeitForImageClassification",anchor:"transformers.BeitForImageClassification",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L918"}}),qe=new D({props:{name:"forward",anchor:"transformers.BeitForImageClassification.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeitForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForImageClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28071/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L938",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new Tt({props:{$$slots:{default:[to]},$$scope:{ctx:C}}}),de=new _t({props:{anchor:"transformers.BeitForImageClassification.forward.example",$$slots:{default:[oo]},$$scope:{ctx:C}}}),xe=new Ne({props:{title:"BeitForSemanticSegmentation",local:"transformers.BeitForSemanticSegmentation",headingTag:"h2"}}),ze=new D({props:{name:"class transformers.BeitForSemanticSegmentation",anchor:"transformers.BeitForSemanticSegmentation",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForSemanticSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L1244"}}),ue=new D({props:{name:"forward",anchor:"transformers.BeitForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeitForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/pr_28071/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForSemanticSegmentation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForSemanticSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForSemanticSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForSemanticSegmentation.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForSemanticSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_28071/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForSemanticSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth semantic segmentation maps for computing the loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code>, a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L1302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) — Classification scores for each pixel.</p>
<Tip warning={true}>
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>
</Tip>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new Tt({props:{$$slots:{default:[no]},$$scope:{ctx:C}}}),S=new _t({props:{anchor:"transformers.BeitForSemanticSegmentation.forward.example",$$slots:{default:[so]},$$scope:{ctx:C}}}),{c(){u(t.$$.fragment),f=a(),o=m("div"),u(l.$$.fragment),T=a(),n=m("p"),n.innerHTML=x,De=a(),U=m("div"),u(Se.$$.fragment),Ae=a(),O=m("p"),O.innerHTML=ct,Qe=a(),u(X.$$.fragment),dt=a(),u(fe.$$.fragment),ie=a(),u(Ve.$$.fragment),Xe=a(),j=m("div"),u(ae.$$.fragment),je=a(),ye=m("p"),ye.innerHTML=at,Me=a(),L=m("div"),u(ve.$$.fragment),re=a(),Ee=m("p"),Ee.innerHTML=Ie,we=a(),u(F.$$.fragment),le=a(),u(ke.$$.fragment),Te=a(),u(pe.$$.fragment),Ge=a(),z=m("div"),u(He.$$.fragment),Oe=a(),K=m("p"),K.textContent=mt,Ke=a(),ee=m("p"),ee.innerHTML=pt,et=a(),Z=m("div"),u(qe.$$.fragment),tt=a(),J=m("p"),J.innerHTML=Je,ge=a(),u(G.$$.fragment),rt=a(),u(de.$$.fragment),$e=a(),u(xe.$$.fragment),te=a(),R=m("div"),u(ze.$$.fragment),ce=a(),Le=m("p"),Le.textContent=We,Be=a(),k=m("p"),k.innerHTML=A,Ue=a(),H=m("div"),u(ue.$$.fragment),it=a(),_e=m("p"),_e.innerHTML=Re,ot=a(),u(q.$$.fragment),nt=a(),u(S.$$.fragment),this.h()},l(d){_(t.$$.fragment,d),f=r(d),o=p(d,"DIV",{class:!0});var $=E(o);_(l.$$.fragment,$),T=r($),n=p($,"P",{"data-svelte-h":!0}),w(n)!=="svelte-1wah8ut"&&(n.innerHTML=x),De=r($),U=p($,"DIV",{class:!0});var N=E(U);_(Se.$$.fragment,N),Ae=r(N),O=p(N,"P",{"data-svelte-h":!0}),w(O)!=="svelte-od6azl"&&(O.innerHTML=ct),Qe=r(N),_(X.$$.fragment,N),dt=r(N),_(fe.$$.fragment,N),N.forEach(s),$.forEach(s),ie=r(d),_(Ve.$$.fragment,d),Xe=r(d),j=p(d,"DIV",{class:!0});var Ce=E(j);_(ae.$$.fragment,Ce),je=r(Ce),ye=p(Ce,"P",{"data-svelte-h":!0}),w(ye)!=="svelte-1xv4rf3"&&(ye.innerHTML=at),Me=r(Ce),L=p(Ce,"DIV",{class:!0});var V=E(L);_(ve.$$.fragment,V),re=r(V),Ee=p(V,"P",{"data-svelte-h":!0}),w(Ee)!=="svelte-s51e61"&&(Ee.innerHTML=Ie),we=r(V),_(F.$$.fragment,V),le=r(V),_(ke.$$.fragment,V),V.forEach(s),Ce.forEach(s),Te=r(d),_(pe.$$.fragment,d),Ge=r(d),z=p(d,"DIV",{class:!0});var I=E(z);_(He.$$.fragment,I),Oe=r(I),K=p(I,"P",{"data-svelte-h":!0}),w(K)!=="svelte-83lcss"&&(K.textContent=mt),Ke=r(I),ee=p(I,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-1gjh92c"&&(ee.innerHTML=pt),et=r(I),Z=p(I,"DIV",{class:!0});var Y=E(Z);_(qe.$$.fragment,Y),tt=r(Y),J=p(Y,"P",{"data-svelte-h":!0}),w(J)!=="svelte-easr0x"&&(J.innerHTML=Je),ge=r(Y),_(G.$$.fragment,Y),rt=r(Y),_(de.$$.fragment,Y),Y.forEach(s),I.forEach(s),$e=r(d),_(xe.$$.fragment,d),te=r(d),R=p(d,"DIV",{class:!0});var Q=E(R);_(ze.$$.fragment,Q),ce=r(Q),Le=p(Q,"P",{"data-svelte-h":!0}),w(Le)!=="svelte-olwnwh"&&(Le.textContent=We),Be=r(Q),k=p(Q,"P",{"data-svelte-h":!0}),w(k)!=="svelte-1gjh92c"&&(k.innerHTML=A),Ue=r(Q),H=p(Q,"DIV",{class:!0});var oe=E(H);_(ue.$$.fragment,oe),it=r(oe),_e=p(oe,"P",{"data-svelte-h":!0}),w(_e)!=="svelte-ckeb91"&&(_e.innerHTML=Re),ot=r(oe),_(q.$$.fragment,oe),nt=r(oe),_(S.$$.fragment,oe),oe.forEach(s),Q.forEach(s),this.h()},h(){W(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(d,$){b(t,d,$),c(d,f,$),c(d,o,$),b(l,o,null),i(o,T),i(o,n),i(o,De),i(o,U),b(Se,U,null),i(U,Ae),i(U,O),i(U,Qe),b(X,U,null),i(U,dt),b(fe,U,null),c(d,ie,$),b(Ve,d,$),c(d,Xe,$),c(d,j,$),b(ae,j,null),i(j,je),i(j,ye),i(j,Me),i(j,L),b(ve,L,null),i(L,re),i(L,Ee),i(L,we),b(F,L,null),i(L,le),b(ke,L,null),c(d,Te,$),b(pe,d,$),c(d,Ge,$),c(d,z,$),b(He,z,null),i(z,Oe),i(z,K),i(z,Ke),i(z,ee),i(z,et),i(z,Z),b(qe,Z,null),i(Z,tt),i(Z,J),i(Z,ge),b(G,Z,null),i(Z,rt),b(de,Z,null),c(d,$e,$),b(xe,d,$),c(d,te,$),c(d,R,$),b(ze,R,null),i(R,ce),i(R,Le),i(R,Be),i(R,k),i(R,Ue),i(R,H),b(ue,H,null),i(H,it),i(H,_e),i(H,ot),b(q,H,null),i(H,nt),b(S,H,null),me=!0},p(d,$){const N={};$&2&&(N.$$scope={dirty:$,ctx:d}),X.$set(N);const Ce={};$&2&&(Ce.$$scope={dirty:$,ctx:d}),fe.$set(Ce);const V={};$&2&&(V.$$scope={dirty:$,ctx:d}),F.$set(V);const I={};$&2&&(I.$$scope={dirty:$,ctx:d}),ke.$set(I);const Y={};$&2&&(Y.$$scope={dirty:$,ctx:d}),G.$set(Y);const Q={};$&2&&(Q.$$scope={dirty:$,ctx:d}),de.$set(Q);const oe={};$&2&&(oe.$$scope={dirty:$,ctx:d}),q.$set(oe);const lt={};$&2&&(lt.$$scope={dirty:$,ctx:d}),S.$set(lt)},i(d){me||(y(t.$$.fragment,d),y(l.$$.fragment,d),y(Se.$$.fragment,d),y(X.$$.fragment,d),y(fe.$$.fragment,d),y(Ve.$$.fragment,d),y(ae.$$.fragment,d),y(ve.$$.fragment,d),y(F.$$.fragment,d),y(ke.$$.fragment,d),y(pe.$$.fragment,d),y(He.$$.fragment,d),y(qe.$$.fragment,d),y(G.$$.fragment,d),y(de.$$.fragment,d),y(xe.$$.fragment,d),y(ze.$$.fragment,d),y(ue.$$.fragment,d),y(q.$$.fragment,d),y(S.$$.fragment,d),me=!0)},o(d){M(t.$$.fragment,d),M(l.$$.fragment,d),M(Se.$$.fragment,d),M(X.$$.fragment,d),M(fe.$$.fragment,d),M(Ve.$$.fragment,d),M(ae.$$.fragment,d),M(ve.$$.fragment,d),M(F.$$.fragment,d),M(ke.$$.fragment,d),M(pe.$$.fragment,d),M(He.$$.fragment,d),M(qe.$$.fragment,d),M(G.$$.fragment,d),M(de.$$.fragment,d),M(xe.$$.fragment,d),M(ze.$$.fragment,d),M(ue.$$.fragment,d),M(q.$$.fragment,d),M(S.$$.fragment,d),me=!1},d(d){d&&(s(f),s(o),s(ie),s(Xe),s(j),s(Te),s(Ge),s(z),s($e),s(te),s(R)),v(t,d),v(l),v(Se),v(X),v(fe),v(Ve,d),v(ae),v(ve),v(F),v(ke),v(pe,d),v(He),v(qe),v(G),v(de),v(xe,d),v(ze),v(ue),v(q),v(S)}}}function ro(C){let t,f;return t=new Lt({props:{$$slots:{default:[ao]},$$scope:{ctx:C}}}),{c(){u(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,l){b(t,o,l),f=!0},p(o,l){const T={};l&2&&(T.$$scope={dirty:l,ctx:o}),t.$set(T)},i(o){f||(y(t.$$.fragment,o),f=!0)},o(o){M(t.$$.fragment,o),f=!1},d(o){v(t,o)}}}function io(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(o,l){c(o,t,l)},p:Pe,d(o){o&&s(t)}}}function lo(C){let t,f="Examples:",o,l,T;return l=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhCZWl0TW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyay1mdDIyayUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhCZWl0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyay1mdDIyayUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxBeitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxBeitModel.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,o=a(),u(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=f),o=r(n),_(l.$$.fragment,n)},m(n,x){c(n,t,x),c(n,o,x),b(l,n,x),T=!0},p:Pe,i(n){T||(y(l.$$.fragment,n),T=!0)},o(n){M(l.$$.fragment,n),T=!1},d(n){n&&(s(t),s(o)),v(l,n)}}}function co(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(o,l){c(o,t,l)},p:Pe,d(o){o&&s(t)}}}function mo(C){let t,f="Examples:",o,l,T;return l=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,o=a(),u(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-kvfsh7"&&(t.textContent=f),o=r(n),_(l.$$.fragment,n)},m(n,x){c(n,t,x),c(n,o,x),b(l,n,x),T=!0},p:Pe,i(n){T||(y(l.$$.fragment,n),T=!0)},o(n){M(l.$$.fragment,n),T=!1},d(n){n&&(s(t),s(o)),v(l,n)}}}function po(C){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(o){t=p(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(o,l){c(o,t,l)},p:Pe,d(o){o&&s(t)}}}function ho(C){let t,f="Example:",o,l,T;return l=new bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxBeitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxBeitForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,o=a(),u(l.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=f),o=r(n),_(l.$$.fragment,n)},m(n,x){c(n,t,x),c(n,o,x),b(l,n,x),T=!0},p:Pe,i(n){T||(y(l.$$.fragment,n),T=!0)},o(n){M(l.$$.fragment,n),T=!1},d(n){n&&(s(t),s(o)),v(l,n)}}}function fo(C){let t,f,o,l,T,n,x="The bare Beit Model transformer outputting raw hidden-states without any specific head on top.",De,U,Se=`This model inherits from <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Ae,O,ct=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,Qe,X,dt="Finally, this model supports inherent JAX features such as:",fe,ie,Ve='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Xe,j,ae,je,ye,at="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Me,L,ve,re,Ee,Ie,we,F,le,ke,Te,pe="Beit Model transformer with a ‘language’ modeling head on top (to predict visual tokens).",Ge,z,He=`This model inherits from <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Oe,K,mt=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,Ke,ee,pt="Finally, this model supports inherent JAX features such as:",et,Z,qe='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',tt,J,Je,ge,G,rt="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",de,$e,xe,te,R=`bool_masked_pos (<code>numpy.ndarray</code> of shape <code>(batch_size, num_patches)</code>):
Boolean masked positions. Indicates which patches are masked (1) and which aren’t (0).`,ze,ce,Le,We,Be,k,A,Ue,H,ue=`Beit Model transformer with an image classification head on top (a linear layer on top of the average of the final
hidden states of the patch tokens) e.g. for ImageNet.`,it,_e,Re=`This model inherits from <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,ot,q,nt=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,S,me,d="Finally, this model supports inherent JAX features such as:",$,N,Ce='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',V,I,Y,Q,oe,lt="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",st,Ye,be,Fe,ht;return t=new Ne({props:{title:"FlaxBeitModel",local:"transformers.FlaxBeitModel",headingTag:"h2"}}),l=new D({props:{name:"class transformers.FlaxBeitModel",anchor:"transformers.FlaxBeitModel",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_flax_beit.py#L741"}}),ae=new D({props:{name:"__call__",anchor:"transformers.FlaxBeitModel.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling"
>transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) — Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.</li>
<li><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling"
>transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new Tt({props:{$$slots:{default:[io]},$$scope:{ctx:C}}}),re=new _t({props:{anchor:"transformers.FlaxBeitModel.__call__.example",$$slots:{default:[lo]},$$scope:{ctx:C}}}),Ie=new Ne({props:{title:"FlaxBeitForMaskedImageModeling",local:"transformers.FlaxBeitForMaskedImageModeling",headingTag:"h2"}}),le=new D({props:{name:"class transformers.FlaxBeitForMaskedImageModeling",anchor:"transformers.FlaxBeitForMaskedImageModeling",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitForMaskedImageModeling.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_flax_beit.py#L825"}}),Je=new D({props:{name:"__call__",anchor:"transformers.FlaxBeitForMaskedImageModeling.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$e=new Tt({props:{$$slots:{default:[co]},$$scope:{ctx:C}}}),ce=new _t({props:{anchor:"transformers.FlaxBeitForMaskedImageModeling.__call__.example",$$slots:{default:[mo]},$$scope:{ctx:C}}}),We=new Ne({props:{title:"FlaxBeitForImageClassification",local:"transformers.FlaxBeitForImageClassification",headingTag:"h2"}}),A=new D({props:{name:"class transformers.FlaxBeitForImageClassification",anchor:"transformers.FlaxBeitForImageClassification",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitForImageClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/pr_28071/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_flax_beit.py#L909"}}),Y=new D({props:{name:"__call__",anchor:"transformers.FlaxBeitForImageClassification.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_28071/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ye=new Tt({props:{$$slots:{default:[po]},$$scope:{ctx:C}}}),Fe=new _t({props:{anchor:"transformers.FlaxBeitForImageClassification.__call__.example",$$slots:{default:[ho]},$$scope:{ctx:C}}}),{c(){u(t.$$.fragment),f=a(),o=m("div"),u(l.$$.fragment),T=a(),n=m("p"),n.textContent=x,De=a(),U=m("p"),U.innerHTML=Se,Ae=a(),O=m("p"),O.innerHTML=ct,Qe=a(),X=m("p"),X.textContent=dt,fe=a(),ie=m("ul"),ie.innerHTML=Ve,Xe=a(),j=m("div"),u(ae.$$.fragment),je=a(),ye=m("p"),ye.innerHTML=at,Me=a(),u(L.$$.fragment),ve=a(),u(re.$$.fragment),Ee=a(),u(Ie.$$.fragment),we=a(),F=m("div"),u(le.$$.fragment),ke=a(),Te=m("p"),Te.textContent=pe,Ge=a(),z=m("p"),z.innerHTML=He,Oe=a(),K=m("p"),K.innerHTML=mt,Ke=a(),ee=m("p"),ee.textContent=pt,et=a(),Z=m("ul"),Z.innerHTML=qe,tt=a(),J=m("div"),u(Je.$$.fragment),ge=a(),G=m("p"),G.innerHTML=rt,de=a(),u($e.$$.fragment),xe=a(),te=m("p"),te.innerHTML=R,ze=a(),u(ce.$$.fragment),Le=a(),u(We.$$.fragment),Be=a(),k=m("div"),u(A.$$.fragment),Ue=a(),H=m("p"),H.textContent=ue,it=a(),_e=m("p"),_e.innerHTML=Re,ot=a(),q=m("p"),q.innerHTML=nt,S=a(),me=m("p"),me.textContent=d,$=a(),N=m("ul"),N.innerHTML=Ce,V=a(),I=m("div"),u(Y.$$.fragment),Q=a(),oe=m("p"),oe.innerHTML=lt,st=a(),u(Ye.$$.fragment),be=a(),u(Fe.$$.fragment),this.h()},l(h){_(t.$$.fragment,h),f=r(h),o=p(h,"DIV",{class:!0});var B=E(o);_(l.$$.fragment,B),T=r(B),n=p(B,"P",{"data-svelte-h":!0}),w(n)!=="svelte-yakhoj"&&(n.textContent=x),De=r(B),U=p(B,"P",{"data-svelte-h":!0}),w(U)!=="svelte-1u1va5b"&&(U.innerHTML=Se),Ae=r(B),O=p(B,"P",{"data-svelte-h":!0}),w(O)!=="svelte-10nfsf3"&&(O.innerHTML=ct),Qe=r(B),X=p(B,"P",{"data-svelte-h":!0}),w(X)!=="svelte-1pplc4a"&&(X.textContent=dt),fe=r(B),ie=p(B,"UL",{"data-svelte-h":!0}),w(ie)!=="svelte-1w7z84m"&&(ie.innerHTML=Ve),Xe=r(B),j=p(B,"DIV",{class:!0});var Ze=E(j);_(ae.$$.fragment,Ze),je=r(Ze),ye=p(Ze,"P",{"data-svelte-h":!0}),w(ye)!=="svelte-15yd1qb"&&(ye.innerHTML=at),Me=r(Ze),_(L.$$.fragment,Ze),ve=r(Ze),_(re.$$.fragment,Ze),Ze.forEach(s),B.forEach(s),Ee=r(h),_(Ie.$$.fragment,h),we=r(h),F=p(h,"DIV",{class:!0});var P=E(F);_(le.$$.fragment,P),ke=r(P),Te=p(P,"P",{"data-svelte-h":!0}),w(Te)!=="svelte-1xpbgj8"&&(Te.textContent=pe),Ge=r(P),z=p(P,"P",{"data-svelte-h":!0}),w(z)!=="svelte-1u1va5b"&&(z.innerHTML=He),Oe=r(P),K=p(P,"P",{"data-svelte-h":!0}),w(K)!=="svelte-10nfsf3"&&(K.innerHTML=mt),Ke=r(P),ee=p(P,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-1pplc4a"&&(ee.textContent=pt),et=r(P),Z=p(P,"UL",{"data-svelte-h":!0}),w(Z)!=="svelte-1w7z84m"&&(Z.innerHTML=qe),tt=r(P),J=p(P,"DIV",{class:!0});var ne=E(J);_(Je.$$.fragment,ne),ge=r(ne),G=p(ne,"P",{"data-svelte-h":!0}),w(G)!=="svelte-15yd1qb"&&(G.innerHTML=rt),de=r(ne),_($e.$$.fragment,ne),xe=r(ne),te=p(ne,"P",{"data-svelte-h":!0}),w(te)!=="svelte-1rn5vq7"&&(te.innerHTML=R),ze=r(ne),_(ce.$$.fragment,ne),ne.forEach(s),P.forEach(s),Le=r(h),_(We.$$.fragment,h),Be=r(h),k=p(h,"DIV",{class:!0});var se=E(k);_(A.$$.fragment,se),Ue=r(se),H=p(se,"P",{"data-svelte-h":!0}),w(H)!=="svelte-83lcss"&&(H.textContent=ue),it=r(se),_e=p(se,"P",{"data-svelte-h":!0}),w(_e)!=="svelte-1u1va5b"&&(_e.innerHTML=Re),ot=r(se),q=p(se,"P",{"data-svelte-h":!0}),w(q)!=="svelte-10nfsf3"&&(q.innerHTML=nt),S=r(se),me=p(se,"P",{"data-svelte-h":!0}),w(me)!=="svelte-1pplc4a"&&(me.textContent=d),$=r(se),N=p(se,"UL",{"data-svelte-h":!0}),w(N)!=="svelte-1w7z84m"&&(N.innerHTML=Ce),V=r(se),I=p(se,"DIV",{class:!0});var he=E(I);_(Y.$$.fragment,he),Q=r(he),oe=p(he,"P",{"data-svelte-h":!0}),w(oe)!=="svelte-15yd1qb"&&(oe.innerHTML=lt),st=r(he),_(Ye.$$.fragment,he),be=r(he),_(Fe.$$.fragment,he),he.forEach(s),se.forEach(s),this.h()},h(){W(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(h,B){b(t,h,B),c(h,f,B),c(h,o,B),b(l,o,null),i(o,T),i(o,n),i(o,De),i(o,U),i(o,Ae),i(o,O),i(o,Qe),i(o,X),i(o,fe),i(o,ie),i(o,Xe),i(o,j),b(ae,j,null),i(j,je),i(j,ye),i(j,Me),b(L,j,null),i(j,ve),b(re,j,null),c(h,Ee,B),b(Ie,h,B),c(h,we,B),c(h,F,B),b(le,F,null),i(F,ke),i(F,Te),i(F,Ge),i(F,z),i(F,Oe),i(F,K),i(F,Ke),i(F,ee),i(F,et),i(F,Z),i(F,tt),i(F,J),b(Je,J,null),i(J,ge),i(J,G),i(J,de),b($e,J,null),i(J,xe),i(J,te),i(J,ze),b(ce,J,null),c(h,Le,B),b(We,h,B),c(h,Be,B),c(h,k,B),b(A,k,null),i(k,Ue),i(k,H),i(k,it),i(k,_e),i(k,ot),i(k,q),i(k,S),i(k,me),i(k,$),i(k,N),i(k,V),i(k,I),b(Y,I,null),i(I,Q),i(I,oe),i(I,st),b(Ye,I,null),i(I,be),b(Fe,I,null),ht=!0},p(h,B){const Ze={};B&2&&(Ze.$$scope={dirty:B,ctx:h}),L.$set(Ze);const P={};B&2&&(P.$$scope={dirty:B,ctx:h}),re.$set(P);const ne={};B&2&&(ne.$$scope={dirty:B,ctx:h}),$e.$set(ne);const se={};B&2&&(se.$$scope={dirty:B,ctx:h}),ce.$set(se);const he={};B&2&&(he.$$scope={dirty:B,ctx:h}),Ye.$set(he);const Ct={};B&2&&(Ct.$$scope={dirty:B,ctx:h}),Fe.$set(Ct)},i(h){ht||(y(t.$$.fragment,h),y(l.$$.fragment,h),y(ae.$$.fragment,h),y(L.$$.fragment,h),y(re.$$.fragment,h),y(Ie.$$.fragment,h),y(le.$$.fragment,h),y(Je.$$.fragment,h),y($e.$$.fragment,h),y(ce.$$.fragment,h),y(We.$$.fragment,h),y(A.$$.fragment,h),y(Y.$$.fragment,h),y(Ye.$$.fragment,h),y(Fe.$$.fragment,h),ht=!0)},o(h){M(t.$$.fragment,h),M(l.$$.fragment,h),M(ae.$$.fragment,h),M(L.$$.fragment,h),M(re.$$.fragment,h),M(Ie.$$.fragment,h),M(le.$$.fragment,h),M(Je.$$.fragment,h),M($e.$$.fragment,h),M(ce.$$.fragment,h),M(We.$$.fragment,h),M(A.$$.fragment,h),M(Y.$$.fragment,h),M(Ye.$$.fragment,h),M(Fe.$$.fragment,h),ht=!1},d(h){h&&(s(f),s(o),s(Ee),s(we),s(F),s(Le),s(Be),s(k)),v(t,h),v(l),v(ae),v(L),v(re),v(Ie,h),v(le),v(Je),v($e),v(ce),v(We,h),v(A),v(Y),v(Ye),v(Fe)}}}function go(C){let t,f;return t=new Lt({props:{$$slots:{default:[fo]},$$scope:{ctx:C}}}),{c(){u(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,l){b(t,o,l),f=!0},p(o,l){const T={};l&2&&(T.$$scope={dirty:l,ctx:o}),t.$set(T)},i(o){f||(y(t.$$.fragment,o),f=!0)},o(o){M(t.$$.fragment,o),f=!1},d(o){v(t,o)}}}function uo(C){let t,f,o,l,T,n,x,De,U,Se=`The BEiT model was proposed in <a href="https://arxiv.org/abs/2106.08254" rel="nofollow">BEiT: BERT Pre-Training of Image Transformers</a> by
Hangbo Bao, Li Dong and Furu Wei. Inspired by BERT, BEiT is the first paper that makes self-supervised pre-training of
Vision Transformers (ViTs) outperform supervised pre-training. Rather than pre-training the model to predict the class
of an image (as done in the <a href="https://arxiv.org/abs/2010.11929" rel="nofollow">original ViT paper</a>), BEiT models are pre-trained to
predict visual tokens from the codebook of OpenAI’s <a href="https://arxiv.org/abs/2102.12092" rel="nofollow">DALL-E model</a> given masked
patches.`,Ae,O,ct="The abstract from the paper is the following:",Qe,X,dt=`<em>We introduce a self-supervised vision representation model BEiT, which stands for Bidirectional Encoder representation
from Image Transformers. Following BERT developed in the natural language processing area, we propose a masked image
modeling task to pretrain vision Transformers. Specifically, each image has two views in our pre-training, i.e, image
patches (such as 16x16 pixels), and visual tokens (i.e., discrete tokens). We first “tokenize” the original image into
visual tokens. Then we randomly mask some image patches and fed them into the backbone Transformer. The pre-training
objective is to recover the original visual tokens based on the corrupted image patches. After pre-training BEiT, we
directly fine-tune the model parameters on downstream tasks by appending task layers upon the pretrained encoder.
Experimental results on image classification and semantic segmentation show that our model achieves competitive results
with previous pre-training methods. For example, base-size BEiT achieves 83.2% top-1 accuracy on ImageNet-1K,
significantly outperforming from-scratch DeiT training (81.8%) with the same setup. Moreover, large-size BEiT obtains
86.3% only using ImageNet-1K, even outperforming ViT-L with supervised pre-training on ImageNet-22K (85.2%).</em>`,fe,ie,Ve=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The JAX/FLAX version of this model was
contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/microsoft/unilm/tree/master/beit" rel="nofollow">here</a>.`,Xe,j,ae,je,ye=`<li>BEiT models are regular Vision Transformers, but pre-trained in a self-supervised way rather than supervised. They
outperform both the <a href="vit">original model (ViT)</a> as well as <a href="deit">Data-efficient Image Transformers (DeiT)</a> when fine-tuned on ImageNet-1K and CIFAR-100. You can check out demo notebooks regarding inference as well as
fine-tuning on custom data <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/VisionTransformer" rel="nofollow">here</a> (you can just replace
<a href="/docs/transformers/pr_28071/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> by <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> and
<a href="/docs/transformers/pr_28071/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> by <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a>).</li> <li>There’s also a demo notebook available which showcases how to combine DALL-E’s image tokenizer with BEiT for
performing masked image modeling. You can find it <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/BEiT" rel="nofollow">here</a>.</li> <li>As the BEiT models expect each image to be of the same size (resolution), one can use
<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> to resize (or rescale) and normalize images for the model.</li> <li>Both the patch resolution and image resolution used during pre-training or fine-tuning are reflected in the name of
each checkpoint. For example, <code>microsoft/beit-base-patch16-224</code> refers to a base-sized architecture with patch
resolution of 16x16 and fine-tuning resolution of 224x224. All checkpoints can be found on the <a href="https://huggingface.co/models?search=microsoft/beit" rel="nofollow">hub</a>.</li> <li>The available checkpoints are either (1) pre-trained on <a href="http://www.image-net.org/" rel="nofollow">ImageNet-22k</a> (a collection of
14 million images and 22k classes) only, (2) also fine-tuned on ImageNet-22k or (3) also fine-tuned on <a href="http://www.image-net.org/challenges/LSVRC/2012/" rel="nofollow">ImageNet-1k</a> (also referred to as ILSVRC 2012, a collection of 1.3 million
images and 1,000 classes).</li> <li>BEiT uses relative position embeddings, inspired by the T5 model. During pre-training, the authors shared the
relative position bias among the several self-attention layers. During fine-tuning, each layer’s relative position
bias is initialized with the shared relative position bias obtained after pre-training. Note that, if one wants to
pre-train a model from scratch, one needs to either set the <code>use_relative_position_bias</code> or the
<code>use_relative_position_bias</code> attribute of <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> to <code>True</code> in order to add
position embeddings.</li>`,at,Me,L,ve,re,Ee='BEiT pre-training. Taken from the <a href="https://arxiv.org/abs/2106.08254">original paper.</a>',Ie,we,F,le,ke="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with BEiT.",Te,pe,Ge,z,He='<li><a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Oe,K,mt="<strong>Semantic segmentation</strong>",Ke,ee,pt='<li><a href="../tasks/semantic_segmentation">Semantic segmentation task guide</a></li>',et,Z,qe="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",tt,J,Je,ge,G,rt,de,$e='Class for outputs of <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitModel">BeitModel</a>.',xe,te,R,ze,ce,Le='Class for outputs of <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a>.',We,Be,k,A,Ue,H,ue,it=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitModel">BeitModel</a>. It is used to instantiate an BEiT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the BEiT
<a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k</a> architecture.`,_e,Re,ot,q,nt,S,me,d,$,N,Ce,V,I,Y,Q,oe='Converts the output of <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',lt,st,Ye,be,Fe,ht,h,B="Constructs a BEiT image processor.",Ze,P,ne,se,he,Ct="Preprocess an image or batch of images.",Zt,ft,yt,Nt,$t,Pt='Converts the output of <a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',jt,gt,It,Mt,kt,Ft,Jt;return T=new Ne({props:{title:"BEiT",local:"beit",headingTag:"h1"}}),x=new Ne({props:{title:"Overview",local:"overview",headingTag:"h2"}}),j=new Ne({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),we=new Ne({props:{title:"Resources",local:"resources",headingTag:"h2"}}),pe=new Yt({props:{pipeline:"image-classification"}}),J=new Ne({props:{title:"BEiT specific outputs",local:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",headingTag:"h2"}}),G=new D({props:{name:"class transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.`,name:"pooler_output"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_beit.py#L63"}}),R=new D({props:{name:"class transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling",anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"pooler_output",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.`,name:"pooler_output"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/modeling_flax_beit.py#L44"}}),Be=new Ne({props:{title:"BeitConfig",local:"transformers.BeitConfig",headingTag:"h2"}}),Ue=new D({props:{name:"class transformers.BeitConfig",anchor:"transformers.BeitConfig",parameters:[{name:"vocab_size",val:" = 8192"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"use_mask_token",val:" = False"},{name:"use_absolute_position_embeddings",val:" = False"},{name:"use_relative_position_bias",val:" = False"},{name:"use_shared_relative_position_bias",val:" = False"},{name:"layer_scale_init_value",val:" = 0.1"},{name:"drop_path_rate",val:" = 0.1"},{name:"use_mean_pooling",val:" = True"},{name:"pool_scales",val:" = [1, 2, 3, 6]"},{name:"use_auxiliary_head",val:" = True"},{name:"auxiliary_loss_weight",val:" = 0.4"},{name:"auxiliary_channels",val:" = 256"},{name:"auxiliary_num_convs",val:" = 1"},{name:"auxiliary_concat_input",val:" = False"},{name:"semantic_loss_ignore_index",val:" = 255"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"add_fpn",val:" = False"},{name:"reshape_hidden_states",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Vocabulary size of the BEiT model. Defines the number of different image tokens that can be used during
pre-training.`,name:"vocab_size"},{anchor:"transformers.BeitConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.BeitConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.BeitConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.BeitConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.BeitConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.BeitConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.BeitConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.BeitConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BeitConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.BeitConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.BeitConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.BeitConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.BeitConfig.use_mask_token",description:`<strong>use_mask_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a mask token for masked image modeling.`,name:"use_mask_token"},{anchor:"transformers.BeitConfig.use_absolute_position_embeddings",description:`<strong>use_absolute_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use BERT-style absolute position embeddings.`,name:"use_absolute_position_embeddings"},{anchor:"transformers.BeitConfig.use_relative_position_bias",description:`<strong>use_relative_position_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use T5-style relative position embeddings in the self-attention layers.`,name:"use_relative_position_bias"},{anchor:"transformers.BeitConfig.use_shared_relative_position_bias",description:`<strong>use_shared_relative_position_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the same relative position embeddings across all self-attention layers of the Transformer.`,name:"use_shared_relative_position_bias"},{anchor:"transformers.BeitConfig.layer_scale_init_value",description:`<strong>layer_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Scale to use in the self-attention layers. 0.1 for base, 1e-5 for large. Set 0 to disable layer scale.`,name:"layer_scale_init_value"},{anchor:"transformers.BeitConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate per sample (when applied in the main path of residual layers).`,name:"drop_path_rate"},{anchor:"transformers.BeitConfig.use_mean_pooling",description:`<strong>use_mean_pooling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to mean pool the final hidden states of the patches instead of using the final hidden state of the
CLS token, before applying the classification head.`,name:"use_mean_pooling"},{anchor:"transformers.BeitConfig.pool_scales",description:`<strong>pool_scales</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 3, 6]</code>) &#x2014;
Pooling scales used in Pooling Pyramid Module applied on the last feature map.`,name:"pool_scales"},{anchor:"transformers.BeitConfig.use_auxiliary_head",description:`<strong>use_auxiliary_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use an auxiliary head during training.`,name:"use_auxiliary_head"},{anchor:"transformers.BeitConfig.auxiliary_loss_weight",description:`<strong>auxiliary_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Weight of the cross-entropy loss of the auxiliary head.`,name:"auxiliary_loss_weight"},{anchor:"transformers.BeitConfig.auxiliary_channels",description:`<strong>auxiliary_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Number of channels to use in the auxiliary head.`,name:"auxiliary_channels"},{anchor:"transformers.BeitConfig.auxiliary_num_convs",description:`<strong>auxiliary_num_convs</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of convolutional layers to use in the auxiliary head.`,name:"auxiliary_num_convs"},{anchor:"transformers.BeitConfig.auxiliary_concat_input",description:`<strong>auxiliary_concat_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the output of the auxiliary head with the input before the classification layer.`,name:"auxiliary_concat_input"},{anchor:"transformers.BeitConfig.semantic_loss_ignore_index",description:`<strong>semantic_loss_ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
The index that is ignored by the loss function of the semantic segmentation model.`,name:"semantic_loss_ignore_index"},{anchor:"transformers.BeitConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_features"},{anchor:"transformers.BeitConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_indices"},{anchor:"transformers.BeitConfig.add_fpn",description:`<strong>add_fpn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a FPN as part of the backbone. Only relevant for <code>BeitBackbone</code>.`,name:"add_fpn"},{anchor:"transformers.BeitConfig.reshape_hidden_states",description:`<strong>reshape_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to reshape the feature maps to 4D tensors of shape <code>(batch_size, hidden_size, height, width)</code> in
case the model is used as backbone. If <code>False</code>, the feature maps will be 3D tensors of shape <code>(batch_size, seq_len, hidden_size)</code>. Only relevant for <code>BeitBackbone</code>.`,name:"reshape_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/configuration_beit.py#L31"}}),Re=new _t({props:{anchor:"transformers.BeitConfig.example",$$slots:{default:[At]},$$scope:{ctx:C}}}),q=new Ne({props:{title:"BeitFeatureExtractor",local:"transformers.BeitFeatureExtractor",headingTag:"h2"}}),me=new D({props:{name:"class transformers.BeitFeatureExtractor",anchor:"transformers.BeitFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/feature_extraction_beit.py#L26"}}),N=new D({props:{name:"__call__",anchor:"transformers.BeitFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/image_processing_beit.py#L309"}}),I=new D({props:{name:"post_process_semantic_segmentation",anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": List = None"}],parametersDescription:[{anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/image_processing_beit.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),st=new Ne({props:{title:"BeitImageProcessor",local:"transformers.BeitImageProcessor",headingTag:"h2"}}),Fe=new D({props:{name:"class transformers.BeitImageProcessor",anchor:"transformers.BeitImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_rescale",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.BeitImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.BeitImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.BeitImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image. If the input size is smaller than <code>crop_size</code> along any edge, the image
is padded with 0&#x2019;s and then center cropped. Can be overridden by the <code>do_center_crop</code> parameter in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.BeitImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Desired output size when applying center-cropping. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.
Can be overridden by the <code>crop_size</code> parameter in the <code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.BeitImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.BeitImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.BeitImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.BeitImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
The mean to use if normalizing the image. This is a float or list of floats of length of the number of
channels of the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.BeitImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
The standard deviation to use if normalizing the image. This is a float or list of floats of length of the
number of channels of the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.BeitImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0 is
used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k). The
background label will be replaced by 255. Can be overridden by the <code>do_reduce_labels</code> parameter in the
<code>preprocess</code> method.`,name:"do_reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/image_processing_beit.py#L57"}}),ne=new D({props:{name:"preprocess",anchor:"transformers.BeitImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"segmentation_maps",val:": Union = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_reduce_labels",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.BeitImageProcessor.preprocess.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
Segmentation maps to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"segmentation_maps"},{anchor:"transformers.BeitImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.BeitImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.BeitImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.BeitImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.BeitImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after center crop. If one edge the image is smaller than <code>crop_size</code>, it will be
padded with zeros and then cropped`,name:"crop_size"},{anchor:"transformers.BeitImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.BeitImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.BeitImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.BeitImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.BeitImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.BeitImageProcessor.preprocess.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_reduce_labels</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g.
ADE20k). The background label will be replaced by 255.`,name:"do_reduce_labels"},{anchor:"transformers.BeitImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.BeitImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.BeitImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/image_processing_beit.py#L314"}}),yt=new D({props:{name:"post_process_semantic_segmentation",anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": List = None"}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/pr_28071/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/vr_28071/src/transformers/models/beit/image_processing_beit.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),gt=new qt({props:{pytorch:!0,tensorflow:!1,jax:!0,$$slots:{jax:[go],pytorch:[ro]},$$scope:{ctx:C}}}),Mt=new Dt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/beit.md"}}),{c(){t=m("meta"),f=a(),o=m("p"),l=a(),u(T.$$.fragment),n=a(),u(x.$$.fragment),De=a(),U=m("p"),U.innerHTML=Se,Ae=a(),O=m("p"),O.textContent=ct,Qe=a(),X=m("p"),X.innerHTML=dt,fe=a(),ie=m("p"),ie.innerHTML=Ve,Xe=a(),u(j.$$.fragment),ae=a(),je=m("ul"),je.innerHTML=ye,at=a(),Me=m("img"),ve=a(),re=m("small"),re.innerHTML=Ee,Ie=a(),u(we.$$.fragment),F=a(),le=m("p"),le.textContent=ke,Te=a(),u(pe.$$.fragment),Ge=a(),z=m("ul"),z.innerHTML=He,Oe=a(),K=m("p"),K.innerHTML=mt,Ke=a(),ee=m("ul"),ee.innerHTML=pt,et=a(),Z=m("p"),Z.textContent=qe,tt=a(),u(J.$$.fragment),Je=a(),ge=m("div"),u(G.$$.fragment),rt=a(),de=m("p"),de.innerHTML=$e,xe=a(),te=m("div"),u(R.$$.fragment),ze=a(),ce=m("p"),ce.innerHTML=Le,We=a(),u(Be.$$.fragment),k=a(),A=m("div"),u(Ue.$$.fragment),H=a(),ue=m("p"),ue.innerHTML=it,_e=a(),u(Re.$$.fragment),ot=a(),u(q.$$.fragment),nt=a(),S=m("div"),u(me.$$.fragment),d=a(),$=m("div"),u(N.$$.fragment),Ce=a(),V=m("div"),u(I.$$.fragment),Y=a(),Q=m("p"),Q.innerHTML=oe,lt=a(),u(st.$$.fragment),Ye=a(),be=m("div"),u(Fe.$$.fragment),ht=a(),h=m("p"),h.textContent=B,Ze=a(),P=m("div"),u(ne.$$.fragment),se=a(),he=m("p"),he.textContent=Ct,Zt=a(),ft=m("div"),u(yt.$$.fragment),Nt=a(),$t=m("p"),$t.innerHTML=Pt,jt=a(),u(gt.$$.fragment),It=a(),u(Mt.$$.fragment),kt=a(),Ft=m("p"),this.h()},l(e){const g=Ht("svelte-u9bgzb",document.head);t=p(g,"META",{name:!0,content:!0}),g.forEach(s),f=r(e),o=p(e,"P",{}),E(o).forEach(s),l=r(e),_(T.$$.fragment,e),n=r(e),_(x.$$.fragment,e),De=r(e),U=p(e,"P",{"data-svelte-h":!0}),w(U)!=="svelte-82fvis"&&(U.innerHTML=Se),Ae=r(e),O=p(e,"P",{"data-svelte-h":!0}),w(O)!=="svelte-vfdo9a"&&(O.textContent=ct),Qe=r(e),X=p(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-s10fc1"&&(X.innerHTML=dt),fe=r(e),ie=p(e,"P",{"data-svelte-h":!0}),w(ie)!=="svelte-29336p"&&(ie.innerHTML=Ve),Xe=r(e),_(j.$$.fragment,e),ae=r(e),je=p(e,"UL",{"data-svelte-h":!0}),w(je)!=="svelte-6rzm5b"&&(je.innerHTML=ye),at=r(e),Me=p(e,"IMG",{src:!0,alt:!0,width:!0}),ve=r(e),re=p(e,"SMALL",{"data-svelte-h":!0}),w(re)!=="svelte-11iyjyp"&&(re.innerHTML=Ee),Ie=r(e),_(we.$$.fragment,e),F=r(e),le=p(e,"P",{"data-svelte-h":!0}),w(le)!=="svelte-1bkfbxv"&&(le.textContent=ke),Te=r(e),_(pe.$$.fragment,e),Ge=r(e),z=p(e,"UL",{"data-svelte-h":!0}),w(z)!=="svelte-9w1twn"&&(z.innerHTML=He),Oe=r(e),K=p(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-1qspi63"&&(K.innerHTML=mt),Ke=r(e),ee=p(e,"UL",{"data-svelte-h":!0}),w(ee)!=="svelte-bnel3y"&&(ee.innerHTML=pt),et=r(e),Z=p(e,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-1xesile"&&(Z.textContent=qe),tt=r(e),_(J.$$.fragment,e),Je=r(e),ge=p(e,"DIV",{class:!0});var vt=E(ge);_(G.$$.fragment,vt),rt=r(vt),de=p(vt,"P",{"data-svelte-h":!0}),w(de)!=="svelte-1vajx43"&&(de.innerHTML=$e),vt.forEach(s),xe=r(e),te=p(e,"DIV",{class:!0});var wt=E(te);_(R.$$.fragment,wt),ze=r(wt),ce=p(wt,"P",{"data-svelte-h":!0}),w(ce)!=="svelte-16yklqv"&&(ce.innerHTML=Le),wt.forEach(s),We=r(e),_(Be.$$.fragment,e),k=r(e),A=p(e,"DIV",{class:!0});var xt=E(A);_(Ue.$$.fragment,xt),H=r(xt),ue=p(xt,"P",{"data-svelte-h":!0}),w(ue)!=="svelte-14z00hx"&&(ue.innerHTML=it),_e=r(xt),_(Re.$$.fragment,xt),xt.forEach(s),ot=r(e),_(q.$$.fragment,e),nt=r(e),S=p(e,"DIV",{class:!0});var Bt=E(S);_(me.$$.fragment,Bt),d=r(Bt),$=p(Bt,"DIV",{class:!0});var Et=E($);_(N.$$.fragment,Et),Et.forEach(s),Ce=r(Bt),V=p(Bt,"DIV",{class:!0});var zt=E(V);_(I.$$.fragment,zt),Y=r(zt),Q=p(zt,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-14gmu8w"&&(Q.innerHTML=oe),zt.forEach(s),Bt.forEach(s),lt=r(e),_(st.$$.fragment,e),Ye=r(e),be=p(e,"DIV",{class:!0});var ut=E(be);_(Fe.$$.fragment,ut),ht=r(ut),h=p(ut,"P",{"data-svelte-h":!0}),w(h)!=="svelte-ky7k50"&&(h.textContent=B),Ze=r(ut),P=p(ut,"DIV",{class:!0});var Wt=E(P);_(ne.$$.fragment,Wt),se=r(Wt),he=p(Wt,"P",{"data-svelte-h":!0}),w(he)!=="svelte-1x3yxsa"&&(he.textContent=Ct),Wt.forEach(s),Zt=r(ut),ft=p(ut,"DIV",{class:!0});var Ut=E(ft);_(yt.$$.fragment,Ut),Nt=r(Ut),$t=p(Ut,"P",{"data-svelte-h":!0}),w($t)!=="svelte-14gmu8w"&&($t.innerHTML=Pt),Ut.forEach(s),ut.forEach(s),jt=r(e),_(gt.$$.fragment,e),It=r(e),_(Mt.$$.fragment,e),kt=r(e),Ft=p(e,"P",{}),E(Ft).forEach(s),this.h()},h(){W(t,"name","hf:doc:metadata"),W(t,"content",_o),St(Me.src,L="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/beit_architecture.jpg")||W(Me,"src",L),W(Me,"alt","drawing"),W(Me,"width","600"),W(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,g){i(document.head,t),c(e,f,g),c(e,o,g),c(e,l,g),b(T,e,g),c(e,n,g),b(x,e,g),c(e,De,g),c(e,U,g),c(e,Ae,g),c(e,O,g),c(e,Qe,g),c(e,X,g),c(e,fe,g),c(e,ie,g),c(e,Xe,g),b(j,e,g),c(e,ae,g),c(e,je,g),c(e,at,g),c(e,Me,g),c(e,ve,g),c(e,re,g),c(e,Ie,g),b(we,e,g),c(e,F,g),c(e,le,g),c(e,Te,g),b(pe,e,g),c(e,Ge,g),c(e,z,g),c(e,Oe,g),c(e,K,g),c(e,Ke,g),c(e,ee,g),c(e,et,g),c(e,Z,g),c(e,tt,g),b(J,e,g),c(e,Je,g),c(e,ge,g),b(G,ge,null),i(ge,rt),i(ge,de),c(e,xe,g),c(e,te,g),b(R,te,null),i(te,ze),i(te,ce),c(e,We,g),b(Be,e,g),c(e,k,g),c(e,A,g),b(Ue,A,null),i(A,H),i(A,ue),i(A,_e),b(Re,A,null),c(e,ot,g),b(q,e,g),c(e,nt,g),c(e,S,g),b(me,S,null),i(S,d),i(S,$),b(N,$,null),i(S,Ce),i(S,V),b(I,V,null),i(V,Y),i(V,Q),c(e,lt,g),b(st,e,g),c(e,Ye,g),c(e,be,g),b(Fe,be,null),i(be,ht),i(be,h),i(be,Ze),i(be,P),b(ne,P,null),i(P,se),i(P,he),i(be,Zt),i(be,ft),b(yt,ft,null),i(ft,Nt),i(ft,$t),c(e,jt,g),b(gt,e,g),c(e,It,g),b(Mt,e,g),c(e,kt,g),c(e,Ft,g),Jt=!0},p(e,[g]){const vt={};g&2&&(vt.$$scope={dirty:g,ctx:e}),Re.$set(vt);const wt={};g&2&&(wt.$$scope={dirty:g,ctx:e}),gt.$set(wt)},i(e){Jt||(y(T.$$.fragment,e),y(x.$$.fragment,e),y(j.$$.fragment,e),y(we.$$.fragment,e),y(pe.$$.fragment,e),y(J.$$.fragment,e),y(G.$$.fragment,e),y(R.$$.fragment,e),y(Be.$$.fragment,e),y(Ue.$$.fragment,e),y(Re.$$.fragment,e),y(q.$$.fragment,e),y(me.$$.fragment,e),y(N.$$.fragment,e),y(I.$$.fragment,e),y(st.$$.fragment,e),y(Fe.$$.fragment,e),y(ne.$$.fragment,e),y(yt.$$.fragment,e),y(gt.$$.fragment,e),y(Mt.$$.fragment,e),Jt=!0)},o(e){M(T.$$.fragment,e),M(x.$$.fragment,e),M(j.$$.fragment,e),M(we.$$.fragment,e),M(pe.$$.fragment,e),M(J.$$.fragment,e),M(G.$$.fragment,e),M(R.$$.fragment,e),M(Be.$$.fragment,e),M(Ue.$$.fragment,e),M(Re.$$.fragment,e),M(q.$$.fragment,e),M(me.$$.fragment,e),M(N.$$.fragment,e),M(I.$$.fragment,e),M(st.$$.fragment,e),M(Fe.$$.fragment,e),M(ne.$$.fragment,e),M(yt.$$.fragment,e),M(gt.$$.fragment,e),M(Mt.$$.fragment,e),Jt=!1},d(e){e&&(s(f),s(o),s(l),s(n),s(De),s(U),s(Ae),s(O),s(Qe),s(X),s(fe),s(ie),s(Xe),s(ae),s(je),s(at),s(Me),s(ve),s(re),s(Ie),s(F),s(le),s(Te),s(Ge),s(z),s(Oe),s(K),s(Ke),s(ee),s(et),s(Z),s(tt),s(Je),s(ge),s(xe),s(te),s(We),s(k),s(A),s(ot),s(nt),s(S),s(lt),s(Ye),s(be),s(jt),s(It),s(kt),s(Ft)),s(t),v(T,e),v(x,e),v(j,e),v(we,e),v(pe,e),v(J,e),v(G),v(R),v(Be,e),v(Ue),v(Re),v(q,e),v(me),v(N),v(I),v(st,e),v(Fe),v(ne),v(yt),v(gt,e),v(Mt,e)}}}const _o='{"title":"BEiT","local":"beit","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"BEiT specific outputs","local":"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling","sections":[],"depth":2},{"title":"BeitConfig","local":"transformers.BeitConfig","sections":[],"depth":2},{"title":"BeitFeatureExtractor","local":"transformers.BeitFeatureExtractor","sections":[],"depth":2},{"title":"BeitImageProcessor","local":"transformers.BeitImageProcessor","sections":[],"depth":2},{"title":"BeitModel","local":"transformers.BeitModel","sections":[],"depth":2},{"title":"BeitForMaskedImageModeling","local":"transformers.BeitForMaskedImageModeling","sections":[],"depth":2},{"title":"BeitForImageClassification","local":"transformers.BeitForImageClassification","sections":[],"depth":2},{"title":"BeitForSemanticSegmentation","local":"transformers.BeitForSemanticSegmentation","sections":[],"depth":2},{"title":"FlaxBeitModel","local":"transformers.FlaxBeitModel","sections":[],"depth":2},{"title":"FlaxBeitForMaskedImageModeling","local":"transformers.FlaxBeitForMaskedImageModeling","sections":[],"depth":2},{"title":"FlaxBeitForImageClassification","local":"transformers.FlaxBeitForImageClassification","sections":[],"depth":2}],"depth":1}';function bo(C){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fo extends Xt{constructor(t){super(),Gt(this,t,bo,uo,Rt,{})}}export{Fo as component};
