import{s as he,n as ce,o as me}from"../chunks/scheduler.25b97de1.js";import{S as fe,i as pe,g as s,s as n,r as C,A as ge,h as r,f as a,c as o,j as ue,u as L,x as l,k as V,y as be,a as i,v as k,d as U,t as x,w as H}from"../chunks/index.d9030fc9.js";import{C as ye}from"../chunks/CodeBlock.e6cd0d95.js";import{H as K,E as we}from"../chunks/EditOnGithub.91d95064.js";function qe(N){let d,P,v,J,h,j,c,ee="Transformers supports and integrates many quantization methods such as QLoRA, GPTQ, LLM.int8, and AWQ. However, there are other quantization approaches that are not yet integrated. To make adding and using these quantization methods with Transformers models easier, you should use the <code>HfQuantizer</code> class. The <code>HfQuantizer</code> is designed as an internal helper class for adding a quantization method instead of something you apply to every PyTorch module.",Q,m,te="This guide will show you how to integrate a new quantization method with the <code>HfQuantizer</code> class.",I,f,A,p,ae="Before integrating a new quantization method into Transformers, ensure the method you are trying to add meets the following prerequisites. Only quantization methods that can be run with PyTorch modules are currently supported.",W,g,ie="<li>The quantization method is available through a Python package that is pip-installable by anyone (it is also fine if you can only install the package from source). Ideally, pre-compiled kernels are included in the pip package.</li> <li>The method can run on commonly-used hardware (CPU, GPU, …).</li> <li>The method is wrapped in a <code>nn.Module</code> (e.g., <code>Linear8bitLt</code>, <code>Linear4bit</code>), and the quantized linear layer should have the following definition:</li>",Z,b,B,y,ne="This way, Transformers models can be easily quantized by replacing some instances of <code>nn.Linear</code> with a target class.",E,w,oe="<li>The quantization method should be serializable. You can save the quantized weights locally or push them to the Hub.</li> <li>Make sure the package that contains the quantization kernels/primitive is stable (no frequent breaking changes).</li>",Y,q,se="For some quantization methods, they may require “pre-quantizing” the models through data calibration (e.g., AWQ). In this case, we prefer to only support inference in Transformers and let the third-party library maintained by the ML community deal with the model quantization itself.",F,_,S,z,re='<li><p>Create a new quantization config class inside <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/utils/quantization_config.py" rel="nofollow">src/transformers/utils/quantization_config.py</a> and make sure to expose the new quantization config inside Transformers main <code>init</code> by adding it to the <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/__init__.py#L1088" rel="nofollow"><code>_import_structure</code></a> object of <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/__init__.py" rel="nofollow">src/transformers/<strong>init</strong>.py</a>.</p></li> <li><p>Create a new file inside <a href="https://github.com/huggingface/transformers/tree/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers" rel="nofollow">src/transformers/quantizers/</a> named <code>quantizer_your_method.py</code>, and make it inherit from <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers/base.py#L28" rel="nofollow">src/transformers/quantizers/base.py::HfQuantizer</a>. Make sure to add the new quantizer and quantization config in the quantization auto-mapping in <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers/auto.py" rel="nofollow">src/transformers/quantizers/auto.py</a>.</p></li> <li><p>Define the following class attributes/property methods for your quantization method:</p></li>',G,T,le='<li><code>requires_calibration</code>: Whether the quantization method requires a data calibration process. If set to <code>True</code>, you can only support inference (with quantized weights) and not inference and quantization.</li> <li><code>required_packages</code>: A list of strings of the required packages to use the quantized weights. You might need to define some new utility methods such as <code>is_auto_awq_available</code> in <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/utils/import_utils.py" rel="nofollow">transformers/src/utils/import_utils.py</a>.</li> <li><code>requires_parameters_quantization</code>: Only required if your quantization method requires extra attention to the underlying <code>nn.Parameter</code> object. For example, bitsandbytes uses <code>Params4bit</code> and <code>Int8Param</code>, which requires some extra attention when quantizing the model. Most of the recent quantization method packs int2/int4 weights inside <code>torch.uint8</code> weights, so this flag should not be really required (set to <code>False</code> by default).</li> <li><code>is_serializable</code>: A property method to determine whether the method is serializable or not.</li> <li><code>is_trainable</code>:  A property method to determine whether you can fine-tune models on top of the quantization method (with or without PEFT approaches).</li>',X,u,de='<li><p>Write the <code>validate_environment</code> and <code>update_torch_dtype</code> methods. These methods are called before creating the quantized model to ensure users use the right configuration. You can have a look at how this is done on other quantizers.</p></li> <li><p>Write the <code>_process_model_before_weight_loading</code> method. In Transformers, the quantized models are initialized first on the <code>&quot;meta&quot;</code> device before loading the weights. This means the <code>_process_model_before_weight_loading</code> method takes care of manipulating the model skeleton to replace some modules (e.g., <code>nn.Linear</code>) with the target modules (quantization modules). You can define a module replacement logic or any other utility method by creating a new file in <a href="https://github.com/huggingface/transformers/tree/abbffc4525566a48a9733639797c812301218b83/src/transformers/integrations" rel="nofollow">transformers/src/integrations/</a> and exposing the relevant methods in that folder’s <code>__init__.py</code> file. The best starting point would be to have a look at another quantization methods such as <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers/quantizer_awq.py" rel="nofollow">quantizer_awq.py</a>.</p></li> <li><p>Write the <code>_process_model_after_weight_loading</code> method. This method enables implementing additional features that require manipulating the model after loading the weights.</p></li> <li><p>Document everything! Make sure your quantization method is documented by adding a new file under <code>docs/source/en/quantization</code> and adding a new row in the table in <code>docs/source/en/quantization/overview.md</code>.</p></li> <li><p>Add tests! You should add tests by first adding the package in our nightly Dockerfile inside <code>docker/transformers-quantization-latest-gpu</code> and then adding a new test file in <code>tests/quantization/xxx</code>. Feel free to check out how it is implemented for other quantization methods.</p></li>',R,M,D,$,O;return h=new K({props:{title:"Contribute new quantization method",local:"contribute-new-quantization-method",headingTag:"h1"}}),f=new K({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),b=new ye({props:{code:"Y2xhc3MlMjBMaW5lYXI0Yml0KG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwLi4uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbXlfNGJpdF9rZXJuZWwoeCUyQyUyMHNlbGYud2VpZ2h0JTJDJTIwc2VsZi5iaWFzKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Linear4bit</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, ...</span>):
        ...
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> my_4bit_kernel(x, self.weight, self.bias)`,wrap:!1}}),_=new K({props:{title:"Build a new HFQuantizer class",local:"build-a-new-hfquantizer-class",headingTag:"h2"}}),M=new we({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/contribute.md"}}),{c(){d=s("meta"),P=n(),v=s("p"),J=n(),C(h.$$.fragment),j=n(),c=s("p"),c.innerHTML=ee,Q=n(),m=s("p"),m.innerHTML=te,I=n(),C(f.$$.fragment),A=n(),p=s("p"),p.textContent=ae,W=n(),g=s("ul"),g.innerHTML=ie,Z=n(),C(b.$$.fragment),B=n(),y=s("p"),y.innerHTML=ne,E=n(),w=s("ul"),w.innerHTML=oe,Y=n(),q=s("p"),q.textContent=se,F=n(),C(_.$$.fragment),S=n(),z=s("ol"),z.innerHTML=re,G=n(),T=s("ul"),T.innerHTML=le,X=n(),u=s("ol"),u.innerHTML=de,R=n(),C(M.$$.fragment),D=n(),$=s("p"),this.h()},l(e){const t=ge("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(a),P=o(e),v=r(e,"P",{}),ue(v).forEach(a),J=o(e),L(h.$$.fragment,e),j=o(e),c=r(e,"P",{"data-svelte-h":!0}),l(c)!=="svelte-1pq1qlp"&&(c.innerHTML=ee),Q=o(e),m=r(e,"P",{"data-svelte-h":!0}),l(m)!=="svelte-z2f8d2"&&(m.innerHTML=te),I=o(e),L(f.$$.fragment,e),A=o(e),p=r(e,"P",{"data-svelte-h":!0}),l(p)!=="svelte-1r9sp5d"&&(p.textContent=ae),W=o(e),g=r(e,"UL",{"data-svelte-h":!0}),l(g)!=="svelte-6z9s8p"&&(g.innerHTML=ie),Z=o(e),L(b.$$.fragment,e),B=o(e),y=r(e,"P",{"data-svelte-h":!0}),l(y)!=="svelte-e9o9mb"&&(y.innerHTML=ne),E=o(e),w=r(e,"UL",{"data-svelte-h":!0}),l(w)!=="svelte-yqp59g"&&(w.innerHTML=oe),Y=o(e),q=r(e,"P",{"data-svelte-h":!0}),l(q)!=="svelte-1e8yc6a"&&(q.textContent=se),F=o(e),L(_.$$.fragment,e),S=o(e),z=r(e,"OL",{"data-svelte-h":!0}),l(z)!=="svelte-luvagu"&&(z.innerHTML=re),G=o(e),T=r(e,"UL",{"data-svelte-h":!0}),l(T)!=="svelte-dy6msy"&&(T.innerHTML=le),X=o(e),u=r(e,"OL",{start:!0,"data-svelte-h":!0}),l(u)!=="svelte-1tedz8k"&&(u.innerHTML=de),R=o(e),L(M.$$.fragment,e),D=o(e),$=r(e,"P",{}),ue($).forEach(a),this.h()},h(){V(d,"name","hf:doc:metadata"),V(d,"content",_e),V(u,"start","4")},m(e,t){be(document.head,d),i(e,P,t),i(e,v,t),i(e,J,t),k(h,e,t),i(e,j,t),i(e,c,t),i(e,Q,t),i(e,m,t),i(e,I,t),k(f,e,t),i(e,A,t),i(e,p,t),i(e,W,t),i(e,g,t),i(e,Z,t),k(b,e,t),i(e,B,t),i(e,y,t),i(e,E,t),i(e,w,t),i(e,Y,t),i(e,q,t),i(e,F,t),k(_,e,t),i(e,S,t),i(e,z,t),i(e,G,t),i(e,T,t),i(e,X,t),i(e,u,t),i(e,R,t),k(M,e,t),i(e,D,t),i(e,$,t),O=!0},p:ce,i(e){O||(U(h.$$.fragment,e),U(f.$$.fragment,e),U(b.$$.fragment,e),U(_.$$.fragment,e),U(M.$$.fragment,e),O=!0)},o(e){x(h.$$.fragment,e),x(f.$$.fragment,e),x(b.$$.fragment,e),x(_.$$.fragment,e),x(M.$$.fragment,e),O=!1},d(e){e&&(a(P),a(v),a(J),a(j),a(c),a(Q),a(m),a(I),a(A),a(p),a(W),a(g),a(Z),a(B),a(y),a(E),a(w),a(Y),a(q),a(F),a(S),a(z),a(G),a(T),a(X),a(u),a(R),a(D),a($)),a(d),H(h,e),H(f,e),H(b,e),H(_,e),H(M,e)}}}const _e='{"title":"Contribute new quantization method","local":"contribute-new-quantization-method","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Build a new HFQuantizer class","local":"build-a-new-hfquantizer-class","sections":[],"depth":2}],"depth":1}';function ze(N){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ce extends fe{constructor(d){super(),pe(this,d,ze,qe,he,{})}}export{Ce as component};
