import{s as gs,n as Cs,o as _s}from"../chunks/scheduler.36a0863c.js";import{S as ks,i as Zs,g as n,s as a,r,A as zs,h as p,f as l,c as i,j as Is,u as c,x as o,k as Bs,y as vs,a as t,v as M,d,t as u,w as m}from"../chunks/index.9c13489a.js";import{C as y}from"../chunks/CodeBlock.05d8ec32.js";import{H as Le,E as As}from"../chunks/EditOnGithub.e88f2b7b.js";function Gs(Ke){let J,ne,ae,pe,T,oe,j,De=`In questa guida, scopriremo come creare una pipeline personalizzata e condividerla sull’ <a href="https://hf.co/models" rel="nofollow">Hub</a> o aggiungerla nella libreria
Transformers.`,re,w,Oe=`Innanzitutto, è necessario decidere gli input grezzi che la pipeline sarà in grado di accettare. Possono essere strings, raw bytes,
dictionaries o qualsiasi cosa sia l’input desiderato più probabile. Cerca di mantenere questi input il più possibile in Python
in quanto facilita la compatibilità (anche con altri linguaggi tramite JSON). Questi saranno gli <code>inputs</code> della
pipeline (<code>preprocess</code>).`,ce,f,es=`Poi definire gli <code>outputs</code>. Stessa strategia degli <code>inputs</code>. Più è seplice e meglio è. Questi saranno gli output del metodo
<code>postprocess</code>.`,Me,U,ss=`Si parte ereditando la classe base <code>Pipeline</code>. con i 4 metodi che bisogna implementare <code>preprocess</code>,
<code>_forward</code>, <code>postprocess</code> e <code>_sanitize_parameters</code>.`,de,h,ue,b,ls=`La struttura di questa suddivisione consiste nel supportare in modo relativamente continuo CPU/GPU, supportando allo stesso tempo l’esecuzione di
pre/postelaborazione sulla CPU su thread diversi.`,me,I,ts=`<code>preprocess</code> prenderà gli input originariamente definiti e li trasformerà in qualcosa di alimentabile dal modello. Potrebbe
contenere più informazioni e di solito è un <code>Dict</code>.`,ye,B,as=`<code>_forward</code> è il dettaglio dell’implementazione e non è destinato a essere chiamato direttamente. <code>forward</code> è il metodo preferito per assicurarsi che tutto funzioni correttamente perchè contiene delle slavaguardie. Se qualcosa è
è collegato a un modello reale, appartiene al metodo <code>_forward</code>, tutto il resto è nel preprocess/postprocess.`,Je,g,is="<code>postprocess</code> prende l’otput di <code>_forward</code> e lo trasforma nell’output finale che era stato deciso in precedenza.",Te,C,ns="<code>_sanitize_parameters</code> esiste per consentire agli utenti di passare i parametri ogni volta che desiderano sia a inizialization time <code>pipeline(...., maybe_arg=4)</code> che al call time <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.",je,_,ps=`<code>_sanitize_parameters</code> ritorna 3 dicts di kwargs che vengono passati direttamente a <code>preprocess</code>,
<code>_forward</code> e <code>postprocess</code>. Non riempire nulla se il chiamante non ha chiamato con alcun parametro aggiuntivo. Questo
consente di mantenere gli argomenti predefiniti nella definizione della funzione, che è sempre più “naturale”.`,we,k,os="Un esempio classico potrebbe essere l’argomento <code>top_k</code> nel post processing dei classification tasks.",fe,Z,Ue,z,rs=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,he,v,be,A,cs=`Cercare di mantenere gli input/output molto semplici e idealmente serializzabili in JSON, in quanto ciò rende l’uso della pipeline molto facile
senza richiedere agli utenti di comprendere nuovi tipi di oggetti. È anche relativamente comune supportare molti tipi di argomenti
per facilitarne l’uso (ad esempio file audio, possono essere nomi di file, URL o byte puri).`,Ie,G,Be,q,Ms="Per registrar il tuo <code>new-task</code> alla lista dei tasks supportati, devi aggiungerlo al <code>PIPELINE_REGISTRY</code>:",ge,H,Ce,X,ds="Puoi specificare il modello di default che desideri, in questo caso dovrebbe essere accompagnato da una revisione specifica (che può essere il nome di un branch o l’hash di un commit, in questo caso abbiamo preso <code>&quot;abcdef&quot;</code>) e anche dal type:",_e,V,ke,N,Ze,W,us=`Per condividere la tua pipeline personalizzata sull’Hub, devi solo salvare il codice della tua sottoclasse <code>Pipeline</code> in un file
python. Per esempio, supponiamo di voler utilizzare una pipeline personalizzata per la classificazione delle coppie di frasi come la seguente:`,ze,R,ve,E,ms="L’implementazione è agnostica al framework, e lavorerà sia con modelli PyTorch che con TensorFlow. Se l’abbiamo salvato in un file chiamato <code>pair_classification.py</code>, può essere successivamente importato e registrato in questo modo:",Ae,$,Ge,x,ys=`Una volta fatto, possiamo usarla con un modello pretrained. L’istanza <code>sgugger/finetuned-bert-mrpc</code> è stata
fine-tuned sul dataset MRPC, che classifica le coppie di frasi come parafrasi o no.`,qe,Q,He,Y,Js="Successivamente possiamo condividerlo sull’Hub usando il metodo <code>push_to_hub</code>",Xe,S,Ve,F,Ts=`Questo codice copierà il file dove è stato definitp <code>PairClassificationPipeline</code> all’interno della cartella <code>&quot;test-dynamic-pipeline&quot;</code>,
insieme al salvataggio del modello e del tokenizer della pipeline, prima di pushare il tutto nel repository
<code>{your_username}/test-dynamic-pipeline</code>. Dopodiché chiunque potrà utilizzarlo, purché fornisca l’opzione
<code>trust_remote_code=True</code>:`,Ne,P,We,L,Re,K,js=`Se vuoi contribuire con la tua pipeline a Transformers, dovrai aggiungere un modulo nel sottomodulo <code>pipelines</code>
con il codice della tua pipeline, quindi aggiungilo all’elenco dei tasks definiti in <code>pipelines/__init__.py</code>.`,Ee,D,ws="Poi hai bisogno di aggiungere i test. Crea un nuovo file <code>tests/test_pipelines_MY_PIPELINE.py</code> con esempi ed altri test.",$e,O,fs=`La funzione <code>run_pipeline_test</code> sarà molto generica e su piccoli modelli casuali su ogni possibile
architettura, come definito da <code>model_mapping</code> e <code>tf_model_mapping</code>.`,xe,ee,Us=`Questo è molto importante per testare la compatibilità futura, nel senso che se qualcuno aggiunge un nuovo modello di
<code>XXXForQuestionAnswering</code> allora il test della pipeline tenterà di essere eseguito su di esso. Poiché i modelli sono casuali, è
è impossibile controllare i valori effettivi, per questo esiste un aiuto <code>ANY</code> che tenterà solamente di far corrispondere l’output della pipeline TYPE.`,Qe,se,hs="Hai anche <em>bisogno</em> di implementare 2 (idealmente 4) test.",Ye,le,bs=`<li><code>test_small_model_pt</code> : Definire 1 piccolo modello per questa pipeline (non importa se i risultati non hanno senso)
e testare i risultati della pipeline. I risultati dovrebbero essere gli stessi di <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Definire 1 piccolo modello per questa pipeline (non importa se i risultati non hanno senso)
e testare i risultati della pipeline. I risultati dovrebbero essere gli stessi di <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Testare la pipeline su una pipeline reale in cui i risultati dovrebbero avere
senso. Questi test sono lenti e dovrebbero essere contrassegnati come tali. In questo caso l’obiettivo è mostrare la pipeline e assicurarsi che non ci siano  derive nelle versioni future</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Testare la pipeline su una pipeline reale in cui i risultati dovrebbero avere
senso. Questi test sono lenti e dovrebbero essere contrassegnati come tali. In questo caso l’obiettivo è mostrare la pipeline e assicurarsi
che non ci siano derive nelle versioni future</li>`,Se,te,Fe,ie,Pe;return T=new Le({props:{title:"Come creare una pipeline personalizzata?",local:"come-creare-una-pipeline-personalizzata",headingTag:"h1"}}),h=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),Z=new y({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),v=new y({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),G=new Le({props:{title:"Aggiungilo alla lista dei tasks supportati",local:"aggiungilo-alla-lista-dei-tasks-supportati",headingTag:"h2"}}),H=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),V=new y({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),N=new Le({props:{title:"Condividi la tua pipeline sull’Hub",local:"condividi-la-tua-pipeline-sullhub",headingTag:"h2"}}),R=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),$=new y({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),Q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),S=new y({props:{code:"Y2xhc3NpZmllci5wdXNoX3RvX2h1YiglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIp",highlighted:'classifier.push_to_hub(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)',wrap:!1}}),P=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new Le({props:{title:"Aggiungere la pipeline a Transformers",local:"aggiungere-la-pipeline-a-transformers",headingTag:"h2"}}),te=new As({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/it/add_new_pipeline.md"}}),{c(){J=n("meta"),ne=a(),ae=n("p"),pe=a(),r(T.$$.fragment),oe=a(),j=n("p"),j.innerHTML=De,re=a(),w=n("p"),w.innerHTML=Oe,ce=a(),f=n("p"),f.innerHTML=es,Me=a(),U=n("p"),U.innerHTML=ss,de=a(),r(h.$$.fragment),ue=a(),b=n("p"),b.textContent=ls,me=a(),I=n("p"),I.innerHTML=ts,ye=a(),B=n("p"),B.innerHTML=as,Je=a(),g=n("p"),g.innerHTML=is,Te=a(),C=n("p"),C.innerHTML=ns,je=a(),_=n("p"),_.innerHTML=ps,we=a(),k=n("p"),k.innerHTML=os,fe=a(),r(Z.$$.fragment),Ue=a(),z=n("p"),z.innerHTML=rs,he=a(),r(v.$$.fragment),be=a(),A=n("p"),A.textContent=cs,Ie=a(),r(G.$$.fragment),Be=a(),q=n("p"),q.innerHTML=Ms,ge=a(),r(H.$$.fragment),Ce=a(),X=n("p"),X.innerHTML=ds,_e=a(),r(V.$$.fragment),ke=a(),r(N.$$.fragment),Ze=a(),W=n("p"),W.innerHTML=us,ze=a(),r(R.$$.fragment),ve=a(),E=n("p"),E.innerHTML=ms,Ae=a(),r($.$$.fragment),Ge=a(),x=n("p"),x.innerHTML=ys,qe=a(),r(Q.$$.fragment),He=a(),Y=n("p"),Y.innerHTML=Js,Xe=a(),r(S.$$.fragment),Ve=a(),F=n("p"),F.innerHTML=Ts,Ne=a(),r(P.$$.fragment),We=a(),r(L.$$.fragment),Re=a(),K=n("p"),K.innerHTML=js,Ee=a(),D=n("p"),D.innerHTML=ws,$e=a(),O=n("p"),O.innerHTML=fs,xe=a(),ee=n("p"),ee.innerHTML=Us,Qe=a(),se=n("p"),se.innerHTML=hs,Ye=a(),le=n("ul"),le.innerHTML=bs,Se=a(),r(te.$$.fragment),Fe=a(),ie=n("p"),this.h()},l(e){const s=zs("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(l),ne=i(e),ae=p(e,"P",{}),Is(ae).forEach(l),pe=i(e),c(T.$$.fragment,e),oe=i(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-11810ad"&&(j.innerHTML=De),re=i(e),w=p(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1iatkga"&&(w.innerHTML=Oe),ce=i(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-i2xp1j"&&(f.innerHTML=es),Me=i(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-eef5a9"&&(U.innerHTML=ss),de=i(e),c(h.$$.fragment,e),ue=i(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1lfi6tr"&&(b.textContent=ls),me=i(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-m2oyf8"&&(I.innerHTML=ts),ye=i(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-xk0co8"&&(B.innerHTML=as),Je=i(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-wbceks"&&(g.innerHTML=is),Te=i(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1w8676p"&&(C.innerHTML=ns),je=i(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-wn1l5e"&&(_.innerHTML=ps),we=i(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-hymnzr"&&(k.innerHTML=os),fe=i(e),c(Z.$$.fragment,e),Ue=i(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-nsc0of"&&(z.innerHTML=rs),he=i(e),c(v.$$.fragment,e),be=i(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1fkgamo"&&(A.textContent=cs),Ie=i(e),c(G.$$.fragment,e),Be=i(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-4zkgvo"&&(q.innerHTML=Ms),ge=i(e),c(H.$$.fragment,e),Ce=i(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-u38mjv"&&(X.innerHTML=ds),_e=i(e),c(V.$$.fragment,e),ke=i(e),c(N.$$.fragment,e),Ze=i(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-16cgcsm"&&(W.innerHTML=us),ze=i(e),c(R.$$.fragment,e),ve=i(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-libyk9"&&(E.innerHTML=ms),Ae=i(e),c($.$$.fragment,e),Ge=i(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-vhle5u"&&(x.innerHTML=ys),qe=i(e),c(Q.$$.fragment,e),He=i(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-g3f5h"&&(Y.innerHTML=Js),Xe=i(e),c(S.$$.fragment,e),Ve=i(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1jl4eog"&&(F.innerHTML=Ts),Ne=i(e),c(P.$$.fragment,e),We=i(e),c(L.$$.fragment,e),Re=i(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-3oo5s6"&&(K.innerHTML=js),Ee=i(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-17yxzlw"&&(D.innerHTML=ws),$e=i(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-agzokg"&&(O.innerHTML=fs),xe=i(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-td3vn9"&&(ee.innerHTML=Us),Qe=i(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-dschfg"&&(se.innerHTML=hs),Ye=i(e),le=p(e,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-1c56iwk"&&(le.innerHTML=bs),Se=i(e),c(te.$$.fragment,e),Fe=i(e),ie=p(e,"P",{}),Is(ie).forEach(l),this.h()},h(){Bs(J,"name","hf:doc:metadata"),Bs(J,"content",qs)},m(e,s){vs(document.head,J),t(e,ne,s),t(e,ae,s),t(e,pe,s),M(T,e,s),t(e,oe,s),t(e,j,s),t(e,re,s),t(e,w,s),t(e,ce,s),t(e,f,s),t(e,Me,s),t(e,U,s),t(e,de,s),M(h,e,s),t(e,ue,s),t(e,b,s),t(e,me,s),t(e,I,s),t(e,ye,s),t(e,B,s),t(e,Je,s),t(e,g,s),t(e,Te,s),t(e,C,s),t(e,je,s),t(e,_,s),t(e,we,s),t(e,k,s),t(e,fe,s),M(Z,e,s),t(e,Ue,s),t(e,z,s),t(e,he,s),M(v,e,s),t(e,be,s),t(e,A,s),t(e,Ie,s),M(G,e,s),t(e,Be,s),t(e,q,s),t(e,ge,s),M(H,e,s),t(e,Ce,s),t(e,X,s),t(e,_e,s),M(V,e,s),t(e,ke,s),M(N,e,s),t(e,Ze,s),t(e,W,s),t(e,ze,s),M(R,e,s),t(e,ve,s),t(e,E,s),t(e,Ae,s),M($,e,s),t(e,Ge,s),t(e,x,s),t(e,qe,s),M(Q,e,s),t(e,He,s),t(e,Y,s),t(e,Xe,s),M(S,e,s),t(e,Ve,s),t(e,F,s),t(e,Ne,s),M(P,e,s),t(e,We,s),M(L,e,s),t(e,Re,s),t(e,K,s),t(e,Ee,s),t(e,D,s),t(e,$e,s),t(e,O,s),t(e,xe,s),t(e,ee,s),t(e,Qe,s),t(e,se,s),t(e,Ye,s),t(e,le,s),t(e,Se,s),M(te,e,s),t(e,Fe,s),t(e,ie,s),Pe=!0},p:Cs,i(e){Pe||(d(T.$$.fragment,e),d(h.$$.fragment,e),d(Z.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(R.$$.fragment,e),d($.$$.fragment,e),d(Q.$$.fragment,e),d(S.$$.fragment,e),d(P.$$.fragment,e),d(L.$$.fragment,e),d(te.$$.fragment,e),Pe=!0)},o(e){u(T.$$.fragment,e),u(h.$$.fragment,e),u(Z.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u($.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(L.$$.fragment,e),u(te.$$.fragment,e),Pe=!1},d(e){e&&(l(ne),l(ae),l(pe),l(oe),l(j),l(re),l(w),l(ce),l(f),l(Me),l(U),l(de),l(ue),l(b),l(me),l(I),l(ye),l(B),l(Je),l(g),l(Te),l(C),l(je),l(_),l(we),l(k),l(fe),l(Ue),l(z),l(he),l(be),l(A),l(Ie),l(Be),l(q),l(ge),l(Ce),l(X),l(_e),l(ke),l(Ze),l(W),l(ze),l(ve),l(E),l(Ae),l(Ge),l(x),l(qe),l(He),l(Y),l(Xe),l(Ve),l(F),l(Ne),l(We),l(Re),l(K),l(Ee),l(D),l($e),l(O),l(xe),l(ee),l(Qe),l(se),l(Ye),l(le),l(Se),l(Fe),l(ie)),l(J),m(T,e),m(h,e),m(Z,e),m(v,e),m(G,e),m(H,e),m(V,e),m(N,e),m(R,e),m($,e),m(Q,e),m(S,e),m(P,e),m(L,e),m(te,e)}}}const qs='{"title":"Come creare una pipeline personalizzata?","local":"come-creare-una-pipeline-personalizzata","sections":[{"title":"Aggiungilo alla lista dei tasks supportati","local":"aggiungilo-alla-lista-dei-tasks-supportati","sections":[],"depth":2},{"title":"Condividi la tua pipeline sull’Hub","local":"condividi-la-tua-pipeline-sullhub","sections":[],"depth":2},{"title":"Aggiungere la pipeline a Transformers","local":"aggiungere-la-pipeline-a-transformers","sections":[],"depth":2}],"depth":1}';function Hs(Ke){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends ks{constructor(J){super(),Zs(this,J,Hs,Gs,gs,{})}}export{Rs as component};
