import{s as is,o as ps,n as os}from"../chunks/scheduler.36a0863c.js";import{S as rs,i as cs,g as i,s as t,r as o,A as ms,h as p,f as l,c as n,j as ns,u as r,x as M,k as _e,y as ds,a,v as c,d as m,t as d,w as u}from"../chunks/index.9c13489a.js";import{T as us}from"../chunks/Tip.3b06990e.js";import{C as j}from"../chunks/CodeBlock.05d8ec32.js";import{H as le,E as Ms}from"../chunks/EditOnGithub.e88f2b7b.js";function hs(ae){let h,U="Dai un’occhiata alla documentazione di <code>pipeline()</code> per una lista completa dei compiti supportati.";return{c(){h=i("p"),h.innerHTML=U},l(g){h=p(g,"P",{"data-svelte-h":!0}),M(h)!=="svelte-19razip"&&(h.innerHTML=U)},m(g,ee){a(g,h,ee)},p:os,d(g){g&&l(h)}}}function gs(ae){let h,U,g,ee,J,te,b,Qe='La <code>pipeline()</code> rende semplice usare qualsiasi modello dal <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> per fare inferenza su diversi compiti come generazione del testo, segmentazione di immagini e classificazione di audio. Anche se non hai esperienza con una modalità specifica o non comprendi bene il codice che alimenta i modelli, è comunque possibile utilizzarli con l’opzione <code>pipeline()</code>! Questa esercitazione ti insegnerà a:',ne,T,Ee="<li>Usare una <code>pipeline()</code> per fare inferenza.</li> <li>Usare uno specifico tokenizer o modello.</li> <li>Usare una <code>pipeline()</code> per compiti che riguardano audio e video.</li>",ie,y,pe,w,oe,$,Se="Nonostante ogni compito abbia una <code>pipeline()</code> associata, è più semplice utilizzare l’astrazione generica della <code>pipeline()</code> che contiene tutte quelle specifiche per ogni mansione. La <code>pipeline()</code> carica automaticamente un modello predefinito e un tokenizer in grado di fare inferenza per il tuo compito.",re,x,Xe="<li>Inizia creando una <code>pipeline()</code> e specificando il compito su cui fare inferenza:</li>",ce,Z,me,f,Le="<li>Inserisci il testo in input nella <code>pipeline()</code>:</li>",de,I,ue,k,Ne="Se hai più di un input, inseriscilo in una lista:",Me,C,he,G,Ae="Qualsiasi parametro addizionale per il tuo compito può essere incluso nella <code>pipeline()</code>. La mansione <code>text-generation</code> ha un metodo <code>generate()</code> con diversi parametri per controllare l’output. Ad esempio, se desideri generare più di un output, utilizza il parametro <code>num_return_sequences</code>:",ge,v,je,z,ye,B,Ye='La <code>pipeline()</code> accetta qualsiasi modello dal <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Ci sono tag nel Model Hub che consentono di filtrare i modelli per attività. Una volta che avrai scelto il modello appropriato, caricalo usando la corrispondente classe <code>AutoModelFor</code> e <code>AutoTokenizer</code>. Ad esempio, carica la classe <code>AutoModelForCausalLM</code> per un compito di causal language modeling:',fe,W,Ue,V,Fe="Crea una <code>pipeline()</code> per il tuo compito, specificando il modello e il tokenizer che hai caricato:",Je,H,be,R,Pe="Inserisci il testo di input nella <code>pipeline()</code> per generare del testo:",Te,q,we,_,$e,Q,De="La flessibilità della <code>pipeline()</code> fa si che possa essere estesa ad attività sugli audio.",xe,E,Ke="Per esempio, classifichiamo le emozioni in questo clip audio:",Ze,S,Ie,X,Oe='Trova un modello per la <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">classificazione audio</a> sul Model Hub per eseguire un compito di riconoscimento automatico delle emozioni e caricalo nella <code>pipeline()</code>:',ke,L,Ce,N,es="Inserisci il file audio nella <code>pipeline()</code>:",Ge,A,ve,Y,ze,F,ss="Infine, usare la <code>pipeline()</code> per le attività sulle immagini è praticamente la stessa cosa.",Be,P,ls="Specifica la tua attività e inserisci l’immagine nel classificatore. L’immagine può essere sia un link che un percorso sul tuo pc in locale. Per esempio, quale specie di gatto è raffigurata qui sotto?",We,D,as='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Ve,K,He,O,Re,se,qe;return J=new le({props:{title:"Pipeline per l’inferenza",local:"pipeline-per-linferenza",headingTag:"h1"}}),y=new us({props:{$$slots:{default:[hs]},$$scope:{ctx:ae}}}),w=new le({props:{title:"Utilizzo della Pipeline",local:"utilizzo-della-pipeline",headingTag:"h2"}}),Z=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),I=new j({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),C=new j({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),v=new j({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),z=new le({props:{title:"Scegliere modello e tokenizer",local:"scegliere-modello-e-tokenizer",headingTag:"h3"}}),W=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)`,wrap:!1}}),H=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),q=new j({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),_=new le({props:{title:"Audio pipeline",local:"audio-pipeline",headingTag:"h2"}}),S=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFhdWRpb19maWxlJTIwJTNEJTIwZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJwYXRoJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`,wrap:!1}}),L=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),A=new j({props:{code:"cHJlZHMlMjAlM0QlMjBhdWRpb19jbGFzc2lmaWVyKGF1ZGlvX2ZpbGUpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>preds = audio_classifier(audio_file)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1315</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1307</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neutral&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1274</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1261</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1242</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>}]`,wrap:!1}}),Y=new le({props:{title:"Vision pipeline",local:"vision-pipeline",headingTag:"h2"}}),K=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjB2aXNpb25fY2xhc3NpZmllciglMEElMjAlMjAlMjAlMjBpbWFnZXMlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),O=new Ms({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/it/pipeline_tutorial.md"}}),{c(){h=i("meta"),U=t(),g=i("p"),ee=t(),o(J.$$.fragment),te=t(),b=i("p"),b.innerHTML=Qe,ne=t(),T=i("ul"),T.innerHTML=Ee,ie=t(),o(y.$$.fragment),pe=t(),o(w.$$.fragment),oe=t(),$=i("p"),$.innerHTML=Se,re=t(),x=i("ol"),x.innerHTML=Xe,ce=t(),o(Z.$$.fragment),me=t(),f=i("ol"),f.innerHTML=Le,de=t(),o(I.$$.fragment),ue=t(),k=i("p"),k.textContent=Ne,Me=t(),o(C.$$.fragment),he=t(),G=i("p"),G.innerHTML=Ae,ge=t(),o(v.$$.fragment),je=t(),o(z.$$.fragment),ye=t(),B=i("p"),B.innerHTML=Ye,fe=t(),o(W.$$.fragment),Ue=t(),V=i("p"),V.innerHTML=Fe,Je=t(),o(H.$$.fragment),be=t(),R=i("p"),R.innerHTML=Pe,Te=t(),o(q.$$.fragment),we=t(),o(_.$$.fragment),$e=t(),Q=i("p"),Q.innerHTML=De,xe=t(),E=i("p"),E.textContent=Ke,Ze=t(),o(S.$$.fragment),Ie=t(),X=i("p"),X.innerHTML=Oe,ke=t(),o(L.$$.fragment),Ce=t(),N=i("p"),N.innerHTML=es,Ge=t(),o(A.$$.fragment),ve=t(),o(Y.$$.fragment),ze=t(),F=i("p"),F.innerHTML=ss,Be=t(),P=i("p"),P.textContent=ls,We=t(),D=i("p"),D.innerHTML=as,Ve=t(),o(K.$$.fragment),He=t(),o(O.$$.fragment),Re=t(),se=i("p"),this.h()},l(e){const s=ms("svelte-u9bgzb",document.head);h=p(s,"META",{name:!0,content:!0}),s.forEach(l),U=n(e),g=p(e,"P",{}),ns(g).forEach(l),ee=n(e),r(J.$$.fragment,e),te=n(e),b=p(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1rvqis7"&&(b.innerHTML=Qe),ne=n(e),T=p(e,"UL",{"data-svelte-h":!0}),M(T)!=="svelte-fik7a1"&&(T.innerHTML=Ee),ie=n(e),r(y.$$.fragment,e),pe=n(e),r(w.$$.fragment,e),oe=n(e),$=p(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1nqd0ay"&&($.innerHTML=Se),re=n(e),x=p(e,"OL",{"data-svelte-h":!0}),M(x)!=="svelte-a5h60b"&&(x.innerHTML=Xe),ce=n(e),r(Z.$$.fragment,e),me=n(e),f=p(e,"OL",{start:!0,"data-svelte-h":!0}),M(f)!=="svelte-13e2sq6"&&(f.innerHTML=Le),de=n(e),r(I.$$.fragment,e),ue=n(e),k=p(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-tdglgg"&&(k.textContent=Ne),Me=n(e),r(C.$$.fragment,e),he=n(e),G=p(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-qa2wbk"&&(G.innerHTML=Ae),ge=n(e),r(v.$$.fragment,e),je=n(e),r(z.$$.fragment,e),ye=n(e),B=p(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1c68157"&&(B.innerHTML=Ye),fe=n(e),r(W.$$.fragment,e),Ue=n(e),V=p(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-p862so"&&(V.innerHTML=Fe),Je=n(e),r(H.$$.fragment,e),be=n(e),R=p(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-g4zh60"&&(R.innerHTML=Pe),Te=n(e),r(q.$$.fragment,e),we=n(e),r(_.$$.fragment,e),$e=n(e),Q=p(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-cjx6rg"&&(Q.innerHTML=De),xe=n(e),E=p(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-riddeh"&&(E.textContent=Ke),Ze=n(e),r(S.$$.fragment,e),Ie=n(e),X=p(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-15pg5pf"&&(X.innerHTML=Oe),ke=n(e),r(L.$$.fragment,e),Ce=n(e),N=p(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-15lqrn8"&&(N.innerHTML=es),Ge=n(e),r(A.$$.fragment,e),ve=n(e),r(Y.$$.fragment,e),ze=n(e),F=p(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-gkha5e"&&(F.innerHTML=ss),Be=n(e),P=p(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-5pw8zv"&&(P.textContent=ls),We=n(e),D=p(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1bks2jw"&&(D.innerHTML=as),Ve=n(e),r(K.$$.fragment,e),He=n(e),r(O.$$.fragment,e),Re=n(e),se=p(e,"P",{}),ns(se).forEach(l),this.h()},h(){_e(h,"name","hf:doc:metadata"),_e(h,"content",js),_e(f,"start","2")},m(e,s){ds(document.head,h),a(e,U,s),a(e,g,s),a(e,ee,s),c(J,e,s),a(e,te,s),a(e,b,s),a(e,ne,s),a(e,T,s),a(e,ie,s),c(y,e,s),a(e,pe,s),c(w,e,s),a(e,oe,s),a(e,$,s),a(e,re,s),a(e,x,s),a(e,ce,s),c(Z,e,s),a(e,me,s),a(e,f,s),a(e,de,s),c(I,e,s),a(e,ue,s),a(e,k,s),a(e,Me,s),c(C,e,s),a(e,he,s),a(e,G,s),a(e,ge,s),c(v,e,s),a(e,je,s),c(z,e,s),a(e,ye,s),a(e,B,s),a(e,fe,s),c(W,e,s),a(e,Ue,s),a(e,V,s),a(e,Je,s),c(H,e,s),a(e,be,s),a(e,R,s),a(e,Te,s),c(q,e,s),a(e,we,s),c(_,e,s),a(e,$e,s),a(e,Q,s),a(e,xe,s),a(e,E,s),a(e,Ze,s),c(S,e,s),a(e,Ie,s),a(e,X,s),a(e,ke,s),c(L,e,s),a(e,Ce,s),a(e,N,s),a(e,Ge,s),c(A,e,s),a(e,ve,s),c(Y,e,s),a(e,ze,s),a(e,F,s),a(e,Be,s),a(e,P,s),a(e,We,s),a(e,D,s),a(e,Ve,s),c(K,e,s),a(e,He,s),c(O,e,s),a(e,Re,s),a(e,se,s),qe=!0},p(e,[s]){const ts={};s&2&&(ts.$$scope={dirty:s,ctx:e}),y.$set(ts)},i(e){qe||(m(J.$$.fragment,e),m(y.$$.fragment,e),m(w.$$.fragment,e),m(Z.$$.fragment,e),m(I.$$.fragment,e),m(C.$$.fragment,e),m(v.$$.fragment,e),m(z.$$.fragment,e),m(W.$$.fragment,e),m(H.$$.fragment,e),m(q.$$.fragment,e),m(_.$$.fragment,e),m(S.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(Y.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),qe=!0)},o(e){d(J.$$.fragment,e),d(y.$$.fragment,e),d(w.$$.fragment,e),d(Z.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(v.$$.fragment,e),d(z.$$.fragment,e),d(W.$$.fragment,e),d(H.$$.fragment,e),d(q.$$.fragment,e),d(_.$$.fragment,e),d(S.$$.fragment,e),d(L.$$.fragment,e),d(A.$$.fragment,e),d(Y.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),qe=!1},d(e){e&&(l(U),l(g),l(ee),l(te),l(b),l(ne),l(T),l(ie),l(pe),l(oe),l($),l(re),l(x),l(ce),l(me),l(f),l(de),l(ue),l(k),l(Me),l(he),l(G),l(ge),l(je),l(ye),l(B),l(fe),l(Ue),l(V),l(Je),l(be),l(R),l(Te),l(we),l($e),l(Q),l(xe),l(E),l(Ze),l(Ie),l(X),l(ke),l(Ce),l(N),l(Ge),l(ve),l(ze),l(F),l(Be),l(P),l(We),l(D),l(Ve),l(He),l(Re),l(se)),l(h),u(J,e),u(y,e),u(w,e),u(Z,e),u(I,e),u(C,e),u(v,e),u(z,e),u(W,e),u(H,e),u(q,e),u(_,e),u(S,e),u(L,e),u(A,e),u(Y,e),u(K,e),u(O,e)}}}const js='{"title":"Pipeline per l’inferenza","local":"pipeline-per-linferenza","sections":[{"title":"Utilizzo della Pipeline","local":"utilizzo-della-pipeline","sections":[{"title":"Scegliere modello e tokenizer","local":"scegliere-modello-e-tokenizer","sections":[],"depth":3}],"depth":2},{"title":"Audio pipeline","local":"audio-pipeline","sections":[],"depth":2},{"title":"Vision pipeline","local":"vision-pipeline","sections":[],"depth":2}],"depth":1}';function ys(ae){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ws extends rs{constructor(h){super(),cs(this,h,ys,gs,is,{})}}export{ws as component};
