import{s as tt,o as st,n as nt}from"../chunks/scheduler.25b97de1.js";import{S as lt,i as at,g as o,s as l,r as y,A as it,h as r,f as s,c as a,j as De,u as h,x as p,k as Oe,y as ot,a as n,v as m,d as w,t as d,w as M,m as rt,n as pt}from"../chunks/index.d9030fc9.js";import{T as et}from"../chunks/Tip.baa67368.js";import{C as Ae}from"../chunks/CodeBlock.e6cd0d95.js";import{H as K,E as ut}from"../chunks/EditOnGithub.91d95064.js";function ct(L){let i;return{c(){i=rt(`Creating an inference engine is a complex topic, and the "best" solution 
will most likely depend on your problem space. Are you on CPU or GPU? Do
you want the lowest latency, the highest throughput, support for
many models, or just highly optimize 1 specific model?
There are many ways to tackle this topic, so what we are going to present is a good default
to get started which may not necessarily be the most optimal solution for you.`)},l(u){i=pt(u,`Creating an inference engine is a complex topic, and the "best" solution 
will most likely depend on your problem space. Are you on CPU or GPU? Do
you want the lowest latency, the highest throughput, support for
many models, or just highly optimize 1 specific model?
There are many ways to tackle this topic, so what we are going to present is a good default
to get started which may not necessarily be the most optimal solution for you.`)},m(u,c){n(u,i,c)},d(u){u&&s(i)}}}function yt(L){let i,u=`The code sample below is intentionally written like pseudo-code for readability.
Do not run this without checking if it makes sense for your system resources!`;return{c(){i=o("p"),i.textContent=u},l(c){i=r(c,"P",{"data-svelte-h":!0}),p(i)!=="svelte-rnh8z1"&&(i.textContent=u)},m(c,Y){n(c,i,Y)},p:nt,d(c){c&&s(i)}}}function ht(L){let i,u,c,Y,T,O,f,ee,J,xe=`The key thing to understand is that we can use an iterator, just like you would <a href="pipeline_tutorial#using-pipelines-on-a-dataset">on a
dataset</a>, since a webserver is basically a system that waits for requests and
treats them as they come in.`,te,j,Ee=`Usually webservers are multiplexed (multithreaded, async, etc..) to handle various
requests concurrently. Pipelines on the other hand (and mostly the underlying models)
are not really great for parallelism; they take up a lot of RAM, so it’s best to give them all the available resources when they are running or it’s a compute-intensive job.`,se,b,qe=`We are going to solve that by having the webserver handle the light load of receiving
and sending requests, and having a single thread handling the actual work.
This example is going to use <code>starlette</code>. The actual framework is not really
important, but you might have to tune or change the code if you are using another
one to achieve the same effect.`,ne,$,_e="Create <code>server.py</code>:",le,v,ae,C,Xe="Now you can start it with:",ie,U,oe,k,Ze="And you can query it:",re,B,pe,I,Ne="And there you go, now you have a good idea of how to create a webserver!",ue,A,Ge=`What is really important is that we load the model only <strong>once</strong>, so there are no copies
of the model on the webserver. This way, no unnecessary RAM is being used.
Then the queuing mechanism allows you to do fancy stuff like maybe accumulating a few
items before inferring to use dynamic batching:`,ce,g,ye,x,he,E,Ve=`Again, the proposed code is optimized for readability, not for being the best code.
First of all, there’s no batch size limit which is usually not a
great idea. Next, the timeout is reset on every queue fetch, meaning you could
wait much more than 1ms before running the inference (delaying the first request
by that much).`,me,q,He="It would be better to have a single 1ms deadline.",we,_,Qe=`This will always wait for 1ms even if the queue is empty, which might not be the
best since you probably want to start doing inference if there’s nothing in the queue.
But maybe it does make sense if batching is really crucial for your use case.
Again, there’s really no one best solution.`,de,X,Me,Z,fe,N,We=`There’s a lot that can go wrong in production: out of memory, out of space,
loading the model might fail, the query might be wrong, the query might be
correct but still fail to run because of a model misconfiguration, and so on.`,ge,G,Re=`Generally, it’s good if the server outputs the errors to the user, so
adding a lot of <code>try..except</code> statements to show those errors is a good
idea. But keep in mind it may also be a security risk to reveal all those errors depending
on your security context.`,Te,V,Je,H,Se=`Webservers usually look better when they do circuit breaking. It means they
return proper errors when they’re overloaded instead of just waiting for the query indefinitely. Return a 503 error instead of waiting for a super long time or a 504 after a long time.`,je,Q,ze=`This is relatively easy to implement in the proposed code since there is a single queue.
Looking at the queue size is a basic way to start returning errors before your
webserver fails under load.`,be,W,$e,R,Pe=`Currently PyTorch is not async aware, and computation will block the main
thread while running. That means it would be better if PyTorch was forced to run
on its own thread/process. This wasn’t done here because the code is a lot more
complex (mostly because threads and async and queues don’t play nice together).
But ultimately it does the same thing.`,ve,S,Fe=`This would be important if the inference of single items were long (> 1s) because
in this case, it means every query during inference would have to wait for 1s before
even receiving an error.`,Ce,z,Ue,P,Le=`In general, batching is not necessarily an improvement over passing 1 item at
a time (see <a href="./main_classes/pipelines#pipeline-batching">batching details</a> for more information). But it can be very effective
when used in the correct setting. In the API, there is no dynamic
batching by default (too much opportunity for a slowdown). But for BLOOM inference -
which is a very large model - dynamic batching is <strong>essential</strong> to provide a decent experience for everyone.`,ke,F,Be,D,Ie;return T=new K({props:{title:"Using pipelines for a webserver",local:"using-pipelines-for-a-webserver",headingTag:"h1"}}),f=new et({props:{$$slots:{default:[ct]},$$scope:{ctx:L}}}),v=new Ae({props:{code:"ZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlc3BvbnNlcyUyMGltcG9ydCUyMEpTT05SZXNwb25zZSUwQWZyb20lMjBzdGFybGV0dGUucm91dGluZyUyMGltcG9ydCUyMFJvdXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQSUwQWFzeW5jJTIwZGVmJTIwaG9tZXBhZ2UocmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0LmJvZHkoKSUwQSUyMCUyMCUyMCUyMHN0cmluZyUyMCUzRCUyMHBheWxvYWQuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3ElMjAlM0QlMjBhc3luY2lvLlF1ZXVlKCklMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJlcXVlc3QuYXBwLm1vZGVsX3F1ZXVlLnB1dCgoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSkpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjByZXNwb25zZV9xLmdldCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwSlNPTlJlc3BvbnNlKG91dHB1dCklMEElMEElMEFhc3luYyUyMGRlZiUyMHNlcnZlcl9sb29wKHEpJTNBJTBBJTIwJTIwJTIwJTIwcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMjAlMjAlMjAlMjB3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSklMjAlM0QlMjBhd2FpdCUyMHEuZ2V0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXQlMjAlM0QlMjBwaXBlKHN0cmluZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhd2FpdCUyMHJlc3BvbnNlX3EucHV0KG91dCklMEElMEElMEFhcHAlMjAlM0QlMjBTdGFybGV0dGUoJTBBJTIwJTIwJTIwJTIwcm91dGVzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUm91dGUoJTIyJTJGJTIyJTJDJTIwaG9tZXBhZ2UlMkMlMjBtZXRob2RzJTNEJTVCJTIyUE9TVCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEEpJTBBJTBBJTBBJTQwYXBwLm9uX2V2ZW50KCUyMnN0YXJ0dXAlMjIpJTBBYXN5bmMlMjBkZWYlMjBzdGFydHVwX2V2ZW50KCklM0ElMEElMjAlMjAlMjAlMjBxJTIwJTNEJTIwYXN5bmNpby5RdWV1ZSgpJTBBJTIwJTIwJTIwJTIwYXBwLm1vZGVsX3F1ZXVlJTIwJTNEJTIwcSUwQSUyMCUyMCUyMCUyMGFzeW5jaW8uY3JlYXRlX3Rhc2soc2VydmVyX2xvb3AocSkp",highlighted:`<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> asyncio


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">homepage</span>(<span class="hljs-params">request</span>):
    payload = <span class="hljs-keyword">await</span> request.body()
    string = payload.decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    response_q = asyncio.Queue()
    <span class="hljs-keyword">await</span> request.app.model_queue.put((string, response_q))
    output = <span class="hljs-keyword">await</span> response_q.get()
    <span class="hljs-keyword">return</span> JSONResponse(output)


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">server_loop</span>(<span class="hljs-params">q</span>):
    pipe = pipeline(model=<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        (string, response_q) = <span class="hljs-keyword">await</span> q.get()
        out = pipe(string)
        <span class="hljs-keyword">await</span> response_q.put(out)


app = Starlette(
    routes=[
        Route(<span class="hljs-string">&quot;/&quot;</span>, homepage, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
    ],
)


<span class="hljs-meta">@app.on_event(<span class="hljs-params"><span class="hljs-string">&quot;startup&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">startup_event</span>():
    q = asyncio.Queue()
    app.model_queue = q
    asyncio.create_task(server_loop(q))`,wrap:!1}}),U=new Ae({props:{code:"dXZpY29ybiUyMHNlcnZlciUzQWFwcA==",highlighted:"uvicorn server:app",wrap:!1}}),B=new Ae({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMC1kJTIwJTIydGVzdCUyMCU1Qk1BU0slNUQlMjIlMjBodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRiUwQSUyMyU1QiU3QiUyMnNjb3JlJTIyJTNBMC43NzQyOTM2MDE1MTI5MDg5JTJDJTIydG9rZW4lMjIlM0ExMDEyJTJDJTIydG9rZW5fc3RyJTIyJTNBJTIyLiUyMiUyQyUyMnNlcXVlbmNlJTIyJTNBJTIydGVzdC4lMjIlN0QlMkMuLi4lNUQ=",highlighted:`curl -X POST -d <span class="hljs-string">&quot;test [MASK]&quot;</span> http://localhost:8000/
<span class="hljs-comment">#[{&quot;score&quot;:0.7742936015129089,&quot;token&quot;:1012,&quot;token_str&quot;:&quot;.&quot;,&quot;sequence&quot;:&quot;test.&quot;},...]</span>`,wrap:!1}}),g=new et({props:{warning:!0,$$slots:{default:[yt]},$$scope:{ctx:L}}}),x=new Ae({props:{code:"KHN0cmluZyUyQyUyMHJxKSUyMCUzRCUyMGF3YWl0JTIwcS5nZXQoKSUwQXN0cmluZ3MlMjAlM0QlMjAlNUIlNUQlMEFxdWV1ZXMlMjAlM0QlMjAlNUIlNUQlMEF3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoc3RyaW5nJTJDJTIwcnEpJTIwJTNEJTIwYXdhaXQlMjBhc3luY2lvLndhaXRfZm9yKHEuZ2V0KCklMkMlMjB0aW1lb3V0JTNEMC4wMDEpJTIwJTIwJTIzJTIwMW1zJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwYXN5bmNpby5leGNlcHRpb25zLlRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwc3RyaW5ncy5hcHBlbmQoc3RyaW5nKSUwQSUyMCUyMCUyMCUyMHF1ZXVlcy5hcHBlbmQocnEpJTBBc3RyaW5ncyUwQW91dHMlMjAlM0QlMjBwaXBlKHN0cmluZ3MlMkMlMjBiYXRjaF9zaXplJTNEbGVuKHN0cmluZ3MpKSUwQWZvciUyMHJxJTJDJTIwb3V0JTIwaW4lMjB6aXAocXVldWVzJTJDJTIwb3V0cyklM0ElMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJxLnB1dChvdXQp",highlighted:`(string, rq) = <span class="hljs-keyword">await</span> q.get()
strings = []
queues = []
<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    <span class="hljs-keyword">try</span>:
        (string, rq) = <span class="hljs-keyword">await</span> asyncio.wait_for(q.get(), timeout=<span class="hljs-number">0.001</span>)  <span class="hljs-comment"># 1ms</span>
    <span class="hljs-keyword">except</span> asyncio.exceptions.TimeoutError:
        <span class="hljs-keyword">break</span>
    strings.append(string)
    queues.append(rq)
strings
outs = pipe(strings, batch_size=<span class="hljs-built_in">len</span>(strings))
<span class="hljs-keyword">for</span> rq, out <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queues, outs):
    <span class="hljs-keyword">await</span> rq.put(out)`,wrap:!1}}),X=new K({props:{title:"Few things you might want to consider",local:"few-things-you-might-want-to-consider",headingTag:"h2"}}),Z=new K({props:{title:"Error checking",local:"error-checking",headingTag:"h3"}}),V=new K({props:{title:"Circuit breaking",local:"circuit-breaking",headingTag:"h3"}}),W=new K({props:{title:"Blocking the main thread",local:"blocking-the-main-thread",headingTag:"h3"}}),z=new K({props:{title:"Dynamic batching",local:"dynamic-batching",headingTag:"h3"}}),F=new ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/pipeline_webserver.md"}}),{c(){i=o("meta"),u=l(),c=o("p"),Y=l(),y(T.$$.fragment),O=l(),y(f.$$.fragment),ee=l(),J=o("p"),J.innerHTML=xe,te=l(),j=o("p"),j.textContent=Ee,se=l(),b=o("p"),b.innerHTML=qe,ne=l(),$=o("p"),$.innerHTML=_e,le=l(),y(v.$$.fragment),ae=l(),C=o("p"),C.textContent=Xe,ie=l(),y(U.$$.fragment),oe=l(),k=o("p"),k.textContent=Ze,re=l(),y(B.$$.fragment),pe=l(),I=o("p"),I.textContent=Ne,ue=l(),A=o("p"),A.innerHTML=Ge,ce=l(),y(g.$$.fragment),ye=l(),y(x.$$.fragment),he=l(),E=o("p"),E.textContent=Ve,me=l(),q=o("p"),q.textContent=He,we=l(),_=o("p"),_.textContent=Qe,de=l(),y(X.$$.fragment),Me=l(),y(Z.$$.fragment),fe=l(),N=o("p"),N.textContent=We,ge=l(),G=o("p"),G.innerHTML=Re,Te=l(),y(V.$$.fragment),Je=l(),H=o("p"),H.textContent=Se,je=l(),Q=o("p"),Q.textContent=ze,be=l(),y(W.$$.fragment),$e=l(),R=o("p"),R.textContent=Pe,ve=l(),S=o("p"),S.textContent=Fe,Ce=l(),y(z.$$.fragment),Ue=l(),P=o("p"),P.innerHTML=Le,ke=l(),y(F.$$.fragment),Be=l(),D=o("p"),this.h()},l(e){const t=it("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(s),u=a(e),c=r(e,"P",{}),De(c).forEach(s),Y=a(e),h(T.$$.fragment,e),O=a(e),h(f.$$.fragment,e),ee=a(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-n5c362"&&(J.innerHTML=xe),te=a(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1fnss2o"&&(j.textContent=Ee),se=a(e),b=r(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-8q5x1q"&&(b.innerHTML=qe),ne=a(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-g4gw6x"&&($.innerHTML=_e),le=a(e),h(v.$$.fragment,e),ae=a(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1uqobnc"&&(C.textContent=Xe),ie=a(e),h(U.$$.fragment,e),oe=a(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-65h2jl"&&(k.textContent=Ze),re=a(e),h(B.$$.fragment,e),pe=a(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1c2g0w1"&&(I.textContent=Ne),ue=a(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1l65fmc"&&(A.innerHTML=Ge),ce=a(e),h(g.$$.fragment,e),ye=a(e),h(x.$$.fragment,e),he=a(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-14jxcik"&&(E.textContent=Ve),me=a(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1bprwig"&&(q.textContent=He),we=a(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1fuz8qb"&&(_.textContent=Qe),de=a(e),h(X.$$.fragment,e),Me=a(e),h(Z.$$.fragment,e),fe=a(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-vb47n8"&&(N.textContent=We),ge=a(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-n6itpg"&&(G.innerHTML=Re),Te=a(e),h(V.$$.fragment,e),Je=a(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1h0ewze"&&(H.textContent=Se),je=a(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-7kt80n"&&(Q.textContent=ze),be=a(e),h(W.$$.fragment,e),$e=a(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1vr6kgq"&&(R.textContent=Pe),ve=a(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-ime2kf"&&(S.textContent=Fe),Ce=a(e),h(z.$$.fragment,e),Ue=a(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-hsmuqq"&&(P.innerHTML=Le),ke=a(e),h(F.$$.fragment,e),Be=a(e),D=r(e,"P",{}),De(D).forEach(s),this.h()},h(){Oe(i,"name","hf:doc:metadata"),Oe(i,"content",mt)},m(e,t){ot(document.head,i),n(e,u,t),n(e,c,t),n(e,Y,t),m(T,e,t),n(e,O,t),m(f,e,t),n(e,ee,t),n(e,J,t),n(e,te,t),n(e,j,t),n(e,se,t),n(e,b,t),n(e,ne,t),n(e,$,t),n(e,le,t),m(v,e,t),n(e,ae,t),n(e,C,t),n(e,ie,t),m(U,e,t),n(e,oe,t),n(e,k,t),n(e,re,t),m(B,e,t),n(e,pe,t),n(e,I,t),n(e,ue,t),n(e,A,t),n(e,ce,t),m(g,e,t),n(e,ye,t),m(x,e,t),n(e,he,t),n(e,E,t),n(e,me,t),n(e,q,t),n(e,we,t),n(e,_,t),n(e,de,t),m(X,e,t),n(e,Me,t),m(Z,e,t),n(e,fe,t),n(e,N,t),n(e,ge,t),n(e,G,t),n(e,Te,t),m(V,e,t),n(e,Je,t),n(e,H,t),n(e,je,t),n(e,Q,t),n(e,be,t),m(W,e,t),n(e,$e,t),n(e,R,t),n(e,ve,t),n(e,S,t),n(e,Ce,t),m(z,e,t),n(e,Ue,t),n(e,P,t),n(e,ke,t),m(F,e,t),n(e,Be,t),n(e,D,t),Ie=!0},p(e,[t]){const Ye={};t&2&&(Ye.$$scope={dirty:t,ctx:e}),f.$set(Ye);const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),g.$set(Ke)},i(e){Ie||(w(T.$$.fragment,e),w(f.$$.fragment,e),w(v.$$.fragment,e),w(U.$$.fragment,e),w(B.$$.fragment,e),w(g.$$.fragment,e),w(x.$$.fragment,e),w(X.$$.fragment,e),w(Z.$$.fragment,e),w(V.$$.fragment,e),w(W.$$.fragment,e),w(z.$$.fragment,e),w(F.$$.fragment,e),Ie=!0)},o(e){d(T.$$.fragment,e),d(f.$$.fragment,e),d(v.$$.fragment,e),d(U.$$.fragment,e),d(B.$$.fragment,e),d(g.$$.fragment,e),d(x.$$.fragment,e),d(X.$$.fragment,e),d(Z.$$.fragment,e),d(V.$$.fragment,e),d(W.$$.fragment,e),d(z.$$.fragment,e),d(F.$$.fragment,e),Ie=!1},d(e){e&&(s(u),s(c),s(Y),s(O),s(ee),s(J),s(te),s(j),s(se),s(b),s(ne),s($),s(le),s(ae),s(C),s(ie),s(oe),s(k),s(re),s(pe),s(I),s(ue),s(A),s(ce),s(ye),s(he),s(E),s(me),s(q),s(we),s(_),s(de),s(Me),s(fe),s(N),s(ge),s(G),s(Te),s(Je),s(H),s(je),s(Q),s(be),s($e),s(R),s(ve),s(S),s(Ce),s(Ue),s(P),s(ke),s(Be),s(D)),s(i),M(T,e),M(f,e),M(v,e),M(U,e),M(B,e),M(g,e),M(x,e),M(X,e),M(Z,e),M(V,e),M(W,e),M(z,e),M(F,e)}}}const mt='{"title":"Using pipelines for a webserver","local":"using-pipelines-for-a-webserver","sections":[{"title":"Few things you might want to consider","local":"few-things-you-might-want-to-consider","sections":[{"title":"Error checking","local":"error-checking","sections":[],"depth":3},{"title":"Circuit breaking","local":"circuit-breaking","sections":[],"depth":3},{"title":"Blocking the main thread","local":"blocking-the-main-thread","sections":[],"depth":3},{"title":"Dynamic batching","local":"dynamic-batching","sections":[],"depth":3}],"depth":2}],"depth":1}';function wt(L){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends lt{constructor(i){super(),at(this,i,wt,ht,tt,{})}}export{Jt as component};
