import{s as wl,n as vl,o as Tl}from"../chunks/scheduler.0219f8bd.js";import{S as yl,i as $l,g as i,s as l,r as c,A as xl,h as a,f as d,c as r,j as u,u as m,x as n,k as s,y as Hl,a as o,v as p,d as f,t as h,w as _}from"../chunks/index.f61edf3b.js";import{H as b,E as Ml}from"../chunks/EditOnGithub.48fa589f.js";function Ll(wo){let g,tt,Ze,dt,w,ot,v,lt,T,vo="Helper module for audio processing.",rt,y,To=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,it,$,yo='<li><a href="#module_utils/audio">utils/audio</a><ul><li><em>static</em><ul><li><a href="#module_utils/audio.read_audio"><code>.read_audio(url, sampling_rate)</code></a> ⇒ <code>Promise.&lt;Float32Array&gt;</code><ul><li><a href="#module_utils/audio.read_audio..audio"><code>~audio</code></a> : <code>Float32Array</code></li></ul></li> <li><a href="#module_utils/audio.hanning"><code>.hanning(M)</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/audio.hamming"><code>.hamming(M)</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/audio.mel_filter_bank"><code>.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space])</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/audio.spectrogram"><code>.spectrogram(waveform, window, frame_length, hop_length, options)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/audio.window_function"><code>.window_function(window_length, name, options)</code></a> ⇒ <code>Float64Array</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/audio..generalized_cosine_window"><code>~generalized_cosine_window(M, a_0)</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/audio..hertz_to_mel"><code>~hertz_to_mel(freq, [mel_scale])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..mel_to_hertz"><code>~mel_to_hertz(mels, [mel_scale])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio.._create_triangular_filter_bank"><code>~_create_triangular_filter_bank(fft_freqs, filter_freqs)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/audio..linspace"><code>~linspace(start, end, num)</code></a> ⇒</li> <li><a href="#module_utils/audio..padReflect"><code>~padReflect(array, left, right)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio.._db_conversion_helper"><code>~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..amplitude_to_db"><code>~amplitude_to_db(spectrogram, [reference], [min_value], [db_range])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..power_to_db"><code>~power_to_db(spectrogram, [reference], [min_value], [db_range])</code></a> ⇒ <code>T</code></li></ul></li></ul></li>',at,nt,st,x,ut,H,ct,M,$o="Helper function to read audio from a path/URL.",mt,L,xo='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Float32Array&gt;</code> - The decoded audio as a <code>Float32Array</code>.',pt,q,Ho="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The path/URL to load the audio from.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>The sampling rate to use when decoding the audio.</p></td></tr></tbody>",ft,ht,_t,A,bt,C,gt,P,Mo='<strong>Kind</strong>: inner property of <a href="#module_utils/audio.read_audio"><code>read_audio</code></a>',wt,vt,Tt,z,yt,k,$t,F,Lo=`Generates a Hanning window of length M.
See <a href="https://numpy.org/doc/stable/reference/generated/numpy.hanning.html" rel="nofollow">https://numpy.org/doc/stable/reference/generated/numpy.hanning.html</a> for more information.`,xt,E,qo='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The generated Hanning window.',Ht,R,Ao="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>M</td><td><code>number</code></td><td><p>The length of the Hanning window to generate.</p></td></tr></tbody>",Mt,Lt,qt,B,At,D,Ct,I,Co=`Generates a Hamming window of length M.
See <a href="https://numpy.org/doc/stable/reference/generated/numpy.hamming.html" rel="nofollow">https://numpy.org/doc/stable/reference/generated/numpy.hamming.html</a> for more information.`,Pt,K,Po='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The generated Hamming window.',zt,S,zo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>M</td><td><code>number</code></td><td><p>The length of the Hamming window to generate.</p></td></tr></tbody>",kt,Ft,Et,j,Rt,O,Bt,N,ko=`Creates a frequency bin conversion matrix used to obtain a mel spectrogram. This is called a <em>mel filter bank</em>, and
various implementation exist, which differ in the number of filters, the shape of the filters, the way the filters
are spaced, the bandwidth of the filters, and the manner in which the spectrum is warped. The goal of these
features is to approximate the non-linear human perception of the variation in pitch with respect to the frequency.`,Dt,U,Fo=`<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Array&lt;number&gt;&gt;</code> - Triangular filter bank matrix, which is a 2D array of shape (<code>num_frequency_bins</code>, <code>num_mel_filters</code>).
This is a projection matrix to go from a spectrogram to a mel spectrogram.`,It,G,Eo=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num_frequency_bins</td><td><code>number</code></td><td><p>Number of frequencies used to compute the spectrogram (should be the same as in <code>stft</code>).</p></td> </tr><tr><td>num_mel_filters</td><td><code>number</code></td><td><p>Number of mel filters to generate.</p></td> </tr><tr><td>min_frequency</td><td><code>number</code></td><td><p>Lowest frequency of interest in Hz.</p></td> </tr><tr><td>max_frequency</td><td><code>number</code></td><td><p>Highest frequency of interest in Hz. This should not exceed <code>sampling_rate / 2</code>.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>Sample rate of the audio waveform.</p></td> </tr><tr><td>[norm]</td><td><code>string</code></td><td><p>If <code>&quot;slaney&quot;</code>, divide the triangular mel weights by the width of the mel band (area normalization).</p></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><p>The mel frequency scale to use, <code>&quot;htk&quot;</code> or <code>&quot;slaney&quot;</code>.</p></td> </tr><tr><td>[triangularize_in_mel_space]</td><td><code>boolean</code></td><td><p>If this option is enabled, the triangular filter is applied in mel space rather than frequency space.
This should be set to <code>true</code> in order to get the same results as <code>torchaudio</code> when computing mel filters.</p></td></tr></tbody>`,Kt,St,jt,W,Ot,J,Nt,Q,Ro="Calculates a spectrogram over one waveform using the Short-Time Fourier Transform.",Ut,V,Bo="This function can create the following kinds of spectrograms:",Gt,X,Do="<li>amplitude spectrogram (<code>power = 1.0</code>)</li> <li>power spectrogram (<code>power = 2.0</code>)</li> <li>complex-valued spectrogram (<code>power = None</code>)</li> <li>log spectrogram (use <code>log_mel</code> argument)</li> <li>mel spectrogram (provide <code>mel_filters</code>)</li> <li>log-mel spectrogram (provide <code>mel_filters</code> and <code>log_mel</code>)</li>",Wt,Y,Io=`In this implementation, the window is assumed to be zero-padded to have the same size as the analysis frame.
A padded window can be obtained from <code>window_function()</code>. The FFT input buffer may be larger than the analysis frame,
typically the next power of two.`,Jt,Z,Ko='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - Spectrogram of shape <code>(num_frequency_bins, length)</code> (regular spectrogram) or shape <code>(num_mel_filters, length)</code> (mel spectrogram).',Qt,ee,So=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>waveform</td><td><code>Float32Array</code> | <code>Float64Array</code></td><td></td><td><p>The input waveform of shape <code>(length,)</code>. This must be a single real-valued, mono waveform.</p></td> </tr><tr><td>window</td><td><code>Float32Array</code> | <code>Float64Array</code></td><td></td><td><p>The windowing function to apply of shape <code>(frame_length,)</code>, including zero-padding if necessary. The actual window length may be
shorter than <code>frame_length</code>, but we&#39;re assuming the array has already been zero-padded.</p></td> </tr><tr><td>frame_length</td><td><code>number</code></td><td></td><td><p>The length of the analysis frames in samples (a.k.a., <code>fft_length</code>).</p></td> </tr><tr><td>hop_length</td><td><code>number</code></td><td></td><td><p>The stride between successive analysis frames in samples.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td></td> </tr><tr><td>[options.fft_length]</td><td><code>number</code></td><td><code></code></td><td><p>The size of the FFT buffer in samples. This determines how many frequency bins the spectrogram will have.
For optimal speed, this should be a power of two. If <code>null</code>, uses <code>frame_length</code>.</p></td> </tr><tr><td>[options.power]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>If 1.0, returns the amplitude spectrogram. If 2.0, returns the power spectrogram. If <code>null</code>, returns complex numbers.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to pad the waveform so that frame <code>t</code> is centered around time <code>t * hop_length</code>. If <code>false</code>, frame
<code>t</code> will start at time <code>t * hop_length</code>.</p></td> </tr><tr><td>[options.pad_mode]</td><td><code>string</code></td><td><code>&quot;&quot;reflect&quot;&quot;</code></td><td><p>Padding mode used when <code>center</code> is <code>true</code>. Possible values are: <code>&quot;constant&quot;</code> (pad with zeros),
<code>&quot;edge&quot;</code> (pad with edge values), <code>&quot;reflect&quot;</code> (pads with mirrored values).</p></td> </tr><tr><td>[options.onesided]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If <code>true</code>, only computes the positive frequencies and returns a spectrogram containing <code>fft_length // 2 + 1</code>
frequency bins. If <code>false</code>, also computes the negative frequencies and returns <code>fft_length</code> frequency bins.</p></td> </tr><tr><td>[options.preemphasis]</td><td><code>number</code></td><td><code></code></td><td><p>Coefficient for a low-pass filter that applies pre-emphasis before the DFT.</p></td> </tr><tr><td>[options.mel_filters]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The mel filter bank of shape <code>(num_freq_bins, num_mel_filters)</code>.
If supplied, applies this filter bank to create a mel spectrogram.</p></td> </tr><tr><td>[options.mel_floor]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>Minimum value of mel frequency banks.</p></td> </tr><tr><td>[options.log_mel]</td><td><code>string</code></td><td><code>null</code></td><td><p>How to convert the spectrogram to log scale. Possible options are:
<code>null</code> (don&#39;t convert), <code>&quot;log&quot;</code> (take the natural logarithm) <code>&quot;log10&quot;</code> (take the base-10 logarithm), <code>&quot;dB&quot;</code> (convert to decibels).
Can only be used when <code>power</code> is not <code>null</code>.</p></td> </tr><tr><td>[options.reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB. For example, use <code>max(spectrogram)[0]</code> to set
the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[options.min_value]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels, to avoid taking <code>log(0)</code>.
For a power spectrogram, the default of <code>1e-10</code> corresponds to a minimum of -100 dB. For an amplitude spectrogram, the value <code>1e-5</code> corresponds to -100 dB.
Must be greater than zero.</p></td> </tr><tr><td>[options.db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the difference between the
peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td> </tr><tr><td>[options.remove_dc_offset]</td><td><code>boolean</code></td><td><code></code></td><td><p>Subtract mean from waveform on each frame, applied before pre-emphasis. This should be set to <code>true</code> in
order to get the same results as <code>torchaudio.compliance.kaldi.fbank</code> when computing mel filters.</p></td> </tr><tr><td>[options.max_num_frames]</td><td><code>number</code></td><td><code></code></td><td><p>If provided, limits the number of frames to compute to this value.</p></td> </tr><tr><td>[options.min_num_frames]</td><td><code>number</code></td><td><code></code></td><td><p>If provided, ensures the number of frames to compute is at least this value.</p></td> </tr><tr><td>[options.do_pad]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If <code>true</code>, pads the output spectrogram to have <code>max_num_frames</code> frames.</p></td> </tr><tr><td>[options.transpose]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>If <code>true</code>, the returned spectrogram will have shape <code>(num_frames, num_frequency_bins/num_mel_filters)</code>. If <code>false</code>, the returned spectrogram will have shape <code>(num_frequency_bins/num_mel_filters, num_frames)</code>.</p></td></tr></tbody>`,Vt,Xt,Yt,te,Zt,de,ed,oe,jo="Returns an array containing the specified window.",td,le,Oo='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The window of shape <code>(window_length,)</code> or <code>(frame_length,)</code>.',dd,re,No=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>window_length</td><td><code>number</code></td><td></td><td><p>The length of the window in samples.</p></td> </tr><tr><td>name</td><td><code>string</code></td><td></td><td><p>The name of the window function.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options.</p></td> </tr><tr><td>[options.periodic]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether the window is periodic or symmetric.</p></td> </tr><tr><td>[options.frame_length]</td><td><code>number</code></td><td><code></code></td><td><p>The length of the analysis frames in samples.
Provide a value for <code>frame_length</code> if the window is smaller than the frame length, so that it will be zero-padded.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to center the window inside the FFT buffer. Only used when <code>frame_length</code> is provided.</p></td></tr></tbody>`,od,ld,rd,ie,id,ae,ad,ne,Uo=`Helper function to generate windows that are special cases of the generalized cosine window.
See <a href="https://www.mathworks.com/help/signal/ug/generalized-cosine-windows.html" rel="nofollow">https://www.mathworks.com/help/signal/ug/generalized-cosine-windows.html</a> for more information.`,nd,se,Go='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The generated window.',sd,ue,Wo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>M</td><td><code>number</code></td><td><p>Number of points in the output window. If zero or less, an empty array is returned.</p></td> </tr><tr><td>a_0</td><td><code>number</code></td><td><p>Offset for the generalized cosine window.</p></td></tr></tbody>",ud,cd,md,ce,pd,me,fd,pe,Jo='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',hd,fe,Qo="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>freq</td><td><code>T</code></td><td></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><code>&quot;htk&quot;</code></td></tr></tbody>",_d,bd,gd,he,wd,_e,vd,be,Vo='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',Td,ge,Xo="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>mels</td><td><code>T</code></td><td></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><code>&quot;htk&quot;</code></td></tr></tbody>",yd,$d,xd,we,Hd,ve,Md,Te,Yo="Creates a triangular filter bank.",Ld,ye,Zo="Adapted from torchaudio and librosa.",qd,$e,el='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Array&lt;number&gt;&gt;</code> - of shape <code>(num_frequency_bins, num_mel_filters)</code>.',Ad,xe,tl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_freqs</td><td><code>Float64Array</code></td><td><p>Discrete frequencies of the FFT bins in Hz, of shape <code>(num_frequency_bins,)</code>.</p></td> </tr><tr><td>filter_freqs</td><td><code>Float64Array</code></td><td><p>Center frequencies of the triangular filters to create, in Hz, of shape <code>(num_mel_filters,)</code>.</p></td></tr></tbody>",Cd,Pd,zd,He,kd,Me,Fd,Le,dl="Return evenly spaced numbers over a specified interval.",Ed,qe,ol='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>num</code> evenly spaced samples, calculated over the interval <code>[start, stop]</code>.',Rd,Ae,ll="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>start</td><td><code>number</code></td><td><p>The starting value of the sequence.</p></td> </tr><tr><td>end</td><td><code>number</code></td><td><p>The end value of the sequence.</p></td> </tr><tr><td>num</td><td><code>number</code></td><td><p>Number of samples to generate.</p></td></tr></tbody>",Bd,Dd,Id,Ce,Kd,Pe,Sd,ze,rl='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The padded array.',jd,ke,il="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td><td><p>The array to pad.</p></td> </tr><tr><td>left</td><td><code>number</code></td><td><p>The amount of padding to add to the left.</p></td> </tr><tr><td>right</td><td><code>number</code></td><td><p>The amount of padding to add to the right.</p></td></tr></tbody>",Od,Nd,Ud,Fe,Gd,Ee,Wd,Re,al="Helper function to compute <code>amplitude_to_db</code> and <code>power_to_db</code>.",Jd,Be,nl='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',Qd,De,sl="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td> </tr><tr><td>factor</td><td><code>number</code></td> </tr><tr><td>reference</td><td><code>number</code></td> </tr><tr><td>min_value</td><td><code>number</code></td> </tr><tr><td>db_range</td><td><code>number</code></td></tr></tbody>",Vd,Xd,Yd,Ie,Zd,Ke,eo,Se,ul=`Converts an amplitude spectrogram to the decibel scale. This computes <code>20 * log10(spectrogram / reference)</code>,
using basic logarithm properties for numerical stability. NOTE: Operates in-place.`,to,je,cl=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,oo,Oe,ml='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The modified spectrogram in decibels.',lo,Ne,pl=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td><td></td><td><p>The input amplitude (mel) spectrogram.</p></td> </tr><tr><td>[reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB.
For example, use <code>np.max(spectrogram)</code> to set the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[min_value]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels,
to avoid taking <code>log(0)</code>. The default of <code>1e-5</code> corresponds to a minimum of -100 dB. Must be greater than zero.</p></td> </tr><tr><td>[db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the
difference between the peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td></tr></tbody>`,ro,io,ao,Ue,no,Ge,so,We,fl=`Converts a power spectrogram to the decibel scale. This computes <code>10 * log10(spectrogram / reference)</code>,
using basic logarithm properties for numerical stability. NOTE: Operates in-place.`,uo,Je,hl=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,co,Qe,_l="Based on the implementation of <code>librosa.power_to_db</code>.",mo,Ve,bl='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The modified spectrogram in decibels.',po,Xe,gl=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td><td></td><td><p>The input power (mel) spectrogram. Note that a power spectrogram has the amplitudes squared!</p></td> </tr><tr><td>[reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB.
For example, use <code>np.max(spectrogram)</code> to set the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[min_value]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels,
to avoid taking <code>log(0)</code>. The default of <code>1e-10</code> corresponds to a minimum of -100 dB. Must be greater than zero.</p></td> </tr><tr><td>[db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the
difference between the peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td></tr></tbody>`,fo,ho,_o,Ye,bo,et,go;return v=new b({props:{title:"utils/audio",local:"utilsaudio",headingTag:"h1"}}),H=new b({props:{title:"utils/audio.read_audio(url, sampling_rate) ⇒ <code> Promise. < Float32Array > </code>",local:"utilsaudioreadaudiourl-samplingrate--code-promise--float32array--code",headingTag:"h2"}}),C=new b({props:{title:"read_audio~audio : <code> Float32Array </code>",local:"readaudioaudio--code-float32array-code",headingTag:"h3"}}),k=new b({props:{title:"utils/audio.hanning(M) ⇒ <code> Float64Array </code>",local:"utilsaudiohanningm--code-float64array-code",headingTag:"h2"}}),D=new b({props:{title:"utils/audio.hamming(M) ⇒ <code> Float64Array </code>",local:"utilsaudiohammingm--code-float64array-code",headingTag:"h2"}}),O=new b({props:{title:"utils/audio.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space]) ⇒ <code> Array. < Array < number > > </code>",local:"utilsaudiomelfilterbanknumfrequencybins-nummelfilters-minfrequency-maxfrequency-samplingrate-norm-melscale-triangularizeinmelspace--code-array--array--number---code",headingTag:"h2"}}),J=new b({props:{title:"utils/audio.spectrogram(waveform, window, frame_length, hop_length, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilsaudiospectrogramwaveform-window-framelength-hoplength-options--code-promise--tensor--code",headingTag:"h2"}}),de=new b({props:{title:"utils/audio.window_function(window_length, name, options) ⇒ <code> Float64Array </code>",local:"utilsaudiowindowfunctionwindowlength-name-options--code-float64array-code",headingTag:"h2"}}),ae=new b({props:{title:"utils/audio~generalized_cosine_window(M, a_0) ⇒ <code> Float64Array </code>",local:"utilsaudiogeneralizedcosinewindowm-a0--code-float64array-code",headingTag:"h2"}}),me=new b({props:{title:"utils/audio~hertz_to_mel(freq, [mel_scale]) ⇒ <code> T </code>",local:"utilsaudiohertztomelfreq-melscale--code-t-code",headingTag:"h2"}}),_e=new b({props:{title:"utils/audio~mel_to_hertz(mels, [mel_scale]) ⇒ <code> T </code>",local:"utilsaudiomeltohertzmels-melscale--code-t-code",headingTag:"h2"}}),ve=new b({props:{title:"utils/audio~_create_triangular_filter_bank(fft_freqs, filter_freqs) ⇒ <code> Array. < Array < number > > </code>",local:"utilsaudiocreatetriangularfilterbankfftfreqs-filterfreqs--code-array--array--number---code",headingTag:"h2"}}),Me=new b({props:{title:"utils/audio~linspace(start, end, num) ⇒",local:"utilsaudiolinspacestart-end-num-",headingTag:"h2"}}),Pe=new b({props:{title:"utils/audio~padReflect(array, left, right) ⇒ <code> T </code>",local:"utilsaudiopadreflectarray-left-right--code-t-code",headingTag:"h2"}}),Ee=new b({props:{title:"utils/audio~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range) ⇒ <code> T </code>",local:"utilsaudiodbconversionhelperspectrogram-factor-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),Ke=new b({props:{title:"utils/audio~amplitude_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>",local:"utilsaudioamplitudetodbspectrogram-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),Ge=new b({props:{title:"utils/audio~power_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>",local:"utilsaudiopowertodbspectrogram-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),Ye=new Ml({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/audio.md"}}),{c(){g=i("meta"),tt=l(),Ze=i("p"),dt=l(),w=i("a"),ot=l(),c(v.$$.fragment),lt=l(),T=i("p"),T.textContent=vo,rt=l(),y=i("p"),y.textContent=To,it=l(),$=i("ul"),$.innerHTML=yo,at=l(),nt=i("hr"),st=l(),x=i("a"),ut=l(),c(H.$$.fragment),ct=l(),M=i("p"),M.textContent=$o,mt=l(),L=i("p"),L.innerHTML=xo,pt=l(),q=i("table"),q.innerHTML=Ho,ft=l(),ht=i("hr"),_t=l(),A=i("a"),bt=l(),c(C.$$.fragment),gt=l(),P=i("p"),P.innerHTML=Mo,wt=l(),vt=i("hr"),Tt=l(),z=i("a"),yt=l(),c(k.$$.fragment),$t=l(),F=i("p"),F.innerHTML=Lo,xt=l(),E=i("p"),E.innerHTML=qo,Ht=l(),R=i("table"),R.innerHTML=Ao,Mt=l(),Lt=i("hr"),qt=l(),B=i("a"),At=l(),c(D.$$.fragment),Ct=l(),I=i("p"),I.innerHTML=Co,Pt=l(),K=i("p"),K.innerHTML=Po,zt=l(),S=i("table"),S.innerHTML=zo,kt=l(),Ft=i("hr"),Et=l(),j=i("a"),Rt=l(),c(O.$$.fragment),Bt=l(),N=i("p"),N.innerHTML=ko,Dt=l(),U=i("p"),U.innerHTML=Fo,It=l(),G=i("table"),G.innerHTML=Eo,Kt=l(),St=i("hr"),jt=l(),W=i("a"),Ot=l(),c(J.$$.fragment),Nt=l(),Q=i("p"),Q.textContent=Ro,Ut=l(),V=i("p"),V.textContent=Bo,Gt=l(),X=i("ul"),X.innerHTML=Do,Wt=l(),Y=i("p"),Y.innerHTML=Io,Jt=l(),Z=i("p"),Z.innerHTML=Ko,Qt=l(),ee=i("table"),ee.innerHTML=So,Vt=l(),Xt=i("hr"),Yt=l(),te=i("a"),Zt=l(),c(de.$$.fragment),ed=l(),oe=i("p"),oe.textContent=jo,td=l(),le=i("p"),le.innerHTML=Oo,dd=l(),re=i("table"),re.innerHTML=No,od=l(),ld=i("hr"),rd=l(),ie=i("a"),id=l(),c(ae.$$.fragment),ad=l(),ne=i("p"),ne.innerHTML=Uo,nd=l(),se=i("p"),se.innerHTML=Go,sd=l(),ue=i("table"),ue.innerHTML=Wo,ud=l(),cd=i("hr"),md=l(),ce=i("a"),pd=l(),c(me.$$.fragment),fd=l(),pe=i("p"),pe.innerHTML=Jo,hd=l(),fe=i("table"),fe.innerHTML=Qo,_d=l(),bd=i("hr"),gd=l(),he=i("a"),wd=l(),c(_e.$$.fragment),vd=l(),be=i("p"),be.innerHTML=Vo,Td=l(),ge=i("table"),ge.innerHTML=Xo,yd=l(),$d=i("hr"),xd=l(),we=i("a"),Hd=l(),c(ve.$$.fragment),Md=l(),Te=i("p"),Te.textContent=Yo,Ld=l(),ye=i("p"),ye.textContent=Zo,qd=l(),$e=i("p"),$e.innerHTML=el,Ad=l(),xe=i("table"),xe.innerHTML=tl,Cd=l(),Pd=i("hr"),zd=l(),He=i("a"),kd=l(),c(Me.$$.fragment),Fd=l(),Le=i("p"),Le.textContent=dl,Ed=l(),qe=i("p"),qe.innerHTML=ol,Rd=l(),Ae=i("table"),Ae.innerHTML=ll,Bd=l(),Dd=i("hr"),Id=l(),Ce=i("a"),Kd=l(),c(Pe.$$.fragment),Sd=l(),ze=i("p"),ze.innerHTML=rl,jd=l(),ke=i("table"),ke.innerHTML=il,Od=l(),Nd=i("hr"),Ud=l(),Fe=i("a"),Gd=l(),c(Ee.$$.fragment),Wd=l(),Re=i("p"),Re.innerHTML=al,Jd=l(),Be=i("p"),Be.innerHTML=nl,Qd=l(),De=i("table"),De.innerHTML=sl,Vd=l(),Xd=i("hr"),Yd=l(),Ie=i("a"),Zd=l(),c(Ke.$$.fragment),eo=l(),Se=i("p"),Se.innerHTML=ul,to=l(),je=i("p"),je.textContent=cl,oo=l(),Oe=i("p"),Oe.innerHTML=ml,lo=l(),Ne=i("table"),Ne.innerHTML=pl,ro=l(),io=i("hr"),ao=l(),Ue=i("a"),no=l(),c(Ge.$$.fragment),so=l(),We=i("p"),We.innerHTML=fl,uo=l(),Je=i("p"),Je.textContent=hl,co=l(),Qe=i("p"),Qe.innerHTML=_l,mo=l(),Ve=i("p"),Ve.innerHTML=bl,po=l(),Xe=i("table"),Xe.innerHTML=gl,fo=l(),ho=i("hr"),_o=l(),c(Ye.$$.fragment),bo=l(),et=i("p"),this.h()},l(e){const t=xl("svelte-u9bgzb",document.head);g=a(t,"META",{name:!0,content:!0}),t.forEach(d),tt=r(e),Ze=a(e,"P",{}),u(Ze).forEach(d),dt=r(e),w=a(e,"A",{id:!0,class:!0}),u(w).forEach(d),ot=r(e),m(v.$$.fragment,e),lt=r(e),T=a(e,"P",{"data-svelte-h":!0}),n(T)!=="svelte-12buzkq"&&(T.textContent=vo),rt=r(e),y=a(e,"P",{"data-svelte-h":!0}),n(y)!=="svelte-il3kl8"&&(y.textContent=To),it=r(e),$=a(e,"UL",{"data-svelte-h":!0}),n($)!=="svelte-hrpzfw"&&($.innerHTML=yo),at=r(e),nt=a(e,"HR",{}),st=r(e),x=a(e,"A",{id:!0,class:!0}),u(x).forEach(d),ut=r(e),m(H.$$.fragment,e),ct=r(e),M=a(e,"P",{"data-svelte-h":!0}),n(M)!=="svelte-wq5n0b"&&(M.textContent=$o),mt=r(e),L=a(e,"P",{"data-svelte-h":!0}),n(L)!=="svelte-wzwr9x"&&(L.innerHTML=xo),pt=r(e),q=a(e,"TABLE",{"data-svelte-h":!0}),n(q)!=="svelte-1u23bjg"&&(q.innerHTML=Ho),ft=r(e),ht=a(e,"HR",{}),_t=r(e),A=a(e,"A",{id:!0,class:!0}),u(A).forEach(d),bt=r(e),m(C.$$.fragment,e),gt=r(e),P=a(e,"P",{"data-svelte-h":!0}),n(P)!=="svelte-kcz1h5"&&(P.innerHTML=Mo),wt=r(e),vt=a(e,"HR",{}),Tt=r(e),z=a(e,"A",{id:!0,class:!0}),u(z).forEach(d),yt=r(e),m(k.$$.fragment,e),$t=r(e),F=a(e,"P",{"data-svelte-h":!0}),n(F)!=="svelte-13ns2vg"&&(F.innerHTML=Lo),xt=r(e),E=a(e,"P",{"data-svelte-h":!0}),n(E)!=="svelte-187ugov"&&(E.innerHTML=qo),Ht=r(e),R=a(e,"TABLE",{"data-svelte-h":!0}),n(R)!=="svelte-1x4zay3"&&(R.innerHTML=Ao),Mt=r(e),Lt=a(e,"HR",{}),qt=r(e),B=a(e,"A",{id:!0,class:!0}),u(B).forEach(d),At=r(e),m(D.$$.fragment,e),Ct=r(e),I=a(e,"P",{"data-svelte-h":!0}),n(I)!=="svelte-8gymva"&&(I.innerHTML=Co),Pt=r(e),K=a(e,"P",{"data-svelte-h":!0}),n(K)!=="svelte-1dyre01"&&(K.innerHTML=Po),zt=r(e),S=a(e,"TABLE",{"data-svelte-h":!0}),n(S)!=="svelte-io80jx"&&(S.innerHTML=zo),kt=r(e),Ft=a(e,"HR",{}),Et=r(e),j=a(e,"A",{id:!0,class:!0}),u(j).forEach(d),Rt=r(e),m(O.$$.fragment,e),Bt=r(e),N=a(e,"P",{"data-svelte-h":!0}),n(N)!=="svelte-ke4v6b"&&(N.innerHTML=ko),Dt=r(e),U=a(e,"P",{"data-svelte-h":!0}),n(U)!=="svelte-rtofow"&&(U.innerHTML=Fo),It=r(e),G=a(e,"TABLE",{"data-svelte-h":!0}),n(G)!=="svelte-t1r9o1"&&(G.innerHTML=Eo),Kt=r(e),St=a(e,"HR",{}),jt=r(e),W=a(e,"A",{id:!0,class:!0}),u(W).forEach(d),Ot=r(e),m(J.$$.fragment,e),Nt=r(e),Q=a(e,"P",{"data-svelte-h":!0}),n(Q)!=="svelte-10mwufd"&&(Q.textContent=Ro),Ut=r(e),V=a(e,"P",{"data-svelte-h":!0}),n(V)!=="svelte-zfp2ya"&&(V.textContent=Bo),Gt=r(e),X=a(e,"UL",{"data-svelte-h":!0}),n(X)!=="svelte-14mziv8"&&(X.innerHTML=Do),Wt=r(e),Y=a(e,"P",{"data-svelte-h":!0}),n(Y)!=="svelte-iwx6w9"&&(Y.innerHTML=Io),Jt=r(e),Z=a(e,"P",{"data-svelte-h":!0}),n(Z)!=="svelte-1shoq4k"&&(Z.innerHTML=Ko),Qt=r(e),ee=a(e,"TABLE",{"data-svelte-h":!0}),n(ee)!=="svelte-roqmrn"&&(ee.innerHTML=So),Vt=r(e),Xt=a(e,"HR",{}),Yt=r(e),te=a(e,"A",{id:!0,class:!0}),u(te).forEach(d),Zt=r(e),m(de.$$.fragment,e),ed=r(e),oe=a(e,"P",{"data-svelte-h":!0}),n(oe)!=="svelte-13l1rbm"&&(oe.textContent=jo),td=r(e),le=a(e,"P",{"data-svelte-h":!0}),n(le)!=="svelte-9ixqdv"&&(le.innerHTML=Oo),dd=r(e),re=a(e,"TABLE",{"data-svelte-h":!0}),n(re)!=="svelte-h693em"&&(re.innerHTML=No),od=r(e),ld=a(e,"HR",{}),rd=r(e),ie=a(e,"A",{id:!0,class:!0}),u(ie).forEach(d),id=r(e),m(ae.$$.fragment,e),ad=r(e),ne=a(e,"P",{"data-svelte-h":!0}),n(ne)!=="svelte-1lyeqxj"&&(ne.innerHTML=Uo),nd=r(e),se=a(e,"P",{"data-svelte-h":!0}),n(se)!=="svelte-xu9700"&&(se.innerHTML=Go),sd=r(e),ue=a(e,"TABLE",{"data-svelte-h":!0}),n(ue)!=="svelte-11w0boh"&&(ue.innerHTML=Wo),ud=r(e),cd=a(e,"HR",{}),md=r(e),ce=a(e,"A",{id:!0,class:!0}),u(ce).forEach(d),pd=r(e),m(me.$$.fragment,e),fd=r(e),pe=a(e,"P",{"data-svelte-h":!0}),n(pe)!=="svelte-5cebk5"&&(pe.innerHTML=Jo),hd=r(e),fe=a(e,"TABLE",{"data-svelte-h":!0}),n(fe)!=="svelte-1w6ehfm"&&(fe.innerHTML=Qo),_d=r(e),bd=a(e,"HR",{}),gd=r(e),he=a(e,"A",{id:!0,class:!0}),u(he).forEach(d),wd=r(e),m(_e.$$.fragment,e),vd=r(e),be=a(e,"P",{"data-svelte-h":!0}),n(be)!=="svelte-5cebk5"&&(be.innerHTML=Vo),Td=r(e),ge=a(e,"TABLE",{"data-svelte-h":!0}),n(ge)!=="svelte-io7ocd"&&(ge.innerHTML=Xo),yd=r(e),$d=a(e,"HR",{}),xd=r(e),we=a(e,"A",{id:!0,class:!0}),u(we).forEach(d),Hd=r(e),m(ve.$$.fragment,e),Md=r(e),Te=a(e,"P",{"data-svelte-h":!0}),n(Te)!=="svelte-uj0il7"&&(Te.textContent=Yo),Ld=r(e),ye=a(e,"P",{"data-svelte-h":!0}),n(ye)!=="svelte-srmfwi"&&(ye.textContent=Zo),qd=r(e),$e=a(e,"P",{"data-svelte-h":!0}),n($e)!=="svelte-aln42z"&&($e.innerHTML=el),Ad=r(e),xe=a(e,"TABLE",{"data-svelte-h":!0}),n(xe)!=="svelte-2x9dyx"&&(xe.innerHTML=tl),Cd=r(e),Pd=a(e,"HR",{}),zd=r(e),He=a(e,"A",{id:!0,class:!0}),u(He).forEach(d),kd=r(e),m(Me.$$.fragment,e),Fd=r(e),Le=a(e,"P",{"data-svelte-h":!0}),n(Le)!=="svelte-osjtvn"&&(Le.textContent=dl),Ed=r(e),qe=a(e,"P",{"data-svelte-h":!0}),n(qe)!=="svelte-bfmjcl"&&(qe.innerHTML=ol),Rd=r(e),Ae=a(e,"TABLE",{"data-svelte-h":!0}),n(Ae)!=="svelte-c7ztlp"&&(Ae.innerHTML=ll),Bd=r(e),Dd=a(e,"HR",{}),Id=r(e),Ce=a(e,"A",{id:!0,class:!0}),u(Ce).forEach(d),Kd=r(e),m(Pe.$$.fragment,e),Sd=r(e),ze=a(e,"P",{"data-svelte-h":!0}),n(ze)!=="svelte-115nnpl"&&(ze.innerHTML=rl),jd=r(e),ke=a(e,"TABLE",{"data-svelte-h":!0}),n(ke)!=="svelte-6p81mk"&&(ke.innerHTML=il),Od=r(e),Nd=a(e,"HR",{}),Ud=r(e),Fe=a(e,"A",{id:!0,class:!0}),u(Fe).forEach(d),Gd=r(e),m(Ee.$$.fragment,e),Wd=r(e),Re=a(e,"P",{"data-svelte-h":!0}),n(Re)!=="svelte-9t3wul"&&(Re.innerHTML=al),Jd=r(e),Be=a(e,"P",{"data-svelte-h":!0}),n(Be)!=="svelte-5cebk5"&&(Be.innerHTML=nl),Qd=r(e),De=a(e,"TABLE",{"data-svelte-h":!0}),n(De)!=="svelte-heeupf"&&(De.innerHTML=sl),Vd=r(e),Xd=a(e,"HR",{}),Yd=r(e),Ie=a(e,"A",{id:!0,class:!0}),u(Ie).forEach(d),Zd=r(e),m(Ke.$$.fragment,e),eo=r(e),Se=a(e,"P",{"data-svelte-h":!0}),n(Se)!=="svelte-93lmwr"&&(Se.innerHTML=ul),to=r(e),je=a(e,"P",{"data-svelte-h":!0}),n(je)!=="svelte-12zo44d"&&(je.textContent=cl),oo=r(e),Oe=a(e,"P",{"data-svelte-h":!0}),n(Oe)!=="svelte-1d363v6"&&(Oe.innerHTML=ml),lo=r(e),Ne=a(e,"TABLE",{"data-svelte-h":!0}),n(Ne)!=="svelte-1wpe278"&&(Ne.innerHTML=pl),ro=r(e),io=a(e,"HR",{}),ao=r(e),Ue=a(e,"A",{id:!0,class:!0}),u(Ue).forEach(d),no=r(e),m(Ge.$$.fragment,e),so=r(e),We=a(e,"P",{"data-svelte-h":!0}),n(We)!=="svelte-1dxatci"&&(We.innerHTML=fl),uo=r(e),Je=a(e,"P",{"data-svelte-h":!0}),n(Je)!=="svelte-12zo44d"&&(Je.textContent=hl),co=r(e),Qe=a(e,"P",{"data-svelte-h":!0}),n(Qe)!=="svelte-1bxqqp"&&(Qe.innerHTML=_l),mo=r(e),Ve=a(e,"P",{"data-svelte-h":!0}),n(Ve)!=="svelte-1d363v6"&&(Ve.innerHTML=bl),po=r(e),Xe=a(e,"TABLE",{"data-svelte-h":!0}),n(Xe)!=="svelte-h9b3kb"&&(Xe.innerHTML=gl),fo=r(e),ho=a(e,"HR",{}),_o=r(e),m(Ye.$$.fragment,e),bo=r(e),et=a(e,"P",{}),u(et).forEach(d),this.h()},h(){s(g,"name","hf:doc:metadata"),s(g,"content",ql),s(w,"id","module_utils/audio"),s(w,"class","group"),s(x,"id","module_utils/audio.read_audio"),s(x,"class","group"),s(A,"id","module_utils/audio.read_audio..audio"),s(A,"class","group"),s(z,"id","module_utils/audio.hanning"),s(z,"class","group"),s(B,"id","module_utils/audio.hamming"),s(B,"class","group"),s(j,"id","module_utils/audio.mel_filter_bank"),s(j,"class","group"),s(W,"id","module_utils/audio.spectrogram"),s(W,"class","group"),s(te,"id","module_utils/audio.window_function"),s(te,"class","group"),s(ie,"id","module_utils/audio..generalized_cosine_window"),s(ie,"class","group"),s(ce,"id","module_utils/audio..hertz_to_mel"),s(ce,"class","group"),s(he,"id","module_utils/audio..mel_to_hertz"),s(he,"class","group"),s(we,"id","module_utils/audio.._create_triangular_filter_bank"),s(we,"class","group"),s(He,"id","module_utils/audio..linspace"),s(He,"class","group"),s(Ce,"id","module_utils/audio..padReflect"),s(Ce,"class","group"),s(Fe,"id","module_utils/audio.._db_conversion_helper"),s(Fe,"class","group"),s(Ie,"id","module_utils/audio..amplitude_to_db"),s(Ie,"class","group"),s(Ue,"id","module_utils/audio..power_to_db"),s(Ue,"class","group")},m(e,t){Hl(document.head,g),o(e,tt,t),o(e,Ze,t),o(e,dt,t),o(e,w,t),o(e,ot,t),p(v,e,t),o(e,lt,t),o(e,T,t),o(e,rt,t),o(e,y,t),o(e,it,t),o(e,$,t),o(e,at,t),o(e,nt,t),o(e,st,t),o(e,x,t),o(e,ut,t),p(H,e,t),o(e,ct,t),o(e,M,t),o(e,mt,t),o(e,L,t),o(e,pt,t),o(e,q,t),o(e,ft,t),o(e,ht,t),o(e,_t,t),o(e,A,t),o(e,bt,t),p(C,e,t),o(e,gt,t),o(e,P,t),o(e,wt,t),o(e,vt,t),o(e,Tt,t),o(e,z,t),o(e,yt,t),p(k,e,t),o(e,$t,t),o(e,F,t),o(e,xt,t),o(e,E,t),o(e,Ht,t),o(e,R,t),o(e,Mt,t),o(e,Lt,t),o(e,qt,t),o(e,B,t),o(e,At,t),p(D,e,t),o(e,Ct,t),o(e,I,t),o(e,Pt,t),o(e,K,t),o(e,zt,t),o(e,S,t),o(e,kt,t),o(e,Ft,t),o(e,Et,t),o(e,j,t),o(e,Rt,t),p(O,e,t),o(e,Bt,t),o(e,N,t),o(e,Dt,t),o(e,U,t),o(e,It,t),o(e,G,t),o(e,Kt,t),o(e,St,t),o(e,jt,t),o(e,W,t),o(e,Ot,t),p(J,e,t),o(e,Nt,t),o(e,Q,t),o(e,Ut,t),o(e,V,t),o(e,Gt,t),o(e,X,t),o(e,Wt,t),o(e,Y,t),o(e,Jt,t),o(e,Z,t),o(e,Qt,t),o(e,ee,t),o(e,Vt,t),o(e,Xt,t),o(e,Yt,t),o(e,te,t),o(e,Zt,t),p(de,e,t),o(e,ed,t),o(e,oe,t),o(e,td,t),o(e,le,t),o(e,dd,t),o(e,re,t),o(e,od,t),o(e,ld,t),o(e,rd,t),o(e,ie,t),o(e,id,t),p(ae,e,t),o(e,ad,t),o(e,ne,t),o(e,nd,t),o(e,se,t),o(e,sd,t),o(e,ue,t),o(e,ud,t),o(e,cd,t),o(e,md,t),o(e,ce,t),o(e,pd,t),p(me,e,t),o(e,fd,t),o(e,pe,t),o(e,hd,t),o(e,fe,t),o(e,_d,t),o(e,bd,t),o(e,gd,t),o(e,he,t),o(e,wd,t),p(_e,e,t),o(e,vd,t),o(e,be,t),o(e,Td,t),o(e,ge,t),o(e,yd,t),o(e,$d,t),o(e,xd,t),o(e,we,t),o(e,Hd,t),p(ve,e,t),o(e,Md,t),o(e,Te,t),o(e,Ld,t),o(e,ye,t),o(e,qd,t),o(e,$e,t),o(e,Ad,t),o(e,xe,t),o(e,Cd,t),o(e,Pd,t),o(e,zd,t),o(e,He,t),o(e,kd,t),p(Me,e,t),o(e,Fd,t),o(e,Le,t),o(e,Ed,t),o(e,qe,t),o(e,Rd,t),o(e,Ae,t),o(e,Bd,t),o(e,Dd,t),o(e,Id,t),o(e,Ce,t),o(e,Kd,t),p(Pe,e,t),o(e,Sd,t),o(e,ze,t),o(e,jd,t),o(e,ke,t),o(e,Od,t),o(e,Nd,t),o(e,Ud,t),o(e,Fe,t),o(e,Gd,t),p(Ee,e,t),o(e,Wd,t),o(e,Re,t),o(e,Jd,t),o(e,Be,t),o(e,Qd,t),o(e,De,t),o(e,Vd,t),o(e,Xd,t),o(e,Yd,t),o(e,Ie,t),o(e,Zd,t),p(Ke,e,t),o(e,eo,t),o(e,Se,t),o(e,to,t),o(e,je,t),o(e,oo,t),o(e,Oe,t),o(e,lo,t),o(e,Ne,t),o(e,ro,t),o(e,io,t),o(e,ao,t),o(e,Ue,t),o(e,no,t),p(Ge,e,t),o(e,so,t),o(e,We,t),o(e,uo,t),o(e,Je,t),o(e,co,t),o(e,Qe,t),o(e,mo,t),o(e,Ve,t),o(e,po,t),o(e,Xe,t),o(e,fo,t),o(e,ho,t),o(e,_o,t),p(Ye,e,t),o(e,bo,t),o(e,et,t),go=!0},p:vl,i(e){go||(f(v.$$.fragment,e),f(H.$$.fragment,e),f(C.$$.fragment,e),f(k.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(J.$$.fragment,e),f(de.$$.fragment,e),f(ae.$$.fragment,e),f(me.$$.fragment,e),f(_e.$$.fragment,e),f(ve.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ke.$$.fragment,e),f(Ge.$$.fragment,e),f(Ye.$$.fragment,e),go=!0)},o(e){h(v.$$.fragment,e),h(H.$$.fragment,e),h(C.$$.fragment,e),h(k.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(J.$$.fragment,e),h(de.$$.fragment,e),h(ae.$$.fragment,e),h(me.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(Me.$$.fragment,e),h(Pe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ke.$$.fragment,e),h(Ge.$$.fragment,e),h(Ye.$$.fragment,e),go=!1},d(e){e&&(d(tt),d(Ze),d(dt),d(w),d(ot),d(lt),d(T),d(rt),d(y),d(it),d($),d(at),d(nt),d(st),d(x),d(ut),d(ct),d(M),d(mt),d(L),d(pt),d(q),d(ft),d(ht),d(_t),d(A),d(bt),d(gt),d(P),d(wt),d(vt),d(Tt),d(z),d(yt),d($t),d(F),d(xt),d(E),d(Ht),d(R),d(Mt),d(Lt),d(qt),d(B),d(At),d(Ct),d(I),d(Pt),d(K),d(zt),d(S),d(kt),d(Ft),d(Et),d(j),d(Rt),d(Bt),d(N),d(Dt),d(U),d(It),d(G),d(Kt),d(St),d(jt),d(W),d(Ot),d(Nt),d(Q),d(Ut),d(V),d(Gt),d(X),d(Wt),d(Y),d(Jt),d(Z),d(Qt),d(ee),d(Vt),d(Xt),d(Yt),d(te),d(Zt),d(ed),d(oe),d(td),d(le),d(dd),d(re),d(od),d(ld),d(rd),d(ie),d(id),d(ad),d(ne),d(nd),d(se),d(sd),d(ue),d(ud),d(cd),d(md),d(ce),d(pd),d(fd),d(pe),d(hd),d(fe),d(_d),d(bd),d(gd),d(he),d(wd),d(vd),d(be),d(Td),d(ge),d(yd),d($d),d(xd),d(we),d(Hd),d(Md),d(Te),d(Ld),d(ye),d(qd),d($e),d(Ad),d(xe),d(Cd),d(Pd),d(zd),d(He),d(kd),d(Fd),d(Le),d(Ed),d(qe),d(Rd),d(Ae),d(Bd),d(Dd),d(Id),d(Ce),d(Kd),d(Sd),d(ze),d(jd),d(ke),d(Od),d(Nd),d(Ud),d(Fe),d(Gd),d(Wd),d(Re),d(Jd),d(Be),d(Qd),d(De),d(Vd),d(Xd),d(Yd),d(Ie),d(Zd),d(eo),d(Se),d(to),d(je),d(oo),d(Oe),d(lo),d(Ne),d(ro),d(io),d(ao),d(Ue),d(no),d(so),d(We),d(uo),d(Je),d(co),d(Qe),d(mo),d(Ve),d(po),d(Xe),d(fo),d(ho),d(_o),d(bo),d(et)),d(g),_(v,e),_(H,e),_(C,e),_(k,e),_(D,e),_(O,e),_(J,e),_(de,e),_(ae,e),_(me,e),_(_e,e),_(ve,e),_(Me,e),_(Pe,e),_(Ee,e),_(Ke,e),_(Ge,e),_(Ye,e)}}}const ql='{"title":"utils/audio","local":"utilsaudio","sections":[{"title":"utils/audio.read_audio(url, sampling_rate) ⇒ <code> Promise. < Float32Array > </code>","local":"utilsaudioreadaudiourl-samplingrate--code-promise--float32array--code","sections":[{"title":"read_audio~audio : <code> Float32Array </code>","local":"readaudioaudio--code-float32array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/audio.hanning(M) ⇒ <code> Float64Array </code>","local":"utilsaudiohanningm--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio.hamming(M) ⇒ <code> Float64Array </code>","local":"utilsaudiohammingm--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space]) ⇒ <code> Array. < Array < number > > </code>","local":"utilsaudiomelfilterbanknumfrequencybins-nummelfilters-minfrequency-maxfrequency-samplingrate-norm-melscale-triangularizeinmelspace--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/audio.spectrogram(waveform, window, frame_length, hop_length, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilsaudiospectrogramwaveform-window-framelength-hoplength-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/audio.window_function(window_length, name, options) ⇒ <code> Float64Array </code>","local":"utilsaudiowindowfunctionwindowlength-name-options--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio~generalized_cosine_window(M, a_0) ⇒ <code> Float64Array </code>","local":"utilsaudiogeneralizedcosinewindowm-a0--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio~hertz_to_mel(freq, [mel_scale]) ⇒ <code> T </code>","local":"utilsaudiohertztomelfreq-melscale--code-t-code","sections":[],"depth":2},{"title":"utils/audio~mel_to_hertz(mels, [mel_scale]) ⇒ <code> T </code>","local":"utilsaudiomeltohertzmels-melscale--code-t-code","sections":[],"depth":2},{"title":"utils/audio~_create_triangular_filter_bank(fft_freqs, filter_freqs) ⇒ <code> Array. < Array < number > > </code>","local":"utilsaudiocreatetriangularfilterbankfftfreqs-filterfreqs--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/audio~linspace(start, end, num) ⇒","local":"utilsaudiolinspacestart-end-num-","sections":[],"depth":2},{"title":"utils/audio~padReflect(array, left, right) ⇒ <code> T </code>","local":"utilsaudiopadreflectarray-left-right--code-t-code","sections":[],"depth":2},{"title":"utils/audio~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range) ⇒ <code> T </code>","local":"utilsaudiodbconversionhelperspectrogram-factor-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~amplitude_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>","local":"utilsaudioamplitudetodbspectrogram-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~power_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>","local":"utilsaudiopowertodbspectrogram-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2}],"depth":1}';function Al(wo){return Tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends yl{constructor(g){super(),$l(this,g,Al,Ll,wl,{})}}export{kl as component};
