import{s as is,o as ps,n as rs}from"../chunks/scheduler.0219f8bd.js";import{S as cs,i as ms,g as m,s as n,r as T,A as Ms,h as M,f as l,c as o,j as ns,u as U,x as J,k as os,y as ws,a,v as h,d,t as j,w as b}from"../chunks/index.f61edf3b.js";import{T as ys}from"../chunks/Tip.5d1e3ef4.js";import{C as q}from"../chunks/CodeBlock.38e566ae.js";import{H as O,E as us}from"../chunks/EditOnGithub.48fa589f.js";function Js(B){let i,f=`<br/>
As of October 2024, global WebGPU support is around 70% (according to <a href="https://caniuse.com/webgpu" rel="nofollow">caniuse.com</a>), meaning some users may not be able to use the API.`,w,c,y="If the following demos do not work in your browser, you may need to enable it using a feature flag:",u,p,Q='<li>Firefox: with the <code>dom.webgpu.enabled</code> flag (see <a href="https://developer.mozilla.org/en-US/docs/Mozilla/Firefox/Experimental_features#:~:text=tested%20by%20Firefox.-,WebGPU%20API,-The%20WebGPU%20API" rel="nofollow">here</a>).</li> <li>Safari: with the <code>WebGPU</code> feature flag (see <a href="https://webkit.org/blog/14879/webgpu-now-available-for-testing-in-safari-technology-preview/" rel="nofollow">here</a>).</li> <li>Older Chromium browsers (on Windows, macOS, Linux): with the <code>enable-unsafe-webgpu</code> flag (see <a href="https://developer.chrome.com/docs/web-platform/webgpu/troubleshooting-tips" rel="nofollow">here</a>).</li>';return{c(){i=m("p"),i.innerHTML=f,w=n(),c=m("p"),c.textContent=y,u=n(),p=m("ul"),p.innerHTML=Q},l(t){i=M(t,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1iuesxc"&&(i.innerHTML=f),w=o(t),c=M(t,"P",{"data-svelte-h":!0}),J(c)!=="svelte-mcs3ta"&&(c.textContent=y),u=o(t),p=M(t,"UL",{"data-svelte-h":!0}),J(p)!=="svelte-ty8cnp"&&(p.innerHTML=Q)},m(t,r){a(t,i,r),a(t,w,r),a(t,c,r),a(t,u,r),a(t,p,r)},p:rs,d(t){t&&(l(i),l(w),l(c),l(u),l(p))}}}function Ts(B){let i,f,w,c,y,u,p,Q='WebGPU is a new web standard for accelerated graphics and compute. The <a href="https://developer.mozilla.org/en-US/docs/Web/API/WebGPU_API" rel="nofollow">API</a> enables web developers to use the underlying system’s GPU to carry out high-performance computations directly in the browser. WebGPU is the successor to <a href="https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API" rel="nofollow">WebGL</a> and provides significantly better performance, because it allows for more direct interaction with modern GPUs. Lastly, it supports general-purpose GPU computations, which makes it just perfect for machine learning!',t,r,E,g,R,I,K='Thanks to our collaboration with <a href="https://www.npmjs.com/package/onnxruntime-web" rel="nofollow">ONNX Runtime Web</a>, enabling WebGPU acceleration is as simple as setting <code>device: &#39;webgpu&#39;</code> when loading a model. Let’s see some examples!',z,W,ss='<strong>Example:</strong> Compute text embeddings on WebGPU (<a href="https://v2.scrimba.com/s06a2smeej" rel="nofollow">demo</a>)',H,G,A,k,es='<strong>Example:</strong> Perform automatic speech recognition with OpenAI whisper on WebGPU (<a href="https://v2.scrimba.com/s0oi76h82g" rel="nofollow">demo</a>)',S,N,V,v,ls='<strong>Example:</strong> Perform image classification with MobileNetV4 on WebGPU (<a href="https://v2.scrimba.com/s0fv2uab1t" rel="nofollow">demo</a>)',_,C,L,Z,P,Y,as='Due to the experimental nature of WebGPU, especially in non-Chromium browsers, you may experience issues when trying to run a model (even it it can run in WASM). If you do, please open <a href="https://github.com/huggingface/transformers.js/issues/new?title=%5BWebGPU%5D%20Error%20running%20MODEL_GOES_HERE&amp;assignees=&amp;labels=bug,webgpu&amp;projects=&amp;template=1_bug-report.yml" rel="nofollow">an issue on GitHub</a> and we’ll do our best to address it. Thanks!',F,x,D,$,X;return y=new O({props:{title:"Running models on WebGPU",local:"running-models-on-webgpu",headingTag:"h1"}}),r=new ys({props:{warning:!0,$$slots:{default:[Js]},$$scope:{ctx:B}}}),g=new O({props:{title:"Usage in Transformers.js v3",local:"usage-in-transformersjs-v3",headingTag:"h2"}}),G=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBhJTIwZmVhdHVyZS1leHRyYWN0aW9uJTIwcGlwZWxpbmUlMEFjb25zdCUyMGV4dHJhY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyJTJDJTBBJTIwJTIwJTIybWl4ZWRicmVhZC1haSUyRm14YmFpLWVtYmVkLXhzbWFsbC12MSUyMiUyQyUwQSUyMCUyMCU3QiUyMGRldmljZSUzQSUyMCUyMndlYmdwdSUyMiUyMCU3RCUyQyUwQSklM0IlMEElMEElMkYlMkYlMjBDb21wdXRlJTIwZW1iZWRkaW5ncyUwQWNvbnN0JTIwdGV4dHMlMjAlM0QlMjAlNUIlMjJIZWxsbyUyMHdvcmxkISUyMiUyQyUyMCUyMlRoaXMlMjBpcyUyMGFuJTIwZXhhbXBsZSUyMHNlbnRlbmNlLiUyMiU1RCUzQiUwQWNvbnN0JTIwZW1iZWRkaW5ncyUyMCUzRCUyMGF3YWl0JTIwZXh0cmFjdG9yKHRleHRzJTJDJTIwJTdCJTIwcG9vbGluZyUzQSUyMCUyMm1lYW4lMjIlMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQWNvbnNvbGUubG9nKGVtYmVkZGluZ3MudG9saXN0KCkpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTVCLTAuMDE2OTg2MTgzODIyMTU1JTJDJTIwMC4wMzIyODY5NjgwODIxODk1NiUyQyUyMC0wLjAwMTM2MzA5NjY0MjMwNzkzNzElMkMlMjAuLi4lMjAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjAlNUIwLjA5MDUwNDgyNTExNTIwMzg2JTJDJTIwMC4wNzIwNzM4Njk0MDcxNzY5NyUyQyUyMDAuMDU3NjI3NDk5MTAzNTQ2MTQlMkMlMjAuLi4lMjAlNUQlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create a feature-extraction pipeline</span>
<span class="hljs-keyword">const</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;feature-extraction&quot;</span>,
  <span class="hljs-string">&quot;mixedbread-ai/mxbai-embed-xsmall-v1&quot;</span>,
  { <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span> },
);

<span class="hljs-comment">// Compute embeddings</span>
<span class="hljs-keyword">const</span> texts = [<span class="hljs-string">&quot;Hello world!&quot;</span>, <span class="hljs-string">&quot;This is an example sentence.&quot;</span>];
<span class="hljs-keyword">const</span> embeddings = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(texts, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&quot;mean&quot;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(embeddings.<span class="hljs-title function_">tolist</span>());
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   [-0.016986183822155, 0.03228696808218956, -0.0013630966423079371, ... ],</span>
<span class="hljs-comment">//   [0.09050482511520386, 0.07207386940717697, 0.05762749910354614, ... ],</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),N=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBhdXRvbWF0aWMlMjBzcGVlY2glMjByZWNvZ25pdGlvbiUyMHBpcGVsaW5lJTBBY29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUwQSUyMCUyMCUyMm9ubngtY29tbXVuaXR5JTJGd2hpc3Blci10aW55LmVuJTIyJTJDJTBBJTIwJTIwJTdCJTIwZGV2aWNlJTNBJTIwJTIyd2ViZ3B1JTIyJTIwJTdEJTJDJTBBKSUzQiUwQSUwQSUyRiUyRiUyMFRyYW5zY3JpYmUlMjBhdWRpbyUyMGZyb20lMjBhJTIwVVJMJTBBY29uc3QlMjB1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZYZW5vdmElMkZ0cmFuc2Zvcm1lcnMuanMtZG9jcyUyRnJlc29sdmUlMkZtYWluJTJGamZrLndhdiUyMiUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwpJTNCJTBBY29uc29sZS5sb2cob3V0cHV0KSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAnJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJyUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create automatic speech recognition pipeline</span>
<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
  <span class="hljs-string">&quot;onnx-community/whisper-tiny.en&quot;</span>,
  { <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span> },
);

<span class="hljs-comment">// Transcribe audio from a URL</span>
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&quot;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&quot;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output);
<span class="hljs-comment">// { text: &#x27; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&#x27; }</span>`,wrap:!1}}),C=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTIwcGlwZWxpbmUlMEFjb25zdCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIyb25ueC1jb21tdW5pdHklMkZtb2JpbGVuZXR2NF9jb252X3NtYWxsLmUyNDAwX3IyMjRfaW4xayUyMiUyQyUwQSUyMCUyMCU3QiUyMGRldmljZSUzQSUyMCUyMndlYmdwdSUyMiUyMCU3RCUyQyUwQSklM0IlMEElMEElMkYlMkYlMjBDbGFzc2lmeSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMFVSTCUwQWNvbnN0JTIwdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRpZ2VyLmpwZyUyMiUzQiUwQWNvbnN0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEFjb25zb2xlLmxvZyhvdXRwdXQpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAndGlnZXIlMkMlMjBQYW50aGVyYSUyMHRpZ3JpcyclMkMlMjBzY29yZSUzQSUyMDAuNjE0OTc4NDkyMjU5OTc5MiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zMDI4MTczNDQ2NjU1MjczNCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RhYmJ5JTJDJTIwdGFiYnklMjBjYXQnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTkxMzU0MjI3NzE3OTY1ODQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCdseW54JTJDJTIwY2F0YW1vdW50JyUyQyUyMHNjb3JlJTNBJTIwMC4wMDEyMTYxMjY2MDU4NjgzMzk1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnRWd5cHRpYW4lMjBjYXQnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTE0NjU5NjE1NzkyMzM0MDglMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create image classification pipeline</span>
<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;image-classification&quot;</span>,
  <span class="hljs-string">&quot;onnx-community/mobilenetv4_conv_small.e2400_r224_in1k&quot;</span>,
  { <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span> },
);

<span class="hljs-comment">// Classify an image from a URL</span>
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&quot;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&quot;</span>;
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.6149784922599792 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.30281734466552734 },</span>
<span class="hljs-comment">//   { label: &#x27;tabby, tabby cat&#x27;, score: 0.0019135422771796584 },</span>
<span class="hljs-comment">//   { label: &#x27;lynx, catamount&#x27;, score: 0.0012161266058683395 },</span>
<span class="hljs-comment">//   { label: &#x27;Egyptian cat&#x27;, score: 0.0011465961579233408 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Z=new O({props:{title:"Reporting bugs and providing feedback",local:"reporting-bugs-and-providing-feedback",headingTag:"h2"}}),x=new us({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/guides/webgpu.md"}}),{c(){i=m("meta"),f=n(),w=m("p"),c=n(),T(y.$$.fragment),u=n(),p=m("p"),p.innerHTML=Q,t=n(),T(r.$$.fragment),E=n(),T(g.$$.fragment),R=n(),I=m("p"),I.innerHTML=K,z=n(),W=m("p"),W.innerHTML=ss,H=n(),T(G.$$.fragment),A=n(),k=m("p"),k.innerHTML=es,S=n(),T(N.$$.fragment),V=n(),v=m("p"),v.innerHTML=ls,_=n(),T(C.$$.fragment),L=n(),T(Z.$$.fragment),P=n(),Y=m("p"),Y.innerHTML=as,F=n(),T(x.$$.fragment),D=n(),$=m("p"),this.h()},l(s){const e=Ms("svelte-u9bgzb",document.head);i=M(e,"META",{name:!0,content:!0}),e.forEach(l),f=o(s),w=M(s,"P",{}),ns(w).forEach(l),c=o(s),U(y.$$.fragment,s),u=o(s),p=M(s,"P",{"data-svelte-h":!0}),J(p)!=="svelte-19qhkg2"&&(p.innerHTML=Q),t=o(s),U(r.$$.fragment,s),E=o(s),U(g.$$.fragment,s),R=o(s),I=M(s,"P",{"data-svelte-h":!0}),J(I)!=="svelte-1dmideb"&&(I.innerHTML=K),z=o(s),W=M(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1sxt5g1"&&(W.innerHTML=ss),H=o(s),U(G.$$.fragment,s),A=o(s),k=M(s,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1jn61pt"&&(k.innerHTML=es),S=o(s),U(N.$$.fragment,s),V=o(s),v=M(s,"P",{"data-svelte-h":!0}),J(v)!=="svelte-1rgic84"&&(v.innerHTML=ls),_=o(s),U(C.$$.fragment,s),L=o(s),U(Z.$$.fragment,s),P=o(s),Y=M(s,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-h8vsz1"&&(Y.innerHTML=as),F=o(s),U(x.$$.fragment,s),D=o(s),$=M(s,"P",{}),ns($).forEach(l),this.h()},h(){os(i,"name","hf:doc:metadata"),os(i,"content",Us)},m(s,e){ws(document.head,i),a(s,f,e),a(s,w,e),a(s,c,e),h(y,s,e),a(s,u,e),a(s,p,e),a(s,t,e),h(r,s,e),a(s,E,e),h(g,s,e),a(s,R,e),a(s,I,e),a(s,z,e),a(s,W,e),a(s,H,e),h(G,s,e),a(s,A,e),a(s,k,e),a(s,S,e),h(N,s,e),a(s,V,e),a(s,v,e),a(s,_,e),h(C,s,e),a(s,L,e),h(Z,s,e),a(s,P,e),a(s,Y,e),a(s,F,e),h(x,s,e),a(s,D,e),a(s,$,e),X=!0},p(s,[e]){const ts={};e&2&&(ts.$$scope={dirty:e,ctx:s}),r.$set(ts)},i(s){X||(d(y.$$.fragment,s),d(r.$$.fragment,s),d(g.$$.fragment,s),d(G.$$.fragment,s),d(N.$$.fragment,s),d(C.$$.fragment,s),d(Z.$$.fragment,s),d(x.$$.fragment,s),X=!0)},o(s){j(y.$$.fragment,s),j(r.$$.fragment,s),j(g.$$.fragment,s),j(G.$$.fragment,s),j(N.$$.fragment,s),j(C.$$.fragment,s),j(Z.$$.fragment,s),j(x.$$.fragment,s),X=!1},d(s){s&&(l(f),l(w),l(c),l(u),l(p),l(t),l(E),l(R),l(I),l(z),l(W),l(H),l(A),l(k),l(S),l(V),l(v),l(_),l(L),l(P),l(Y),l(F),l(D),l($)),l(i),b(y,s),b(r,s),b(g,s),b(G,s),b(N,s),b(C,s),b(Z,s),b(x,s)}}}const Us='{"title":"Running models on WebGPU","local":"running-models-on-webgpu","sections":[{"title":"Usage in Transformers.js v3","local":"usage-in-transformersjs-v3","sections":[],"depth":2},{"title":"Reporting bugs and providing feedback","local":"reporting-bugs-and-providing-feedback","sections":[],"depth":2}],"depth":1}';function hs(B){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends cs{constructor(i){super(),ms(this,i,hs,Ts,is,{})}}export{Is as component};
