import{s as Qn,o as En,n as st}from"../chunks/scheduler.25b97de1.js";import{S as Gn,i as On,g as i,s,r as h,A as Rn,h as l,f as o,c as r,j as M,u,x as b,k as S,y as t,a as c,v as f,d as g,t as _,w as k}from"../chunks/index.d9030fc9.js";import{T as hn}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.e257edda.js";import{C as fn}from"../chunks/CodeBlock.e6cd0d95.js";import{E as un}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as B,E as Dn}from"../chunks/EditOnGithub.91d95064.js";function Xn(x){let a,T="Example:",p,m,w;return m=new fn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwbGludGVyTW9kZWwlMkMlMjBTcGxpbnRlckNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTcGxpbnRlciUyMHRhdSUyRnNwbGludGVyLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3BsaW50ZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB0YXUlMkZzcGxpbnRlci1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTcGxpbnRlck1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SplinterModel, SplinterConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Splinter tau/splinter-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SplinterConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the tau/splinter-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=i("p"),a.textContent=T,p=s(),h(m.$$.fragment)},l(d){a=l(d,"P",{"data-svelte-h":!0}),b(a)!=="svelte-11lpom8"&&(a.textContent=T),p=r(d),u(m.$$.fragment,d)},m(d,v){c(d,a,v),c(d,p,v),f(m,d,v),w=!0},p:st,i(d){w||(g(m.$$.fragment,d),w=!0)},o(d){_(m.$$.fragment,d),w=!1},d(d){d&&(o(a),o(p)),k(m,d)}}}function Vn(x){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=T},l(p){a=l(p,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(p,m){c(p,a,m)},p:st,d(p){p&&o(a)}}}function Yn(x){let a,T="Example:",p,m,w;return m=new fn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcGxpbnRlck1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0YXUlMkZzcGxpbnRlci1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwU3BsaW50ZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydGF1JTJGc3BsaW50ZXItYmFzZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SplinterModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterModel.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){a=i("p"),a.textContent=T,p=s(),h(m.$$.fragment)},l(d){a=l(d,"P",{"data-svelte-h":!0}),b(a)!=="svelte-11lpom8"&&(a.textContent=T),p=r(d),u(m.$$.fragment,d)},m(d,v){c(d,a,v),c(d,p,v),f(m,d,v),w=!0},p:st,i(d){w||(g(m.$$.fragment,d),w=!0)},o(d){_(m.$$.fragment,d),w=!1},d(d){d&&(o(a),o(p)),k(m,d)}}}function Kn(x){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=T},l(p){a=l(p,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(p,m){c(p,a,m)},p:st,d(p){p&&o(a)}}}function eo(x){let a,T="Example:",p,m,w;return m=new fn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcGxpbnRlckZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0YXUlMkZzcGxpbnRlci1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwU3BsaW50ZXJGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIydGF1JTJGc3BsaW50ZXItYmFzZSUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcyU1QjAlMkMlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfZW5kX2luZGV4JTIwJTJCJTIwMSU1RCUwQSUwQSUyMyUyMHRhcmdldCUyMGlzJTIwJTIybmljZSUyMHB1cHBldCUyMiUwQXRhcmdldF9zdGFydF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNCU1RCklMEF0YXJnZXRfZW5kX2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE1JTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SplinterForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){a=i("p"),a.textContent=T,p=s(),h(m.$$.fragment)},l(d){a=l(d,"P",{"data-svelte-h":!0}),b(a)!=="svelte-11lpom8"&&(a.textContent=T),p=r(d),u(m.$$.fragment,d)},m(d,v){c(d,a,v),c(d,p,v),f(m,d,v),w=!0},p:st,i(d){w||(g(m.$$.fragment,d),w=!0)},o(d){_(m.$$.fragment,d),w=!1},d(d){d&&(o(a),o(p)),k(m,d)}}}function to(x){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=T},l(p){a=l(p,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(p,m){c(p,a,m)},p:st,d(p){p&&o(a)}}}function no(x){let a,T,p,m,w,d,v,it,oe,gn=`The Splinter model was proposed in <a href="https://arxiv.org/abs/2101.00438" rel="nofollow">Few-Shot Question Answering by Pretraining Span Selection</a> by Ori Ram, Yuval Kirstain, Jonathan Berant, Amir Globerson, Omer Levy. Splinter
is an encoder-only transformer (similar to BERT) pretrained using the recurring span selection task on a large corpus
comprising Wikipedia and the Toronto Book Corpus.`,lt,se,_n="The abstract from the paper is the following:",dt,re,kn=`In several question answering benchmarks, pretrained models have reached human parity through fine-tuning on an order
of 100,000 annotated questions and answers. We explore the more realistic few-shot setting, where only a few hundred
training examples are available, and observe that standard models perform poorly, highlighting the discrepancy between
current pretraining objectives and question answering. We propose a new pretraining scheme tailored for question
answering: recurring span selection. Given a passage with multiple sets of recurring spans, we mask in each set all
recurring spans but one, and ask the model to select the correct span in the passage for each masked span. Masked spans
are replaced with a special token, viewed as a question representation, that is later used during fine-tuning to select
the answer span. The resulting model obtains surprisingly good results on multiple benchmarks (e.g., 72.7 F1 on SQuAD
with only 128 training examples), while maintaining competitive performance in the high-resource setting.`,ct,ae,bn='This model was contributed by <a href="https://huggingface.co/yuvalkirstain" rel="nofollow">yuvalkirstain</a> and <a href="https://huggingface.co/oriram" rel="nofollow">oriram</a>. The original code can be found <a href="https://github.com/oriram/splinter" rel="nofollow">here</a>.',pt,ie,mt,le,Tn=`<li>Splinter was trained to predict answers spans conditioned on a special [QUESTION] token. These tokens contextualize
to question representations which are used to predict the answers. This layer is called QASS, and is the default
behaviour in the <a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> class. Therefore:</li> <li>Use <a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterTokenizer">SplinterTokenizer</a> (rather than <a href="/docs/transformers/pr_30862/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>), as it already
contains this special token. Also, its default behavior is to use this token when two sequences are given (for
example, in the <em>run_qa.py</em> script).</li> <li>If you plan on using Splinter outside <em>run_qa.py</em>, please keep in mind the question token - it might be important for
the success of your model, especially in a few-shot setting.</li> <li>Please note there are two different checkpoints for each size of Splinter. Both are basically the same, except that
one also has the pretrained weights of the QASS layer (<em>tau/splinter-base-qass</em> and <em>tau/splinter-large-qass</em>) and one
doesn’t (<em>tau/splinter-base</em> and <em>tau/splinter-large</em>). This is done to support randomly initializing this layer at
fine-tuning, as it is shown to yield better results for some cases in the paper.</li>`,ht,de,ut,ce,wn='<li><a href="../tasks/question-answering">Question answering task guide</a></li>',ft,pe,gt,q,me,Ct,Le,vn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>. It is used to instantiate an
Splinter model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Splinter
<a href="https://huggingface.co/tau/splinter-base" rel="nofollow">tau/splinter-base</a> architecture.`,Ft,Pe,yn=`Configuration objects inherit from <a href="/docs/transformers/pr_30862/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30862/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,It,Q,_t,he,kt,y,ue,Lt,je,$n="Construct a Splinter tokenizer. Based on WordPiece.",Pt,Ue,Mn=`This tokenizer inherits from <a href="/docs/transformers/pr_30862/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,jt,W,fe,Ut,We,Sn=`Build model inputs from a pair of sequence for question answering tasks by concatenating and adding special
tokens. A Splinter sequence has the following format:`,Wt,Je,xn="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences for question answering: <code>[CLS] question_tokens [QUESTION] . [SEP] context_tokens [SEP]</code></li>",Jt,E,ge,At,Ae,zn=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Nt,J,_e,Bt,Ne,qn=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,Ht,Be,Cn="Should be overridden in a subclass if the model has a special way of building those.",Zt,He,ke,bt,be,Tt,C,Te,Qt,Ze,Fn="Construct a “fast” Splinter tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on WordPiece.",Et,Qe,In=`This tokenizer inherits from <a href="/docs/transformers/pr_30862/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Gt,A,we,Ot,Ee,Ln=`Build model inputs from a pair of sequence for question answering tasks by concatenating and adding special
tokens. A Splinter sequence has the following format:`,Rt,Ge,Pn="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences for question answering: <code>[CLS] question_tokens [QUESTION] . [SEP] context_tokens [SEP]</code></li>",wt,ve,vt,F,ye,Dt,Oe,jn=`The bare Splinter Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Xt,Re,Un=`The model is an encoder (with only self-attention) following the architecture described in <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">Attention is all you
need</a> by Ashish Vaswani, Noam Shazeer, Niki Parmar, Jakob Uszkoreit, Llion Jones,
Aidan N. Gomez, Lukasz Kaiser and Illia Polosukhin.`,Vt,P,$e,Yt,De,Wn='The <a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> forward method, overrides the <code>__call__</code> special method.',Kt,G,en,O,yt,Me,$t,I,Se,tn,Xe,Jn=`Splinter Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,nn,Ve,An=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,on,j,xe,sn,Ye,Nn='The <a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',rn,R,an,D,Mt,ze,St,L,qe,ln,Ke,Bn=`Splinter Model for the recurring span selection task as done during the pretraining. The difference to the QA task
is that we do not have a question, but multiple question tokens that replace the occurrences of recurring spans
instead.`,dn,et,Hn=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,cn,N,Ce,pn,tt,Zn='The <a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',mn,X,xt,Fe,zt,rt,qt;return w=new B({props:{title:"Splinter",local:"splinter",headingTag:"h1"}}),v=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ie=new B({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),de=new B({props:{title:"Resources",local:"resources",headingTag:"h2"}}),pe=new B({props:{title:"SplinterConfig",local:"transformers.SplinterConfig",headingTag:"h2"}}),me=new z({props:{name:"class transformers.SplinterConfig",anchor:"transformers.SplinterConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"question_token_id",val:" = 104"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the Splinter model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>.`,name:"vocab_size"},{anchor:"transformers.SplinterConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SplinterConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SplinterConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SplinterConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.SplinterConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SplinterConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.SplinterConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.SplinterConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.SplinterConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.SplinterConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SplinterConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SplinterConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.SplinterConfig.question_token_id",description:`<strong>question_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 104) &#x2014;
The id of the <code>[QUESTION]</code> token.`,name:"question_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/configuration_splinter.py#L24"}}),Q=new un({props:{anchor:"transformers.SplinterConfig.example",$$slots:{default:[Xn]},$$scope:{ctx:x}}}),he=new B({props:{title:"SplinterTokenizer",local:"transformers.SplinterTokenizer",headingTag:"h2"}}),ue=new z({props:{name:"class transformers.SplinterTokenizer",anchor:"transformers.SplinterTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"question_token",val:" = '[QUESTION]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SplinterTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SplinterTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.SplinterTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.SplinterTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SplinterTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SplinterTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SplinterTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SplinterTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SplinterTokenizer.question_token",description:`<strong>question_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[QUESTION]&quot;</code>) &#x2014;
The token used for constructing question representations.`,name:"question_token"},{anchor:"transformers.SplinterTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters.</p>
<p>This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SplinterTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/tokenization_splinter.py#L52"}}),fe=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The question token IDs if pad_on_right, else context tokens IDs`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The context token IDs if pad_on_right, else question token IDs`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/tokenization_splinter.py#L190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ge=new z({props:{name:"get_special_tokens_mask",anchor:"transformers.SplinterTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/tokenization_splinter.py#L222",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),_e=new z({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/tokenization_splinter.py#L250",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ke=new z({props:{name:"save_vocabulary",anchor:"transformers.SplinterTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/tokenization_splinter.py#L279"}}),be=new B({props:{title:"SplinterTokenizerFast",local:"transformers.SplinterTokenizerFast",headingTag:"h2"}}),Te=new z({props:{name:"class transformers.SplinterTokenizerFast",anchor:"transformers.SplinterTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"do_lower_case",val:" = True"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"question_token",val:" = '[QUESTION]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SplinterTokenizerFast.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SplinterTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SplinterTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SplinterTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SplinterTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SplinterTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SplinterTokenizerFast.question_token",description:`<strong>question_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[QUESTION]&quot;</code>) &#x2014;
The token used for constructing question representations.`,name:"question_token"},{anchor:"transformers.SplinterTokenizerFast.clean_text",description:`<strong>clean_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the text before tokenization by removing any control characters and replacing all
whitespaces by the classic one.`,name:"clean_text"},{anchor:"transformers.SplinterTokenizerFast.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see <a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">this
issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SplinterTokenizerFast.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"},{anchor:"transformers.SplinterTokenizerFast.wordpieces_prefix",description:`<strong>wordpieces_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;##&quot;</code>) &#x2014;
The prefix for subwords.`,name:"wordpieces_prefix"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/tokenization_splinter_fast.py#L32"}}),we=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The question token IDs if pad_on_right, else context tokens IDs`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The context token IDs if pad_on_right, else question token IDs`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/tokenization_splinter_fast.py#L127",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ve=new B({props:{title:"SplinterModel",local:"transformers.SplinterModel",headingTag:"h2"}}),ye=new z({props:{name:"class transformers.SplinterModel",anchor:"transformers.SplinterModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/modeling_splinter.py#L602"}}),$e=new z({props:{name:"forward",anchor:"transformers.SplinterModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SplinterModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention if
the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.SplinterModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.SplinterModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SplinterModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/modeling_splinter.py#L637",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new hn({props:{$$slots:{default:[Vn]},$$scope:{ctx:x}}}),O=new un({props:{anchor:"transformers.SplinterModel.forward.example",$$slots:{default:[Yn]},$$scope:{ctx:x}}}),Me=new B({props:{title:"SplinterForQuestionAnswering",local:"transformers.SplinterForQuestionAnswering",headingTag:"h2"}}),Se=new z({props:{name:"class transformers.SplinterForQuestionAnswering",anchor:"transformers.SplinterForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/modeling_splinter.py#L821"}}),xe=new z({props:{name:"forward",anchor:"transformers.SplinterForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"start_positions",val:": Optional = None"},{name:"end_positions",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"question_positions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SplinterForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.question_positions",description:`<strong>question_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
The positions of all question tokens. If given, start_logits and end_logits will be of shape <code>(batch_size, num_questions, sequence_length)</code>. If None, the first question token in each sequence in the batch will be
the only one for which start_logits and end_logits are calculated and they will be of shape <code>(batch_size, sequence_length)</code>.`,name:"question_positions"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/modeling_splinter.py#L839",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_30862/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new hn({props:{$$slots:{default:[Kn]},$$scope:{ctx:x}}}),D=new un({props:{anchor:"transformers.SplinterForQuestionAnswering.forward.example",$$slots:{default:[eo]},$$scope:{ctx:x}}}),ze=new B({props:{title:"SplinterForPreTraining",local:"transformers.SplinterForPreTraining",headingTag:"h2"}}),qe=new z({props:{name:"class transformers.SplinterForPreTraining",anchor:"transformers.SplinterForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30862/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30862/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/modeling_splinter.py#L974"}}),Ce=new z({props:{name:"forward",anchor:"transformers.SplinterForPreTraining.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"start_positions",val:": Optional = None"},{name:"end_positions",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"question_positions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SplinterForPreTraining.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30862/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30862/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterForPreTraining.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterForPreTraining.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterForPreTraining.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_questions, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30862/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterForPreTraining.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SplinterForPreTraining.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.SplinterForPreTraining.forward.question_positions",description:`<strong>question_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
The positions of all question tokens. If given, start_logits and end_logits will be of shape <code>(batch_size, num_questions, sequence_length)</code>. If None, the first question token in each sequence in the batch will be
the only one for which start_logits and end_logits are calculated and they will be of shape <code>(batch_size, sequence_length)</code>.`,name:"question_positions"}],source:"https://github.com/huggingface/transformers/blob/vr_30862/src/transformers/models/splinter/modeling_splinter.py#L993"}}),X=new hn({props:{$$slots:{default:[to]},$$scope:{ctx:x}}}),Fe=new Dn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/splinter.md"}}),{c(){a=i("meta"),T=s(),p=i("p"),m=s(),h(w.$$.fragment),d=s(),h(v.$$.fragment),it=s(),oe=i("p"),oe.innerHTML=gn,lt=s(),se=i("p"),se.textContent=_n,dt=s(),re=i("p"),re.textContent=kn,ct=s(),ae=i("p"),ae.innerHTML=bn,pt=s(),h(ie.$$.fragment),mt=s(),le=i("ul"),le.innerHTML=Tn,ht=s(),h(de.$$.fragment),ut=s(),ce=i("ul"),ce.innerHTML=wn,ft=s(),h(pe.$$.fragment),gt=s(),q=i("div"),h(me.$$.fragment),Ct=s(),Le=i("p"),Le.innerHTML=vn,Ft=s(),Pe=i("p"),Pe.innerHTML=yn,It=s(),h(Q.$$.fragment),_t=s(),h(he.$$.fragment),kt=s(),y=i("div"),h(ue.$$.fragment),Lt=s(),je=i("p"),je.textContent=$n,Pt=s(),Ue=i("p"),Ue.innerHTML=Mn,jt=s(),W=i("div"),h(fe.$$.fragment),Ut=s(),We=i("p"),We.textContent=Sn,Wt=s(),Je=i("ul"),Je.innerHTML=xn,Jt=s(),E=i("div"),h(ge.$$.fragment),At=s(),Ae=i("p"),Ae.innerHTML=zn,Nt=s(),J=i("div"),h(_e.$$.fragment),Bt=s(),Ne=i("p"),Ne.innerHTML=qn,Ht=s(),Be=i("p"),Be.textContent=Cn,Zt=s(),He=i("div"),h(ke.$$.fragment),bt=s(),h(be.$$.fragment),Tt=s(),C=i("div"),h(Te.$$.fragment),Qt=s(),Ze=i("p"),Ze.innerHTML=Fn,Et=s(),Qe=i("p"),Qe.innerHTML=In,Gt=s(),A=i("div"),h(we.$$.fragment),Ot=s(),Ee=i("p"),Ee.textContent=Ln,Rt=s(),Ge=i("ul"),Ge.innerHTML=Pn,wt=s(),h(ve.$$.fragment),vt=s(),F=i("div"),h(ye.$$.fragment),Dt=s(),Oe=i("p"),Oe.innerHTML=jn,Xt=s(),Re=i("p"),Re.innerHTML=Un,Vt=s(),P=i("div"),h($e.$$.fragment),Yt=s(),De=i("p"),De.innerHTML=Wn,Kt=s(),h(G.$$.fragment),en=s(),h(O.$$.fragment),yt=s(),h(Me.$$.fragment),$t=s(),I=i("div"),h(Se.$$.fragment),tn=s(),Xe=i("p"),Xe.innerHTML=Jn,nn=s(),Ve=i("p"),Ve.innerHTML=An,on=s(),j=i("div"),h(xe.$$.fragment),sn=s(),Ye=i("p"),Ye.innerHTML=Nn,rn=s(),h(R.$$.fragment),an=s(),h(D.$$.fragment),Mt=s(),h(ze.$$.fragment),St=s(),L=i("div"),h(qe.$$.fragment),ln=s(),Ke=i("p"),Ke.textContent=Bn,dn=s(),et=i("p"),et.innerHTML=Hn,cn=s(),N=i("div"),h(Ce.$$.fragment),pn=s(),tt=i("p"),tt.innerHTML=Zn,mn=s(),h(X.$$.fragment),xt=s(),h(Fe.$$.fragment),zt=s(),rt=i("p"),this.h()},l(e){const n=Rn("svelte-u9bgzb",document.head);a=l(n,"META",{name:!0,content:!0}),n.forEach(o),T=r(e),p=l(e,"P",{}),M(p).forEach(o),m=r(e),u(w.$$.fragment,e),d=r(e),u(v.$$.fragment,e),it=r(e),oe=l(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-1nfobji"&&(oe.innerHTML=gn),lt=r(e),se=l(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-vfdo9a"&&(se.textContent=_n),dt=r(e),re=l(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-m8m8di"&&(re.textContent=kn),ct=r(e),ae=l(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-1hzgtbk"&&(ae.innerHTML=bn),pt=r(e),u(ie.$$.fragment,e),mt=r(e),le=l(e,"UL",{"data-svelte-h":!0}),b(le)!=="svelte-1sq9viw"&&(le.innerHTML=Tn),ht=r(e),u(de.$$.fragment,e),ut=r(e),ce=l(e,"UL",{"data-svelte-h":!0}),b(ce)!=="svelte-1orm8os"&&(ce.innerHTML=wn),ft=r(e),u(pe.$$.fragment,e),gt=r(e),q=l(e,"DIV",{class:!0});var U=M(q);u(me.$$.fragment,U),Ct=r(U),Le=l(U,"P",{"data-svelte-h":!0}),b(Le)!=="svelte-l7t4gb"&&(Le.innerHTML=vn),Ft=r(U),Pe=l(U,"P",{"data-svelte-h":!0}),b(Pe)!=="svelte-dt1yj"&&(Pe.innerHTML=yn),It=r(U),u(Q.$$.fragment,U),U.forEach(o),_t=r(e),u(he.$$.fragment,e),kt=r(e),y=l(e,"DIV",{class:!0});var $=M(y);u(ue.$$.fragment,$),Lt=r($),je=l($,"P",{"data-svelte-h":!0}),b(je)!=="svelte-1auu3gg"&&(je.textContent=$n),Pt=r($),Ue=l($,"P",{"data-svelte-h":!0}),b(Ue)!=="svelte-1e9cw37"&&(Ue.innerHTML=Mn),jt=r($),W=l($,"DIV",{class:!0});var H=M(W);u(fe.$$.fragment,H),Ut=r(H),We=l(H,"P",{"data-svelte-h":!0}),b(We)!=="svelte-1di5c8i"&&(We.textContent=Sn),Wt=r(H),Je=l(H,"UL",{"data-svelte-h":!0}),b(Je)!=="svelte-18p1y68"&&(Je.innerHTML=xn),H.forEach(o),Jt=r($),E=l($,"DIV",{class:!0});var Ie=M(E);u(ge.$$.fragment,Ie),At=r(Ie),Ae=l(Ie,"P",{"data-svelte-h":!0}),b(Ae)!=="svelte-1f4f5kp"&&(Ae.innerHTML=zn),Ie.forEach(o),Nt=r($),J=l($,"DIV",{class:!0});var Z=M(J);u(_e.$$.fragment,Z),Bt=r(Z),Ne=l(Z,"P",{"data-svelte-h":!0}),b(Ne)!=="svelte-zj1vf1"&&(Ne.innerHTML=qn),Ht=r(Z),Be=l(Z,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-9vptpw"&&(Be.textContent=Cn),Z.forEach(o),Zt=r($),He=l($,"DIV",{class:!0});var at=M(He);u(ke.$$.fragment,at),at.forEach(o),$.forEach(o),bt=r(e),u(be.$$.fragment,e),Tt=r(e),C=l(e,"DIV",{class:!0});var V=M(C);u(Te.$$.fragment,V),Qt=r(V),Ze=l(V,"P",{"data-svelte-h":!0}),b(Ze)!=="svelte-t7sr0h"&&(Ze.innerHTML=Fn),Et=r(V),Qe=l(V,"P",{"data-svelte-h":!0}),b(Qe)!=="svelte-160uz0f"&&(Qe.innerHTML=In),Gt=r(V),A=l(V,"DIV",{class:!0});var nt=M(A);u(we.$$.fragment,nt),Ot=r(nt),Ee=l(nt,"P",{"data-svelte-h":!0}),b(Ee)!=="svelte-1di5c8i"&&(Ee.textContent=Ln),Rt=r(nt),Ge=l(nt,"UL",{"data-svelte-h":!0}),b(Ge)!=="svelte-18p1y68"&&(Ge.innerHTML=Pn),nt.forEach(o),V.forEach(o),wt=r(e),u(ve.$$.fragment,e),vt=r(e),F=l(e,"DIV",{class:!0});var Y=M(F);u(ye.$$.fragment,Y),Dt=r(Y),Oe=l(Y,"P",{"data-svelte-h":!0}),b(Oe)!=="svelte-mflokx"&&(Oe.innerHTML=jn),Xt=r(Y),Re=l(Y,"P",{"data-svelte-h":!0}),b(Re)!=="svelte-ocipx3"&&(Re.innerHTML=Un),Vt=r(Y),P=l(Y,"DIV",{class:!0});var K=M(P);u($e.$$.fragment,K),Yt=r(K),De=l(K,"P",{"data-svelte-h":!0}),b(De)!=="svelte-10986b3"&&(De.innerHTML=Wn),Kt=r(K),u(G.$$.fragment,K),en=r(K),u(O.$$.fragment,K),K.forEach(o),Y.forEach(o),yt=r(e),u(Me.$$.fragment,e),$t=r(e),I=l(e,"DIV",{class:!0});var ee=M(I);u(Se.$$.fragment,ee),tn=r(ee),Xe=l(ee,"P",{"data-svelte-h":!0}),b(Xe)!=="svelte-cet2uw"&&(Xe.innerHTML=Jn),nn=r(ee),Ve=l(ee,"P",{"data-svelte-h":!0}),b(Ve)!=="svelte-68lg8f"&&(Ve.innerHTML=An),on=r(ee),j=l(ee,"DIV",{class:!0});var te=M(j);u(xe.$$.fragment,te),sn=r(te),Ye=l(te,"P",{"data-svelte-h":!0}),b(Ye)!=="svelte-ro9omf"&&(Ye.innerHTML=Nn),rn=r(te),u(R.$$.fragment,te),an=r(te),u(D.$$.fragment,te),te.forEach(o),ee.forEach(o),Mt=r(e),u(ze.$$.fragment,e),St=r(e),L=l(e,"DIV",{class:!0});var ne=M(L);u(qe.$$.fragment,ne),ln=r(ne),Ke=l(ne,"P",{"data-svelte-h":!0}),b(Ke)!=="svelte-1fwuwic"&&(Ke.textContent=Bn),dn=r(ne),et=l(ne,"P",{"data-svelte-h":!0}),b(et)!=="svelte-68lg8f"&&(et.innerHTML=Hn),cn=r(ne),N=l(ne,"DIV",{class:!0});var ot=M(N);u(Ce.$$.fragment,ot),pn=r(ot),tt=l(ot,"P",{"data-svelte-h":!0}),b(tt)!=="svelte-asxr8d"&&(tt.innerHTML=Zn),mn=r(ot),u(X.$$.fragment,ot),ot.forEach(o),ne.forEach(o),xt=r(e),u(Fe.$$.fragment,e),zt=r(e),rt=l(e,"P",{}),M(rt).forEach(o),this.h()},h(){S(a,"name","hf:doc:metadata"),S(a,"content",oo),S(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){t(document.head,a),c(e,T,n),c(e,p,n),c(e,m,n),f(w,e,n),c(e,d,n),f(v,e,n),c(e,it,n),c(e,oe,n),c(e,lt,n),c(e,se,n),c(e,dt,n),c(e,re,n),c(e,ct,n),c(e,ae,n),c(e,pt,n),f(ie,e,n),c(e,mt,n),c(e,le,n),c(e,ht,n),f(de,e,n),c(e,ut,n),c(e,ce,n),c(e,ft,n),f(pe,e,n),c(e,gt,n),c(e,q,n),f(me,q,null),t(q,Ct),t(q,Le),t(q,Ft),t(q,Pe),t(q,It),f(Q,q,null),c(e,_t,n),f(he,e,n),c(e,kt,n),c(e,y,n),f(ue,y,null),t(y,Lt),t(y,je),t(y,Pt),t(y,Ue),t(y,jt),t(y,W),f(fe,W,null),t(W,Ut),t(W,We),t(W,Wt),t(W,Je),t(y,Jt),t(y,E),f(ge,E,null),t(E,At),t(E,Ae),t(y,Nt),t(y,J),f(_e,J,null),t(J,Bt),t(J,Ne),t(J,Ht),t(J,Be),t(y,Zt),t(y,He),f(ke,He,null),c(e,bt,n),f(be,e,n),c(e,Tt,n),c(e,C,n),f(Te,C,null),t(C,Qt),t(C,Ze),t(C,Et),t(C,Qe),t(C,Gt),t(C,A),f(we,A,null),t(A,Ot),t(A,Ee),t(A,Rt),t(A,Ge),c(e,wt,n),f(ve,e,n),c(e,vt,n),c(e,F,n),f(ye,F,null),t(F,Dt),t(F,Oe),t(F,Xt),t(F,Re),t(F,Vt),t(F,P),f($e,P,null),t(P,Yt),t(P,De),t(P,Kt),f(G,P,null),t(P,en),f(O,P,null),c(e,yt,n),f(Me,e,n),c(e,$t,n),c(e,I,n),f(Se,I,null),t(I,tn),t(I,Xe),t(I,nn),t(I,Ve),t(I,on),t(I,j),f(xe,j,null),t(j,sn),t(j,Ye),t(j,rn),f(R,j,null),t(j,an),f(D,j,null),c(e,Mt,n),f(ze,e,n),c(e,St,n),c(e,L,n),f(qe,L,null),t(L,ln),t(L,Ke),t(L,dn),t(L,et),t(L,cn),t(L,N),f(Ce,N,null),t(N,pn),t(N,tt),t(N,mn),f(X,N,null),c(e,xt,n),f(Fe,e,n),c(e,zt,n),c(e,rt,n),qt=!0},p(e,[n]){const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),Q.$set(U);const $={};n&2&&($.$$scope={dirty:n,ctx:e}),G.$set($);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),O.$set(H);const Ie={};n&2&&(Ie.$$scope={dirty:n,ctx:e}),R.$set(Ie);const Z={};n&2&&(Z.$$scope={dirty:n,ctx:e}),D.$set(Z);const at={};n&2&&(at.$$scope={dirty:n,ctx:e}),X.$set(at)},i(e){qt||(g(w.$$.fragment,e),g(v.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(Q.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(ke.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),g($e.$$.fragment,e),g(G.$$.fragment,e),g(O.$$.fragment,e),g(Me.$$.fragment,e),g(Se.$$.fragment,e),g(xe.$$.fragment,e),g(R.$$.fragment,e),g(D.$$.fragment,e),g(ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ce.$$.fragment,e),g(X.$$.fragment,e),g(Fe.$$.fragment,e),qt=!0)},o(e){_(w.$$.fragment,e),_(v.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(Q.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(ke.$$.fragment,e),_(be.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_($e.$$.fragment,e),_(G.$$.fragment,e),_(O.$$.fragment,e),_(Me.$$.fragment,e),_(Se.$$.fragment,e),_(xe.$$.fragment,e),_(R.$$.fragment,e),_(D.$$.fragment,e),_(ze.$$.fragment,e),_(qe.$$.fragment,e),_(Ce.$$.fragment,e),_(X.$$.fragment,e),_(Fe.$$.fragment,e),qt=!1},d(e){e&&(o(T),o(p),o(m),o(d),o(it),o(oe),o(lt),o(se),o(dt),o(re),o(ct),o(ae),o(pt),o(mt),o(le),o(ht),o(ut),o(ce),o(ft),o(gt),o(q),o(_t),o(kt),o(y),o(bt),o(Tt),o(C),o(wt),o(vt),o(F),o(yt),o($t),o(I),o(Mt),o(St),o(L),o(xt),o(zt),o(rt)),o(a),k(w,e),k(v,e),k(ie,e),k(de,e),k(pe,e),k(me),k(Q),k(he,e),k(ue),k(fe),k(ge),k(_e),k(ke),k(be,e),k(Te),k(we),k(ve,e),k(ye),k($e),k(G),k(O),k(Me,e),k(Se),k(xe),k(R),k(D),k(ze,e),k(qe),k(Ce),k(X),k(Fe,e)}}}const oo='{"title":"Splinter","local":"splinter","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SplinterConfig","local":"transformers.SplinterConfig","sections":[],"depth":2},{"title":"SplinterTokenizer","local":"transformers.SplinterTokenizer","sections":[],"depth":2},{"title":"SplinterTokenizerFast","local":"transformers.SplinterTokenizerFast","sections":[],"depth":2},{"title":"SplinterModel","local":"transformers.SplinterModel","sections":[],"depth":2},{"title":"SplinterForQuestionAnswering","local":"transformers.SplinterForQuestionAnswering","sections":[],"depth":2},{"title":"SplinterForPreTraining","local":"transformers.SplinterForPreTraining","sections":[],"depth":2}],"depth":1}';function so(x){return En(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ho extends Gn{constructor(a){super(),On(this,a,so,no,Qn,{})}}export{ho as component};
