import{s as Qi,n as qi,o as Ki}from"../chunks/scheduler.36a0863c.js";import{S as Di,i as Oi,g as a,s as o,r as d,A as eo,h as s,f as l,c as n,j as Ai,u as p,x as r,k as Si,y as to,a as i,v as m,d as c,t as u,w as M}from"../chunks/index.9c13489a.js";import{C as f}from"../chunks/CodeBlock.05d8ec32.js";import{H as b,E as lo}from"../chunks/EditOnGithub.e88f2b7b.js";function io(Xl){let T,lt,et,it,y,ot,v,nt,J,El=`Un paio di modifiche sono state introdotte nel passaggio dalla versione 3 alla versione 4. Di seguito è riportato un riepilogo delle
modifiche previste:`,at,z,st,_,Fl="I tokenizer python e rust hanno all’incirca le stesse API, ma i tokenizer rust hanno un set di funzionalità più completo.",rt,w,Yl="Ciò introduce due modifiche sostanziali:",dt,g,Nl="<li>La gestione dei token in overflow tra i tokenizer Python e Rust è diversa.</li> <li>I tokenizers di rust non accettano numeri interi nei metodi di codifica.</li>",pt,$,mt,h,Pl='<li>Le pipeline ora contengono funzionalità aggiuntive pronte all’uso. Vedi la <a href="main_classes/pipelines#transformers.TokenClassificationPipeline">pipeline di classificazione dei token con il flag <code>grouped_entities</code></a>.</li> <li>Gli auto-tokenizer ora restituiscono tokenizer rust. Per ottenere invece i tokenizer python, l’utente deve usare il flag <code>use_fast</code> impostandolo <code>False</code>:</li>',ct,j,Al="Nella versione <code>v3.x</code>:",ut,U,Mt,Z,Sl="per ottenere lo stesso nella versione <code>v4.x</code>:",bt,B,ft,x,Tt,k,Ql="Il requisito sulla dipendenza SentencePiece è stato rimosso da <code>setup.py</code>. È stato fatto per avere un canale su anaconda cloud senza basarsi su <code>conda-forge</code>. Ciò significa che i tokenizer che dipendono dalla libreria SentencePiece non saranno disponibili con un’installazione standard di <code>transformers</code>.",yt,W,ql="Ciò include le versioni <strong>lente</strong> di:",vt,C,Kl="<li><code>XLNetTokenizer</code></li> <li><code>AlbertTokenizer</code></li> <li><code>CamembertTokenizer</code></li> <li><code>MBartTokenizer</code></li> <li><code>PegasusTokenizer</code></li> <li><code>T5Tokenizer</code></li> <li><code>ReformerTokenizer</code></li> <li><code>XLMRobertaTokenizer</code></li>",Jt,H,zt,I,Dl="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, devi installare anche <code>sentencepiece</code>:",_t,G,Ol="Nella versione <code>v3.x</code>:",wt,L,gt,V,ei="per ottenere lo stesso nella versione <code>v4.x</code>:",$t,R,ht,X,ti="o",jt,E,Ut,F,Zt,Y,li="Con l’aggiunta di nuovi modelli, il numero di file nella cartella <code>src/transformers</code> continua a crescere e diventa più difficile navigare e capire. Abbiamo fatto la scelta di inserire ogni modello e i file che lo accompagnano nelle proprie sottocartelle.",Bt,N,ii="Si tratta di una modifica sostanziale in quanto l’importazione di layer intermedi utilizzando direttamente il modulo di un modello deve essere eseguita tramite un percorso diverso.",xt,P,kt,A,oi="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, devi aggiornare il percorso utilizzato per accedere ai layer.",Wt,S,ni="Nella versione <code>v3.x</code>:",Ct,Q,Ht,q,ai="per ottenere lo stesso nella versione <code>v4.x</code>:",It,K,Gt,D,Lt,O,si='L’<a href="main_classes/output">argomento <code>return_dict</code></a> abilita la restituzione di oggetti python dict-like contenenti gli output del modello, invece delle tuple standard. Questo oggetto è self-documented poiché le chiavi possono essere utilizzate per recuperare valori, comportandosi anche come una tupla e gli utenti possono recuperare oggetti per indexing o slicing.',Vt,ee,ri="Questa è una modifica sostanziale poiché la tupla non può essere decompressa: <code>value0, value1 = outputs</code> non funzionerà.",Rt,te,Xt,le,di="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, specifica l’argomento <code>return_dict</code> come <code>False</code>, sia nella configurazione del modello che nel passaggio successivo.",Et,ie,pi="Nella versione <code>v3.x</code>:",Ft,oe,Yt,ne,mi="per ottenere lo stesso nella versione <code>v4.x</code>:",Nt,ae,Pt,se,ci="o",At,re,St,de,Qt,pe,ui='Gli attributi sono stati rimossi se deprecati da almeno un mese. L’elenco completo degli attributi obsoleti è disponibile in <a href="https://github.com/huggingface/transformers/pull/8604" rel="nofollow">#8604</a>.',qt,me,Mi="Ecco un elenco di questi attributi/metodi/argomenti e quali dovrebbero essere le loro sostituzioni:",Kt,ce,bi="In diversi modelli, le etichette diventano coerenti con gli altri modelli:",Dt,ue,fi="<li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>AlbertForMaskedLM</code> e <code>AlbertForPreTraining</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>BertForMaskedLM</code> e <code>BertForPreTraining</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>DistilBertForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>ElectraForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>LongformerForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>MobileBertForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>RobertaForMaskedLM</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>BartForConditionalGeneration</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>GPT2DoubleHeadsModel</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>OpenAIGPTDoubleHeadsModel</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>T5ForConditionalGeneration</code>.</li>",Ot,Me,Ti="In diversi modelli, il meccanismo di memorizzazione nella cache diventa coerente con gli altri:",el,be,yi="<li><code>decoder_cached_states</code> diventa <code>past_key_values</code> in tutti i modelli BART-like, FSMT e T5.</li> <li><code>decoder_past_key_values</code> diventa <code>past_key_values</code> in tutti i modelli BART-like, FSMT e T5.</li> <li><code>past</code> diventa <code>past_key_values</code> in tutti i modelli CTRL.</li> <li><code>past</code> diventa <code>past_key_values</code> in tutti i modelli GPT-2.</li>",tl,fe,vi="Per quanto riguarda le classi tokenizer:",ll,Te,Ji="<li>L’attributo tokenizer <code>max_len</code> diventa <code>model_max_length</code>.</li> <li>L’attributo tokenizer <code>return_lengths</code> diventa <code>return_length</code>.</li> <li>L’argomento di codifica del tokenizer <code>is_pretokenized</code> diventa <code>is_split_into_words</code>.</li>",il,ye,zi="Per quanto riguarda la classe <code>Trainer</code>:",ol,ve,_i="<li>L’argomento <code>tb_writer</code> di <code>Trainer</code> è stato rimosso in favore della funzione richiamabile <code>TensorBoardCallback(tb_writer=...)</code>.</li> <li>L’argomento <code>prediction_loss_only</code> di <code>Trainer</code> è stato rimosso in favore dell’argomento di classe <code>args.prediction_loss_only</code>.</li> <li>L’attributo <code>data_collator</code> di <code>Trainer</code> sarà richiamabile.</li> <li>Il metodo <code>_log</code> di <code>Trainer</code> è deprecato a favore di <code>log</code>.</li> <li>Il metodo <code>_training_step</code> di <code>Trainer</code> è deprecato a favore di <code>training_step</code>.</li> <li>Il metodo <code>_prediction_loop</code> di <code>Trainer</code> è deprecato a favore di <code>prediction_loop</code>.</li> <li>Il metodo <code>is_local_master</code> di <code>Trainer</code> è deprecato a favore di <code>is_local_process_zero</code>.</li> <li>Il metodo <code>is_world_master</code> di <code>Trainer</code> è deprecato a favore di <code>is_world_process_zero</code>.</li>",nl,Je,wi="Per quanto riguarda la classe <code>TrainingArguments</code>:",al,ze,gi="<li>L’argomento <code>evaluate_during_training</code> di <code>TrainingArguments</code> è deprecato a favore di <code>eval_strategy</code>.</li>",sl,_e,$i="Per quanto riguarda il modello Transfo-XL:",rl,we,hi="<li>L’attributo di configurazione <code>tie_weight</code> di Transfo-XL diventa <code>tie_words_embeddings</code>.</li> <li>Il metodo di modellazione <code>reset_length</code> di Transfo-XL diventa <code>reset_memory_length</code>.</li>",dl,ge,ji="Per quanto riguarda le pipeline:",pl,$e,Ui="<li>L’argomento <code>topk</code> di <code>FillMaskPipeline</code> diventa <code>top_k</code>.</li>",ml,he,cl,je,Zi="Ecco un breve riepilogo di ciò a cui prestare attenzione durante il passaggio da <code>pytorch-transformers</code> a 🤗 Transformers.",ul,Ue,Ml,Ze,Bi="Per usare Torchscript (vedi #1010, #1204 e #1195) l’ordine specifico delle <strong>parole chiave di input</strong> di alcuni modelli (<code>attention_mask</code>, <code>token_type_ids</code>…) è stato modificato.",bl,Be,xi="Se inizializzavi i modelli usando parole chiave per gli argomenti, ad esempio <code>model(inputs_ids, attention_mask=attention_mask, token_type_ids=token_type_ids)</code>, questo non dovrebbe causare alcun cambiamento.",fl,xe,ki="Se inizializzavi i modelli con input posizionali per gli argomenti, ad esempio <code>model(inputs_ids, attention_mask, token_type_ids)</code>, potrebbe essere necessario ricontrollare l’ordine esatto degli argomenti di input.",Tl,ke,yl,We,Wi="Ecco un breve riepilogo di ciò a cui prestare attenzione durante la migrazione da <code>pytorch-pretrained-bert</code> a 🤗 Transformers",vl,Ce,Jl,He,Ci="La principale modifica di rilievo durante la migrazione da <code>pytorch-pretrained-bert</code> a 🤗 Transformers è che il metodo dei modelli di previsione dà sempre una <code>tupla</code> con vari elementi a seconda del modello e dei parametri di configurazione.",zl,Ie,Hi='Il contenuto esatto delle tuple per ciascun modello è mostrato in dettaglio nelle docstring dei modelli e nella <a href="https://huggingface.co/transformers/" rel="nofollow">documentazione</a>.',_l,Ge,Ii="In quasi tutti i casi, andrà bene prendendo il primo elemento dell’output come quello che avresti precedentemente utilizzato in <code>pytorch-pretrained-bert</code>.",wl,Le,Gi=`Ecco un esempio di conversione da <code>pytorch-pretrained-bert</code>
a 🤗 Transformers per un modello di classificazione <code>BertForSequenceClassification</code>:`,gl,Ve,$l,Re,hl,Xe,Li="Modifica sostanziale nel metodo <code>from_pretrained()</code>:",jl,Ee,Vi="<li><p>I modelli sono ora impostati in modalità di valutazione in maniera predefinita quando usi il metodo <code>from_pretrained()</code>. Per addestrarli non dimenticare di riportarli in modalità di addestramento (<code>model.train()</code>) per attivare i moduli di dropout.</p></li> <li><p>Gli argomenti aggiuntivi <code>*inputs</code> e <code>**kwargs</code> forniti al metodo <code>from_pretrained()</code> venivano passati direttamente al metodo <code>__init__()</code> della classe sottostante del modello. Ora sono usati per aggiornare prima l’attributo di configurazione del modello, che può non funzionare con le classi del modello derivate costruite basandosi sui precedenti esempi di <code>BertForSequenceClassification</code>. Più precisamente, gli argomenti posizionali <code>*inputs</code> forniti a <code>from_pretrained()</code> vengono inoltrati direttamente al metodo <code>__init__()</code>  del modello mentre gli argomenti keyword <code>**kwargs</code> (i) che corrispondono agli attributi della classe di configurazione, vengono utilizzati per aggiornare tali attributi (ii) che non corrispondono ad alcun attributo della classe di configurazione, vengono inoltrati al metodo <code>__init__()</code>.</p></li>",Ul,Fe,Ri="Inoltre, sebbene non si tratti di una modifica sostanziale, i metodi di serializzazione sono stati standardizzati e probabilmente dovresti passare al nuovo metodo <code>save_pretrained(save_directory)</code> se prima usavi qualsiasi altro metodo di serializzazione.",Zl,Ye,Xi="Ecco un esempio:",Bl,Ne,xl,Pe,kl,Ae,Ei="I due ottimizzatori precedenti inclusi, <code>BertAdam</code> e <code>OpenAIAdam</code>, sono stati sostituiti da un singolo <code>AdamW</code> che presenta alcune differenze:",Wl,Se,Fi="<li>implementa solo la correzione del weights decay,</li> <li>lo scheduling ora è esterno (vedi sotto),</li> <li>anche il gradient clipping ora è esterno (vedi sotto).</li>",Cl,Qe,Yi="Il nuovo ottimizzatore <code>AdamW</code> corrisponde alle API di <code>Adam</code> di PyTorch e ti consente di utilizzare metodi PyTorch o apex per lo scheduling e il clipping.",Hl,qe,Ni='Lo scheduling è ora standard <a href="https://pytorch.org/docs/stable/optim.html#how-to-adjust-learning-rate" rel="nofollow">PyTorch learning rate schedulers</a> e non fanno più parte dell’ottimizzatore.',Il,Ke,Pi="Ecco un esempio di linear warmup e decay con <code>BertAdam</code> e con <code>AdamW</code>:",Gl,De,Ll,Oe,Vl,tt,Rl;return y=new b({props:{title:"Migrazione da pacchetti precedenti",local:"migrazione-da-pacchetti-precedenti",headingTag:"h1"}}),v=new b({props:{title:"Migrazione da transformers v3.x a v4.x",local:"migrazione-da-transformers-v3x-a-v4x",headingTag:"h2"}}),z=new b({props:{title:"1. AutoTokenizer e pipeline ora utilizzano tokenizer veloci (rust) per impostazione predefinita.",local:"1-autotokenizer-e-pipeline-ora-utilizzano-tokenizer-veloci-rust-per-impostazione-predefinita",headingTag:"h4"}}),$=new b({props:{title:"Come ottenere lo stesso comportamento di v3.x in v4.x",local:"come-ottenere-lo-stesso-comportamento-di-v3x-in-v4x",headingTag:"h5"}}),U=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)`,wrap:!1}}),B=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMHVzZV9mYXN0JTNERmFsc2Up",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, use_fast=<span class="hljs-literal">False</span>)`,wrap:!1}}),x=new b({props:{title:"2. SentencePiece è stato rimosso dalle dipendenze richieste",local:"2-sentencepiece-è-stato-rimosso-dalle-dipendenze-richieste",headingTag:"h4"}}),H=new b({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),L=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),R=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyU1QnNlbnRlbmNlcGllY2UlNUQ=",highlighted:"pip install transformers[sentencepiece]",wrap:!1}}),E=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMHN0ZW50ZW5jZXBpZWNl",highlighted:"pip install transformers stentencepiece",wrap:!1}}),F=new b({props:{title:"3. L’architettura delle repo è stato aggiornata in modo che ogni modello abbia la propria cartella",local:"3-larchitettura-delle-repo-è-stato-aggiornata-in-modo-che-ogni-modello-abbia-la-propria-cartella",headingTag:"h4"}}),P=new b({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),Q=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbGluZ19iZXJ0JTIwaW1wb3J0JTIwQmVydExheWVy",highlighted:"from transformers.modeling_bert import BertLayer",wrap:!1}}),K=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuYmVydC5tb2RlbGluZ19iZXJ0JTIwaW1wb3J0JTIwQmVydExheWVy",highlighted:"from transformers.models.bert.modeling_bert import BertLayer",wrap:!1}}),D=new b({props:{title:"4. Impostare l’argomento return_dict su True per impostazione predefinita",local:"4-impostare-largomento-returndict-su-true-per-impostazione-predefinita",headingTag:"h4"}}),te=new b({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),oe=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
outputs = model(**inputs)`,wrap:!1}}),ae=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0JTNERmFsc2Up",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
outputs = model(**inputs, return_dict=False)`,wrap:!1}}),re=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwcmV0dXJuX2RpY3QlM0RGYWxzZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMp",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, return_dict=False)
outputs = model(**inputs)`,wrap:!1}}),de=new b({props:{title:"5. Rimozione di alcuni attributi deprecati",local:"5-rimozione-di-alcuni-attributi-deprecati",headingTag:"h4"}}),he=new b({props:{title:"Passaggio da pytorch-transformers a 🤗 Transformers",local:"passaggio-da-pytorch-transformers-a--transformers",headingTag:"h2"}}),Ue=new b({props:{title:"L’ordine posizionale di alcune parole chiave di input dei modelli ( attention_mask , token_type_ids …) è cambiato",local:"lordine-posizionale-di-alcune-parole-chiave-di-input-dei-modelli--attentionmask--tokentypeids--è-cambiato",headingTag:"h3"}}),ke=new b({props:{title:"Migrazione da pytorch-pretrained-bert",local:"migrazione-da-pytorch-pretrained-bert",headingTag:"h2"}}),Ce=new b({props:{title:"I modelli restituiscono sempre tuple",local:"i-modelli-restituiscono-sempre-tuple",headingTag:"h3"}}),Ve=new f({props:{code:"JTIzJTIwQ2FyaWNoaWFtbyUyMGlsJTIwbm9zdHJvJTIwbW9kZWxsbyUwQW1vZGVsJTIwJTNEJTIwQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBJTIzJTIwU2UlMjB1c2F2aSUyMHF1ZXN0YSUyMHJpZ2ElMjBpbiUyMHB5dG9yY2gtcHJldHJhaW5lZC1iZXJ0JTIwJTNBJTBBbG9zcyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhYmVscyUzRGxhYmVscyklMEElMEElMjMlMjBPcmElMjB1c2ElMjBxdWVzdGElMjByaWdhJTIwaW4lMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBwZXIlMjBlc3RyYXJyZSUyMGxhJTIwcGVyZGl0YSUyMGRhbGxhJTIwdHVwbGElMjBkaSUyMG91dHB1dCUzQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMlNUIwJTVEJTBBJTBBJTIzJTIwSW4lMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBwdW9pJTIwYW5jaGUlMjBhdmVyZSUyMGFjY2Vzc28lMjBhaSUyMGxvZ2l0JTNBJTBBbG9zcyUyQyUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMlNUIlM0EyJTVEJTBBJTBBJTIzJTIwRWQlMjBhbmNoZSUyMGFnbGklMjBhdHRlbnRpb24lMjB3ZWlnaHQlMjBzZSUyMGNvbmZpZ3VyaSUyMGlsJTIwbW9kZWxsbyUyMHBlciUyMHJlc3RpdHVpcmxpJTIwKGUlMjBhbmNoZSUyMGFsdHJpJTIwb3V0cHV0JTJDJTIwdmVkaSUyMGxlJTIwZG9jc3RyaW5nJTIwZSUyMGxhJTIwZG9jdW1lbnRhemlvbmUpJTBBbW9kZWwlMjAlM0QlMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyJTIwZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvc3MlMkMlMjBsb2dpdHMlMkMlMjBhdHRlbnRpb25zJTIwJTNEJTIwb3V0cHV0cw==",highlighted:`<span class="hljs-comment"># Carichiamo il nostro modello</span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-comment"># Se usavi questa riga in pytorch-pretrained-bert :</span>
loss = model(input_ids, labels=labels)

<span class="hljs-comment"># Ora usa questa riga in 🤗 Transformers per estrarre la perdita dalla tupla di output:</span>
outputs = model(input_ids, labels=labels)
loss = outputs[<span class="hljs-number">0</span>]

<span class="hljs-comment"># In 🤗 Transformers puoi anche avere accesso ai logit:</span>
loss, logits = outputs[:<span class="hljs-number">2</span>]

<span class="hljs-comment"># Ed anche agli attention weight se configuri il modello per restituirli (e anche altri output, vedi le docstring e la documentazione)</span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot; google-bert/bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
outputs = model(input_ids, labels=labels)
loss, logits, attentions = outputs`,wrap:!1}}),Re=new b({props:{title:"Serializzazione",local:"serializzazione",headingTag:"h3"}}),Ne=new f({props:{code:"JTIzJTIzJTIzJTIwQ2FyaWNoaWFtbyUyMHVuJTIwbW9kZWxsbyUyMGUlMjB1biUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQmVydFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjMlMjMlMjMlMjBGYWNjaWFtbyUyMGZhcmUlMjBhbGN1bmUlMjBjb3NlJTIwYWwlMjBub3N0cm8lMjBtb2RlbGxvJTIwZSUyMHRva2VuaXplciUwQSUyMyUyMEVzJTNBJTIwYWdnaXVuZ2lhbW8lMjBudW92aSUyMHRva2VuJTIwYWwlMjB2b2NhYm9sYXJpbyUyMGUlMjBhZ2xpJTIwZW1iZW5kaW5nJTIwZGVsJTIwbm9zdHJvJTIwbW9kZWxsbyUwQXRva2VuaXplci5hZGRfdG9rZW5zKCU1QiUyMiU1QlNQRUNJQUxfVE9LRU5fMSU1RCUyMiUyQyUyMCUyMiU1QlNQRUNJQUxfVE9LRU5fMiU1RCUyMiU1RCklMEFtb2RlbC5yZXNpemVfdG9rZW5fZW1iZWRkaW5ncyhsZW4odG9rZW5pemVyKSklMEElMjMlMjBBbGxlbmlhbW8lMjBpbCUyMG5vc3RybyUyMG1vZGVsbG8lMEF0cmFpbihtb2RlbCklMEElMEElMjMlMjMlMjMlMjBPcmElMjBzYWx2aWFtbyUyMGlsJTIwbm9zdHJvJTIwbW9kZWxsbyUyMGUlMjBpbCUyMHRva2VuaXplciUyMGluJTIwdW5hJTIwY2FydGVsbGElMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyLiUyRm15X3NhdmVkX21vZGVsX2RpcmVjdG9yeSUyRiUyMiklMEF0b2tlbml6ZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZteV9zYXZlZF9tb2RlbF9kaXJlY3RvcnklMkYlMjIpJTBBJTBBJTIzJTIzJTIzJTIwUmljYXJpY2hpYW1vJTIwaWwlMjBtb2RlbGxvJTIwZSUyMGlsJTIwdG9rZW5pemVyJTBBbW9kZWwlMjAlM0QlMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRm15X3NhdmVkX21vZGVsX2RpcmVjdG9yeSUyRiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIuJTJGbXlfc2F2ZWRfbW9kZWxfZGlyZWN0b3J5JTJGJTIyKQ==",highlighted:`<span class="hljs-comment">### Carichiamo un modello e un tokenizer</span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-comment">### Facciamo fare alcune cose al nostro modello e tokenizer</span>
<span class="hljs-comment"># Es: aggiungiamo nuovi token al vocabolario e agli embending del nostro modello</span>
tokenizer.add_tokens([<span class="hljs-string">&quot;[SPECIAL_TOKEN_1]&quot;</span>, <span class="hljs-string">&quot;[SPECIAL_TOKEN_2]&quot;</span>])
model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))
<span class="hljs-comment"># Alleniamo il nostro modello</span>
train(model)

<span class="hljs-comment">### Ora salviamo il nostro modello e il tokenizer in una cartella</span>
model.save_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>)

<span class="hljs-comment">### Ricarichiamo il modello e il tokenizer</span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>)
tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>)`,wrap:!1}}),Pe=new b({props:{title:"Ottimizzatori: BertAdam e OpenAIAdam ora sono AdamW, lo scheduling è quello standard PyTorch",local:"ottimizzatori-bertadam-e-openaiadam-ora-sono-adamw-lo-scheduling-è-quello-standard-pytorch",headingTag:"h3"}}),De=new f({props:{code:"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",highlighted:`<span class="hljs-comment"># Parametri:</span>
lr = <span class="hljs-number">1e-3</span>
max_grad_norm = <span class="hljs-number">1.0</span>
num_training_steps = <span class="hljs-number">1000</span>
num_warmup_steps = <span class="hljs-number">100</span>
warmup_proportion = <span class="hljs-built_in">float</span>( num_warmup_steps) / <span class="hljs-built_in">float</span>(num_training_steps) <span class="hljs-comment"># 0.1</span>

<span class="hljs-comment">### In precedenza l&#x27;ottimizzatore BertAdam veniva istanziato in questo modo:</span>
optimizer = BertAdam(
   model.parameters(),
   lr=lr,
   schedule=<span class="hljs-string">&quot;warmup_linear&quot;</span>,
   warmup=warmup_proportion,
   num_training_steps=num_training_steps,
)
<span class="hljs-comment">### e usato in questo modo:</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_data:
   loss = model(batch)
   loss.backward()
   optimizer.step()

<span class="hljs-comment">### In 🤗 Transformers, ottimizzatore e schedule sono divisi e usati in questo modo:</span>
optimizer = AdamW(
   model.parameters(), lr=lr, correct_bias=<span class="hljs-literal">False</span>
) <span class="hljs-comment"># Per riprodurre il comportamento specifico di BertAdam impostare correct_bias=False</span>
scheduler = get_linear_schedule_with_warmup(
   optimizer, num_warmup_steps=num_warmup_steps, num_training_steps=num_training_steps
) <span class="hljs-comment"># PyTorch scheduler</span>
<span class="hljs-comment">### e va usato così:</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_data:
   loss = model(batch)
   loss.backward()
   torch.nn.utils.clip_grad_norm_(
   model.parameters(), max_grad_norm
   ) <span class="hljs-comment"># Gradient clipping non è più in AdamW (quindi puoi usare amp senza problemi)</span>
   optimizer.step()
   scheduler.step()`,wrap:!1}}),Oe=new lo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/it/migration.md"}}),{c(){T=a("meta"),lt=o(),et=a("p"),it=o(),d(y.$$.fragment),ot=o(),d(v.$$.fragment),nt=o(),J=a("p"),J.textContent=El,at=o(),d(z.$$.fragment),st=o(),_=a("p"),_.textContent=Fl,rt=o(),w=a("p"),w.textContent=Yl,dt=o(),g=a("ul"),g.innerHTML=Nl,pt=o(),d($.$$.fragment),mt=o(),h=a("ul"),h.innerHTML=Pl,ct=o(),j=a("p"),j.innerHTML=Al,ut=o(),d(U.$$.fragment),Mt=o(),Z=a("p"),Z.innerHTML=Sl,bt=o(),d(B.$$.fragment),ft=o(),d(x.$$.fragment),Tt=o(),k=a("p"),k.innerHTML=Ql,yt=o(),W=a("p"),W.innerHTML=ql,vt=o(),C=a("ul"),C.innerHTML=Kl,Jt=o(),d(H.$$.fragment),zt=o(),I=a("p"),I.innerHTML=Dl,_t=o(),G=a("p"),G.innerHTML=Ol,wt=o(),d(L.$$.fragment),gt=o(),V=a("p"),V.innerHTML=ei,$t=o(),d(R.$$.fragment),ht=o(),X=a("p"),X.textContent=ti,jt=o(),d(E.$$.fragment),Ut=o(),d(F.$$.fragment),Zt=o(),Y=a("p"),Y.innerHTML=li,Bt=o(),N=a("p"),N.textContent=ii,xt=o(),d(P.$$.fragment),kt=o(),A=a("p"),A.innerHTML=oi,Wt=o(),S=a("p"),S.innerHTML=ni,Ct=o(),d(Q.$$.fragment),Ht=o(),q=a("p"),q.innerHTML=ai,It=o(),d(K.$$.fragment),Gt=o(),d(D.$$.fragment),Lt=o(),O=a("p"),O.innerHTML=si,Vt=o(),ee=a("p"),ee.innerHTML=ri,Rt=o(),d(te.$$.fragment),Xt=o(),le=a("p"),le.innerHTML=di,Et=o(),ie=a("p"),ie.innerHTML=pi,Ft=o(),d(oe.$$.fragment),Yt=o(),ne=a("p"),ne.innerHTML=mi,Nt=o(),d(ae.$$.fragment),Pt=o(),se=a("p"),se.textContent=ci,At=o(),d(re.$$.fragment),St=o(),d(de.$$.fragment),Qt=o(),pe=a("p"),pe.innerHTML=ui,qt=o(),me=a("p"),me.textContent=Mi,Kt=o(),ce=a("p"),ce.textContent=bi,Dt=o(),ue=a("ul"),ue.innerHTML=fi,Ot=o(),Me=a("p"),Me.textContent=Ti,el=o(),be=a("ul"),be.innerHTML=yi,tl=o(),fe=a("p"),fe.textContent=vi,ll=o(),Te=a("ul"),Te.innerHTML=Ji,il=o(),ye=a("p"),ye.innerHTML=zi,ol=o(),ve=a("ul"),ve.innerHTML=_i,nl=o(),Je=a("p"),Je.innerHTML=wi,al=o(),ze=a("ul"),ze.innerHTML=gi,sl=o(),_e=a("p"),_e.textContent=$i,rl=o(),we=a("ul"),we.innerHTML=hi,dl=o(),ge=a("p"),ge.textContent=ji,pl=o(),$e=a("ul"),$e.innerHTML=Ui,ml=o(),d(he.$$.fragment),cl=o(),je=a("p"),je.innerHTML=Zi,ul=o(),d(Ue.$$.fragment),Ml=o(),Ze=a("p"),Ze.innerHTML=Bi,bl=o(),Be=a("p"),Be.innerHTML=xi,fl=o(),xe=a("p"),xe.innerHTML=ki,Tl=o(),d(ke.$$.fragment),yl=o(),We=a("p"),We.innerHTML=Wi,vl=o(),d(Ce.$$.fragment),Jl=o(),He=a("p"),He.innerHTML=Ci,zl=o(),Ie=a("p"),Ie.innerHTML=Hi,_l=o(),Ge=a("p"),Ge.innerHTML=Ii,wl=o(),Le=a("p"),Le.innerHTML=Gi,gl=o(),d(Ve.$$.fragment),$l=o(),d(Re.$$.fragment),hl=o(),Xe=a("p"),Xe.innerHTML=Li,jl=o(),Ee=a("ol"),Ee.innerHTML=Vi,Ul=o(),Fe=a("p"),Fe.innerHTML=Ri,Zl=o(),Ye=a("p"),Ye.textContent=Xi,Bl=o(),d(Ne.$$.fragment),xl=o(),d(Pe.$$.fragment),kl=o(),Ae=a("p"),Ae.innerHTML=Ei,Wl=o(),Se=a("ul"),Se.innerHTML=Fi,Cl=o(),Qe=a("p"),Qe.innerHTML=Yi,Hl=o(),qe=a("p"),qe.innerHTML=Ni,Il=o(),Ke=a("p"),Ke.innerHTML=Pi,Gl=o(),d(De.$$.fragment),Ll=o(),d(Oe.$$.fragment),Vl=o(),tt=a("p"),this.h()},l(e){const t=eo("svelte-u9bgzb",document.head);T=s(t,"META",{name:!0,content:!0}),t.forEach(l),lt=n(e),et=s(e,"P",{}),Ai(et).forEach(l),it=n(e),p(y.$$.fragment,e),ot=n(e),p(v.$$.fragment,e),nt=n(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-668hq5"&&(J.textContent=El),at=n(e),p(z.$$.fragment,e),st=n(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-gf1el4"&&(_.textContent=Fl),rt=n(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1m5uxey"&&(w.textContent=Yl),dt=n(e),g=s(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-57nl0c"&&(g.innerHTML=Nl),pt=n(e),p($.$$.fragment,e),mt=n(e),h=s(e,"UL",{"data-svelte-h":!0}),r(h)!=="svelte-1jqlgbo"&&(h.innerHTML=Pl),ct=n(e),j=s(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-s7f1fx"&&(j.innerHTML=Al),ut=n(e),p(U.$$.fragment,e),Mt=n(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ggfn91"&&(Z.innerHTML=Sl),bt=n(e),p(B.$$.fragment,e),ft=n(e),p(x.$$.fragment,e),Tt=n(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1yqxt38"&&(k.innerHTML=Ql),yt=n(e),W=s(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-7vgiw8"&&(W.innerHTML=ql),vt=n(e),C=s(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-gqa7ea"&&(C.innerHTML=Kl),Jt=n(e),p(H.$$.fragment,e),zt=n(e),I=s(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-e0qch8"&&(I.innerHTML=Dl),_t=n(e),G=s(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-s7f1fx"&&(G.innerHTML=Ol),wt=n(e),p(L.$$.fragment,e),gt=n(e),V=s(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1ggfn91"&&(V.innerHTML=ei),$t=n(e),p(R.$$.fragment,e),ht=n(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1cem39h"&&(X.textContent=ti),jt=n(e),p(E.$$.fragment,e),Ut=n(e),p(F.$$.fragment,e),Zt=n(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1d9aumn"&&(Y.innerHTML=li),Bt=n(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-z35xty"&&(N.textContent=ii),xt=n(e),p(P.$$.fragment,e),kt=n(e),A=s(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1syye96"&&(A.innerHTML=oi),Wt=n(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-s7f1fx"&&(S.innerHTML=ni),Ct=n(e),p(Q.$$.fragment,e),Ht=n(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ggfn91"&&(q.innerHTML=ai),It=n(e),p(K.$$.fragment,e),Gt=n(e),p(D.$$.fragment,e),Lt=n(e),O=s(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-15fnb1f"&&(O.innerHTML=si),Vt=n(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-6z85oe"&&(ee.innerHTML=ri),Rt=n(e),p(te.$$.fragment,e),Xt=n(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1bl6pbd"&&(le.innerHTML=di),Et=n(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-s7f1fx"&&(ie.innerHTML=pi),Ft=n(e),p(oe.$$.fragment,e),Yt=n(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1ggfn91"&&(ne.innerHTML=mi),Nt=n(e),p(ae.$$.fragment,e),Pt=n(e),se=s(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1cem39h"&&(se.textContent=ci),At=n(e),p(re.$$.fragment,e),St=n(e),p(de.$$.fragment,e),Qt=n(e),pe=s(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1jgy8li"&&(pe.innerHTML=ui),qt=n(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1jjvwm4"&&(me.textContent=Mi),Kt=n(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-ykanzw"&&(ce.textContent=bi),Dt=n(e),ue=s(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-19g3nxw"&&(ue.innerHTML=fi),Ot=n(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ja413z"&&(Me.textContent=Ti),el=n(e),be=s(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-1wt3yrf"&&(be.innerHTML=yi),tl=n(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1hgabrv"&&(fe.textContent=vi),ll=n(e),Te=s(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-31xrbn"&&(Te.innerHTML=Ji),il=n(e),ye=s(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-170kx12"&&(ye.innerHTML=zi),ol=n(e),ve=s(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-1d9dzd2"&&(ve.innerHTML=_i),nl=n(e),Je=s(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-uuss7p"&&(Je.innerHTML=wi),al=n(e),ze=s(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-1e9eo3a"&&(ze.innerHTML=gi),sl=n(e),_e=s(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-13a2h9b"&&(_e.textContent=$i),rl=n(e),we=s(e,"UL",{"data-svelte-h":!0}),r(we)!=="svelte-g6j8ra"&&(we.innerHTML=hi),dl=n(e),ge=s(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1k2o8s3"&&(ge.textContent=ji),pl=n(e),$e=s(e,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-8otb07"&&($e.innerHTML=Ui),ml=n(e),p(he.$$.fragment,e),cl=n(e),je=s(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-l36xrj"&&(je.innerHTML=Zi),ul=n(e),p(Ue.$$.fragment,e),Ml=n(e),Ze=s(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-seplpo"&&(Ze.innerHTML=Bi),bl=n(e),Be=s(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1ro2lsk"&&(Be.innerHTML=xi),fl=n(e),xe=s(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1plbv18"&&(xe.innerHTML=ki),Tl=n(e),p(ke.$$.fragment,e),yl=n(e),We=s(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-q2e62a"&&(We.innerHTML=Wi),vl=n(e),p(Ce.$$.fragment,e),Jl=n(e),He=s(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-4cf5r"&&(He.innerHTML=Ci),zl=n(e),Ie=s(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-bgxvfx"&&(Ie.innerHTML=Hi),_l=n(e),Ge=s(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1jfesn2"&&(Ge.innerHTML=Ii),wl=n(e),Le=s(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-83adx7"&&(Le.innerHTML=Gi),gl=n(e),p(Ve.$$.fragment,e),$l=n(e),p(Re.$$.fragment,e),hl=n(e),Xe=s(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1d5f1v"&&(Xe.innerHTML=Li),jl=n(e),Ee=s(e,"OL",{"data-svelte-h":!0}),r(Ee)!=="svelte-5qzntw"&&(Ee.innerHTML=Vi),Ul=n(e),Fe=s(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1pjusnp"&&(Fe.innerHTML=Ri),Zl=n(e),Ye=s(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1nimzcx"&&(Ye.textContent=Xi),Bl=n(e),p(Ne.$$.fragment,e),xl=n(e),p(Pe.$$.fragment,e),kl=n(e),Ae=s(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-2o9zch"&&(Ae.innerHTML=Ei),Wl=n(e),Se=s(e,"UL",{"data-svelte-h":!0}),r(Se)!=="svelte-15b1x1u"&&(Se.innerHTML=Fi),Cl=n(e),Qe=s(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-5iz2eq"&&(Qe.innerHTML=Yi),Hl=n(e),qe=s(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-18bzze7"&&(qe.innerHTML=Ni),Il=n(e),Ke=s(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-hz6tan"&&(Ke.innerHTML=Pi),Gl=n(e),p(De.$$.fragment,e),Ll=n(e),p(Oe.$$.fragment,e),Vl=n(e),tt=s(e,"P",{}),Ai(tt).forEach(l),this.h()},h(){Si(T,"name","hf:doc:metadata"),Si(T,"content",oo)},m(e,t){to(document.head,T),i(e,lt,t),i(e,et,t),i(e,it,t),m(y,e,t),i(e,ot,t),m(v,e,t),i(e,nt,t),i(e,J,t),i(e,at,t),m(z,e,t),i(e,st,t),i(e,_,t),i(e,rt,t),i(e,w,t),i(e,dt,t),i(e,g,t),i(e,pt,t),m($,e,t),i(e,mt,t),i(e,h,t),i(e,ct,t),i(e,j,t),i(e,ut,t),m(U,e,t),i(e,Mt,t),i(e,Z,t),i(e,bt,t),m(B,e,t),i(e,ft,t),m(x,e,t),i(e,Tt,t),i(e,k,t),i(e,yt,t),i(e,W,t),i(e,vt,t),i(e,C,t),i(e,Jt,t),m(H,e,t),i(e,zt,t),i(e,I,t),i(e,_t,t),i(e,G,t),i(e,wt,t),m(L,e,t),i(e,gt,t),i(e,V,t),i(e,$t,t),m(R,e,t),i(e,ht,t),i(e,X,t),i(e,jt,t),m(E,e,t),i(e,Ut,t),m(F,e,t),i(e,Zt,t),i(e,Y,t),i(e,Bt,t),i(e,N,t),i(e,xt,t),m(P,e,t),i(e,kt,t),i(e,A,t),i(e,Wt,t),i(e,S,t),i(e,Ct,t),m(Q,e,t),i(e,Ht,t),i(e,q,t),i(e,It,t),m(K,e,t),i(e,Gt,t),m(D,e,t),i(e,Lt,t),i(e,O,t),i(e,Vt,t),i(e,ee,t),i(e,Rt,t),m(te,e,t),i(e,Xt,t),i(e,le,t),i(e,Et,t),i(e,ie,t),i(e,Ft,t),m(oe,e,t),i(e,Yt,t),i(e,ne,t),i(e,Nt,t),m(ae,e,t),i(e,Pt,t),i(e,se,t),i(e,At,t),m(re,e,t),i(e,St,t),m(de,e,t),i(e,Qt,t),i(e,pe,t),i(e,qt,t),i(e,me,t),i(e,Kt,t),i(e,ce,t),i(e,Dt,t),i(e,ue,t),i(e,Ot,t),i(e,Me,t),i(e,el,t),i(e,be,t),i(e,tl,t),i(e,fe,t),i(e,ll,t),i(e,Te,t),i(e,il,t),i(e,ye,t),i(e,ol,t),i(e,ve,t),i(e,nl,t),i(e,Je,t),i(e,al,t),i(e,ze,t),i(e,sl,t),i(e,_e,t),i(e,rl,t),i(e,we,t),i(e,dl,t),i(e,ge,t),i(e,pl,t),i(e,$e,t),i(e,ml,t),m(he,e,t),i(e,cl,t),i(e,je,t),i(e,ul,t),m(Ue,e,t),i(e,Ml,t),i(e,Ze,t),i(e,bl,t),i(e,Be,t),i(e,fl,t),i(e,xe,t),i(e,Tl,t),m(ke,e,t),i(e,yl,t),i(e,We,t),i(e,vl,t),m(Ce,e,t),i(e,Jl,t),i(e,He,t),i(e,zl,t),i(e,Ie,t),i(e,_l,t),i(e,Ge,t),i(e,wl,t),i(e,Le,t),i(e,gl,t),m(Ve,e,t),i(e,$l,t),m(Re,e,t),i(e,hl,t),i(e,Xe,t),i(e,jl,t),i(e,Ee,t),i(e,Ul,t),i(e,Fe,t),i(e,Zl,t),i(e,Ye,t),i(e,Bl,t),m(Ne,e,t),i(e,xl,t),m(Pe,e,t),i(e,kl,t),i(e,Ae,t),i(e,Wl,t),i(e,Se,t),i(e,Cl,t),i(e,Qe,t),i(e,Hl,t),i(e,qe,t),i(e,Il,t),i(e,Ke,t),i(e,Gl,t),m(De,e,t),i(e,Ll,t),m(Oe,e,t),i(e,Vl,t),i(e,tt,t),Rl=!0},p:qi,i(e){Rl||(c(y.$$.fragment,e),c(v.$$.fragment,e),c(z.$$.fragment,e),c($.$$.fragment,e),c(U.$$.fragment,e),c(B.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(R.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),c(P.$$.fragment,e),c(Q.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(Ue.$$.fragment,e),c(ke.$$.fragment,e),c(Ce.$$.fragment,e),c(Ve.$$.fragment,e),c(Re.$$.fragment,e),c(Ne.$$.fragment,e),c(Pe.$$.fragment,e),c(De.$$.fragment,e),c(Oe.$$.fragment,e),Rl=!0)},o(e){u(y.$$.fragment,e),u(v.$$.fragment,e),u(z.$$.fragment,e),u($.$$.fragment,e),u(U.$$.fragment,e),u(B.$$.fragment,e),u(x.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(Q.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(Ce.$$.fragment,e),u(Ve.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),u(Pe.$$.fragment,e),u(De.$$.fragment,e),u(Oe.$$.fragment,e),Rl=!1},d(e){e&&(l(lt),l(et),l(it),l(ot),l(nt),l(J),l(at),l(st),l(_),l(rt),l(w),l(dt),l(g),l(pt),l(mt),l(h),l(ct),l(j),l(ut),l(Mt),l(Z),l(bt),l(ft),l(Tt),l(k),l(yt),l(W),l(vt),l(C),l(Jt),l(zt),l(I),l(_t),l(G),l(wt),l(gt),l(V),l($t),l(ht),l(X),l(jt),l(Ut),l(Zt),l(Y),l(Bt),l(N),l(xt),l(kt),l(A),l(Wt),l(S),l(Ct),l(Ht),l(q),l(It),l(Gt),l(Lt),l(O),l(Vt),l(ee),l(Rt),l(Xt),l(le),l(Et),l(ie),l(Ft),l(Yt),l(ne),l(Nt),l(Pt),l(se),l(At),l(St),l(Qt),l(pe),l(qt),l(me),l(Kt),l(ce),l(Dt),l(ue),l(Ot),l(Me),l(el),l(be),l(tl),l(fe),l(ll),l(Te),l(il),l(ye),l(ol),l(ve),l(nl),l(Je),l(al),l(ze),l(sl),l(_e),l(rl),l(we),l(dl),l(ge),l(pl),l($e),l(ml),l(cl),l(je),l(ul),l(Ml),l(Ze),l(bl),l(Be),l(fl),l(xe),l(Tl),l(yl),l(We),l(vl),l(Jl),l(He),l(zl),l(Ie),l(_l),l(Ge),l(wl),l(Le),l(gl),l($l),l(hl),l(Xe),l(jl),l(Ee),l(Ul),l(Fe),l(Zl),l(Ye),l(Bl),l(xl),l(kl),l(Ae),l(Wl),l(Se),l(Cl),l(Qe),l(Hl),l(qe),l(Il),l(Ke),l(Gl),l(Ll),l(Vl),l(tt)),l(T),M(y,e),M(v,e),M(z,e),M($,e),M(U,e),M(B,e),M(x,e),M(H,e),M(L,e),M(R,e),M(E,e),M(F,e),M(P,e),M(Q,e),M(K,e),M(D,e),M(te,e),M(oe,e),M(ae,e),M(re,e),M(de,e),M(he,e),M(Ue,e),M(ke,e),M(Ce,e),M(Ve,e),M(Re,e),M(Ne,e),M(Pe,e),M(De,e),M(Oe,e)}}}const oo='{"title":"Migrazione da pacchetti precedenti","local":"migrazione-da-pacchetti-precedenti","sections":[{"title":"Migrazione da transformers v3.x a v4.x","local":"migrazione-da-transformers-v3x-a-v4x","sections":[{"title":"1. AutoTokenizer e pipeline ora utilizzano tokenizer veloci (rust) per impostazione predefinita.","local":"1-autotokenizer-e-pipeline-ora-utilizzano-tokenizer-veloci-rust-per-impostazione-predefinita","sections":[{"title":"Come ottenere lo stesso comportamento di v3.x in v4.x","local":"come-ottenere-lo-stesso-comportamento-di-v3x-in-v4x","sections":[],"depth":5}],"depth":4},{"title":"2. SentencePiece è stato rimosso dalle dipendenze richieste","local":"2-sentencepiece-è-stato-rimosso-dalle-dipendenze-richieste","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"3. L’architettura delle repo è stato aggiornata in modo che ogni modello abbia la propria cartella","local":"3-larchitettura-delle-repo-è-stato-aggiornata-in-modo-che-ogni-modello-abbia-la-propria-cartella","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"4. Impostare l’argomento return_dict su True per impostazione predefinita","local":"4-impostare-largomento-returndict-su-true-per-impostazione-predefinita","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"5. Rimozione di alcuni attributi deprecati","local":"5-rimozione-di-alcuni-attributi-deprecati","sections":[],"depth":4}],"depth":2},{"title":"Passaggio da pytorch-transformers a 🤗 Transformers","local":"passaggio-da-pytorch-transformers-a--transformers","sections":[{"title":"L’ordine posizionale di alcune parole chiave di input dei modelli ( attention_mask , token_type_ids …) è cambiato","local":"lordine-posizionale-di-alcune-parole-chiave-di-input-dei-modelli--attentionmask--tokentypeids--è-cambiato","sections":[],"depth":3}],"depth":2},{"title":"Migrazione da pytorch-pretrained-bert","local":"migrazione-da-pytorch-pretrained-bert","sections":[{"title":"I modelli restituiscono sempre tuple","local":"i-modelli-restituiscono-sempre-tuple","sections":[],"depth":3},{"title":"Serializzazione","local":"serializzazione","sections":[],"depth":3},{"title":"Ottimizzatori: BertAdam e OpenAIAdam ora sono AdamW, lo scheduling è quello standard PyTorch","local":"ottimizzatori-bertadam-e-openaiadam-ora-sono-adamw-lo-scheduling-è-quello-standard-pytorch","sections":[],"depth":3}],"depth":2}],"depth":1}';function no(Xl){return Ki(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mo extends Di{constructor(T){super(),Oi(this,T,no,io,Qi,{})}}export{mo as component};
