import{s as Yo,o as Qo,n as rt}from"../chunks/scheduler.25b97de1.js";import{S as Ko,i as en,g as i,s as n,r as u,A as tn,h as d,f as s,c as r,j as z,u as f,x as h,k as C,y as t,a as l,v as _,d as g,t as T,w}from"../chunks/index.d9030fc9.js";import{T as fo}from"../chunks/Tip.baa67368.js";import{D as Z}from"../chunks/Docstring.e257edda.js";import{C as go}from"../chunks/CodeBlock.e6cd0d95.js";import{E as _o}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as B,E as on}from"../chunks/EditOnGithub.91d95064.js";function nn($){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(p){a=d(p,"P",{"data-svelte-h":!0}),h(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(p,m){l(p,a,m)},p:rt,d(p){p&&s(a)}}}function rn($){let a,b="Example:",p,m,y;return m=new go({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnN3aXRjaC1iYXNlLTglMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGc3dpdGNoLWJhc2UtOCUyMiklMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJTdHVkaWVzJTIwc2hvdyUyMHRoYXQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBJTBBJTIzJTIwcHJlcHJvY2VzcyUzQSUyMFByZXBlbmQlMjBkZWNvZGVyX2lucHV0X2lkcyUyMHdpdGglMjBzdGFydCUyMHRva2VuJTIwd2hpY2glMjBpcyUyMHBhZCUyMHRva2VuJTIwZm9yJTIwU3dpdGNoVHJhbnNmb3JtZXJzTW9kZWwuJTBBJTIzJTIwVGhpcyUyMGlzJTIwbm90JTIwbmVlZGVkJTIwZm9yJTIwdG9yY2gncyUyMFN3aXRjaFRyYW5zZm9ybWVyc0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyMGFzJTIwaXQlMjBkb2VzJTIwdGhpcyUyMGludGVybmFsbHklMjB1c2luZyUyMGxhYmVscyUyMGFyZy4lMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMG1vZGVsLl9zaGlmdF9yaWdodChkZWNvZGVyX2lucHV0X2lkcyklMEElMEElMjMlMjBmb3J3YXJkJTIwcGFzcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersModel.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># preprocess: Prepend decoder_input_ids with start token which is pad token for SwitchTransformersModel.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is not needed for torch&#x27;s SwitchTransformersForConditionalGeneration as it does this internally using labels arg.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = model._shift_right(decoder_input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){a=i("p"),a.textContent=b,p=n(),u(m.$$.fragment)},l(c){a=d(c,"P",{"data-svelte-h":!0}),h(a)!=="svelte-11lpom8"&&(a.textContent=b),p=r(c),f(m.$$.fragment,c)},m(c,M){l(c,a,M),l(c,p,M),_(m,c,M),y=!0},p:rt,i(c){y||(g(m.$$.fragment,c),y=!0)},o(c){T(m.$$.fragment,c),y=!1},d(c){c&&(s(a),s(p)),w(m,c)}}}function sn($){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(p){a=d(p,"P",{"data-svelte-h":!0}),h(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(p,m){l(p,a,m)},p:rt,d(p){p&&s(a)}}}function an($){let a,b="Examples:",p,m,y;return m=new go({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpdGNoVHJhbnNmb3JtZXJzRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQSUwQSUyMyUyMHRyYWluaW5nJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMCUzQ2V4dHJhX2lkXzAlM0UlMjB3YWxrcyUyMGluJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHBhcmslMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyJTNDZXh0cmFfaWRfMCUzRSUyMGN1dGUlMjBkb2clMjAlM0NleHRyYV9pZF8xJTNFJTIwdGhlJTIwJTNDZXh0cmFfaWRfMiUzRSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBJTIzJTIwaW5mZXJlbmNlJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMnN1bW1hcml6ZSUzQSUyMHN0dWRpZXMlMjBoYXZlJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzKSUwQSUyMyUyMC4lMjBUbyUyQyUyMGxldCVFMiU4MCU5OXMlMjBzYXklMjB5b3UlMjBoYXZlJTIwYSUyMGRvZy4lMjBUbyUyMHN1bW1hcml6ZSUzQSUwQSUyMyUyMFNpbmNlJTIwdGhlJTIwbW9kZWwlMjBoYXMlMjBiZWVuJTIwdHJhaW5lZCUyMG9uJTIwTUxNJTJDJTIwdGhpcyUyMHdpbGwlMjBvdXRwdXQlMjBnaWJiZXJpc2g=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;&lt;extra_id_0&gt; cute dog &lt;extra_id_1&gt; the &lt;extra_id_2&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;summarize: studies have shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># . To, let’s say you have a dog. To summarize:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since the model has been trained on MLM, this will output gibberish</span>`,wrap:!1}}),{c(){a=i("p"),a.textContent=b,p=n(),u(m.$$.fragment)},l(c){a=d(c,"P",{"data-svelte-h":!0}),h(a)!=="svelte-kvfsh7"&&(a.textContent=b),p=r(c),f(m.$$.fragment,c)},m(c,M){l(c,a,M),l(c,p,M),_(m,c,M),y=!0},p:rt,i(c){y||(g(m.$$.fragment,c),y=!0)},o(c){T(m.$$.fragment,c),y=!1},d(c){c&&(s(a),s(p)),w(m,c)}}}function dn($){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(p){a=d(p,"P",{"data-svelte-h":!0}),h(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(p,m){l(p,a,m)},p:rt,d(p){p&&s(a)}}}function ln($){let a,b="Example:",p,m,y;return m=new go({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNFbmNvZGVyTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpdGNoVHJhbnNmb3JtZXJzRW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJTdHVkaWVzJTIwaGF2ZSUyMGJlZW4lMjBzaG93biUyMHRoYXQlMjBvd25pbmclMjBhJTIwZG9nJTIwaXMlMjBnb29kJTIwZm9yJTIweW91JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkuaW5wdXRfaWRzJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersEncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersEncoderModel.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){a=i("p"),a.textContent=b,p=n(),u(m.$$.fragment)},l(c){a=d(c,"P",{"data-svelte-h":!0}),h(a)!=="svelte-11lpom8"&&(a.textContent=b),p=r(c),f(m.$$.fragment,c)},m(c,M){l(c,a,M),l(c,p,M),_(m,c,M),y=!0},p:rt,i(c){y||(g(m.$$.fragment,c),y=!0)},o(c){T(m.$$.fragment,c),y=!1},d(c){c&&(s(a),s(p)),w(m,c)}}}function cn($){let a,b,p,m,y,c,M,at,ne,To='The SwitchTransformers model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity</a> by William Fedus, Barret Zoph, Noam Shazeer.',it,re,wo=`The Switch Transformer model uses a sparse T5 encoder-decoder architecture, where the MLP are replaced by a Mixture of Experts (MoE). A routing mechanism (top 1 in this case) associates each token to one of the expert, where each expert is a dense MLP. While switch transformers have a lot more weights than their equivalent dense models, the sparsity allows better scaling and better finetuning performance at scale.
During a forward pass, only a fraction of the weights are used. The routing mechanism allows the model to select relevant weights on the fly which increases the model capacity without increasing the number of operations.`,dt,se,bo="The abstract from the paper is the following:",lt,ae,yo="<em>In deep learning, models typically reuse the same parameters for all inputs. Mixture of Experts (MoE) defies this and instead selects different parameters for each incoming example. The result is a sparsely-activated model — with outrageous numbers of parameters — but a constant computational cost. However, despite several notable successes of MoE, widespread adoption has been hindered by complexity, communication costs and training instability — we address these with the Switch Transformer. We simplify the MoE routing algorithm and design intuitive improved models with reduced communication and computational costs. Our proposed training techniques help wrangle the instabilities and we show large sparse models may be trained, for the first time, with lower precision (bfloat16) formats. We design models based off T5-Base and T5-Large to obtain up to 7x increases in pre-training speed with the same computational resources. These improvements extend into multilingual settings where we measure gains over the mT5-Base version across all 101 languages. Finally, we advance the current scale of language models by pre-training up to trillion parameter models on the “Colossal Clean Crawled Corpus” and achieve a 4x speedup over the T5-XXL model.</em>",ct,ie,Mo=`This model was contributed by <a href="https://huggingface.co/ybelkada" rel="nofollow">Younes Belkada</a> and <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>.
The original code can be found <a href="https://github.com/google/flaxformer/tree/main/flaxformer/architectures/moe" rel="nofollow">here</a>.`,ht,de,pt,le,vo='<li>SwitchTransformers uses the <a href="/docs/transformers/pr_29077/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>, which can be loaded directly from each model’s repository.</li> <li>The released weights are pretrained on English <a href="https://moon-ci-docs.huggingface.co/docs/transformers/pr_19323/en/glossary#general-terms" rel="nofollow">Masked Language Modeling</a> task, and should be finetuned.</li>',mt,ce,ut,he,ko='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',ft,pe,_t,W,me,Ft,Ue,So=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a>. It is used to
instantiate a SwitchTransformers model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the
SwitchTransformers <a href="https://huggingface.co/google/switch-base-8" rel="nofollow">google/switch-base-8</a> architecture.`,jt,He,xo=`Configuration objects inherit from <a href="/docs/transformers/pr_29077/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_29077/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,gt,ue,Tt,x,fe,Ut,Je,$o="Router using tokens choose top-1 experts assignment.",Ht,Ie,zo=`This router uses the same mechanism as in Switch Transformer (<a href="https://arxiv.org/abs/2101.03961" rel="nofollow">https://arxiv.org/abs/2101.03961</a>) and V-MoE
(<a href="https://arxiv.org/abs/2106.05974" rel="nofollow">https://arxiv.org/abs/2106.05974</a>): tokens choose their top experts. Items are sorted by router_probs and then
routed to their choice of expert until the expert’s expert_capacity is reached. <strong>There is no guarantee that each
token is processed by an expert</strong>, or that each expert receives at least one token.`,Jt,X,_e,It,Re,Co="Computes router probabilities from input hidden states.",Rt,N,ge,qt,qe,Fo=`Generic forward function for every Router class. Each Router expects to have the same input hidden states
(<code>hidden_states</code>) corresponding to the hidden states for each token, the <code>expert_capacity</code> corresponding to the
number of tokens the Router will send to each expert, some Routers can send up to few tokens to each expert.`,Zt,Ze,jo=`Each Router works as the following: it expects the hidden states for each token, gets the <code>router_probs</code> and
<code>router_logits</code> from the <code>router_weights</code>. This will assign for each token, the raw probability to be assigned
to an expert. Then each Router class will have to define its own <code>_compute_routing_instructions</code>.`,wt,Te,bt,E,we,Wt,We,Uo="Implementation of the Switch Transformers Sparse MLP module.",Et,j,be,Gt,Ee,Ho="Hold on, this will be slightly tricky to understand In the correct order, a MoE layer does the following:",Nt,Ge,Jo=`1- Gets the <code>router_mask</code> from the router. The shape of the mask is <code>(batch_size, sequence_length, num_expert)</code>
and corresponds to the argmax of the <code>router_probs</code>. The probabilities are needed in the computation of the
hidden states : they are broadcasted to the hidden states values (can be interpreted as a scaling factor).`,Bt,Ne,Io=`2- Dispatch the tokens to its associated experts. We do a classic for loop over the experts and assign for each
expert the corresponding hidden states.`,yt,ye,Mt,v,Me,Lt,Be,Ro="The bare SWITCH_TRANSFORMERS Model transformer outputting raw hidden-states without any specific head on top.",Pt,Le,qo=`The SWITCH_TRANSFORMERS model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with
Simple and Efficient Sparsity</a> by <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Fedus%2C+W" rel="nofollow">William
Fedus</a>, <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Zoph%2C+B" rel="nofollow">Barret
Zoph</a>, and <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Shazeer%2C+N" rel="nofollow">Noam
Shazeer</a>. It’s an encoder-decoder T5-like model
with sparse Feed Forward that stands for Mixture of Experts (MoE) architecture.`,Vt,Pe,Zo=`This model inherits from <a href="/docs/transformers/pr_29077/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xt,Ve,Wo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ot,U,ve,At,Xe,Eo='The <a href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> forward method, overrides the <code>__call__</code> special method.',Dt,O,Yt,A,vt,ke,kt,k,Se,Qt,Oe,Go="SWITCH_TRANSFORMERS Model with a <code>language modeling</code> head on top.",Kt,Ae,No=`The SWITCH_TRANSFORMERS model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with
Simple and Efficient Sparsity</a> by <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Fedus%2C+W" rel="nofollow">William
Fedus</a>, <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Zoph%2C+B" rel="nofollow">Barret
Zoph</a>, and <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Shazeer%2C+N" rel="nofollow">Noam
Shazeer</a>. It’s an encoder-decoder T5-like model
with sparse Feed Forward that stands for Mixture of Experts (MoE) architecture.`,eo,De,Bo=`This model inherits from <a href="/docs/transformers/pr_29077/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,to,Ye,Lo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,oo,H,xe,no,Qe,Po='The <a href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',ro,D,so,Y,St,$e,xt,S,ze,ao,Ke,Vo="The bare SWITCH_TRANSFORMERS Model transformer outputting encoder’s raw hidden-states without any specific head on top.",io,et,Xo=`The SWITCH_TRANSFORMERS model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with
Simple and Efficient Sparsity</a> by <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Fedus%2C+W" rel="nofollow">William
Fedus</a>, <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Zoph%2C+B" rel="nofollow">Barret
Zoph</a>, and <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Shazeer%2C+N" rel="nofollow">Noam
Shazeer</a>. It’s an encoder-decoder T5-like model
with sparse Feed Forward that stands for Mixture of Experts (MoE) architecture.`,lo,tt,Oo=`This model inherits from <a href="/docs/transformers/pr_29077/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,co,ot,Ao=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ho,J,Ce,po,nt,Do='The <a href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersEncoderModel">SwitchTransformersEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',mo,Q,uo,K,$t,Fe,zt,st,Ct;return y=new B({props:{title:"SwitchTransformers",local:"switchtransformers",headingTag:"h1"}}),M=new B({props:{title:"Overview",local:"overview",headingTag:"h2"}}),de=new B({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ce=new B({props:{title:"Resources",local:"resources",headingTag:"h2"}}),pe=new B({props:{title:"SwitchTransformersConfig",local:"transformers.SwitchTransformersConfig",headingTag:"h2"}}),me=new Z({props:{name:"class transformers.SwitchTransformersConfig",anchor:"transformers.SwitchTransformersConfig",parameters:[{name:"vocab_size",val:" = 32128"},{name:"d_model",val:" = 768"},{name:"d_kv",val:" = 64"},{name:"d_ff",val:" = 2048"},{name:"expert_capacity",val:" = 64"},{name:"num_layers",val:" = 12"},{name:"num_sparse_encoder_layers",val:" = 3"},{name:"num_decoder_layers",val:" = 12"},{name:"num_sparse_decoder_layers",val:" = 3"},{name:"num_heads",val:" = 12"},{name:"num_experts",val:" = 8"},{name:"router_bias",val:" = False"},{name:"router_jitter_noise",val:" = 0.01"},{name:"router_dtype",val:" = 'float32'"},{name:"router_ignore_padding_tokens",val:" = False"},{name:"relative_attention_num_buckets",val:" = 32"},{name:"relative_attention_max_distance",val:" = 128"},{name:"dropout_rate",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"router_z_loss_coef",val:" = 0.001"},{name:"router_aux_loss_coef",val:" = 0.001"},{name:"initializer_factor",val:" = 1.0"},{name:"dense_act_fn",val:" = 'relu'"},{name:"is_encoder_decoder",val:" = True"},{name:"add_router_probs",val:" = False"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SwitchTransformersConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32128) &#x2014;
Vocabulary size of the SwitchTransformers model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a>.`,name:"vocab_size"},{anchor:"transformers.SwitchTransformersConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.SwitchTransformersConfig.d_kv",description:`<strong>d_kv</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the key, query, value projections per attention head. <code>d_kv</code> has to be equal to <code>d_model // num_heads</code>.`,name:"d_kv"},{anchor:"transformers.SwitchTransformersConfig.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Size of the intermediate feed forward layer in each <code>SwitchTransformersBlock</code>.`,name:"d_ff"},{anchor:"transformers.SwitchTransformersConfig.expert_capacity",description:`<strong>expert_capacity</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of tokens that can be stored in each expert. If set to 1, the model will behave like a regular
Transformer.`,name:"expert_capacity"},{anchor:"transformers.SwitchTransformersConfig.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of dense hidden layers in the Transformer encoder layer.`,name:"num_layers"},{anchor:"transformers.SwitchTransformersConfig.num_sparse_encoder_layers",description:`<strong>num_sparse_encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of sparse (MoE) dense hidden layers in the Transformer encoder layer.`,name:"num_sparse_encoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_decoder_layers",description:`<strong>num_decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer decoder. Will use the same value as <code>num_layers</code> if not set.`,name:"num_decoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_sparse_decoder_layers",description:`<strong>num_sparse_decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of sparse (MoE) dense hidden layers in the Transformer decoder layer.`,name:"num_sparse_decoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.SwitchTransformersConfig.num_experts",description:`<strong>num_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of experts for each SwitchTransformer layer.`,name:"num_experts"},{anchor:"transformers.SwitchTransformersConfig.router_bias",description:`<strong>router_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a bias to the router.`,name:"router_bias"},{anchor:"transformers.SwitchTransformersConfig.router_jitter_noise",description:`<strong>router_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
Amount of noise to add to the router.`,name:"router_jitter_noise"},{anchor:"transformers.SwitchTransformersConfig.router_dtype",description:`<strong>router_dtype</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;float32&quot;</code>) &#x2014;
The <code>dtype</code> used for the routers. It is preferable to keep the <code>dtype</code> to <code>&quot;float32&quot;</code> as specified in the
<em>selective precision</em> discussion in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">the paper</a>.`,name:"router_dtype"},{anchor:"transformers.SwitchTransformersConfig.router_ignore_padding_tokens",description:`<strong>router_ignore_padding_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to ignore padding tokens when routing.`,name:"router_ignore_padding_tokens"},{anchor:"transformers.SwitchTransformersConfig.relative_attention_num_buckets",description:`<strong>relative_attention_num_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of buckets to use for each attention layer.`,name:"relative_attention_num_buckets"},{anchor:"transformers.SwitchTransformersConfig.relative_attention_max_distance",description:`<strong>relative_attention_max_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The maximum distance of the longer sequences for the bucket separation.`,name:"relative_attention_max_distance"},{anchor:"transformers.SwitchTransformersConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.SwitchTransformersConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SwitchTransformersConfig.router_z_loss_coef",description:`<strong>router_z_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The z loss factor for the total loss.`,name:"router_z_loss_coef"},{anchor:"transformers.SwitchTransformersConfig.router_aux_loss_coef",description:`<strong>router_aux_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The aux loss factor for the total loss.`,name:"router_aux_loss_coef"},{anchor:"transformers.SwitchTransformersConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.SwitchTransformersConfig.dense_act_fn",description:`<strong>dense_act_fn</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Type of feed forward layer to be used. Should be one of <code>&quot;relu&quot;</code> or <code>&quot;gated-gelu&quot;</code>. SwitchTransformersv1.1
uses the <code>&quot;gated-gelu&quot;</code> feed forward projection. Original SwitchTransformers uses <code>&quot;relu&quot;</code>.`,name:"dense_act_fn"},{anchor:"transformers.SwitchTransformersConfig.add_router_probs",description:`<strong>add_router_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to output router probabilities to compute router auxiliary loss.`,name:"add_router_probs"},{anchor:"transformers.SwitchTransformersConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/configuration_switch_transformers.py#L24"}}),ue=new B({props:{title:"SwitchTransformersTop1Router",local:"transformers.SwitchTransformersTop1Router",headingTag:"h2"}}),fe=new Z({props:{name:"class transformers.SwitchTransformersTop1Router",anchor:"transformers.SwitchTransformersTop1Router",parameters:[{name:"config",val:": SwitchTransformersConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L117"}}),_e=new Z({props:{name:"_compute_router_probabilities",anchor:"transformers.SwitchTransformersTop1Router._compute_router_probabilities",parameters:[{name:"hidden_states",val:": Tensor"}],parametersDescription:[{anchor:"transformers.SwitchTransformersTop1Router._compute_router_probabilities.hidden_states",description:`<strong>hidden_states</strong> (<code>torch.Tensor</code>) &#x2014;
(batch_size, sequence_length, hidden_dim) from which router probabilities are computed.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L137",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Tensor of shape (batch_size, sequence_length, num_experts) corresponding to the probabilities for each
token and expert. Used for routing tokens to experts.
router_logits (<code>torch.Tensor</code>):
Logits tensor of shape (batch_size, sequence_length, num_experts) corresponding to raw router logits.
This is used later for computing router z-loss.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>router_probabilities (<code>torch.Tensor</code>)</p>
`}}),ge=new Z({props:{name:"forward",anchor:"transformers.SwitchTransformersTop1Router.forward",parameters:[{name:"hidden_states",val:": Tensor"}],parametersDescription:[{anchor:"transformers.SwitchTransformersTop1Router.forward.hidden_states",description:`<strong>hidden_states</strong> (<code>torch.Tensor</code>)  &#x2014;
[num_groups, tokens_per_group, hidden_dim] inputs to send to experts.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L178",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Tuple[<code>torch.Tensor</code>, <code>torch.Tensor</code>, <code>torch.Tensor</code>] Tuple containing the expert index, the router probs
and the router logits. The router probabilities and logits are required to compute the loss.</p>
`}}),Te=new B({props:{title:"SwitchTransformersSparseMLP",local:"transformers.SwitchTransformersSparseMLP",headingTag:"h2"}}),we=new Z({props:{name:"class transformers.SwitchTransformersSparseMLP",anchor:"transformers.SwitchTransformersSparseMLP",parameters:[{name:"config",val:": SwitchTransformersConfig"},{name:"expert_class",val:": Module = <class 'transformers.models.switch_transformers.modeling_switch_transformers.SwitchTransformersDenseActDense'>"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L262"}}),be=new Z({props:{name:"forward",anchor:"transformers.SwitchTransformersSparseMLP.forward",parameters:[{name:"hidden_states",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L277"}}),ye=new B({props:{title:"SwitchTransformersModel",local:"transformers.SwitchTransformersModel",headingTag:"h2"}}),Me=new Z({props:{name:"class transformers.SwitchTransformersModel",anchor:"transformers.SwitchTransformersModel",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_29077/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1282"}}),ve=new Z({props:{name:"forward",anchor:"transformers.SwitchTransformersModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"decoder_input_ids",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"decoder_head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_router_logits",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29077/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29077/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>SWITCH_TRANSFORMERS uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.SwitchTransformersModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SwitchTransformersModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SwitchTransformersModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SwitchTransformersModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SwitchTransformersModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29077/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1337",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.Seq2SeqMoEModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>decoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>encoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the encoder model, useful to compute the auxiliary loss and the z_loss for the sparse
modules.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.Seq2SeqMoEModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new fo({props:{$$slots:{default:[nn]},$$scope:{ctx:$}}}),A=new _o({props:{anchor:"transformers.SwitchTransformersModel.forward.example",$$slots:{default:[rn]},$$scope:{ctx:$}}}),ke=new B({props:{title:"SwitchTransformersForConditionalGeneration",local:"transformers.SwitchTransformersForConditionalGeneration",headingTag:"h2"}}),Se=new Z({props:{name:"class transformers.SwitchTransformersForConditionalGeneration",anchor:"transformers.SwitchTransformersForConditionalGeneration",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_29077/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1456"}}),xe=new Z({props:{name:"forward",anchor:"transformers.SwitchTransformersForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"decoder_input_ids",val:": Optional = None"},{name:"decoder_attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"decoder_head_mask",val:": Optional = None"},{name:"cross_attn_head_mask",val:": Optional = None"},{name:"encoder_outputs",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"decoder_inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_router_logits",val:": Optional = True"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29077/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29077/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>SWITCH_TRANSFORMERS uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29077/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1516",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.Seq2SeqMoEOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>decoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>encoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the encoder model, useful to compute the auxiliary loss and z_loss for Mixture of Experts
models.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.Seq2SeqMoEOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new fo({props:{$$slots:{default:[sn]},$$scope:{ctx:$}}}),Y=new _o({props:{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.example",$$slots:{default:[an]},$$scope:{ctx:$}}}),$e=new B({props:{title:"SwitchTransformersEncoderModel",local:"transformers.SwitchTransformersEncoderModel",headingTag:"h2"}}),ze=new Z({props:{name:"class transformers.SwitchTransformersEncoderModel",anchor:"transformers.SwitchTransformersEncoderModel",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_29077/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1779"}}),Ce=new Z({props:{name:"forward",anchor:"transformers.SwitchTransformersEncoderModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_router_logits",val:": Optional = True"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersEncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29077/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29077/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29077/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_29077/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1824",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoEModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_29077/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>router_probs</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router probabilities that are computed by MoE routers, these terms are used to compute the auxiliary
loss and the z_loss for Mixture of Experts models.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoEModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new fo({props:{$$slots:{default:[dn]},$$scope:{ctx:$}}}),K=new _o({props:{anchor:"transformers.SwitchTransformersEncoderModel.forward.example",$$slots:{default:[ln]},$$scope:{ctx:$}}}),Fe=new on({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/switch_transformers.md"}}),{c(){a=i("meta"),b=n(),p=i("p"),m=n(),u(y.$$.fragment),c=n(),u(M.$$.fragment),at=n(),ne=i("p"),ne.innerHTML=To,it=n(),re=i("p"),re.textContent=wo,dt=n(),se=i("p"),se.textContent=bo,lt=n(),ae=i("p"),ae.innerHTML=yo,ct=n(),ie=i("p"),ie.innerHTML=Mo,ht=n(),u(de.$$.fragment),pt=n(),le=i("ul"),le.innerHTML=vo,mt=n(),u(ce.$$.fragment),ut=n(),he=i("ul"),he.innerHTML=ko,ft=n(),u(pe.$$.fragment),_t=n(),W=i("div"),u(me.$$.fragment),Ft=n(),Ue=i("p"),Ue.innerHTML=So,jt=n(),He=i("p"),He.innerHTML=xo,gt=n(),u(ue.$$.fragment),Tt=n(),x=i("div"),u(fe.$$.fragment),Ut=n(),Je=i("p"),Je.textContent=$o,Ht=n(),Ie=i("p"),Ie.innerHTML=zo,Jt=n(),X=i("div"),u(_e.$$.fragment),It=n(),Re=i("p"),Re.textContent=Co,Rt=n(),N=i("div"),u(ge.$$.fragment),qt=n(),qe=i("p"),qe.innerHTML=Fo,Zt=n(),Ze=i("p"),Ze.innerHTML=jo,wt=n(),u(Te.$$.fragment),bt=n(),E=i("div"),u(we.$$.fragment),Wt=n(),We=i("p"),We.textContent=Uo,Et=n(),j=i("div"),u(be.$$.fragment),Gt=n(),Ee=i("p"),Ee.textContent=Ho,Nt=n(),Ge=i("p"),Ge.innerHTML=Jo,Bt=n(),Ne=i("p"),Ne.textContent=Io,yt=n(),u(ye.$$.fragment),Mt=n(),v=i("div"),u(Me.$$.fragment),Lt=n(),Be=i("p"),Be.textContent=Ro,Pt=n(),Le=i("p"),Le.innerHTML=qo,Vt=n(),Pe=i("p"),Pe.innerHTML=Zo,Xt=n(),Ve=i("p"),Ve.innerHTML=Wo,Ot=n(),U=i("div"),u(ve.$$.fragment),At=n(),Xe=i("p"),Xe.innerHTML=Eo,Dt=n(),u(O.$$.fragment),Yt=n(),u(A.$$.fragment),vt=n(),u(ke.$$.fragment),kt=n(),k=i("div"),u(Se.$$.fragment),Qt=n(),Oe=i("p"),Oe.innerHTML=Go,Kt=n(),Ae=i("p"),Ae.innerHTML=No,eo=n(),De=i("p"),De.innerHTML=Bo,to=n(),Ye=i("p"),Ye.innerHTML=Lo,oo=n(),H=i("div"),u(xe.$$.fragment),no=n(),Qe=i("p"),Qe.innerHTML=Po,ro=n(),u(D.$$.fragment),so=n(),u(Y.$$.fragment),St=n(),u($e.$$.fragment),xt=n(),S=i("div"),u(ze.$$.fragment),ao=n(),Ke=i("p"),Ke.textContent=Vo,io=n(),et=i("p"),et.innerHTML=Xo,lo=n(),tt=i("p"),tt.innerHTML=Oo,co=n(),ot=i("p"),ot.innerHTML=Ao,ho=n(),J=i("div"),u(Ce.$$.fragment),po=n(),nt=i("p"),nt.innerHTML=Do,mo=n(),u(Q.$$.fragment),uo=n(),u(K.$$.fragment),$t=n(),u(Fe.$$.fragment),zt=n(),st=i("p"),this.h()},l(e){const o=tn("svelte-u9bgzb",document.head);a=d(o,"META",{name:!0,content:!0}),o.forEach(s),b=r(e),p=d(e,"P",{}),z(p).forEach(s),m=r(e),f(y.$$.fragment,e),c=r(e),f(M.$$.fragment,e),at=r(e),ne=d(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-qxeocr"&&(ne.innerHTML=To),it=r(e),re=d(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1klyz3l"&&(re.textContent=wo),dt=r(e),se=d(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-vfdo9a"&&(se.textContent=bo),lt=r(e),ae=d(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-ev6w2b"&&(ae.innerHTML=yo),ct=r(e),ie=d(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-ks65n9"&&(ie.innerHTML=Mo),ht=r(e),f(de.$$.fragment,e),pt=r(e),le=d(e,"UL",{"data-svelte-h":!0}),h(le)!=="svelte-9jdjaq"&&(le.innerHTML=vo),mt=r(e),f(ce.$$.fragment,e),ut=r(e),he=d(e,"UL",{"data-svelte-h":!0}),h(he)!=="svelte-6ej6p2"&&(he.innerHTML=ko),ft=r(e),f(pe.$$.fragment,e),_t=r(e),W=d(e,"DIV",{class:!0});var L=z(W);f(me.$$.fragment,L),Ft=r(L),Ue=d(L,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-f736c9"&&(Ue.innerHTML=So),jt=r(L),He=d(L,"P",{"data-svelte-h":!0}),h(He)!=="svelte-16h7rv"&&(He.innerHTML=xo),L.forEach(s),gt=r(e),f(ue.$$.fragment,e),Tt=r(e),x=d(e,"DIV",{class:!0});var F=z(x);f(fe.$$.fragment,F),Ut=r(F),Je=d(F,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-12fm05d"&&(Je.textContent=$o),Ht=r(F),Ie=d(F,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-14tpjgc"&&(Ie.innerHTML=zo),Jt=r(F),X=d(F,"DIV",{class:!0});var je=z(X);f(_e.$$.fragment,je),It=r(je),Re=d(je,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-jnjz7k"&&(Re.textContent=Co),je.forEach(s),Rt=r(F),N=d(F,"DIV",{class:!0});var P=z(N);f(ge.$$.fragment,P),qt=r(P),qe=d(P,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-wi3ols"&&(qe.innerHTML=Fo),Zt=r(P),Ze=d(P,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-1xte4m0"&&(Ze.innerHTML=jo),P.forEach(s),F.forEach(s),wt=r(e),f(Te.$$.fragment,e),bt=r(e),E=d(e,"DIV",{class:!0});var V=z(E);f(we.$$.fragment,V),Wt=r(V),We=d(V,"P",{"data-svelte-h":!0}),h(We)!=="svelte-1avy50b"&&(We.textContent=Uo),Et=r(V),j=d(V,"DIV",{class:!0});var G=z(j);f(be.$$.fragment,G),Gt=r(G),Ee=d(G,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-a1z96i"&&(Ee.textContent=Ho),Nt=r(G),Ge=d(G,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-1mybtpr"&&(Ge.innerHTML=Jo),Bt=r(G),Ne=d(G,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-1n21hyz"&&(Ne.textContent=Io),G.forEach(s),V.forEach(s),yt=r(e),f(ye.$$.fragment,e),Mt=r(e),v=d(e,"DIV",{class:!0});var I=z(v);f(Me.$$.fragment,I),Lt=r(I),Be=d(I,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-1r3vbx8"&&(Be.textContent=Ro),Pt=r(I),Le=d(I,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-1kjq2n1"&&(Le.innerHTML=qo),Vt=r(I),Pe=d(I,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-1hhw3ap"&&(Pe.innerHTML=Zo),Xt=r(I),Ve=d(I,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-hswkmf"&&(Ve.innerHTML=Wo),Ot=r(I),U=d(I,"DIV",{class:!0});var ee=z(U);f(ve.$$.fragment,ee),At=r(ee),Xe=d(ee,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-1r7j0xd"&&(Xe.innerHTML=Eo),Dt=r(ee),f(O.$$.fragment,ee),Yt=r(ee),f(A.$$.fragment,ee),ee.forEach(s),I.forEach(s),vt=r(e),f(ke.$$.fragment,e),kt=r(e),k=d(e,"DIV",{class:!0});var R=z(k);f(Se.$$.fragment,R),Qt=r(R),Oe=d(R,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-yohvjb"&&(Oe.innerHTML=Go),Kt=r(R),Ae=d(R,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-1kjq2n1"&&(Ae.innerHTML=No),eo=r(R),De=d(R,"P",{"data-svelte-h":!0}),h(De)!=="svelte-1hhw3ap"&&(De.innerHTML=Bo),to=r(R),Ye=d(R,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-hswkmf"&&(Ye.innerHTML=Lo),oo=r(R),H=d(R,"DIV",{class:!0});var te=z(H);f(xe.$$.fragment,te),no=r(te),Qe=d(te,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-196ar4f"&&(Qe.innerHTML=Po),ro=r(te),f(D.$$.fragment,te),so=r(te),f(Y.$$.fragment,te),te.forEach(s),R.forEach(s),St=r(e),f($e.$$.fragment,e),xt=r(e),S=d(e,"DIV",{class:!0});var q=z(S);f(ze.$$.fragment,q),ao=r(q),Ke=d(q,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-1ip3xuw"&&(Ke.textContent=Vo),io=r(q),et=d(q,"P",{"data-svelte-h":!0}),h(et)!=="svelte-1kjq2n1"&&(et.innerHTML=Xo),lo=r(q),tt=d(q,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-1hhw3ap"&&(tt.innerHTML=Oo),co=r(q),ot=d(q,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-hswkmf"&&(ot.innerHTML=Ao),ho=r(q),J=d(q,"DIV",{class:!0});var oe=z(J);f(Ce.$$.fragment,oe),po=r(oe),nt=d(oe,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-ya1z83"&&(nt.innerHTML=Do),mo=r(oe),f(Q.$$.fragment,oe),uo=r(oe),f(K.$$.fragment,oe),oe.forEach(s),q.forEach(s),$t=r(e),f(Fe.$$.fragment,e),zt=r(e),st=d(e,"P",{}),z(st).forEach(s),this.h()},h(){C(a,"name","hf:doc:metadata"),C(a,"content",hn),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){t(document.head,a),l(e,b,o),l(e,p,o),l(e,m,o),_(y,e,o),l(e,c,o),_(M,e,o),l(e,at,o),l(e,ne,o),l(e,it,o),l(e,re,o),l(e,dt,o),l(e,se,o),l(e,lt,o),l(e,ae,o),l(e,ct,o),l(e,ie,o),l(e,ht,o),_(de,e,o),l(e,pt,o),l(e,le,o),l(e,mt,o),_(ce,e,o),l(e,ut,o),l(e,he,o),l(e,ft,o),_(pe,e,o),l(e,_t,o),l(e,W,o),_(me,W,null),t(W,Ft),t(W,Ue),t(W,jt),t(W,He),l(e,gt,o),_(ue,e,o),l(e,Tt,o),l(e,x,o),_(fe,x,null),t(x,Ut),t(x,Je),t(x,Ht),t(x,Ie),t(x,Jt),t(x,X),_(_e,X,null),t(X,It),t(X,Re),t(x,Rt),t(x,N),_(ge,N,null),t(N,qt),t(N,qe),t(N,Zt),t(N,Ze),l(e,wt,o),_(Te,e,o),l(e,bt,o),l(e,E,o),_(we,E,null),t(E,Wt),t(E,We),t(E,Et),t(E,j),_(be,j,null),t(j,Gt),t(j,Ee),t(j,Nt),t(j,Ge),t(j,Bt),t(j,Ne),l(e,yt,o),_(ye,e,o),l(e,Mt,o),l(e,v,o),_(Me,v,null),t(v,Lt),t(v,Be),t(v,Pt),t(v,Le),t(v,Vt),t(v,Pe),t(v,Xt),t(v,Ve),t(v,Ot),t(v,U),_(ve,U,null),t(U,At),t(U,Xe),t(U,Dt),_(O,U,null),t(U,Yt),_(A,U,null),l(e,vt,o),_(ke,e,o),l(e,kt,o),l(e,k,o),_(Se,k,null),t(k,Qt),t(k,Oe),t(k,Kt),t(k,Ae),t(k,eo),t(k,De),t(k,to),t(k,Ye),t(k,oo),t(k,H),_(xe,H,null),t(H,no),t(H,Qe),t(H,ro),_(D,H,null),t(H,so),_(Y,H,null),l(e,St,o),_($e,e,o),l(e,xt,o),l(e,S,o),_(ze,S,null),t(S,ao),t(S,Ke),t(S,io),t(S,et),t(S,lo),t(S,tt),t(S,co),t(S,ot),t(S,ho),t(S,J),_(Ce,J,null),t(J,po),t(J,nt),t(J,mo),_(Q,J,null),t(J,uo),_(K,J,null),l(e,$t,o),_(Fe,e,o),l(e,zt,o),l(e,st,o),Ct=!0},p(e,[o]){const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),O.$set(L);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),A.$set(F);const je={};o&2&&(je.$$scope={dirty:o,ctx:e}),D.$set(je);const P={};o&2&&(P.$$scope={dirty:o,ctx:e}),Y.$set(P);const V={};o&2&&(V.$$scope={dirty:o,ctx:e}),Q.$set(V);const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),K.$set(G)},i(e){Ct||(g(y.$$.fragment,e),g(M.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(_e.$$.fragment,e),g(ge.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(O.$$.fragment,e),g(A.$$.fragment,e),g(ke.$$.fragment,e),g(Se.$$.fragment,e),g(xe.$$.fragment,e),g(D.$$.fragment,e),g(Y.$$.fragment,e),g($e.$$.fragment,e),g(ze.$$.fragment,e),g(Ce.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(Fe.$$.fragment,e),Ct=!0)},o(e){T(y.$$.fragment,e),T(M.$$.fragment,e),T(de.$$.fragment,e),T(ce.$$.fragment,e),T(pe.$$.fragment,e),T(me.$$.fragment,e),T(ue.$$.fragment,e),T(fe.$$.fragment,e),T(_e.$$.fragment,e),T(ge.$$.fragment,e),T(Te.$$.fragment,e),T(we.$$.fragment,e),T(be.$$.fragment,e),T(ye.$$.fragment,e),T(Me.$$.fragment,e),T(ve.$$.fragment,e),T(O.$$.fragment,e),T(A.$$.fragment,e),T(ke.$$.fragment,e),T(Se.$$.fragment,e),T(xe.$$.fragment,e),T(D.$$.fragment,e),T(Y.$$.fragment,e),T($e.$$.fragment,e),T(ze.$$.fragment,e),T(Ce.$$.fragment,e),T(Q.$$.fragment,e),T(K.$$.fragment,e),T(Fe.$$.fragment,e),Ct=!1},d(e){e&&(s(b),s(p),s(m),s(c),s(at),s(ne),s(it),s(re),s(dt),s(se),s(lt),s(ae),s(ct),s(ie),s(ht),s(pt),s(le),s(mt),s(ut),s(he),s(ft),s(_t),s(W),s(gt),s(Tt),s(x),s(wt),s(bt),s(E),s(yt),s(Mt),s(v),s(vt),s(kt),s(k),s(St),s(xt),s(S),s($t),s(zt),s(st)),s(a),w(y,e),w(M,e),w(de,e),w(ce,e),w(pe,e),w(me),w(ue,e),w(fe),w(_e),w(ge),w(Te,e),w(we),w(be),w(ye,e),w(Me),w(ve),w(O),w(A),w(ke,e),w(Se),w(xe),w(D),w(Y),w($e,e),w(ze),w(Ce),w(Q),w(K),w(Fe,e)}}}const hn='{"title":"SwitchTransformers","local":"switchtransformers","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SwitchTransformersConfig","local":"transformers.SwitchTransformersConfig","sections":[],"depth":2},{"title":"SwitchTransformersTop1Router","local":"transformers.SwitchTransformersTop1Router","sections":[],"depth":2},{"title":"SwitchTransformersSparseMLP","local":"transformers.SwitchTransformersSparseMLP","sections":[],"depth":2},{"title":"SwitchTransformersModel","local":"transformers.SwitchTransformersModel","sections":[],"depth":2},{"title":"SwitchTransformersForConditionalGeneration","local":"transformers.SwitchTransformersForConditionalGeneration","sections":[],"depth":2},{"title":"SwitchTransformersEncoderModel","local":"transformers.SwitchTransformersEncoderModel","sections":[],"depth":2}],"depth":1}';function pn($){return Qo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bn extends Ko{constructor(a){super(),en(this,a,pn,cn,Yo,{})}}export{bn as component};
