import{s as Cl,o as ml,n as ul}from"../chunks/scheduler.f6319a2a.js";import{S as hl,i as bl,g as a,s as n,r as p,A as Jl,h as y,f as t,c as M,j as wl,u as U,x as o,k as dl,y as Tl,a as s,v as r,d as j,t as c,w}from"../chunks/index.85aa684c.js";import{T as fl}from"../chunks/Tip.3d397a88.js";import{C}from"../chunks/CodeBlock.3400fc53.js";import{D as gl}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as Ye,E as Al}from"../chunks/index.c8a0819f.js";function Il(Me){let i,u='Inference Providers give access to hundreds of models, powered by serverless inference partners. A list of supported providers can be found <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">here</a>.';return{c(){i=a("p"),i.innerHTML=u},l(d){i=y(d,"P",{"data-svelte-h":!0}),o(i)!=="svelte-k0ft1t"&&(i.innerHTML=u)},m(d,se){s(d,i,se)},p:ul,d(d){d&&t(i)}}}function Bl(Me){let i,u,d,se,h,ae,b,ye,J,Le="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",oe,T,ze="It will be a simple hierarchy:",ie,f,pe,g,Fe="Let’s set up this system.",Ue,A,qe="Run the line below to install the required dependencies:",re,I,je,B,Pe="Let’s login to HF in order to call Inference Providers:",ce,k,we,Z,De='⚡️ Our agent will be powered by <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a> using <code>InferenceClientModel</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',de,m,Ce,G,me,v,ue,W,Ke='For web browsing, we can already use our native <a href="/docs/smolagents/pr_1364/en/reference/tools#smolagents.WebSearchTool">WebSearchTool</a> tool to provide a Google search equivalent.',he,$,Oe=`But then we will also need to be able to peak into the page found by the <code>WebSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,be,S,el="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",Je,V,Te,E,ll="Ok, now let’s initialize and test our tool!",fe,_,ge,Q,Ae,H,tl="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Ie,x,sl="Which configuration to choose for this agent?",Be,R,nl="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>ToolCallingAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_steps</code> to 10.</li>",ke,X,Ze,N,Ml="Note that we gave this agent attributes <code>name</code> and <code>description</code>, mandatory attributes to make this agent callable by its manager agent.",Ge,Y,al="Then we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",ve,L,yl="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>CodeAgent</code> will be the best choice.",We,z,ol="Also, we want to ask a question that involves the current year and does additional data calculations: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;numpy&quot;, &quot;pandas&quot;]</code>, just in case the agent needs these packages.",$e,F,Se,q,il="That’s all! Now let’s run our system! We select a question that requires both some calculation and research:",Ve,P,Ee,D,pl="We get this report as the answer:",_e,K,Qe,O,Ul='Seems like we’ll need some sizeable powerplants if the <a href="https://gwern.net/scaling-hypothesis" rel="nofollow">scaling hypothesis</a> continues to hold true.',He,ee,rl="Our agents managed to efficiently collaborate towards solving the task! ✅",xe,le,jl="💡 You can easily extend this orchestration to more agents: one does the code execution, one the web search, one handles file loadings…",Re,te,Xe,ne,Ne;return h=new Ye({props:{title:"Orchestrate a multi-agent system 🤖🤝🤖",local:"orchestrate-a-multi-agent-system-",headingTag:"h1"}}),b=new gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"}]}}),f=new C({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJCLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyME1hbmFnZXIlMjBhZ2VudCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0lMkIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfX19fX19fX19fX19fX18lN0NfX19fX19fX19fX19fXyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQUNvZGUlMjBJbnRlcnByZXRlciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBXZWIlMjBTZWFyY2glMjBhZ2VudCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQi0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFdlYiUyMFNlYXJjaCUyMHRvb2wlMjAlMjAlMjAlMjAlMjAlN0MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBWaXNpdCUyMHdlYnBhZ2UlMjB0b29s",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
Code Interpreter            +------------------+
    tool                    |<span class="hljs-string"> Web Search agent </span>|
                            +------------------+
                               |<span class="hljs-string">            </span>|
                        Web Search tool     |<span class="hljs-string">
                                   Visit webpage tool</span>`,wrap:!1}}),I=new C({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTVCdG9vbGtpdCU1RCUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install smolagents[toolkit] --upgrade -q",wrap:!1}}),k=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),m=new fl({props:{warning:!1,$$slots:{default:[Il]},$$scope:{ctx:Me}}}),G=new C({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjI=",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>',wrap:!1}}),v=new Ye({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h2"}}),V=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = markdownify(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),_=new C({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),Q=new Ye({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),X=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwV2ViU2VhcmNoVG9vbCUyQyUwQSUyMCUyMCUyMCUyMExpdGVMTE1Nb2RlbCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QldlYlNlYXJjaFRvb2woKSUyQyUyMHZpc2l0X3dlYnBhZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyd2ViX3NlYXJjaF9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyUnVucyUyMHdlYiUyMHNlYXJjaGVzJTIwZm9yJTIweW91LiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    InferenceClientModel,
    WebSearchTool,
    LiteLLMModel,
)

model = InferenceClientModel(model_id=model_id)

web_agent = ToolCallingAgent(
    tools=[WebSearchTool(), visit_webpage],
    model=model,
    max_steps=<span class="hljs-number">10</span>,
    name=<span class="hljs-string">&quot;web_search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you.&quot;</span>,
)`,wrap:!1}}),F=new C({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1QndlYl9hZ2VudCU1RCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIydGltZSUyMiUyQyUyMCUyMm51bXB5JTIyJTJDJTIwJTIycGFuZGFzJTIyJTVEJTJDJTBBKQ==",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;numpy&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>],
)`,wrap:!1}}),P=new C({props:{code:"YW5zd2VyJTIwJTNEJTIwbWFuYWdlcl9hZ2VudC5ydW4oJTIySWYlMjBMTE0lMjB0cmFpbmluZyUyMGNvbnRpbnVlcyUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUyQyUyMHdoYXQlMjB3b3VsZCUyMGJlJTIwdGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMGluJTIwR1clMjByZXF1aXJlZCUyMHRvJTIwcG93ZXIlMjB0aGUlMjBiaWdnZXN0JTIwdHJhaW5pbmclMjBydW5zJTIwYnklMjAyMDMwJTNGJTIwV2hhdCUyMHdvdWxkJTIwdGhhdCUyMGNvcnJlc3BvbmQlMjB0byUyQyUyMGNvbXBhcmVkJTIwdG8lMjBzb21lJTIwY291bnRyaWVzJTNGJTIwUGxlYXNlJTIwcHJvdmlkZSUyMGElMjBzb3VyY2UlMjBmb3IlMjBhbnklMjBudW1iZXJzJTIwdXNlZC4lMjIp",highlighted:'answer = manager_agent.run(<span class="hljs-string">&quot;If LLM training continues to scale up at the current rhythm until 2030, what would be the electric power in GW required to power the biggest training runs by 2030? What would that correspond to, compared to some countries? Please provide a source for any numbers used.&quot;</span>)',wrap:!1}}),K=new C({props:{code:"QmFzZWQlMjBvbiUyMGN1cnJlbnQlMjBncm93dGglMjBwcm9qZWN0aW9ucyUyMGFuZCUyMGVuZXJneSUyMGNvbnN1bXB0aW9uJTIwZXN0aW1hdGVzJTJDJTIwaWYlMjBMTE0lMjB0cmFpbmluZ3MlMjBjb250aW51ZSUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwJTBBY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUzQSUwQSUwQTEuJTIwVGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMHJlcXVpcmVkJTIwdG8lMjBwb3dlciUyMHRoZSUyMGJpZ2dlc3QlMjB0cmFpbmluZyUyMHJ1bnMlMjBieSUyMDIwMzAlMjB3b3VsZCUyMGJlJTIwYXBwcm94aW1hdGVseSUyMDMwMy43NCUyMEdXJTJDJTIwd2hpY2glMjAlMEF0cmFuc2xhdGVzJTIwdG8lMjBhYm91dCUyMDIlMkM2NjAlMkM3NjIlMjBHV2glMkZ5ZWFyLiUwQSUwQTIuJTIwQ29tcGFyaW5nJTIwdGhpcyUyMHRvJTIwY291bnRyaWVzJyUyMGVsZWN0cmljaXR5JTIwY29uc3VtcHRpb24lM0ElMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwZXF1aXZhbGVudCUyMHRvJTIwYWJvdXQlMjAzNCUyNSUyMG9mJTIwQ2hpbmEncyUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbi4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGV4Y2VlZCUyMHRoZSUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwSW5kaWElMjAoMTg0JTI1KSUyQyUyMFJ1c3NpYSUyMCgyNjclMjUpJTJDJTIwYW5kJTIwSmFwYW4lMjAoMjkxJTI1KS4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwbmVhcmx5JTIwOSUyMHRpbWVzJTIwdGhlJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwY291bnRyaWVzJTIwbGlrZSUyMEl0YWx5JTIwb3IlMjBNZXhpY28uJTBBJTBBMy4lMjBTb3VyY2UlMjBvZiUyMG51bWJlcnMlM0ElMEElMjAlMjAlMjAtJTIwVGhlJTIwaW5pdGlhbCUyMGVzdGltYXRlJTIwb2YlMjA1JTIwR1clMjBmb3IlMjBmdXR1cmUlMjBMTE0lMjB0cmFpbmluZyUyMGNvbWVzJTIwZnJvbSUyMEFXUyUyMENFTyUyME1hdHQlMjBHYXJtYW4uJTBBJTIwJTIwJTIwLSUyMFRoZSUyMGdyb3d0aCUyMHByb2plY3Rpb24lMjB1c2VkJTIwYSUyMENBR1IlMjBvZiUyMDc5LjgwJTI1JTIwZnJvbSUyMG1hcmtldCUyMHJlc2VhcmNoJTIwYnklMjBTcHJpbmdzLiUwQSUyMCUyMCUyMC0lMjBDb3VudHJ5JTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMGRhdGElMjBpcyUyMGZyb20lMjB0aGUlMjBVLlMuJTIwRW5lcmd5JTIwSW5mb3JtYXRpb24lMjBBZG1pbmlzdHJhdGlvbiUyQyUyMHByaW1hcmlseSUyMGZvciUyMHRoZSUyMHllYXIlMjAlMEEyMDIxLg==",highlighted:`Based <span class="hljs-keyword">on</span> current growth projections <span class="hljs-keyword">and</span> energy consumption estimates, <span class="hljs-keyword">if</span> LLM trainings <span class="hljs-keyword">continue</span> <span class="hljs-keyword">to</span> scale up <span class="hljs-keyword">at</span> <span class="hljs-keyword">the</span> 
current rhythm <span class="hljs-keyword">until</span> <span class="hljs-number">2030</span>:

<span class="hljs-number">1.</span> The electric power required <span class="hljs-keyword">to</span> power <span class="hljs-keyword">the</span> biggest training runs <span class="hljs-keyword">by</span> <span class="hljs-number">2030</span> would be approximately <span class="hljs-number">303.74</span> GW, which 
translates <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">2</span>,<span class="hljs-number">660</span>,<span class="hljs-number">762</span> GWh/<span class="hljs-built_in">year</span>.

<span class="hljs-number">2.</span> Comparing this <span class="hljs-keyword">to</span> countries&#x27; electricity consumption:
   - It would be equivalent <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">34</span>% <span class="hljs-keyword">of</span> China&#x27;s total electricity consumption.
   - It would exceed <span class="hljs-keyword">the</span> total electricity consumption <span class="hljs-keyword">of</span> India (<span class="hljs-number">184</span>%), Russia (<span class="hljs-number">267</span>%), <span class="hljs-keyword">and</span> Japan (<span class="hljs-number">291</span>%).
   - It would be nearly <span class="hljs-number">9</span> <span class="hljs-keyword">times</span> <span class="hljs-keyword">the</span> electricity consumption <span class="hljs-keyword">of</span> countries like Italy <span class="hljs-keyword">or</span> Mexico.

<span class="hljs-number">3.</span> Source <span class="hljs-keyword">of</span> numbers:
   - The initial estimate <span class="hljs-keyword">of</span> <span class="hljs-number">5</span> GW <span class="hljs-keyword">for</span> future LLM training comes <span class="hljs-keyword">from</span> AWS CEO Matt Garman.
   - The growth projection used a CAGR <span class="hljs-keyword">of</span> <span class="hljs-number">79.80</span>% <span class="hljs-keyword">from</span> market research <span class="hljs-keyword">by</span> Springs.
   - Country electricity consumption data <span class="hljs-keyword">is</span> <span class="hljs-keyword">from</span> <span class="hljs-keyword">the</span> U.S. Energy Information Administration, primarily <span class="hljs-keyword">for</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span> 
<span class="hljs-number">2021.</span>`,wrap:!1}}),te=new Al({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/multiagents.mdx"}}),{c(){i=a("meta"),u=n(),d=a("p"),se=n(),p(h.$$.fragment),ae=n(),p(b.$$.fragment),ye=n(),J=a("p"),J.innerHTML=Le,oe=n(),T=a("p"),T.textContent=ze,ie=n(),p(f.$$.fragment),pe=n(),g=a("p"),g.textContent=Fe,Ue=n(),A=a("p"),A.textContent=qe,re=n(),p(I.$$.fragment),je=n(),B=a("p"),B.textContent=Pe,ce=n(),p(k.$$.fragment),we=n(),Z=a("p"),Z.innerHTML=De,de=n(),p(m.$$.fragment),Ce=n(),p(G.$$.fragment),me=n(),p(v.$$.fragment),ue=n(),W=a("p"),W.innerHTML=Ke,he=n(),$=a("p"),$.innerHTML=Oe,be=n(),S=a("p"),S.innerHTML=el,Je=n(),p(V.$$.fragment),Te=n(),E=a("p"),E.textContent=ll,fe=n(),p(_.$$.fragment),ge=n(),p(Q.$$.fragment),Ae=n(),H=a("p"),H.innerHTML=tl,Ie=n(),x=a("p"),x.textContent=sl,Be=n(),R=a("ul"),R.innerHTML=nl,ke=n(),p(X.$$.fragment),Ze=n(),N=a("p"),N.innerHTML=Ml,Ge=n(),Y=a("p"),Y.innerHTML=al,ve=n(),L=a("p"),L.innerHTML=yl,We=n(),z=a("p"),z.innerHTML=ol,$e=n(),p(F.$$.fragment),Se=n(),q=a("p"),q.textContent=il,Ve=n(),p(P.$$.fragment),Ee=n(),D=a("p"),D.textContent=pl,_e=n(),p(K.$$.fragment),Qe=n(),O=a("p"),O.innerHTML=Ul,He=n(),ee=a("p"),ee.textContent=rl,xe=n(),le=a("p"),le.textContent=jl,Re=n(),p(te.$$.fragment),Xe=n(),ne=a("p"),this.h()},l(e){const l=Jl("svelte-u9bgzb",document.head);i=y(l,"META",{name:!0,content:!0}),l.forEach(t),u=M(e),d=y(e,"P",{}),wl(d).forEach(t),se=M(e),U(h.$$.fragment,e),ae=M(e),U(b.$$.fragment,e),ye=M(e),J=y(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-45abwn"&&(J.innerHTML=Le),oe=M(e),T=y(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1f6nia6"&&(T.textContent=ze),ie=M(e),U(f.$$.fragment,e),pe=M(e),g=y(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1occiln"&&(g.textContent=Fe),Ue=M(e),A=y(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-ofrdjq"&&(A.textContent=qe),re=M(e),U(I.$$.fragment,e),je=M(e),B=y(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-gkovew"&&(B.textContent=Pe),ce=M(e),U(k.$$.fragment,e),we=M(e),Z=y(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-16hajs3"&&(Z.innerHTML=De),de=M(e),U(m.$$.fragment,e),Ce=M(e),U(G.$$.fragment,e),me=M(e),U(v.$$.fragment,e),ue=M(e),W=y(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1xrf5i5"&&(W.innerHTML=Ke),he=M(e),$=y(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-128rf40"&&($.innerHTML=Oe),be=M(e),S=y(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1ms2uj2"&&(S.innerHTML=el),Je=M(e),U(V.$$.fragment,e),Te=M(e),E=y(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-hbvg5t"&&(E.textContent=ll),fe=M(e),U(_.$$.fragment,e),ge=M(e),U(Q.$$.fragment,e),Ae=M(e),H=y(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-5768lo"&&(H.innerHTML=tl),Ie=M(e),x=y(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-noa5rw"&&(x.textContent=sl),Be=M(e),R=y(e,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-cg2xmz"&&(R.innerHTML=nl),ke=M(e),U(X.$$.fragment,e),Ze=M(e),N=y(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-fbxoqx"&&(N.innerHTML=Ml),Ge=M(e),Y=y(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-wtigy3"&&(Y.innerHTML=al),ve=M(e),L=y(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1btrnf1"&&(L.innerHTML=yl),We=M(e),z=y(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1ezr7oa"&&(z.innerHTML=ol),$e=M(e),U(F.$$.fragment,e),Se=M(e),q=y(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-90lagx"&&(q.textContent=il),Ve=M(e),U(P.$$.fragment,e),Ee=M(e),D=y(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-tvhx1x"&&(D.textContent=pl),_e=M(e),U(K.$$.fragment,e),Qe=M(e),O=y(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-19s7crl"&&(O.innerHTML=Ul),He=M(e),ee=y(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-ollz3q"&&(ee.textContent=rl),xe=M(e),le=y(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-rvy62f"&&(le.textContent=jl),Re=M(e),U(te.$$.fragment,e),Xe=M(e),ne=y(e,"P",{}),wl(ne).forEach(t),this.h()},h(){dl(i,"name","hf:doc:metadata"),dl(i,"content",kl)},m(e,l){Tl(document.head,i),s(e,u,l),s(e,d,l),s(e,se,l),r(h,e,l),s(e,ae,l),r(b,e,l),s(e,ye,l),s(e,J,l),s(e,oe,l),s(e,T,l),s(e,ie,l),r(f,e,l),s(e,pe,l),s(e,g,l),s(e,Ue,l),s(e,A,l),s(e,re,l),r(I,e,l),s(e,je,l),s(e,B,l),s(e,ce,l),r(k,e,l),s(e,we,l),s(e,Z,l),s(e,de,l),r(m,e,l),s(e,Ce,l),r(G,e,l),s(e,me,l),r(v,e,l),s(e,ue,l),s(e,W,l),s(e,he,l),s(e,$,l),s(e,be,l),s(e,S,l),s(e,Je,l),r(V,e,l),s(e,Te,l),s(e,E,l),s(e,fe,l),r(_,e,l),s(e,ge,l),r(Q,e,l),s(e,Ae,l),s(e,H,l),s(e,Ie,l),s(e,x,l),s(e,Be,l),s(e,R,l),s(e,ke,l),r(X,e,l),s(e,Ze,l),s(e,N,l),s(e,Ge,l),s(e,Y,l),s(e,ve,l),s(e,L,l),s(e,We,l),s(e,z,l),s(e,$e,l),r(F,e,l),s(e,Se,l),s(e,q,l),s(e,Ve,l),r(P,e,l),s(e,Ee,l),s(e,D,l),s(e,_e,l),r(K,e,l),s(e,Qe,l),s(e,O,l),s(e,He,l),s(e,ee,l),s(e,xe,l),s(e,le,l),s(e,Re,l),r(te,e,l),s(e,Xe,l),s(e,ne,l),Ne=!0},p(e,[l]){const cl={};l&2&&(cl.$$scope={dirty:l,ctx:e}),m.$set(cl)},i(e){Ne||(j(h.$$.fragment,e),j(b.$$.fragment,e),j(f.$$.fragment,e),j(I.$$.fragment,e),j(k.$$.fragment,e),j(m.$$.fragment,e),j(G.$$.fragment,e),j(v.$$.fragment,e),j(V.$$.fragment,e),j(_.$$.fragment,e),j(Q.$$.fragment,e),j(X.$$.fragment,e),j(F.$$.fragment,e),j(P.$$.fragment,e),j(K.$$.fragment,e),j(te.$$.fragment,e),Ne=!0)},o(e){c(h.$$.fragment,e),c(b.$$.fragment,e),c(f.$$.fragment,e),c(I.$$.fragment,e),c(k.$$.fragment,e),c(m.$$.fragment,e),c(G.$$.fragment,e),c(v.$$.fragment,e),c(V.$$.fragment,e),c(_.$$.fragment,e),c(Q.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),Ne=!1},d(e){e&&(t(u),t(d),t(se),t(ae),t(ye),t(J),t(oe),t(T),t(ie),t(pe),t(g),t(Ue),t(A),t(re),t(je),t(B),t(ce),t(we),t(Z),t(de),t(Ce),t(me),t(ue),t(W),t(he),t($),t(be),t(S),t(Je),t(Te),t(E),t(fe),t(ge),t(Ae),t(H),t(Ie),t(x),t(Be),t(R),t(ke),t(Ze),t(N),t(Ge),t(Y),t(ve),t(L),t(We),t(z),t($e),t(Se),t(q),t(Ve),t(Ee),t(D),t(_e),t(Qe),t(O),t(He),t(ee),t(xe),t(le),t(Re),t(Xe),t(ne)),t(i),w(h,e),w(b,e),w(f,e),w(I,e),w(k,e),w(m,e),w(G,e),w(v,e),w(V,e),w(_,e),w(Q,e),w(X,e),w(F,e),w(P,e),w(K,e),w(te,e)}}}const kl='{"title":"Orchestrate a multi-agent system 🤖🤝🤖","local":"orchestrate-a-multi-agent-system-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":2},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function Zl(Me){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends hl{constructor(i){super(),bl(this,i,Zl,Bl,Cl,{})}}export{El as component};
